---
stage: Secure
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# SQL Injection

## Description

It is possible to execute arbitrary SQL commands on the target application server's
backend database.
SQL Injection is a critical vulnerability that can lead to a data or system
compromise.

## Remediation

Always use parameterized queries when issuing requests to backend database systems. In
situations where dynamic queries must be created, never use direct user input, but
instead use a map or dictionary of valid values and resolve them using a user-supplied key.

For example, some database drivers do not allow parameterized queries for `>` or `<` comparison
operators. In these cases, do not use a user supplied `>` or `<` value, but rather have the user
supply a `gt` or `lt` value. The alphabetical values are then used to look up the `>` and `<`
values to be used in the construction of the dynamic query. The same goes for other queries where
column or table names are required but can not be parameterized.

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:--------|:--------|:--------|:--------|
| 89.1 | false | 89 | Active | high |

## Links

- [OWASP](https://owasp.org/www-community/attacks/SQL_Injection)
- [CWE](https://cwe.mitre.org/data/definitions/89.html)
