// Demonstrates usage of the Gauss-Hermite nodes and weights
// generated by our program GaussHermite_NodesWeights.cpp.
//
// Joachim Wuttke, 2023, public domain

#include "GaussHermiteConstants.cpp"
#include <cmath>
#include <iostream>
#include <iomanip>

// With f(x)=cos(x), analytical integration yields exp(-1/4).
// See https://www.chebfun.org/examples/quad/HermiteQuad.html, with different normalization.
double f(double x)
{
    return cos(x);
}

int main(int argc, char* argv[])
{
    std::cout << std::setprecision(15);
    for (int n=0; n<12; ++n) {

        double sum = 0;
        for (int i = 0; i<n; ++i) {
            int k = n * (n-1) + 2*i;
            sum += GaussHermiteNodesWeights[k+1] * f(GaussHermiteNodesWeights[k]);
        }
        std::cout << sum << "\n";
    }
}
