#!/bin/sh

. "`dirname \"$0\"`/common.sh"

USER="mailto:vincent.vole@example.com"
SENDER="mailto:paul.boddie@example.com"

mkdir -p "$PREFS/$USER"
echo 'Europe/Oslo' > "$PREFS/$USER/TZID"
echo 'share' > "$PREFS/$USER/freebusy_sharing"
echo 'add' > "$PREFS/$USER/add_method_response"

mkdir -p "$PREFS/$SENDER"
echo 'Europe/Oslo' > "$PREFS/$USER/TZID"
echo 'always' > "$PREFS/$SENDER/event_refreshing"

# Publish an event, testing registration in the outgoing handler.

"$OUTGOING_SCRIPT" $ARGS < "$TEMPLATES/event-request-person-recurring.txt" 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "freebusy" \
>  out1f.tmp

   grep -q "^20141212T090000Z${TAB}20141212T100000Z" "out1f.tmp" \
&& echo "Success" \
|| echo "Failed"

# Test a request from an attendee for the event details to be refreshed.

  "$PERSON_SCRIPT" $ARGS < "$TEMPLATES/event-refresh-person-recurring.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out2.tmp

   grep -q 'METHOD:REQUEST' out2.tmp \
&& echo "Success" \
|| echo "Failed"

# Present the result to the recipient.

  "$PERSON_SCRIPT" $ARGS < out2.tmp 2>> $ERROR \
| "$SHOWMAIL" \
> out3.tmp

   ! grep -q 'METHOD:REPLY' out3.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out3f.tmp

   ! grep -q "^20141212T090000Z${TAB}20141212T100000Z" "out3f.tmp" \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy_other" "$SENDER" \
>  out3f.tmp

   grep -q "^20141212T090000Z${TAB}20141212T100000Z" "out3f.tmp" \
&& echo "Success" \
|| echo "Failed"

# Test acceptance and registration in the outgoing handler.

  "$ACCEPT_SCRIPT" $ACCEPT_ARGS "$USER" "event8@example.com" 2>> $ERROR \
| tee out4.tmp \
| "$OUTGOING_SCRIPT" $ARGS 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out4f.tmp

   grep -q "^20141212T090000Z${TAB}20141212T100000Z" "out4f.tmp" \
&& echo "Success" \
|| echo "Failed"

# Test a request from a non-attendee for the event details to be refreshed.

  "$PERSON_SCRIPT" $ARGS < "$TEMPLATES/event-refresh-person-recurring-non-attendee.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out5.tmp

   ! grep -q 'METHOD:REQUEST' out5.tmp \
&& echo "Success" \
|| echo "Failed"

# Test rescheduling in the outgoing handler.

"$OUTGOING_SCRIPT" $ARGS < "$TEMPLATES/event-request-person-recurring-reschedule-instance.txt" 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "freebusy" \
>  out5f.tmp

   grep -q "^20141011T080000Z${TAB}20141011T090000Z" "out5f.tmp" \
&& ! grep -q "^20141010T080000Z${TAB}20141010T090000Z" "out5f.tmp" \
&& echo "Success" \
|| echo "Failed"

# Test another request from an attendee for the event details to be refreshed.

  "$PERSON_SCRIPT" $ARGS < "$TEMPLATES/event-refresh-person-recurring.txt" 2>> $ERROR \
| tee out6r.tmp \
| "$SHOWMAIL" \
> out6.tmp

   grep -q 'METHOD:REQUEST' out6.tmp \
&& grep -q 'RECURRENCE-ID' out6.tmp \
&& [ `grep 'BEGIN:VEVENT' out6.tmp | wc -l` = '2' ] \
&& echo "Success" \
|| echo "Failed"

# Process the resulting message.

  "$PERSON_SCRIPT" $ARGS < out6r.tmp 2>> $ERROR \
| "$SHOWMAIL" \
> out6a.tmp

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "object" "event8@example.com" \
>  out6O.tmp

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "recurrence" "event8@example.com" "20141010T080000Z" \
>  out6R.tmp

   grep -q 'event8@example.com' "out6O.tmp" \
&& grep -q 'event8@example.com' "out6R.tmp" \
&& echo "Success" \
|| echo "Failed"

# Cancel a recurrence. Both the original and rescheduled recurrences should be
# absent from the free/busy collection.

"$OUTGOING_SCRIPT" $ARGS < "$TEMPLATES/event-cancel-person-recurring-rescheduled-instance.txt" 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "object" "event8@example.com" \
>  out6O2.tmp

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "recurrence" "event8@example.com" "20141010T080000Z" \
>  out6R2.tmp

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "cancelled_recurrences" "event8@example.com" \
>  out6C.tmp

   grep -q 'event8@example.com' "out6O2.tmp" \
&& ! grep -q 'event8@example.com' "out6R2.tmp" \
&& grep -q '20141010T080000Z' "out6C.tmp" \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "freebusy" \
>  out6f.tmp

   ! grep -q "^20141010T080000Z${TAB}20141010T090000Z" "out6f.tmp" \
&& ! grep -q "^20141011T080000Z${TAB}20141011T090000Z" "out6f.tmp" \
&& echo "Success" \
|| echo "Failed"

# Test another request from an attendee for the event details to be refreshed.
# The additional recurrence should now be absent.

  "$PERSON_SCRIPT" $ARGS < "$TEMPLATES/event-refresh-person-recurring.txt" 2>> $ERROR \
| tee out7r.tmp \
| "$SHOWMAIL" \
> out7.tmp

   grep -q 'METHOD:REQUEST' out7.tmp \
&& grep -q 'METHOD:CANCEL' out7.tmp \
&& [ `grep 'BEGIN:VEVENT' out7.tmp | wc -l` = '2' ] \
&& echo "Success" \
|| echo "Failed"

# Process the resulting message.

  "$PERSON_SCRIPT" $ARGS < out7r.tmp 2>> $ERROR \
| "$SHOWMAIL" \
> out7a.tmp

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "object" "event8@example.com" \
>  out7O.tmp

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "recurrence" "event8@example.com" "20141010T080000Z" \
>  out7R.tmp

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "cancelled_recurrences" "event8@example.com" \
>  out7C.tmp

   grep -q 'event8@example.com' "out7O.tmp" \
&& ! grep -q 'event8@example.com' "out7R.tmp" \
&& grep -q '20141010T080000Z' "out7C.tmp" \
&& echo "Success" \
|| echo "Failed"

# Re-add the cancelled instance.

"$OUTGOING_SCRIPT" $ARGS < "$TEMPLATES/event-add-person-recurring-rescheduled-instance.txt" 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "freebusy" \
>  out7f.tmp

   grep -q "^20141010T080000Z${TAB}20141010T090000Z" "out7f.tmp" \
&& ! grep -q "^20141011T080000Z${TAB}20141011T090000Z" "out7f.tmp" \
&& echo "Success" \
|| echo "Failed"

  "$PERSON_SCRIPT" $ARGS < "$TEMPLATES/event-add-person-recurring-rescheduled-instance.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out8.tmp

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "object" "event8@example.com" \
>  out8O.tmp

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "recurrence" "event8@example.com" "20141010T080000Z" \
>  out8R.tmp

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "cancelled_recurrences" "event8@example.com" \
>  out8C.tmp

   grep -q 'event8@example.com' "out8O.tmp" \
&& grep -q 'event8@example.com' "out8R.tmp" \
&& ! grep -q '20141010T080000Z' "out8C.tmp" \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out8f.tmp

   ! grep -q "^20141010T080000Z${TAB}20141010T090000Z" "out8f.tmp" \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy_other" "$SENDER" \
>  out8f.tmp

   grep -q "^20141010T080000Z${TAB}20141010T090000Z" "out8f.tmp" \
&& echo "Success" \
|| echo "Failed"

# Test acceptance and registration in the outgoing handler.

  "$ACCEPT_SCRIPT" $ACCEPT_ARGS "$USER" "event8@example.com" "20141010T080000Z" 2>> $ERROR \
| tee out9.tmp \
| "$OUTGOING_SCRIPT" $ARGS 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out9f.tmp

   grep -q "^20141010T080000Z${TAB}20141010T090000Z" "out9f.tmp" \
&& echo "Success" \
|| echo "Failed"

# Test yet another request from an attendee for the event details to be refreshed.

  "$PERSON_SCRIPT" $ARGS < "$TEMPLATES/event-refresh-person-recurring.txt" 2>> $ERROR \
| tee out10r.tmp \
| "$SHOWMAIL" \
> out10.tmp

   grep -q 'METHOD:REQUEST' out10.tmp \
&& grep -q 'RECURRENCE-ID' out10.tmp \
&& [ `grep 'BEGIN:VEVENT' out10.tmp | wc -l` = '2' ] \
&& echo "Success" \
|| echo "Failed"

# Process the resulting message.

  "$PERSON_SCRIPT" $ARGS < out10r.tmp 2>> $ERROR \
| "$SHOWMAIL" \
> out11.tmp

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "object" "event8@example.com" \
>  out11O.tmp

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "recurrence" "event8@example.com" "20141010T080000Z" \
>  out11R.tmp

   grep -q 'event8@example.com' "out11O.tmp" \
&& grep -q 'event8@example.com' "out11R.tmp" \
&& echo "Success" \
|| echo "Failed"
