// created by jay 0.7 (c) 1998 Axel.Schreiner@informatik.uni-osnabrueck.de

#line 2 "cs-parser.jay"
//
// cs-parser.jay: The Parser for the C# compiler
//
// Authors: Miguel de Icaza (miguel@gnome.org)
//          Ravi Pratap     (ravi@ximian.com)
//          Marek Safar	    (marek.safar@gmail.com)
//
// Dual Licensed under the terms of the GNU GPL and the MIT X11 license
//
// (C) 2001 Ximian, Inc (http://www.ximian.com)
// (C) 2004-2011 Novell, Inc
// Copyright 2011-2012 Xamarin Inc.
//

using System.Text;
using System.IO;
using System;
using System.Collections.Generic;

namespace Mono.CSharp
{
	/// <summary>
	///    The C# Parser
	/// </summary>
	public class CSharpParser
	{
		[Flags]
		enum ParameterModifierType
		{
			Ref		= 1 << 1,
			Out		= 1 << 2,
			This	= 1 << 3,
			Params	= 1 << 4,
			Arglist	= 1 << 5,
			DefaultValue = 1 << 6,
			
			All = Ref | Out | This | Params | Arglist | DefaultValue,
			PrimaryConstructor = Ref | Out | Params | DefaultValue
		}
		
		static readonly object ModifierNone = 0;
	
		NamespaceContainer current_namespace;
		TypeContainer current_container;
		TypeDefinition current_type;
		PropertyBase current_property;
		EventProperty current_event;
		EventField current_event_field;
		FieldBase current_field;
	
		/// <summary>
		///   Current block is used to add statements as we find
		///   them.  
		/// </summary>
		Block      current_block;
		
		BlockVariable current_variable;

		Delegate   current_delegate;
		
		AnonymousMethodExpression current_anonymous_method;

		/// <summary>
		///   This is used by the unary_expression code to resolve
		///   a name against a parameter.  
		/// </summary>
		
		// FIXME: This is very ugly and it's very hard to reset it correctly
		// on all places, especially when some parameters are autogenerated.
		ParametersCompiled current_local_parameters;

		bool parsing_anonymous_method;
		
		bool async_block;

		///
		/// An out-of-band stack.
		///
		Stack<object> oob_stack;

		///
		/// Controls the verbosity of the errors produced by the parser
		///
		int yacc_verbose_flag;

		/// 
		/// Used by the interactive shell, flags whether EOF was reached
		/// and an error was produced
		///
		public bool UnexpectedEOF;

		///
		/// The current file.
		///
		readonly CompilationSourceFile file;

		///
		/// Temporary Xml documentation cache.
		/// For enum types, we need one more temporary store.
		///
		string tmpComment;
		string enumTypeComment;
	       		
		/// Current attribute target
		string current_attr_target;
		
		ParameterModifierType valid_param_mod;
		
		bool default_parameter_used;

		/// When using the interactive parser, this holds the
		/// resulting expression
		public Class InteractiveResult;

		//
		// Keeps track of global data changes to undo on parser error
		//
		public Undo undo;

		bool? interactive_async;
		
		Stack<Linq.QueryBlock> linq_clause_blocks;

		ModuleContainer module;
		
		readonly CompilerContext compiler;
		readonly LanguageVersion lang_version;
		readonly bool doc_support;
		readonly CompilerSettings settings;
		readonly Report report;
		
		//
		// Instead of allocating carrier array everytime we
		// share the bucket for very common constructs which can never
		// be recursive
		//
		List<Parameter> parameters_bucket;
		
		//
		// Full AST support members
		//
		LocationsBag lbag;
		List<Tuple<Modifiers, Location>> mod_locations;
		Location parameterModifierLocation, savedLocation, savedEventAssignLocation;
		Location savedAttrParenOpenLocation, savedAttrParenCloseLocation, savedOperatorLocation;
		Stack<List<Location>> locationListStack = new Stack<List<Location>> (); // used for type parameters
		Stack<Location> opt_intoStack = new Stack<Location> ();

		bool HadAttributeParens;
		List<Location> attributeArgumentCommas = new List<Location> ();
		List<Location> parameterListCommas = new List<Location> ();
		Stack<Location> location_stack;
#line default

  /** error output stream.
      It should be changeable.
    */
  public System.IO.TextWriter ErrorOutput = System.Console.Out;

  /** simplified error message.
      @see <a href="#yyerror(java.lang.String, java.lang.String[])">yyerror</a>
    */
  public void yyerror (string message) {
    yyerror(message, null);
  }
#pragma warning disable 649
  /* An EOF token */
  public int eof_token;
#pragma warning restore 649
  /** (syntax) error message.
      Can be overwritten to control message format.
      @param message text to be displayed.
      @param expected vector of acceptable tokens, if available.
    */
  public void yyerror (string message, string[] expected) {
    if ((yacc_verbose_flag > 0) && (expected != null) && (expected.Length  > 0)) {
      ErrorOutput.Write (message+", expecting");
      for (int n = 0; n < expected.Length; ++ n)
        ErrorOutput.Write (" "+expected[n]);
        ErrorOutput.WriteLine ();
    } else
      ErrorOutput.WriteLine (message);
  }

  /** debugging support, requires the package jay.yydebug.
      Set to null to suppress debugging messages.
    */
//t  internal yydebug.yyDebug debug;

  protected const int yyFinal = 7;
//t // Put this array into a separate class so it is only initialized if debugging is actually used
//t // Use MarshalByRefObject to disable inlining
//t class YYRules : MarshalByRefObject {
//t  public static readonly string [] yyRule = {
//t    "$accept : compilation_unit",
//t    "compilation_unit : outer_declaration opt_EOF",
//t    "$$1 :",
//t    "compilation_unit : interactive_parsing $$1 opt_EOF",
//t    "compilation_unit : documentation_parsing",
//t    "outer_declaration : opt_extern_alias_directives opt_using_directives",
//t    "outer_declaration : opt_extern_alias_directives opt_using_directives namespace_or_type_declarations opt_attributes",
//t    "outer_declaration : opt_extern_alias_directives opt_using_directives attribute_sections",
//t    "outer_declaration : error",
//t    "opt_EOF :",
//t    "opt_EOF : EOF",
//t    "extern_alias_directives : extern_alias_directive",
//t    "extern_alias_directives : extern_alias_directives extern_alias_directive",
//t    "extern_alias_directive : EXTERN_ALIAS IDENTIFIER IDENTIFIER SEMICOLON",
//t    "extern_alias_directive : EXTERN_ALIAS error",
//t    "using_directives : using_directive",
//t    "using_directives : using_directives using_directive",
//t    "using_directive : using_namespace",
//t    "using_namespace : USING namespace_or_type_expr SEMICOLON",
//t    "using_namespace : USING IDENTIFIER ASSIGN namespace_or_type_expr SEMICOLON",
//t    "using_namespace : USING error",
//t    "$$2 :",
//t    "$$3 :",
//t    "namespace_declaration : opt_attributes NAMESPACE namespace_name $$2 OPEN_BRACE $$3 opt_extern_alias_directives opt_using_directives opt_namespace_or_type_declarations CLOSE_BRACE opt_semicolon_error",
//t    "namespace_declaration : opt_attributes NAMESPACE namespace_name",
//t    "opt_semicolon_error :",
//t    "opt_semicolon_error : SEMICOLON",
//t    "opt_semicolon_error : error",
//t    "namespace_name : IDENTIFIER",
//t    "namespace_name : namespace_name DOT IDENTIFIER",
//t    "namespace_name : error",
//t    "opt_semicolon :",
//t    "opt_semicolon : SEMICOLON",
//t    "opt_comma :",
//t    "opt_comma : COMMA",
//t    "opt_using_directives :",
//t    "opt_using_directives : using_directives",
//t    "opt_extern_alias_directives :",
//t    "opt_extern_alias_directives : extern_alias_directives",
//t    "opt_namespace_or_type_declarations :",
//t    "opt_namespace_or_type_declarations : namespace_or_type_declarations",
//t    "namespace_or_type_declarations : namespace_or_type_declaration",
//t    "namespace_or_type_declarations : namespace_or_type_declarations namespace_or_type_declaration",
//t    "namespace_or_type_declaration : type_declaration",
//t    "namespace_or_type_declaration : namespace_declaration",
//t    "namespace_or_type_declaration : attribute_sections CLOSE_BRACE",
//t    "type_declaration : class_declaration",
//t    "type_declaration : struct_declaration",
//t    "type_declaration : interface_declaration",
//t    "type_declaration : enum_declaration",
//t    "type_declaration : delegate_declaration",
//t    "opt_attributes :",
//t    "opt_attributes : attribute_sections",
//t    "attribute_sections : attribute_section",
//t    "attribute_sections : attribute_sections attribute_section",
//t    "$$4 :",
//t    "attribute_section : OPEN_BRACKET $$4 attribute_section_cont",
//t    "$$5 :",
//t    "attribute_section_cont : attribute_target COLON $$5 attribute_list opt_comma CLOSE_BRACKET",
//t    "attribute_section_cont : attribute_list opt_comma CLOSE_BRACKET",
//t    "attribute_section_cont : IDENTIFIER error",
//t    "attribute_section_cont : error",
//t    "attribute_target : IDENTIFIER",
//t    "attribute_target : EVENT",
//t    "attribute_target : RETURN",
//t    "attribute_list : attribute",
//t    "attribute_list : attribute_list COMMA attribute",
//t    "$$6 :",
//t    "attribute : attribute_name $$6 opt_attribute_arguments",
//t    "attribute_name : namespace_or_type_expr",
//t    "opt_attribute_arguments :",
//t    "opt_attribute_arguments : OPEN_PARENS attribute_arguments CLOSE_PARENS",
//t    "attribute_arguments :",
//t    "attribute_arguments : positional_or_named_argument",
//t    "attribute_arguments : named_attribute_argument",
//t    "attribute_arguments : attribute_arguments COMMA positional_or_named_argument",
//t    "attribute_arguments : attribute_arguments COMMA named_attribute_argument",
//t    "positional_or_named_argument : expression",
//t    "positional_or_named_argument : named_argument",
//t    "positional_or_named_argument : error",
//t    "$$7 :",
//t    "named_attribute_argument : IDENTIFIER ASSIGN $$7 expression",
//t    "named_argument : identifier_inside_body COLON opt_named_modifier expression_or_error",
//t    "opt_named_modifier :",
//t    "opt_named_modifier : REF",
//t    "opt_named_modifier : OUT",
//t    "opt_class_member_declarations :",
//t    "opt_class_member_declarations : class_member_declarations",
//t    "class_member_declarations : class_member_declaration",
//t    "class_member_declarations : class_member_declarations class_member_declaration",
//t    "class_member_declaration : constant_declaration",
//t    "class_member_declaration : field_declaration",
//t    "class_member_declaration : method_declaration",
//t    "class_member_declaration : property_declaration",
//t    "class_member_declaration : event_declaration",
//t    "class_member_declaration : indexer_declaration",
//t    "class_member_declaration : operator_declaration",
//t    "class_member_declaration : constructor_declaration",
//t    "class_member_declaration : primary_constructor_body",
//t    "class_member_declaration : destructor_declaration",
//t    "class_member_declaration : type_declaration",
//t    "class_member_declaration : attributes_without_members",
//t    "class_member_declaration : incomplete_member",
//t    "class_member_declaration : error",
//t    "$$8 :",
//t    "primary_constructor_body : OPEN_BRACE $$8 opt_statement_list block_end",
//t    "$$9 :",
//t    "$$10 :",
//t    "$$11 :",
//t    "$$12 :",
//t    "$$13 :",
//t    "struct_declaration : opt_attributes opt_modifiers opt_partial STRUCT $$9 type_declaration_name $$10 opt_primary_parameters opt_class_base opt_type_parameter_constraints_clauses $$11 OPEN_BRACE $$12 opt_class_member_declarations CLOSE_BRACE $$13 opt_semicolon",
//t    "struct_declaration : opt_attributes opt_modifiers opt_partial STRUCT error",
//t    "$$14 :",
//t    "constant_declaration : opt_attributes opt_modifiers CONST type IDENTIFIER $$14 constant_initializer opt_constant_declarators SEMICOLON",
//t    "constant_declaration : opt_attributes opt_modifiers CONST type error",
//t    "opt_constant_declarators :",
//t    "opt_constant_declarators : constant_declarators",
//t    "constant_declarators : constant_declarator",
//t    "constant_declarators : constant_declarators constant_declarator",
//t    "constant_declarator : COMMA IDENTIFIER constant_initializer",
//t    "$$15 :",
//t    "constant_initializer : ASSIGN $$15 constant_initializer_expr",
//t    "constant_initializer : error",
//t    "constant_initializer_expr : constant_expression",
//t    "constant_initializer_expr : array_initializer",
//t    "$$16 :",
//t    "field_declaration : opt_attributes opt_modifiers member_type IDENTIFIER $$16 opt_field_initializer opt_field_declarators SEMICOLON",
//t    "$$17 :",
//t    "field_declaration : opt_attributes opt_modifiers FIXED simple_type IDENTIFIER $$17 fixed_field_size opt_fixed_field_declarators SEMICOLON",
//t    "field_declaration : opt_attributes opt_modifiers FIXED simple_type error SEMICOLON",
//t    "opt_field_initializer :",
//t    "$$18 :",
//t    "opt_field_initializer : ASSIGN $$18 variable_initializer",
//t    "opt_field_declarators :",
//t    "opt_field_declarators : field_declarators",
//t    "field_declarators : field_declarator",
//t    "field_declarators : field_declarators field_declarator",
//t    "field_declarator : COMMA IDENTIFIER",
//t    "$$19 :",
//t    "field_declarator : COMMA IDENTIFIER ASSIGN $$19 variable_initializer",
//t    "opt_fixed_field_declarators :",
//t    "opt_fixed_field_declarators : fixed_field_declarators",
//t    "fixed_field_declarators : fixed_field_declarator",
//t    "fixed_field_declarators : fixed_field_declarators fixed_field_declarator",
//t    "fixed_field_declarator : COMMA IDENTIFIER fixed_field_size",
//t    "$$20 :",
//t    "fixed_field_size : OPEN_BRACKET $$20 expression CLOSE_BRACKET",
//t    "fixed_field_size : OPEN_BRACKET error",
//t    "variable_initializer : expression",
//t    "variable_initializer : array_initializer",
//t    "variable_initializer : error",
//t    "$$21 :",
//t    "method_declaration : method_header $$21 method_body_expression_block",
//t    "$$22 :",
//t    "$$23 :",
//t    "method_header : opt_attributes opt_modifiers member_type method_declaration_name OPEN_PARENS $$22 opt_formal_parameter_list CLOSE_PARENS $$23 opt_type_parameter_constraints_clauses",
//t    "$$24 :",
//t    "$$25 :",
//t    "$$26 :",
//t    "method_header : opt_attributes opt_modifiers PARTIAL VOID $$24 method_declaration_name OPEN_PARENS $$25 opt_formal_parameter_list CLOSE_PARENS $$26 opt_type_parameter_constraints_clauses",
//t    "method_header : opt_attributes opt_modifiers member_type modifiers method_declaration_name OPEN_PARENS opt_formal_parameter_list CLOSE_PARENS",
//t    "method_header : opt_attributes opt_modifiers member_type method_declaration_name error",
//t    "method_body_expression_block : method_body",
//t    "method_body_expression_block : expression_block",
//t    "method_body : block",
//t    "method_body : SEMICOLON",
//t    "$$27 :",
//t    "expression_block : ARROW $$27 expression SEMICOLON",
//t    "opt_formal_parameter_list :",
//t    "opt_formal_parameter_list : formal_parameter_list",
//t    "formal_parameter_list : fixed_parameters",
//t    "formal_parameter_list : fixed_parameters COMMA parameter_array",
//t    "formal_parameter_list : fixed_parameters COMMA arglist_modifier",
//t    "formal_parameter_list : parameter_array COMMA error",
//t    "formal_parameter_list : fixed_parameters COMMA parameter_array COMMA error",
//t    "formal_parameter_list : arglist_modifier COMMA error",
//t    "formal_parameter_list : fixed_parameters COMMA ARGLIST COMMA error",
//t    "formal_parameter_list : parameter_array",
//t    "formal_parameter_list : arglist_modifier",
//t    "formal_parameter_list : error",
//t    "fixed_parameters : fixed_parameter",
//t    "fixed_parameters : fixed_parameters COMMA fixed_parameter",
//t    "fixed_parameter : opt_attributes opt_parameter_modifier parameter_type identifier_inside_body",
//t    "fixed_parameter : opt_attributes opt_parameter_modifier parameter_type identifier_inside_body OPEN_BRACKET CLOSE_BRACKET",
//t    "fixed_parameter : attribute_sections error",
//t    "fixed_parameter : opt_attributes opt_parameter_modifier parameter_type error",
//t    "$$28 :",
//t    "fixed_parameter : opt_attributes opt_parameter_modifier parameter_type identifier_inside_body ASSIGN $$28 constant_expression",
//t    "opt_parameter_modifier :",
//t    "opt_parameter_modifier : parameter_modifiers",
//t    "parameter_modifiers : parameter_modifier",
//t    "parameter_modifiers : parameter_modifiers parameter_modifier",
//t    "parameter_modifier : REF",
//t    "parameter_modifier : OUT",
//t    "parameter_modifier : THIS",
//t    "parameter_array : opt_attributes params_modifier type IDENTIFIER",
//t    "parameter_array : opt_attributes params_modifier type IDENTIFIER ASSIGN constant_expression",
//t    "parameter_array : opt_attributes params_modifier type error",
//t    "params_modifier : PARAMS",
//t    "params_modifier : PARAMS parameter_modifier",
//t    "params_modifier : PARAMS params_modifier",
//t    "arglist_modifier : ARGLIST",
//t    "$$29 :",
//t    "$$30 :",
//t    "$$31 :",
//t    "$$32 :",
//t    "property_declaration : opt_attributes opt_modifiers member_type member_declaration_name $$29 OPEN_BRACE $$30 accessor_declarations $$31 CLOSE_BRACE $$32 opt_property_initializer",
//t    "$$33 :",
//t    "property_declaration : opt_attributes opt_modifiers member_type member_declaration_name $$33 expression_block",
//t    "opt_property_initializer :",
//t    "$$34 :",
//t    "opt_property_initializer : ASSIGN $$34 property_initializer SEMICOLON",
//t    "property_initializer : expression",
//t    "property_initializer : array_initializer",
//t    "$$35 :",
//t    "$$36 :",
//t    "indexer_declaration : opt_attributes opt_modifiers member_type indexer_declaration_name OPEN_BRACKET $$35 opt_formal_parameter_list CLOSE_BRACKET $$36 indexer_body",
//t    "indexer_body : OPEN_BRACE accessor_declarations CLOSE_BRACE",
//t    "indexer_body : expression_block",
//t    "accessor_declarations : get_accessor_declaration",
//t    "accessor_declarations : get_accessor_declaration accessor_declarations",
//t    "accessor_declarations : set_accessor_declaration",
//t    "accessor_declarations : set_accessor_declaration accessor_declarations",
//t    "accessor_declarations : error",
//t    "$$37 :",
//t    "get_accessor_declaration : opt_attributes opt_modifiers GET $$37 accessor_body",
//t    "$$38 :",
//t    "set_accessor_declaration : opt_attributes opt_modifiers SET $$38 accessor_body",
//t    "accessor_body : block",
//t    "accessor_body : SEMICOLON",
//t    "accessor_body : error",
//t    "$$39 :",
//t    "$$40 :",
//t    "$$41 :",
//t    "$$42 :",
//t    "interface_declaration : opt_attributes opt_modifiers opt_partial INTERFACE $$39 type_declaration_name $$40 opt_class_base opt_type_parameter_constraints_clauses $$41 OPEN_BRACE opt_interface_member_declarations CLOSE_BRACE $$42 opt_semicolon",
//t    "interface_declaration : opt_attributes opt_modifiers opt_partial INTERFACE error",
//t    "opt_interface_member_declarations :",
//t    "opt_interface_member_declarations : interface_member_declarations",
//t    "interface_member_declarations : interface_member_declaration",
//t    "interface_member_declarations : interface_member_declarations interface_member_declaration",
//t    "interface_member_declaration : constant_declaration",
//t    "interface_member_declaration : field_declaration",
//t    "interface_member_declaration : method_declaration",
//t    "interface_member_declaration : property_declaration",
//t    "interface_member_declaration : event_declaration",
//t    "interface_member_declaration : indexer_declaration",
//t    "interface_member_declaration : operator_declaration",
//t    "interface_member_declaration : constructor_declaration",
//t    "interface_member_declaration : type_declaration",
//t    "$$43 :",
//t    "operator_declaration : opt_attributes opt_modifiers operator_declarator $$43 method_body_expression_block",
//t    "operator_type : type_expression_or_array",
//t    "operator_type : VOID",
//t    "$$44 :",
//t    "operator_declarator : operator_type OPERATOR overloadable_operator OPEN_PARENS $$44 opt_formal_parameter_list CLOSE_PARENS",
//t    "operator_declarator : conversion_operator_declarator",
//t    "overloadable_operator : BANG",
//t    "overloadable_operator : TILDE",
//t    "overloadable_operator : OP_INC",
//t    "overloadable_operator : OP_DEC",
//t    "overloadable_operator : TRUE",
//t    "overloadable_operator : FALSE",
//t    "overloadable_operator : PLUS",
//t    "overloadable_operator : MINUS",
//t    "overloadable_operator : STAR",
//t    "overloadable_operator : DIV",
//t    "overloadable_operator : PERCENT",
//t    "overloadable_operator : BITWISE_AND",
//t    "overloadable_operator : BITWISE_OR",
//t    "overloadable_operator : CARRET",
//t    "overloadable_operator : OP_SHIFT_LEFT",
//t    "overloadable_operator : OP_SHIFT_RIGHT",
//t    "overloadable_operator : OP_EQ",
//t    "overloadable_operator : OP_NE",
//t    "overloadable_operator : OP_GT",
//t    "overloadable_operator : OP_LT",
//t    "overloadable_operator : OP_GE",
//t    "overloadable_operator : OP_LE",
//t    "$$45 :",
//t    "conversion_operator_declarator : IMPLICIT OPERATOR type OPEN_PARENS $$45 opt_formal_parameter_list CLOSE_PARENS",
//t    "$$46 :",
//t    "conversion_operator_declarator : EXPLICIT OPERATOR type OPEN_PARENS $$46 opt_formal_parameter_list CLOSE_PARENS",
//t    "conversion_operator_declarator : IMPLICIT error",
//t    "conversion_operator_declarator : EXPLICIT error",
//t    "constructor_declaration : constructor_declarator constructor_body",
//t    "$$47 :",
//t    "$$48 :",
//t    "constructor_declarator : opt_attributes opt_modifiers IDENTIFIER $$47 OPEN_PARENS opt_formal_parameter_list CLOSE_PARENS $$48 opt_constructor_initializer",
//t    "constructor_body : block_prepared",
//t    "constructor_body : SEMICOLON",
//t    "opt_constructor_initializer :",
//t    "opt_constructor_initializer : constructor_initializer",
//t    "$$49 :",
//t    "constructor_initializer : COLON BASE OPEN_PARENS $$49 opt_argument_list CLOSE_PARENS",
//t    "$$50 :",
//t    "constructor_initializer : COLON THIS OPEN_PARENS $$50 opt_argument_list CLOSE_PARENS",
//t    "constructor_initializer : COLON error",
//t    "constructor_initializer : error",
//t    "$$51 :",
//t    "destructor_declaration : opt_attributes opt_modifiers TILDE $$51 IDENTIFIER OPEN_PARENS CLOSE_PARENS method_body",
//t    "$$52 :",
//t    "event_declaration : opt_attributes opt_modifiers EVENT type member_declaration_name $$52 opt_event_initializer opt_event_declarators SEMICOLON",
//t    "$$53 :",
//t    "$$54 :",
//t    "event_declaration : opt_attributes opt_modifiers EVENT type member_declaration_name OPEN_BRACE $$53 event_accessor_declarations $$54 CLOSE_BRACE",
//t    "event_declaration : opt_attributes opt_modifiers EVENT type error",
//t    "opt_event_initializer :",
//t    "$$55 :",
//t    "opt_event_initializer : ASSIGN $$55 event_variable_initializer",
//t    "opt_event_declarators :",
//t    "opt_event_declarators : event_declarators",
//t    "event_declarators : event_declarator",
//t    "event_declarators : event_declarators event_declarator",
//t    "event_declarator : COMMA IDENTIFIER",
//t    "$$56 :",
//t    "event_declarator : COMMA IDENTIFIER ASSIGN $$56 event_variable_initializer",
//t    "$$57 :",
//t    "event_variable_initializer : $$57 variable_initializer",
//t    "event_accessor_declarations : add_accessor_declaration remove_accessor_declaration",
//t    "event_accessor_declarations : remove_accessor_declaration add_accessor_declaration",
//t    "event_accessor_declarations : add_accessor_declaration",
//t    "event_accessor_declarations : remove_accessor_declaration",
//t    "event_accessor_declarations : error",
//t    "$$58 :",
//t    "add_accessor_declaration : opt_attributes opt_modifiers ADD $$58 event_accessor_block",
//t    "$$59 :",
//t    "remove_accessor_declaration : opt_attributes opt_modifiers REMOVE $$59 event_accessor_block",
//t    "event_accessor_block : opt_semicolon",
//t    "event_accessor_block : block",
//t    "attributes_without_members : attribute_sections CLOSE_BRACE",
//t    "incomplete_member : opt_attributes opt_modifiers member_type CLOSE_BRACE",
//t    "$$60 :",
//t    "$$61 :",
//t    "$$62 :",
//t    "enum_declaration : opt_attributes opt_modifiers ENUM type_declaration_name opt_enum_base $$60 OPEN_BRACE $$61 opt_enum_member_declarations $$62 CLOSE_BRACE opt_semicolon",
//t    "opt_enum_base :",
//t    "opt_enum_base : COLON type",
//t    "opt_enum_base : COLON error",
//t    "opt_enum_member_declarations :",
//t    "opt_enum_member_declarations : enum_member_declarations",
//t    "opt_enum_member_declarations : enum_member_declarations COMMA",
//t    "enum_member_declarations : enum_member_declaration",
//t    "enum_member_declarations : enum_member_declarations COMMA enum_member_declaration",
//t    "enum_member_declaration : opt_attributes IDENTIFIER",
//t    "$$63 :",
//t    "enum_member_declaration : opt_attributes IDENTIFIER $$63 ASSIGN constant_expression",
//t    "enum_member_declaration : opt_attributes IDENTIFIER error",
//t    "enum_member_declaration : attributes_without_members",
//t    "$$64 :",
//t    "$$65 :",
//t    "$$66 :",
//t    "delegate_declaration : opt_attributes opt_modifiers DELEGATE member_type type_declaration_name OPEN_PARENS $$64 opt_formal_parameter_list CLOSE_PARENS $$65 opt_type_parameter_constraints_clauses $$66 SEMICOLON",
//t    "opt_nullable :",
//t    "opt_nullable : INTERR_NULLABLE",
//t    "namespace_or_type_expr : member_name",
//t    "namespace_or_type_expr : qualified_alias_member IDENTIFIER opt_type_argument_list",
//t    "namespace_or_type_expr : qualified_alias_member IDENTIFIER generic_dimension",
//t    "member_name : simple_name_expr",
//t    "member_name : namespace_or_type_expr DOT IDENTIFIER opt_type_argument_list",
//t    "member_name : namespace_or_type_expr DOT IDENTIFIER generic_dimension",
//t    "simple_name_expr : IDENTIFIER opt_type_argument_list",
//t    "simple_name_expr : IDENTIFIER generic_dimension",
//t    "opt_type_argument_list :",
//t    "opt_type_argument_list : OP_GENERICS_LT type_arguments OP_GENERICS_GT",
//t    "opt_type_argument_list : OP_GENERICS_LT error",
//t    "type_arguments : type",
//t    "type_arguments : type_arguments COMMA type",
//t    "$$67 :",
//t    "type_declaration_name : IDENTIFIER $$67 opt_type_parameter_list",
//t    "member_declaration_name : method_declaration_name",
//t    "method_declaration_name : type_declaration_name",
//t    "method_declaration_name : explicit_interface IDENTIFIER opt_type_parameter_list",
//t    "indexer_declaration_name : THIS",
//t    "indexer_declaration_name : explicit_interface THIS",
//t    "explicit_interface : IDENTIFIER opt_type_argument_list DOT",
//t    "explicit_interface : qualified_alias_member IDENTIFIER opt_type_argument_list DOT",
//t    "explicit_interface : explicit_interface IDENTIFIER opt_type_argument_list DOT",
//t    "opt_type_parameter_list :",
//t    "opt_type_parameter_list : OP_GENERICS_LT_DECL type_parameters OP_GENERICS_GT",
//t    "type_parameters : type_parameter",
//t    "type_parameters : type_parameters COMMA type_parameter",
//t    "type_parameter : opt_attributes opt_type_parameter_variance IDENTIFIER",
//t    "type_parameter : error",
//t    "type_and_void : type_expression_or_array",
//t    "type_and_void : VOID",
//t    "member_type : type_and_void",
//t    "type : type_expression_or_array",
//t    "type : void_invalid",
//t    "simple_type : type_expression",
//t    "simple_type : void_invalid",
//t    "parameter_type : type_expression_or_array",
//t    "parameter_type : VOID",
//t    "type_expression_or_array : type_expression",
//t    "type_expression_or_array : type_expression rank_specifiers",
//t    "type_expression : namespace_or_type_expr opt_nullable",
//t    "type_expression : namespace_or_type_expr pointer_stars",
//t    "type_expression : builtin_type_expression",
//t    "void_invalid : VOID",
//t    "builtin_type_expression : builtin_types opt_nullable",
//t    "builtin_type_expression : builtin_types pointer_stars",
//t    "builtin_type_expression : VOID pointer_stars",
//t    "type_list : base_type_name",
//t    "type_list : type_list COMMA base_type_name",
//t    "base_type_name : type",
//t    "builtin_types : OBJECT",
//t    "builtin_types : STRING",
//t    "builtin_types : BOOL",
//t    "builtin_types : DECIMAL",
//t    "builtin_types : FLOAT",
//t    "builtin_types : DOUBLE",
//t    "builtin_types : integral_type",
//t    "integral_type : SBYTE",
//t    "integral_type : BYTE",
//t    "integral_type : SHORT",
//t    "integral_type : USHORT",
//t    "integral_type : INT",
//t    "integral_type : UINT",
//t    "integral_type : LONG",
//t    "integral_type : ULONG",
//t    "integral_type : CHAR",
//t    "primary_expression : primary_expression_or_type",
//t    "primary_expression : literal",
//t    "primary_expression : array_creation_expression",
//t    "primary_expression : parenthesized_expression",
//t    "primary_expression : default_value_expression",
//t    "primary_expression : invocation_expression",
//t    "primary_expression : element_access",
//t    "primary_expression : this_access",
//t    "primary_expression : base_access",
//t    "primary_expression : post_increment_expression",
//t    "primary_expression : post_decrement_expression",
//t    "primary_expression : object_or_delegate_creation_expression",
//t    "primary_expression : anonymous_type_expression",
//t    "primary_expression : typeof_expression",
//t    "primary_expression : sizeof_expression",
//t    "primary_expression : checked_expression",
//t    "primary_expression : unchecked_expression",
//t    "primary_expression : pointer_member_access",
//t    "primary_expression : anonymous_method_expression",
//t    "primary_expression : undocumented_expressions",
//t    "primary_expression_or_type : simple_name_expr",
//t    "primary_expression_or_type : IDENTIFIER GENERATE_COMPLETION",
//t    "primary_expression_or_type : member_access",
//t    "literal : boolean_literal",
//t    "literal : LITERAL",
//t    "literal : NULL",
//t    "boolean_literal : TRUE",
//t    "boolean_literal : FALSE",
//t    "open_parens_any : OPEN_PARENS",
//t    "open_parens_any : OPEN_PARENS_CAST",
//t    "close_parens : CLOSE_PARENS",
//t    "close_parens : COMPLETE_COMPLETION",
//t    "parenthesized_expression : OPEN_PARENS expression CLOSE_PARENS",
//t    "parenthesized_expression : OPEN_PARENS expression COMPLETE_COMPLETION",
//t    "member_access : primary_expression DOT identifier_inside_body opt_type_argument_list",
//t    "member_access : primary_expression DOT identifier_inside_body generic_dimension",
//t    "member_access : primary_expression INTERR_OPERATOR DOT identifier_inside_body opt_type_argument_list",
//t    "member_access : builtin_types DOT identifier_inside_body opt_type_argument_list",
//t    "member_access : BASE DOT identifier_inside_body opt_type_argument_list",
//t    "member_access : AWAIT DOT identifier_inside_body opt_type_argument_list",
//t    "member_access : qualified_alias_member identifier_inside_body opt_type_argument_list",
//t    "member_access : qualified_alias_member identifier_inside_body generic_dimension",
//t    "member_access : primary_expression DOT GENERATE_COMPLETION",
//t    "member_access : primary_expression DOT IDENTIFIER GENERATE_COMPLETION",
//t    "member_access : builtin_types DOT GENERATE_COMPLETION",
//t    "member_access : builtin_types DOT IDENTIFIER GENERATE_COMPLETION",
//t    "invocation_expression : primary_expression open_parens_any opt_argument_list close_parens",
//t    "invocation_expression : primary_expression open_parens_any argument_list error",
//t    "invocation_expression : primary_expression open_parens_any error",
//t    "opt_object_or_collection_initializer :",
//t    "opt_object_or_collection_initializer : object_or_collection_initializer",
//t    "object_or_collection_initializer : OPEN_BRACE opt_member_initializer_list close_brace_or_complete_completion",
//t    "object_or_collection_initializer : OPEN_BRACE member_initializer_list COMMA CLOSE_BRACE",
//t    "opt_member_initializer_list :",
//t    "opt_member_initializer_list : member_initializer_list",
//t    "member_initializer_list : member_initializer",
//t    "member_initializer_list : member_initializer_list COMMA member_initializer",
//t    "member_initializer_list : member_initializer_list error",
//t    "member_initializer : IDENTIFIER ASSIGN initializer_value",
//t    "member_initializer : AWAIT ASSIGN initializer_value",
//t    "member_initializer : GENERATE_COMPLETION",
//t    "member_initializer : non_assignment_expression opt_COMPLETE_COMPLETION",
//t    "member_initializer : OPEN_BRACE expression_list CLOSE_BRACE",
//t    "member_initializer : OPEN_BRACKET_EXPR expression_list CLOSE_BRACKET ASSIGN initializer_value",
//t    "member_initializer : OPEN_BRACE CLOSE_BRACE",
//t    "initializer_value : expression",
//t    "initializer_value : object_or_collection_initializer",
//t    "opt_argument_list :",
//t    "opt_argument_list : argument_list",
//t    "argument_list : argument_or_named_argument",
//t    "argument_list : argument_list COMMA argument",
//t    "argument_list : argument_list COMMA named_argument",
//t    "argument_list : argument_list COMMA error",
//t    "argument_list : COMMA error",
//t    "argument : expression",
//t    "argument : non_simple_argument",
//t    "argument_or_named_argument : argument",
//t    "argument_or_named_argument : named_argument",
//t    "non_simple_argument : REF variable_reference",
//t    "non_simple_argument : OUT variable_reference",
//t    "non_simple_argument : ARGLIST OPEN_PARENS argument_list CLOSE_PARENS",
//t    "non_simple_argument : ARGLIST OPEN_PARENS CLOSE_PARENS",
//t    "variable_reference : expression",
//t    "element_access : primary_expression OPEN_BRACKET_EXPR expression_list_arguments CLOSE_BRACKET",
//t    "element_access : primary_expression INTERR_OPERATOR OPEN_BRACKET_EXPR expression_list_arguments CLOSE_BRACKET",
//t    "element_access : primary_expression OPEN_BRACKET_EXPR expression_list_arguments error",
//t    "element_access : primary_expression OPEN_BRACKET_EXPR error",
//t    "expression_list : expression_or_error",
//t    "expression_list : expression_list COMMA expression_or_error",
//t    "expression_list_arguments : expression_list_argument",
//t    "expression_list_arguments : expression_list_arguments COMMA expression_list_argument",
//t    "expression_list_argument : expression",
//t    "expression_list_argument : named_argument",
//t    "this_access : THIS",
//t    "base_access : BASE OPEN_BRACKET_EXPR expression_list_arguments CLOSE_BRACKET",
//t    "base_access : BASE OPEN_BRACKET error",
//t    "post_increment_expression : primary_expression OP_INC",
//t    "post_decrement_expression : primary_expression OP_DEC",
//t    "object_or_delegate_creation_expression : NEW new_expr_type open_parens_any opt_argument_list CLOSE_PARENS opt_object_or_collection_initializer",
//t    "object_or_delegate_creation_expression : NEW new_expr_type object_or_collection_initializer",
//t    "array_creation_expression : NEW new_expr_type OPEN_BRACKET_EXPR expression_list CLOSE_BRACKET opt_rank_specifier opt_array_initializer",
//t    "array_creation_expression : NEW new_expr_type rank_specifiers opt_array_initializer",
//t    "array_creation_expression : NEW rank_specifier array_initializer",
//t    "array_creation_expression : NEW new_expr_type OPEN_BRACKET CLOSE_BRACKET OPEN_BRACKET_EXPR error CLOSE_BRACKET",
//t    "array_creation_expression : NEW new_expr_type error",
//t    "$$68 :",
//t    "new_expr_type : $$68 simple_type",
//t    "anonymous_type_expression : NEW OPEN_BRACE anonymous_type_parameters_opt_comma CLOSE_BRACE",
//t    "anonymous_type_expression : NEW OPEN_BRACE GENERATE_COMPLETION",
//t    "anonymous_type_parameters_opt_comma : anonymous_type_parameters_opt",
//t    "anonymous_type_parameters_opt_comma : anonymous_type_parameters COMMA",
//t    "anonymous_type_parameters_opt :",
//t    "anonymous_type_parameters_opt : anonymous_type_parameters",
//t    "anonymous_type_parameters : anonymous_type_parameter",
//t    "anonymous_type_parameters : anonymous_type_parameters COMMA anonymous_type_parameter",
//t    "anonymous_type_parameters : COMPLETE_COMPLETION",
//t    "anonymous_type_parameters : anonymous_type_parameter COMPLETE_COMPLETION",
//t    "anonymous_type_parameter : identifier_inside_body ASSIGN variable_initializer",
//t    "anonymous_type_parameter : identifier_inside_body",
//t    "anonymous_type_parameter : member_access",
//t    "anonymous_type_parameter : error",
//t    "opt_rank_specifier :",
//t    "opt_rank_specifier : rank_specifiers",
//t    "rank_specifiers : rank_specifier",
//t    "rank_specifiers : rank_specifier rank_specifiers",
//t    "rank_specifier : OPEN_BRACKET CLOSE_BRACKET",
//t    "rank_specifier : OPEN_BRACKET dim_separators CLOSE_BRACKET",
//t    "dim_separators : COMMA",
//t    "dim_separators : dim_separators COMMA",
//t    "opt_array_initializer :",
//t    "opt_array_initializer : array_initializer",
//t    "array_initializer : OPEN_BRACE CLOSE_BRACE",
//t    "array_initializer : OPEN_BRACE variable_initializer_list opt_comma CLOSE_BRACE",
//t    "variable_initializer_list : variable_initializer",
//t    "variable_initializer_list : variable_initializer_list COMMA variable_initializer",
//t    "typeof_expression : TYPEOF open_parens_any typeof_type_expression CLOSE_PARENS",
//t    "typeof_type_expression : type_and_void",
//t    "typeof_type_expression : error",
//t    "generic_dimension : GENERIC_DIMENSION",
//t    "qualified_alias_member : IDENTIFIER DOUBLE_COLON",
//t    "sizeof_expression : SIZEOF open_parens_any type CLOSE_PARENS",
//t    "sizeof_expression : SIZEOF open_parens_any type error",
//t    "checked_expression : CHECKED open_parens_any expression CLOSE_PARENS",
//t    "checked_expression : CHECKED error",
//t    "unchecked_expression : UNCHECKED open_parens_any expression CLOSE_PARENS",
//t    "unchecked_expression : UNCHECKED error",
//t    "pointer_member_access : primary_expression OP_PTR IDENTIFIER opt_type_argument_list",
//t    "$$69 :",
//t    "anonymous_method_expression : DELEGATE opt_anonymous_method_signature $$69 block",
//t    "$$70 :",
//t    "anonymous_method_expression : ASYNC DELEGATE opt_anonymous_method_signature $$70 block",
//t    "opt_anonymous_method_signature :",
//t    "opt_anonymous_method_signature : anonymous_method_signature",
//t    "$$71 :",
//t    "anonymous_method_signature : OPEN_PARENS $$71 opt_formal_parameter_list CLOSE_PARENS",
//t    "default_value_expression : DEFAULT open_parens_any type CLOSE_PARENS",
//t    "unary_expression : primary_expression",
//t    "unary_expression : BANG prefixed_unary_expression",
//t    "unary_expression : TILDE prefixed_unary_expression",
//t    "unary_expression : OPEN_PARENS_CAST type CLOSE_PARENS prefixed_unary_expression",
//t    "unary_expression : AWAIT prefixed_unary_expression",
//t    "unary_expression : BANG error",
//t    "unary_expression : TILDE error",
//t    "unary_expression : OPEN_PARENS_CAST type CLOSE_PARENS error",
//t    "unary_expression : AWAIT error",
//t    "prefixed_unary_expression : unary_expression",
//t    "prefixed_unary_expression : PLUS prefixed_unary_expression",
//t    "prefixed_unary_expression : MINUS prefixed_unary_expression",
//t    "prefixed_unary_expression : OP_INC prefixed_unary_expression",
//t    "prefixed_unary_expression : OP_DEC prefixed_unary_expression",
//t    "prefixed_unary_expression : STAR prefixed_unary_expression",
//t    "prefixed_unary_expression : BITWISE_AND prefixed_unary_expression",
//t    "prefixed_unary_expression : PLUS error",
//t    "prefixed_unary_expression : MINUS error",
//t    "prefixed_unary_expression : OP_INC error",
//t    "prefixed_unary_expression : OP_DEC error",
//t    "prefixed_unary_expression : STAR error",
//t    "prefixed_unary_expression : BITWISE_AND error",
//t    "multiplicative_expression : prefixed_unary_expression",
//t    "multiplicative_expression : multiplicative_expression STAR prefixed_unary_expression",
//t    "multiplicative_expression : multiplicative_expression DIV prefixed_unary_expression",
//t    "multiplicative_expression : multiplicative_expression PERCENT prefixed_unary_expression",
//t    "multiplicative_expression : multiplicative_expression STAR error",
//t    "multiplicative_expression : multiplicative_expression DIV error",
//t    "multiplicative_expression : multiplicative_expression PERCENT error",
//t    "additive_expression : multiplicative_expression",
//t    "additive_expression : additive_expression PLUS multiplicative_expression",
//t    "additive_expression : additive_expression MINUS multiplicative_expression",
//t    "additive_expression : additive_expression PLUS error",
//t    "additive_expression : additive_expression MINUS error",
//t    "additive_expression : additive_expression AS type",
//t    "additive_expression : additive_expression IS is_match_expr opt_identifier",
//t    "additive_expression : additive_expression AS error",
//t    "additive_expression : additive_expression IS error",
//t    "additive_expression : AWAIT IS type",
//t    "additive_expression : AWAIT AS type",
//t    "is_match_expr : match_type",
//t    "is_match_expr : match_type rank_specifiers",
//t    "is_match_expr : literal",
//t    "is_match_expr : PLUS prefixed_unary_expression",
//t    "is_match_expr : MINUS prefixed_unary_expression",
//t    "match_type : primary_expression_or_type opt_nullable",
//t    "match_type : primary_expression_or_type pointer_stars",
//t    "match_type : builtin_type_expression",
//t    "match_type : void_invalid",
//t    "shift_expression : additive_expression",
//t    "shift_expression : shift_expression OP_SHIFT_LEFT additive_expression",
//t    "shift_expression : shift_expression OP_SHIFT_RIGHT additive_expression",
//t    "shift_expression : shift_expression OP_SHIFT_LEFT error",
//t    "shift_expression : shift_expression OP_SHIFT_RIGHT error",
//t    "relational_expression : shift_expression",
//t    "relational_expression : relational_expression OP_LT shift_expression",
//t    "relational_expression : relational_expression OP_GT shift_expression",
//t    "relational_expression : relational_expression OP_LE shift_expression",
//t    "relational_expression : relational_expression OP_GE shift_expression",
//t    "relational_expression : relational_expression OP_LT error",
//t    "relational_expression : relational_expression OP_GT error",
//t    "relational_expression : relational_expression OP_LE error",
//t    "relational_expression : relational_expression OP_GE error",
//t    "equality_expression : relational_expression",
//t    "equality_expression : equality_expression OP_EQ relational_expression",
//t    "equality_expression : equality_expression OP_NE relational_expression",
//t    "equality_expression : equality_expression OP_EQ error",
//t    "equality_expression : equality_expression OP_NE error",
//t    "and_expression : equality_expression",
//t    "and_expression : and_expression BITWISE_AND equality_expression",
//t    "and_expression : and_expression BITWISE_AND error",
//t    "exclusive_or_expression : and_expression",
//t    "exclusive_or_expression : exclusive_or_expression CARRET and_expression",
//t    "exclusive_or_expression : exclusive_or_expression CARRET error",
//t    "inclusive_or_expression : exclusive_or_expression",
//t    "inclusive_or_expression : inclusive_or_expression BITWISE_OR exclusive_or_expression",
//t    "inclusive_or_expression : inclusive_or_expression BITWISE_OR error",
//t    "conditional_and_expression : inclusive_or_expression",
//t    "conditional_and_expression : conditional_and_expression OP_AND inclusive_or_expression",
//t    "conditional_and_expression : conditional_and_expression OP_AND error",
//t    "conditional_or_expression : conditional_and_expression",
//t    "conditional_or_expression : conditional_or_expression OP_OR conditional_and_expression",
//t    "conditional_or_expression : conditional_or_expression OP_OR error",
//t    "null_coalescing_expression : conditional_or_expression",
//t    "null_coalescing_expression : conditional_or_expression OP_COALESCING null_coalescing_expression",
//t    "conditional_expression : null_coalescing_expression",
//t    "conditional_expression : null_coalescing_expression INTERR expression COLON expression",
//t    "conditional_expression : null_coalescing_expression INTERR expression error",
//t    "conditional_expression : null_coalescing_expression INTERR expression COLON error",
//t    "conditional_expression : null_coalescing_expression INTERR expression COLON CLOSE_BRACE",
//t    "assignment_expression : prefixed_unary_expression ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_MULT_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_DIV_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_MOD_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_ADD_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_SUB_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_SHIFT_LEFT_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_SHIFT_RIGHT_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_AND_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_OR_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_XOR_ASSIGN expression",
//t    "lambda_parameter_list : lambda_parameter",
//t    "lambda_parameter_list : lambda_parameter_list COMMA lambda_parameter",
//t    "lambda_parameter : parameter_modifier parameter_type identifier_inside_body",
//t    "lambda_parameter : parameter_type identifier_inside_body",
//t    "lambda_parameter : IDENTIFIER",
//t    "lambda_parameter : AWAIT",
//t    "opt_lambda_parameter_list :",
//t    "opt_lambda_parameter_list : lambda_parameter_list",
//t    "$$72 :",
//t    "lambda_expression_body : $$72 expression",
//t    "lambda_expression_body : block",
//t    "lambda_expression_body : error",
//t    "expression_or_error : expression",
//t    "expression_or_error : error",
//t    "$$73 :",
//t    "lambda_expression : IDENTIFIER ARROW $$73 lambda_expression_body",
//t    "$$74 :",
//t    "lambda_expression : AWAIT ARROW $$74 lambda_expression_body",
//t    "$$75 :",
//t    "lambda_expression : ASYNC identifier_inside_body ARROW $$75 lambda_expression_body",
//t    "$$76 :",
//t    "$$77 :",
//t    "lambda_expression : OPEN_PARENS_LAMBDA $$76 opt_lambda_parameter_list CLOSE_PARENS ARROW $$77 lambda_expression_body",
//t    "$$78 :",
//t    "$$79 :",
//t    "lambda_expression : ASYNC OPEN_PARENS_LAMBDA $$78 opt_lambda_parameter_list CLOSE_PARENS ARROW $$79 lambda_expression_body",
//t    "expression : assignment_expression",
//t    "expression : non_assignment_expression",
//t    "non_assignment_expression : conditional_expression",
//t    "non_assignment_expression : lambda_expression",
//t    "non_assignment_expression : query_expression",
//t    "non_assignment_expression : ARGLIST",
//t    "undocumented_expressions : REFVALUE OPEN_PARENS non_assignment_expression COMMA type CLOSE_PARENS",
//t    "undocumented_expressions : REFTYPE open_parens_any expression CLOSE_PARENS",
//t    "undocumented_expressions : MAKEREF open_parens_any expression CLOSE_PARENS",
//t    "constant_expression : expression",
//t    "boolean_expression : expression",
//t    "opt_primary_parameters :",
//t    "opt_primary_parameters : primary_parameters",
//t    "primary_parameters : OPEN_PARENS opt_formal_parameter_list CLOSE_PARENS",
//t    "opt_primary_parameters_with_class_base :",
//t    "opt_primary_parameters_with_class_base : class_base",
//t    "opt_primary_parameters_with_class_base : primary_parameters",
//t    "opt_primary_parameters_with_class_base : primary_parameters class_base",
//t    "$$80 :",
//t    "opt_primary_parameters_with_class_base : primary_parameters class_base OPEN_PARENS $$80 opt_argument_list CLOSE_PARENS",
//t    "$$81 :",
//t    "$$82 :",
//t    "$$83 :",
//t    "$$84 :",
//t    "class_declaration : opt_attributes opt_modifiers opt_partial CLASS $$81 type_declaration_name $$82 opt_primary_parameters_with_class_base opt_type_parameter_constraints_clauses $$83 OPEN_BRACE opt_class_member_declarations CLOSE_BRACE $$84 opt_semicolon",
//t    "opt_partial :",
//t    "opt_partial : PARTIAL",
//t    "opt_modifiers :",
//t    "opt_modifiers : modifiers",
//t    "modifiers : modifier",
//t    "modifiers : modifiers modifier",
//t    "modifier : NEW",
//t    "modifier : PUBLIC",
//t    "modifier : PROTECTED",
//t    "modifier : INTERNAL",
//t    "modifier : PRIVATE",
//t    "modifier : ABSTRACT",
//t    "modifier : SEALED",
//t    "modifier : STATIC",
//t    "modifier : READONLY",
//t    "modifier : VIRTUAL",
//t    "modifier : OVERRIDE",
//t    "modifier : EXTERN",
//t    "modifier : VOLATILE",
//t    "modifier : UNSAFE",
//t    "modifier : ASYNC",
//t    "opt_class_base :",
//t    "opt_class_base : class_base",
//t    "class_base : COLON type_list",
//t    "class_base : COLON type_list error",
//t    "opt_type_parameter_constraints_clauses :",
//t    "opt_type_parameter_constraints_clauses : type_parameter_constraints_clauses",
//t    "type_parameter_constraints_clauses : type_parameter_constraints_clause",
//t    "type_parameter_constraints_clauses : type_parameter_constraints_clauses type_parameter_constraints_clause",
//t    "type_parameter_constraints_clause : WHERE IDENTIFIER COLON type_parameter_constraints",
//t    "type_parameter_constraints_clause : WHERE IDENTIFIER error",
//t    "type_parameter_constraints : type_parameter_constraint",
//t    "type_parameter_constraints : type_parameter_constraints COMMA type_parameter_constraint",
//t    "type_parameter_constraint : type",
//t    "type_parameter_constraint : NEW OPEN_PARENS CLOSE_PARENS",
//t    "type_parameter_constraint : CLASS",
//t    "type_parameter_constraint : STRUCT",
//t    "opt_type_parameter_variance :",
//t    "opt_type_parameter_variance : type_parameter_variance",
//t    "type_parameter_variance : OUT",
//t    "type_parameter_variance : IN",
//t    "$$85 :",
//t    "block : OPEN_BRACE $$85 opt_statement_list block_end",
//t    "block_end : CLOSE_BRACE",
//t    "block_end : COMPLETE_COMPLETION",
//t    "$$86 :",
//t    "block_prepared : OPEN_BRACE $$86 opt_statement_list CLOSE_BRACE",
//t    "block_prepared : CLOSE_BRACE",
//t    "$$87 :",
//t    "block_prepared_strict : OPEN_BRACE $$87 opt_statement_list CLOSE_BRACE",
//t    "opt_statement_list :",
//t    "opt_statement_list : statement_list",
//t    "statement_list : statement",
//t    "statement_list : statement_list statement",
//t    "statement : block_variable_declaration",
//t    "statement : valid_declaration_statement",
//t    "statement : labeled_statement",
//t    "statement : IDENTIFIER error",
//t    "statement : error",
//t    "interactive_statement_list : interactive_statement",
//t    "interactive_statement_list : interactive_statement_list interactive_statement",
//t    "interactive_statement : block_variable_declaration",
//t    "interactive_statement : interactive_valid_declaration_statement",
//t    "interactive_statement : labeled_statement",
//t    "valid_declaration_statement : block",
//t    "valid_declaration_statement : empty_statement",
//t    "valid_declaration_statement : expression_statement",
//t    "valid_declaration_statement : selection_statement",
//t    "valid_declaration_statement : iteration_statement",
//t    "valid_declaration_statement : jump_statement",
//t    "valid_declaration_statement : try_statement",
//t    "valid_declaration_statement : checked_statement",
//t    "valid_declaration_statement : unchecked_statement",
//t    "valid_declaration_statement : lock_statement",
//t    "valid_declaration_statement : using_statement",
//t    "valid_declaration_statement : unsafe_statement",
//t    "valid_declaration_statement : fixed_statement",
//t    "interactive_valid_declaration_statement : block",
//t    "interactive_valid_declaration_statement : empty_statement",
//t    "interactive_valid_declaration_statement : interactive_expression_statement",
//t    "interactive_valid_declaration_statement : selection_statement",
//t    "interactive_valid_declaration_statement : iteration_statement",
//t    "interactive_valid_declaration_statement : jump_statement",
//t    "interactive_valid_declaration_statement : try_statement",
//t    "interactive_valid_declaration_statement : checked_statement",
//t    "interactive_valid_declaration_statement : unchecked_statement",
//t    "interactive_valid_declaration_statement : lock_statement",
//t    "interactive_valid_declaration_statement : using_statement",
//t    "interactive_valid_declaration_statement : unsafe_statement",
//t    "interactive_valid_declaration_statement : fixed_statement",
//t    "embedded_statement : valid_declaration_statement",
//t    "embedded_statement : block_variable_declaration",
//t    "embedded_statement : labeled_statement",
//t    "embedded_statement : error",
//t    "empty_statement : SEMICOLON",
//t    "$$88 :",
//t    "labeled_statement : identifier_inside_body COLON $$88 statement",
//t    "variable_type : variable_type_simple",
//t    "variable_type : variable_type_simple rank_specifiers",
//t    "variable_type_simple : primary_expression_or_type opt_nullable",
//t    "variable_type_simple : primary_expression_or_type pointer_stars",
//t    "variable_type_simple : builtin_type_expression",
//t    "variable_type_simple : void_invalid",
//t    "pointer_stars : pointer_star",
//t    "pointer_stars : pointer_star pointer_stars",
//t    "pointer_star : STAR",
//t    "identifier_inside_body : IDENTIFIER",
//t    "identifier_inside_body : AWAIT",
//t    "$$89 :",
//t    "block_variable_declaration : variable_type identifier_inside_body $$89 opt_local_variable_initializer opt_variable_declarators semicolon_or_handle_error_close_brace",
//t    "$$90 :",
//t    "block_variable_declaration : CONST variable_type identifier_inside_body $$90 const_variable_initializer opt_const_declarators SEMICOLON",
//t    "semicolon_or_handle_error_close_brace : SEMICOLON",
//t    "semicolon_or_handle_error_close_brace : CLOSE_BRACE",
//t    "opt_local_variable_initializer :",
//t    "opt_local_variable_initializer : ASSIGN block_variable_initializer",
//t    "opt_local_variable_initializer : error",
//t    "opt_variable_declarators :",
//t    "opt_variable_declarators : variable_declarators",
//t    "opt_using_or_fixed_variable_declarators :",
//t    "opt_using_or_fixed_variable_declarators : variable_declarators",
//t    "variable_declarators : variable_declarator",
//t    "variable_declarators : variable_declarators variable_declarator",
//t    "variable_declarator : COMMA identifier_inside_body",
//t    "variable_declarator : COMMA identifier_inside_body ASSIGN block_variable_initializer",
//t    "const_variable_initializer :",
//t    "const_variable_initializer : ASSIGN constant_initializer_expr",
//t    "opt_const_declarators :",
//t    "opt_const_declarators : const_declarators",
//t    "const_declarators : const_declarator",
//t    "const_declarators : const_declarators const_declarator",
//t    "const_declarator : COMMA identifier_inside_body ASSIGN constant_initializer_expr",
//t    "block_variable_initializer : variable_initializer",
//t    "block_variable_initializer : STACKALLOC simple_type OPEN_BRACKET_EXPR expression CLOSE_BRACKET",
//t    "block_variable_initializer : STACKALLOC simple_type",
//t    "expression_statement : statement_expression SEMICOLON",
//t    "expression_statement : statement_expression COMPLETE_COMPLETION",
//t    "expression_statement : statement_expression CLOSE_BRACE",
//t    "interactive_expression_statement : interactive_statement_expression SEMICOLON",
//t    "interactive_expression_statement : interactive_statement_expression COMPLETE_COMPLETION",
//t    "statement_expression : expression",
//t    "interactive_statement_expression : expression",
//t    "interactive_statement_expression : error",
//t    "selection_statement : if_statement",
//t    "selection_statement : switch_statement",
//t    "if_statement : IF open_parens_any boolean_expression CLOSE_PARENS embedded_statement",
//t    "if_statement : IF open_parens_any boolean_expression CLOSE_PARENS embedded_statement ELSE embedded_statement",
//t    "if_statement : IF open_parens_any boolean_expression error",
//t    "$$91 :",
//t    "switch_statement : SWITCH open_parens_any expression CLOSE_PARENS OPEN_BRACE $$91 opt_switch_sections CLOSE_BRACE",
//t    "switch_statement : SWITCH open_parens_any expression error",
//t    "opt_switch_sections :",
//t    "opt_switch_sections : switch_sections",
//t    "switch_sections : switch_section",
//t    "switch_sections : switch_sections switch_section",
//t    "switch_sections : error",
//t    "switch_section : switch_labels statement_list",
//t    "switch_labels : switch_label",
//t    "switch_labels : switch_labels switch_label",
//t    "switch_label : CASE constant_expression COLON",
//t    "switch_label : CASE constant_expression error",
//t    "switch_label : DEFAULT_COLON",
//t    "iteration_statement : while_statement",
//t    "iteration_statement : do_statement",
//t    "iteration_statement : for_statement",
//t    "iteration_statement : foreach_statement",
//t    "while_statement : WHILE open_parens_any boolean_expression CLOSE_PARENS embedded_statement",
//t    "while_statement : WHILE open_parens_any boolean_expression error",
//t    "do_statement : DO embedded_statement WHILE open_parens_any boolean_expression CLOSE_PARENS SEMICOLON",
//t    "do_statement : DO embedded_statement error",
//t    "do_statement : DO embedded_statement WHILE open_parens_any boolean_expression error",
//t    "$$92 :",
//t    "for_statement : FOR open_parens_any $$92 for_statement_cont",
//t    "$$93 :",
//t    "for_statement_cont : opt_for_initializer SEMICOLON $$93 for_statement_condition",
//t    "for_statement_cont : opt_for_initializer CLOSE_PARENS",
//t    "$$94 :",
//t    "for_statement_condition : opt_for_condition SEMICOLON $$94 for_statement_end",
//t    "for_statement_condition : boolean_expression CLOSE_PARENS",
//t    "for_statement_end : opt_for_iterator CLOSE_PARENS embedded_statement",
//t    "for_statement_end : error",
//t    "opt_for_initializer :",
//t    "opt_for_initializer : for_initializer",
//t    "$$95 :",
//t    "for_initializer : variable_type identifier_inside_body $$95 opt_local_variable_initializer opt_variable_declarators",
//t    "for_initializer : statement_expression_list",
//t    "opt_for_condition :",
//t    "opt_for_condition : boolean_expression",
//t    "opt_for_iterator :",
//t    "opt_for_iterator : for_iterator",
//t    "for_iterator : statement_expression_list",
//t    "statement_expression_list : statement_expression",
//t    "statement_expression_list : statement_expression_list COMMA statement_expression",
//t    "foreach_statement : FOREACH open_parens_any type error",
//t    "foreach_statement : FOREACH open_parens_any type identifier_inside_body error",
//t    "$$96 :",
//t    "foreach_statement : FOREACH open_parens_any type identifier_inside_body IN expression CLOSE_PARENS $$96 embedded_statement",
//t    "foreach_statement : FOREACH open_parens_any type identifier_inside_body error",
//t    "foreach_statement : FOREACH open_parens_any type error",
//t    "jump_statement : break_statement",
//t    "jump_statement : continue_statement",
//t    "jump_statement : goto_statement",
//t    "jump_statement : return_statement",
//t    "jump_statement : throw_statement",
//t    "jump_statement : yield_statement",
//t    "break_statement : BREAK SEMICOLON",
//t    "continue_statement : CONTINUE SEMICOLON",
//t    "continue_statement : CONTINUE error",
//t    "goto_statement : GOTO identifier_inside_body SEMICOLON",
//t    "goto_statement : GOTO CASE constant_expression SEMICOLON",
//t    "goto_statement : GOTO DEFAULT SEMICOLON",
//t    "return_statement : RETURN opt_expression SEMICOLON",
//t    "return_statement : RETURN expression error",
//t    "return_statement : RETURN error",
//t    "throw_statement : THROW opt_expression SEMICOLON",
//t    "throw_statement : THROW expression error",
//t    "throw_statement : THROW error",
//t    "yield_statement : identifier_inside_body RETURN opt_expression SEMICOLON",
//t    "yield_statement : identifier_inside_body RETURN expression error",
//t    "yield_statement : identifier_inside_body BREAK SEMICOLON",
//t    "opt_expression :",
//t    "opt_expression : expression",
//t    "try_statement : TRY block catch_clauses",
//t    "try_statement : TRY block FINALLY block",
//t    "try_statement : TRY block catch_clauses FINALLY block",
//t    "try_statement : TRY block error",
//t    "catch_clauses : catch_clause",
//t    "catch_clauses : catch_clauses catch_clause",
//t    "opt_identifier :",
//t    "opt_identifier : identifier_inside_body",
//t    "catch_clause : CATCH opt_catch_filter block",
//t    "$$97 :",
//t    "catch_clause : CATCH open_parens_any type opt_identifier CLOSE_PARENS $$97 opt_catch_filter block_prepared",
//t    "catch_clause : CATCH open_parens_any error",
//t    "catch_clause : CATCH open_parens_any type opt_identifier CLOSE_PARENS error",
//t    "opt_catch_filter :",
//t    "opt_catch_filter : IF open_parens_any expression CLOSE_PARENS",
//t    "checked_statement : CHECKED block",
//t    "unchecked_statement : UNCHECKED block",
//t    "$$98 :",
//t    "unsafe_statement : UNSAFE $$98 block",
//t    "lock_statement : LOCK open_parens_any expression CLOSE_PARENS embedded_statement",
//t    "lock_statement : LOCK open_parens_any expression error",
//t    "$$99 :",
//t    "$$100 :",
//t    "fixed_statement : FIXED open_parens_any variable_type identifier_inside_body $$99 using_or_fixed_variable_initializer opt_using_or_fixed_variable_declarators CLOSE_PARENS $$100 embedded_statement",
//t    "$$101 :",
//t    "$$102 :",
//t    "using_statement : USING open_parens_any variable_type identifier_inside_body $$101 using_initialization CLOSE_PARENS $$102 embedded_statement",
//t    "using_statement : USING open_parens_any expression CLOSE_PARENS embedded_statement",
//t    "using_statement : USING open_parens_any expression error",
//t    "using_initialization : using_or_fixed_variable_initializer opt_using_or_fixed_variable_declarators",
//t    "using_initialization : error",
//t    "using_or_fixed_variable_initializer :",
//t    "using_or_fixed_variable_initializer : ASSIGN variable_initializer",
//t    "query_expression : first_from_clause query_body",
//t    "query_expression : nested_from_clause query_body",
//t    "query_expression : first_from_clause COMPLETE_COMPLETION",
//t    "query_expression : nested_from_clause COMPLETE_COMPLETION",
//t    "first_from_clause : FROM_FIRST identifier_inside_body IN expression",
//t    "first_from_clause : FROM_FIRST type identifier_inside_body IN expression",
//t    "nested_from_clause : FROM identifier_inside_body IN expression",
//t    "nested_from_clause : FROM type identifier_inside_body IN expression",
//t    "$$103 :",
//t    "from_clause : FROM identifier_inside_body IN $$103 expression_or_error",
//t    "$$104 :",
//t    "from_clause : FROM type identifier_inside_body IN $$104 expression_or_error",
//t    "query_body : query_body_clauses select_or_group_clause opt_query_continuation",
//t    "query_body : select_or_group_clause opt_query_continuation",
//t    "query_body : query_body_clauses COMPLETE_COMPLETION",
//t    "query_body : query_body_clauses error",
//t    "query_body : error",
//t    "$$105 :",
//t    "select_or_group_clause : SELECT $$105 expression_or_error",
//t    "$$106 :",
//t    "$$107 :",
//t    "select_or_group_clause : GROUP $$106 expression_or_error $$107 by_expression",
//t    "by_expression : BY expression_or_error",
//t    "by_expression : error",
//t    "query_body_clauses : query_body_clause",
//t    "query_body_clauses : query_body_clauses query_body_clause",
//t    "query_body_clause : from_clause",
//t    "query_body_clause : let_clause",
//t    "query_body_clause : where_clause",
//t    "query_body_clause : join_clause",
//t    "query_body_clause : orderby_clause",
//t    "$$108 :",
//t    "let_clause : LET identifier_inside_body ASSIGN $$108 expression_or_error",
//t    "$$109 :",
//t    "where_clause : WHERE $$109 expression_or_error",
//t    "$$110 :",
//t    "$$111 :",
//t    "$$112 :",
//t    "join_clause : JOIN identifier_inside_body IN $$110 expression_or_error ON $$111 expression_or_error EQUALS $$112 expression_or_error opt_join_into",
//t    "$$113 :",
//t    "$$114 :",
//t    "$$115 :",
//t    "join_clause : JOIN type identifier_inside_body IN $$113 expression_or_error ON $$114 expression_or_error EQUALS $$115 expression_or_error opt_join_into",
//t    "opt_join_into :",
//t    "opt_join_into : INTO identifier_inside_body",
//t    "$$116 :",
//t    "orderby_clause : ORDERBY $$116 orderings",
//t    "orderings : order_by",
//t    "$$117 :",
//t    "orderings : order_by COMMA $$117 orderings_then_by",
//t    "orderings_then_by : then_by",
//t    "$$118 :",
//t    "orderings_then_by : orderings_then_by COMMA $$118 then_by",
//t    "order_by : expression",
//t    "order_by : expression ASCENDING",
//t    "order_by : expression DESCENDING",
//t    "then_by : expression",
//t    "then_by : expression ASCENDING",
//t    "then_by : expression DESCENDING",
//t    "opt_query_continuation :",
//t    "$$119 :",
//t    "opt_query_continuation : INTO identifier_inside_body $$119 query_body",
//t    "interactive_parsing : EVAL_STATEMENT_PARSER EOF",
//t    "interactive_parsing : EVAL_USING_DECLARATIONS_UNIT_PARSER using_directives opt_COMPLETE_COMPLETION",
//t    "$$120 :",
//t    "interactive_parsing : EVAL_STATEMENT_PARSER $$120 interactive_statement_list opt_COMPLETE_COMPLETION",
//t    "interactive_parsing : EVAL_COMPILATION_UNIT_PARSER interactive_compilation_unit",
//t    "interactive_compilation_unit : opt_extern_alias_directives opt_using_directives",
//t    "interactive_compilation_unit : opt_extern_alias_directives opt_using_directives namespace_or_type_declarations",
//t    "opt_COMPLETE_COMPLETION :",
//t    "opt_COMPLETE_COMPLETION : COMPLETE_COMPLETION",
//t    "close_brace_or_complete_completion : CLOSE_BRACE",
//t    "close_brace_or_complete_completion : COMPLETE_COMPLETION",
//t    "documentation_parsing : DOC_SEE doc_cref",
//t    "doc_cref : doc_type_declaration_name opt_doc_method_sig",
//t    "doc_cref : builtin_types opt_doc_method_sig",
//t    "doc_cref : VOID opt_doc_method_sig",
//t    "doc_cref : builtin_types DOT IDENTIFIER opt_doc_method_sig",
//t    "doc_cref : doc_type_declaration_name DOT THIS",
//t    "$$121 :",
//t    "doc_cref : doc_type_declaration_name DOT THIS OPEN_BRACKET $$121 opt_doc_parameters CLOSE_BRACKET",
//t    "doc_cref : EXPLICIT OPERATOR type opt_doc_method_sig",
//t    "doc_cref : IMPLICIT OPERATOR type opt_doc_method_sig",
//t    "doc_cref : OPERATOR overloadable_operator opt_doc_method_sig",
//t    "doc_type_declaration_name : type_declaration_name",
//t    "doc_type_declaration_name : doc_type_declaration_name DOT type_declaration_name",
//t    "opt_doc_method_sig :",
//t    "$$122 :",
//t    "opt_doc_method_sig : OPEN_PARENS $$122 opt_doc_parameters CLOSE_PARENS",
//t    "opt_doc_parameters :",
//t    "opt_doc_parameters : doc_parameters",
//t    "doc_parameters : doc_parameter",
//t    "doc_parameters : doc_parameters COMMA doc_parameter",
//t    "doc_parameter : opt_parameter_modifier parameter_type",
//t  };
//t public static string getRule (int index) {
//t    return yyRule [index];
//t }
//t}
  protected static readonly string [] yyNames = {    
    "end-of-file",null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,"EOF","NONE","ERROR",
    "FIRST_KEYWORD","ABSTRACT","AS","ADD","BASE","BOOL","BREAK","BYTE",
    "CASE","CATCH","CHAR","CHECKED","CLASS","CONST","CONTINUE","DECIMAL",
    "DEFAULT","DELEGATE","DO","DOUBLE","ELSE","ENUM","EVENT","EXPLICIT",
    "EXTERN","FALSE","FINALLY","FIXED","FLOAT","FOR","FOREACH","GOTO",
    "IF","IMPLICIT","IN","INT","INTERFACE","INTERNAL","IS","LOCK","LONG",
    "NAMESPACE","NEW","NULL","OBJECT","OPERATOR","OUT","OVERRIDE",
    "PARAMS","PRIVATE","PROTECTED","PUBLIC","READONLY","REF","RETURN",
    "REMOVE","SBYTE","SEALED","SHORT","SIZEOF","STACKALLOC","STATIC",
    "STRING","STRUCT","SWITCH","THIS","THROW","TRUE","TRY","TYPEOF",
    "UINT","ULONG","UNCHECKED","UNSAFE","USHORT","USING","VIRTUAL","VOID",
    "VOLATILE","WHERE","WHILE","ARGLIST","PARTIAL","ARROW","FROM",
    "FROM_FIRST","JOIN","ON","EQUALS","SELECT","GROUP","BY","LET",
    "ORDERBY","ASCENDING","DESCENDING","INTO","INTERR_NULLABLE",
    "EXTERN_ALIAS","REFVALUE","REFTYPE","MAKEREF","ASYNC","AWAIT",
    "INTERR_OPERATOR","GET","SET","LAST_KEYWORD","OPEN_BRACE",
    "CLOSE_BRACE","OPEN_BRACKET","CLOSE_BRACKET","OPEN_PARENS",
    "CLOSE_PARENS","DOT","COMMA","COLON","SEMICOLON","TILDE","PLUS",
    "MINUS","BANG","ASSIGN","OP_LT","OP_GT","BITWISE_AND","BITWISE_OR",
    "STAR","PERCENT","DIV","CARRET","INTERR","DOUBLE_COLON","OP_INC",
    "OP_DEC","OP_SHIFT_LEFT","OP_SHIFT_RIGHT","OP_LE","OP_GE","OP_EQ",
    "OP_NE","OP_AND","OP_OR","OP_MULT_ASSIGN","OP_DIV_ASSIGN",
    "OP_MOD_ASSIGN","OP_ADD_ASSIGN","OP_SUB_ASSIGN",
    "OP_SHIFT_LEFT_ASSIGN","OP_SHIFT_RIGHT_ASSIGN","OP_AND_ASSIGN",
    "OP_XOR_ASSIGN","OP_OR_ASSIGN","OP_PTR","OP_COALESCING",
    "OP_GENERICS_LT","OP_GENERICS_LT_DECL","OP_GENERICS_GT","LITERAL",
    "IDENTIFIER","OPEN_PARENS_LAMBDA","OPEN_PARENS_CAST",
    "GENERIC_DIMENSION","DEFAULT_COLON","OPEN_BRACKET_EXPR",
    "EVAL_STATEMENT_PARSER","EVAL_COMPILATION_UNIT_PARSER",
    "EVAL_USING_DECLARATIONS_UNIT_PARSER","DOC_SEE","GENERATE_COMPLETION",
    "COMPLETE_COMPLETION","UMINUS",
  };

  /** index-checked interface to yyNames[].
      @param token single character or %token value.
      @return token name or [illegal] or [unknown].
    */
//t  public static string yyname (int token) {
//t    if ((token < 0) || (token > yyNames.Length)) return "[illegal]";
//t    string name;
//t    if ((name = yyNames[token]) != null) return name;
//t    return "[unknown]";
//t  }

#pragma warning disable 414
  int yyExpectingState;
#pragma warning restore 414
  /** computes list of expected tokens on error by tracing the tables.
      @param state for which to compute the list.
      @return list of token names.
    */
  protected int [] yyExpectingTokens (int state){
    int token, n, len = 0;
    bool[] ok = new bool[yyNames.Length];
    if ((n = yySindex[state]) != 0)
      for (token = n < 0 ? -n : 0;
           (token < yyNames.Length) && (n+token < yyTable.Length); ++ token)
        if (yyCheck[n+token] == token && !ok[token] && yyNames[token] != null) {
          ++ len;
          ok[token] = true;
        }
    if ((n = yyRindex[state]) != 0)
      for (token = n < 0 ? -n : 0;
           (token < yyNames.Length) && (n+token < yyTable.Length); ++ token)
        if (yyCheck[n+token] == token && !ok[token] && yyNames[token] != null) {
          ++ len;
          ok[token] = true;
        }
    int [] result = new int [len];
    for (n = token = 0; n < len;  ++ token)
      if (ok[token]) result[n++] = token;
    return result;
  }
  protected string[] yyExpecting (int state) {
    int [] tokens = yyExpectingTokens (state);
    string [] result = new string[tokens.Length];
    for (int n = 0; n < tokens.Length;  n++)
      result[n++] = yyNames[tokens [n]];
    return result;
  }

  /** the generated parser, with debugging messages.
      Maintains a state and a value stack, currently with fixed maximum size.
      @param yyLex scanner.
      @param yydebug debug message writer implementing yyDebug, or null.
      @return result of the last reduction, if any.
      @throws yyException on irrecoverable parse error.
    */
  internal Object yyparse (yyParser.yyInput yyLex, Object yyd)
				 {
//t    this.debug = (yydebug.yyDebug)yyd;
    return yyparse(yyLex);
  }

  /** initial size and increment of the state/value stack [default 256].
      This is not final so that it can be overwritten outside of invocations
      of yyparse().
    */
  protected int yyMax;

  /** executed at the beginning of a reduce action.
      Used as $$ = yyDefault($1), prior to the user-specified action, if any.
      Can be overwritten to provide deep copy, etc.
      @param first value for $1, or null.
      @return first.
    */
  protected Object yyDefault (Object first) {
    return first;
  }

	static int[] global_yyStates;
	static object[] global_yyVals;
#pragma warning disable 649
	protected bool use_global_stacks;
#pragma warning restore 649
	object[] yyVals;					// value stack
	object yyVal;						// value stack ptr
	int yyToken;						// current input
	int yyTop;

  /** the generated parser.
      Maintains a state and a value stack, currently with fixed maximum size.
      @param yyLex scanner.
      @return result of the last reduction, if any.
      @throws yyException on irrecoverable parse error.
    */
  internal Object yyparse (yyParser.yyInput yyLex)
  {
    if (yyMax <= 0) yyMax = 256;		// initial size
    int yyState = 0;                   // state stack ptr
    int [] yyStates;               	// state stack 
    yyVal = null;
    yyToken = -1;
    int yyErrorFlag = 0;				// #tks to shift
	if (use_global_stacks && global_yyStates != null) {
		yyVals = global_yyVals;
		yyStates = global_yyStates;
   } else {
		yyVals = new object [yyMax];
		yyStates = new int [yyMax];
		if (use_global_stacks) {
			global_yyVals = yyVals;
			global_yyStates = yyStates;
		}
	}

    /*yyLoop:*/ for (yyTop = 0;; ++ yyTop) {
      if (yyTop >= yyStates.Length) {			// dynamically increase
        global::System.Array.Resize (ref yyStates, yyStates.Length+yyMax);
        global::System.Array.Resize (ref yyVals, yyVals.Length+yyMax);
      }
      yyStates[yyTop] = yyState;
      yyVals[yyTop] = yyVal;
//t      if (debug != null) debug.push(yyState, yyVal);

      /*yyDiscarded:*/ while (true) {	// discarding a token does not change stack
        int yyN;
        if ((yyN = yyDefRed[yyState]) == 0) {	// else [default] reduce (yyN)
          if (yyToken < 0) {
            yyToken = yyLex.advance() ? yyLex.token() : 0;
//t            if (debug != null)
//t              debug.lex(yyState, yyToken, yyname(yyToken), yyLex.value());
          }
          if ((yyN = yySindex[yyState]) != 0 && ((yyN += yyToken) >= 0)
              && (yyN < yyTable.Length) && (yyCheck[yyN] == yyToken)) {
//t            if (debug != null)
//t              debug.shift(yyState, yyTable[yyN], yyErrorFlag-1);
            yyState = yyTable[yyN];		// shift to yyN
            yyVal = yyLex.value();
            yyToken = -1;
            if (yyErrorFlag > 0) -- yyErrorFlag;
            goto continue_yyLoop;
          }
          if ((yyN = yyRindex[yyState]) != 0 && (yyN += yyToken) >= 0
              && yyN < yyTable.Length && yyCheck[yyN] == yyToken)
            yyN = yyTable[yyN];			// reduce (yyN)
          else
            switch (yyErrorFlag) {
  
            case 0:
              yyExpectingState = yyState;
              // yyerror(String.Format ("syntax error, got token `{0}'", yyname (yyToken)), yyExpecting(yyState));
//t              if (debug != null) debug.error("syntax error");
              if (yyToken == 0 /*eof*/ || yyToken == eof_token) throw new yyParser.yyUnexpectedEof ();
              goto case 1;
            case 1: case 2:
              yyErrorFlag = 3;
              do {
                if ((yyN = yySindex[yyStates[yyTop]]) != 0
                    && (yyN += Token.yyErrorCode) >= 0 && yyN < yyTable.Length
                    && yyCheck[yyN] == Token.yyErrorCode) {
//t                  if (debug != null)
//t                    debug.shift(yyStates[yyTop], yyTable[yyN], 3);
                  yyState = yyTable[yyN];
                  yyVal = yyLex.value();
                  goto continue_yyLoop;
                }
//t                if (debug != null) debug.pop(yyStates[yyTop]);
              } while (-- yyTop >= 0);
//t              if (debug != null) debug.reject();
              throw new yyParser.yyException("irrecoverable syntax error");
  
            case 3:
              if (yyToken == 0) {
//t                if (debug != null) debug.reject();
                throw new yyParser.yyException("irrecoverable syntax error at end-of-file");
              }
//t              if (debug != null)
//t                debug.discard(yyState, yyToken, yyname(yyToken),
//t  							yyLex.value());
              yyToken = -1;
              goto continue_yyDiscarded;		// leave stack alone
            }
        }
        int yyV = yyTop + 1-yyLen[yyN];
//t        if (debug != null)
//t          debug.reduce(yyState, yyStates[yyV-1], yyN, YYRules.getRule (yyN), yyLen[yyN]);
        yyVal = yyV > yyTop ? null : yyVals[yyV]; // yyVal = yyDefault(yyV > yyTop ? null : yyVals[yyV]);
        switch (yyN) {
case 1:
#line 389 "cs-parser.jay"
  {
		Lexer.check_incorrect_doc_comment ();
	  }
  break;
case 2:
#line 390 "cs-parser.jay"
  { Lexer.CompleteOnEOF = false; }
  break;
case 6:
  case_6();
  break;
case 7:
#line 409 "cs-parser.jay"
  {
		module.AddAttributes ((Attributes) yyVals[0+yyTop], current_namespace);
	  }
  break;
case 8:
  case_8();
  break;
case 13:
  case_13();
  break;
case 14:
#line 454 "cs-parser.jay"
  {
		Error_SyntaxError (yyToken);
	  }
  break;
case 17:
  case_17();
  break;
case 18:
  case_18();
  break;
case 19:
  case_19();
  break;
case 20:
  case_20();
  break;
case 21:
  case_21();
  break;
case 22:
  case_22();
  break;
case 23:
  case_23();
  break;
case 24:
  case_24();
  break;
case 27:
  case_27();
  break;
case 28:
  case_28();
  break;
case 29:
  case_29();
  break;
case 30:
  case_30();
  break;
case 43:
  case_43();
  break;
case 44:
#line 638 "cs-parser.jay"
  {
		current_namespace.DeclarationFound = true;
	  }
  break;
case 45:
  case_45();
  break;
case 53:
  case_53();
  break;
case 54:
  case_54();
  break;
case 55:
  case_55();
  break;
case 56:
  case_56();
  break;
case 57:
  case_57();
  break;
case 58:
  case_58();
  break;
case 59:
  case_59();
  break;
case 60:
  case_60();
  break;
case 61:
  case_61();
  break;
case 62:
  case_62();
  break;
case 63:
#line 763 "cs-parser.jay"
  { yyVal = "event"; PushLocation (GetLocation (yyVals[0+yyTop])); }
  break;
case 64:
#line 764 "cs-parser.jay"
  { yyVal = "return"; PushLocation (GetLocation (yyVals[0+yyTop])); }
  break;
case 65:
#line 771 "cs-parser.jay"
  {
		yyVal = new List<Attribute> (4) { (Attribute) yyVals[0+yyTop] };
	  }
  break;
case 66:
  case_66();
  break;
case 67:
#line 788 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 68:
  case_68();
  break;
case 70:
#line 816 "cs-parser.jay"
  { yyVal = null; HadAttributeParens = false;  }
  break;
case 71:
  case_71();
  break;
case 72:
#line 828 "cs-parser.jay"
  { yyVal = null; }
  break;
case 73:
  case_73();
  break;
case 74:
  case_74();
  break;
case 75:
  case_75();
  break;
case 76:
  case_76();
  break;
case 77:
#line 872 "cs-parser.jay"
  {
	  	yyVal = new Argument ((Expression) yyVals[0+yyTop]);
	  }
  break;
case 79:
  case_79();
  break;
case 80:
#line 885 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 81:
  case_81();
  break;
case 82:
  case_82();
  break;
case 83:
#line 911 "cs-parser.jay"
  { yyVal = null; }
  break;
case 84:
#line 915 "cs-parser.jay"
  { 
		yyVal = Argument.AType.Ref;
	  }
  break;
case 85:
#line 919 "cs-parser.jay"
  { 
		yyVal = Argument.AType.Out;
	  }
  break;
case 88:
  case_88();
  break;
case 89:
  case_89();
  break;
case 103:
  case_103();
  break;
case 104:
  case_104();
  break;
case 105:
  case_105();
  break;
case 106:
#line 996 "cs-parser.jay"
  {
	  }
  break;
case 107:
  case_107();
  break;
case 108:
  case_108();
  break;
case 109:
  case_109();
  break;
case 110:
  case_110();
  break;
case 111:
  case_111();
  break;
case 112:
#line 1046 "cs-parser.jay"
  {
		Error_SyntaxError (yyToken);
	  }
  break;
case 113:
  case_113();
  break;
case 114:
  case_114();
  break;
case 115:
  case_115();
  break;
case 118:
#line 1095 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 119:
#line 1099 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 120:
  case_120();
  break;
case 121:
#line 1115 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 122:
  case_122();
  break;
case 123:
  case_123();
  break;
case 126:
  case_126();
  break;
case 127:
  case_127();
  break;
case 128:
  case_128();
  break;
case 129:
  case_129();
  break;
case 130:
#line 1194 "cs-parser.jay"
  {
		report.Error (1641, GetLocation (yyVals[-1+yyTop]), "A fixed size buffer field must have the array size specifier after the field name");
	  }
  break;
case 132:
  case_132();
  break;
case 133:
  case_133();
  break;
case 136:
#line 1224 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 137:
#line 1228 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 138:
  case_138();
  break;
case 139:
#line 1241 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 140:
  case_140();
  break;
case 143:
#line 1260 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 144:
#line 1264 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 145:
  case_145();
  break;
case 146:
#line 1280 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 147:
  case_147();
  break;
case 148:
  case_148();
  break;
case 151:
  case_151();
  break;
case 152:
  case_152();
  break;
case 153:
  case_153();
  break;
case 154:
#line 1348 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.All;
	  }
  break;
case 155:
  case_155();
  break;
case 156:
  case_156();
  break;
case 157:
#line 1387 "cs-parser.jay"
  {
		lexer.parsing_generic_declaration = true;
	  }
  break;
case 158:
  case_158();
  break;
case 159:
#line 1397 "cs-parser.jay"
  {
		lexer.ConstraintsParsing = true;
	  }
  break;
case 160:
  case_160();
  break;
case 161:
  case_161();
  break;
case 162:
  case_162();
  break;
case 166:
#line 1475 "cs-parser.jay"
  { savedLocation = GetLocation (yyVals[0+yyTop]); yyVal = null; }
  break;
case 167:
  case_167();
  break;
case 168:
  case_168();
  break;
case 169:
#line 1499 "cs-parser.jay"
  { yyVal = ParametersCompiled.EmptyReadOnlyParameters; }
  break;
case 171:
  case_171();
  break;
case 172:
  case_172();
  break;
case 173:
  case_173();
  break;
case 174:
  case_174();
  break;
case 175:
  case_175();
  break;
case 176:
  case_176();
  break;
case 177:
  case_177();
  break;
case 178:
#line 1571 "cs-parser.jay"
  {
		yyVal = new ParametersCompiled (new Parameter[] { (Parameter) yyVals[0+yyTop] } );
	  }
  break;
case 179:
#line 1575 "cs-parser.jay"
  {
		yyVal = new ParametersCompiled (new Parameter [] { new ArglistParameter (GetLocation (yyVals[0+yyTop])) }, true);
	  }
  break;
case 180:
  case_180();
  break;
case 181:
  case_181();
  break;
case 182:
  case_182();
  break;
case 183:
  case_183();
  break;
case 184:
  case_184();
  break;
case 185:
  case_185();
  break;
case 186:
  case_186();
  break;
case 187:
#line 1656 "cs-parser.jay"
  {
	  	++lexer.parsing_block;
	  }
  break;
case 188:
  case_188();
  break;
case 189:
#line 1697 "cs-parser.jay"
  { yyVal = Parameter.Modifier.NONE; }
  break;
case 191:
#line 1705 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 192:
  case_192();
  break;
case 193:
  case_193();
  break;
case 194:
  case_194();
  break;
case 195:
  case_195();
  break;
case 196:
  case_196();
  break;
case 197:
  case_197();
  break;
case 198:
  case_198();
  break;
case 199:
  case_199();
  break;
case 200:
  case_200();
  break;
case 201:
#line 1799 "cs-parser.jay"
  {
		Error_DuplicateParameterModifier (GetLocation (yyVals[-1+yyTop]), Parameter.Modifier.PARAMS);
	  }
  break;
case 202:
  case_202();
  break;
case 203:
  case_203();
  break;
case 204:
  case_204();
  break;
case 205:
  case_205();
  break;
case 206:
  case_206();
  break;
case 207:
#line 1849 "cs-parser.jay"
  {
		current_property = null;
	  }
  break;
case 208:
  case_208();
  break;
case 209:
  case_209();
  break;
case 211:
  case_211();
  break;
case 212:
  case_212();
  break;
case 215:
#line 1911 "cs-parser.jay"
  {
	  	valid_param_mod = ParameterModifierType.Params | ParameterModifierType.DefaultValue;
	  }
  break;
case 216:
  case_216();
  break;
case 217:
  case_217();
  break;
case 218:
#line 1957 "cs-parser.jay"
  {
		lbag.AppendToMember (current_property, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 219:
  case_219();
  break;
case 224:
  case_224();
  break;
case 225:
  case_225();
  break;
case 226:
  case_226();
  break;
case 227:
  case_227();
  break;
case 228:
  case_228();
  break;
case 230:
  case_230();
  break;
case 231:
  case_231();
  break;
case 232:
#line 2098 "cs-parser.jay"
  {
	  }
  break;
case 233:
  case_233();
  break;
case 234:
  case_234();
  break;
case 235:
  case_235();
  break;
case 236:
  case_236();
  break;
case 237:
#line 2138 "cs-parser.jay"
  {
		Error_SyntaxError (yyToken);	  
	  }
  break;
case 240:
  case_240();
  break;
case 241:
  case_241();
  break;
case 242:
#line 2163 "cs-parser.jay"
  {
		report.Error (525, GetLocation (yyVals[0+yyTop]), "Interfaces cannot contain fields or constants");
	  }
  break;
case 243:
#line 2167 "cs-parser.jay"
  {
		report.Error (525, GetLocation (yyVals[0+yyTop]), "Interfaces cannot contain fields or constants");
	  }
  break;
case 248:
#line 2175 "cs-parser.jay"
  {
	  	report.Error (567, GetLocation (yyVals[0+yyTop]), "Interfaces cannot contain operators");
	  }
  break;
case 249:
#line 2179 "cs-parser.jay"
  {
	  	report.Error (526, GetLocation (yyVals[0+yyTop]), "Interfaces cannot contain contructors");
	  }
  break;
case 250:
#line 2183 "cs-parser.jay"
  {
	  	report.Error (524, GetLocation (yyVals[0+yyTop]), "Interfaces cannot declare classes, structs, interfaces, delegates, or enumerations");
	  }
  break;
case 251:
#line 2189 "cs-parser.jay"
  {
	  }
  break;
case 252:
  case_252();
  break;
case 254:
  case_254();
  break;
case 255:
#line 2233 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.DefaultValue;
	  }
  break;
case 256:
  case_256();
  break;
case 258:
#line 2279 "cs-parser.jay"
  { yyVal = Operator.OpType.LogicalNot; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 259:
#line 2280 "cs-parser.jay"
  { yyVal = Operator.OpType.OnesComplement; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 260:
#line 2281 "cs-parser.jay"
  { yyVal = Operator.OpType.Increment; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 261:
#line 2282 "cs-parser.jay"
  { yyVal = Operator.OpType.Decrement; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 262:
#line 2283 "cs-parser.jay"
  { yyVal = Operator.OpType.True; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 263:
#line 2284 "cs-parser.jay"
  { yyVal = Operator.OpType.False; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 264:
#line 2286 "cs-parser.jay"
  { yyVal = Operator.OpType.Addition; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 265:
#line 2287 "cs-parser.jay"
  { yyVal = Operator.OpType.Subtraction; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 266:
#line 2289 "cs-parser.jay"
  { yyVal = Operator.OpType.Multiply; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 267:
#line 2290 "cs-parser.jay"
  {  yyVal = Operator.OpType.Division; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 268:
#line 2291 "cs-parser.jay"
  { yyVal = Operator.OpType.Modulus; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 269:
#line 2292 "cs-parser.jay"
  { yyVal = Operator.OpType.BitwiseAnd; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 270:
#line 2293 "cs-parser.jay"
  { yyVal = Operator.OpType.BitwiseOr; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 271:
#line 2294 "cs-parser.jay"
  { yyVal = Operator.OpType.ExclusiveOr; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 272:
#line 2295 "cs-parser.jay"
  { yyVal = Operator.OpType.LeftShift; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 273:
#line 2296 "cs-parser.jay"
  { yyVal = Operator.OpType.RightShift; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 274:
#line 2297 "cs-parser.jay"
  { yyVal = Operator.OpType.Equality; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 275:
#line 2298 "cs-parser.jay"
  { yyVal = Operator.OpType.Inequality; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 276:
#line 2299 "cs-parser.jay"
  { yyVal = Operator.OpType.GreaterThan; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 277:
#line 2300 "cs-parser.jay"
  { yyVal = Operator.OpType.LessThan; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 278:
#line 2301 "cs-parser.jay"
  { yyVal = Operator.OpType.GreaterThanOrEqual; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 279:
#line 2302 "cs-parser.jay"
  { yyVal = Operator.OpType.LessThanOrEqual; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 280:
#line 2309 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.DefaultValue;
	  }
  break;
case 281:
  case_281();
  break;
case 282:
#line 2332 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.DefaultValue;
	  }
  break;
case 283:
  case_283();
  break;
case 284:
  case_284();
  break;
case 285:
  case_285();
  break;
case 286:
  case_286();
  break;
case 287:
  case_287();
  break;
case 288:
  case_288();
  break;
case 289:
  case_289();
  break;
case 291:
#line 2442 "cs-parser.jay"
  { current_block = null; yyVal = null; }
  break;
case 294:
#line 2454 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 295:
  case_295();
  break;
case 296:
#line 2464 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 297:
  case_297();
  break;
case 298:
  case_298();
  break;
case 299:
  case_299();
  break;
case 300:
  case_300();
  break;
case 301:
  case_301();
  break;
case 302:
  case_302();
  break;
case 303:
  case_303();
  break;
case 304:
  case_304();
  break;
case 305:
  case_305();
  break;
case 306:
  case_306();
  break;
case 307:
  case_307();
  break;
case 309:
#line 2591 "cs-parser.jay"
  {
	  	++lexer.parsing_block;
	  }
  break;
case 310:
  case_310();
  break;
case 313:
#line 2609 "cs-parser.jay"
  {
		current_event_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 314:
#line 2613 "cs-parser.jay"
  {
		current_event_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 315:
  case_315();
  break;
case 316:
#line 2626 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 317:
  case_317();
  break;
case 318:
  case_318();
  break;
case 319:
#line 2651 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 322:
  case_322();
  break;
case 323:
  case_323();
  break;
case 324:
  case_324();
  break;
case 325:
  case_325();
  break;
case 326:
  case_326();
  break;
case 327:
  case_327();
  break;
case 328:
  case_328();
  break;
case 329:
  case_329();
  break;
case 331:
  case_331();
  break;
case 332:
  case_332();
  break;
case 333:
  case_333();
  break;
case 334:
  case_334();
  break;
case 335:
  case_335();
  break;
case 336:
  case_336();
  break;
case 338:
  case_338();
  break;
case 339:
  case_339();
  break;
case 342:
#line 2839 "cs-parser.jay"
  {
		lbag.AppendToMember (current_container, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 344:
  case_344();
  break;
case 345:
  case_345();
  break;
case 346:
  case_346();
  break;
case 347:
  case_347();
  break;
case 348:
  case_348();
  break;
case 350:
#line 2913 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out | ParameterModifierType.Params | ParameterModifierType.DefaultValue;
	  }
  break;
case 351:
  case_351();
  break;
case 352:
#line 2932 "cs-parser.jay"
  {
		lexer.ConstraintsParsing = false;
	  }
  break;
case 353:
  case_353();
  break;
case 355:
  case_355();
  break;
case 357:
  case_357();
  break;
case 358:
  case_358();
  break;
case 360:
  case_360();
  break;
case 361:
  case_361();
  break;
case 362:
  case_362();
  break;
case 363:
  case_363();
  break;
case 365:
  case_365();
  break;
case 366:
  case_366();
  break;
case 367:
  case_367();
  break;
case 368:
  case_368();
  break;
case 369:
#line 3062 "cs-parser.jay"
  {
		lexer.parsing_generic_declaration = true;
	  }
  break;
case 370:
  case_370();
  break;
case 371:
  case_371();
  break;
case 373:
  case_373();
  break;
case 374:
  case_374();
  break;
case 375:
  case_375();
  break;
case 376:
  case_376();
  break;
case 377:
  case_377();
  break;
case 378:
  case_378();
  break;
case 380:
  case_380();
  break;
case 381:
  case_381();
  break;
case 382:
  case_382();
  break;
case 383:
  case_383();
  break;
case 384:
  case_384();
  break;
case 386:
#line 3187 "cs-parser.jay"
  {
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 387:
#line 3194 "cs-parser.jay"
  {
		lexer.parsing_generic_declaration = true;
	  }
  break;
case 393:
  case_393();
  break;
case 395:
#line 3224 "cs-parser.jay"
  {
		yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 396:
  case_396();
  break;
case 397:
#line 3243 "cs-parser.jay"
  {
		yyVal = new ComposedCast ((ATypeNameExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 399:
  case_399();
  break;
case 400:
  case_400();
  break;
case 401:
#line 3264 "cs-parser.jay"
  {
		yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 402:
#line 3268 "cs-parser.jay"
  {
		yyVal = new ComposedCast (new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[-1+yyTop])), (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 403:
  case_403();
  break;
case 404:
  case_404();
  break;
case 405:
  case_405();
  break;
case 406:
#line 3302 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Object, GetLocation (yyVals[0+yyTop])); }
  break;
case 407:
#line 3303 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.String, GetLocation (yyVals[0+yyTop])); }
  break;
case 408:
#line 3304 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Bool, GetLocation (yyVals[0+yyTop])); }
  break;
case 409:
#line 3305 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Decimal, GetLocation (yyVals[0+yyTop])); }
  break;
case 410:
#line 3306 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Float, GetLocation (yyVals[0+yyTop])); }
  break;
case 411:
#line 3307 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Double, GetLocation (yyVals[0+yyTop])); }
  break;
case 413:
#line 3312 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.SByte, GetLocation (yyVals[0+yyTop])); }
  break;
case 414:
#line 3313 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Byte, GetLocation (yyVals[0+yyTop])); }
  break;
case 415:
#line 3314 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Short, GetLocation (yyVals[0+yyTop])); }
  break;
case 416:
#line 3315 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.UShort, GetLocation (yyVals[0+yyTop])); }
  break;
case 417:
#line 3316 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Int, GetLocation (yyVals[0+yyTop])); }
  break;
case 418:
#line 3317 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.UInt, GetLocation (yyVals[0+yyTop])); }
  break;
case 419:
#line 3318 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Long, GetLocation (yyVals[0+yyTop])); }
  break;
case 420:
#line 3319 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.ULong, GetLocation (yyVals[0+yyTop])); }
  break;
case 421:
#line 3320 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Char, GetLocation (yyVals[0+yyTop])); }
  break;
case 443:
  case_443();
  break;
case 447:
#line 3363 "cs-parser.jay"
  { yyVal = new NullLiteral (GetLocation (yyVals[0+yyTop])); }
  break;
case 448:
#line 3367 "cs-parser.jay"
  { yyVal = new BoolLiteral (compiler.BuiltinTypes, true, GetLocation (yyVals[0+yyTop])); }
  break;
case 449:
#line 3368 "cs-parser.jay"
  { yyVal = new BoolLiteral (compiler.BuiltinTypes, false, GetLocation (yyVals[0+yyTop])); }
  break;
case 454:
  case_454();
  break;
case 455:
#line 3401 "cs-parser.jay"
  {
		yyVal = new ParenthesizedExpression ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }
  break;
case 456:
  case_456();
  break;
case 457:
  case_457();
  break;
case 458:
  case_458();
  break;
case 459:
  case_459();
  break;
case 460:
  case_460();
  break;
case 461:
  case_461();
  break;
case 462:
  case_462();
  break;
case 463:
  case_463();
  break;
case 464:
#line 3465 "cs-parser.jay"
  {
		yyVal = new CompletionMemberAccess ((Expression) yyVals[-2+yyTop], null,GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 465:
  case_465();
  break;
case 466:
#line 3473 "cs-parser.jay"
  {
		yyVal = new CompletionMemberAccess ((Expression) yyVals[-2+yyTop], null, lexer.Location);
	  }
  break;
case 467:
  case_467();
  break;
case 468:
  case_468();
  break;
case 469:
  case_469();
  break;
case 470:
  case_470();
  break;
case 471:
#line 3503 "cs-parser.jay"
  { yyVal = null; }
  break;
case 473:
  case_473();
  break;
case 474:
  case_474();
  break;
case 475:
#line 3525 "cs-parser.jay"
  { yyVal = null; }
  break;
case 476:
#line 3529 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	}
  break;
case 477:
  case_477();
  break;
case 478:
  case_478();
  break;
case 479:
  case_479();
  break;
case 480:
  case_480();
  break;
case 481:
  case_481();
  break;
case 482:
#line 3568 "cs-parser.jay"
  {
		yyVal = new CompletionElementInitializer (null, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 483:
  case_483();
  break;
case 484:
  case_484();
  break;
case 485:
  case_485();
  break;
case 486:
  case_486();
  break;
case 489:
#line 3608 "cs-parser.jay"
  { yyVal = null; }
  break;
case 491:
  case_491();
  break;
case 492:
  case_492();
  break;
case 493:
  case_493();
  break;
case 494:
  case_494();
  break;
case 495:
  case_495();
  break;
case 496:
#line 3662 "cs-parser.jay"
  {
		yyVal = new Argument ((Expression) yyVals[0+yyTop]);
	  }
  break;
case 500:
  case_500();
  break;
case 501:
  case_501();
  break;
case 502:
  case_502();
  break;
case 503:
  case_503();
  break;
case 505:
  case_505();
  break;
case 506:
  case_506();
  break;
case 507:
  case_507();
  break;
case 508:
  case_508();
  break;
case 509:
  case_509();
  break;
case 510:
  case_510();
  break;
case 511:
  case_511();
  break;
case 512:
  case_512();
  break;
case 513:
#line 3766 "cs-parser.jay"
  {
	  	yyVal = new Argument ((Expression) yyVals[0+yyTop]);
	  }
  break;
case 515:
#line 3774 "cs-parser.jay"
  {
		yyVal = new This (GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 516:
  case_516();
  break;
case 517:
  case_517();
  break;
case 518:
#line 3794 "cs-parser.jay"
  {
		yyVal = new UnaryMutator (UnaryMutator.Mode.PostIncrement, (Expression) yyVals[-1+yyTop], GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 519:
#line 3801 "cs-parser.jay"
  {
		yyVal = new UnaryMutator (UnaryMutator.Mode.PostDecrement, (Expression) yyVals[-1+yyTop], GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 520:
  case_520();
  break;
case 521:
  case_521();
  break;
case 522:
  case_522();
  break;
case 523:
  case_523();
  break;
case 524:
  case_524();
  break;
case 525:
  case_525();
  break;
case 526:
  case_526();
  break;
case 527:
#line 3868 "cs-parser.jay"
  {
		++lexer.parsing_type;
	  }
  break;
case 528:
  case_528();
  break;
case 529:
  case_529();
  break;
case 530:
#line 3890 "cs-parser.jay"
  {
		yyVal = new EmptyCompletion ();
	  }
  break;
case 533:
#line 3899 "cs-parser.jay"
  { yyVal = null; }
  break;
case 535:
  case_535();
  break;
case 536:
  case_536();
  break;
case 537:
#line 3921 "cs-parser.jay"
  {
		yyVal = new EmptyCompletion ();
	  }
  break;
case 538:
#line 3925 "cs-parser.jay"
  {
	  	yyVal = yyVals[-1+yyTop];
	  }
  break;
case 539:
  case_539();
  break;
case 540:
  case_540();
  break;
case 541:
  case_541();
  break;
case 542:
  case_542();
  break;
case 546:
  case_546();
  break;
case 547:
  case_547();
  break;
case 548:
  case_548();
  break;
case 549:
#line 3985 "cs-parser.jay"
  {
		yyVal = 2;
	  }
  break;
case 550:
#line 3989 "cs-parser.jay"
  {
		yyVal = ((int) yyVals[-1+yyTop]) + 1;
	  }
  break;
case 551:
#line 3996 "cs-parser.jay"
  {
		yyVal = null;
	  }
  break;
case 552:
#line 4000 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 553:
  case_553();
  break;
case 554:
  case_554();
  break;
case 555:
  case_555();
  break;
case 556:
  case_556();
  break;
case 557:
  case_557();
  break;
case 559:
  case_559();
  break;
case 560:
  case_560();
  break;
case 561:
  case_561();
  break;
case 562:
  case_562();
  break;
case 563:
  case_563();
  break;
case 564:
  case_564();
  break;
case 565:
  case_565();
  break;
case 566:
  case_566();
  break;
case 567:
  case_567();
  break;
case 568:
  case_568();
  break;
case 569:
#line 4133 "cs-parser.jay"
  {
		start_anonymous (false, (ParametersCompiled) yyVals[0+yyTop], false, GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 570:
  case_570();
  break;
case 571:
#line 4146 "cs-parser.jay"
  {
		start_anonymous (false, (ParametersCompiled) yyVals[0+yyTop], true, GetLocation (yyVals[-2+yyTop]));
	  }
  break;
case 572:
  case_572();
  break;
case 573:
#line 4163 "cs-parser.jay"
  {
		yyVal = ParametersCompiled.Undefined;
	  }
  break;
case 575:
#line 4171 "cs-parser.jay"
  {
	  	valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out;
	  }
  break;
case 576:
  case_576();
  break;
case 577:
  case_577();
  break;
case 579:
#line 4197 "cs-parser.jay"
  {
		yyVal = new Unary (Unary.Operator.LogicalNot, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 580:
#line 4201 "cs-parser.jay"
  {
		yyVal = new Unary (Unary.Operator.OnesComplement, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 581:
  case_581();
  break;
case 582:
  case_582();
  break;
case 583:
  case_583();
  break;
case 584:
  case_584();
  break;
case 585:
  case_585();
  break;
case 586:
  case_586();
  break;
case 588:
#line 4265 "cs-parser.jay"
  { 
	  	yyVal = new Unary (Unary.Operator.UnaryPlus, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 589:
#line 4269 "cs-parser.jay"
  { 
		yyVal = new Unary (Unary.Operator.UnaryNegation, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 590:
#line 4273 "cs-parser.jay"
  {
		yyVal = new UnaryMutator (UnaryMutator.Mode.PreIncrement, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 591:
#line 4277 "cs-parser.jay"
  {
		yyVal = new UnaryMutator (UnaryMutator.Mode.PreDecrement, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 592:
#line 4281 "cs-parser.jay"
  {
		yyVal = new Indirection ((Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 593:
#line 4285 "cs-parser.jay"
  {
		yyVal = new Unary (Unary.Operator.AddressOf, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 594:
  case_594();
  break;
case 595:
  case_595();
  break;
case 596:
  case_596();
  break;
case 597:
  case_597();
  break;
case 598:
  case_598();
  break;
case 599:
  case_599();
  break;
case 601:
  case_601();
  break;
case 602:
  case_602();
  break;
case 603:
  case_603();
  break;
case 604:
  case_604();
  break;
case 605:
  case_605();
  break;
case 606:
  case_606();
  break;
case 608:
  case_608();
  break;
case 609:
  case_609();
  break;
case 610:
  case_610();
  break;
case 611:
  case_611();
  break;
case 612:
#line 4393 "cs-parser.jay"
  {
		yyVal = new As ((Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 613:
  case_613();
  break;
case 614:
  case_614();
  break;
case 615:
  case_615();
  break;
case 616:
  case_616();
  break;
case 617:
  case_617();
  break;
case 619:
  case_619();
  break;
case 621:
#line 4445 "cs-parser.jay"
  {
		yyVal = new Unary (Unary.Operator.UnaryPlus, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 622:
#line 4449 "cs-parser.jay"
  {
		yyVal = new Unary (Unary.Operator.UnaryNegation, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 623:
  case_623();
  break;
case 624:
  case_624();
  break;
case 628:
  case_628();
  break;
case 629:
  case_629();
  break;
case 630:
  case_630();
  break;
case 631:
  case_631();
  break;
case 633:
  case_633();
  break;
case 634:
  case_634();
  break;
case 635:
  case_635();
  break;
case 636:
  case_636();
  break;
case 637:
  case_637();
  break;
case 638:
  case_638();
  break;
case 639:
  case_639();
  break;
case 640:
  case_640();
  break;
case 642:
  case_642();
  break;
case 643:
  case_643();
  break;
case 644:
  case_644();
  break;
case 645:
  case_645();
  break;
case 647:
  case_647();
  break;
case 648:
  case_648();
  break;
case 650:
  case_650();
  break;
case 651:
  case_651();
  break;
case 653:
  case_653();
  break;
case 654:
  case_654();
  break;
case 656:
  case_656();
  break;
case 657:
  case_657();
  break;
case 659:
  case_659();
  break;
case 660:
  case_660();
  break;
case 662:
  case_662();
  break;
case 664:
  case_664();
  break;
case 665:
  case_665();
  break;
case 666:
  case_666();
  break;
case 667:
  case_667();
  break;
case 668:
  case_668();
  break;
case 669:
  case_669();
  break;
case 670:
  case_670();
  break;
case 671:
  case_671();
  break;
case 672:
  case_672();
  break;
case 673:
  case_673();
  break;
case 674:
  case_674();
  break;
case 675:
  case_675();
  break;
case 676:
  case_676();
  break;
case 677:
  case_677();
  break;
case 678:
  case_678();
  break;
case 679:
  case_679();
  break;
case 680:
  case_680();
  break;
case 681:
  case_681();
  break;
case 682:
  case_682();
  break;
case 683:
  case_683();
  break;
case 684:
  case_684();
  break;
case 685:
#line 4821 "cs-parser.jay"
  { yyVal = ParametersCompiled.EmptyReadOnlyParameters; }
  break;
case 686:
  case_686();
  break;
case 687:
#line 4832 "cs-parser.jay"
  {
		start_block (Location.Null);
	  }
  break;
case 688:
  case_688();
  break;
case 690:
  case_690();
  break;
case 692:
  case_692();
  break;
case 693:
  case_693();
  break;
case 694:
  case_694();
  break;
case 695:
  case_695();
  break;
case 696:
  case_696();
  break;
case 697:
  case_697();
  break;
case 698:
  case_698();
  break;
case 699:
#line 4899 "cs-parser.jay"
  {
	  	valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out;
	  }
  break;
case 700:
  case_700();
  break;
case 701:
  case_701();
  break;
case 702:
#line 4913 "cs-parser.jay"
  {
	  	valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out;	  
	  }
  break;
case 703:
  case_703();
  break;
case 704:
  case_704();
  break;
case 710:
#line 4938 "cs-parser.jay"
  {
		yyVal = new ArglistAccess (GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 711:
  case_711();
  break;
case 712:
  case_712();
  break;
case 713:
  case_713();
  break;
case 715:
#line 4967 "cs-parser.jay"
  {
		yyVal = new BooleanExpression ((Expression) yyVals[0+yyTop]);
	  }
  break;
case 716:
#line 4974 "cs-parser.jay"
  {
	  	yyVal = null;
	  }
  break;
case 718:
  case_718();
  break;
case 719:
#line 4995 "cs-parser.jay"
  {
	  	yyVal = null;
	  }
  break;
case 720:
#line 4999 "cs-parser.jay"
  {
		yyVal = null;
	  }
  break;
case 721:
#line 5003 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 722:
#line 5007 "cs-parser.jay"
  {
		yyVal = yyVals[-1+yyTop];
	  }
  break;
case 723:
  case_723();
  break;
case 724:
  case_724();
  break;
case 725:
#line 5032 "cs-parser.jay"
  {
	  }
  break;
case 726:
  case_726();
  break;
case 727:
  case_727();
  break;
case 728:
  case_728();
  break;
case 729:
  case_729();
  break;
case 730:
#line 5084 "cs-parser.jay"
  { yyVal = null; }
  break;
case 731:
#line 5086 "cs-parser.jay"
  { yyVal = yyVals[0+yyTop]; StoreModifierLocation (Modifiers.PARTIAL, GetLocation (yyVals[0+yyTop])); }
  break;
case 732:
  case_732();
  break;
case 733:
#line 5099 "cs-parser.jay"
  {
		lexer.parsing_modifiers = false;		
	  }
  break;
case 735:
  case_735();
  break;
case 736:
  case_736();
  break;
case 737:
  case_737();
  break;
case 738:
  case_738();
  break;
case 739:
  case_739();
  break;
case 740:
  case_740();
  break;
case 741:
  case_741();
  break;
case 742:
  case_742();
  break;
case 743:
  case_743();
  break;
case 744:
  case_744();
  break;
case 745:
  case_745();
  break;
case 746:
  case_746();
  break;
case 747:
  case_747();
  break;
case 748:
  case_748();
  break;
case 749:
  case_749();
  break;
case 750:
  case_750();
  break;
case 753:
  case_753();
  break;
case 754:
  case_754();
  break;
case 756:
#line 5229 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 757:
  case_757();
  break;
case 758:
  case_758();
  break;
case 759:
  case_759();
  break;
case 760:
  case_760();
  break;
case 761:
  case_761();
  break;
case 762:
  case_762();
  break;
case 763:
  case_763();
  break;
case 764:
  case_764();
  break;
case 765:
#line 5322 "cs-parser.jay"
  {
		yyVal = new SpecialContraintExpr (SpecialConstraint.Class, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 766:
#line 5326 "cs-parser.jay"
  {
		yyVal = new SpecialContraintExpr (SpecialConstraint.Struct, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 767:
#line 5333 "cs-parser.jay"
  {
		yyVal = null;
	  }
  break;
case 768:
  case_768();
  break;
case 769:
  case_769();
  break;
case 770:
  case_770();
  break;
case 771:
  case_771();
  break;
case 772:
#line 5378 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 773:
  case_773();
  break;
case 774:
  case_774();
  break;
case 775:
  case_775();
  break;
case 776:
  case_776();
  break;
case 777:
  case_777();
  break;
case 778:
  case_778();
  break;
case 779:
  case_779();
  break;
case 784:
#line 5440 "cs-parser.jay"
  {
		current_block.AddStatement ((Statement) yyVals[0+yyTop]);
	  }
  break;
case 785:
#line 5444 "cs-parser.jay"
  {
		current_block.AddStatement ((Statement) yyVals[0+yyTop]);
	  }
  break;
case 787:
  case_787();
  break;
case 788:
  case_788();
  break;
case 791:
#line 5478 "cs-parser.jay"
  {
		current_block.AddStatement ((Statement) yyVals[0+yyTop]);
	  }
  break;
case 792:
#line 5482 "cs-parser.jay"
  {
		current_block.AddStatement ((Statement) yyVals[0+yyTop]);
	  }
  break;
case 821:
  case_821();
  break;
case 822:
  case_822();
  break;
case 823:
  case_823();
  break;
case 824:
  case_824();
  break;
case 825:
  case_825();
  break;
case 828:
  case_828();
  break;
case 829:
  case_829();
  break;
case 830:
  case_830();
  break;
case 834:
  case_834();
  break;
case 835:
#line 5633 "cs-parser.jay"
  {
		yyVal = ComposedTypeSpecifier.CreatePointer (GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 837:
#line 5641 "cs-parser.jay"
  {
	  	yyVal = Error_AwaitAsIdentifier (yyVals[0+yyTop]);
	  }
  break;
case 838:
  case_838();
  break;
case 839:
  case_839();
  break;
case 840:
  case_840();
  break;
case 841:
  case_841();
  break;
case 843:
  case_843();
  break;
case 845:
  case_845();
  break;
case 846:
  case_846();
  break;
case 850:
  case_850();
  break;
case 853:
  case_853();
  break;
case 854:
  case_854();
  break;
case 855:
#line 5755 "cs-parser.jay"
  {
		report.Error (145, lexer.Location, "A const field requires a value to be provided");
	  }
  break;
case 856:
  case_856();
  break;
case 861:
  case_861();
  break;
case 863:
  case_863();
  break;
case 864:
  case_864();
  break;
case 865:
  case_865();
  break;
case 866:
#line 5805 "cs-parser.jay"
  { yyVal = yyVals[-1+yyTop]; }
  break;
case 867:
  case_867();
  break;
case 868:
#line 5815 "cs-parser.jay"
  { yyVal = yyVals[-1+yyTop]; }
  break;
case 869:
#line 5816 "cs-parser.jay"
  { yyVal = yyVals[-1+yyTop]; }
  break;
case 870:
  case_870();
  break;
case 871:
  case_871();
  break;
case 872:
  case_872();
  break;
case 875:
  case_875();
  break;
case 876:
  case_876();
  break;
case 877:
  case_877();
  break;
case 878:
#line 5888 "cs-parser.jay"
  {
		start_block (GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 879:
  case_879();
  break;
case 880:
  case_880();
  break;
case 881:
#line 5908 "cs-parser.jay"
  {
		report.Warning (1522, 1, current_block.StartLocation, "Empty switch block"); 
	  }
  break;
case 885:
#line 5918 "cs-parser.jay"
  {
		Error_SyntaxError (yyToken);
	  }
  break;
case 887:
  case_887();
  break;
case 888:
#line 5935 "cs-parser.jay"
  {
		current_block.AddStatement ((Statement) yyVals[0+yyTop]);
	  }
  break;
case 889:
  case_889();
  break;
case 890:
  case_890();
  break;
case 891:
#line 5952 "cs-parser.jay"
  {
		yyVal = new SwitchLabel (null, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 896:
  case_896();
  break;
case 897:
  case_897();
  break;
case 898:
  case_898();
  break;
case 899:
  case_899();
  break;
case 900:
  case_900();
  break;
case 901:
  case_901();
  break;
case 902:
#line 6013 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 903:
  case_903();
  break;
case 904:
#line 6028 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 905:
  case_905();
  break;
case 906:
  case_906();
  break;
case 907:
#line 6049 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 908:
  case_908();
  break;
case 909:
  case_909();
  break;
case 910:
  case_910();
  break;
case 911:
#line 6083 "cs-parser.jay"
  { yyVal = new EmptyStatement (lexer.Location); }
  break;
case 913:
  case_913();
  break;
case 914:
  case_914();
  break;
case 916:
#line 6107 "cs-parser.jay"
  { yyVal = null; }
  break;
case 918:
#line 6112 "cs-parser.jay"
  { yyVal = new EmptyStatement (lexer.Location); }
  break;
case 922:
  case_922();
  break;
case 923:
  case_923();
  break;
case 924:
  case_924();
  break;
case 925:
  case_925();
  break;
case 926:
  case_926();
  break;
case 927:
  case_927();
  break;
case 928:
  case_928();
  break;
case 935:
  case_935();
  break;
case 936:
  case_936();
  break;
case 937:
  case_937();
  break;
case 938:
  case_938();
  break;
case 939:
  case_939();
  break;
case 940:
  case_940();
  break;
case 941:
  case_941();
  break;
case 942:
  case_942();
  break;
case 943:
  case_943();
  break;
case 944:
  case_944();
  break;
case 945:
  case_945();
  break;
case 946:
  case_946();
  break;
case 947:
  case_947();
  break;
case 948:
  case_948();
  break;
case 949:
  case_949();
  break;
case 952:
#line 6358 "cs-parser.jay"
  {
		yyVal = new TryCatch ((Block) yyVals[-1+yyTop], (List<Catch>) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]), false);
	  }
  break;
case 953:
  case_953();
  break;
case 954:
  case_954();
  break;
case 955:
  case_955();
  break;
case 956:
  case_956();
  break;
case 957:
  case_957();
  break;
case 960:
  case_960();
  break;
case 961:
  case_961();
  break;
case 962:
  case_962();
  break;
case 963:
  case_963();
  break;
case 964:
  case_964();
  break;
case 966:
  case_966();
  break;
case 967:
#line 6483 "cs-parser.jay"
  {
		yyVal = new Checked ((Block) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 968:
#line 6490 "cs-parser.jay"
  {
		yyVal = new Unchecked ((Block) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 969:
  case_969();
  break;
case 970:
#line 6500 "cs-parser.jay"
  {
		yyVal = new Unsafe ((Block) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }
  break;
case 971:
  case_971();
  break;
case 972:
  case_972();
  break;
case 973:
  case_973();
  break;
case 974:
  case_974();
  break;
case 975:
  case_975();
  break;
case 976:
  case_976();
  break;
case 977:
  case_977();
  break;
case 978:
  case_978();
  break;
case 979:
  case_979();
  break;
case 980:
  case_980();
  break;
case 982:
  case_982();
  break;
case 983:
#line 6605 "cs-parser.jay"
  {
		Error_MissingInitializer (lexer.Location);
	  }
  break;
case 984:
  case_984();
  break;
case 985:
  case_985();
  break;
case 986:
  case_986();
  break;
case 987:
  case_987();
  break;
case 988:
  case_988();
  break;
case 989:
  case_989();
  break;
case 990:
  case_990();
  break;
case 991:
  case_991();
  break;
case 992:
  case_992();
  break;
case 993:
#line 6710 "cs-parser.jay"
  {
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 994:
  case_994();
  break;
case 995:
#line 6725 "cs-parser.jay"
  {
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 996:
  case_996();
  break;
case 997:
  case_997();
  break;
case 998:
  case_998();
  break;
case 1000:
  case_1000();
  break;
case 1001:
  case_1001();
  break;
case 1002:
#line 6789 "cs-parser.jay"
  {
	  	current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 1003:
  case_1003();
  break;
case 1004:
  case_1004();
  break;
case 1005:
  case_1005();
  break;
case 1006:
  case_1006();
  break;
case 1007:
#line 6828 "cs-parser.jay"
  {
	  	yyVal = new object[] { yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]) };
	  }
  break;
case 1008:
  case_1008();
  break;
case 1010:
  case_1010();
  break;
case 1016:
#line 6857 "cs-parser.jay"
  {
	  	current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 1017:
  case_1017();
  break;
case 1018:
#line 6876 "cs-parser.jay"
  {
	  	current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 1019:
  case_1019();
  break;
case 1020:
  case_1020();
  break;
case 1021:
  case_1021();
  break;
case 1022:
  case_1022();
  break;
case 1023:
  case_1023();
  break;
case 1024:
  case_1024();
  break;
case 1025:
  case_1025();
  break;
case 1026:
  case_1026();
  break;
case 1027:
  case_1027();
  break;
case 1029:
  case_1029();
  break;
case 1030:
  case_1030();
  break;
case 1031:
  case_1031();
  break;
case 1033:
  case_1033();
  break;
case 1034:
  case_1034();
  break;
case 1036:
  case_1036();
  break;
case 1037:
  case_1037();
  break;
case 1038:
#line 7077 "cs-parser.jay"
  {
		yyVal = new Linq.OrderByAscending ((Linq.QueryBlock) current_block, (Expression)yyVals[0+yyTop]);	
	  }
  break;
case 1039:
  case_1039();
  break;
case 1040:
  case_1040();
  break;
case 1041:
#line 7094 "cs-parser.jay"
  {
		yyVal = new Linq.ThenByAscending ((Linq.QueryBlock) current_block, (Expression)yyVals[0+yyTop]);	
	  }
  break;
case 1042:
  case_1042();
  break;
case 1043:
  case_1043();
  break;
case 1045:
  case_1045();
  break;
case 1046:
  case_1046();
  break;
case 1049:
  case_1049();
  break;
case 1050:
  case_1050();
  break;
case 1058:
#line 7219 "cs-parser.jay"
  {
		module.DocumentationBuilder.ParsedName = (MemberName) yyVals[0+yyTop];
	  }
  break;
case 1059:
#line 7226 "cs-parser.jay"
  {
		module.DocumentationBuilder.ParsedParameters = (List<DocumentationParameter>)yyVals[0+yyTop];
	  }
  break;
case 1060:
  case_1060();
  break;
case 1061:
  case_1061();
  break;
case 1062:
  case_1062();
  break;
case 1063:
#line 7249 "cs-parser.jay"
  {
		yyVal = new MemberName ((MemberName) yyVals[-2+yyTop], MemberCache.IndexerNameAlias, Location.Null);
	  }
  break;
case 1064:
#line 7253 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out;
	  }
  break;
case 1065:
  case_1065();
  break;
case 1066:
  case_1066();
  break;
case 1067:
  case_1067();
  break;
case 1068:
  case_1068();
  break;
case 1070:
#line 7289 "cs-parser.jay"
  {
		yyVal = new MemberName (((MemberName) yyVals[-2+yyTop]), (MemberName) yyVals[0+yyTop]);
	  }
  break;
case 1072:
#line 7297 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out;
	  }
  break;
case 1073:
#line 7301 "cs-parser.jay"
  {
		yyVal = yyVals[-1+yyTop];
	  }
  break;
case 1074:
#line 7308 "cs-parser.jay"
  {
		yyVal = new List<DocumentationParameter> (0);
	  }
  break;
case 1076:
  case_1076();
  break;
case 1077:
  case_1077();
  break;
case 1078:
  case_1078();
  break;
#line default
        }
        yyTop -= yyLen[yyN];
        yyState = yyStates[yyTop];
        int yyM = yyLhs[yyN];
        if (yyState == 0 && yyM == 0) {
//t          if (debug != null) debug.shift(0, yyFinal);
          yyState = yyFinal;
          if (yyToken < 0) {
            yyToken = yyLex.advance() ? yyLex.token() : 0;
//t            if (debug != null)
//t               debug.lex(yyState, yyToken,yyname(yyToken), yyLex.value());
          }
          if (yyToken == 0) {
//t            if (debug != null) debug.accept(yyVal);
            return yyVal;
          }
          goto continue_yyLoop;
        }
        if (((yyN = yyGindex[yyM]) != 0) && ((yyN += yyState) >= 0)
            && (yyN < yyTable.Length) && (yyCheck[yyN] == yyState))
          yyState = yyTable[yyN];
        else
          yyState = yyDgoto[yyM];
//t        if (debug != null) debug.shift(yyStates[yyTop], yyState);
	 goto continue_yyLoop;
      continue_yyDiscarded: ;	// implements the named-loop continue: 'continue yyDiscarded'
      }
    continue_yyLoop: ;		// implements the named-loop continue: 'continue yyLoop'
    }
  }

/*
 All more than 3 lines long rules are wrapped into a method
*/
void case_6()
#line 397 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {
			Attributes attrs = (Attributes) yyVals[0+yyTop];
			report.Error (1730, attrs.Attrs [0].Location,
				"Assembly and module attributes must precede all other elements except using clauses and extern alias declarations");

			current_namespace.UnattachedAttributes = attrs;
		}
	  }

void case_8()
#line 411 "cs-parser.jay"
{
		if (yyToken == Token.EXTERN_ALIAS)
			report.Error (439, lexer.Location, "An extern alias declaration must precede all other elements");
		else
			Error_SyntaxError (yyToken);
	  }

void case_13()
#line 431 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-2+yyTop];
		string s = lt.Value;
		if (s != "alias") {
			syntax_error (lt.Location, "`alias' expected");
		} else {
			if (lang_version == LanguageVersion.ISO_1)
				FeatureIsNotAvailable (lt.Location, "external alias");

			lt = (LocatedToken) yyVals[-1+yyTop];
			if (lt.Value == QualifiedAliasMember.GlobalAlias) {
				RootNamespace.Error_GlobalNamespaceRedefined (report, lt.Location);
			}
			
			var na = new UsingExternAlias (new SimpleMemberName (lt.Value, lt.Location), GetLocation (yyVals[-3+yyTop]));
			current_namespace.AddUsing (na);
			
			lbag.AddLocation (na, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
		}
	  }

void case_17()
#line 464 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_18()
#line 472 "cs-parser.jay"
{
		var un = new UsingNamespace ((ATypeNameExpression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		current_namespace.AddUsing (un);
		
		lbag.AddLocation (un, GetLocation (yyVals[0+yyTop]));
	  }

void case_19()
#line 479 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-3+yyTop];
		if (lang_version != LanguageVersion.ISO_1 && lt.Value == "global") {
			report.Warning (440, 2, lt.Location,
			 "An alias named `global' will not be used when resolving `global::'. The global namespace will be used instead");
		}

		var un = new UsingAliasNamespace (new SimpleMemberName (lt.Value, lt.Location), (ATypeNameExpression) yyVals[-1+yyTop], GetLocation (yyVals[-4+yyTop]));
		current_namespace.AddUsing (un);
		lbag.AddLocation (un, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_20()
#line 491 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	 }

void case_21()
#line 504 "cs-parser.jay"
{
		Attributes attrs = (Attributes) yyVals[-2+yyTop];
		var name = (MemberName) yyVals[0+yyTop];
		if (attrs != null) {
			bool valid_global_attrs = true;
			if ((current_namespace.DeclarationFound || current_namespace != file)) {
				valid_global_attrs = false;
			} else {
				foreach (var a in attrs.Attrs) {
					if (a.ExplicitTarget == "assembly" || a.ExplicitTarget == "module")
						continue;
						
					valid_global_attrs = false;
					break;
				}
			}
			
			if (!valid_global_attrs)
				report.Error (1671, name.Location, "A namespace declaration cannot have modifiers or attributes");
		}
	
		module.AddAttributes (attrs, current_namespace);
		
		var ns = new NamespaceContainer (name, current_namespace);
		current_namespace.AddTypeContainer (ns);
		current_container = current_namespace = ns;
	  }

void case_22()
#line 532 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_23()
#line 537 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null)
			lbag.AddLocation (current_container, GetLocation (yyVals[-9+yyTop]), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
		else
			lbag.AddLocation (current_container, GetLocation (yyVals[-9+yyTop]), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  
		current_container = current_namespace = current_namespace.Parent;
	  }

void case_24()
#line 546 "cs-parser.jay"
{
		report.Error (1514, lexer.Location, "Unexpected symbol `{0}', expecting `.' or `{{'", GetSymbolName (yyToken));

		var name = (MemberName) yyVals[0+yyTop];		
		var ns = new NamespaceContainer (name, current_namespace);
		lbag.AddLocation (ns, GetLocation (yyVals[-1+yyTop]));
		current_namespace.AddTypeContainer (ns);
	  }

void case_27()
#line 560 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
	  	yyVal = null;
	  }

void case_28()
#line 568 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];
		yyVal = new MemberName (lt.Value, lt.Location);
	  }

void case_29()
#line 573 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];
		yyVal = new MemberName ((MemberName) yyVals[-2+yyTop], lt.Value, lt.Location);		
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_30()
#line 579 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new MemberName ("<invalid>", lexer.Location);
	  }

void case_43()
#line 617 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {
			TypeContainer ds = (TypeContainer)yyVals[0+yyTop];

			if ((ds.ModFlags & (Modifiers.PRIVATE | Modifiers.PROTECTED)) != 0){
				report.Error (1527, ds.Location, 
				"Namespace elements cannot be explicitly declared as private, protected or protected internal");
			}

			/* Here is a trick, for explicit attributes we don't know where they belong to until*/
			/* we parse succeeding declaration hence we parse them as normal and re-attach them*/
			/* when we know whether they are global (assembly:, module:) or local (type:).*/
			if (ds.OptAttributes != null) {
				ds.OptAttributes.ConvertGlobalAttributes (ds, current_namespace, !current_namespace.DeclarationFound && current_namespace == file);
			}
		}
		current_namespace.DeclarationFound = true;
	  }

void case_45()
#line 639 "cs-parser.jay"
{
		current_namespace.UnattachedAttributes = (Attributes) yyVals[-1+yyTop];
		report.Error (1518, lexer.Location, "Attributes must be attached to class, delegate, enum, interface or struct");
		lexer.putback ('}');
	  }

void case_53()
#line 672 "cs-parser.jay"
{
		var sect = (List<Attribute>) yyVals[0+yyTop];
		yyVal = new Attributes (sect);
	  }

void case_54()
#line 677 "cs-parser.jay"
{
		Attributes attrs = yyVals[-1+yyTop] as Attributes;
		var sect = (List<Attribute>) yyVals[0+yyTop];
		if (attrs == null)
			attrs = new Attributes (sect);
		else if (sect != null)
			attrs.AddAttributes (sect);
		yyVal = attrs;
	  }

void case_55()
#line 690 "cs-parser.jay"
{
	  	PushLocation (GetLocation (yyVals[0+yyTop]));
		lexer.parsing_attribute_section = true;
	  }

void case_56()
#line 695 "cs-parser.jay"
{
		lexer.parsing_attribute_section = false;
		yyVal = yyVals[0+yyTop];
	  }

void case_57()
#line 703 "cs-parser.jay"
{
		current_attr_target = (string) yyVals[-1+yyTop];
		if (current_attr_target == "assembly" || current_attr_target == "module") {
			Lexer.check_incorrect_doc_comment ();
		}
	  }

void case_58()
#line 710 "cs-parser.jay"
{
		/* when attribute target is invalid*/
		if (current_attr_target == string.Empty)
			yyVal = new List<Attribute> (0);
		else
			yyVal = yyVals[-2+yyTop];
		lbag.InsertLocation (yyVal, 0, GetLocation (yyVals[-4+yyTop]));
		lbag.InsertLocation (yyVal, 0, PopLocation ());
		lbag.InsertLocation (yyVal, 0, PopLocation ());
		if (yyVals[-1+yyTop] != null) {
			lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
		} else {
			lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
		}

		current_attr_target = null;
		lexer.parsing_attribute_section = false;
 	  }

void case_59()
#line 729 "cs-parser.jay"
{
		yyVal = yyVals[-2+yyTop];
		lbag.InsertLocation (yyVal, 0, PopLocation ());
		if (yyVals[-1+yyTop] != null) {
			lbag.AddLocation (yyVal, GetLocation(yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
		} else {
			lbag.AddLocation (yyVal, GetLocation(yyVals[0+yyTop]));
		}
	  }

void case_60()
#line 739 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		var lt = (LocatedToken) yyVals[-1+yyTop];
		var tne = new SimpleName (lt.Value, null, lt.Location);

		yyVal = new List<Attribute> () {
			new Attribute (null, tne, null, GetLocation (yyVals[-1+yyTop]), false)
		};
	  }

void case_61()
#line 750 "cs-parser.jay"
{
 		CheckAttributeTarget (yyToken, GetTokenName (yyToken), GetLocation (yyVals[0+yyTop])); 
 		yyVal = null;
	  }

void case_62()
#line 758 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];
		yyVal = CheckAttributeTarget (yyToken, lt.Value, lt.Location);
		PushLocation (GetLocation (yyVals[0+yyTop]));
	  }

void case_66()
#line 773 "cs-parser.jay"
{
		var attrs = (List<Attribute>) yyVals[-2+yyTop];
		if (attrs != null) {
			attrs.Add ((Attribute) yyVals[0+yyTop]);
	  		lbag.AddLocation (attrs, GetLocation (yyVals[-1+yyTop]));
	  	}

		yyVal = attrs;
	  }

void case_68()
#line 790 "cs-parser.jay"
{
		--lexer.parsing_block;
		
		var tne = (ATypeNameExpression) yyVals[-2+yyTop];
		if (tne.HasTypeArguments) {
			report.Error (404, tne.Location, "Attributes cannot be generic");
		}
		Arguments [] arguments = (Arguments []) yyVals[0+yyTop];

		yyVal = new Attribute (current_attr_target, tne, (Arguments[]) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]), lexer.IsEscapedIdentifier (tne));
		if (arguments != null) {
			attributeArgumentCommas.Insert (0, savedAttrParenOpenLocation);
			attributeArgumentCommas.Add (savedAttrParenCloseLocation);
			lbag.AddLocation (yyVal, attributeArgumentCommas);
			attributeArgumentCommas.Clear ();
		} else if (HadAttributeParens) {
			lbag.AddLocation (yyVal, savedAttrParenOpenLocation, savedAttrParenCloseLocation);
		}
	  }

void case_71()
#line 818 "cs-parser.jay"
{
		savedAttrParenOpenLocation = GetLocation (yyVals[-2+yyTop]);
		savedAttrParenCloseLocation = GetLocation (yyVals[0+yyTop]);
		yyVal = yyVals[-1+yyTop];
		HadAttributeParens = true;
	  }

void case_73()
#line 830 "cs-parser.jay"
{
	  	Arguments a = new Arguments (4);
		a.Add ((Argument) yyVals[0+yyTop]);
		yyVal = new Arguments [] { a, null };
	  }

void case_74()
#line 836 "cs-parser.jay"
{
	  	Arguments a = new Arguments (4);
		a.Add ((Argument) yyVals[0+yyTop]);  
		yyVal = new Arguments [] { null, a };
	  }

void case_75()
#line 842 "cs-parser.jay"
{
		Arguments[] o = (Arguments[]) yyVals[-2+yyTop];
		if (o [1] != null) {
			report.Error (1016, ((Argument) yyVals[0+yyTop]).Expr.Location, "Named attribute arguments must appear after the positional arguments");
			o [0] = new Arguments (4);
		}
		
		Arguments args = ((Arguments) o [0]);
		if (args.Count > 0 && !(yyVals[0+yyTop] is NamedArgument) && args [args.Count - 1] is NamedArgument)
			Error_NamedArgumentExpected ((NamedArgument) args [args.Count - 1]);
		
		args.Add ((Argument) yyVals[0+yyTop]);
		attributeArgumentCommas.Add (GetLocation (yyVals[-1+yyTop]));
	  }

void case_76()
#line 857 "cs-parser.jay"
{
		Arguments[] o = (Arguments[]) yyVals[-2+yyTop];
		if (o [1] == null) {
			o [1] = new Arguments (4);
		}

		((Arguments) o [1]).Add ((Argument) yyVals[0+yyTop]);
		attributeArgumentCommas.Add (GetLocation (yyVals[-1+yyTop]));
	  }

void case_79()
#line 875 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_81()
#line 887 "cs-parser.jay"
{
	  	--lexer.parsing_block;
	  	var lt = (LocatedToken) yyVals[-3+yyTop];
		yyVal = new NamedArgument (lt.Value, lt.Location, (Expression) yyVals[0+yyTop]);	  
		lbag.AddLocation (yyVal, GetLocation(yyVals[-2+yyTop]));
	  }

void case_82()
#line 897 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.V_3)
			FeatureIsNotAvailable (GetLocation (yyVals[-3+yyTop]), "named argument");
			
		/* Avoid boxing in common case (no modifier)*/
		var arg_mod = yyVals[-1+yyTop] == null ? Argument.AType.None : (Argument.AType) yyVals[-1+yyTop];
			
		var lt = (LocatedToken) yyVals[-3+yyTop];
		yyVal = new NamedArgument (lt.Value, lt.Location, (Expression) yyVals[0+yyTop], arg_mod);
		lbag.AddLocation (yyVal, GetLocation(yyVals[-2+yyTop]));
	  }

void case_88()
#line 929 "cs-parser.jay"
{
		lexer.parsing_modifiers = true;
		lexer.parsing_block = 0;
	  }

void case_89()
#line 934 "cs-parser.jay"
{
		lexer.parsing_modifiers = true;
		lexer.parsing_block = 0;
	  }

void case_103()
#line 955 "cs-parser.jay"
{
		report.Error (1519, lexer.Location, "Unexpected symbol `{0}' in class, struct, or interface member declaration",
			GetSymbolName (yyToken));
		yyVal = null;
		lexer.parsing_generic_declaration = false;
	  }

void case_104()
#line 965 "cs-parser.jay"
{
		current_local_parameters = current_type.PrimaryConstructorParameters;
		if (current_local_parameters == null) {
			report.Error (9010, GetLocation (yyVals[0+yyTop]), "Primary constructor body is not allowed");
			current_local_parameters = ParametersCompiled.EmptyReadOnlyParameters;
		}

		++lexer.parsing_block;
		start_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_105()
#line 976 "cs-parser.jay"
{
		current_local_parameters = null;
		var t = current_type as ClassOrStruct;
		if (t != null) {
			var b = (ToplevelBlock) yyVals[0+yyTop];
			if (t.PrimaryConstructorBlock != null) {
				report.Error (8041, b.StartLocation, "Primary constructor already has a body");
			} else {
				t.PrimaryConstructorBlock = b;
			}
		}
	  }

void case_107()
#line 998 "cs-parser.jay"
{ 
		lexer.ConstraintsParsing = true;
		valid_param_mod = ParameterModifierType.PrimaryConstructor;
		push_current_container (new Struct (current_container, (MemberName) yyVals[0+yyTop], (Modifiers) yyVals[-4+yyTop], (Attributes) yyVals[-5+yyTop]), yyVals[-3+yyTop]);
		lbag.AddMember (current_container, GetModifierLocations (), GetLocation (yyVals[-2+yyTop]));
	  }

void case_108()
#line 1007 "cs-parser.jay"
{
		valid_param_mod = 0;
		lexer.ConstraintsParsing = false;

		if (yyVals[-2+yyTop] != null)
			current_type.PrimaryConstructorParameters = (ParametersCompiled) yyVals[-2+yyTop];

		if (yyVals[0+yyTop] != null)
			current_container.SetConstraints ((List<Constraints>) yyVals[0+yyTop]);

		if (doc_support)
			current_container.PartialContainer.DocComment = Lexer.consume_doc_comment ();

		
		lexer.parsing_modifiers = true;
	  }

void case_109()
#line 1024 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_110()
#line 1029 "cs-parser.jay"
{
		--lexer.parsing_declaration;
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_111()
#line 1035 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] == null) {
			lbag.AppendToMember (current_container, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-2+yyTop]));
		} else {
			lbag.AppendToMember (current_container, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
		}
		yyVal = pop_current_class ();
	  }

void case_113()
#line 1053 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];
		var mod = (Modifiers) yyVals[-3+yyTop];
		current_field = new Const (current_type, (FullNamedExpression) yyVals[-1+yyTop], mod, new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-4+yyTop]);
		current_type.AddMember (current_field);
		
		if ((mod & Modifiers.STATIC) != 0) {
			report.Error (504, current_field.Location, "The constant `{0}' cannot be marked static", current_field.GetSignatureForError ());
		}
		
		yyVal = current_field;
	  }

void case_114()
#line 1066 "cs-parser.jay"
{
		if (doc_support) {
			current_field.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		current_field.Initializer = (ConstInitializer) yyVals[-2+yyTop];
		lbag.AddMember (current_field, GetModifierLocations (), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[0+yyTop]));
		current_field = null;
	  }

void case_115()
#line 1079 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		current_type.AddMember (new Const (current_type, (FullNamedExpression) yyVals[-1+yyTop], (Modifiers) yyVals[-3+yyTop], MemberName.Null, (Attributes) yyVals[-4+yyTop]));
	  }

void case_120()
#line 1104 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
	  	yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), (ConstInitializer) yyVals[0+yyTop]);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_122()
#line 1117 "cs-parser.jay"
{
		--lexer.parsing_block;
		yyVal = new ConstInitializer (current_field, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_123()
#line 1123 "cs-parser.jay"
{
		report.Error (145, lexer.Location, "A const field requires a value to be provided");
		yyVal = null;
	  }

void case_126()
#line 1138 "cs-parser.jay"
{
	  	lexer.parsing_generic_declaration = false;

		FullNamedExpression type = (FullNamedExpression) yyVals[-1+yyTop];
		if (type.Type != null && type.Type.Kind == MemberKind.Void)
			report.Error (670, GetLocation (yyVals[-1+yyTop]), "Fields cannot have void type");
			
		var lt = (LocatedToken) yyVals[0+yyTop];
		current_field = new Field (current_type, type, (Modifiers) yyVals[-2+yyTop], new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-3+yyTop]);
		current_type.AddField (current_field);
		yyVal = current_field;
	  }

void case_127()
#line 1153 "cs-parser.jay"
{ 
		if (doc_support) {
			current_field.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
			
		lbag.AddMember (current_field, GetModifierLocations (), GetLocation (yyVals[0+yyTop]));
		yyVal = current_field;
		current_field = null;
	  }

void case_128()
#line 1166 "cs-parser.jay"
{ 
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "fixed size buffers");

		var lt = (LocatedToken) yyVals[0+yyTop];
		current_field = new FixedField (current_type, (FullNamedExpression) yyVals[-1+yyTop], (Modifiers) yyVals[-3+yyTop],
			new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-4+yyTop]);
			
		current_type.AddField (current_field);
	  }

void case_129()
#line 1177 "cs-parser.jay"
{
		if (doc_support) {
			current_field.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
	    }

		current_field.Initializer = (ConstInitializer) yyVals[-2+yyTop];	    
		lbag.AddMember (current_field, GetModifierLocations (), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[0+yyTop]));
		yyVal = current_field;
	    current_field = null;
	  }

void case_132()
#line 1200 "cs-parser.jay"
{
	  	++lexer.parsing_block;
		current_local_parameters = ParametersCompiled.EmptyReadOnlyParameters;
	  	start_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_133()
#line 1206 "cs-parser.jay"
{
	  	--lexer.parsing_block;
		current_field.Initializer = (Expression) yyVals[0+yyTop];
		lbag.AppendToMember (current_field, GetLocation (yyVals[-2+yyTop]));
		end_block (lexer.Location);
		current_local_parameters = null;
	  }

void case_138()
#line 1233 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];
	  	yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), null);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_140()
#line 1243 "cs-parser.jay"
{
		--lexer.parsing_block;
		var lt = (LocatedToken) yyVals[-3+yyTop];	  
	  	yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), (Expression) yyVals[0+yyTop]);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_145()
#line 1269 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];	  
		yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), (ConstInitializer) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_147()
#line 1282 "cs-parser.jay"
{
		--lexer.parsing_block;
		yyVal = new ConstInitializer (current_field, (Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_148()
#line 1288 "cs-parser.jay"
{
		report.Error (443, lexer.Location, "Value or constant expected");
		yyVal = null;
	  }

void case_151()
#line 1298 "cs-parser.jay"
{
		/* It has to be here for the parent to safely restore artificial block*/
	  	Error_SyntaxError (yyToken);
	  	yyVal = null;
	  }

void case_152()
#line 1307 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.NotAllowed;

		/* Was added earlier in the case of body being eof for full ast*/
	  }

void case_153()
#line 1314 "cs-parser.jay"
{
		Method method = (Method) yyVals[-2+yyTop];
		method.Block = (ToplevelBlock) yyVals[0+yyTop];
		async_block = false;
		
		if (method.Block == null) {
			lbag.AppendToMember (method, savedLocation); /* semicolon*/
			method.ParameterInfo.CheckParameters (method);

			if ((method.ModFlags & Modifiers.ASYNC) != 0) {
				report.Error (1994, method.Location, "`{0}': The async modifier can only be used with methods that have a body",
					method.GetSignatureForError ());
			}
		} else {
			if (current_container.Kind == MemberKind.Interface) {
				report.Error (531, method.Location, "`{0}': interface members cannot have a definition",
					method.GetSignatureForError ());
			}
		}

		current_local_parameters = null;

		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_155()
#line 1350 "cs-parser.jay"
{
		valid_param_mod = 0;
		MemberName name = (MemberName) yyVals[-4+yyTop];
		current_local_parameters = (ParametersCompiled) yyVals[-1+yyTop];

		var method = Method.Create (current_type, (FullNamedExpression) yyVals[-5+yyTop], (Modifiers) yyVals[-6+yyTop],
				     name, current_local_parameters, (Attributes) yyVals[-7+yyTop]);

		current_type.AddMember (method);

		async_block = (method.ModFlags & Modifiers.ASYNC) != 0;

		if (doc_support)
			method.DocComment = Lexer.consume_doc_comment ();

		lbag.AddMember (method, GetModifierLocations (), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
		yyVal = method;

		lexer.ConstraintsParsing = true;
	  }

void case_156()
#line 1371 "cs-parser.jay"
{
		lexer.ConstraintsParsing = false;

		if (yyVals[0+yyTop] != null) {
			var method = (Method) yyVals[-1+yyTop];
			method.SetConstraints ((List<Constraints>) yyVals[0+yyTop]);
		}

		yyVal = yyVals[-1+yyTop];
	  }

void case_158()
#line 1390 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;
	  	valid_param_mod = ParameterModifierType.All;
	  }

void case_160()
#line 1399 "cs-parser.jay"
{
		lexer.ConstraintsParsing = false;
		valid_param_mod = 0;

		MemberName name = (MemberName) yyVals[-6+yyTop];
		current_local_parameters = (ParametersCompiled) yyVals[-3+yyTop];

		var modifiers = (Modifiers) yyVals[-10+yyTop];
		modifiers |= Modifiers.PARTIAL;

		var method = Method.Create (current_type, new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[-8+yyTop])),
				     modifiers, name, current_local_parameters, (Attributes) yyVals[-11+yyTop]);

		current_type.AddMember (method);

		async_block = (method.ModFlags & Modifiers.ASYNC) != 0;

		if (yyVals[0+yyTop] != null)
			method.SetConstraints ((List<Constraints>) yyVals[0+yyTop]);

		if (doc_support)
			method.DocComment = Lexer.consume_doc_comment ();

		StoreModifierLocation (Modifiers.PARTIAL, GetLocation (yyVals[-9+yyTop]));
		lbag.AddMember (method, GetModifierLocations (), GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-2+yyTop]));
		yyVal = method;
	  }

void case_161()
#line 1430 "cs-parser.jay"
{
		MemberName name = (MemberName) yyVals[-3+yyTop];
		report.Error (1585, name.Location, 
			"Member modifier `{0}' must precede the member type and name", ModifiersExtensions.Name ((Modifiers) yyVals[-4+yyTop]));

		var method = Method.Create (current_type, (FullNamedExpression) yyVals[-5+yyTop],
					    0, name, (ParametersCompiled) yyVals[-1+yyTop], (Attributes) yyVals[-7+yyTop]);

		current_type.AddMember (method);

		current_local_parameters = (ParametersCompiled) yyVals[-1+yyTop];

		if (doc_support)
			method.DocComment = Lexer.consume_doc_comment ();

		yyVal = method;
	  }

void case_162()
#line 1451 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		current_local_parameters = ParametersCompiled.Undefined;

		MemberName name = (MemberName) yyVals[-1+yyTop];
		var method = Method.Create (current_type, (FullNamedExpression) yyVals[-2+yyTop], (Modifiers) yyVals[-3+yyTop],
									name, current_local_parameters, (Attributes) yyVals[-4+yyTop]);

		current_type.AddMember (method);

		if (doc_support)
			method.DocComment = Lexer.consume_doc_comment ();

		yyVal = method;
	  }

void case_167()
#line 1480 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.V_6) {
			FeatureIsNotAvailable (GetLocation (yyVals[0+yyTop]), "expression bodied members");
		}

		++lexer.parsing_block;
		start_block (GetLocation (yyVals[0+yyTop]));
	 }

void case_168()
#line 1489 "cs-parser.jay"
{
		lexer.parsing_block = 0;
		current_block.AddStatement (new ContextualReturn ((Expression) yyVals[-1+yyTop]));
		var b = end_block (GetLocation (yyVals[0+yyTop]));
		b.IsCompilerGenerated = true;
		yyVal = b;
	 }

void case_171()
#line 1505 "cs-parser.jay"
{
		var pars_list = (List<Parameter>) yyVals[0+yyTop];
	  	yyVal = new ParametersCompiled (pars_list.ToArray ());
	  	lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_172()
#line 1511 "cs-parser.jay"
{
		var pars_list = (List<Parameter>) yyVals[-2+yyTop];
		pars_list.Add ((Parameter) yyVals[0+yyTop]);
		parameterListCommas.Add (GetLocation (yyVals[-1+yyTop]));
		
		yyVal = new ParametersCompiled (pars_list.ToArray ()); 
	  	lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_173()
#line 1520 "cs-parser.jay"
{
		var pars_list = (List<Parameter>) yyVals[-2+yyTop];
		pars_list.Add (new ArglistParameter (GetLocation (yyVals[0+yyTop])));
		parameterListCommas.Add (GetLocation (yyVals[-1+yyTop]));
		
		yyVal = new ParametersCompiled (pars_list.ToArray (), true);
	  	lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_174()
#line 1529 "cs-parser.jay"
{
		if (yyVals[-2+yyTop] != null)
			report.Error (231, ((Parameter) yyVals[-2+yyTop]).Location, "A params parameter must be the last parameter in a formal parameter list");

		yyVal = new ParametersCompiled (new Parameter[] { (Parameter) yyVals[-2+yyTop] } );			
	  	lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_175()
#line 1537 "cs-parser.jay"
{
		if (yyVals[-2+yyTop] != null)
			report.Error (231, ((Parameter) yyVals[-2+yyTop]).Location, "A params parameter must be the last parameter in a formal parameter list");

		var pars_list = (List<Parameter>) yyVals[-4+yyTop];
		pars_list.Add (new ArglistParameter (GetLocation (yyVals[-2+yyTop])));
		parameterListCommas.Add (GetLocation (yyVals[-3+yyTop]));
		parameterListCommas.Add (GetLocation (yyVals[-1+yyTop]));
		
		yyVal = new ParametersCompiled (pars_list.ToArray (), true);
	  	lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_176()
#line 1550 "cs-parser.jay"
{
		report.Error (257, GetLocation (yyVals[-2+yyTop]), "An __arglist parameter must be the last parameter in a formal parameter list");

		yyVal = new ParametersCompiled (new Parameter [] { new ArglistParameter (GetLocation (yyVals[-2+yyTop])) }, true);
	  	lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_177()
#line 1557 "cs-parser.jay"
{
		report.Error (257, GetLocation (yyVals[-2+yyTop]), "An __arglist parameter must be the last parameter in a formal parameter list");

		var pars_list = (List<Parameter>) yyVals[-4+yyTop];
		pars_list.Add (new ArglistParameter (GetLocation (yyVals[-2+yyTop])));
		parameterListCommas.Add (GetLocation (yyVals[-3+yyTop]));
		parameterListCommas.Add (GetLocation (yyVals[-1+yyTop]));

		yyVal = new ParametersCompiled (pars_list.ToArray (), true);
	  	lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_180()
#line 1577 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = ParametersCompiled.EmptyReadOnlyParameters;
	  }

void case_181()
#line 1585 "cs-parser.jay"
{
		parameters_bucket.Clear ();
		Parameter p = (Parameter) yyVals[0+yyTop];
		parameters_bucket.Add (p);
		parameterListCommas.Clear ();
		default_parameter_used = p.HasDefaultValue;
		yyVal = parameters_bucket;
	  }

void case_182()
#line 1594 "cs-parser.jay"
{
		var pars = (List<Parameter>) yyVals[-2+yyTop];
		Parameter p = (Parameter) yyVals[0+yyTop];
		if (p != null) {
			if (p.HasExtensionMethodModifier)
				report.Error (1100, p.Location, "The parameter modifier `this' can only be used on the first parameter");
			else if (!p.HasDefaultValue && default_parameter_used)
				report.Error (1737, p.Location, "Optional parameter cannot precede required parameters");

			default_parameter_used |= p.HasDefaultValue;
			pars.Add (p);
			
			parameterListCommas.Add (GetLocation (yyVals[-1+yyTop]));
		}
		
		yyVal = yyVals[-2+yyTop];
	  }

void case_183()
#line 1618 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];
		yyVal = new Parameter ((FullNamedExpression) yyVals[-1+yyTop], lt.Value, (Parameter.Modifier) yyVals[-2+yyTop], (Attributes) yyVals[-3+yyTop], lt.Location);
		lbag.AddLocation (yyVal, parameterModifierLocation);
	  }

void case_184()
#line 1627 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-2+yyTop];
		report.Error (1552, lt.Location, "Array type specifier, [], must appear before parameter name");
		yyVal = new Parameter ((FullNamedExpression) yyVals[-3+yyTop], lt.Value, (Parameter.Modifier) yyVals[-4+yyTop], (Attributes) yyVals[-5+yyTop], lt.Location);
		lbag.AddLocation (yyVal, parameterModifierLocation);
	  }

void case_185()
#line 1634 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
	  	Location l = GetLocation (yyVals[0+yyTop]);
		yyVal = new Parameter (null, null, Parameter.Modifier.NONE, (Attributes) yyVals[-1+yyTop], l);
	  }

void case_186()
#line 1643 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
	  	Location l = GetLocation (yyVals[0+yyTop]);
		yyVal = new Parameter ((FullNamedExpression) yyVals[-1+yyTop], null, (Parameter.Modifier) yyVals[-2+yyTop], (Attributes) yyVals[-3+yyTop], l);
		lbag.AddLocation (yyVal, parameterModifierLocation);
	  }

void case_188()
#line 1658 "cs-parser.jay"
{
	  	--lexer.parsing_block;
		if (lang_version <= LanguageVersion.V_3) {
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "optional parameter");
		}
		
		Parameter.Modifier mod = (Parameter.Modifier) yyVals[-5+yyTop];
		if (mod != Parameter.Modifier.NONE) {
			switch (mod) {
			case Parameter.Modifier.REF:
			case Parameter.Modifier.OUT:
				report.Error (1741, GetLocation (yyVals[-5+yyTop]), "Cannot specify a default value for the `{0}' parameter",
					Parameter.GetModifierSignature (mod));
				break;
				
			case Parameter.Modifier.This:
				report.Error (1743, GetLocation (yyVals[-5+yyTop]), "Cannot specify a default value for the `{0}' parameter",
					Parameter.GetModifierSignature (mod));
				break;
			default:
				throw new NotImplementedException (mod.ToString ());
			}
				
			mod = Parameter.Modifier.NONE;
		}
		
		if ((valid_param_mod & ParameterModifierType.DefaultValue) == 0)
			report.Error (1065, GetLocation (yyVals[-2+yyTop]), "Optional parameter is not valid in this context");
		
		var lt = (LocatedToken) yyVals[-3+yyTop];
		yyVal = new Parameter ((FullNamedExpression) yyVals[-4+yyTop], lt.Value, mod, (Attributes) yyVals[-6+yyTop], lt.Location);
		lbag.AddLocation (yyVal, parameterModifierLocation, GetLocation (yyVals[-2+yyTop])); /* parameterModifierLocation should be ignored when mod == NONE*/
		
		if (yyVals[0+yyTop] != null)
			((Parameter) yyVal).DefaultValue = new DefaultParameterValueExpression ((Expression) yyVals[0+yyTop]);
	  }

void case_192()
#line 1707 "cs-parser.jay"
{
		Parameter.Modifier p2 = (Parameter.Modifier)yyVals[0+yyTop];
  		Parameter.Modifier mod = (Parameter.Modifier)yyVals[-1+yyTop] | p2;
  		if (((Parameter.Modifier)yyVals[-1+yyTop] & p2) == p2) {
  			Error_DuplicateParameterModifier (lexer.Location, p2);
  		} else {
	  		switch (mod & ~Parameter.Modifier.This) {
  				case Parameter.Modifier.REF:
					report.Error (1101, lexer.Location, "The parameter modifiers `this' and `ref' cannot be used altogether");
  					break;
   				case Parameter.Modifier.OUT:
					report.Error (1102, lexer.Location, "The parameter modifiers `this' and `out' cannot be used altogether");
  					break;
  				default:
 					report.Error (1108, lexer.Location, "A parameter cannot have specified more than one modifier");
 					break;
 			}
  		}
  		yyVal = mod;
	  }

void case_193()
#line 1731 "cs-parser.jay"
{
	  	if ((valid_param_mod & ParameterModifierType.Ref) == 0)
	  		Error_ParameterModifierNotValid ("ref", GetLocation (yyVals[0+yyTop]));
		parameterModifierLocation = GetLocation (yyVals[0+yyTop]);
	  	yyVal = Parameter.Modifier.REF;
	  }

void case_194()
#line 1738 "cs-parser.jay"
{
	  	if ((valid_param_mod & ParameterModifierType.Out) == 0)
	  		Error_ParameterModifierNotValid ("out", GetLocation (yyVals[0+yyTop]));
		parameterModifierLocation = GetLocation (yyVals[0+yyTop]);
	  	yyVal = Parameter.Modifier.OUT;
	  }

void case_195()
#line 1745 "cs-parser.jay"
{
		if ((valid_param_mod & ParameterModifierType.This) == 0)
	  		Error_ParameterModifierNotValid ("this", GetLocation (yyVals[0+yyTop]));

	  	if (lang_version <= LanguageVersion.ISO_2)
	  		FeatureIsNotAvailable (GetLocation (yyVals[0+yyTop]), "extension methods");
		parameterModifierLocation = GetLocation (yyVals[0+yyTop]);
		yyVal = Parameter.Modifier.This;
	  }

void case_196()
#line 1758 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];
		yyVal = new ParamsParameter ((FullNamedExpression) yyVals[-1+yyTop], lt.Value, (Attributes) yyVals[-3+yyTop], lt.Location);
		lbag.AddLocation (yyVal, savedLocation);
	  }

void case_197()
#line 1764 "cs-parser.jay"
{
		report.Error (1751, GetLocation (yyVals[-4+yyTop]), "Cannot specify a default value for a parameter array");
		
		var lt = (LocatedToken) yyVals[-2+yyTop];
		yyVal = new ParamsParameter ((FullNamedExpression) yyVals[-3+yyTop], lt.Value, (Attributes) yyVals[-5+yyTop], lt.Location);		
		lbag.AddLocation (yyVal, savedLocation);
	  }

void case_198()
#line 1772 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new ParamsParameter ((FullNamedExpression) yyVals[-1+yyTop], null, (Attributes) yyVals[-3+yyTop], Location.Null);
	  }

void case_199()
#line 1781 "cs-parser.jay"
{
		if ((valid_param_mod & ParameterModifierType.Params) == 0)
			report.Error (1670, (GetLocation (yyVals[0+yyTop])), "The `params' modifier is not allowed in current context");
		savedLocation = GetLocation (yyVals[0+yyTop]);
	  }

void case_200()
#line 1787 "cs-parser.jay"
{
		Parameter.Modifier mod = (Parameter.Modifier)yyVals[0+yyTop];
		if ((mod & Parameter.Modifier.This) != 0) {
			report.Error (1104, GetLocation (yyVals[-1+yyTop]), "The parameter modifiers `this' and `params' cannot be used altogether");
		} else {
			report.Error (1611, GetLocation (yyVals[-1+yyTop]), "The params parameter cannot be declared as ref or out");
		}	  
		savedLocation = GetLocation (yyVals[-1+yyTop]);
	  }

void case_202()
#line 1804 "cs-parser.jay"
{
	  	if ((valid_param_mod & ParameterModifierType.Arglist) == 0)
	  		report.Error (1669, GetLocation (yyVals[0+yyTop]), "__arglist is not valid in this context");
	  }

void case_203()
#line 1815 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;
		if (doc_support)
			tmpComment = Lexer.consume_doc_comment ();
	  }

void case_204()
#line 1821 "cs-parser.jay"
{
		var type = (FullNamedExpression) yyVals[-3+yyTop];
		current_property = new Property (current_type, type, (Modifiers) yyVals[-4+yyTop],
			(MemberName) yyVals[-2+yyTop], (Attributes) yyVals[-5+yyTop]);
			
		if (type.Type != null && type.Type.Kind == MemberKind.Void)
			report.Error (547, GetLocation (yyVals[-3+yyTop]), "`{0}': property or indexer cannot have void type", current_property.GetSignatureForError ());					
			
		current_type.AddMember (current_property);
		lbag.AddMember (current_property, GetModifierLocations (), GetLocation (yyVals[0+yyTop]));
		
		lexer.PropertyParsing = true;
	  }

void case_205()
#line 1835 "cs-parser.jay"
{
		lexer.PropertyParsing = false;
		
		if (doc_support)
			current_property.DocComment = ConsumeStoredComment ();				
	  }

void case_206()
#line 1842 "cs-parser.jay"
{
		lbag.AppendToMember (current_property, GetLocation (yyVals[0+yyTop]));
		lexer.parsing_modifiers = true;
	  }

void case_208()
#line 1854 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;
		if (doc_support)
			tmpComment = Lexer.consume_doc_comment ();
		current_local_parameters = ParametersCompiled.EmptyReadOnlyParameters;
	  }

void case_209()
#line 1861 "cs-parser.jay"
{
		var type = (FullNamedExpression) yyVals[-3+yyTop];
		var property = new Property (current_type, type, (Modifiers) yyVals[-4+yyTop],
			(MemberName) yyVals[-2+yyTop], (Attributes) yyVals[-5+yyTop]);

		property.Get = new Property.GetMethod (property, Modifiers.COMPILER_GENERATED, null, property.Location);
		property.Get.Block = (ToplevelBlock) yyVals[0+yyTop];

		if (current_container.Kind == MemberKind.Interface) {
			report.Error (531, property.Get.Block.StartLocation,
				"`{0}': interface members cannot have a definition", property.GetSignatureForError ());
		}

		if (type.Type != null && type.Type.Kind == MemberKind.Void)
			report.Error (547, GetLocation (yyVals[-3+yyTop]), "`{0}': property or indexer cannot have void type", property.GetSignatureForError ());

		current_type.AddMember (property);

		current_local_parameters = null;
	  }

void case_211()
#line 1886 "cs-parser.jay"
{
		++lexer.parsing_block;
		current_local_parameters = ParametersCompiled.EmptyReadOnlyParameters;
		start_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_212()
#line 1892 "cs-parser.jay"
{
		--lexer.parsing_block;
		((Property)current_property).Initializer = (Expression) yyVals[-1+yyTop];
		lbag.AppendToMember (current_property, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
		end_block (GetLocation (yyVals[0+yyTop]));
		current_local_parameters = null;
	  }

void case_216()
#line 1913 "cs-parser.jay"
{
		valid_param_mod = 0;
		var type = (FullNamedExpression) yyVals[-5+yyTop];
		Indexer indexer = new Indexer (current_type, type, (MemberName) yyVals[-4+yyTop], (Modifiers) yyVals[-6+yyTop], (ParametersCompiled) yyVals[-1+yyTop], (Attributes) yyVals[-7+yyTop]);
			
		current_property = indexer;

  		current_type.AddIndexer (indexer);
		lbag.AddMember (current_property, GetModifierLocations (), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
  		
		if (type.Type != null && type.Type.Kind == MemberKind.Void)
			report.Error (620, GetLocation (yyVals[-5+yyTop]), "`{0}': indexer return type cannot be `void'", indexer.GetSignatureForError ());  		

		if (indexer.ParameterInfo.IsEmpty) {
			report.Error (1551, GetLocation (yyVals[-3+yyTop]), "Indexers must have at least one parameter");
		}

		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}

		lexer.PropertyParsing = true;
		current_local_parameters = (ParametersCompiled) yyVals[-1+yyTop];
	  }

void case_217()
#line 1939 "cs-parser.jay"
{
 		lexer.PropertyParsing = false;
		current_local_parameters = null;

		if (current_property.AccessorFirst != null && current_property.AccessorFirst.Block == null)
			((Indexer) current_property).ParameterInfo.CheckParameters (current_property);
	  
		if (doc_support)
			current_property.DocComment = ConsumeStoredComment ();
			
		current_property = null;		
	  }

void case_219()
#line 1959 "cs-parser.jay"
{
		current_property.Get = new Indexer.GetIndexerMethod (current_property, Modifiers.COMPILER_GENERATED, current_local_parameters, null, current_property.Location);
		current_property.Get.Block = (ToplevelBlock) yyVals[0+yyTop];
	  }

void case_224()
#line 1971 "cs-parser.jay"
{
	  	if (yyToken == Token.CLOSE_BRACE) {
	  		report.Error (548, lexer.Location, "`{0}': property or indexer must have at least one accessor", current_property.GetSignatureForError ());
		} else {
			if (yyToken == Token.SEMICOLON)
				report.Error (1597, lexer.Location, "Semicolon after method or accessor block is not valid");
			else
				report.Error (1014, GetLocation (yyVals[0+yyTop]), "A get or set accessor expected");
		}
	  }

void case_225()
#line 1985 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] != ModifierNone && lang_version == LanguageVersion.ISO_1) {
			FeatureIsNotAvailable (GetLocation (yyVals[-1+yyTop]), "access modifiers on properties");
		}
	  
		if (current_property.Get != null) {
			report.Error (1007, GetLocation (yyVals[0+yyTop]), "Property accessor already defined");
		}
		
		if (current_property is Indexer) {
			current_property.Get = new Indexer.GetIndexerMethod (current_property, (Modifiers) yyVals[-1+yyTop], ((Indexer)current_property).ParameterInfo.Clone (),
				(Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		} else {
			current_property.Get = new Property.GetMethod (current_property,
				(Modifiers) yyVals[-1+yyTop], (Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		}	
	  
		current_local_parameters = current_property.Get.ParameterInfo;	  
		lexer.PropertyParsing = false;
	  }

void case_226()
#line 2006 "cs-parser.jay"
{
	  	if (yyVals[0+yyTop] != null) {
	  		current_property.Get.Block = (ToplevelBlock) yyVals[0+yyTop];			
	  	
			if (current_container.Kind == MemberKind.Interface) {
				report.Error (531, current_property.Get.Block.StartLocation,
					"`{0}': interface members cannot have a definition", current_property.Get.GetSignatureForError ());
			}
			lbag.AddMember (current_property.Get, GetModifierLocations ());
		} else {
			lbag.AddMember (current_property.Get, GetModifierLocations (), savedLocation);
		}
	  
		current_local_parameters = null;
		lexer.PropertyParsing = true;

		if (doc_support)
			if (Lexer.doc_state == XmlCommentState.Error)
				Lexer.doc_state = XmlCommentState.NotAllowed;
	  }

void case_227()
#line 2030 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] != ModifierNone && lang_version == LanguageVersion.ISO_1) {
			FeatureIsNotAvailable (GetLocation (yyVals[-1+yyTop]), "access modifiers on properties");
		}
		
		if (current_property.Set != null) {
			report.Error (1007, GetLocation (yyVals[0+yyTop]), "Property accessor already defined");
		}
	  
		if (current_property is Indexer) {
			current_property.Set = new Indexer.SetIndexerMethod (current_property, (Modifiers) yyVals[-1+yyTop],
				ParametersCompiled.MergeGenerated (compiler,
				((Indexer)current_property).ParameterInfo, true, new Parameter (
					current_property.TypeExpression, "value", Parameter.Modifier.NONE, null, GetLocation (yyVals[0+yyTop])),
					null),
				(Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		} else {
			current_property.Set = new Property.SetMethod (current_property, (Modifiers) yyVals[-1+yyTop], 
				ParametersCompiled.CreateImplicitParameter (current_property.TypeExpression, GetLocation (yyVals[0+yyTop])),
				(Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		}
		
		current_local_parameters = current_property.Set.ParameterInfo;	
		lexer.PropertyParsing = false;
	  }

void case_228()
#line 2056 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {		
			current_property.Set.Block = (ToplevelBlock) yyVals[0+yyTop];
		
			if (current_container.Kind == MemberKind.Interface) {
				report.Error (531, current_property.Set.Block.StartLocation,
					"`{0}': interface members cannot have a definition", current_property.Set.GetSignatureForError ());
			}
			lbag.AddMember (current_property.Set, GetModifierLocations ());
		} else {
			lbag.AddMember (current_property.Set, GetModifierLocations (), savedLocation);
		}
		
		current_local_parameters = null;
		lexer.PropertyParsing = true;

		if (doc_support
			&& Lexer.doc_state == XmlCommentState.Error)
			Lexer.doc_state = XmlCommentState.NotAllowed;
	  }

void case_230()
#line 2081 "cs-parser.jay"
{
		savedLocation = GetLocation (yyVals[0+yyTop]);
	  	yyVal = null;
	  }

void case_231()
#line 2086 "cs-parser.jay"
{
	  	Error_SyntaxError (1043, yyToken, "Invalid accessor body");
	  	yyVal = null;
	  }

void case_233()
#line 2100 "cs-parser.jay"
{
		lexer.ConstraintsParsing = true;
		push_current_container (new Interface (current_container, (MemberName) yyVals[0+yyTop], (Modifiers) yyVals[-4+yyTop], (Attributes) yyVals[-5+yyTop]), yyVals[-3+yyTop]);
		lbag.AddMember (current_container, GetModifierLocations (), GetLocation (yyVals[-2+yyTop]));		
	  }

void case_234()
#line 2107 "cs-parser.jay"
{
		lexer.ConstraintsParsing = false;

		if (yyVals[0+yyTop] != null)
			current_container.SetConstraints ((List<Constraints>) yyVals[0+yyTop]);

		if (doc_support) {
			current_container.PartialContainer.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		lexer.parsing_modifiers = true;
	  }

void case_235()
#line 2121 "cs-parser.jay"
{
		--lexer.parsing_declaration;	  
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_236()
#line 2127 "cs-parser.jay"
{
		if (yyVals[0+yyTop] == null) {
			lbag.AppendToMember (current_container, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
		} else {
			lbag.AppendToMember (current_container, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
		}
		yyVal = pop_current_class ();
	  }

void case_240()
#line 2148 "cs-parser.jay"
{
		lexer.parsing_modifiers = true;
		lexer.parsing_block = 0;
	  }

void case_241()
#line 2153 "cs-parser.jay"
{
		lexer.parsing_modifiers = true;
		lexer.parsing_block = 0;
	  }

void case_252()
#line 2191 "cs-parser.jay"
{
		OperatorDeclaration decl = (OperatorDeclaration) yyVals[-2+yyTop];
		if (decl != null) {
			Operator op = new Operator (
				current_type, decl.optype, decl.ret_type, (Modifiers) yyVals[-3+yyTop], 
				current_local_parameters,
				(ToplevelBlock) yyVals[0+yyTop], (Attributes) yyVals[-4+yyTop], decl.location);
				
			if (op.Block == null)
				op.ParameterInfo.CheckParameters (op);

			if (doc_support) {
				op.DocComment = tmpComment;
				Lexer.doc_state = XmlCommentState.Allowed;
			}

			/* Note again, checking is done in semantic analysis*/
			current_type.AddOperator (op);

			lbag.AddMember (op, GetModifierLocations (), lbag.GetLocations (decl));
			if (yyVals[0+yyTop] == null) { /* Semicolon*/
				lbag.AddLocation (op, savedLocation); 
			}
		}
		
		current_local_parameters = null;
	  }

void case_254()
#line 2223 "cs-parser.jay"
{
		report.Error (590, GetLocation (yyVals[0+yyTop]), "User-defined operators cannot return void");
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }

void case_256()
#line 2235 "cs-parser.jay"
{
		valid_param_mod = 0;

		Location loc = GetLocation (yyVals[-5+yyTop]);
		Operator.OpType op = (Operator.OpType) yyVals[-4+yyTop];
		current_local_parameters = (ParametersCompiled)yyVals[-1+yyTop];
		
		int p_count = current_local_parameters.Count;
		if (p_count == 1) {
			if (op == Operator.OpType.Addition)
				op = Operator.OpType.UnaryPlus;
			else if (op == Operator.OpType.Subtraction)
				op = Operator.OpType.UnaryNegation;
		}
		
		if (IsUnaryOperator (op)) {
			if (p_count == 2) {
				report.Error (1020, loc, "Overloadable binary operator expected");
			} else if (p_count != 1) {
				report.Error (1535, loc, "Overloaded unary operator `{0}' takes one parameter",
					Operator.GetName (op));
			}
		} else {
			if (p_count == 1) {
				report.Error (1019, loc, "Overloadable unary operator expected");
			} else if (p_count != 2) {
				report.Error (1534, loc, "Overloaded binary operator `{0}' takes two parameters",
					Operator.GetName (op));
			}
		}
		
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}

		yyVal = new OperatorDeclaration (op, (FullNamedExpression) yyVals[-6+yyTop], loc);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-5+yyTop]), savedOperatorLocation, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_281()
#line 2311 "cs-parser.jay"
{
		valid_param_mod = 0;

		Location loc = GetLocation (yyVals[-5+yyTop]);
		current_local_parameters = (ParametersCompiled)yyVals[-1+yyTop];  

		if (current_local_parameters.Count != 1) {
			report.Error (1535, loc, "Overloaded unary operator `implicit' takes one parameter");
		}

		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}

		yyVal = new OperatorDeclaration (Operator.OpType.Implicit, (FullNamedExpression) yyVals[-4+yyTop], loc);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_283()
#line 2334 "cs-parser.jay"
{
		valid_param_mod = 0;
		
		Location loc = GetLocation (yyVals[-5+yyTop]);
		current_local_parameters = (ParametersCompiled)yyVals[-1+yyTop];  

		if (current_local_parameters.Count != 1) {
			report.Error (1535, loc, "Overloaded unary operator `explicit' takes one parameter");
		}

		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}

		yyVal = new OperatorDeclaration (Operator.OpType.Explicit, (FullNamedExpression) yyVals[-4+yyTop], loc);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_284()
#line 2353 "cs-parser.jay"
{
	  	Error_SyntaxError (yyToken);
		current_local_parameters = ParametersCompiled.EmptyReadOnlyParameters;
		yyVal = new OperatorDeclaration (Operator.OpType.Implicit, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_285()
#line 2359 "cs-parser.jay"
{
	  	Error_SyntaxError (yyToken);
		current_local_parameters = ParametersCompiled.EmptyReadOnlyParameters;
	  	yyVal = new OperatorDeclaration (Operator.OpType.Explicit, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_286()
#line 2369 "cs-parser.jay"
{ 
		Constructor c = (Constructor) yyVals[-1+yyTop];
		c.Block = (ToplevelBlock) yyVals[0+yyTop];
		
		if (doc_support)
			c.DocComment = ConsumeStoredComment ();

		current_local_parameters = null;
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_287()
#line 2386 "cs-parser.jay"
{
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		valid_param_mod = ParameterModifierType.All;
	  }

void case_288()
#line 2395 "cs-parser.jay"
{
		valid_param_mod = 0;
		current_local_parameters = (ParametersCompiled) yyVals[-1+yyTop];
		
		var lt = (LocatedToken) yyVals[-4+yyTop];
		var mods = (Modifiers) yyVals[-5+yyTop];
		var c = new Constructor (current_type, lt.Value, mods, (Attributes) yyVals[-6+yyTop], current_local_parameters, lt.Location);

		if (lt.Value != current_container.MemberName.Name) {
			report.Error (1520, c.Location, "Class, struct, or interface method must have a return type");
		} else if ((mods & Modifiers.STATIC) != 0) {
			if ((mods & Modifiers.AccessibilityMask) != 0){
				report.Error (515, c.Location,
					"`{0}': static constructor cannot have an access modifier",
					c.GetSignatureForError ());
			}
		}

		current_type.AddConstructor (c);
		lbag.AddMember (c, GetModifierLocations (), GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
		yyVal = c;

		/**/
		/* start block here, so possible anonymous methods inside*/
		/* constructor initializer can get correct parent block*/
		/**/
	  	start_block (lexer.Location);
	  }

void case_289()
#line 2424 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {
			var c = (Constructor) yyVals[-1+yyTop];
			c.Initializer = (ConstructorInitializer) yyVals[0+yyTop];
			
			if (c.IsStatic) {
				report.Error (514, c.Location,
					"`{0}': static constructor cannot have an explicit `this' or `base' constructor call",
					c.GetSignatureForError ());
			}
		}

		yyVal = yyVals[-1+yyTop];
	  }

void case_295()
#line 2456 "cs-parser.jay"
{
	  	--lexer.parsing_block;
		yyVal = new ConstructorBaseInitializer ((Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_297()
#line 2466 "cs-parser.jay"
{
	  	--lexer.parsing_block;
		yyVal = new ConstructorThisInitializer ((Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_298()
#line 2472 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);	  
		yyVal = new ConstructorThisInitializer (null, GetLocation (yyVals[0+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_299()
#line 2478 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_300()
#line 2486 "cs-parser.jay"
{
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}
		
		current_local_parameters = ParametersCompiled.EmptyReadOnlyParameters;
	  }

void case_301()
#line 2495 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-3+yyTop];
		if (lt.Value != current_container.MemberName.Name){
			report.Error (574, lt.Location, "Name of destructor must match name of class");
		} else if (current_container.Kind != MemberKind.Class){
			report.Error (575, lt.Location, "Only class types can contain destructor");
		}
		
		Destructor d = new Destructor (current_type, (Modifiers) yyVals[-6+yyTop],
			ParametersCompiled.EmptyReadOnlyParameters, (Attributes) yyVals[-7+yyTop], lt.Location);
		d.Identifier = lt.Value;
		if (doc_support)
			d.DocComment = ConsumeStoredComment ();
		  
		d.Block = (ToplevelBlock) yyVals[0+yyTop];
		current_type.AddMember (d);
		lbag.AddMember (d, GetModifierLocations (), GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[-1+yyTop]));

		current_local_parameters = null;
	  }

void case_302()
#line 2521 "cs-parser.jay"
{
		current_event_field = new EventField (current_type, (FullNamedExpression) yyVals[-1+yyTop], (Modifiers) yyVals[-3+yyTop], (MemberName) yyVals[0+yyTop], (Attributes) yyVals[-4+yyTop]);
		current_type.AddMember (current_event_field);
		
		if (current_event_field.MemberName.ExplicitInterface != null) {
			report.Error (71, current_event_field.Location, "`{0}': An explicit interface implementation of an event must use property syntax",
			current_event_field.GetSignatureForError ());
		}
		
		yyVal = current_event_field;
	  }

void case_303()
#line 2535 "cs-parser.jay"
{
		if (doc_support) {
			current_event_field.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		if (current_event_field.Initializer != null) {
			lbag.AddMember (current_event_field, GetModifierLocations (), GetLocation (yyVals[-6+yyTop]), savedEventAssignLocation, GetLocation (yyVals[0+yyTop]));
		} else {
			lbag.AddMember (current_event_field, GetModifierLocations (), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[0+yyTop]));
		}
		current_event_field = null;
	  }

void case_304()
#line 2551 "cs-parser.jay"
{
		current_event = new EventProperty (current_type, (FullNamedExpression) yyVals[-2+yyTop], (Modifiers) yyVals[-4+yyTop], (MemberName) yyVals[-1+yyTop], (Attributes) yyVals[-5+yyTop]);
		current_type.AddMember (current_event);
		lbag.AddMember (current_event, GetModifierLocations (), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
		
		lexer.EventParsing = true;
	  }

void case_305()
#line 2559 "cs-parser.jay"
{
		if (current_container.Kind == MemberKind.Interface)
			report.Error (69, GetLocation (yyVals[-2+yyTop]), "Event in interface cannot have add or remove accessors");
	  
		lexer.EventParsing = false;
	  }

void case_306()
#line 2566 "cs-parser.jay"
{
		if (doc_support) {
			current_event.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		lbag.AppendToMember (current_event, GetLocation (yyVals[-1+yyTop]));
	  	current_event = null;	
		current_local_parameters = null;
	  }

void case_307()
#line 2579 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		current_type.AddMember (new EventField (current_type, (FullNamedExpression) yyVals[-1+yyTop], (Modifiers) yyVals[-3+yyTop], MemberName.Null, (Attributes) yyVals[-4+yyTop]));
	  }

void case_310()
#line 2593 "cs-parser.jay"
{
	  	--lexer.parsing_block;
	  	savedEventAssignLocation = GetLocation (yyVals[-2+yyTop]);
		current_event_field.Initializer = (Expression) yyVals[0+yyTop];
	  }

void case_315()
#line 2618 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];
	  	yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), null);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_317()
#line 2628 "cs-parser.jay"
{
		--lexer.parsing_block;
		var lt = (LocatedToken) yyVals[-3+yyTop];	  
	  	yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), (Expression) yyVals[0+yyTop]);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_318()
#line 2637 "cs-parser.jay"
{
		if (current_container.Kind == MemberKind.Interface) {
			report.Error (68, lexer.Location, "`{0}': event in interface cannot have an initializer",
				current_event_field.GetSignatureForError ());
		}
		
	  	if ((current_event_field.ModFlags & Modifiers.ABSTRACT) != 0) {
			report.Error (74, lexer.Location, "`{0}': abstract event cannot have an initializer",
				current_event_field.GetSignatureForError ());
	  	}		
	  }

void case_322()
#line 2658 "cs-parser.jay"
{
		report.Error (65, lexer.Location, "`{0}': event property must have both add and remove accessors",
			current_event.GetSignatureForError ());
	  }

void case_323()
#line 2663 "cs-parser.jay"
{
		report.Error (65, lexer.Location, "`{0}': event property must have both add and remove accessors",
			current_event.GetSignatureForError ());
	  }

void case_324()
#line 2668 "cs-parser.jay"
{ 
		report.Error (1055, GetLocation (yyVals[0+yyTop]), "An add or remove accessor expected");
		yyVal = null;
	  }

void case_325()
#line 2676 "cs-parser.jay"
{
	  	if (yyVals[-1+yyTop] != ModifierNone) {
			report.Error (1609, GetLocation (yyVals[-1+yyTop]), "Modifiers cannot be placed on event accessor declarations");
	  	}
	  	
	  	current_event.Add = new EventProperty.AddDelegateMethod (current_event, (Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		current_local_parameters = current_event.Add.ParameterInfo;
		
		lbag.AddMember (current_event.Add, GetModifierLocations ());
		lexer.EventParsing = false;		
	  }

void case_326()
#line 2688 "cs-parser.jay"
{
		lexer.EventParsing = true;
	  
	  	current_event.Add.Block = (ToplevelBlock) yyVals[0+yyTop];
		
		if (current_container.Kind == MemberKind.Interface) {
			report.Error (531, current_event.Add.Block.StartLocation,
				"`{0}': interface members cannot have a definition", current_event.Add.GetSignatureForError ());
		}
		
		current_local_parameters = null;
	  }

void case_327()
#line 2704 "cs-parser.jay"
{
	  	if (yyVals[-1+yyTop] != ModifierNone) {
			report.Error (1609, GetLocation (yyVals[-1+yyTop]), "Modifiers cannot be placed on event accessor declarations");
	  	}
	  	
	  	current_event.Remove = new EventProperty.RemoveDelegateMethod (current_event, (Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		current_local_parameters = current_event.Remove.ParameterInfo;

		lbag.AddMember (current_event.Remove, GetModifierLocations ());
		lexer.EventParsing = false;		
	  }

void case_328()
#line 2716 "cs-parser.jay"
{
		lexer.EventParsing = true;
	  
	  	current_event.Remove.Block = (ToplevelBlock) yyVals[0+yyTop];
		
		if (current_container.Kind == MemberKind.Interface) {
			report.Error (531, current_event.Remove.Block.StartLocation,
				"`{0}': interface members cannot have a definition", current_event.Remove.GetSignatureForError ());
		}
		
		current_local_parameters = null;
	  }

void case_329()
#line 2732 "cs-parser.jay"
{
		report.Error (73, lexer.Location, "An add or remove accessor must have a body");
		yyVal = null;
	  }

void case_331()
#line 2741 "cs-parser.jay"
{
		current_type.UnattachedAttributes = (Attributes) yyVals[-1+yyTop];
		report.Error (1519, GetLocation (yyVals[-1+yyTop]), "An attribute is missing member declaration");
		lexer.putback ('}');
	  }

void case_332()
#line 2752 "cs-parser.jay"
{
		report.Error (1519, lexer.Location, "Unexpected symbol `}' in class, struct, or interface member declaration");
 
		lexer.putback ('}');

	  	lexer.parsing_generic_declaration = false;
		FullNamedExpression type = (FullNamedExpression) yyVals[-1+yyTop];
		current_field = new Field (current_type, type, (Modifiers) yyVals[-2+yyTop], MemberName.Null, (Attributes) yyVals[-3+yyTop]);
		current_type.AddField (current_field);
		lbag.AddMember (current_field, GetModifierLocations ());
		yyVal = current_field;
	  }

void case_333()
#line 2772 "cs-parser.jay"
{
		if (doc_support)
			enumTypeComment = Lexer.consume_doc_comment ();
	  }

void case_334()
#line 2777 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;

		MemberName name = (MemberName) yyVals[-3+yyTop];
		if (name.IsGeneric) {
			report.Error (1675, name.Location, "Enums cannot have type parameters");
		}
		
		push_current_container (new Enum (current_container, (FullNamedExpression) yyVals[-2+yyTop], (Modifiers) yyVals[-5+yyTop], name, (Attributes) yyVals[-6+yyTop]), null);
		if (yyVals[-2+yyTop] != null) {
			lbag.AddMember (current_container, GetModifierLocations (), GetLocation (yyVals[-4+yyTop]), savedLocation, GetLocation (yyVals[0+yyTop]));
		} else {
			lbag.AddMember (current_container, GetModifierLocations (), GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[0+yyTop]));
		}
	  }

void case_335()
#line 2794 "cs-parser.jay"
{
		lexer.parsing_modifiers = true;
	  
	  	/* here will be evaluated after CLOSE_BLACE is consumed.*/
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_336()
#line 2802 "cs-parser.jay"
{
		lbag.AppendToMember (current_container, GetLocation (yyVals[-1+yyTop]));
		if (yyVals[0+yyTop] != null) {
			lbag.AppendToMember (current_container, GetLocation (yyVals[0+yyTop]));
		}
		if (doc_support)
			current_container.DocComment = enumTypeComment;
			
		--lexer.parsing_declaration;

/*			if (doc_support)*/
/*				em.DocComment = ev.DocComment;*/

		yyVal = pop_current_class ();
	  }

void case_338()
#line 2822 "cs-parser.jay"
{
		savedLocation = GetLocation (yyVals[-1+yyTop]);
		yyVal = yyVals[0+yyTop];
	 }

void case_339()
#line 2827 "cs-parser.jay"
{
	 	Error_TypeExpected (GetLocation (yyVals[-1+yyTop]));
		yyVal = null;
	 }

void case_344()
#line 2845 "cs-parser.jay"
{
		lbag.AppendToMember (current_container, GetLocation (yyVals[-1+yyTop]));
	  	yyVal = yyVals[0+yyTop];
	  }

void case_345()
#line 2853 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];
	  	var em = new EnumMember ((Enum) current_type, new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-1+yyTop]);
	  	((Enum) current_type).AddEnumMember (em);

		if (doc_support) {
			em.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}

		yyVal = em;
	  }

void case_346()
#line 2866 "cs-parser.jay"
{
	  	++lexer.parsing_block;
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}
	  }

void case_347()
#line 2874 "cs-parser.jay"
{ 
		--lexer.parsing_block;
		
		var lt = (LocatedToken) yyVals[-3+yyTop];
	  	var em = new EnumMember ((Enum) current_type, new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-4+yyTop]);
	  	em.Initializer = new ConstInitializer (em, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  	((Enum) current_type).AddEnumMember (em);
		
		if (doc_support)
			em.DocComment = ConsumeStoredComment ();

		yyVal = em;
	  }

void case_348()
#line 2888 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
	  
		var lt = (LocatedToken) yyVals[-1+yyTop];
	  	var em = new EnumMember ((Enum) current_type, new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-2+yyTop]);
	  	((Enum) current_type).AddEnumMember (em);

		if (doc_support) {
			em.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}

		yyVal = em;
	  }

void case_351()
#line 2915 "cs-parser.jay"
{
		valid_param_mod = 0;

		ParametersCompiled p = (ParametersCompiled) yyVals[-1+yyTop];

		Delegate del = new Delegate (current_container, (FullNamedExpression) yyVals[-5+yyTop], (Modifiers) yyVals[-7+yyTop], (MemberName) yyVals[-4+yyTop], p, (Attributes) yyVals[-8+yyTop]);

		p.CheckParameters (del);

		current_container.AddTypeContainer (del);

		current_delegate = del;
		lexer.ConstraintsParsing = true;
	  }

void case_353()
#line 2934 "cs-parser.jay"
{
		if (doc_support) {
			current_delegate.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
	  
		if (yyVals[-2+yyTop] != null)
			current_delegate.SetConstraints ((List<Constraints>) yyVals[-2+yyTop]);
		lbag.AddMember (current_delegate, GetModifierLocations (), GetLocation (yyVals[-10+yyTop]), GetLocation (yyVals[-7+yyTop]), GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[0+yyTop]));

		yyVal = current_delegate;

		current_delegate = null;
	  }

void case_355()
#line 2953 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[0+yyTop]), "nullable types");
	  
	  	yyVal = ComposedTypeSpecifier.CreateNullable (GetLocation (yyVals[0+yyTop]));
	  }

void case_357()
#line 2964 "cs-parser.jay"
{
		var lt1 = (LocatedToken) yyVals[-2+yyTop];
		var lt2 = (LocatedToken) yyVals[-1+yyTop];
		
		yyVal = new QualifiedAliasMember (lt1.Value, lt2.Value, (TypeArguments) yyVals[0+yyTop], lt1.Location);
		lbag.AddLocation (yyVal, savedLocation, GetLocation (yyVals[-1+yyTop]));
	  }

void case_358()
#line 2972 "cs-parser.jay"
{
		var lt1 = (LocatedToken) yyVals[-2+yyTop];
		var lt2 = (LocatedToken) yyVals[-1+yyTop];
		var qam = new QualifiedAliasMember (lt1.Value, lt2.Value, (int) yyVals[0+yyTop], lt1.Location);
		lbag.AddLocation (qam.TypeArguments, Lexer.GenericDimensionLocations);
		yyVal = qam;
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_360()
#line 2985 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_361()
#line 2991 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		var ma = new MemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, (int) yyVals[0+yyTop], lt.Location);
		lbag.AddLocation (ma.TypeArguments, Lexer.GenericDimensionLocations);
		yyVal = ma;
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_362()
#line 3002 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new SimpleName (lt.Value, (TypeArguments)yyVals[0+yyTop], lt.Location);
	  }

void case_363()
#line 3007 "cs-parser.jay"
{  
		var lt = (LocatedToken) yyVals[-1+yyTop];
		var sn = new SimpleName (lt.Value, (int) yyVals[0+yyTop], lt.Location);
		lbag.AddLocation (sn.TypeArguments, Lexer.GenericDimensionLocations);
		yyVal = sn;
	  }

void case_365()
#line 3021 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "generics");
		var list = locationListStack.Pop ();
		list.Add (GetLocation (yyVals[-2+yyTop]));
		list.Add (GetLocation (yyVals[-1+yyTop]));
		lbag.AddLocation (yyVals[-1+yyTop], list);
	
		yyVal = yyVals[-1+yyTop];;
	  }

void case_366()
#line 3032 "cs-parser.jay"
{
		Error_TypeExpected (lexer.Location);
		yyVal = new TypeArguments ();
	  }

void case_367()
#line 3040 "cs-parser.jay"
{
		TypeArguments type_args = new TypeArguments ();
		type_args.Add ((FullNamedExpression) yyVals[0+yyTop]);
		yyVal = type_args;
		locationListStack.Push (new List<Location> ());
	  }

void case_368()
#line 3047 "cs-parser.jay"
{
		TypeArguments type_args = (TypeArguments) yyVals[-2+yyTop];
		type_args.Add ((FullNamedExpression) yyVals[0+yyTop]);
		yyVal = type_args;
		locationListStack.Peek ().Add (GetLocation (yyVals[-1+yyTop]));
	  }

void case_370()
#line 3064 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;
		var lt = (LocatedToken) yyVals[-2+yyTop];
		yyVal = new MemberName (lt.Value, (TypeParameters)yyVals[0+yyTop], lt.Location);
	  }

void case_371()
#line 3073 "cs-parser.jay"
{
	  	MemberName mn = (MemberName)yyVals[0+yyTop];
	  	if (mn.TypeParameters != null)
	  		syntax_error (mn.Location, string.Format ("Member `{0}' cannot declare type arguments",
	  			mn.GetSignatureForError ()));
	  }

void case_373()
#line 3084 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;	  
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberName (lt.Value, (TypeParameters) yyVals[0+yyTop], (ATypeNameExpression) yyVals[-2+yyTop], lt.Location);
	  }

void case_374()
#line 3093 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;	  
		yyVal = new MemberName (TypeDefinition.DefaultIndexerName, GetLocation (yyVals[0+yyTop]));
	  }

void case_375()
#line 3098 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;
		yyVal = new MemberName (TypeDefinition.DefaultIndexerName, null, (ATypeNameExpression) yyVals[-1+yyTop], GetLocation (yyVals[0+yyTop]));
	  }

void case_376()
#line 3106 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-2+yyTop];
		yyVal = new SimpleName (lt.Value, (TypeArguments) yyVals[-1+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_377()
#line 3112 "cs-parser.jay"
{
		var lt1 = (LocatedToken) yyVals[-3+yyTop];
		var lt2 = (LocatedToken) yyVals[-2+yyTop];

		yyVal = new QualifiedAliasMember (lt1.Value, lt2.Value, (TypeArguments) yyVals[-1+yyTop], lt1.Location);
		lbag.AddLocation (yyVal, savedLocation, GetLocation (yyVals[0+yyTop]));
	  }

void case_378()
#line 3120 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-2+yyTop];
		yyVal = new MemberAccess ((ATypeNameExpression) yyVals[-3+yyTop], lt.Value, (TypeArguments) yyVals[-1+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_380()
#line 3130 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "generics");
	  
		yyVal = yyVals[-1+yyTop];
		var list = locationListStack.Pop ();
		list.Add (GetLocation (yyVals[-2+yyTop]));
		list.Add (GetLocation (yyVals[-1+yyTop]));
		lbag.AddLocation (yyVals[-1+yyTop], list);
	  }

void case_381()
#line 3144 "cs-parser.jay"
{
		var tparams = new TypeParameters ();
		tparams.Add ((TypeParameter)yyVals[0+yyTop]);
		yyVal = tparams;
		locationListStack.Push (new List<Location> ());
	  }

void case_382()
#line 3151 "cs-parser.jay"
{
		var tparams = (TypeParameters) yyVals[-2+yyTop];
		tparams.Add ((TypeParameter)yyVals[0+yyTop]);
		yyVal = tparams;
		locationListStack.Peek ().Add (GetLocation (yyVals[-1+yyTop]));
	  }

void case_383()
#line 3161 "cs-parser.jay"
{
		var lt = (LocatedToken)yyVals[0+yyTop];
		var variance = (VarianceDecl) yyVals[-1+yyTop];
		yyVal = new TypeParameter (new MemberName (lt.Value, lt.Location), (Attributes)yyVals[-2+yyTop], variance);
		if (variance != null)
			lbag.AddLocation (yyVal, savedLocation);
  	  }

void case_384()
#line 3169 "cs-parser.jay"
{
  	  	if (GetTokenName (yyToken) == "type")
			report.Error (81, GetLocation (yyVals[0+yyTop]), "Type parameter declaration must be an identifier not a type");
		else
			Error_SyntaxError (yyToken);
			
  	  	yyVal = new TypeParameter (MemberName.Null, null, null);
  	  }

void case_393()
#line 3213 "cs-parser.jay"
{
		report.Error (1536, GetLocation (yyVals[0+yyTop]), "Invalid parameter type `void'");
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }

void case_396()
#line 3229 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {
			yyVal = new ComposedCast ((ATypeNameExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
		} else {
			var sn = yyVals[-1+yyTop] as SimpleName;
			if (sn != null && sn.Name == "var")
				yyVal = new VarExpr (sn.Location);
			else
				yyVal = yyVals[-1+yyTop];
		}
	  }

void case_399()
#line 3249 "cs-parser.jay"
{
		Expression.Error_VoidInvalidInTheContext (GetLocation (yyVals[0+yyTop]), report);
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }

void case_400()
#line 3257 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null)
			yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }

void case_403()
#line 3273 "cs-parser.jay"
{
		var types = new List<FullNamedExpression> (2);
		types.Add ((FullNamedExpression) yyVals[0+yyTop]);
		yyVal = types;
	  }

void case_404()
#line 3279 "cs-parser.jay"
{
		var types = (List<FullNamedExpression>) yyVals[-2+yyTop];
		types.Add ((FullNamedExpression) yyVals[0+yyTop]);
		lbag.AddLocation (types, GetLocation (yyVals[-1+yyTop]));
		yyVal = types;
	  }

void case_405()
#line 3289 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is ComposedCast) {
			report.Error (1521, GetLocation (yyVals[0+yyTop]), "Invalid base type `{0}'", ((ComposedCast)yyVals[0+yyTop]).GetSignatureForError ());
		}
		yyVal = yyVals[0+yyTop];
	  }

void case_443()
#line 3353 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
	       yyVal = new CompletionSimpleName (MemberName.MakeName (lt.Value, null), lt.Location);
	  }

void case_454()
#line 3394 "cs-parser.jay"
{
		yyVal = new ParenthesizedExpression ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_456()
#line 3406 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_457()
#line 3412 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		var ma = new MemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, (int) yyVals[0+yyTop], lt.Location);
		lbag.AddLocation (ma.TypeArguments, Lexer.GenericDimensionLocations);
		yyVal = ma;
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_458()
#line 3420 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.V_6)
			FeatureIsNotAvailable (GetLocation (yyVals[-3+yyTop]), "null propagating operator");

		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new ConditionalMemberAccess ((Expression) yyVals[-4+yyTop], lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_459()
#line 3429 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_460()
#line 3435 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess (new BaseThis (GetLocation (yyVals[-3+yyTop])), lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_461()
#line 3441 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess (new SimpleName ("await", ((LocatedToken) yyVals[-3+yyTop]).Location), lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_462()
#line 3447 "cs-parser.jay"
{
		var lt1 = (LocatedToken) yyVals[-2+yyTop];
		var lt2 = (LocatedToken) yyVals[-1+yyTop];

		yyVal = new QualifiedAliasMember (lt1.Value, lt2.Value, (TypeArguments) yyVals[0+yyTop], lt1.Location);
		lbag.AddLocation (yyVal, savedLocation, GetLocation (yyVals[-1+yyTop]));
	  }

void case_463()
#line 3455 "cs-parser.jay"
{
		var lt1 = (LocatedToken) yyVals[-2+yyTop];
		var lt2 = (LocatedToken) yyVals[-1+yyTop];
		var qam = new QualifiedAliasMember (lt1.Value, lt2.Value, (int) yyVals[0+yyTop], lt1.Location);
		lbag.AddLocation (qam.TypeArguments, Lexer.GenericDimensionLocations);
		yyVal = qam;
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_465()
#line 3466 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new CompletionMemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, lt.Location);
	  }

void case_467()
#line 3474 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new CompletionMemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, lt.Location);
 	  }

void case_468()
#line 3482 "cs-parser.jay"
{
		yyVal = new Invocation ((Expression) yyVals[-3+yyTop], (Arguments) yyVals[-1+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_469()
#line 3487 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Invocation ((Expression) yyVals[-3+yyTop], (Arguments) yyVals[-1+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_470()
#line 3494 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Invocation ((Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_473()
#line 3509 "cs-parser.jay"
{
	  	if (yyVals[-1+yyTop] == null) {
	  		yyVal = new CollectionOrObjectInitializers (GetLocation (yyVals[-2+yyTop]));
	  	} else {
	  		yyVal = new CollectionOrObjectInitializers ((List<Expression>) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	  	}
 		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_474()
#line 3518 "cs-parser.jay"
{
	  	yyVal = new CollectionOrObjectInitializers ((List<Expression>) yyVals[-2+yyTop], GetLocation (yyVals[-3+yyTop]));
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_477()
#line 3534 "cs-parser.jay"
{
	  	var a = new List<Expression> ();
	  	a.Add ((Expression) yyVals[0+yyTop]);
	  	yyVal = a;
	  }

void case_478()
#line 3540 "cs-parser.jay"
{
	  	var a = (List<Expression>)yyVals[-2+yyTop];
	  	a.Add ((Expression) yyVals[0+yyTop]);
		lbag.AddLocation (a, GetLocation (yyVals[-1+yyTop]));
	  	yyVal = a;
	  }

void case_479()
#line 3546 "cs-parser.jay"
{
	  	Error_SyntaxError (yyToken);
		yyVal = yyVals[-1+yyTop];
	  }

void case_480()
#line 3554 "cs-parser.jay"
{
	  	var lt = (LocatedToken) yyVals[-2+yyTop];
	  	yyVal = new ElementInitializer (lt.Value, (Expression)yyVals[0+yyTop], lt.Location);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_481()
#line 3560 "cs-parser.jay"
{
	  	var lt = (LocatedToken) Error_AwaitAsIdentifier (yyVals[-2+yyTop]);
	  	yyVal = new ElementInitializer (lt.Value, (Expression)yyVals[0+yyTop], lt.Location);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_483()
#line 3569 "cs-parser.jay"
{
		CompletionSimpleName csn = yyVals[-1+yyTop] as CompletionSimpleName;
		if (csn == null)
			yyVal = new CollectionElementInitializer ((Expression)yyVals[-1+yyTop]);
		else
			yyVal = new CompletionElementInitializer (csn.Prefix, csn.Location);
	  }

void case_484()
#line 3577 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] == null)
			yyVal = new CollectionElementInitializer (GetLocation (yyVals[-2+yyTop]));
		else {
	  		yyVal = new CollectionElementInitializer ((List<Expression>)yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
			lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
		}
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_485()
#line 3587 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.V_6)
			FeatureIsNotAvailable (GetLocation (yyVals[-4+yyTop]), "dictionary initializer");

		yyVal = new DictionaryElementInitializer ((List<Expression>)yyVals[-3+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_486()
#line 3595 "cs-parser.jay"
{
	  	report.Error (1920, GetLocation (yyVals[-1+yyTop]), "An element initializer cannot be empty");
		yyVal = new CollectionElementInitializer (GetLocation (yyVals[-1+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_491()
#line 3614 "cs-parser.jay"
{ 
		Arguments list = new Arguments (4);
		list.Add ((Argument) yyVals[0+yyTop]);
		yyVal = list;
	  }

void case_492()
#line 3620 "cs-parser.jay"
{
		Arguments list = (Arguments) yyVals[-2+yyTop];
		if (list [list.Count - 1] is NamedArgument)
			Error_NamedArgumentExpected ((NamedArgument) list [list.Count - 1]);
		
		list.Add ((Argument) yyVals[0+yyTop]);
		lbag.AddLocation (list, GetLocation (yyVals[-1+yyTop]));
		yyVal = list;
	  }

void case_493()
#line 3630 "cs-parser.jay"
{
		Arguments list = (Arguments) yyVals[-2+yyTop];
		NamedArgument a = (NamedArgument) yyVals[0+yyTop];
		for (int i = 0; i < list.Count; ++i) {
			NamedArgument na = list [i] as NamedArgument;
			if (na != null && na.Name == a.Name)
				report.Error (1740, na.Location, "Named argument `{0}' specified multiple times",
					na.Name);
		}
		
		list.Add (a);
		lbag.AddLocation (list, GetLocation (yyVals[-1+yyTop]));
		yyVal = list;
	  }

void case_494()
#line 3645 "cs-parser.jay"
{
	  	if (lexer.putback_char == -1)
	  		lexer.putback (')'); /* TODO: Wrong but what can I do*/
		Error_SyntaxError (yyToken);
		yyVal = yyVals[-2+yyTop];
	  }

void case_495()
#line 3652 "cs-parser.jay"
{
	  	report.Error (839, GetLocation (yyVals[-1+yyTop]), "An argument is missing");
	  	yyVal = null;
	  }

void case_500()
#line 3673 "cs-parser.jay"
{ 
		yyVal = new Argument ((Expression) yyVals[0+yyTop], Argument.AType.Ref);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_501()
#line 3678 "cs-parser.jay"
{ 
		yyVal = new Argument ((Expression) yyVals[0+yyTop], Argument.AType.Out);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_502()
#line 3683 "cs-parser.jay"
{
		yyVal = new Argument (new Arglist ((Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop])));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_503()
#line 3688 "cs-parser.jay"
{
		yyVal = new Argument (new Arglist (GetLocation (yyVals[-2+yyTop])));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_505()
#line 3700 "cs-parser.jay"
{
		yyVal = new ElementAccess ((Expression) yyVals[-3+yyTop], (Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_506()
#line 3705 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.V_6)
			FeatureIsNotAvailable (GetLocation (yyVals[-3+yyTop]), "null propagating operator");

		yyVal = new ElementAccess ((Expression) yyVals[-4+yyTop], (Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop])) {
			ConditionalAccess = true
		};

		lbag.AddLocation (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_507()
#line 3716 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new ElementAccess ((Expression) yyVals[-3+yyTop], (Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }

void case_508()
#line 3721 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new ElementAccess ((Expression) yyVals[-2+yyTop], null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_509()
#line 3729 "cs-parser.jay"
{
		var list = new List<Expression> (4);
		list.Add ((Expression) yyVals[0+yyTop]);
		yyVal = list;
	  }

void case_510()
#line 3735 "cs-parser.jay"
{
		var list = (List<Expression>) yyVals[-2+yyTop];
		list.Add ((Expression) yyVals[0+yyTop]);
		lbag.AddLocation (list, GetLocation (yyVals[-1+yyTop]));
		yyVal = list;
	  }

void case_511()
#line 3745 "cs-parser.jay"
{
		Arguments args = new Arguments (4);
		args.Add ((Argument) yyVals[0+yyTop]);
		yyVal = args;
	  }

void case_512()
#line 3751 "cs-parser.jay"
{
		Arguments args = (Arguments) yyVals[-2+yyTop];
		if (args [args.Count - 1] is NamedArgument && !(yyVals[0+yyTop] is NamedArgument))
			Error_NamedArgumentExpected ((NamedArgument) args [args.Count - 1]);
	  
		args.Add ((Argument) yyVals[0+yyTop]);
		lbag.AddLocation (args, GetLocation (yyVals[-1+yyTop]));
		yyVal = args;	  
	  }

void case_516()
#line 3779 "cs-parser.jay"
{
	  	yyVal = new ElementAccess (new BaseThis (GetLocation (yyVals[-3+yyTop])), (Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_517()
#line 3784 "cs-parser.jay"
{
	  	Error_SyntaxError (yyToken);
		yyVal = new ElementAccess (null, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_520()
#line 3806 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {
			if (lang_version <= LanguageVersion.ISO_2)
				FeatureIsNotAvailable (GetLocation (yyVals[-5+yyTop]), "object initializers");
				
			yyVal = new NewInitialize ((FullNamedExpression) yyVals[-4+yyTop], (Arguments) yyVals[-2+yyTop], (CollectionOrObjectInitializers) yyVals[0+yyTop], GetLocation (yyVals[-5+yyTop]));
		} else {
			yyVal = new New ((FullNamedExpression) yyVals[-4+yyTop], (Arguments) yyVals[-2+yyTop], GetLocation (yyVals[-5+yyTop]));
		}
		
		lbag.AddLocation (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_521()
#line 3819 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "collection initializers");
	  
		yyVal = new NewInitialize ((FullNamedExpression) yyVals[-1+yyTop], null, (CollectionOrObjectInitializers) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }

void case_522()
#line 3831 "cs-parser.jay"
{
		yyVal = new ArrayCreation ((FullNamedExpression) yyVals[-5+yyTop], (List<Expression>) yyVals[-3+yyTop],
				new ComposedTypeSpecifier (((List<Expression>) yyVals[-3+yyTop]).Count, GetLocation (yyVals[-4+yyTop])) {
	  				Next = (ComposedTypeSpecifier) yyVals[-1+yyTop]
			  	}, (ArrayInitializer) yyVals[0+yyTop], GetLocation (yyVals[-6+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_523()
#line 3839 "cs-parser.jay"
{
	  	if (yyVals[0+yyTop] == null)
	  		report.Error (1586, GetLocation (yyVals[-3+yyTop]), "Array creation must have array size or array initializer");

		yyVal = new ArrayCreation ((FullNamedExpression) yyVals[-2+yyTop], (ComposedTypeSpecifier) yyVals[-1+yyTop], (ArrayInitializer) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
	  }

void case_524()
#line 3846 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "implicitly typed arrays");
	  
		yyVal = new ImplicitlyTypedArrayCreation ((ComposedTypeSpecifier) yyVals[-1+yyTop], (ArrayInitializer) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }

void case_525()
#line 3853 "cs-parser.jay"
{
		report.Error (178, GetLocation (yyVals[-1+yyTop]), "Invalid rank specifier, expecting `,' or `]'");
		yyVal = new ArrayCreation ((FullNamedExpression) yyVals[-5+yyTop], null, GetLocation (yyVals[-6+yyTop]));
	  }

void case_526()
#line 3858 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		/* It can be any of new expression, create the most common one*/
		yyVal = new New ((FullNamedExpression) yyVals[-1+yyTop], null, GetLocation (yyVals[-2+yyTop]));
	  }

void case_528()
#line 3870 "cs-parser.jay"
{
		--lexer.parsing_type;
		yyVal = yyVals[0+yyTop];
	  }

void case_529()
#line 3878 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.ISO_2)
	  		FeatureIsNotAvailable (GetLocation (yyVals[-3+yyTop]), "anonymous types");

		yyVal = new NewAnonymousType ((List<AnonymousTypeParameter>) yyVals[-1+yyTop], current_container, GetLocation (yyVals[-3+yyTop]));
		
		/* TODO: lbag comma location*/
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_535()
#line 3905 "cs-parser.jay"
{
	  	var a = new List<AnonymousTypeParameter> (4);
	  	a.Add ((AnonymousTypeParameter) yyVals[0+yyTop]);
	  	yyVal = a;
	  }

void case_536()
#line 3911 "cs-parser.jay"
{
	  	var a = (List<AnonymousTypeParameter>) yyVals[-2+yyTop];
	  	a.Add ((AnonymousTypeParameter) yyVals[0+yyTop]);
	  	lbag.AddLocation (a, GetLocation (yyVals[-1+yyTop]));

	  	yyVal = a;
	  }

void case_539()
#line 3930 "cs-parser.jay"
{
		var lt = (LocatedToken)yyVals[-2+yyTop];
	  	yyVal = new AnonymousTypeParameter ((Expression)yyVals[0+yyTop], lt.Value, lt.Location);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_540()
#line 3936 "cs-parser.jay"
{
		var lt = (LocatedToken)yyVals[0+yyTop];
	  	yyVal = new AnonymousTypeParameter (new SimpleName (lt.Value, lt.Location),
	  		lt.Value, lt.Location);
	  }

void case_541()
#line 3942 "cs-parser.jay"
{
	  	MemberAccess ma = (MemberAccess) yyVals[0+yyTop];
	  	yyVal = new AnonymousTypeParameter (ma, ma.Name, ma.Location);
	  }

void case_542()
#line 3947 "cs-parser.jay"
{
		report.Error (746, lexer.Location,
			"Invalid anonymous type member declarator. Anonymous type members must be a member assignment, simple name or member access expression");
		yyVal = null;
	  }

void case_546()
#line 3962 "cs-parser.jay"
{
	  	((ComposedTypeSpecifier) yyVals[-1+yyTop]).Next = (ComposedTypeSpecifier) yyVals[0+yyTop];
	  	yyVal = yyVals[-1+yyTop];
	  }

void case_547()
#line 3970 "cs-parser.jay"
{
		yyVal = ComposedTypeSpecifier.CreateArrayDimension (1, GetLocation (yyVals[-1+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_548()
#line 3975 "cs-parser.jay"
{
		yyVal = ComposedTypeSpecifier.CreateArrayDimension ((int)yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_553()
#line 4005 "cs-parser.jay"
{
		var ai = new ArrayInitializer (0, GetLocation (yyVals[-1+yyTop]));
		ai.VariableDeclaration = current_variable;
		lbag.AddLocation (ai, GetLocation (yyVals[0+yyTop]));
		yyVal = ai;
	  }

void case_554()
#line 4012 "cs-parser.jay"
{
		var ai = new ArrayInitializer ((List<Expression>) yyVals[-2+yyTop], GetLocation (yyVals[-3+yyTop]));
		ai.VariableDeclaration = current_variable;
		if (yyVals[-1+yyTop] != null) {
			lbag.AddLocation (ai, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
		} else {
			lbag.AddLocation (ai, GetLocation (yyVals[0+yyTop]));
		}
		yyVal = ai;
	  }

void case_555()
#line 4026 "cs-parser.jay"
{
		var list = new List<Expression> (4);
		list.Add ((Expression) yyVals[0+yyTop]);
		yyVal = list;
	  }

void case_556()
#line 4032 "cs-parser.jay"
{
		var list = (List<Expression>) yyVals[-2+yyTop];
		list.Add ((Expression) yyVals[0+yyTop]);
		lbag.AddLocation (list, GetLocation (yyVals[-1+yyTop]));
		yyVal = list;
	  }

void case_557()
#line 4042 "cs-parser.jay"
{
		yyVal = new TypeOf ((FullNamedExpression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_559()
#line 4051 "cs-parser.jay"
{
	 	Error_TypeExpected (lexer.Location);
	 	yyVal = null;
	 }

void case_560()
#line 4059 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[0+yyTop]), "generics");

		yyVal = yyVals[0+yyTop];
	  }

void case_561()
#line 4069 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		if (lang_version == LanguageVersion.ISO_1)
			FeatureIsNotAvailable (lt.Location, "namespace alias qualifier");
		savedLocation = GetLocation (yyVals[0+yyTop]);
		yyVal = lt;		
	  }

void case_562()
#line 4080 "cs-parser.jay"
{ 
		yyVal = new SizeOf ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_563()
#line 4085 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new SizeOf ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_564()
#line 4095 "cs-parser.jay"
{
		yyVal = new CheckedExpr ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_565()
#line 4100 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new CheckedExpr (null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_566()
#line 4109 "cs-parser.jay"
{
		yyVal = new UnCheckedExpr ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_567()
#line 4114 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new UnCheckedExpr (null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_568()
#line 4123 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess (new Indirection ((Expression) yyVals[-3+yyTop], GetLocation (yyVals[-2+yyTop])), lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location);
	  }

void case_570()
#line 4135 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		if ((ParametersCompiled) yyVals[-2+yyTop] != ParametersCompiled.Undefined) {
			lbag.AddLocation (yyVal, GetLocation (yyVals[-3+yyTop]), PopLocation (), PopLocation ());
		} else {
			lbag.AddLocation (yyVal, GetLocation (yyVals[-3+yyTop]));
		}
	  }

void case_572()
#line 4148 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		
		if ((ParametersCompiled) yyVals[-2+yyTop] != ParametersCompiled.Undefined) {
			lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-3+yyTop]), PopLocation (), PopLocation ());
		} else {
			lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-3+yyTop]));
		}
	  }

void case_576()
#line 4173 "cs-parser.jay"
{
		valid_param_mod = 0;
	  	yyVal = yyVals[-1+yyTop];
	  	PushLocation (GetLocation (yyVals[-1+yyTop]));
	  	PushLocation (GetLocation (yyVals[-3+yyTop]));
	  }

void case_577()
#line 4183 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-3+yyTop]), "default value expression");

		yyVal = new DefaultValueExpression ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_581()
#line 4203 "cs-parser.jay"
{
		yyVal = new Cast ((FullNamedExpression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_582()
#line 4208 "cs-parser.jay"
{
		if (!async_block) {
			 if (current_anonymous_method is LambdaExpression) {
				report.Error (4034, GetLocation (yyVals[-1+yyTop]),
					"The `await' operator can only be used when its containing lambda expression is marked with the `async' modifier");
			} else if (current_anonymous_method != null) {
				report.Error (4035, GetLocation (yyVals[-1+yyTop]),
					"The `await' operator can only be used when its containing anonymous method is marked with the `async' modifier");
			} else if (interactive_async != null) {
				current_block.Explicit.RegisterAsyncAwait ();
				interactive_async = true;
			} else {
				report.Error (4033, GetLocation (yyVals[-1+yyTop]),
					"The `await' operator can only be used when its containing method is marked with the `async' modifier");
			}
		} else {
			current_block.Explicit.RegisterAsyncAwait ();
		}
		
		yyVal = new Await ((Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_583()
#line 4230 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Unary (Unary.Operator.LogicalNot, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_584()
#line 4236 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Unary (Unary.Operator.OnesComplement, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_585()
#line 4242 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Cast ((FullNamedExpression) yyVals[-2+yyTop], null, GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_586()
#line 4249 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Await (null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_594()
#line 4287 "cs-parser.jay"
{ 
		Error_SyntaxError (yyToken);

	  	yyVal = new Unary (Unary.Operator.UnaryPlus, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_595()
#line 4293 "cs-parser.jay"
{ 
		Error_SyntaxError (yyToken);

		yyVal = new Unary (Unary.Operator.UnaryNegation, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_596()
#line 4299 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new UnaryMutator (UnaryMutator.Mode.PreIncrement, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_597()
#line 4305 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new UnaryMutator (UnaryMutator.Mode.PreDecrement, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_598()
#line 4311 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Indirection (null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_599()
#line 4317 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Unary (Unary.Operator.AddressOf, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_601()
#line 4327 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Multiply, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_602()
#line 4332 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Division, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_603()
#line 4337 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Modulus, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_604()
#line 4342 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.Multiply, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_605()
#line 4349 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.Division, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_606()
#line 4356 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.Modulus, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_608()
#line 4367 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Addition, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_609()
#line 4372 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Subtraction, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_610()
#line 4377 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.Addition, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_611()
#line 4384 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.Subtraction, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_613()
#line 4395 "cs-parser.jay"
{
		var is_expr = new Is ((Expression) yyVals[-3+yyTop], (Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		if (yyVals[0+yyTop] != null) {
			if (lang_version != LanguageVersion.Experimental)
				FeatureIsNotAvailable (GetLocation (yyVals[0+yyTop]), "type pattern matching");

			var lt = (LocatedToken) yyVals[0+yyTop];
			is_expr.Variable = new LocalVariable (current_block, lt.Value, lt.Location);
			current_block.AddLocalName (is_expr.Variable);
		}

		yyVal = is_expr;
	  }

void case_614()
#line 4409 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new As ((Expression) yyVals[-2+yyTop], null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_615()
#line 4415 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Is ((Expression) yyVals[-2+yyTop], null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_616()
#line 4421 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-2+yyTop];
		yyVal = new Is (new SimpleName (lt.Value, lt.Location), (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_617()
#line 4426 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-2+yyTop];
		yyVal = new As (new SimpleName (lt.Value, lt.Location), (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_619()
#line 4435 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] is VarExpr)
			yyVals[-1+yyTop] = new SimpleName ("var", ((VarExpr) yyVals[-1+yyTop]).Location);

		yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }

void case_623()
#line 4454 "cs-parser.jay"
{
		Expression expr = (Expression) yyVals[-1+yyTop];
		if (yyVals[0+yyTop] == null) {
			SimpleName sn = expr as SimpleName;
			if (sn != null && sn.Name == "var")
				yyVal = new VarExpr (sn.Location);
			else
				yyVal = yyVals[-1+yyTop];
		} else if (expr is ATypeNameExpression) {
			yyVal = new ComposedCast ((ATypeNameExpression)expr, (ComposedTypeSpecifier) yyVals[0+yyTop]);
		} else {
			Error_ExpectingTypeName (expr);
			yyVal = null;
		}
	  }

void case_624()
#line 4470 "cs-parser.jay"
{
		ATypeNameExpression expr = yyVals[-1+yyTop] as ATypeNameExpression;

		if (expr != null) {
			yyVal = new ComposedCast (expr, (ComposedTypeSpecifier) yyVals[0+yyTop]);
		} else {
			Error_ExpectingTypeName ((Expression)yyVals[-1+yyTop]);
			yyVal = expr;
		}
	  }

void case_628()
#line 4487 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LeftShift, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_629()
#line 4492 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.RightShift, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_630()
#line 4497 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.LeftShift, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_631()
#line 4504 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.RightShift, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_633()
#line 4515 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LessThan, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_634()
#line 4520 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.GreaterThan, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_635()
#line 4525 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LessThanOrEqual, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_636()
#line 4530 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.GreaterThanOrEqual, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_637()
#line 4535 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.LessThan, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_638()
#line 4542 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.GreaterThan, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_639()
#line 4549 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.LessThanOrEqual, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_640()
#line 4556 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.GreaterThanOrEqual, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_642()
#line 4567 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Equality, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_643()
#line 4572 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Inequality, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_644()
#line 4577 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.Equality, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_645()
#line 4584 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.Inequality, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_647()
#line 4595 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.BitwiseAnd, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_648()
#line 4600 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.BitwiseAnd, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_650()
#line 4611 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.ExclusiveOr, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_651()
#line 4616 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.ExclusiveOr, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_653()
#line 4627 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.BitwiseOr, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_654()
#line 4632 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.BitwiseOr, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_656()
#line 4643 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LogicalAnd, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_657()
#line 4648 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.LogicalAnd, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_659()
#line 4659 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LogicalOr, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_660()
#line 4664 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Binary (Binary.Operator.LogicalOr, (Expression) yyVals[-2+yyTop], null);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_662()
#line 4675 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-1+yyTop]), "null coalescing operator");
			
		yyVal = new Nullable.NullCoalescingOperator ((Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_664()
#line 4687 "cs-parser.jay"
{
		yyVal = new Conditional (new BooleanExpression ((Expression) yyVals[-4+yyTop]), (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_665()
#line 4692 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Conditional (new BooleanExpression ((Expression) yyVals[-3+yyTop]), (Expression) yyVals[-1+yyTop], null, GetLocation (yyVals[-2+yyTop]));
	  }

void case_666()
#line 4698 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Conditional (new BooleanExpression ((Expression) yyVals[-4+yyTop]), (Expression) yyVals[-2+yyTop], null, GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_667()
#line 4705 "cs-parser.jay"
{
		Error_SyntaxError (Token.CLOSE_BRACE);

		yyVal = new Conditional (new BooleanExpression ((Expression) yyVals[-4+yyTop]), (Expression) yyVals[-2+yyTop], null, GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
		lexer.putback ('}');
	  }

void case_668()
#line 4716 "cs-parser.jay"
{
		yyVal = new SimpleAssign ((Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_669()
#line 4721 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.Multiply, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_670()
#line 4726 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.Division, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_671()
#line 4731 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.Modulus, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_672()
#line 4736 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.Addition, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_673()
#line 4741 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.Subtraction, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_674()
#line 4746 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.LeftShift, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_675()
#line 4751 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.RightShift, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_676()
#line 4756 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.BitwiseAnd, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_677()
#line 4761 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.BitwiseOr, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_678()
#line 4766 "cs-parser.jay"
{
		yyVal = new CompoundAssign (Binary.Operator.ExclusiveOr, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_679()
#line 4774 "cs-parser.jay"
{
		var pars = new List<Parameter> (4);
		pars.Add ((Parameter) yyVals[0+yyTop]);
		parameterListCommas.Clear ();
		yyVal = pars;
	  }

void case_680()
#line 4781 "cs-parser.jay"
{
		var pars = (List<Parameter>) yyVals[-2+yyTop];
		Parameter p = (Parameter)yyVals[0+yyTop];
		if (pars[0].GetType () != p.GetType ()) {
			report.Error (748, p.Location, "All lambda parameters must be typed either explicitly or implicitly");
		}
		
		pars.Add (p);
		parameterListCommas.Add (GetLocation (yyVals[-1+yyTop]));

		yyVal = pars;
	  }

void case_681()
#line 4797 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];

		yyVal = new Parameter ((FullNamedExpression) yyVals[-1+yyTop], lt.Value, (Parameter.Modifier) yyVals[-2+yyTop], null, lt.Location);
	  }

void case_682()
#line 4803 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];

		yyVal = new Parameter ((FullNamedExpression) yyVals[-1+yyTop], lt.Value, Parameter.Modifier.NONE, null, lt.Location);
	  }

void case_683()
#line 4809 "cs-parser.jay"
{
	  	var lt = (LocatedToken) yyVals[0+yyTop];
		yyVal = new ImplicitLambdaParameter (lt.Value, lt.Location);
	  }

void case_684()
#line 4814 "cs-parser.jay"
{
	  	var lt = (LocatedToken) Error_AwaitAsIdentifier (yyVals[0+yyTop]);
		yyVal = new ImplicitLambdaParameter (lt.Value, lt.Location);
	  }

void case_686()
#line 4822 "cs-parser.jay"
{ 
		var pars_list = (List<Parameter>) yyVals[0+yyTop];
		yyVal = new ParametersCompiled (pars_list.ToArray ());
		lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_688()
#line 4834 "cs-parser.jay"
{
		Block b = end_block (Location.Null);
		b.IsCompilerGenerated = true;
		b.AddStatement (new ContextualReturn ((Expression) yyVals[0+yyTop]));
		yyVal = b;
	  }

void case_690()
#line 4842 "cs-parser.jay"
{
	  	/* Handles only cases like foo = x.FirstOrDefault (l => );*/
	  	/* where we must restore current_variable*/
		Block b = end_block (Location.Null);
		b.IsCompilerGenerated = true;

		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_692()
#line 4856 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_693()
#line 4864 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];	
		Parameter p = new ImplicitLambdaParameter (lt.Value, lt.Location);
		start_anonymous (true, new ParametersCompiled (p), false, lt.Location);
	  }

void case_694()
#line 4870 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_695()
#line 4875 "cs-parser.jay"
{
		var lt = (LocatedToken) Error_AwaitAsIdentifier (yyVals[-1+yyTop]);
		Parameter p = new ImplicitLambdaParameter (lt.Value, lt.Location);
		start_anonymous (true, new ParametersCompiled (p), false, lt.Location);
	  }

void case_696()
#line 4881 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_697()
#line 4886 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		Parameter p = new ImplicitLambdaParameter (lt.Value, lt.Location);
		start_anonymous (true, new ParametersCompiled (p), true, lt.Location);
	  }

void case_698()
#line 4892 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_700()
#line 4901 "cs-parser.jay"
{
	  	valid_param_mod = 0;
		start_anonymous (true, (ParametersCompiled) yyVals[-2+yyTop], false, GetLocation (yyVals[-4+yyTop]));
	  }

void case_701()
#line 4906 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_703()
#line 4915 "cs-parser.jay"
{
	  	valid_param_mod = 0;
		start_anonymous (true, (ParametersCompiled) yyVals[-2+yyTop], true, GetLocation (yyVals[-5+yyTop]));
	  }

void case_704()
#line 4920 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-7+yyTop]), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_711()
#line 4943 "cs-parser.jay"
{
		yyVal = new RefValueExpr ((Expression) yyVals[-3+yyTop], (FullNamedExpression) yyVals[-1+yyTop], GetLocation (yyVals[-5+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_712()
#line 4948 "cs-parser.jay"
{
		yyVal = new RefTypeExpr ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_713()
#line 4953 "cs-parser.jay"
{
		yyVal = new MakeRefExpr ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));	  
	  }

void case_718()
#line 4980 "cs-parser.jay"
{
		yyVal = yyVals[-1+yyTop];

		/* Cannot use opt_formal_parameter_list because it can be shared instance for empty parameters*/
	  	lbag.AppendToMember (current_container, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));

		if (lang_version < LanguageVersion.V_6)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "primary constructor");
	  }

void case_723()
#line 5009 "cs-parser.jay"
{
		++lexer.parsing_block;
		current_type.PrimaryConstructorBaseArgumentsStart = GetLocation (yyVals[0+yyTop]);
	  }

void case_724()
#line 5014 "cs-parser.jay"
{
		lbag.AppendToMember (current_container, GetLocation (yyVals[0+yyTop]));
		current_type.PrimaryConstructorBaseArguments = (Arguments) yyVals[-1+yyTop];
		--lexer.parsing_block;

		yyVal = yyVals[-5+yyTop];
	  }

void case_726()
#line 5034 "cs-parser.jay"
{
		lexer.ConstraintsParsing = true;

		Class c = new Class (current_container, (MemberName) yyVals[0+yyTop], (Modifiers) yyVals[-4+yyTop], (Attributes) yyVals[-5+yyTop]);
		if (((c.ModFlags & Modifiers.STATIC) != 0) && lang_version == LanguageVersion.ISO_1) {
			FeatureIsNotAvailable (c.Location, "static classes");
		}
			
		push_current_container (c, yyVals[-3+yyTop]);
		lbag.AddMember (current_container, GetModifierLocations (), GetLocation (yyVals[-2+yyTop]));
		valid_param_mod = ParameterModifierType.PrimaryConstructor;
	  }

void case_727()
#line 5048 "cs-parser.jay"
{
		valid_param_mod = 0;
		lexer.ConstraintsParsing = false;

		if (yyVals[-1+yyTop] != null)
			current_type.PrimaryConstructorParameters = (ParametersCompiled) yyVals[-1+yyTop];

		if (yyVals[0+yyTop] != null)
			current_container.SetConstraints ((List<Constraints>) yyVals[0+yyTop]);

		if (doc_support) {
			current_container.PartialContainer.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		lexer.parsing_modifiers = true;
	  }

void case_728()
#line 5066 "cs-parser.jay"
{
		--lexer.parsing_declaration;
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_729()
#line 5072 "cs-parser.jay"
{
		if (yyVals[0+yyTop] == null) {
			lbag.AppendToMember (current_container, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
		} else {
			lbag.AppendToMember (current_container, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
		}
		yyVal = pop_current_class ();
	  }

void case_732()
#line 5091 "cs-parser.jay"
{
	    mod_locations = null;
		yyVal = ModifierNone;
		lexer.parsing_modifiers = false;
	  }

void case_735()
#line 5105 "cs-parser.jay"
{ 
		var m1 = (Modifiers) yyVals[-1+yyTop];
		var m2 = (Modifiers) yyVals[0+yyTop];

		if ((m1 & m2) != 0) {
			report.Error (1004, lexer.Location - ModifiersExtensions.Name (m2).Length,
				"Duplicate `{0}' modifier", ModifiersExtensions.Name (m2));
		} else if ((m2 & Modifiers.AccessibilityMask) != 0 && (m1 & Modifiers.AccessibilityMask) != 0 &&
			((m2 | m1 & Modifiers.AccessibilityMask) != (Modifiers.PROTECTED | Modifiers.INTERNAL))) {
			report.Error (107, lexer.Location - ModifiersExtensions.Name (m2).Length,
				"More than one protection modifier specified");
		}
		
		yyVal = m1 | m2;
	  }

void case_736()
#line 5124 "cs-parser.jay"
{
		yyVal = Modifiers.NEW;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
		
		if (current_container.Kind == MemberKind.Namespace)
			report.Error (1530, GetLocation (yyVals[0+yyTop]), "Keyword `new' is not allowed on namespace elements");
	  }

void case_737()
#line 5132 "cs-parser.jay"
{
		yyVal = Modifiers.PUBLIC;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_738()
#line 5137 "cs-parser.jay"
{
		yyVal = Modifiers.PROTECTED;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_739()
#line 5142 "cs-parser.jay"
{
		yyVal = Modifiers.INTERNAL;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_740()
#line 5147 "cs-parser.jay"
{
		yyVal = Modifiers.PRIVATE;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_741()
#line 5152 "cs-parser.jay"
{
		yyVal = Modifiers.ABSTRACT;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_742()
#line 5157 "cs-parser.jay"
{
		yyVal = Modifiers.SEALED;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_743()
#line 5162 "cs-parser.jay"
{
		yyVal = Modifiers.STATIC;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_744()
#line 5167 "cs-parser.jay"
{
		yyVal = Modifiers.READONLY;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_745()
#line 5172 "cs-parser.jay"
{
		yyVal = Modifiers.VIRTUAL;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_746()
#line 5177 "cs-parser.jay"
{
		yyVal = Modifiers.OVERRIDE;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_747()
#line 5182 "cs-parser.jay"
{
		yyVal = Modifiers.EXTERN;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_748()
#line 5187 "cs-parser.jay"
{
		yyVal = Modifiers.VOLATILE;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_749()
#line 5192 "cs-parser.jay"
{
		yyVal = Modifiers.UNSAFE;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
		if (!settings.Unsafe)
			Error_UnsafeCodeNotAllowed (GetLocation (yyVals[0+yyTop]));
	  }

void case_750()
#line 5199 "cs-parser.jay"
{
		yyVal = Modifiers.ASYNC;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_753()
#line 5212 "cs-parser.jay"
{
		current_type.SetBaseTypes ((List<FullNamedExpression>) yyVals[0+yyTop]);
		lbag.AppendToMember (current_type, GetLocation (yyVals[-1+yyTop]));
	 }

void case_754()
#line 5217 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		current_type.SetBaseTypes ((List<FullNamedExpression>) yyVals[-1+yyTop]);
	  }

void case_757()
#line 5234 "cs-parser.jay"
{
		var constraints = new List<Constraints> (1);
		constraints.Add ((Constraints) yyVals[0+yyTop]);
		yyVal = constraints;
	  }

void case_758()
#line 5240 "cs-parser.jay"
{
		var constraints = (List<Constraints>) yyVals[-1+yyTop];
		Constraints new_constraint = (Constraints)yyVals[0+yyTop];

		foreach (Constraints c in constraints) {
			if (new_constraint.TypeParameter.Value == c.TypeParameter.Value) {
				report.Error (409, new_constraint.Location,
					"A constraint clause has already been specified for type parameter `{0}'",
					new_constraint.TypeParameter.Value);
			}
		}

		constraints.Add (new_constraint);
		yyVal = constraints;
	  }

void case_759()
#line 5259 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-2+yyTop];
		yyVal = new Constraints (new SimpleMemberName (lt.Value, lt.Location), (List<FullNamedExpression>) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_760()
#line 5265 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
	  
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new Constraints (new SimpleMemberName (lt.Value, lt.Location), null, GetLocation (yyVals[-2+yyTop]));
	  }

void case_761()
#line 5275 "cs-parser.jay"
{
		var constraints = new List<FullNamedExpression> (1);
		constraints.Add ((FullNamedExpression) yyVals[0+yyTop]);
		yyVal = constraints;
	  }

void case_762()
#line 5281 "cs-parser.jay"
{
		var constraints = (List<FullNamedExpression>) yyVals[-2+yyTop];
		var prev = constraints [constraints.Count - 1] as SpecialContraintExpr;
		if (prev != null && (prev.Constraint & SpecialConstraint.Constructor) != 0) {			
			report.Error (401, GetLocation (yyVals[-1+yyTop]), "The `new()' constraint must be the last constraint specified");
		}
		
		prev = yyVals[0+yyTop] as SpecialContraintExpr;
		if (prev != null) {
			if ((prev.Constraint & (SpecialConstraint.Class | SpecialConstraint.Struct)) != 0) {
				report.Error (449, prev.Location, "The `class' or `struct' constraint must be the first constraint specified");			
			} else {
			 	prev = constraints [0] as SpecialContraintExpr;
			 	if (prev != null && (prev.Constraint & SpecialConstraint.Struct) != 0) {			
					report.Error (451, GetLocation (yyVals[0+yyTop]), "The `new()' constraint cannot be used with the `struct' constraint");
				}
			}
		}

		constraints.Add ((FullNamedExpression) yyVals[0+yyTop]);
		lbag.AddLocation (constraints, GetLocation (yyVals[-1+yyTop]));
		yyVal = constraints;
	  }

void case_763()
#line 5308 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is ComposedCast)
			report.Error (706, GetLocation (yyVals[0+yyTop]), "Invalid constraint type `{0}'", ((ComposedCast)yyVals[0+yyTop]).GetSignatureForError ());
	  
	  	yyVal = yyVals[0+yyTop];
	  }

void case_764()
#line 5315 "cs-parser.jay"
{
		yyVal = new SpecialContraintExpr (SpecialConstraint.Constructor, GetLocation (yyVals[-2+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_768()
#line 5335 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.V_3)
			FeatureIsNotAvailable (lexer.Location, "generic type variance");
		
		yyVal = yyVals[0+yyTop];
	  }

void case_769()
#line 5345 "cs-parser.jay"
{
		yyVal = new VarianceDecl (Variance.Covariant, GetLocation (yyVals[0+yyTop]));
		savedLocation = GetLocation (yyVals[0+yyTop]);
	  }

void case_770()
#line 5350 "cs-parser.jay"
{
		yyVal = new VarianceDecl (Variance.Contravariant, GetLocation (yyVals[0+yyTop]));
		savedLocation = GetLocation (yyVals[0+yyTop]);
	  }

void case_771()
#line 5371 "cs-parser.jay"
{
		++lexer.parsing_block;
		start_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_773()
#line 5383 "cs-parser.jay"
{
	 	--lexer.parsing_block;
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_774()
#line 5388 "cs-parser.jay"
{
	 	--lexer.parsing_block;
		yyVal = end_block (lexer.Location);
	  }

void case_775()
#line 5397 "cs-parser.jay"
{
		++lexer.parsing_block;
		current_block.StartLocation = GetLocation (yyVals[0+yyTop]);
	  }

void case_776()
#line 5402 "cs-parser.jay"
{
		--lexer.parsing_block;
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_777()
#line 5406 "cs-parser.jay"
{
		report.Error (1525, GetLocation (yyVals[0+yyTop]), "Unexpected symbol '}', expected '{'");
		lexer.putback ('}');
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_778()
#line 5415 "cs-parser.jay"
{
		++lexer.parsing_block;
		current_block.StartLocation = GetLocation (yyVals[0+yyTop]);
	  }

void case_779()
#line 5420 "cs-parser.jay"
{
		--lexer.parsing_block;
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_787()
#line 5448 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		var lt =(LocatedToken) yyVals[-1+yyTop];
		var sn = new SimpleName (lt.Value, lt.Location);
		current_block.AddStatement(new StatementErrorExpression (sn));
		yyVal = null;
	}

void case_788()
#line 5457 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_821()
#line 5521 "cs-parser.jay"
{
		  report.Error (1023, GetLocation (yyVals[0+yyTop]), "An embedded statement may not be a declaration or labeled statement");
		  yyVal = null;
	  }

void case_822()
#line 5526 "cs-parser.jay"
{
		  report.Error (1023, GetLocation (yyVals[0+yyTop]), "An embedded statement may not be a declaration or labeled statement");
		  yyVal = null;
	  }

void case_823()
#line 5531 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  }

void case_824()
#line 5539 "cs-parser.jay"
{
		/* Uses lexer.Location because semicolon location is not kept in quick mode*/
		yyVal = new EmptyStatement (lexer.Location);
	  }

void case_825()
#line 5547 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		LabeledStatement labeled = new LabeledStatement (lt.Value, current_block, lt.Location);
		lbag.AddLocation (labeled, GetLocation (yyVals[0+yyTop]));
		current_block.AddLabel (labeled);
		current_block.AddStatement (labeled);
	  }

void case_828()
#line 5560 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] is VarExpr)
			yyVals[-1+yyTop] = new SimpleName ("var", ((VarExpr) yyVals[-1+yyTop]).Location);
	  
		yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }

void case_829()
#line 5576 "cs-parser.jay"
{ 
		/* Ok, the above "primary_expression" is there to get rid of*/
		/* both reduce/reduce and shift/reduces in the grammar, it should*/
		/* really just be "type_name".  If you use type_name, a reduce/reduce*/
		/* creeps up.  If you use namespace_or_type_name (which is all we need*/
		/* really) two shift/reduces appear.*/
		/* */

		/* So the super-trick is that primary_expression*/
		/* can only be either a SimpleName or a MemberAccess. */
		/* The MemberAccess case arises when you have a fully qualified type-name like :*/
		/* Foo.Bar.Blah i;*/
		/* SimpleName is when you have*/
		/* Blah i;*/
		
		Expression expr = (Expression) yyVals[-1+yyTop];
		if (yyVals[0+yyTop] == null) {
			SimpleName sn = expr as SimpleName;
			if (sn != null && sn.Name == "var")
				yyVal = new VarExpr (sn.Location);
			else
				yyVal = yyVals[-1+yyTop];
		} else if (expr is ATypeNameExpression) {
			yyVal = new ComposedCast ((ATypeNameExpression)expr, (ComposedTypeSpecifier) yyVals[0+yyTop]);
		} else {
			Error_ExpectingTypeName (expr);
			yyVal = null;
		}
	  }

void case_830()
#line 5606 "cs-parser.jay"
{
		ATypeNameExpression expr = yyVals[-1+yyTop] as ATypeNameExpression;

		if (expr != null) {
			yyVal = new ComposedCast (expr, (ComposedTypeSpecifier) yyVals[0+yyTop]);
		} else {
			Error_ExpectingTypeName ((Expression)yyVals[-1+yyTop]);
			yyVal = expr;
		}
	  }

void case_834()
#line 5623 "cs-parser.jay"
{
	  	((ComposedTypeSpecifier) yyVals[-1+yyTop]).Next = (ComposedTypeSpecifier) yyVals[0+yyTop];
	  	yyVal = yyVals[-1+yyTop];
	  }

void case_838()
#line 5646 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new BlockVariable ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_839()
#line 5653 "cs-parser.jay"
{
		yyVal = current_variable;
		current_variable = null;
		if (yyVals[-2+yyTop] != null)
			lbag.AddLocation (yyVal, PopLocation (), GetLocation (yyVals[0+yyTop]));
		else
			lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_840()
#line 5662 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.Constant, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new BlockConstant ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_841()
#line 5669 "cs-parser.jay"
{
		if (current_variable.Initializer != null) {
			lbag.AddLocation (current_variable, GetLocation (yyVals[-6+yyTop]), savedLocation, GetLocation (yyVals[0+yyTop]));
		} else {
			lbag.AddLocation (current_variable, GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[0+yyTop]));
		}
		yyVal = current_variable;;
		current_variable = null;
	  }

void case_843()
#line 5682 "cs-parser.jay"
{
		/* Redundant, but wont regress*/
		report.Error (1525, lexer.Location, "Unexpected symbol }");
		lexer.putback ('}');
		yyVal = yyVals[0+yyTop];
	  }

void case_845()
#line 5693 "cs-parser.jay"
{
		current_variable.Initializer = (Expression) yyVals[0+yyTop];
		PushLocation (GetLocation (yyVals[-1+yyTop]));
		yyVal = current_variable;
	  }

void case_846()
#line 5699 "cs-parser.jay"
{
	  	if (yyToken == Token.OPEN_BRACKET_EXPR) {
			report.Error (650, lexer.Location,
				"Syntax error, bad array declarator. To declare a managed array the rank specifier precedes the variable's identifier. To declare a fixed size buffer field, use the fixed keyword before the field type");
		} else {
			Error_SyntaxError (yyToken);
		}
	  }

void case_850()
#line 5717 "cs-parser.jay"
{
		foreach (var d in current_variable.Declarators) {
			if (d.Initializer == null)
				Error_MissingInitializer (d.Variable.Location);
		}
	  }

void case_853()
#line 5732 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];	  
		var li = new LocalVariable (current_variable.Variable, lt.Value, lt.Location);
		var d = new BlockVariableDeclarator (li, null);
		current_variable.AddDeclarator (d);
		current_block.AddLocalName (li);
	  	lbag.AddLocation (d, GetLocation (yyVals[-1+yyTop]));
	  }

void case_854()
#line 5741 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-2+yyTop];	  
		var li = new LocalVariable (current_variable.Variable, lt.Value, lt.Location);
		var d = new BlockVariableDeclarator (li, (Expression) yyVals[0+yyTop]);
		current_variable.AddDeclarator (d);
		current_block.AddLocalName (li);
	  	lbag.AddLocation (d, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_856()
#line 5757 "cs-parser.jay"
{
		savedLocation = GetLocation (yyVals[-1+yyTop]);
		current_variable.Initializer = (Expression) yyVals[0+yyTop];
	  }

void case_861()
#line 5775 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-2+yyTop];	  
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.Constant, lt.Location);
		var d = new BlockVariableDeclarator (li, (Expression) yyVals[0+yyTop]);
		current_variable.AddDeclarator (d);
		current_block.AddLocalName (li);
	  	lbag.AddLocation (d, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_863()
#line 5788 "cs-parser.jay"
{
		yyVal = new StackAlloc ((Expression) yyVals[-3+yyTop], (Expression) yyVals[-1+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_864()
#line 5793 "cs-parser.jay"
{
		report.Error (1575, GetLocation (yyVals[-1+yyTop]), "A stackalloc expression requires [] after type");
		yyVal = new StackAlloc ((Expression) yyVals[0+yyTop], null, GetLocation (yyVals[-1+yyTop]));		
	  }

void case_865()
#line 5801 "cs-parser.jay"
{
		yyVal = yyVals[-1+yyTop];
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_867()
#line 5807 "cs-parser.jay"
{
		yyVal = yyVals[-1+yyTop];
		report.Error (1002, GetLocation (yyVals[0+yyTop]), "; expected");
		lexer.putback ('}');
	  }

void case_870()
#line 5825 "cs-parser.jay"
{
		ExpressionStatement s = yyVals[0+yyTop] as ExpressionStatement;
		if (s == null) {
			var expr = yyVals[0+yyTop] as Expression;
			yyVal = new StatementErrorExpression (expr);
		} else {
			yyVal = new StatementExpression (s);
		}
	  }

void case_871()
#line 5838 "cs-parser.jay"
{
		Expression expr = (Expression) yyVals[0+yyTop];
		yyVal = new StatementExpression (new OptionalAssign (expr, lexer.Location));
	  }

void case_872()
#line 5843 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  }

void case_875()
#line 5857 "cs-parser.jay"
{ 
		if (yyVals[0+yyTop] is EmptyStatement)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
		
		yyVal = new If ((BooleanExpression) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_876()
#line 5866 "cs-parser.jay"
{
		yyVal = new If ((BooleanExpression) yyVals[-4+yyTop], (Statement) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-6+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
		
		if (yyVals[-2+yyTop] is EmptyStatement)
			Warning_EmptyStatement (GetLocation (yyVals[-2+yyTop]));
		if (yyVals[0+yyTop] is EmptyStatement)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  }

void case_877()
#line 5876 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		
		yyVal = new If ((BooleanExpression) yyVals[-1+yyTop], null, GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_879()
#line 5890 "cs-parser.jay"
{
		yyVal = new Switch ((Expression) yyVals[-5+yyTop], (ExplicitBlock) current_block.Explicit, GetLocation (yyVals[-7+yyTop]));	
		end_block (GetLocation (yyVals[0+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_880()
#line 5896 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
	  
		yyVal = new Switch ((Expression) yyVals[-1+yyTop], null, GetLocation (yyVals[-3+yyTop]));	
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_887()
#line 5927 "cs-parser.jay"
{
	  	var label = (SwitchLabel) yyVals[0+yyTop];
	  	label.SectionStart = true;
		current_block.AddStatement (label);
	  }

void case_889()
#line 5940 "cs-parser.jay"
{
	 	yyVal = new SwitchLabel ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	 	lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	 }

void case_890()
#line 5945 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new SwitchLabel ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }

void case_896()
#line 5964 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		yyVal = new While ((BooleanExpression) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_897()
#line 5972 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		
		yyVal = new While ((BooleanExpression) yyVals[-1+yyTop], null, GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_898()
#line 5982 "cs-parser.jay"
{
		yyVal = new Do ((Statement) yyVals[-5+yyTop], (BooleanExpression) yyVals[-2+yyTop], GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_899()
#line 5987 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new Do ((Statement) yyVals[-1+yyTop], null, GetLocation (yyVals[-2+yyTop]), Location.Null);
	  }

void case_900()
#line 5992 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
	  
		yyVal = new Do ((Statement) yyVals[-4+yyTop], (BooleanExpression) yyVals[-1+yyTop], GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_901()
#line 6002 "cs-parser.jay"
{
		start_block (GetLocation (yyVals[0+yyTop]));
		current_block.IsCompilerGenerated = true;
		For f = new For (GetLocation (yyVals[-1+yyTop]));
		current_block.AddStatement (f);
		lbag.AddStatement (f, current_block.StartLocation);
		yyVal = f;
	  }

void case_903()
#line 6019 "cs-parser.jay"
{
		For f =  (For) yyVals[-2+yyTop];
		f.Initializer = (Statement) yyVals[-1+yyTop];
		lbag.AddLocation (f, GetLocation (yyVals[0+yyTop]));
		yyVal = f;
	  }

void case_905()
#line 6029 "cs-parser.jay"
{
		report.Error (1525, GetLocation (yyVals[0+yyTop]), "Unexpected symbol ')', expected ';'");
		For f =  (For) yyVals[-2+yyTop];
		f.Initializer = (Statement) yyVals[-1+yyTop];
		lbag.AddLocation (f, GetLocation (yyVals[0+yyTop]));
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	}

void case_906()
#line 6040 "cs-parser.jay"
{
		For f =  (For) yyVals[-2+yyTop];
		f.Condition = (BooleanExpression) yyVals[-1+yyTop];
		lbag.AddLocation (f, GetLocation (yyVals[0+yyTop]));
		yyVal = f;
	  }

void case_908()
#line 6051 "cs-parser.jay"
{
		report.Error (1525, GetLocation (yyVals[0+yyTop]), "Unexpected symbol ')', expected ';'");
		For f =  (For) yyVals[-2+yyTop];
		f.Condition = (BooleanExpression) yyVals[-1+yyTop];
		lbag.AddLocation (f, GetLocation (yyVals[0+yyTop]));
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	}

void case_909()
#line 6063 "cs-parser.jay"
{
		For f =  (For) yyVals[-3+yyTop];
		f.Iterator = (Statement) yyVals[-2+yyTop];
		
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		f.Statement = (Statement) yyVals[0+yyTop];
		lbag.AddLocation (f, GetLocation (yyVals[-1+yyTop]));

		yyVal = end_block (GetLocation (yyVals[-1+yyTop]));
	  }

void case_910()
#line 6076 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = end_block (current_block.StartLocation);
	  }

void case_913()
#line 6089 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new BlockVariable ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_914()
#line 6096 "cs-parser.jay"
{
		yyVal = current_variable;
		if (yyVals[-1+yyTop] != null)
			lbag.AddLocation (current_variable, PopLocation ());

		current_variable = null;
	  }

void case_922()
#line 6123 "cs-parser.jay"
{
	  	var sl = yyVals[-2+yyTop] as StatementList;
	  	if (sl == null) {
	  		sl = new StatementList ((Statement) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop]);
			lbag.AddStatement (sl, GetLocation (yyVals[-1+yyTop]));
	  	} else {
	  		sl.Add ((Statement) yyVals[0+yyTop]);
	  		lbag.AddLocation (sl, GetLocation (yyVals[-1+yyTop]));
	  		
	  	}
	  		
		yyVal = sl;
	  }

void case_923()
#line 6140 "cs-parser.jay"
{
		report.Error (230, GetLocation (yyVals[-3+yyTop]), "Type and identifier are both required in a foreach statement");

		start_block (GetLocation (yyVals[-2+yyTop]));
		current_block.IsCompilerGenerated = true;
		
		Foreach f = new Foreach ((Expression) yyVals[-1+yyTop], null, null, null, null, GetLocation (yyVals[-3+yyTop]));
		current_block.AddStatement (f);
		
		lbag.AddStatement (f, GetLocation (yyVals[-2+yyTop]));
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_924()
#line 6153 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
	
		start_block (GetLocation (yyVals[-3+yyTop]));
		current_block.IsCompilerGenerated = true;
		
		var lt = (LocatedToken) yyVals[-1+yyTop];
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.ForeachVariable | LocalVariable.Flags.Used, lt.Location);
		current_block.AddLocalName (li);
		
		Foreach f = new Foreach ((Expression) yyVals[-2+yyTop], li, null, null, null, GetLocation (yyVals[-4+yyTop]));
		current_block.AddStatement (f);
		
		lbag.AddStatement (f, GetLocation (yyVals[-3+yyTop]));
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_925()
#line 6170 "cs-parser.jay"
{
		start_block (GetLocation (yyVals[-5+yyTop]));
		current_block.IsCompilerGenerated = true;
		
		var lt = (LocatedToken) yyVals[-3+yyTop];
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.ForeachVariable | LocalVariable.Flags.Used, lt.Location);
		current_block.AddLocalName (li);
		yyVal = li;
	  }

void case_926()
#line 6180 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
		
		Foreach f = new Foreach ((Expression) yyVals[-6+yyTop], (LocalVariable) yyVals[-1+yyTop], (Expression) yyVals[-3+yyTop], (Statement) yyVals[0+yyTop], current_block, GetLocation (yyVals[-8+yyTop]));
		lbag.AddStatement (f, GetLocation (yyVals[-7+yyTop]), GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
		end_block (GetLocation (yyVals[-2+yyTop]));
		
		yyVal = f;
	  }

void case_927()
#line 6191 "cs-parser.jay"
{
		start_block (GetLocation (yyVals[-3+yyTop]));
		current_block.IsCompilerGenerated = true;
		var lt = yyVals[-1+yyTop] as LocatedToken;
		var li = lt != null ? new LocalVariable (current_block, lt.Value, LocalVariable.Flags.ForeachVariable | LocalVariable.Flags.Used, lt.Location) : null;
		
		Foreach f = new Foreach ((Expression) yyVals[-2+yyTop], li, null, null, null, GetLocation (yyVals[-4+yyTop]));
		current_block.AddStatement (f);
		
		lbag.AddStatement (f, GetLocation (yyVals[-3+yyTop]));
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_928()
#line 6204 "cs-parser.jay"
{
		Foreach f = new Foreach ((Expression) yyVals[-1+yyTop], null, null, null, null, GetLocation (yyVals[-3+yyTop]));
		current_block.AddStatement (f);
		
		lbag.AddStatement (f, GetLocation (yyVals[-2+yyTop]));
		yyVal = f;
	  }

void case_935()
#line 6224 "cs-parser.jay"
{
		yyVal = new Break (GetLocation (yyVals[-1+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_936()
#line 6232 "cs-parser.jay"
{
		yyVal = new Continue (GetLocation (yyVals[-1+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_937()
#line 6237 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new Continue (GetLocation (yyVals[-1+yyTop]));
	  }

void case_938()
#line 6245 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new Goto (lt.Value, GetLocation (yyVals[-2+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_939()
#line 6251 "cs-parser.jay"
{
		yyVal = new GotoCase ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_940()
#line 6256 "cs-parser.jay"
{
		yyVal = new GotoDefault (GetLocation (yyVals[-2+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_941()
#line 6264 "cs-parser.jay"
{
		yyVal = new Return ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_942()
#line 6269 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new Return ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }

void case_943()
#line 6274 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new Return (null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_944()
#line 6282 "cs-parser.jay"
{
		yyVal = new Throw ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_945()
#line 6287 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new Throw ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }

void case_946()
#line 6292 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new Throw (null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_947()
#line 6300 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-3+yyTop];
		string s = lt.Value;
		if (s != "yield"){
			report.Error (1003, lt.Location, "; expected");
		} else if (yyVals[-1+yyTop] == null) {
			report.Error (1627, GetLocation (yyVals[0+yyTop]), "Expression expected after yield return");
		} else if (lang_version == LanguageVersion.ISO_1){
			FeatureIsNotAvailable (lt.Location, "iterators");
		}
		
		current_block.Explicit.RegisterIteratorYield ();
		yyVal = new Yield ((Expression) yyVals[-1+yyTop], lt.Location);
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_948()
#line 6316 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		var lt = (LocatedToken) yyVals[-3+yyTop];
		string s = lt.Value;
		if (s != "yield"){
			report.Error (1003, lt.Location, "; expected");
		} else if (yyVals[-1+yyTop] == null) {
			report.Error (1627, GetLocation (yyVals[0+yyTop]), "Expression expected after yield return");
		} else if (lang_version == LanguageVersion.ISO_1){
			FeatureIsNotAvailable (lt.Location, "iterators");
		}
		
		current_block.Explicit.RegisterIteratorYield ();
		yyVal = new Yield ((Expression) yyVals[-1+yyTop], lt.Location);
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_949()
#line 6334 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-2+yyTop];
		string s = lt.Value;
		if (s != "yield"){
			report.Error (1003, lt.Location, "; expected");
		} else if (lang_version == LanguageVersion.ISO_1){
			FeatureIsNotAvailable (lt.Location, "iterators");
		}
		
		current_block.ParametersBlock.TopBlock.IsIterator = true;
		yyVal = new YieldBreak (lt.Location);
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_953()
#line 6360 "cs-parser.jay"
{
		yyVal = new TryFinally ((Statement) yyVals[-2+yyTop], (ExplicitBlock) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_954()
#line 6365 "cs-parser.jay"
{
		yyVal = new TryFinally (new TryCatch ((Block) yyVals[-3+yyTop], (List<Catch>) yyVals[-2+yyTop], GetLocation (yyVals[-4+yyTop]), true), (ExplicitBlock) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_955()
#line 6370 "cs-parser.jay"
{
		Error_SyntaxError (1524, yyToken);
		yyVal = new TryCatch ((Block) yyVals[-1+yyTop], null, GetLocation (yyVals[-2+yyTop]), false);
	  }

void case_956()
#line 6378 "cs-parser.jay"
{
		var l = new List<Catch> (2);

		l.Add ((Catch) yyVals[0+yyTop]);
		yyVal = l;
	  }

void case_957()
#line 6385 "cs-parser.jay"
{
		var l = (List<Catch>) yyVals[-1+yyTop];
		
		Catch c = (Catch) yyVals[0+yyTop];
		var prev_catch = l [l.Count - 1];
		if (prev_catch.IsGeneral && prev_catch.Filter == null) {
			report.Error (1017, c.loc, "Try statement already has an empty catch block");
		}
		
		l.Add (c);
		yyVal = l;
	  }

void case_960()
#line 6406 "cs-parser.jay"
{
	  	var c = new Catch ((ExplicitBlock) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));
	  	c.Filter = (CatchFilterExpression) yyVals[-1+yyTop];
	  	yyVal = c;
	  }

void case_961()
#line 6412 "cs-parser.jay"
{
		start_block (GetLocation (yyVals[-3+yyTop]));
		var c = new Catch ((ExplicitBlock) current_block, GetLocation (yyVals[-4+yyTop]));
		c.TypeExpression = (FullNamedExpression) yyVals[-2+yyTop];

		if (yyVals[-1+yyTop] != null) {
			var lt = (LocatedToken) yyVals[-1+yyTop];
			c.Variable = new LocalVariable (current_block, lt.Value, lt.Location);
			current_block.AddLocalName (c.Variable);
		}

		lbag.AddLocation (c, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
		yyVal = c;
	  }

void case_962()
#line 6427 "cs-parser.jay"
{
	  	((Catch) yyVals[-2+yyTop]).Filter = (CatchFilterExpression) yyVals[-1+yyTop];
		yyVal = yyVals[-2+yyTop];
	  }

void case_963()
#line 6432 "cs-parser.jay"
{
	  	if (yyToken == Token.CLOSE_PARENS) {
			report.Error (1015, lexer.Location,
				"A type that derives from `System.Exception', `object', or `string' expected");
		} else {
			Error_SyntaxError (yyToken);
		}
		
		yyVal = new Catch (null, GetLocation (yyVals[-2+yyTop]));
	  }

void case_964()
#line 6443 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		/* Required otherwise missing block could not be detected because*/
		/* start_block is run early*/
		var c = new Catch (null, GetLocation (yyVals[-5+yyTop]));
		c.TypeExpression = (FullNamedExpression) yyVals[-3+yyTop];
		
		if (yyVals[-2+yyTop] != null) {
			var lt = (LocatedToken) yyVals[-2+yyTop];
			c.Variable = new LocalVariable (current_block, lt.Value, lt.Location);
		}

		if (yyVals[-2+yyTop] != null) {
			var lt = (LocatedToken) yyVals[-2+yyTop];
			c.Variable = new LocalVariable (current_block, lt.Value, lt.Location);
		}

		lbag.AddLocation (c, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-1+yyTop]));

		yyVal = c;
	  }

void case_966()
#line 6470 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.V_5)
			FeatureIsNotAvailable (GetLocation (yyVals[-3+yyTop]), "exception filter");

	  	yyVal = new CatchFilterExpression ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_969()
#line 6495 "cs-parser.jay"
{
		if (!settings.Unsafe)
			Error_UnsafeCodeNotAllowed (GetLocation (yyVals[0+yyTop]));
	  }

void case_971()
#line 6505 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		yyVal = new Lock ((Expression) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_972()
#line 6513 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);

		yyVal = new Lock ((Expression) yyVals[-1+yyTop], null, GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_973()
#line 6523 "cs-parser.jay"
{
	    start_block (GetLocation (yyVals[-2+yyTop]));
	    
		current_block.IsCompilerGenerated = true;
		var lt = (LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.FixedVariable | LocalVariable.Flags.Used, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new Fixed.VariableDeclaration ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_974()
#line 6533 "cs-parser.jay"
{
		yyVal = current_variable;
		current_variable = null;
	  }

void case_975()
#line 6538 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		Fixed f = new Fixed ((Fixed.VariableDeclaration) yyVals[-1+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-9+yyTop]));
		current_block.AddStatement (f);
		lbag.AddStatement (f, GetLocation (yyVals[-8+yyTop]), GetLocation (yyVals[-2+yyTop]));
		yyVal = end_block (GetLocation (yyVals[-2+yyTop]));
	  }

void case_976()
#line 6551 "cs-parser.jay"
{
	    start_block (GetLocation (yyVals[-2+yyTop]));
	    
		current_block.IsCompilerGenerated = true;
		var lt = (LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.UsingVariable | LocalVariable.Flags.Used, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new Using.VariableDeclaration ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_977()
#line 6561 "cs-parser.jay"
{
		yyVal = current_variable;	  
		current_variable = null;
	  }

void case_978()
#line 6566 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		Using u = new Using ((Using.VariableDeclaration) yyVals[-1+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-8+yyTop]));
		lbag.AddStatement (u, GetLocation (yyVals[-7+yyTop]), GetLocation (yyVals[-2+yyTop]));
		current_block.AddStatement (u);
		yyVal = end_block (GetLocation (yyVals[-2+yyTop]));
	  }

void case_979()
#line 6576 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		yyVal = new Using ((Expression) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_980()
#line 6584 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		
		yyVal = new Using ((Expression) yyVals[-1+yyTop], null, GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_982()
#line 6595 "cs-parser.jay"
{
		/* It has to be here for the parent to safely restore artificial block*/
	  	Error_SyntaxError (yyToken);
	  }

void case_984()
#line 6607 "cs-parser.jay"
{
		current_variable.Initializer = (Expression) yyVals[0+yyTop];
		lbag.AddLocation (current_variable, GetLocation (yyVals[-1+yyTop]));
		yyVal = current_variable;
	  }

void case_985()
#line 6619 "cs-parser.jay"
{
		lexer.query_parsing = false;
			
		Linq.AQueryClause from = yyVals[-1+yyTop] as Linq.AQueryClause;
			
		from.Tail.Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = from;
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_986()
#line 6631 "cs-parser.jay"
{
		Linq.AQueryClause from = yyVals[-1+yyTop] as Linq.AQueryClause;
			
		from.Tail.Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = from;
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_987()
#line 6642 "cs-parser.jay"
{
	        lexer.query_parsing = false;
		yyVal = yyVals[-1+yyTop];

		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_988()
#line 6649 "cs-parser.jay"
{
	        yyVal = yyVals[-1+yyTop];
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_989()
#line 6658 "cs-parser.jay"
{
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  
		var lt = (LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
		var clause = new Linq.QueryStartClause ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], rv, GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (clause, GetLocation (yyVals[-1+yyTop]));
		yyVal = new Linq.QueryExpression (clause);
	  }

void case_990()
#line 6668 "cs-parser.jay"
{
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  
		var lt = (LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
		var clause = new Linq.QueryStartClause ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], rv, GetLocation (yyVals[-4+yyTop])) {
				IdentifierType = (FullNamedExpression)yyVals[-3+yyTop]
		};
		lbag.AddLocation (clause, GetLocation (yyVals[-1+yyTop]));
		yyVal = new Linq.QueryExpression (clause);
	  }

void case_991()
#line 6683 "cs-parser.jay"
{
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  
		var lt = (LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
		var clause = new Linq.QueryStartClause ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], rv, GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (clause, GetLocation (yyVals[-1+yyTop]));
		yyVal = new Linq.QueryExpression (clause);
	  }

void case_992()
#line 6693 "cs-parser.jay"
{
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  
		var lt = (LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
		var clause = new Linq.QueryStartClause ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], rv, GetLocation (yyVals[-4+yyTop])) {
				IdentifierType = (FullNamedExpression)yyVals[-3+yyTop]
		};
		lbag.AddLocation (clause, GetLocation (yyVals[-1+yyTop]));
		yyVal = new Linq.QueryExpression (clause);
	  }

void case_994()
#line 6712 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-3+yyTop];
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);
		yyVal = new Linq.SelectMany ((Linq.QueryBlock)current_block, sn, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
		((Linq.QueryBlock)current_block).AddRangeVariable (sn);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_996()
#line 6727 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-3+yyTop];
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);

		yyVal = new Linq.SelectMany ((Linq.QueryBlock)current_block, sn, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-5+yyTop])) {
			IdentifierType = (FullNamedExpression)yyVals[-4+yyTop]
		};
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
		
		((Linq.QueryBlock)current_block).AddRangeVariable (sn);
		
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_997()
#line 6746 "cs-parser.jay"
{
	  	Linq.AQueryClause head = (Linq.AQueryClause)yyVals[-1+yyTop];
		
		if (yyVals[0+yyTop] != null)
			head.Next = (Linq.AQueryClause)yyVals[0+yyTop];
				
		if (yyVals[-2+yyTop] != null) {
			Linq.AQueryClause clause = (Linq.AQueryClause)yyVals[-2+yyTop];
			clause.Tail.Next = head;
			head = clause;
		}
		
		yyVal = head;
	  }

void case_998()
#line 6761 "cs-parser.jay"
{
	  	Linq.AQueryClause head = (Linq.AQueryClause)yyVals[0+yyTop];

		if (yyVals[-1+yyTop] != null) {
			Linq.AQueryClause clause = (Linq.AQueryClause)yyVals[-1+yyTop];
			clause.Tail.Next = head;
			head = clause;
		}
		
		yyVal = head;
	  }

void case_1000()
#line 6774 "cs-parser.jay"
{
		report.Error (742, GetLocation (yyVals[0+yyTop]), "Unexpected symbol `{0}'. A query body must end with select or group clause", GetSymbolName (yyToken));
		yyVal = yyVals[-1+yyTop];
	  }

void case_1001()
#line 6779 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_1003()
#line 6791 "cs-parser.jay"
{
		yyVal = new Linq.Select ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));

		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_1004()
#line 6798 "cs-parser.jay"
{
	  	if (linq_clause_blocks == null)
	  		linq_clause_blocks = new Stack<Linq.QueryBlock> ();
	  		
	  	current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  	linq_clause_blocks.Push ((Linq.QueryBlock)current_block);
	  }

void case_1005()
#line 6806 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }

void case_1006()
#line 6813 "cs-parser.jay"
{
		var obj = (object[]) yyVals[0+yyTop];

		yyVal = new Linq.GroupBy ((Linq.QueryBlock)current_block, (Expression)yyVals[-2+yyTop], linq_clause_blocks.Pop (), (Expression)obj[0], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, (Location) obj[1]);
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_1008()
#line 6830 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new object[2] { null, Location.Null };
	  }

void case_1010()
#line 6839 "cs-parser.jay"
{
		((Linq.AQueryClause)yyVals[-1+yyTop]).Tail.Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = yyVals[-1+yyTop];
	  }

void case_1017()
#line 6859 "cs-parser.jay"
{
		var lt = (LocatedToken) yyVals[-3+yyTop];
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);
	  	yyVal = new Linq.Let ((Linq.QueryBlock) current_block, sn, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  	
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
		
		((Linq.QueryBlock)current_block).AddRangeVariable (sn);
	  }

void case_1019()
#line 6878 "cs-parser.jay"
{
		yyVal = new Linq.Where ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));

		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_1020()
#line 6888 "cs-parser.jay"
{
		if (linq_clause_blocks == null)
			linq_clause_blocks = new Stack<Linq.QueryBlock> ();
	  		
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);
	  }

void case_1021()
#line 6896 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;

		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);
	  }

void case_1022()
#line 6904 "cs-parser.jay"
{
		current_block.AddStatement (new ContextualReturn ((Expression) yyVals[-1+yyTop]));
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;

		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }

void case_1023()
#line 6912 "cs-parser.jay"
{
		current_block.AddStatement (new ContextualReturn ((Expression) yyVals[-1+yyTop]));
		current_block.SetEndLocation (lexer.Location);
	  
		var outer_selector = linq_clause_blocks.Pop ();
		var block = linq_clause_blocks.Pop ();

		var lt = (LocatedToken) yyVals[-10+yyTop];	
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);
		Linq.RangeVariable into;
		
		if (yyVals[0+yyTop] == null) {
			into = sn;
	  		yyVal = new Linq.Join (block, sn, (Expression)yyVals[-7+yyTop], outer_selector, (Linq.QueryBlock) current_block, GetLocation (yyVals[-11+yyTop]));
			lbag.AddLocation (yyVal, GetLocation (yyVals[-9+yyTop]), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-3+yyTop]));
		} else {
			/**/
			/* Set equals right side parent to beginning of linq query, it is not accessible therefore cannot cause name collisions*/
			/**/
			var parent = block.Parent;
			while (parent is Linq.QueryBlock) {
				parent = parent.Parent;
			}
			current_block.Parent = parent;
			
			((Linq.QueryBlock)current_block).AddRangeVariable (sn);
		
			lt = (LocatedToken) yyVals[0+yyTop];
			into = new Linq.RangeVariable (lt.Value, lt.Location);

			yyVal = new Linq.GroupJoin (block, sn, (Expression)yyVals[-7+yyTop], outer_selector, (Linq.QueryBlock) current_block, into, GetLocation (yyVals[-11+yyTop]));	
			lbag.AddLocation (yyVal, GetLocation (yyVals[-9+yyTop]), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-3+yyTop]), opt_intoStack.Pop ());
		}

		current_block = block.Parent;
		((Linq.QueryBlock)current_block).AddRangeVariable (into);
	  }

void case_1024()
#line 6950 "cs-parser.jay"
{
		if (linq_clause_blocks == null)
			linq_clause_blocks = new Stack<Linq.QueryBlock> ();
	  		
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);
	  }

void case_1025()
#line 6958 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;

		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);
	  }

void case_1026()
#line 6966 "cs-parser.jay"
{
		current_block.AddStatement (new ContextualReturn ((Expression) yyVals[-1+yyTop]));
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;

		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }

void case_1027()
#line 6974 "cs-parser.jay"
{
		current_block.AddStatement (new ContextualReturn ((Expression) yyVals[-1+yyTop]));
		current_block.SetEndLocation (lexer.Location);
	  
		var outer_selector = linq_clause_blocks.Pop ();
		var block = linq_clause_blocks.Pop ();
		
		var lt = (LocatedToken) yyVals[-10+yyTop];
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);
		Linq.RangeVariable into;
		
		if (yyVals[0+yyTop] == null) {
			into = sn;		
	  		yyVal = new Linq.Join (block, sn, (Expression)yyVals[-7+yyTop], outer_selector, (Linq.QueryBlock) current_block, GetLocation (yyVals[-12+yyTop])) {
	  			IdentifierType = (FullNamedExpression)yyVals[-11+yyTop]
	  		};
			lbag.AddLocation (yyVal, GetLocation (yyVals[-10+yyTop]), GetLocation (yyVals[-7+yyTop]), GetLocation (yyVals[-4+yyTop]));
		} else {
			/**/
			/* Set equals right side parent to beginning of linq query, it is not accessible therefore cannot cause name collisions*/
			/**/
			var parent = block.Parent;
			while (parent is Linq.QueryBlock) {
				parent = parent.Parent;
			}
			current_block.Parent = parent;
		
			((Linq.QueryBlock)current_block).AddRangeVariable (sn);
		
			lt = (LocatedToken) yyVals[0+yyTop];
			into = new Linq.RangeVariable (lt.Value, lt.Location); /* TODO:*/
			
			yyVal = new Linq.GroupJoin (block, sn, (Expression)yyVals[-7+yyTop], outer_selector, (Linq.QueryBlock) current_block, into, GetLocation (yyVals[-12+yyTop])) {
	  			IdentifierType = (FullNamedExpression)yyVals[-11+yyTop]
	  		};			
			lbag.AddLocation (yyVal, GetLocation (yyVals[-10+yyTop]), GetLocation (yyVals[-7+yyTop]), GetLocation (yyVals[-4+yyTop]), opt_intoStack.Pop ());
		}
		
		current_block = block.Parent;
		((Linq.QueryBlock)current_block).AddRangeVariable (into);		
	  }

void case_1029()
#line 7020 "cs-parser.jay"
{
		opt_intoStack.Push (GetLocation (yyVals[-1+yyTop]));
		yyVal = yyVals[0+yyTop];
	  }

void case_1030()
#line 7028 "cs-parser.jay"
{
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		lbag.AddLocation (current_block, GetLocation (yyVals[0+yyTop]));
	  }

void case_1031()
#line 7033 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  
		yyVal = yyVals[0+yyTop];
	  }

void case_1033()
#line 7044 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }

void case_1034()
#line 7051 "cs-parser.jay"
{
		((Linq.AQueryClause)yyVals[-3+yyTop]).Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = yyVals[-3+yyTop];
	  }

void case_1036()
#line 7060 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  
		current_block = new Linq.QueryBlock ((Linq.QueryBlock) current_block, lexer.Location);	 
	 }

void case_1037()
#line 7067 "cs-parser.jay"
{
		((Linq.AQueryClause)yyVals[-3+yyTop]).Tail.Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = yyVals[-3+yyTop];
	 }

void case_1039()
#line 7079 "cs-parser.jay"
{
		yyVal = new Linq.OrderByAscending ((Linq.QueryBlock) current_block, (Expression)yyVals[-1+yyTop]);	
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_1040()
#line 7084 "cs-parser.jay"
{
		yyVal = new Linq.OrderByDescending ((Linq.QueryBlock) current_block, (Expression)yyVals[-1+yyTop]);	
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_1042()
#line 7096 "cs-parser.jay"
{
		yyVal = new Linq.ThenByAscending ((Linq.QueryBlock) current_block, (Expression)yyVals[-1+yyTop]);	
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_1043()
#line 7101 "cs-parser.jay"
{
		yyVal = new Linq.ThenByDescending ((Linq.QueryBlock) current_block, (Expression)yyVals[-1+yyTop]);	
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_1045()
#line 7111 "cs-parser.jay"
{
		/* query continuation block is not linked with query block but with block*/
		/* before. This means each query can use same range variable names for*/
		/* different identifiers.*/

		current_block.SetEndLocation (GetLocation (yyVals[-1+yyTop]));
		current_block = current_block.Parent;
	
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		
		if (linq_clause_blocks == null)
			linq_clause_blocks = new Stack<Linq.QueryBlock> ();
	  		
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);		
	  }

void case_1046()
#line 7127 "cs-parser.jay"
{
		var current_block = linq_clause_blocks.Pop ();	  
		var lt = (LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
  		yyVal = new Linq.QueryStartClause ((Linq.QueryBlock)current_block, null, rv, GetLocation (yyVals[-3+yyTop])) {
  			next = (Linq.AQueryClause)yyVals[0+yyTop]
  		};
	  }

void case_1049()
#line 7154 "cs-parser.jay"
{ 
		current_container = current_type = new Class (current_container, new MemberName ("<InteractiveExpressionClass>"), Modifiers.PUBLIC, null);

		/* (ref object retval)*/
		Parameter [] mpar = new Parameter [1];
		mpar [0] = new Parameter (new TypeExpression (compiler.BuiltinTypes.Object, Location.Null), "$retval", Parameter.Modifier.REF, null, Location.Null);

		ParametersCompiled pars = new ParametersCompiled (mpar);
		var mods = Modifiers.PUBLIC | Modifiers.STATIC;
		if (settings.Unsafe)
			mods |= Modifiers.UNSAFE;

		current_local_parameters = pars;
		var method = new InteractiveMethod (
			current_type,
			new TypeExpression (compiler.BuiltinTypes.Void, Location.Null),
			mods,
			pars);
			
		current_type.AddMember (method);			
		oob_stack.Push (method);

		interactive_async = false;

		++lexer.parsing_block;
		start_block (lexer.Location);
	  }

void case_1050()
#line 7182 "cs-parser.jay"
{
		--lexer.parsing_block;
		var method = (InteractiveMethod) oob_stack.Pop ();
		method.Block = (ToplevelBlock) end_block(lexer.Location);

		if (interactive_async == true) {
			method.ChangeToAsync ();
		}

		InteractiveResult = (Class) pop_current_class ();
		current_local_parameters = null;
	  }

void case_1060()
#line 7228 "cs-parser.jay"
{
		module.DocumentationBuilder.ParsedBuiltinType = (TypeExpression)yyVals[-1+yyTop];
		module.DocumentationBuilder.ParsedParameters = (List<DocumentationParameter>)yyVals[0+yyTop];
		yyVal = null;
	  }

void case_1061()
#line 7234 "cs-parser.jay"
{
		module.DocumentationBuilder.ParsedBuiltinType = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[-1+yyTop]));
		module.DocumentationBuilder.ParsedParameters = (List<DocumentationParameter>)yyVals[0+yyTop];
		yyVal = null;
	  }

void case_1062()
#line 7240 "cs-parser.jay"
{
		module.DocumentationBuilder.ParsedBuiltinType = (TypeExpression)yyVals[-3+yyTop];
		module.DocumentationBuilder.ParsedParameters = (List<DocumentationParameter>)yyVals[0+yyTop];
		var lt = (LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberName (lt.Value);
	  }

void case_1065()
#line 7255 "cs-parser.jay"
{
		module.DocumentationBuilder.ParsedParameters = (List<DocumentationParameter>)yyVals[-1+yyTop];
		yyVal = new MemberName ((MemberName) yyVals[-6+yyTop], MemberCache.IndexerNameAlias, Location.Null);
	  }

void case_1066()
#line 7260 "cs-parser.jay"
{
		var p = (List<DocumentationParameter>)yyVals[0+yyTop] ?? new List<DocumentationParameter> (1);
		p.Add (new DocumentationParameter ((FullNamedExpression) yyVals[-1+yyTop]));
		module.DocumentationBuilder.ParsedParameters = p;
		module.DocumentationBuilder.ParsedOperator = Operator.OpType.Explicit;
		yyVal = null;
	  }

void case_1067()
#line 7268 "cs-parser.jay"
{
		var p = (List<DocumentationParameter>)yyVals[0+yyTop] ?? new List<DocumentationParameter> (1);
		p.Add (new DocumentationParameter ((FullNamedExpression) yyVals[-1+yyTop]));
		module.DocumentationBuilder.ParsedParameters = p;
		module.DocumentationBuilder.ParsedOperator = Operator.OpType.Implicit;
		yyVal = null;
	  }

void case_1068()
#line 7276 "cs-parser.jay"
{
		var p = (List<DocumentationParameter>)yyVals[0+yyTop];
		module.DocumentationBuilder.ParsedParameters = p;
		module.DocumentationBuilder.ParsedOperator = (Operator.OpType) yyVals[-1+yyTop];
		yyVal = null;
	  }

void case_1076()
#line 7314 "cs-parser.jay"
{
		var parameters = new List<DocumentationParameter> ();
		parameters.Add ((DocumentationParameter) yyVals[0+yyTop]);
		yyVal = parameters;
	  }

void case_1077()
#line 7320 "cs-parser.jay"
{
		var parameters = yyVals[-2+yyTop] as List<DocumentationParameter>;
		parameters.Add ((DocumentationParameter) yyVals[0+yyTop]);
		yyVal = parameters;
	  }

void case_1078()
#line 7329 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] != null)
			yyVal = new DocumentationParameter ((Parameter.Modifier) yyVals[-1+yyTop], (FullNamedExpression) yyVals[0+yyTop]);
		else
			yyVal = new DocumentationParameter ((FullNamedExpression) yyVals[0+yyTop]);
	  }

#line default
   static readonly short [] yyLhs  = {              -1,
    0,    4,    0,    0,    1,    1,    1,    1,    2,    2,
   11,   11,   12,   12,   13,   13,   14,   15,   15,   15,
   19,   20,   17,   17,   22,   22,   22,   18,   18,   18,
   23,   23,   24,   24,    7,    7,    6,    6,   21,   21,
    8,    8,   25,   25,   25,   26,   26,   26,   26,   26,
    9,    9,   10,   10,   34,   32,   37,   33,   33,   33,
   33,   35,   35,   35,   36,   36,   41,   38,   39,   40,
   40,   42,   42,   42,   42,   42,   43,   43,   43,   47,
   44,   46,   49,   49,   49,   51,   51,   52,   52,   53,
   53,   53,   53,   53,   53,   53,   53,   53,   53,   53,
   53,   53,   53,   67,   62,   72,   74,   77,   78,   79,
   28,   28,   82,   54,   54,   83,   83,   84,   84,   85,
   87,   81,   81,   86,   86,   92,   55,   96,   55,   55,
   91,   99,   91,   93,   93,  100,  100,  101,  102,  101,
   97,   97,  103,  103,  104,  105,   95,   95,   98,   98,
   98,  108,   56,  111,  112,  106,  113,  114,  115,  106,
  106,  106,  107,  107,  117,  117,  120,  118,  110,  110,
  121,  121,  121,  121,  121,  121,  121,  121,  121,  121,
  122,  122,  125,  125,  125,  125,  128,  125,  126,  126,
  129,  129,  130,  130,  130,  123,  123,  123,  131,  131,
  131,  124,  133,  135,  136,  138,   57,  139,   57,  137,
  141,  137,  140,  140,  143,  145,   59,  144,  144,  134,
  134,  134,  134,  134,  149,  146,  150,  147,  148,  148,
  148,  151,  152,  153,  155,   29,   29,  154,  154,  156,
  156,  157,  157,  157,  157,  157,  157,  157,  157,  157,
  159,   60,  160,  160,  163,  158,  158,  162,  162,  162,
  162,  162,  162,  162,  162,  162,  162,  162,  162,  162,
  162,  162,  162,  162,  162,  162,  162,  162,  162,  165,
  164,  166,  164,  164,  164,   61,  169,  171,  167,  168,
  168,  170,  170,  175,  173,  176,  173,  173,  173,  177,
   63,  179,   58,  182,  183,   58,   58,  178,  185,  178,
  180,  180,  186,  186,  187,  188,  187,  189,  184,  181,
  181,  181,  181,  181,  193,  190,  194,  191,  192,  192,
   64,   65,  196,  198,  199,   30,  195,  195,  195,  197,
  197,  197,  200,  200,  201,  202,  201,  201,  201,  203,
  204,  205,   31,  206,  206,   16,   16,   16,  207,  207,
  207,  211,  211,  209,  209,  209,  212,  212,  214,   71,
  132,  109,  109,  142,  142,  215,  215,  215,  213,  213,
  216,  216,  217,  217,  219,  219,   90,   80,   80,   94,
   94,  127,  127,  161,  161,  221,  221,  221,  220,  224,
  224,  224,  226,  226,  227,  225,  225,  225,  225,  225,
  225,  225,  228,  228,  228,  228,  228,  228,  228,  228,
  228,  229,  229,  229,  229,  229,  229,  229,  229,  229,
  229,  229,  229,  229,  229,  229,  229,  229,  229,  229,
  229,  230,  230,  230,  231,  231,  231,  251,  251,  252,
  252,  253,  253,  233,  233,  250,  250,  250,  250,  250,
  250,  250,  250,  250,  250,  250,  250,  235,  235,  235,
  255,  255,  256,  256,  257,  257,  259,  259,  259,  260,
  260,  260,  260,  260,  260,  260,  261,  261,  174,  174,
  254,  254,  254,  254,  254,  266,  266,  265,  265,  267,
  267,  267,  267,  268,  236,  236,  236,  236,  264,  264,
  269,  269,  270,  270,  237,  238,  238,  239,  240,  241,
  241,  232,  232,  232,  232,  232,  275,  271,  242,  242,
  276,  276,  277,  277,  278,  278,  278,  278,  279,  279,
  279,  279,  272,  272,  222,  222,  274,  274,  280,  280,
  273,  273,   89,   89,  281,  281,  243,  282,  282,  210,
  208,  244,  244,  245,  245,  246,  246,  247,  284,  248,
  285,  248,  283,  283,  287,  286,  234,  288,  288,  288,
  288,  288,  288,  288,  288,  288,  289,  289,  289,  289,
  289,  289,  289,  289,  289,  289,  289,  289,  289,  290,
  290,  290,  290,  290,  290,  290,  291,  291,  291,  291,
  291,  291,  291,  291,  291,  291,  291,  292,  292,  292,
  292,  292,  294,  294,  294,  294,  295,  295,  295,  295,
  295,  296,  296,  296,  296,  296,  296,  296,  296,  296,
  297,  297,  297,  297,  297,  298,  298,  298,  299,  299,
  299,  300,  300,  300,  301,  301,  301,  302,  302,  302,
  303,  303,  304,  304,  304,  304,  304,  305,  305,  305,
  305,  305,  305,  305,  305,  305,  305,  305,  306,  306,
  307,  307,  307,  307,  308,  308,  310,  309,  309,  309,
   50,   50,  312,  311,  313,  311,  314,  311,  315,  316,
  311,  317,  318,  311,   45,   45,  262,  262,  262,  262,
  249,  249,  249,   88,  320,   73,   73,  321,  322,  322,
  322,  322,  324,  322,  325,  326,  327,  328,   27,   70,
   70,   69,   69,  116,  116,  329,  329,  329,  329,  329,
  329,  329,  329,  329,  329,  329,  329,  329,  329,  329,
   75,   75,  323,  323,   76,   76,  330,  330,  331,  331,
  332,  332,  333,  333,  333,  333,  218,  218,  334,  334,
  335,  119,   68,   68,  336,  172,  172,  338,  337,   66,
   66,  339,  339,  340,  340,  340,  340,  340,  344,  344,
  345,  345,  345,  342,  342,  342,  342,  342,  342,  342,
  342,  342,  342,  342,  342,  342,  346,  346,  346,  346,
  346,  346,  346,  346,  346,  346,  346,  346,  346,  360,
  360,  360,  360,  347,  361,  343,  362,  362,  363,  363,
  363,  363,  223,  223,  364,   48,   48,  366,  341,  370,
  341,  368,  368,  365,  365,  365,  367,  367,  374,  374,
  373,  373,  375,  375,  369,  369,  371,  371,  376,  376,
  377,  372,  372,  372,  348,  348,  348,  359,  359,  378,
  379,  379,  349,  349,  380,  380,  380,  383,  381,  381,
  382,  382,  384,  384,  384,  385,  386,  386,  387,  387,
  387,  350,  350,  350,  350,  388,  388,  389,  389,  389,
  393,  390,  396,  392,  392,  399,  395,  395,  398,  398,
  394,  394,  402,  401,  401,  397,  397,  400,  400,  404,
  403,  403,  391,  391,  405,  391,  391,  391,  351,  351,
  351,  351,  351,  351,  406,  407,  407,  408,  408,  408,
  409,  409,  409,  410,  410,  410,  411,  411,  411,  412,
  412,  352,  352,  352,  352,  413,  413,  293,  293,  414,
  416,  414,  414,  414,  415,  415,  353,  354,  417,  357,
  355,  355,  419,  420,  358,  422,  423,  356,  356,  356,
  421,  421,  418,  418,  319,  319,  319,  319,  424,  424,
  426,  426,  428,  427,  429,  427,  425,  425,  425,  425,
  425,  433,  431,  434,  436,  431,  435,  435,  430,  430,
  437,  437,  437,  437,  437,  442,  438,  443,  439,  444,
  445,  446,  440,  448,  449,  450,  440,  447,  447,  452,
  441,  451,  455,  451,  454,  457,  454,  453,  453,  453,
  456,  456,  456,  432,  458,  432,    3,    3,  459,    3,
    3,  460,  460,  263,  263,  258,  258,    5,  461,  461,
  461,  461,  461,  465,  461,  461,  461,  461,  462,  462,
  463,  466,  463,  464,  464,  467,  467,  468,
  };
   static readonly short [] yyLen = {           2,
    2,    0,    3,    1,    2,    4,    3,    1,    0,    1,
    1,    2,    4,    2,    1,    2,    1,    3,    5,    2,
    0,    0,   11,    3,    0,    1,    1,    1,    3,    1,
    0,    1,    0,    1,    0,    1,    0,    1,    0,    1,
    1,    2,    1,    1,    2,    1,    1,    1,    1,    1,
    0,    1,    1,    2,    0,    3,    0,    6,    3,    2,
    1,    1,    1,    1,    1,    3,    0,    3,    1,    0,
    3,    0,    1,    1,    3,    3,    1,    1,    1,    0,
    4,    4,    0,    1,    1,    0,    1,    1,    2,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    0,    4,    0,    0,    0,    0,    0,
   17,    5,    0,    9,    5,    0,    1,    1,    2,    3,
    0,    3,    1,    1,    1,    0,    8,    0,    9,    6,
    0,    0,    3,    0,    1,    1,    2,    2,    0,    5,
    0,    1,    1,    2,    3,    0,    4,    2,    1,    1,
    1,    0,    3,    0,    0,   10,    0,    0,    0,   12,
    8,    5,    1,    1,    1,    1,    0,    4,    0,    1,
    1,    3,    3,    3,    5,    3,    5,    1,    1,    1,
    1,    3,    4,    6,    2,    4,    0,    7,    0,    1,
    1,    2,    1,    1,    1,    4,    6,    4,    1,    2,
    2,    1,    0,    0,    0,    0,   12,    0,    6,    0,
    0,    4,    1,    1,    0,    0,   10,    3,    1,    1,
    2,    1,    2,    1,    0,    5,    0,    5,    1,    1,
    1,    0,    0,    0,    0,   15,    5,    0,    1,    1,
    2,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    0,    5,    1,    1,    0,    7,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    0,
    7,    0,    7,    2,    2,    2,    0,    0,    9,    1,
    1,    0,    1,    0,    6,    0,    6,    2,    1,    0,
    8,    0,    9,    0,    0,   10,    5,    0,    0,    3,
    0,    1,    1,    2,    2,    0,    5,    0,    2,    2,
    2,    1,    1,    1,    0,    5,    0,    5,    1,    1,
    2,    4,    0,    0,    0,   12,    0,    2,    2,    0,
    1,    2,    1,    3,    2,    0,    5,    3,    1,    0,
    0,    0,   13,    0,    1,    1,    3,    3,    1,    4,
    4,    2,    2,    0,    3,    2,    1,    3,    0,    3,
    1,    1,    3,    1,    2,    3,    4,    4,    0,    3,
    1,    3,    3,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    2,    2,    2,    1,    1,    2,
    2,    2,    1,    3,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    2,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    3,    3,    4,    4,    5,    4,    4,
    4,    3,    3,    3,    4,    3,    4,    4,    4,    3,
    0,    1,    3,    4,    0,    1,    1,    3,    2,    3,
    3,    1,    2,    3,    5,    2,    1,    1,    0,    1,
    1,    3,    3,    3,    2,    1,    1,    1,    1,    2,
    2,    4,    3,    1,    4,    5,    4,    3,    1,    3,
    1,    3,    1,    1,    1,    4,    3,    2,    2,    6,
    3,    7,    4,    3,    7,    3,    0,    2,    4,    3,
    1,    2,    0,    1,    1,    3,    1,    2,    3,    1,
    1,    1,    0,    1,    1,    2,    2,    3,    1,    2,
    0,    1,    2,    4,    1,    3,    4,    1,    1,    1,
    2,    4,    4,    4,    2,    4,    2,    4,    0,    4,
    0,    5,    0,    1,    0,    4,    4,    1,    2,    2,
    4,    2,    2,    2,    4,    2,    1,    2,    2,    2,
    2,    2,    2,    2,    2,    2,    2,    2,    2,    1,
    3,    3,    3,    3,    3,    3,    1,    3,    3,    3,
    3,    3,    4,    3,    3,    3,    3,    1,    2,    1,
    2,    2,    2,    2,    1,    1,    1,    3,    3,    3,
    3,    1,    3,    3,    3,    3,    3,    3,    3,    3,
    1,    3,    3,    3,    3,    1,    3,    3,    1,    3,
    3,    1,    3,    3,    1,    3,    3,    1,    3,    3,
    1,    3,    1,    5,    4,    5,    5,    3,    3,    3,
    3,    3,    3,    3,    3,    3,    3,    3,    1,    3,
    3,    2,    1,    1,    0,    1,    0,    2,    1,    1,
    1,    1,    0,    4,    0,    4,    0,    5,    0,    0,
    7,    0,    0,    8,    1,    1,    1,    1,    1,    1,
    6,    4,    4,    1,    1,    0,    1,    3,    0,    1,
    1,    2,    0,    6,    0,    0,    0,    0,   15,    0,
    1,    0,    1,    1,    2,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    0,    1,    2,    3,    0,    1,    1,    2,    4,    3,
    1,    3,    1,    3,    1,    1,    0,    1,    1,    1,
    0,    4,    1,    1,    0,    4,    1,    0,    4,    0,
    1,    1,    2,    1,    1,    1,    2,    1,    1,    2,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    0,    4,    1,    2,    2,    2,
    1,    1,    1,    2,    1,    1,    1,    0,    6,    0,
    7,    1,    1,    0,    2,    1,    0,    1,    0,    1,
    1,    2,    2,    4,    0,    2,    0,    1,    1,    2,
    4,    1,    5,    2,    2,    2,    2,    2,    2,    1,
    1,    1,    1,    1,    5,    7,    4,    0,    8,    4,
    0,    1,    1,    2,    1,    2,    1,    2,    3,    3,
    1,    1,    1,    1,    1,    5,    4,    7,    3,    6,
    0,    4,    0,    4,    2,    0,    4,    2,    3,    1,
    0,    1,    0,    5,    1,    0,    1,    0,    1,    1,
    1,    3,    4,    5,    0,    9,    5,    4,    1,    1,
    1,    1,    1,    1,    2,    2,    2,    3,    4,    3,
    3,    3,    2,    3,    3,    2,    4,    4,    3,    0,
    1,    3,    4,    5,    3,    1,    2,    0,    1,    3,
    0,    8,    3,    6,    0,    4,    2,    2,    0,    3,
    5,    4,    0,    0,   10,    0,    0,    9,    5,    4,
    2,    1,    0,    2,    2,    2,    2,    2,    4,    5,
    4,    5,    0,    5,    0,    6,    3,    2,    2,    2,
    1,    0,    3,    0,    0,    5,    2,    1,    1,    2,
    1,    1,    1,    1,    1,    0,    5,    0,    3,    0,
    0,    0,   12,    0,    0,    0,   13,    0,    2,    0,
    3,    1,    0,    4,    1,    0,    4,    1,    2,    2,
    1,    2,    2,    0,    0,    4,    2,    3,    0,    4,
    2,    2,    3,    0,    1,    1,    1,    2,    2,    2,
    2,    4,    3,    0,    7,    4,    4,    3,    1,    3,
    0,    0,    4,    0,    1,    1,    3,    2,
  };
   static readonly short [] yyDefRed = {            0,
    8,    0,    0,    0,    0,    0,    0,    0,    2,    4,
    0,    0,   11,   14,    0, 1047,    0,    0, 1051,    0,
    0,   15,   17,  408,  414,  421,  409,  411,    0,  410,
    0,  417,  419,  406,    0,  413,  415,  407,  418,  420,
  416,    0,  369, 1069,    0,  412, 1058,    0,   10,    1,
    0,    0,    0,   12,    0,  872,    0,    0,    0,    0,
    0,    0,    0,    0,  449,    0,    0,    0,    0,    0,
    0,    0,  447,    0,    0,    0,  515,    0,  448,    0,
    0,    0,  969,    0,    0,    0,  710,    0,    0,    0,
    0,    0,    0,    0,  771,    0,  824,    0,    0,    0,
    0,    0,    0,    0,    0,  446,    0,  699,    0,  871,
    0,  807,    0,  442,  832,  831,    0,    0,    0,  423,
  424,  425,  426,  427,  428,  429,  430,  431,  432,  433,
  434,  435,  436,  437,  438,  439,  440,  441,  444,  445,
  706,  587,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  707,  705,  708,  709,  791,  793,
    0,  789,  792,  808,  810,  811,  812,  813,  814,  815,
  816,  817,  818,  819,  809,    0,    0,    0,  873,  874,
  892,  893,  894,  895,  929,  930,  931,  932,  933,  934,
    0,    0,    0,   20,    0,    0,  356,    0,  359, 1055,
   16, 1048,    0,    0,  263,  262,  259,  264,  265,  258,
  277,  276,  269,  270,  266,  268,  267,  271,  260,  261,
  272,  273,  279,  278,  274,  275,    0, 1072, 1061,    0,
    0, 1060,    0, 1059,    3,   55,    0,    0,    0,   44,
   41,   43,   46,   47,   48,   49,   50,   53,   13,    0,
    0,    0,  935,  565,  450,  451,  967,    0,    0,    0,
    0,    0,    0,    0,    0,  937,  936,    0,  575,  569,
  574,  823,  870,  794,  821,  820,  822,  795,  796,  797,
  798,  799,  800,  801,  802,  803,  804,  805,  806,    0,
    0,    0,  901,    0,    0,    0,  837,  836,    0,    0,
    0,    0,    0,    0,    0,    0,  943,    0,    0,    0,
    0,  422,    0,    0,    0,  946,    0,    0,    0,    0,
  567,  968,    0,    0,    0,  835,  402,    0,    0,    0,
    0,    0,    0,  388,  389,    0,  398,    0,    0,    0,
    0,    0,    0,    0,  702,    0,  586,    0,    0,  695,
    0,    0,  582,    0,    0,  584,  580,  594,  588,  595,
  589,  583,  579,  599,  593,  598,  592,  596,  590,  597,
  591,  693,  561,    0,  560,  443,  362,  363,    0,    0,
    0,    0,    0,  825,    0,  355,    0,  400,  401,    0,
    0,  518,  519,    0,    0,    0,  829,  830,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1050,  790,  838,  828,    0,  868,  869, 1001, 1018,
    0,    0, 1002, 1004,    0, 1030,  987,  985, 1011,    0,
    0, 1009, 1012, 1013, 1014, 1015,  988,  986,    0,    0,
    0,    0,   18,    0,    0,    0, 1068,    0,    0,  370,
    0,    0, 1070,    0,    0,   42,  741,  747,  739,    0,
  736,  746,  740,  738,  737,  744,  742,  743,  749,  745,
  748,  750,    0,    0,  734,   45,   54,  517,    0,  513,
  514,    0,    0,  511,    0,  840,    0,    0,    0,  899,
    0,  867,  865,  866,    0,    0,    0,  714,    0,  940,
  938,  715,    0,    0,  542,    0,    0,  530,  537,    0,
    0,    0,  531,    0,    0,  547,  549,    0,  526,    0,
    0,    0,    0,    0,  521,    0,  524,  528,  391,  390,
  942,  941,    0,    0,  945,  944,  955,    0,    0,    0,
  956,  559,    0,  385,  558,    0,    0,  970,    0,    0,
  834,    0,  396,  397,    0,    0,  395,    0,    0,    0,
  600,    0,    0,  571,    0,  697,  617,  616,    0,    0,
  788,    0,    0,    0,  782,  784,  785,  786,  454,  455,
    0,  366,  367,    0,  194,  193,  195,    0,  684,    0,
    0,    0,  392,    0,  679,    0,    0,  949,    0,    0,
    0,  462,  463,    0,  466,    0,    0,    0,    0,  464,
    0,    0,  508,    0,  470,    0,    0,    0,    0,  496,
  499,    0,    0,  491,  498,  497,  668,  669,  670,  671,
  672,  673,  674,  675,  676,  678,  677,  604,  601,  606,
  603,  605,  602,  614,  612,  615,    0,    0,  626,  625,
    0,    0,    0,    0,  610,    0,  611,    0,  630,    0,
    0,  631,    0,  637,    0,  638,    0,  639,    0,  640,
    0,  644,    0,  645,    0,  648,    0,  651,    0,  654,
    0,  657,    0,  660,    0,  662,    0,    0,  546,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1000,  999,
    0, 1010,    0,  998,    0,    0,  357,  358, 1066, 1067,
    0,    0,  191,    0,    0, 1076,  384,    0,    0,    0,
  381, 1062, 1064,   61,   63,   64,    0,    0,   56,    0,
    0,   65,   67,   30,   28,    0,    0,    0,  731,    0,
  735,  460,    0,  516,    0,  564,    0,  577,  180,  202,
    0,    0,    0,  170,    0,    0,    0,  181,  570,    0,
  973,    0,  921,  902,    0,  912,    0,  923,    0,  939,
  877,    0,  972,    0,    0,  529,    0,  538,  548,  550,
    0,    0,    0,    0,  482,    0,    0,  477,    0,    0,
  692,  691,  509,    0,  552,  523,    0,    0,  151,  553,
  149,  150,  555,    0,  563,  562,  880,    0,    0,    0,
    0,  953,    0,  957,  557,  566,  980,    0,  976,  897,
    0,  991,    0,  989,    0,    0,  712,  713,    0,    0,
    0,  690,  689,  696,    0,  461,  787,  773,  774,  772,
  783,  694,    0,  365,  682,    0,    0,    0,  585,  581,
  948,  947,  826,  467,  459,    0,    0,  465,  456,  457,
  568,  507,  505,  504,  501,  500,    0,  495,  452,  453,
  468,  469,    0,  621,  622,  623,  624,  959,  613,  619,
  665,    0,  846,    0,    0, 1019,  993,    0, 1020,    0,
 1003, 1005, 1016,    0, 1031,    0,  997, 1045,   19,  360,
  361, 1078,  192, 1073,    0,  770,  769,    0,  768,    0,
  380,    0,   60,   57,    0,    0,    0,    0,    0,    0,
  387,    0,  725,    0,    0,   85,   84,    0,  512,    0,
    0,    0,    0,    0,  185,  576,    0,    0,    0,    0,
    0,  913,  905,  903,    0,  924,    0,    0,  971,  539,
  536,    0,  486,    0,    0,    0, 1056, 1057,  473,  479,
    0,  483,    0,    0,    0,    0,    0,    0,  878,    0,
  963,    0,  960,  954,  979,    0,  896,  992,  990,    0,
  572,    0,  698,  688,  368,  681,  680,  700,  458,  506,
  503,    0,  494,  493,  492,  666,  667,  664,    0,  862,
  845,    0,    0,    0,  851,    0,  995,    0, 1024,    0,
    0, 1039, 1040, 1033,    0, 1077,  383,  382,    0,    0,
   66,   59,    0,   68,   29,   22,    0,    0,  333,    0,
  237,    0,  112,    0,   82,  856,  124,  125,    0,    0,
    0,  859,  200,  201,    0,    0,    0,    0,  173,  182,
  174,  176,  900,    0,    0,    0,    0,    0,  922,    0,
    0,  487,  488,  481,  484,  480,    0,  474,  478,    0,
  544,    0,  510,  520,  472,  556,  554,    0,    0,    0,
  982,    0,    0,  711,  703,    0,  502,    0,    0,  843,
  842,  839,  852,  994,    0,    0,    0, 1008,    0, 1006,
 1017,    0, 1046, 1065,    0,   79,    0,    0,   73,   74,
   77,   78,    0,  350,  339,  338,    0,  726,  233,  107,
    0,  841,  860,  186,    0,  198,    0,    0,    0,  898,
  984,    0,    0,    0,    0,  904,    0,  925,  876,    0,
  525,  522,  885,    0,  891,    0,    0,  883,    0,  887,
  966,    0,  981,  977,    0,  701,    0,    0,  996, 1021,
    0, 1007,    0,    0, 1035,    0,   80,   71,    0,    0,
    0,  334,    0,    0,    0,    0,    0,  187,    0,  177,
  175,  974,  914,  908,  906,    0,  485,    0,  879,  884,
    0,  888,  964,    0,    0,  704,    0,  854,    0, 1025,
 1042, 1043, 1036,   58,    0,   75,   76,    0,    0,    0,
    0,    0,    0,    0,  720,    0,  752,    0,  717,  861,
  184,    0,  197,    0,    0,  926,  890,  889,    0,  978,
  863,    0,    0,    0,   81,    0,    0,  351,    0,    0,
  349,  335,    0,  343,    0,  405,    0,  403,    0,    0,
  727,    0,  757,  234,    0,  188,  975,  910,  907,    0,
    0,  919,  775,  777,  962, 1022,    0, 1037,    0,    0,
    0,  331,    0,    0,  718,  754,    0,  723,    0,    0,
  758,    0,  108,    0,    0,    0, 1026,   27,   26,   23,
  352,  348,    0,    0,  344,  404,    0,  760,    0,    0,
    0,    0,  909,    0,    0,    0,    0,    0,   32,  336,
    0,  765,    0,  766,  763,    0,  761,  103,  104,    0,
  100,    0,    0,   88,   90,   91,   92,   93,   94,   95,
   96,   97,   98,   99,  101,  102,  152,    0,    0,  250,
  242,  243,  244,  245,  246,  247,  248,  249,    0,    0,
  240,  109,  776,    0, 1023,    0,  353,  347,  724,    0,
    0,    0,    0,  728,   89,    0,  291,  286,  290,    0,
  235,  241,    0, 1029, 1027,  764,  762,    0,    0,    0,
    0,    0,    0,    0,    0,  300,    0,    0,  251,    0,
    0,  257,    0,  167,  166,  153,  163,  164,  165,    0,
    0,    0,  105,    0,    0,  285,    0,    0,  284,    0,
  157,    0,    0,  374,  332,    0,  372,    0,    0,    0,
    0,    0,    0,    0,    0,  729,    0,  236,  110,  115,
  113,  307,    0,  371,    0,    0,    0,    0,  128,    0,
    0,    0,    0,    0,    0,  162,  154,    0,    0,    0,
  215,    0,  375,    0,  252,    0,    0,    0,    0,  304,
    0,  282,  130,    0,  280,    0,    0,    0,  132,    0,
  376,    0,    0,  204,  209,    0,    0,    0,  373,  255,
  168,  111,  123,  121,    0,    0,  309,    0,    0,    0,
    0,    0,  158,    0,  288,    0,    0,    0,    0,  136,
    0,    0,    0,    0,  377,  378,    0,    0,    0,    0,
    0,  118,  324,    0,  305,    0,    0,  318,    0,    0,
    0,  313,    0,  148,    0,    0,    0,    0,  143,    0,
    0,  301,    0,  133,    0,  127,  137,  155,  161,  224,
    0,  205,    0,    0,  216,    0,  122,    0,  114,  119,
    0,    0,    0,  320,    0,  321,  310,    0,    0,  303,
  314,  283,    0,    0,  129,  144,  281,    0,  299,    0,
  289,  293,  139,    0,    0,    0,  221,  223,    0,  256,
  120,  325,  327,  306,    0,    0,  319,  316,  147,  145,
  159,  298,    0,    0,    0,  156,  225,  227,  206,    0,
  219,  217,    0,    0,  318,    0,  294,  296,  140,    0,
    0,    0,    0,  329,  330,  326,  328,  317,  160,    0,
    0,  231,  230,  229,  226,  228,  211,  207,  218,    0,
    0,    0,  295,  297,  213,  214,    0,  212,
  };
  protected static readonly short [] yyDgoto  = {             7,
    8,   50,    9,   51,   10,   11,   52,  237,  771,  772,
   12,   13,   53,   22,   23,  331,  240,  756,  939, 1133,
 1257, 1310, 1634,  936,  241,  242,  243,  244,  245,  246,
  247,  248,  749,  474,  750,  751, 1040,  752,  753, 1044,
  937, 1128, 1129, 1130,  273,  641, 1225,  111,  948,  813,
 1342, 1343, 1344, 1345, 1346, 1347, 1348, 1349, 1350, 1351,
 1352, 1353, 1354, 1355, 1356,  593, 1382,  860,  493,  760,
 1437, 1054, 1238, 1195, 1236, 1271, 1322, 1393, 1478, 1266,
 1505, 1479, 1530, 1531, 1532, 1056, 1528, 1057,  822,  940,
 1490, 1464, 1518,  548, 1511, 1484, 1547, 1020, 1516, 1519,
 1520, 1615, 1548, 1549, 1545, 1357, 1416, 1386, 1438,  773,
 1492, 1594, 1461, 1551, 1626,  494, 1417, 1418,  274, 1447,
  774,  775,  776,  777,  778,  731,  611, 1242,  732,  733,
  954, 1440, 1469, 1562, 1523, 1596, 1648, 1632, 1470, 1657,
 1652, 1441, 1496, 1622, 1599, 1563, 1564, 1645, 1630, 1631,
 1052, 1194, 1302, 1369, 1421, 1370, 1371, 1409, 1444, 1410,
  334,  227, 1527, 1412, 1512, 1509, 1358, 1388, 1433, 1591,
 1553, 1285, 1592,  642, 1640, 1641, 1432, 1508, 1481, 1540,
 1535, 1506, 1572, 1577, 1538, 1541, 1542, 1625, 1578, 1536,
 1537, 1636, 1623, 1624, 1049, 1137, 1262, 1230, 1293, 1263,
 1264, 1313, 1191, 1290, 1327,  388,  197,  113,  377,  378,
  114,  604,  470,  230, 1456,  740,  741,  928,  941,  335,
  336,  435,  327,  337,  311, 1267, 1268,   46,  118,  312,
  120,  121,  122,  123,  124,  125,  126,  127,  128,  129,
  130,  131,  132,  133,  134,  135,  136,  137,  138,  139,
  140,  258,  891,  818, 1094, 1083,  806,  979,  807,  808,
 1084,  141,  202,  814,  644,  645,  646,  885,  503,  504,
  304, 1092,  816,  436,  306,  532,  533,  534,  535,  538,
  824,  566,  270,  509,  849,  271,  508,  142,  143,  144,
  145,  673,  899,  674,  146,  147,  148,  149,  150,  151,
  152,  153,  154,  155,  156,  614,  615,  616,  854,  855,
  157,  601,  589,  851,  379, 1106,  585, 1175,  158,  523,
 1233, 1234, 1237, 1317, 1050, 1193, 1300, 1413,  495, 1272,
 1273, 1336, 1337,  929,  354, 1305,    0,    0,  594,  595,
  275,  276,  277,  161,  162,  163,  278,  279,  280,  281,
  282,  283,  284,  285,  286,  287,  288,  289,  175,  290,
  621,  176,  177,  328,  905,  708, 1023, 1112,  951,  767,
 1060, 1021, 1024, 1153, 1025, 1061, 1062,  291,  178,  179,
  180, 1166, 1098, 1167, 1168, 1169, 1170,  181,  182,  183,
  184,  784,  516,  785, 1156, 1078, 1157, 1279, 1245, 1280,
  786, 1077,  787, 1282, 1206,  185,  186,  187,  188,  189,
  190,  313,  560,  561,  831, 1214,  324, 1076,  961, 1244,
 1103,  996, 1215,  191,  448,  192,  449, 1026, 1115,  450,
  451,  724,  715,  716, 1120, 1030,  452,  453,  454,  455,
  456, 1031,  710, 1028, 1219, 1306, 1375, 1117, 1253, 1326,
  915,  718,  916, 1184, 1122, 1185, 1254, 1035,   17,   19,
   47,   48,  229,  734,  932,  468,  735,  736,
  };
  protected static readonly short [] yySindex = {          -68,
    0, -187,  189,  161,  258,18441,    0,  251,    0,    0,
  258,  161,    0,    0,  303,    0, 8261,  258,    0, -151,
 -258,    0,    0,    0,    0,    0,    0,    0,  249,    0,
  448,    0,    0,    0, 5471,    0,    0,    0,    0,    0,
    0,  297,    0,    0,  426,    0,    0,  720,    0,    0,
  251,  495,  258,    0,  534,    0,  322,  590, -183,17987,
  -27,  138,  512, 8419,    0,  138,  138,  138,  -90,  138,
  138,  610,    0,10410,  138,  138,    0,10568,    0,  642,
  138, -181,    0,  138,  645,  138,    0,18473,18473,  666,
  138,  138,   97,10728,    0,17096,    0,11916,12048,12180,
12312,12444,12576,12708,12840,    0,  232,    0, 9503,    0,
  184,    0,   50,    0,    0,    0,  579,  500, -234,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  853,  917,  209,  755,  636,  338,  671,  697,
  686,  694,  533,  713,    0,    0,    0,    0,    0,    0,
 3940,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   50,  745,  197,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  377,  418,  495,    0,  517, -240,    0,  704,    0,    0,
    0,    0, 9503, 9503,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  297,    0,    0,  712,
  751,    0, -200,    0,    0,    0,  495,19024,  841,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  877,
   50,17233,    0,    0,    0,    0,    0,17096, -205, -141,
  901,  811,  488,  500,   50,    0,    0, 9503,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  156,
  275,17987,    0, 9503,17096,  816,    0,    0,  826,17096,
17096, 6467,  537,  -93,  874, 9503,    0,10728,  232, 1010,
  897,    0,  913, 9503,17096,    0, 1022,  918,  690,  951,
    0,    0,17096,  642,16685,    0,    0,  645,17096,  577,
  634,  989,   50,    0,    0,  745,    0, -234, 1013,   50,
17096,17096,17096,  512,    0,  980,    0, 9503, 9503,    0,
11784,   50,    0, 8577,  250,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1069,    0,    0,    0,    0,18291,  577,
  959,  958,17096,    0,  562,    0,  126,    0,    0,  316,
  259,    0,    0,  923,10860, 8893,    0,    0,17096,17096,
17096,17096,17096,17096,17096,17096,17096,17096,17096,12972,
13104,13236, 2103,15577,13368,13500,13632,13764,13896,14028,
14160,14292,14424,14556,14688,14820,14952,15084,15216,17644,
17096,    0,    0,    0,    0,  745,    0,    0,    0,    0,
18473,18473,    0,    0,   50,    0,    0,    0,    0,  552,
  981,    0,    0,    0,    0,    0,    0,    0,  495,  841,
  927,  943,    0,  562,  297,  297,    0,  486,  107,    0,
  297,  998,    0, -193,19024,    0,    0,    0,    0, -145,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  255,19054,    0,    0,    0,    0,  962,    0,
    0, 1003,  788,    0, 1001,    0, 1011,  164,  642,    0,
  138,    0,    0,    0,   50,16685, -115,    0, 1021,    0,
    0,    0,  112,  168,    0,  811,  488,    0,    0, 1008,
    0, 1041,    0, 1037,  983,    0,    0,  805,    0, 9167,
  806,11018,  874,16548,    0, 9328,    0,    0,    0,    0,
    0,    0,  174,  192,    0,    0,    0, -224,  642, -147,
    0,    0,  645,    0,    0, 1042, 1044,    0,  195,   50,
    0,  205,    0,    0,17096, 1126,    0,17096, 1129, 1050,
    0, 1053, 1055,    0,18291,    0,    0,    0,  188,  962,
    0,  -92, -272, 8577,    0,    0,    0,    0,    0,    0,
  188,    0,    0, -235,    0,    0,    0,  645,    0,  577,
   50, 9661,    0, 1056,    0, 1060,15348,    0, 1181, 1061,
 8577,    0,    0, 1014,    0,  962,   50,17233, 1015,    0,
  562,  962,    0,  116,    0,17096,17096, 1067, 1186,    0,
    0,  270,  146,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,17769,17769,    0,    0,
 -234,    0,   50,  745,    0,  917,    0,  917,    0,11652,
  209,    0,  209,    0,  755,    0,  755,    0,  755,    0,
  755,    0,  636,    0,  636,    0,  338,    0,  671,    0,
  697,    0,  686,    0,  694,    0,  -57, -180,    0,11018,
 1151,   50, 1152,   50,11018,11018, 1066,17096,    0,    0,
  981,    0,   50,    0,  244,  562,    0,    0,    0,    0,
 9661,  486,    0, 1076, 1075,    0,    0,  707,  495,   -8,
    0,    0,    0,    0,    0,    0, -185, 1077,    0, 1079,
 1081,    0,    0,    0,    0, 1083,10269, 1039,    0,  435,
    0,    0,  687,    0,17233,    0, 1082,    0,    0,    0,
  729,  141, 1086,    0, 1088, 1091, 1092,    0,    0,17096,
    0,   50,    0,    0,  818,    0, 1094,    0,  256,    0,
    0, 8419,    0, 8419, 9802,    0,15688,    0,    0,    0,
 9962,10094,  422,11018,    0,    7,  149,    0, 1031, 1046,
    0,    0,    0,  834,    0,    0, 1099, 1098,    0,    0,
    0,    0,    0, 1100,    0,    0,    0, 1106,  138, 4352,
  642,    0,  642,    0,    0,    0,    0, 8419,    0,    0,
 8419,    0,17096,    0,17096, 9503,    0,    0,  642, 1103,
  188,    0,    0,    0,17096,    0,    0,    0,    0,    0,
    0,    0, 9503,    0,    0,   50,18291, 1135,    0,    0,
    0,    0,    0,    0,    0,  962,  842,    0,    0,    0,
    0,    0,    0,    0,    0,    0,16411,    0,    0,    0,
    0,    0, 9486,    0,    0,    0,    0,    0,    0,    0,
    0,10252,    0, 9644, 1108,    0,    0, 1190,    0, 1191,
    0,    0,    0,  932,    0, 1111,    0,    0,    0,    0,
    0,    0,    0,    0,  486,    0,    0, 1068,    0,  107,
    0,  486,    0,    0,  927, 1119, 1122, 1072, 1130, 1039,
    0, 1121,    0, 1245, 1246,    0,    0,11018,    0,16822,
 1128,  729, 9661, 9503,    0,    0,  371, 1249, 1250,  219,
 1127,    0,    0,    0,17096,    0,17096, 1230,    0,    0,
    0,16959,    0,  342,16959,  848,    0,    0,    0,    0,
 9030,    0, 1256,  745,11018, 1145, 9802, 1146,    0,17096,
    0,   50,    0,    0,    0,  -87,    0,    0,    0, 1141,
    0, 1174,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  706,    0,    0,    0,    0,    0,    0, 9503,    0,
    0,   50, -242, 1108,    0,11018,    0,11018,    0,  191,
11018,    0,    0,    0,  503,    0,    0,    0, 1150,  927,
    0,    0,11176,    0,    0,    0, 1155, 4512,    0, 1039,
    0, 1039,    0, 1039,    0,    0,    0,    0,   50, 1156,
 1128,    0,    0,    0, -109, -125, 1154, 1157,    0,    0,
    0,    0,    0, 1159, 9802, 1108, -180,17096,    0, 1166,
 8419,    0,    0,    0,    0,    0, 1158,    0,    0, 1170,
    0,  874,    0,    0,    0,    0,    0, -201, 1169, 1171,
    0, 1108, 1175,    0,    0,  188,    0, 1123, 1167,    0,
    0,    0,    0,    0,11018, 1204,11018,    0,11018,    0,
    0,17096,    0,    0, 1081,    0,  515,  739,    0,    0,
    0,    0,  161,    0,    0,    0, 1185,    0,    0,    0,
 1172,    0,    0,    0,  682,    0, 1176, 1300, 1303,    0,
    0, 1108, 1193, 1108, 1195,    0, 1187,    0,    0,16959,
    0,    0,    0,17096,    0, 1194, -209,    0, 8101,    0,
    0, 1313,    0,    0,  188,    0,17096, 9644,    0,    0,
 1223,    0,  964, 1197,    0, 1202,    0,    0,11176,  258,
  164,    0,  852, 1199, 1205,16822, 1207,    0,17096,    0,
    0,    0,    0,    0,    0, 8419,    0,   77,    0,    0,
 8577,    0,    0, 1290, 8419,    0, 1213,    0,11018,    0,
    0,    0,    0,    0,17096,    0,    0,  495, 1214,  495,
  164, 9503, 1199, 1253,    0, 1253,    0, 1199,    0,    0,
    0,17096,    0, 8419,11334,    0,    0,    0,  906,    0,
    0, 1240,11018,17096,    0,  495, 1220,    0, 1180,  991,
    0,    0, 1225,    0, 1222,    0,  165,    0, 1229, 1183,
    0, 1253,    0,    0, 1253,    0,    0,    0,    0, 1231,
 1094,    0,    0,    0,    0,    0, 1255,    0,   68, 1253,
 1349,    0, 1238,  495,    0,    0, 9503,    0,  106, 1241,
    0, 1242,    0, 8419, 8577,11018,    0,    0,    0,    0,
    0,    0, 1226, 1235,    0,    0,16548,    0, 2289,   66,
  495, 1247,    0, 1248, 1260,11018, 1251,17096,    0,    0,
 1254,    0, 1257,    0,    0, 1243,    0,    0,    0,19054,
    0, 1261,   66,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  714,19054,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1262,  495,
    0,    0,    0,   50,    0, 1260,    0,    0,    0, 1259,
 2289, 8577,18159,    0,    0,  595,    0,    0,    0, 5312,
    0,    0,   66,    0,    0,    0,    0, -272, 9503, 9503,
  176, 9503,  477,  645, 1282,    0,  577, 1663,    0, 1317,
    0,    0, 1235,    0,    0,    0,    0,    0,    0, 4029,
 1235, 1264,    0, -123, -120,    0, 9503, -118,    0, 9503,
    0, 1215, 1265,    0,    0,   12,    0,  143, 4675,    0,
 1266, 1219,  153,  595, 5471,    0,17096,    0,    0,    0,
    0,    0,   12,    0, 1271, 1221, 1269, 1267,    0, 1270,
 1224, 1275,  164, 1272, 1274,    0,    0, 1280, 1281, 1310,
    0,  962,    0,  965,    0, 1296, 1292, 1235,  -62,    0,
 1288,    0,    0, 1301,    0, 1304, 1299, 1302,    0, 1306,
    0,  164,  164,    0,    0,  164, 1305, 1309,    0,    0,
    0,    0,    0,    0, 1314,  150,    0, 1316,  164, 1421,
 1318,  164,    0,  501,    0, 9802, 1273, 1308, 1306,    0,
 1321, 1322,  152, 1325,    0,    0,  164,16822, 1278, 1323,
 1314,    0,    0,19054,    0,  495,  495,    0, 1279, 1324,
 1316,    0, 1326,    0,17096, 1284, 1327, 1318,    0, 1332,
  164,    0,  114,    0, 1328,    0,    0,    0,    0,    0,
19054,    0,  152,  152,    0, 1333,    0,  -62,    0,    0,
  409, 1338,19054,    0,19054,    0,    0, 9802, 1329,    0,
    0,    0, 1337, 1301,    0,    0,    0, 1336,    0,  208,
    0,    0,    0, 1253, 1017, 1343,    0,    0,  538,    0,
    0,    0,    0,    0, 1398, 1451,    0,    0,    0,    0,
    0,    0, 1344, 1345, 9802,    0,    0,    0,    0,  152,
    0,    0,  580,  580,    0, 1253,    0,    0,    0, -143,
 -143, 1340, 1354,    0,    0,    0,    0,    0,    0,16548,
16548,    0,    0,    0,    0,    0,    0,    0,    0, 1360,
 1361,16822,    0,    0,    0,    0, 1358,    0,
  };
  protected static readonly short [] yyRindex = {         1936,
    0,    0, 8735, 1936,    0,    0,    0, 1736,    0,    0,
 3522, 1489,    0,    0,    0,    0,    0, 3522,    0,    0,
   56,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1737,    0,    0, 1737,    0,    0, 1737,    0,    0,
 1736, 3602, 2027,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1371,    0,    0,    0,    0,    0,    0,    0,
    0,10427,    0, 1363,    0,    0,    0, 1363,    0,    0,
    0,    0,    0,    0, 3192,    0,    0,    0,    0,    0,
    0,    0,    0,  190,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 5375,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 5788, 5311, 5699,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 5893, 6070, 4119, 6623, 7048, 7255, 7393, 7531,
 7669, 7807, 1311, 5470,    0,    0,    0,    0,    0,    0,
   56,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  238,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 3649,    0,  688,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1737,    0,    0,  307,
    0,    0,    0,    0,    0,    0, 3712,  432, 3755,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 4351,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1373,    0,    0,    0,    0,    0,    0, 4351, 1366,
    0,    0,    0,    0,    0,    0, 1366,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 2148,    0,  403,
 2851,    0,    0,    0,    0, 2982,    0, 2851,    0,    0,
    0,    0,    0, 1371,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  198,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1372, 3087,
    0,    0, 1363,    0, 4351,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  278,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 2384,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1852,    0,    0,    0,    0,    0,    0,    0, 3798, 3861,
    0,    0,    0, 1531, 1737, 1737,    0, 8910, -206,    0,
 1737, 1744,    0,    0,   84,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  479,17919,    0,    0,    0,    0, 4351,    0,
    0,    0,    0,    0,    0,    0,    0,18191,    0,    0,
    0,    0,    0,    0,    0,  868,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  233, 1047,    0,    0,  230,
 1928,    0,    0, 1378,  513,    0,    0,    0,    0,  215,
    0,    0, 4831, 1376,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1384,    0, 2553,
    0,    0,  222,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1372,    0,    0,    0,17370, 4351,
    0, 7940,    0,  225,    0,    0,    0,    0,    0,    0,
17370,    0,    0,    0,    0,    0,    0,   60,    0,  703,
    0,    0,    0, 1381,    0,    0,    0,    0, 1366,    0,
    0,    0,    0, 4191,    0, 4351,    0,    0, 4030,    0,
 4351, 4991,    0,    0,    0,    0,    0, -202,    0,    0,
    0,    0,  313,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 5535, 5640, 6142, 5965,    0, 6247,    0, 6319,    0,    0,
 6469,    0, 6554,    0, 6692,    0, 6761,    0, 6830,    0,
 6899,    0, 7117,    0, 7186,    0, 7324,    0, 7462,    0,
 7600,    0, 7738,    0, 7876,    0,    0,  749,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1852,    0,    0,    0,    0, 1531,    0,    0,    0,    0,
    0,11035,    0,    0,  817,    0,    0, 1339,15851,    0,
    0,    0,    0,    0,    0,    0,  781,  774,    0,    0,
 1385,    0,    0,    0,    0, 1820,    0,    0,    0,    0,
    0,    0,11492,    0,    0,    0,  845,    0,    0,    0,
11193,18364,    0,    0,  881,  920,  937,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  870,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1386,    0,    0,    0,
    0,    0, 6961,    0,    0,    0,  261,    0,  117, 4511,
    0,    0,    0,    0,    0,    0,    0, 1387,    0,    0,
    0,    0,    0, 1388,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
17370,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 4351,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  674,    0,    0,    0,    0,    0,
    0,    0,    0, -169,    0,  576,    0,    0,    0,    0,
    0,    0,    0,    0,11193,    0,    0,    0,    0, -206,
    0, 9345,    0,    0, 1391,    0,  873,    0,    0,    0,
    0, 1395,    0, 1346, 1348,    0,    0,    0,    0,    0,
 1382,11351,    0,    0,    0,    0,18396,    0,    0,    0,
  939,    0,    0,    0,    0,    0,    0, 2721,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 4671,    0, 5151, 1399,    0,    0,    0,
    0, 1396,    0,    0,    0,  939,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  771,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  940,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1394,    0,    0,    0,    0,    0,  957,  960,    0,    0,
    0,    0,    0,    0,    0, 1401,  761, 1400,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 4831,    0,    0,    0,    0,    0, 1403,    0,    0,
    0, 1401,    0,    0,    0,17370,    0,  752,  762,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1385,    0,15689,    0,    0,    0,
    0,    0,18521,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  793,    0,  798,    0,    0,    0,
    0, 1402,    0,  895, 1404,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1407,    0,    0,    0,
    0,  202,    0,    0,17370,    0,    0,    0,    0,    0,
    0,    0,  113,  678,    0,    0,    0,    0,    0,18592,
18191,    0,  386,  511,  449,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 -208,    0,    0, 1020,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,18748,    0, -253,
18191,    0,  522, 1410,    0, 1410,    0,  511,    0,    0,
    0,    0,    0,    0, 1406,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,18791,    0,    0,    0,16125,
    0,    0, 1411,    0,    0,    0,  364,    0,  532,    0,
    0,  606,    0,    0, 1410,    0,    0,    0,    0,    0,
 1409,    0,    0,    0,    0,    0,    0,    0, 3479, 1412,
  493,    0,    0,  333,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1414,    0,    0,    0,    0,    0,
    0,    0,    0, 3363,    0,    0, 1376,    0,    0,15957,
16209,    0,    0,    0,  767,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  617,    0,    0,    0,18091,
    0,    0,16041,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 5152,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,16293,
    0,    0,    0,    0,    0,  767,    0,    0,    0,    0,
    0,  198,  479,    0,    0,    0,    0,    0,    0,  479,
    0,    0,15957,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 4830,  507,    0,16335,    0,    0,    0,
 4990,    0, 3363,    0,    0,    0,    0,    0,    0,    0,
 3363,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  257,    0,  584,    0,  647,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  824,    0,  692,    0,    0,    0,    0,    0,
    0,    0,18191,  947,    0,    0,    0,    0,    0,    0,
    0, 1390,    0,  438,    0,    0,    0, 3363,    0,    0,
  963,    0,    0,    0,    0,    0,    0,    0,    0, 1417,
    0,18191,18191,    0,    0,18259,    0,    0,    0,    0,
    0,    0,    0,    0, 1418,15719,    0, 1420,18191,17507,
 1425,18191,    0,    0,    0,    0,    0,    0, 1426,    0,
    0,    0,18984,    0,    0,    0,18191,    0,    0,    0,
 1427,    0,    0,  424,    0,18914,18954,    0,    0,    0,
 1428,    0,    0,    0,    0,    0,    0, 1430,    0,    0,
18191,    0,  716,    0,  968,    0,    0,    0,    0,    0,
 1029,    0,18834,18874,    0,    0,    0,    0,    0,    0,
    0,    0, 1469,    0, 1525,    0,    0,    0,  978,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  611,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,18984,
    0,    0,18634,18672,    0,  611,    0,    0,    0,    0,
    0,15498,    0,    0,    0,    0,    0,    0,    0, 1376,
 1376,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,
  };
  protected static readonly short [] yyGindex = {            0,
    0, 1757,    0,    0,    0,   -1,  -16, -178,  -44,  -41,
    0, 1797, 1806,  103,    0,    6,    0,    0,    0,    0,
    0,    0,-1157, -774, -216, -708,    0,    0,    0,    0,
    0, -221,    0,    0,    0,  776,    0,  883,    0,    0,
    0,    0,  630,  632,  -17, -227,    0,  -47,    0, -112,
  430,    0,  487, -587, -577, -576, -541, -537, -525, -516,
 -503,    0,    0,-1152,    0,-1187,    0,  434,-1258,    0,
    3,    0,    0,    0,  596,-1183,    0,    0,    0,   -3,
  267,    0,    0,    0,  306,-1151,    0, -281, -301, -354,
    0,    0,    0, -985,  262,    0,    0, -529,    0,    0,
  320,    0,    0,  299,    0,    0,  401,    0, -630, -856,
    0,    0,    0,    0,    0, -404,  335,-1396,  -10,    0,
    0,    0,  893,  898,  900, 1089, -572,    0,    0, -336,
  902,  436,    0, -905,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  234,    0,    0,
    0,    0,    0,    0,    0,    0,  496,    0,    0,    0,
 -315,  423,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  505,    0, -531,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  246,    0,    0,  331,    0,    0,  336,
  340,  266,    0,    0,    0,    0,    0,    0,    0,    0,
  598,    0,    0,    0,    0,  -86,    0,  135, -373, -304,
 1277,    0,  421,    0, -349,    0,  966,    0, 1577,  148,
 -305, -274,  -81,  203, 1232,    0,  601,    0,  -21,  509,
 1495,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, -267,
    0,   28,    0, -352,    0, -280,    0,    0,    0,  931,
 -927, -313, -132,  554,    0, 1026,    0, 1276, -343, 1160,
    0,    0,  828, 1851,    0,    0,    0,    0, 1137,    0,
    0,    0, 1593,    0,    0,    0,    0,    0, 1627,  986,
  987,    0,  946,    0,  812,  984, 1514, 1515, 1513, 1516,
 1517,    0, 1512,    0,    0,    0, 1084, 1364, -569,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, -306,
  748,    0, -444,    0,    0,    0,    0,    0, -475,    0,
  681,    0,  573,    0,    0,    0,    0,    0,  787, -563,
  -11, -334,   -7,    0, 1796,    0,   48,    0,   85,   91,
  111,  128,  157,  173,  175,  181,  193,  194,    0, -662,
    0,  -23,    0,    0,  882,    0,  804,    0,    0,    0,
    0,  784, -959,  862, -931,    0,  905, -489,    0,    0,
    0,    0,    0,    0,  800,    0,  802,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  724,    0,    0,    0,    0,    0,    0,    0,
    0,  -31,    0, 1416,  763,    0,    0,  985,    0,    0,
    0,    0,    0,    0, -176,    0,    0,    0,    0,    0,
 1529, 1283,    0,    0,    0,    0, 1532,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  607,    0,    0,    0,
    0,    0,    0,    0,    0,  731,    0,    0,    0,    0,
    0,    0,   35, 1054,    0,    0,    0, 1062,
  };
  protected static readonly short [] yyTable = {           110,
  550,  193,   18,  547,  564,  159,  112,  238,   44,  160,
  239,  622,  817,  519,  459,  458,  823,  497,  761,  597,
  476,  299,  572,  545,  501,  196,  783,  580,  432,  543,
  861,  862,  397, 1108,  531,  389,  265,  398,  264,  866,
  332,  339,  612,  643, 1240,  346,  318, 1086,  257,  988,
  254,  634, 1274,  710, 1163, 1054,  310,  873, 1164,  886,
  317,  577,  744,  613,  164,  385, 1164,  829,   14,  319,
  933,  322,  254, 1495,  321,  903,   20, 1261,  355,  232,
  623, 1383,  234,    6,  333,  340, 1038,   51,  745,  268,
  727, 1303, 1113,  292,  293,  294,  858,  300,  301,   51,
 1390,  165,  314,  315,  194,  381, 1311,  166,  320,  323,
  754,  325, 1642,  329,  321,  340, 1152, 1324,  342,  343,
  746,  558,  386,  201,  472,  762, 1110,  167,  434,  968,
 1146,  969, 1450,  462, 1111, 1452,  463, 1458,  833,  863,
  788, 1261, 1152,  110,  168,  396, 1144,  255,  238,  159,
  112,  460,  326,  160,  198,  201, 1330,  859,  922,  728,
  886,  709,  539,  857,  115,   51,  255,  501, 1101, 1038,
  710,  200,  710,  169, 1038,  995, 1038,  295,  997, 1038,
 1038,  864, 1038, 1038,   95,  296,   95,    1,  255,  170,
  255,  171,  475, 1503, 1398,  460,  256,  172,  901,  465,
  466,  904, 1621,  499,  502, 1038,  373,  115,  164,  173,
  174,  115,   51, 1165,  886,  256,  856,  506,   43,  116,
 1113, 1165,  198,  198,   95,  747,  809,  710,  266,  374,
  255,   15, 1207, 1643,  500,  473,  375,  256,  497,  256,
  505,  815,  476,  198,  573,  165,  571,  297,  612,  574,
  372,  166,  875,  297,  530, 1446,  389,  879,  881,  597,
 1038,  467,  116, 1448,  507,  970,  116,  195,  515,  613,
  264,  167,  297,  755,  540, 1571,  541,  518,  255,  256,
  264, 1003,  522,  524,  877,  576,  597,  323,  168,    2,
  517,  396,  579, 1147, 1075, 1451,  613,  554, 1453,  373,
 1459,  570, 1595,  298,  590,  567,  379,  569,  115,  298,
  553,  522, 1054,  568, 1605,  393, 1606,  169,  902, 1504,
 1502, 1338,  374, 1308,  582,  583,  880,  256,  298,  375,
  542,  544, 1247,  170, 1229,  171,  376,  198,  198,  626,
    6,  172,  596,  631,  587,  588,  598,  502,  502,  267,
 1186,  620,  920,  173,  174,  732,    3,    4,    5,    6,
  732, 1318,  737,  116,  732,  619,  930,  791, 1041, 1589,
  603,  882, 1054,  344, 1265,  977, 1567,  500,  640,  732,
 1065,  647,  648,  649,  650,  651,  652,  653,  654,  655,
  656,  657,  264,  711,  713,  923,  955,  717, 1466,  900,
  501,  892,  198,  373,  980, 1533,  732, 1560,  931,  665,
 1616,  510,  297,  707,  238,  613, 1428,  460, 1159,  769,
 1296,  921,  393,  793,  738,  732,  374,  739,  198,  825,
  393, 1426,  393, 1339,  393,  236,  978,  712,  714,  115,
  198,  564, 1639,  852, 1309,   16, 1118,  827,  198,  382,
  837, 1041, 1248,  549,  198,  837, 1041, 1096, 1041,  297,
  840, 1041, 1041, 1612, 1041, 1041,  725,  781,  298,  789,
  413, 1613,  115,  960, 1073, 1079,  236, 1473,  393,  748,
 1427, 1319,  198,  198,  792, 1054,  883, 1041,  297, 1590,
  765, 1054,  782,  961,  116,  511,  502,  383,  779,  729,
  730,  115, 1009,  837,  770,  742,  414,   49,  198,  255,
  236,  966,  369,  198, 1467,  298,  345,  497,    2,  236,
  893,  236,  839,  981,  812,  119,  640,  116,  821,  531,
  612,  757, 1614,  236, 1012,  758, 1176,  501,  780, 1297,
  794, 1119, 1041, 1246,  624, 1151,  826,  198,  832,  967,
  497,  613, 1250,  203,  625,   95,  116,  842,  256,  384,
  844,  669,  379,  865,  828,  837,  780,  838,  119,  961,
  961, 1474,  119,  437,  372,  198,  198,  841,  853,  876,
  502, 1277,  596,  475,  896,  830,  598,  415,  416,  897,
  853, 1074,   20,  781,  386,  198,  759,  906,  540,  369,
  827,  837,  911,  912,  540, 1216, 1488,  837,  198,  596,
  500, 1341, 1360,  598,  837, 1063,  670,  462,  884,  884,
  919,  297,  599,  373,  369,  898,  438,  780,  369,  476,
  364,  126,  439,  126, 1341, 1521, 1522,  613,  126, 1524,
  386, 1323,  889,  512,  475,  379,  374,  861, 1058,  379,
  489,  513, 1543,  375,  781, 1550,  827, 1597, 1598,  540,
  376, 1360,  837,  115,  908, 1014,  910,  809,  228,  119,
 1566, 1602,  369,  439,  379,  918,  982,  629,  379,  600,
  379,  379,  379,  379, 1341,  490,  732,  630,  379,  627,
  476,  250,  812,  379, 1588,  251,  836,  812,  812,  890,
  914,  342,  753,  732,  514, 1095,  943,  489,  732, 1091,
 1085, 1067,  732,  550, 1633,  440,  985,  502,  116,  198,
  441,   55,  442, 1603,  719,  443,  444,  732,  445,  446,
  944,  753, 1429, 1361,  962,  753,  423,  424,  732,  628,
  236,  115,  490, 1362, 1363,  252,  198,  500, 1235,  530,
  730,   51,  204,  719,  732,  783,  440,  945,  439,  364,
  942,  441,  522,  442,  372,  364,  443,  444,  115,  445,
  446, 1155,  364,  732,  730,  264,  364,  821,  731, 1364,
  379, 1430, 1361, 1365,  812, 1331,  812,  716, 1269,  364,
  815,  605, 1362, 1363, 1454, 1366,  116,  228,  606,  231,
  119,  730,  731,  975, 1367,  379,  447,  719, 1468,  379,
  607,  364,  379,  373,  379, 1132,  716, 1368, 1006,  379,
  993,  364,  994,  116,  716,  998,  992,  999, 1364,  731,
 1486, 1032, 1365,  119,  597, 1055,  374, 1004, 1001,  502,
  853,  440, 1000,  375, 1366,  502,  441,  457,  442,  751,
  376,  443,  444, 1367,  445,  446,  990,  372, 1123, 1005,
  721,  345,  119,  390,  236,  198, 1368,  345,   95,  640,
  722,  255, 1093,  391,  346,  640,  597, 1415,  751,  373,
 1414,  535, 1208,  269, 1018,  738,  821,  535,  739,  721,
  440,  198,  392,  393, 1058,  441, 1187,  442,  461,  722,
  443,  444,  374,  445,  446, 1620,  373,  536,  373,  375,
  249,  537,  394, 1114, 1032, 1116,  376, 1243, 1121, 1032,
  256, 1032,  671,  395, 1032, 1032,  371, 1032, 1032,  374,
  812,  374,  518, 1034,  429,  386,  375, 1414,  375,  115,
  748,  115, 1047,  376,  898,  557,  430,   95,  756, 1080,
 1066,  371,  387,  755, 1082,  759, 1329, 1082,  558,  759,
 1276, 1132,   95,  761,  198,  326,  253,  812,  373,  821,
  597, 1415, 1099,  756, 1109,  559,  374,  302,  755,  303,
  198,  720,  756,  375,  759,  115, 1554,  755,  115,  208,
  386,  374,  946,  759,  116,  502,  116,  198,  375,  947,
  926,  198, 1179, 1439, 1181, 1032, 1182,  462,  812,   95,
  812, 1141,  927,  812,  203, 1439, 1034, 1145,  419,  420,
  326, 1034, 1028, 1034,  119, 1131, 1034, 1034, 1408, 1034,
 1034,  326,  421,  422,  605, 1420,  952,  341,  497,  476,
  116,  606,  847,  116, 1136,  748, 1378,  597, 1607, 1256,
  847, 1197, 1138,  607, 1139,  425, 1140,  821, 1443,  364,
  522,  364, 1465, 1198,  364,  364,  302, 1411,  302,  198,
 1443,  427,  364,  302, 1411,  683,  364,  683, 1107, 1465,
  893, 1283, 1284,  292,  292, 1629,  426,  198,  198,  364,
 1387,  228,  292,  233,  428,  853,  550,  812, 1497,  812,
 1498,  812,  119,  431, 1183, 1028, 1252, 1034, 1650, 1651,
 1028, 1188, 1028, 1189,  303, 1028, 1028,  844, 1028, 1028,
  864,  364,  464,  844,  864,  844,  864,  469,  864,  119,
  853, 1190,  498,  844,  853,  844,  853,  844,  853,  848,
 1287,  502, 1082,  848,   69,   69,  518,  848,   69,  417,
  418,  364,  364,  198,  364,  364,   62,  596,  764, 1217,
  821,  598,  765,  183,  853,  183,  549,  183,  196,  471,
  196, 1131,  196, 1228,  198,  799,  810,  344,  518,  800,
  537,  518,  198,  238,  352, 1259,  460, 1075, 1260, 1075,
  963,  369,  520, 1325,  964,  369, 1028,  364,  369,  596,
  369,  812,  521,  598,  984,  369,  562, 1255,  985,  496,
  236,  238, 1010, 1376,  460,   24,  765,   25, 1087,  855,
   26,  855,  985, 1231,  518,   27, 1058, 1232,  115,   28,
  685,  687,  689,  691,  399,  812, 1183,   45,   30,  369,
  911,  546,  915,   70,  911,   32,  915,   70,  117, 1259,
   33,  171, 1260,  171,   34,  400,  401,  402,  403,  404,
  405,  406,  407,  408,  409,  551,   36,  847,   37,  502,
  387,  847,   38, 1283, 1284, 1340, 1359,  555, 1260,  739,
   39,   40,  575,  116,   41, 1032, 1033,  563,  812,  552,
  178,  117,  178,  596,  556,  117,  199,  598, 1340,  640,
  119, 1260,  119,  410,  411,  412,  578,  179,  812,  179,
  518,  983,   72,  983,   72, 1335,  115, 1221, 1222,  338,
  338,  131,  586,  131,  602, 1359, 1394,  202,  739,  202,
  172,  617,  172,   24,  618,   25,  723,  308,   26,  308,
  338,  632,  138,   27,  138,  380,  119,   28, 1340,  119,
 1656, 1260,  315,  115,  315,  974,   30,  976,  115, 1292,
  236,  726,  115,   32,  199,  199,  198,  743,   33,  380,
  596,  116,   34,  766,  598, 1419,  374, 1335,  763,  374,
  469, 1617, 1618,  768,   36,  199,   37,  965,  965,  795,
   38,  115,  117,  732,  732, 1424, 1425,  790,   39,   40,
  676,  678,   41,  681,  683,   85,  693,  695,  116,  796,
  364,  797,  798,  116,  835,  836,  836,  116,  364,  843,
  364,  836,  845, 1457,  846,  847, 1460,  848,  836, 1477,
  867,  198,  868, 1419,  338,  338,  871,  872,  887,  364,
  364,  888,  874,  878,  907,  909,  116,  913,  924,  925,
  462,  115,  115,  198,  934,  935,  938,   43,  956,  364,
  200, 1534,  957,  950,  739,  958,  959,  364,  965,  983,
  364,  986,  893,  989,  987, 1002,  836, 1008, 1561,  199,
  199,  739, 1022, 1027, 1029, 1034, 1037,  380,   38, 1042,
 1045, 1573, 1575, 1043,  739,  739, 1048, 1046,  821,  338,
 1051, 1053, 1059, 1419, 1071, 1072,  116,  116, 1075, 1081,
  518, 1090,  540, 1104, 1097,  198, 1105,  198, 1561, 1561,
 1124,  739,  739,  117,  198,  338, 1134, 1583, 1148,  115,
  364, 1149, 1142,  198,  198, 1150,  198,  338, 1158, 1160,
 1161, 1171, 1442, 1172,  199,  338, 1177, 1174, 1178,  549,
 1180,  338, 1192, 1196, 1442, 1200,  117, 1199, 1201, 1442,
  821,  198, 1209, 1205,  198, 1202,  661, 1204, 1213, 1220,
  199, 1223, 1224, 1442, 1232, 1561, 1231, 1241,  739,  338,
  338,  829,  199, 1251,  116,  117, 1258, 1286, 1289,  119,
  199, 1270,  502,  502, 1295, 1442,  199,  821, 1291, 1294,
 1298, 1299, 1307, 1304, 1312,  338, 1314, 1328, 1320, 1321,
  338, 1329, 1635, 1635, 1372, 1374, 1373, 1381, 1431, 1644,
 1644, 1445,  640,  640,  199,  199, 1379, 1377, 1380, 1384,
 1391, 1396, 1449, 1462, 1655, 1471, 1463, 1472, 1480, 1474,
 1482, 1485, 1453, 1483,  338,  117, 1487, 1491, 1494,  661,
  199, 1493, 1414, 1489,  661,  199,  661,  661,  661,  661,
  661,  661,  661,  661,  661,  661,  661, 1500, 1501, 1507,
 1510, 1514,  338,  338, 1515, 1513, 1544,  119, 1525,  661,
 1517,  661, 1526,  661, 1556,  661,  661,  661, 1529,  199,
 1539, 1555, 1546, 1558, 1559, 1565, 1568, 1579, 1582, 1569,
 1580,  661, 1584, 1585, 1587, 1600, 1604, 1609, 1611, 1593,
 1608, 1619, 1603, 1602,  119, 1627, 1628,  199,  199,  119,
  353, 1647, 1649,  119,  357,  359,  361,  363,  365,  367,
  369,  371, 1653, 1654, 1658,    9, 1071,  199,  573,  950,
  661,  533,  951, 1063,  685,   38,  534,  117,  489,   38,
  199,  965,  119,  686,  532,   33,   33,  767,  857,  490,
   38,   34,  337,  364,  232,   38,  106,   34,  958,   38,
  858,  881,   38,  849,  850,  882,  916,  755,  918,  341,
  917,  920,  780,  732,   38,   38,  364,  732,  755,   38,
   38,  364,  364,  134,  116,   38,  311,   38,   38,   38,
   38,  141,  135,  117,  312,   38,  142,  235,   54,   38,
   21,   38,  119,  119,  364, 1125,  338, 1041, 1226,   24,
 1227,   38, 1422,   38,   38,  117,   38,  364,  364, 1385,
   38, 1423,  364, 1275, 1601,  364, 1570,  364, 1557,  364,
  364,  364,  364,  338, 1475, 1610, 1586,  364, 1552, 1068,
   38,  364,  117, 1064, 1069,  364, 1070,   38,   38,  953,
 1455,  199, 1389,  364, 1646, 1392,  364, 1476,  364,  364,
 1638, 1581, 1576,  364,  364, 1574,  364,  364,  364,  364,
  364,  364,  364,  364,  364,  364,  364,  364,  199, 1637,
  119, 1315,  364,  364, 1499, 1038,  565, 1316,  364,  364,
  364,  364,  364,  364,  364,  364,  364,  364,  672,  364,
  364, 1089,  886,  364,  364,  364,  364,  364, 1015, 1162,
  364,  364,  305,  477,  949,  364,  364,  364,  364,  364,
  364,  364,  364,  971,  353,   37,  584, 1100,  697,  701,
  699,  706, 1239,  703,  364,  705,  478,  364,  850,  364,
 1007,  364, 1301, 1397,  364, 1211,  433, 1203, 1154,  479,
  364, 1218,  338, 1173,  481, 1143, 1210,  581, 1281,  482,
 1212,  483,  484,  485,  486,  834, 1249,  353,  721,  487,
 1102,  722, 1395,  488, 1288, 1039, 1036, 1434,  338,    0,
    0,    0,    0,    0,    0,  489,    0,    0,  490,    0,
  491,    0,    0,  917,    0,    0,    0,  199,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  117,  492,  117,   36,    0,    0,    0,
    0, 1435,    0,  199,    0,    0,  659,  661,  663,    0,
    0,  581,  581,  581,  581,  581,  581,  581,  581,  581,
  581,  581,  581,  581,  581,  581,  581,    0,    0,    0,
    0,  338,    0,    0,    0,    0,    0,    0,    0,  117,
    0,    0,  117,    0,    0,    0,   24,  338,    0,    0,
   24, 1436,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   24,    0,    0,  338,    0,   24,    0,  338,    0,
   24,    0,    0,   24,    0,    0,  199, 1044,    0,    0,
    0,    0,    0,    0,    0,   24,   24,    0,    0,    0,
   24,   24,  199,    0,    0,    0,   24,    0,   24,   24,
   24,   24,    0,    0,    0,    0,   24,    0,    0,  199,
   24,    0,   24,  199,    0,    0,    0,  833,    0,    0,
    0,    0,   24,    0,    0,   24,    0,   24,    0,    0,
    0,   24,    0,    0,    0,    0,  581,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   24,    0,    0,  338,  338,    0,   21,   24,   24,
 1044,    0,   37,    0,    0, 1044,   37, 1044, 1044, 1044,
 1044, 1044, 1044, 1044, 1044, 1044, 1044,   37,    0,    0,
    0,  199,   37,    0,    0,    0,   37,    0,    0,   37,
 1044,    0, 1044,    0, 1044,    0, 1044, 1044, 1044,  199,
  199,   37,   37,    0,    0,    0,   37,   37,    0,    0,
    0,    0,   37,  870,   37,   37,   37,   37,    0,    0,
  338,    0,   37,    0,    0,    0,   37,    0,   37,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   37,    0,
   37,   37,    0,   37,    0,    0,    0,   37,    0,  338,
    0, 1044,    0,   36,    0,    0,    0,   36,    0,    0,
    0,  444,    0,  894,  895,  199,  541,   37,   36,  444,
    0,  444,  541,   36,    0,   37,  353,   36,    0,    0,
   36,    0,  117,    0,    0,    0,  199,    0,    0,    0,
  444,  444,   36,   36,  199,    0,    0,   36,   36,    0,
    0,    0,    0,   36,    0,   36,   36,   36,   36,    0,
  444,    0,    0,   36,    0,    0,    0,   36,  444,   36,
    0,  444,    0,    0,    0,    0,    0,  541,  664,   36,
    0,    0,   36,    0,   36,    0,    0,   24,   36,   25,
    0,    0,   26,    0,    0,    0,    0,   27,    0,    0,
    0,   28,    0,  545,    0,    0,    0,    0,   36,    0,
   30,    0,    0,    0,    0,   36,   36,   32,    0,    0,
  117,    0,   33,  833,    0,    0,   34,    0,  833,  833,
    0,    0,    0,    0,    0,    0,    0,    0,   36,    0,
   37,    0,    0,    0,   38,    0,    0,  353,    0,    0,
    0,  833,   39,   40,    0,    0,   41,  117,    0,   85,
    0,    0,  117,    0,  833,  833,  117,    0,    0,  833,
    0,    0,  833,    0,  833,    0,  833,  833,  833,  833,
    0,    0,    0,  338,  833,    0,    0,    0,  833,    0,
    0,    0,  833,    0,    0,  117,    0,    0,    0,    0,
  833,    0,    0,  833,    0,  833,  833,    0,    0,    0,
  833,  833,    0,  833,  833,  833,  833,  833,  833,  833,
  833,  833,  833,  833,    0,    0,    0,    0,  199,  833,
  833,    0,    0,    0,    0,  833,  833,  833,  833,  833,
  833,  380,  833,  833,  833,    0,  833,  833,  338,    0,
  833,  833,  833,  833,    0,  117,  117,  833,  833,    0,
    0,    0,  833,  833,  833,  833,  833,  833,  833,  833,
  338,    0,  952,   24,    0,   25,    0,    0,   26,    0,
 1332,  833,    0,   27,  833,    0,  833,   28,  833,    0,
    0,  833,    0,  199,    0,    0,   30,  833,    0,    0,
    0,    0,    0,   32,    0,    0,    0,    0,   33,    0,
 1333,    0,   34,    0,    0,  199,    0,    0,    0,    0,
    0,    0,    0,    0,   36,    0,   37,  581,    0,    0,
   38, 1334,  338,  117,  338,    0,    0,    0,   39,   40,
    0,  338,   41,    0,    0,   85,    0,    0,    0,    0,
  338,  338,    0,  338,    0,    0,    0,    0,    0,  545,
    0,    0,    0,    0,  545,  545,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  199,  338,  199,
    0,  338,    0,    0,    0,    0,  199,  545,    0,    0,
    0,    0,    0,    0,    0,  199,  199,    0,  199,    0,
  545,  545,    0,    0,    0,  545,    0,    0,  545,    0,
  545,    0,  545,  545,  545,  545,    0,    0,    0,    0,
  545,    0,    0,  199,  545,    0,  199,  380,  545,    0,
    0,    0,    0,    0,    0,    0,  545,    0,    0,  545,
  875,  545,  545,    0,    0,    0,  545,  545,    0,  545,
  545,  545,  545,  545,  545,  545,  545,  545,  545,  545,
    0,    0,    0,    0,    0,  545,  545,  545,    0,    0,
    0,  545,  545,    0,  545,  545,  545,  545,  545,  545,
  545,    0,  545,  545,    0,  545,  545,  545,  545,  545,
  545,  545,  545,  545,  545,    0,  545,  545,  545,  545,
  545,  545,  545,  545,  545,  545,  545,  545,  545,  545,
  545,  545,  545,  545,  545,  545,  545,  545,    0,    0,
  545,    0,  545,    0,  545,    0,    0,  545,  952,  952,
    0,    0,    0,  545,    0,    0,  952,  952,  952,  952,
  952,    0,  952,  952,    0,  952,  952,  952,  952,  952,
  952,  952,  952,    0,    0,    0,    0,  952,    0,  952,
  952,  952,  952,  952,  952,    0,    0,  952,    0,    0,
  354,  952,  952,    0,  952,  952,  952,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  952,    0,  952,    0,
  952,  952,    0,    0,  952,    0,  952,  952,  952,  952,
  952,  952,  952,  952,  952,  952,  952,  952,    0,  952,
    0,    0,  952,  952,    0,    0,  952,  952,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  952,  952,  952,  952,  952,    0,    0,    0,    0,
  952,  952,    0,    0,  952,    0,    0,    0,    0,  952,
  952,  952,  952,  952,    0,    0,    0,  952,    0,  952,
    0,    0,    0,    0,    0,  952,  952,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  952,  952,  952,  952,    0,  952,  875,  875,    0,    0,
    0,  394,  952,    0,  875,  875,  875,  875,  875,    0,
  875,  875,    0,  875,  875,  875,  875,  875,  875,  875,
    0,    0,    0,    0,    0,  875,    0,  875,  875,  875,
  875,  875,  875,    0,    0,  875,    0,    0,    0,  875,
  875,    0,  875,  875,  875,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  875,    0,  875,    0,  875,  875,
    0,    0,  875,    0,  875,  875,  875,  875,  875,  875,
  875,  875,  875,  875,  875,  875,    0,  875,    0,    0,
  875,  875,    0,    0,  875,  875,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  875,
  875,  875,  875,  875,    0,    0,  364,    0,  875,  875,
    0,    0,  875,    0,    0,    0,    0,  875,  875,  875,
  875,  875,    0,    0,    0,  875,  354,  875,    0,    0,
    0,  354,  354,  875,  875,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  354,    0,    0,    0,  875,  875,
  875,  875,    0,  875,    0,    0,    0,  354,  354,    0,
  875,    0,  354,    0,    0,  354,    0,  354,    0,  354,
  354,  354,  354,    0,    0,    0,    0,  354,    0,    0,
    0,  354,    0,    0,    0,  354,    0,    0,    0,    0,
    0,    0,    0,  354,    0,    0,  354,    0,  354,  354,
    0,  399,    0,  354,  354,    0,  354,  354,  354,  354,
  354,  354,  354,  354,  354,  354,  354,    0,    0,    0,
    0,    0,  354,  354,    0,    0,    0,    0,  354,  354,
  354,  354,  354,  354,    0,  354,  354,  354,    0,  354,
  354,    0,    0,  354,  354,  354,  354,  394,    0,    0,
  354,  354,  394,  394,    0,  354,  354,  354,  354,  354,
  354,  354,  354,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  354,  394,    0,  354,    0,  354,
    0,  354,    0,    0,  354,    0,    0,    0,  394,  394,
  354,    0,    0,  394,    0,    0,  394,    0,  394,    0,
  394,  394,  394,  394,    0,    0,    0,    0,  394,    0,
    0,    0,  394,    0,    0,    0,  394,    0,    0,    0,
    0,    0,    0,    0,  394,    0,    0,  394,    0,  394,
  394,    0,    0,    0,  394,  394,    0,  394,  394,  394,
  394,  394,  394,  394,  394,  394,  394,  394,    0,    0,
    0,    0,  364,  394,  394,    0,    0,    0,  364,  394,
  394,    0,  394,  394,  394,    0,  394,  394,  394,    0,
  394,  394,   31,    0,  394,  394,  394,  394,    0,    0,
    0,  394,  394,    0,    0,    0,  394,  394,  394,  394,
  394,  394,  394,  394,  364,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  394,    0,    0,  394,    0,
  394,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  394,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  364,    0,    0,    0,  364,
  364,    0,  364,  364,  364,  364,  364,  364,  364,  364,
  364,  364,  364,  364,    0,    0,    0,  399,    0,  364,
    0,    0,    0,  399,  364,  364,  364,  364,  364,  364,
  364,  364,  364,  364,    0,  364,  364,    0,    0,  364,
  364,  364,  364,  364,    0,    0,  364,  364,   25,    0,
    0,  364,  364,  364,  364,  364,  364,  364,  364,  399,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  364,    0,    0,  364,    0,  364,    0,  364,    0,    0,
  364,    0,    0,    0,    0,    0,  364,    0,    0,    0,
    0,   35,    0,    0,    0,    0,    0,    0,    0,    0,
  399,    0,    0,    0,  399,  399,    0,  399,  399,  399,
  399,  399,  399,  399,  399,  399,  399,  399,    0,    0,
    0,    0,    0,    0,  399,    0,    0,    0,    0,  399,
  399,  399,  399,  399,  399,    0,  399,  399,  399,    0,
  399,  399,    0,    0,  399,  399,  399,  399,    0,    0,
    0,  399,  399,    0,    0,    0,  399,  399,  399,  399,
  399,  399,  399,  399,    0,    0,    0,    0,    0,    0,
    0,    5,    0,    0,    0,  399,    0,    0,  399,    0,
  399,    0,  399,    0,    0,  399,    0,    0,   31,   31,
    0,  399,    0,   31,    0,    0,    0,   31,    0,   31,
    0,    0,   31,    0,   31,   31,    0,   31,    0,   31,
    0,   31,    0,   31,   31,   31,   31,    0, 1052,   31,
   31,    0,    0,    0,    0,   31,    0,   31,   31,   31,
    0,    0,   31,   31,   31,    0,   31,    0,    0,   31,
    0,   31,   31,   31,   31,    0,    0,    0,   31,   31,
   31,    0,    0,   31,   31,   31,    0,    0,    0,    0,
    0,    0,   31,   31,    0,   31,   31,    0,   31,   31,
   31,    0,    0,    0,   31,    0,    0,    0,    0,    0,
    0,   51,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   31,    0,    0,    0,    0,    0,
   31,   31,   31,    0,    0,   25,    0,    0,    0,   25,
   31,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   25,    0,    0,    0,    7,   25,    0,    0,    0,   25,
    0,    0,   25,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   25,   25,    0,    0,   35,   25,
   25,   31,   35,    0,    0,   25,    0,   25,   25,   25,
   25,    0,    0,   35,    0,   25,    0, 1053,   35,   25,
    0,   25,   35,    0,    0,   35,    0,    0,    0,    0,
    0,   25,    0,    0,   25,    0,   25,   35,   35,    0,
   25,    0,   35,   35,    0,    0,    0,    0,   35,    0,
   35,   35,   35,   35,    0,    0,    0,    0,   35,    0,
   25,    0,   35,    0,   35,    0,    0,   25,   25,    0,
    0,    0,    0,    0,   35,    0,    0,   35,    5,   35,
   52,    0,   51,   35,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   51,    0,    0,    0,    0,   51,    0,
    0,    0,   51,   35,    0,   51,    0,    0,    0,    0,
    0,   35,    0,    0,    0,    0,    0,   51,   51,    0,
    0,    0,   51,   51,    0, 1052,    0,    0,   51,   51,
   51,   51,   51,   51,    0,    0,    0,    0,   51,    0,
   51,    0,   51,    0,   51,   51,    0,    0,    0,   51,
    0,    0,   51,    0,   51,    0,    0,   51,    0,   51,
    0,    0,    0,   51,   51,   51,    0,    0,    0,   51,
   51,    0,    0,    0,    0,   51,    0,   51,   51,   51,
   51,    0,    0,   51,    0,   51,    0,    0,   51,   51,
    0,   51,   51,    0,    0,    0,    0,    0,    0,    0,
    0,   51,    0,   51,   51,    0,   51,    0,   51,    0,
   51,    0,   51,    0,    0,   51,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   51,   51,    0,
   51,    7,   51,   51,    0,   52,    0,    0,   51,    0,
   51,   51,   51,   51,    0,    0,   52,    0,   51,    0,
    0,   52,   51,    0,   51,   52,    0,    0,   52,    0,
    0,    0,    0,    0,   51,    0,    0,   51,    0,   51,
   52,   52,    0,   51, 1053,   52,   52,    0,   51,    0,
    0,   52,    0,   52,   52,   52,   52,    0,    0,   51,
    0,   52,    0,   51,   51,   52,    0,   52,   51,    0,
    0,   51,    0,    0,    0,    0,    0,   52,    0,    0,
   52,    0,   52,   51,   51,    0,   52,    0,   51,   51,
    0,    0,    0,    0,   51,    0,   51,   51,   51,   51,
    0,    0,    0,    0,   51,    0,   52,   52,   51,    0,
   51,   52,    0,    0,    0,    0,    0,    0,    0,    0,
   51,    0,   52,   51,    0,   51,    0,   52,    0,   51,
    0,   52,    0,    0,   52,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   52,   52,    0,   51,
    0,   52,   52,    0,    0,    0,    0,   52,    0,   52,
   52,   52,   52,    0,    0,    0,    0,   52,    0,    0,
    0,   52,    0,   52,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   52,    0,   56,   52,    0,   52,    0,
    0,    0,   52,   57,   24,   58,   25,    0,    0,   26,
   59,    0,   60,   61,   27,   62,   63,   64,   28,    0,
    0,    0,   52,    0,   65,    0,   66,   30,   67,   68,
   69,   70,    0,    0,   32,    0,    0,    0,   71,   33,
    0,   72,   73,   34,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   74,    0,   36,    0,   37,   75,    0,
    0,   38,    0,   76,   77,   78,   79,   80,   81,   39,
   40,   82,   83,   41,   84,    0,   85,    0,    0,   86,
   87,    0,    0,   88,   89,  836,    0,    0,    0,  477,
    0,  836,    0,    0,    0,    0,    0,    0,   90,   91,
   92,   93,   94,    0,    0,    0,    0,   95,    0,    0,
    0,   96,  478,    0,    0,    0,   97,   98,   99,  100,
  101,    0,    0,    0,  102,  479,  103,  836,    0,    0,
  481,    0,  104,  105,    0,  482,    0,  483,  484,  485,
  486,    0,    0,    0,    0,  487,    0,    0,    0,  488,
    0,    0,    0, 1434,    0,    0,    0,  106,  107,  108,
  109,  489,    0,    0,  490,    0,  491,    0,  836,  200,
    0,    0,    0,  836,  627,  836,  836,  836,  836,  836,
  836,  836,  836,  836,  836,  836,  836,    0,    0,    0,
  492,    0,  836,  836,    0,    0,    0,    0,  836,  836,
  836,  836,  836,  836,  836,  836,  836,    0,  836,  836,
    0,  836,  836,  836,  836,  836,  836,  836,  836,  836,
  836,    0,  836,  836,  836,  836,  836,  836,  836,  836,
  836,  836,  836,  836,  836,  836,  836,  836,  836,  836,
  836,  836,  836,  836,  836,    0,  836, 1436,  836,    0,
  836,  836,  836,  836,    0,    0,    0,  627,    0,  836,
    0,    0,  627,    0,  627,  627,  627,  627,  627,  627,
  627,  627,  627,  627,  627,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  627,  836,  627,
    0,  627,    0,  627,  627,  627,    0,    0,    0,    0,
    0,  627,  627,  627,  627,    0,    0,    0,  627,  627,
    0,    0,    0,  627,  627,  627,  627,  627,  627,  627,
  627,    0,    0,    0,    0,    0,    0,    0,    0,  836,
    0,    0,  627,    0,  836,    0,  836,  836,  836,  836,
  836,  836,  836,  836,  836,  836,  836,  836,  627,    0,
    0,    0,    0,  836,  836,    0,    0,    0,    0,  836,
  836,  836,  836,  836,  836,  836,  836,  836,    0,  836,
  836,    0,  836,  836,  836,  836,  836,  836,  836,  836,
  836,  836,    0,  836,  836,  836,  836,  836,  836,  836,
  836,  836,  836,  836,  836,  836,  836,  836,  836,  836,
  836,  836,  836,  836,  836,  836,  364,  991,    0,  836,
    0,  836,  364,    0,  836,    0,   24,    0,   25,    0,
  836,   26,    0,    0,    0,    0,   27,    0,    0,    0,
   28,    0,    0,    0,    0,    0,    0,    0,    0,   30,
    0,    0,    0,    0,    0,    0,   32,    0,  364,    0,
    0,   33,    0,    0,    0,   34,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   36,    0,   37,
    0,    0,    0,   38,    0,    0,    0,    0,    0,    0,
    0,   39,   40,    0,    0,   41,    0,    0,   85,  364,
    0,    0,    0,    0,  364,    0,  364,  364,  364,  364,
  364,  364,  364,  364,  364,  364,  364,  364,    0,    0,
    0,    0,    0,  364,  364,    0,    0,    0,    0,  364,
  364,  364,  364,  364,  364,  364,  364,  364,    0,  364,
  364,    0,  364,  364,  364,  364,  364,  364,  364,  364,
  364,  364,    0,  364,  364,  364,  364,  364,  364,  364,
  364,  364,  364,  364,  364,  364,  364,  364,  364,  364,
  364,  364,  364,  364,  364,    0,  547, 1135,    0,  364,
  380,  364,  547,    0,  364,    0,   24,    0,   25,    0,
  364,   26,    0,    0,    0,    0,   27,    0,    0,    0,
   28,    0,    0,    0,    0,    0,    0,    0,    0,   30,
    0,    0,    0,    0,    0,    0,   32,    0,  547,    0,
    0,   33,    0,    0,    0,   34,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   36,    0,   37,
    0,    0,    0,   38,    0,    0,    0,    0,    0,    0,
    0,   39,   40,    0,    0,   41,    0,    0,   85,  547,
    0,    0,    0,    0,  547,    0,  547,  547,  547,  547,
  547,  547,  547,  547,  547,  547,  547,    0,    0,    0,
    0,    0,    0,  547,  547,    0,    0,    0,  547,  547,
  547,  547,  547,  547,  547,  547,  547,  547,    0,  547,
  547,    0,  547,  547,  547,  547,  547,  547,  547,  547,
  547,  547,    0,  547,  547,  547,  547,  547,  547,  547,
  547,  547,  547,  547,  547,  547,  547,  547,  547,  547,
  547,  547,  547,  547,  547,    0,  543,    0,    0,  547,
  380,  547,  543,    0,    0,  477,    0,    0,    0,    0,
  547,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  478,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  543,    0,
    0,  479,    0,    0,    0,    0,  481,    0,    0,    0,
    0,  482,    0,  483,  484,  485,  486,    0,    0,    0,
    0,  487,    0,    0,    0,  488,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  489,    0,  543,
  490,    0,  491,    0,  543,    0,  543,  543,  543,  543,
  543,  543,  543,  543,  543,  543,  543,    0,    0,    0,
    0,    0,    0,  543,  543,    0,  492,    0,  543,  543,
    0,  543,  543,  543,  543,  543,  543,  543,    0,  543,
  543,    0,  543,  543,  543,  543,  543,  543,  543,  543,
  543,  543,    0,  543,  543,  543,  543,  543,  543,  543,
  543,  543,  543,  543,  543,  543,  543,  543,  543,  543,
  543,  543,  543,  543,  543,    0,  551,    0,    0,  543,
  386,  543,  551, 1453,  543,    0,    0,    0,    0,    0,
  543,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  386,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  386,    0,  551,    0,
    0,  386,    0,    0,  254,    0,  386,    0,  386,  386,
  386,  386,    0,    0,    0,    0,  386,    0,    0,    0,
  386,    0,    0,    0,  386,    0,    0,    0,    0,    0,
    0,    0,  386,    0,    0,  386,    0,  386,    0,  551,
    0,    0,    0,    0,  551,    0,  551,  551,  551,  551,
  551,  551,  551,  551,  551,  551,  551,    0,    0,    0,
    0,  386,    0,  551,  551,    0,    0,    0,  386,  551,
    0,  551,  551,  551,  551,  551,  551,  551,    0,  551,
  551,    0,  551,  551,  551,  551,  551,  551,  551,  551,
  551,  551,    0,  551,  551,  551,  551,  551,  551,  551,
  551,  551,  551,  551,  551,  551,  551,  551,  551,  551,
  551,  551,  551,  551,  551,    0,  364,    0,  386,  551,
  385,  551,  364,    0,  551,    0,    0,    0,    0,    0,
  551,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  385,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  385,    0,  364,    0,
    0,  385,    0,    0,  253,    0,  385,    0,  385,  385,
  385,  385,    0,    0,    0,    0,  385,    0,    0,    0,
  385,    0,    0,    0,  385,    0,    0,    0,    0,    0,
    0,    0,  385,    0,    0,  385,    0,  385,    0,  364,
    0,    0,    0,    0,  364,    0,  364,  364,  364,  364,
  364,  364,  364,  364,  364,  364,  364,    0,    0,    0,
    0,  385,    0,  364,  364,    0,    0,    0,  385,  364,
    0,  364,  364,  364,  364,  364,  364,  364,    0,  364,
  364,    0,  364,  364,  364,  364,  364,  364,  364,  364,
  364,  364,    0,  364,  364,  364,  364,  364,  364,  364,
  364,  364,  364,  364,  364,  364,  364,  364,  364,  364,
  364,  364,  364,  364,  364,    0,  471,    0,  385,  364,
    0,  364,  471,    0,  364,    0,  732,    0,  732,    0,
  364,  732,    0,  732,  732,    0,  732,    0,  732,    0,
  732,    0,  732,  732,  732,    0,    0,    0,  732,  732,
    0,    0,    0,    0,  732,    0,  732,  732,  471,    0,
    0,  732,    0,    0,    0,  732,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  732,    0,  732,
    0,    0,    0,  732,  732,    0,    0,    0,    0,    0,
    0,  732,  732,    0,    0,  732,    0,    0,  732,  471,
    0,    0,    0,  732,  471,    0,  471,  471,  471,  471,
  471,  471,  471,  471,  471,  471,  471,    0,    0,    0,
    0,    0,    0,  471,  471,    0,    0,    0,    0,  471,
    0,  471,  471,  471,  471,  471,  471,  471,    0,  471,
  471,    0,  471,  471,  471,  471,  471,  471,  471,  471,
  471,  471,    0,  471,  471,  471,  471,  471,  471,  471,
  471,  471,  471,  471,  471,  471,  471,  471,  471,  471,
  471,  471,  471,  471,  471,    0,  578,    0,    0,  471,
  732,  471,  578,    0,  471,    0,   24,    0,   25,    0,
  471,   26,    0,    0, 1399,    0,   27,    0,  757,    0,
   28,    0,  758, 1400, 1401,    0,    0,    0, 1402,   30,
    0,    0,    0,    0, 1403,    0,   32,    0,  578,    0,
    0,   33,    0,    0,    0,   34,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   36,    0,   37,
  364,    0,    0,   38,    0,    0,  364,    0,    0,    0,
  836,   39,   40,    0,    0,   41,    0,    0, 1404,  578,
    0,    0,    0, 1405,  578,    0,  578,  578,  578,  578,
  578,  578,  578,  578,  578,  578,  578,    0,    0,    0,
    0,    0,  364,  578,    0,    0,    0,    0,    0,  578,
    0,  578,    0,  578,    0,  578,  578,  578,  836,  578,
  578,    0,  578,  578,  578,  578,  578,  578,  578,  578,
  578,  578,    0,    0,    0,  578,  578,  578,  578,  578,
  578,  578,  578,  578,  578,  578,  578,  578,  578,  578,
  578,  578,  578,    0,  578,  663,    0,    0,    0,  578,
 1407,  364,    0,    0,    0,    0,    0,  364,  364,    0,
  578,    0,    0,  364,  364,  364,  364,  364,  364,  364,
  836,  364,    0,  364,  364,  205,  364,  364,  364,  364,
  364,  364,  364,  364,  364,  364,    0,  364,  364,  364,
  364,  364,  364,  364,  364,  364,  364,  364,  364,  364,
  364,  364,  364,  364,  364,  364,  364,  364,  364,    0,
  354,    0,    0,  364,    0,  364,  354,  206,  364,    0,
    0,    0,    0,    0,  364,    0,    0,    0,  663,    0,
    0,    0,    0,  663,    0,  663,  663,  663,  663,  663,
  663,  663,  663,  663,  663,  663,    0,    0,    0,    0,
    0,    0,  354,    0,    0,    0,    0,    0,  663,    0,
  663,    0,  663,    0,  663,  663,  663,    0,  207,  208,
  209,  210,    0,  211,  212,  213,  214,  215,  216,  217,
  218,    0,    0,  219,  220,  221,  222,  223,  224,  225,
  226,    0,    0,  354,    0,    0,    0,    0,  354,    0,
  354,  354,  354,  354,  354,  354,  354,  354,  354,  354,
  354,    0,    0,    0,    0,  620,    0,  354,  422,  663,
    0,  620,    0,  354,  354,  354,  422,  354,  422,  354,
  354,  354,    0,  354,  354,    0,    0,  354,  354,  354,
  354,    0,    0,    0,  354,  354,    0,  422,  422,  354,
  354,  354,  354,  354,  354,  354,  354,  620,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  422,  354,    0,
    0,    0,    0,  354,  422,  422,    0,    0,  422,    0,
  422,    0,    0,    0,  354,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  620,    0,
    0,    0,    0,  620,    0,  620,  620,  620,  620,  620,
  620,  620,  620,  620,  620,  620,  422,    0,    0,    0,
    0,    0,  620,  423,    0,    0,    0,    0,  620,    0,
  620,  423,  620,  423,  620,  620,  620,    0,  620,  620,
    0,    0,  620,  620,  620,  620,    0,    0,    0,  620,
  620,    0,  423,  423,  620,  620,  620,  620,  620,  620,
  620,  620,    0,  354,    0,    0,    0,    0,    0,  354,
    0,    0,  423,  620,    0,    0,    0,    0,  620,    0,
  423,  354,  422,  423,    0,    0,    0,  422,  354,  620,
  422,  422,  422,  422,    0,  422,    0,  422,  422,    0,
  422,  422,  422,  422,  422,  354,  422,  422,  422,  422,
    0,  422,  422,  422,  422,  422,  422,  422,  422,  422,
  422,  422,  422,  422,  422,  422,  422,  422,  422,  422,
  422,  422,  422,    0,    0,    0,    0,  354,    0,  422,
    0,    0,  422,    0,    0,    0,  354,    0,  422,    0,
    0,  354,    0,  354,  354,  354,  354,  354,  354,  354,
  354,  354,  354,  354,    0,    0,    0,    0,  600,    0,
  354,    0,    0,    0,  600,    0,  354,  354,  354,    0,
  354,    0,  354,  354,  354,    0,  354,  354,    0,    0,
  354,  354,  354,  354,    0,    0,    0,  354,  354,    0,
    0,    0,  354,  354,  354,  354,  354,  354,  354,  354,
  600,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  354,    0,    0,    0,    0,  354,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  354,    0,    0,
  618,    0,    0,    0,    0,    0,  618,    0,    0,    0,
    0,  600,    0,    0,    0,    0,  600,    0,  600,  600,
  600,  600,  600,  600,  600,  600,  600,  600,  600,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  600,  618,  600,    0,  600,    0,  600,  600,  600,
    0,  600,  600,    0,    0,  600,  600,  600,  600,  600,
  600,  600,  600,  600,    0,    0,    0,  600,  600,  600,
  600,  600,  600,  600,  600,    0,    0,    0,    0,    0,
    0,    0,    0,  618,    0,    0,  600,    0,  618,    0,
  618,  618,  618,  618,  618,  618,  618,  618,  618,  618,
  618,    0,  600,    0,    0,  607,    0,  618,    0,    0,
    0,  607,    0,  618,    0,  618,    0,  618,    0,  618,
  618,  618,    0,  618,  618,    0,    0,  618,  618,  618,
  618,    0,    0,    0,  618,  618,    0,    0,    0,  618,
  618,  618,  618,  618,  618,  618,  618,  607,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  618,    0,
    0,    0,    0,  618,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  618,    0,    0,  958,    0,    0,
    0,    0,    0,  958,    0,    0,    0,    0,  607,    0,
    0,    0,    0,  607,    0,  607,  607,  607,  607,  607,
  607,  607,  607,  607,  607,  607,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  607,  958,
  607,    0,  607,    0,  607,  607,  607,    0,  607,  607,
    0,    0,  607,  607,  607,  607,    0,    0,    0,  607,
  607,    0,    0,    0,  607,  607,  607,  607,  607,  607,
  607,  607,    0,    0,    0,    0,    0,    0,    0,    0,
  958,    0,    0,  607,    0,  958,    0,  958,  958,  958,
  958,  958,  958,  958,  958,  958,  958,  958,    0,  607,
    0,    0,  608,    0,    0,    0,    0,    0,  608,    0,
  958,    0,  958,    0,  958,    0,  958,  958,  958,    0,
  958,  958,    0,    0,  958,  958,  958,  958,    0,    0,
    0,  958,  958,    0,    0,    0,  958,  958,  958,  958,
  958,  958,  958,  958,  608,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  958,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  958,    0,    0,  609,    0,    0,    0,    0,    0,
  609,    0,    0,    0,    0,  608,    0,    0,    0,    0,
  608,    0,  608,  608,  608,  608,  608,  608,  608,  608,
  608,  608,  608,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  608,  609,  608,    0,  608,
    0,  608,  608,  608,    0,  608,  608,    0,    0,  608,
  608,  608,  608,    0,    0,    0,  608,  608,    0,    0,
    0,  608,  608,  608,  608,  608,  608,  608,  608,    0,
    0,    0,    0,    0,    0,    0,    0,  609,    0,    0,
  608,    0,  609,    0,  609,  609,  609,  609,  609,  609,
  609,  609,  609,  609,  609,    0,  608,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  609,    0,  609,
    0,  609,    0,  609,  609,  609,    0,  609,  609,    0,
    0,  609,  609,  609,  609,    0,    0,    0,  609,  609,
    0,    0,    0,  609,  609,  609,  609,  609,  609,  609,
  609,    0,  525,    0,  628,    0,    0,    0,    0,    0,
   57,   24,  609,   25,    0,    0,   26,  259,    0,    0,
    0,   27,   62,   63,    0,   28,    0,    0,  609,    0,
    0,   65,    0,    0,   30,    0,    0,    0,    0,    0,
    0,   32,    0,    0,    0,    0,   33,    0,   72,   73,
   34,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   36,    0,   37,   75,    0,    0,   38,    0,
    0,   77,    0,   79,    0,   81,   39,   40,  260,    0,
   41,    0,    0,    0,    0,    0,    0,  628,    0,  629,
    0,    0,  628,    0,  628,  628,  628,  628,  628,  628,
  628,  628,  628,  628,  628,   90,   91,   92,  261,  526,
    0,    0,    0,    0,    0,    0,    0,  628,   96,  628,
    0,  628,    0,  628,  628,  628,    0,    0,    0,    0,
    0,  628,  628,  628,  628,    0,    0,    0,  628,  628,
    0,    0,    0,  628,  628,  628,  628,  628,  628,  628,
  628,    0,    0,    0,    0,    0,    0,    0,  632,    0,
    0,    0,  628,    0,  106,  527,    0,    0,    0,    0,
    0,    0,  629,    0,    0,  528,  529,  629,  628,  629,
  629,  629,  629,  629,  629,  629,  629,  629,  629,  629,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  629,    0,  629,    0,  629,    0,  629,  629,
  629,    0,    0,    0,    0,    0,  629,  629,  629,  629,
    0,    0,    0,  629,  629,    0,    0,  633,  629,  629,
  629,  629,  629,  629,  629,  629,    0,    0,    0,    0,
    0,  632,    0,    0,    0,    0,  632,  629,  632,  632,
  632,  632,  632,  632,  632,  632,  632,  632,  632,    0,
    0,    0,    0,  629,    0,    0,    0,    0,    0,    0,
    0,  632,    0,  632,    0,  632,    0,  632,  632,  632,
    0,    0,    0,    0,    0,  632,  632,  632,  632,    0,
    0,    0,  632,  632,    0,    0,  634,    0,    0,  632,
  632,  632,  632,  632,  632,    0,    0,    0,    0,    0,
  633,    0,    0,    0,    0,  633,  632,  633,  633,  633,
  633,  633,  633,  633,  633,  633,  633,  633,    0,    0,
    0,    0,  632,    0,    0,    0,    0,    0,    0,    0,
  633,    0,  633,    0,  633,    0,  633,  633,  633,    0,
    0,    0,    0,    0,  633,  633,  633,  633,    0,    0,
    0,  633,  633,    0,    0,  635,    0,    0,  633,  633,
  633,  633,  633,  633,    0,    0,    0,    0,    0,  634,
    0,    0,    0,    0,  634,  633,  634,  634,  634,  634,
  634,  634,  634,  634,  634,  634,  634,    0,    0,    0,
    0,  633,    0,    0,    0,    0,    0,    0,    0,  634,
    0,  634,    0,  634,    0,  634,  634,  634,    0,    0,
    0,    0,    0,  634,  634,  634,  634,    0,    0,    0,
  634,  634,    0,    0,  636,    0,    0,  634,  634,  634,
  634,  634,  634,    0,    0,    0,    0,    0,  635,    0,
    0,    0,    0,  635,  634,  635,  635,  635,  635,  635,
  635,  635,  635,  635,  635,  635,    0,    0,    0,    0,
  634,    0,    0,    0,    0,    0,    0,    0,  635,    0,
  635,    0,  635,    0,  635,  635,  635,    0,    0,    0,
    0,    0,  635,  635,  635,  635,  364,    0,    0,  635,
  635,    0,  364,    0,    0,    0,  635,  635,  635,  635,
  635,  635,    0,    0,    0,    0,    0,  636,    0,    0,
    0,    0,  636,  635,  636,  636,  636,  636,  636,  636,
  636,  636,  636,  636,  636,    0,    0,    0,  364,  635,
    0,    0,    0,    0,    0,    0,    0,  636,    0,  636,
    0,  636,    0,  636,  636,  636,    0,    0,    0,    0,
    0,  636,  636,  636,  636,    0,    0,    0,  636,  636,
    0,    0,    0,    0,    0,  636,  636,  636,  636,  636,
  636,    0,    0,  641,    0,    0,    0,    0,    0,    0,
    0,    0,  636,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  364,    0,    0,    0,  636,  364,
    0,    0,  364,    0,  364,  364,    0,    0,    0,  364,
  364,    0,    0,  364,  364,  364,  364,  364,  364,  364,
  364,  364,    0,  364,  364,  364,  364,  364,  364,  364,
  364,  364,  364,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  642,  364,  364,    0,    0,    0,    0,    0,
    0,  364,    0,    0,  364,    0,  641,    0,    0,    0,
  364,  641,    0,  641,  641,  641,  641,  641,  641,  641,
  641,  641,  641,  641,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  641,    0,  641,    0,
  641,    0,  641,  641,  641,    0,    0,    0,    0,    0,
    0,    0,  641,  641,    0,    0,    0,  641,  641,    0,
    0,  643,    0,    0,    0,    0,  641,  641,  641,  641,
    0,    0,    0,    0,    0,  642,    0,    0,    0,    0,
  642,  641,  642,  642,  642,  642,  642,  642,  642,  642,
  642,  642,  642,    0,    0,    0,    0,  641,    0,    0,
    0,    0,    0,    0,    0,  642,    0,  642,    0,  642,
    0,  642,  642,  642,    0,    0,    0,    0,    0,    0,
    0,  642,  642,    0,    0,    0,  642,  642,    0,    0,
  646,    0,    0,    0,    0,  642,  642,  642,  642,    0,
    0,    0,    0,    0,  643,    0,    0,    0,    0,  643,
  642,  643,  643,  643,  643,  643,  643,  643,  643,  643,
  643,  643,    0,    0,    0,    0,  642,    0,    0,    0,
    0,    0,    0,    0,  643,    0,  643,    0,  643,    0,
  643,  643,  643,    0,    0,    0,    0,    0,    0,    0,
  643,  643,    0,    0,    0,  643,  643,    0,    0,  647,
    0,    0,    0,    0,  643,  643,  643,  643,    0,    0,
    0,    0,    0,  646,    0,    0,    0,    0,  646,  643,
  646,  646,  646,  646,  646,  646,  646,  646,  646,  646,
  646,    0,    0,    0,    0,  643,    0,    0,    0,    0,
    0,    0,    0,  646,    0,  646,    0,  646,    0,  646,
  646,  646,    0,    0,    0,    0,    0,    0,    0,  646,
  646,    0,    0,    0,  646,  646,    0,    0,  649,    0,
    0,    0,    0,    0,    0,  646,  646,    0,    0,    0,
    0,    0,  647,    0,    0,    0,    0,  647,  646,  647,
  647,  647,  647,  647,  647,  647,  647,  647,  647,  647,
    0,    0,    0,    0,  646,    0,    0,    0,    0,    0,
    0,    0,  647,    0,  647,    0,  647,    0,  647,  647,
  647,    0,    0,    0,    0,    0,    0,    0,  647,  647,
    0,    0,    0,  647,  647,    0,    0,  650,    0,    0,
    0,    0,    0,    0,  647,  647,    0,    0,    0,    0,
    0,  649,    0,    0,    0,    0,  649,  647,  649,  649,
  649,  649,  649,  649,  649,  649,  649,  649,  649,    0,
    0,    0,    0,  647,    0,    0,    0,    0,    0,    0,
    0,  649,    0,  649,    0,  649,    0,  649,  649,  649,
    0,    0,    0,    0,    0,    0,    0,    0,  649,    0,
    0,    0,  649,  649,    0,    0,  652,    0,    0,    0,
    0,    0,    0,  649,  649,    0,    0,    0,    0,    0,
  650,    0,    0,    0,    0,  650,  649,  650,  650,  650,
  650,  650,  650,  650,  650,  650,  650,  650,    0,    0,
    0,    0,  649,    0,    0,    0,    0,    0,    0,    0,
  650,    0,  650,    0,  650,    0,  650,  650,  650,    0,
    0,    0,    0,    0,    0,    0,    0,  650,    0,    0,
    0,  650,  650,    0,    0,  653,    0,    0,    0,    0,
    0,    0,  650,  650,    0,    0,    0,    0,    0,  652,
    0,    0,    0,    0,  652,  650,  652,  652,  652,  652,
  652,  652,  652,  652,  652,  652,  652,    0,    0,    0,
    0,  650,    0,    0,    0,    0,    0,    0,    0,  652,
    0,  652,    0,  652,    0,  652,  652,  652,    0,    0,
    0,    0,    0,    0,    0,    0,  652,    0,    0,    0,
    0,  652,    0,    0,  655,    0,    0,    0,    0,    0,
    0,  652,  652,    0,    0,    0,    0,    0,  653,    0,
    0,    0,    0,  653,  652,  653,  653,  653,  653,  653,
  653,  653,  653,  653,  653,  653,    0,    0,    0,    0,
  652,    0,    0,    0,    0,    0,    0,    0,  653,    0,
  653,    0,  653,    0,  653,  653,  653,    0,    0,    0,
    0,    0,    0,    0,    0,  653,    0,    0,    0,    0,
  653,    0,    0,  656,    0,    0,    0,    0,    0,    0,
  653,  653,    0,    0,    0,    0,    0,  655,    0,    0,
    0,    0,  655,  653,  655,  655,  655,  655,  655,  655,
  655,  655,  655,  655,  655,    0,    0,    0,    0,  653,
    0,    0,    0,    0,    0,    0,    0,  655,    0,  655,
    0,  655,    0,  655,  655,  655,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  655,
    0,    0,  658,    0,    0,    0,    0,    0,    0,  655,
  655,    0,    0,    0,    0,    0,  656,    0,    0,    0,
    0,  656,  655,  656,  656,  656,  656,  656,  656,  656,
  656,  656,  656,  656,    0,    0,    0,    0,  655,    0,
    0,    0,    0,    0,    0,    0,  656,    0,  656,    0,
  656,    0,  656,  656,  656,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  656,    0,
    0,  659,    0,    0,    0,    0,    0,    0,  656,  656,
    0,    0,    0,    0,    0,  658,    0,    0,    0,    0,
  658,  656,  658,  658,  658,  658,  658,  658,  658,  658,
  658,  658,  658,    0,    0,    0,    0,  656,    0,    0,
    0,    0,    0,    0,    0,  658,    0,  658,    0,  658,
    0,  658,  658,  658,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  658,    0,    0,
    0,  364,    0,    0,    0,  836,    0,    0,  658,    0,
    0,    0,    0,    0,  659,    0,    0,    0,    0,  659,
  658,  659,  659,  659,  659,  659,  659,  659,  659,  659,
  659,  659,    0,    0,    0,    0,  658,  364,    0,    0,
    0,    0,    0,    0,  659,    0,  659,    0,  659,    0,
  659,  659,  659,  836,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  659,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  659,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  659,
    0,    0,    0,    0,    0,    0,  364,    0,    0,    0,
    0,    0,  364,  364,    0,  659,    0,    0,  364,  364,
    0,  364,    0,  364,    0,  836,  364,    0,  364,  364,
    0,  364,  364,  364,  364,  364,  364,  364,  364,  364,
  364,    0,  364,  364,  364,  364,  364,  364,  364,  364,
  364,  364,  364,  364,  364,  364,  364,  364,  364,  364,
  364,  364,  364,  364,    0,    0,  591,    0,  364,    0,
  364,    0,    0,  364,   57,   24,   58,   25, 1164,  364,
   26,   59,    0,   60,   61,   27,   62,   63,   64,   28,
    0,    0,    0,    0,    0,   65,    0,   66,   30,   67,
   68,   69,   70,    0,    0,   32,    0,    0,    0,   71,
   33,    0,   72,   73,   34,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   74,    0,   36,    0,   37,   75,
    0,    0,   38,    0,   76,   77,   78,   79,   80,   81,
   39,   40,   82,   83,   41,   84,    0,   85,    0,    0,
   86,   87,    0,    0,   88,   89,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   90,
   91,   92,   93,   94,    0,    0,    0,    0,   95,    0,
    0,    0,   96,    0,    0,    0,    0,   97,   98,   99,
  100,  101,    0,    0,    0,  102,    0,  103,    0,    0,
    0,    0,    0,  104,  105,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   56,    0,  106,  592,
  108,  109,    0, 1165,   57,   24,   58,   25,    0,    0,
   26,   59,    0,   60,   61,   27,   62,   63,   64,   28,
    0,    0,    0,    0,    0,   65,    0,   66,   30,   67,
   68,   69,   70,    0,    0,   32,    0,    0,    0,   71,
   33,    0,   72,   73,   34,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   74,    0,   36,    0,   37,   75,
    0,    0,   38,    0,   76,   77,   78,   79,   80,   81,
   39,   40,   82,   83,   41,   84,    0,   85,    0,    0,
   86,   87,    0,    0,   88,   89,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   90,
   91,   92,   93,   94,    0,    0,    0,    0,   95,    0,
    0,    0,   96,    0,    0,    0,    0,   97,   98,   99,
  100,  101,    0,    0,    0,  102,    0,  103,    0,    0,
    0,    0,    0,  104,  105,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  272,    0,    0,    0,  106,  107,
  108,  109,   57,   24,   58,   25,    0,    0,   26,   59,
    0,   60,   61,   27,   62,   63,   64,   28,    0,    0,
    0,    0,    0,   65,    0,   66,   30,   67,   68,   69,
   70,    0,    0,   32,    0,    0,    0,   71,   33,    0,
   72,   73,   34,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   74,    0,   36,    0,   37,   75,    0,    0,
   38,    0,   76,   77,   78,   79,   80,   81,   39,   40,
   82,   83,   41,   84,    0,   85,    0,    0,   86,   87,
    0,    0,   88,   89,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   90,   91,   92,
   93,   94,    0,    0,    0,    0,   95,    0,    0,    0,
   96,    0,    0,    0,    0,   97,   98,   99,  100,  101,
    0,    0,    0,  102,    0,  103,    0,    0,    0,    0,
    0,  104,  105,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  591,    0,    0,    0,  106,  107,  108,  109,
   57,   24,   58,   25,    0,    0,   26,   59,    0,   60,
   61,   27,   62,   63,   64,   28,    0,    0,    0,    0,
    0,   65,    0,   66,   30,   67,   68,   69,   70,    0,
    0,   32,    0,    0,    0,   71,   33,    0,   72,   73,
   34,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   74,    0,   36,    0,   37,   75,    0,    0,   38,    0,
   76,   77,   78,   79,   80,   81,   39,   40,   82,   83,
   41,   84,    0,   85,    0,    0,   86,   87,    0,    0,
   88,   89,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   90,   91,   92,   93,   94,
    0,    0,    0,    0,   95,    0,    0,    0,   96,    0,
    0,    0,    0,   97,   98,   99,  100,  101,    0,    0,
    0,  102,    0,  103,    0,    0,    0,    0,    0,  104,
  105,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1049,    0,    0,    0,  106,  592,  108,  109, 1049, 1049,
 1049, 1049,    0,    0, 1049, 1049,    0, 1049, 1049, 1049,
 1049, 1049, 1049, 1049,    0,    0,    0,    0,    0, 1049,
    0, 1049, 1049, 1049, 1049, 1049, 1049,    0,    0, 1049,
    0,    0,    0, 1049, 1049,    0, 1049, 1049, 1049,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1049,    0,
 1049,    0, 1049, 1049,    0,    0, 1049,    0, 1049, 1049,
 1049, 1049, 1049, 1049, 1049, 1049, 1049, 1049, 1049, 1049,
    0, 1049,    0,    0, 1049, 1049,    0,    0, 1049, 1049,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1049, 1049, 1049, 1049, 1049,    0,    0,
    0,    0, 1049,    0,    0,    0, 1049,    0,    0,    0,
    0, 1049, 1049, 1049, 1049, 1049,    0,    0,    0, 1049,
    0, 1049,    0,    0,    0,    0,    0, 1049, 1049,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  635,    0,
    0,    0, 1049, 1049, 1049, 1049,   57,   24,    0,   25,
    0,    0,   26,  259,    0,    0,    0,   27,   62,   63,
    0,   28,    0,    0,  189,    0,  189,   65,    0,  189,
   30,    0,    0,    0,  189,    0,    0,   32,  189,    0,
    0,    0,   33,    0,   72,   73,   34,  189,  636,    0,
    0,    0,    0,    0,  189,  637,    0,    0,   36,  189,
   37,   75,    0,  189,   38,    0,    0,   77,    0,   79,
    0,   81,   39,   40,  260,  189,   41,  189,    0,    0,
    0,  189,    0,  638,    0,    0,   88,   89,    0,  189,
  189,    0,    0,  189,    0,    0,  189,    0,    0,    0,
    0,   90,   91,   92,   93,   94,    0,    0,    0,    0,
    0,    0,    0,    0,   96,    0,    0,  639,    0,    0,
   98,   99,  100,  101,    0,    0,    0,  102,    0,  103,
    0,    0, 1074,    0,    0,  104,  105,    0,    0,    0,
    0,    0,    0,   57,   24,    0,   25,    0,    0,   26,
  259,    0,    0,    0,   27,   62,   63,    0,   28,    0,
  106,  107,  108,  109,   65,    0,    0,   30,    0,    0,
    0,    0,    0,    0,   32,    0,    0,    0,  189,   33,
    0,   72,   73,   34,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   36,    0,   37,   75,    0,
    0,   38,    0,    0,   77,    0,   79,    0,   81,   39,
   40,  260,    0,   41,    0,    0,    0,    0,    0,    0,
   87,    0,    0,   88,   89,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   90,   91,
   92,   93,  801,    0,    0,    0,    0,  802, 1088,    0,
    0,   96,    0,    0,    0,    0,    0,   98,   99,  100,
  101,    0,    0,    0,  102,    0,  103,    0,    0,    0,
    0,    0,  104,  105,    0,    0,    0,    0,    0,    0,
   57,   24,    0,   25,    0,    0,   26,  259,    0,    0,
    0,   27,   62,   63,    0,   28,    0,  106,  803,  108,
  109,   65,    0,  804,   30,    0,    0,    0,  805,    0,
    0,   32,    0,    0,    0,    0,   33,    0,   72,   73,
   34,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   36,    0,   37,   75,    0,    0,   38,    0,
    0,   77,    0,   79,    0,   81,   39,   40,  260,    0,
   41,    0,    0,    0,    0,    0,    0,   87,    0,    0,
   88,   89,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   90,   91,   92,   93,  801,
    0,    0,    0,    0,  802,    0,    0,    0,   96,    0,
    0,    0,    0,    0,   98,   99,  100,  101,    0,    0,
    0,  102,    0,  103,    0,    0,    0,    0,    0,  104,
  105,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  819,  106,  803,  108,  109,    0,    0,
  804,   57,   24,    0,   25,  805,    0,   26,  259,    0,
    0,    0,   27,   62,   63,    0,   28,    0,    0,  189,
    0,  189,   65,    0,  189,   30,    0,    0,    0,  189,
    0,    0,   32,  189,    0,    0,    0,   33,    0,   72,
   73,   34,  189,    0,    0,    0,    0,    0,    0,  189,
    0,    0,    0,   36,  189,   37,   75,    0,  189,   38,
    0,    0,   77,    0,   79,    0,   81,   39,   40,  260,
  189,   41,  189,    0,    0,    0,  189,    0,   87,    0,
    0,   88,   89,    0,  189,  189,    0,    0,  189,    0,
    0,  189,    0,    0,    0,    0,   90,   91,   92,   93,
  308,    0,    0,    0,    0,  546,  820,    0,    0,   96,
    0,    0,    0,    0,    0,   98,   99,  100,  101,    0,
    0,    0,  102,    0,  103, 1074,    0,    0,    0,    0,
  104,  105,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1013,    0,    0,    0,  106,  309,  108,  109,   57,
   24,    0,   25,    0,    0,   26,  259,    0,    0,    0,
   27,   62,   63,  189,   28,    0,    0,   24,    0,   25,
   65,    0,   26,   30,    0,    0,    0,   27,    0,    0,
   32,   28,    0,    0,    0,   33,    0,   72,   73,   34,
   30,  636,    0,    0,    0,    0,    0,   32,  637,    0,
    0,   36,   33,   37,   75,    0,   34,   38,    0,    0,
   77,    0,   79,    0,   81,   39,   40,  260,   36,   41,
   37,    0,    0,    0,   38,    0,  638,    0,    0,   88,
   89,    0,   39,   40,    0,    0,   41,    0,    0,   85,
    0,    0,    0,    0,   90,   91,   92,   93,   94,    0,
    0,    0,    0,    0,    0,    0,    0,   96,    0,    0,
    0,    0,    0,   98,   99,  100,  101,    0,    0,    0,
  102,    0,  103,    0,    0,    0,    0,    0,  104,  105,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  819,
    0,    0,    0,  106,  107,  108,  109,   57,   24,    0,
   25,    0,    0,   26,  259,    0,    0,    0,   27,   62,
   63,  380,   28,    0,    0,   24,    0,   25,   65,    0,
   26,   30,    0,    0,    0,   27,    0,    0,   32,   28,
    0,    0,    0,   33,    0,   72,   73,   34,   30,    0,
    0,    0,    0,    0,    0,   32,    0,    0,    0,   36,
   33,   37,   75, 1019,   34,   38,    0,    0,   77,    0,
   79,    0,   81,   39,   40,  260,   36,   41,   37,    0,
    0,    0,   38,    0,   87,    0,    0,   88,   89,    0,
   39,   40,    0,    0,   41,    0,    0,  608,    0,    0,
    0,    0,   90,   91,   92,   93,  308,    0,    0,    0,
    0,  546,    0,    0,    0,   96,    0,    0,    0,    0,
    0,   98,   99,  100,  101,    0,    0,    0,  102,    0,
  103,    0,    0,    0,    0,    0,  104,  105,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  819,    0,    0,
    0,  106,  309,  108,  109,   57,   24,    0,   25,    0,
    0,   26,  259,    0,    0,    0,   27,   62,   63,  380,
   28,    0,    0,    0,    0,    0,   65,    0,    0,   30,
    0,    0,    0,    0,    0,    0,   32,    0,    0,    0,
    0,   33,    0,   72,   73,   34,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   36,    0,   37,
   75,    0,    0,   38,    0,    0,   77,    0,   79,    0,
   81,   39,   40,  260,    0,   41,    0,    0,    0,    0,
    0,    0,   87,    0,    0,   88,   89,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   90,   91,   92,   93,  308,    0,    0,    0,    0,  546,
    0,    0,    0,   96,    0,    0,    0,    0,    0,   98,
   99,  100,  101,    0,    0,    0,  102,    0,  103,    0,
    0,    0,    0,    0,  104,  105,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  347,    0,  106,
  309,  108,  109,  348,    0,   57,   24,    0,   25,    0,
    0,   26,  259,    0,    0,    0,   27,   62,   63,    0,
   28,    0,    0,    0,    0,    0,   65,    0,    0,   30,
    0,    0,    0,    0,    0,    0,   32,    0,    0,  349,
    0,   33,    0,   72,   73,   34,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   36,    0,   37,
   75,    0,    0,   38,    0,    0,   77,    0,   79,    0,
   81,   39,   40,  260,    0,   41,    0,    0,    0,    0,
    0,    0,    0,    0,  350,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   90,   91,   92,  261,  351,    0,    0,    0,    0,    0,
    0,    0,    0,   96,    0,  352,    0,    0,    0,   98,
   99,  100,  101,  972,    0,    0,  102,    0,  103,  811,
    0,    0,    0,    0,  104,  105,    0,   57,   24,    0,
   25,    0,    0,   26,  259,    0,    0,    0,   27,   62,
   63,    0,   28,    0,    0,    0,    0,    0,   65,  106,
  263,   30,  109,    0,    0,    0,    0,    0,   32,    0,
    0,    0,    0,   33,    0,   72,   73,   34,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   36,
    0,   37,   75,    0,    0,   38,    0,    0,   77,    0,
   79,    0,   81,   39,   40,  260,    0,   41,    0,    0,
    0,    0,    0,    0,   87,    0,    0,   88,   89,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   90,   91,   92,   93,  308,    0,    0,    0,
    0,    0,  973,    0,    0,   96,    0,    0,    0,    0,
    0,   98,   99,  100,  101,    0,    0,    0,  102,    0,
  103,    0,    0,    0,    0,    0,  104,  105,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1016,    0,    0,
    0,  106,  309,  108,  109,   57,   24,    0,   25,    0,
    0,   26,  259,    0,    0,    0,   27,   62,   63,    0,
   28,    0,    0,   24,    0,   25,   65,    0,   26,   30,
    0,    0,    0,   27,    0,    0,   32,   28,    0,    0,
    0,   33,    0,   72,   73,   34,   30,    0,    0,    0,
    0,    0,    0,   32,    0,    0,    0,   36,   33,   37,
   75,    0,   34,   38,    0,    0,   77,    0,   79,    0,
   81,   39,   40,  260,   36,   41,   37,    0,    0,    0,
   38,    0,   87,    0,    0,   88,   89,    0,   39,   40,
    0,    0,   41,    0,    0,  563,    0,    0,    0,    0,
   90,   91,   92,   93,  308,    0,    0,    0,    0,    0,
 1017,    0,    0,   96,    0,    0,    0,    0,    0,   98,
   99,  100,  101,    0,    0,    0,  102,    0,  103,    0,
    0,    0,    0,    0,  104,  105,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  307,    0,    0,    0,  106,
  309,  108,  109,   57,   24,    0,   25,    0,    0,   26,
  259,    0,    0,    0,   27,   62,   63,  380,   28,    0,
    0,  527,    0,  527,   65,    0,  527,   30,    0,    0,
    0,  527,    0,    0,   32,  527,    0,    0,    0,   33,
    0,   72,   73,   34,  527,    0,    0,    0,    0,    0,
    0,  527,    0,    0,    0,   36,  527,   37,   75,    0,
  527,   38,    0,    0,   77,    0,   79,    0,   81,   39,
   40,  260,  527,   41,  527,    0,    0,    0,  527,    0,
   87,    0,    0,   88,   89,    0,  527,  527,    0,    0,
  527,    0,    0,  527,    0,    0,    0,    0,   90,   91,
   92,   93,  308,    0,    0,    0,    0,    0,    0,    0,
    0,   96,    0,    0,    0,    0,    0,   98,   99,  100,
  101,    0,    0,    0,  102,    0,  103,    0,    0,    0,
    0,    0,  104,  105,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  316,    0,    0,    0,  106,  309,  108,
  109,   57,   24,    0,   25,    0,    0,   26,  259,    0,
    0,    0,   27,   62,   63,  527,   28,    0,    0,    0,
    0,    0,   65,    0,    0,   30,    0,    0,    0,    0,
    0,    0,   32,    0,    0,    0,    0,   33,    0,   72,
   73,   34,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   36,    0,   37,   75,    0,    0,   38,
    0,    0,   77,    0,   79,    0,   81,   39,   40,  260,
    0,   41,    0,    0,    0,    0,    0,    0,   87,    0,
    0,   88,   89,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   90,   91,   92,   93,
  308,    0,    0,    0,    0,    0,    0,    0,    0,   96,
    0,    0,    0,    0,    0,   98,   99,  100,  101,    0,
    0,    0,  102,    0,  103,    0,    0,    0,    0,    0,
  104,  105,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  347,    0,  106,  309,  108,  109,  348,
    0,   57,   24,    0,   25,    0,    0,   26,  259,    0,
    0,    0,   27,   62,   63,    0,   28,    0,    0,    0,
    0,    0,   65,    0,    0,   30,    0,    0,    0,    0,
    0,    0,   32,    0,    0,  349,    0,   33,    0,   72,
   73,   34,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   36,    0,   37,   75,    0,    0,   38,
    0,    0,   77,    0,   79,    0,   81,   39,   40,  260,
    0,   41,    0,    0,    0,    0,    0,    0,    0,    0,
  350,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   90,   91,   92,  261,
  351,    0,    0,    0,    0,    0,    0,    0,    0,   96,
    0,  352,    0,    0,    0,   98,   99,  100,  101,    0,
    0,    0,  102,    0,  103,  633,    0,    0,    0,    0,
  104,  105,    0,   57,   24,    0,   25,    0,    0,   26,
  259,    0,    0,    0,   27,   62,   63,    0,   28,    0,
    0,    0,    0,    0,   65,  106,  263,   30,  109,    0,
    0,    0,    0,    0,   32,    0,    0,    0,    0,   33,
    0,   72,   73,   34,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   36,    0,   37,   75,    0,
    0,   38,    0,    0,   77,    0,   79,    0,   81,   39,
   40,  260,    0,   41,    0,    0,    0,    0,    0,    0,
   87,    0,    0,   88,   89,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   90,   91,
   92,   93,   94,    0,    0,    0,    0,    0,    0,    0,
    0,   96,    0,    0,    0,    0,    0,   98,   99,  100,
  101,    0,    0,    0,  102,    0,  103,    0,    0,    0,
    0,    0,  104,  105,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  811,    0,    0,    0,  106,  107,  108,
  109,   57,   24,    0,   25,    0,    0,   26,  259,    0,
    0,    0,   27,   62,   63,    0,   28,    0,    0,  190,
    0,  190,   65,    0,  190,   30,    0,    0,    0,  190,
    0,    0,   32,  190,    0,    0,    0,   33,    0,   72,
   73,   34,  190,    0,    0,    0,    0,    0,    0,  190,
    0,    0,    0,   36,  190,   37,   75,    0,  190,   38,
    0,    0,   77,    0,   79,    0,   81,   39,   40,  260,
  190,   41,  190,    0,    0,    0,  190,    0,   87,    0,
    0,   88,   89,    0,  190,  190,    0,    0,  190,    0,
    0,  190,    0,    0,    0,    0,   90,   91,   92,   93,
  308,    0,    0,    0,    0,    0,    0,    0,    0,   96,
    0,    0,    0,    0,    0,   98,   99,  100,  101,    0,
    0,    0,  102,    0,  103,    0,    0,    0,    0,    0,
  104,  105,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1126,    0,    0,    0,  106,  309,  108,  109,   57,
   24,    0,   25,    0,    0,   26,  259,    0,    0,    0,
   27,   62,   63,  190,   28,    0,    0,  189,    0,  189,
   65,    0,  189,   30,    0,    0,    0,  189,    0,    0,
   32,  189,    0,    0,    0,   33,    0,   72,   73,   34,
  189,    0,    0,    0,    0,    0,    0,  189,    0,    0,
    0,   36,  189,   37,   75,    0,  189,   38,    0,    0,
   77,    0,   79,    0,   81,   39,   40,  260,  189,   41,
  189,    0,    0,    0,  189,    0,   87,    0,    0,   88,
   89,    0,  189,  189,    0,    0,  189,    0,    0,  189,
    0,    0,    0,    0,   90,   91,   92,   93,   94,    0,
    0,    0,    0,    0,    0,    0,    0,   96,    0,    0,
    0,    0,    0,   98,   99,  100,  101,    0,    0,    0,
  102,    0,  103,    0,    0,    0,    0,    0,  104,  105,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1278,
    0,    0,    0,  106, 1127,  108,  109,   57,   24,    0,
   25,    0,    0,   26,  259,    0,    0,    0,   27,   62,
   63,  189,   28,    0,    0,  199,    0,  199,   65,    0,
  199,   30,    0,    0,    0,  199,    0,    0,   32,  199,
    0,    0,    0,   33,    0,   72,   73,   34,  199,    0,
    0,    0,    0,    0,    0,  199,    0,    0,    0,   36,
  199,   37,   75,    0,  199,   38,    0,    0,   77,    0,
   79,    0,   81,   39,   40,  260,  199,   41,  199,    0,
    0,    0,  199,    0,   87,    0,    0,   88,   89,    0,
  199,  199,    0,    0,  199,    0,    0,  199,    0,    0,
    0,    0,   90,   91,   92,   93,  308,    0,    0,    0,
    0,    0,    0,    0,    0,   96,    0,    0,    0,    0,
    0,   98,   99,  100,  101,    0,    0,    0,  102,    0,
  103,    0,    0,    0,    0,    0,  104,  105,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   83,    0,    0,
    0,  106,  309,  108,  109,   83,   83,    0,   83,    0,
    0,   83,   83,    0,    0,    0,   83,   83,   83,  199,
   83,    0,    0,    0,    0,    0,   83,    0,    0,   83,
    0,    0,    0,    0,    0,    0,   83,    0,    0,    0,
    0,   83,    0,   83,   83,   83,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   83,    0,   83,
   83,    0,    0,   83,    0,    0,   83,    0,   83,    0,
   83,   83,   83,   83,    0,   83,    0,    0,    0,    0,
    0,    0,   83,    0,    0,   83,   83,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   83,   83,   83,   83,   83,    0,    0,    0,    0,    0,
    0,    0,    0,   83,    0,    0,    0,    0,    0,   83,
   83,   83,   83,    0,    0,    0,   83,    0,   83,    0,
    0,    0,    0,    0,   83,   83,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  347,    0,   83,
   83,   83,   83,  348,    0,   57,   24,    0,   25,    0,
    0,   26,  259,    0,    0,    0,   27,   62,   63,    0,
   28,    0,    0,    0,    0,    0,   65,    0,    0,   30,
    0,    0,    0,    0,    0,    0,   32,    0,    0,  349,
    0,   33,    0,   72,   73,   34,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   36,    0,   37,
   75,    0,    0,   38,    0,    0,   77,    0,   79,    0,
   81,   39,   40,  260,    0,   41,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   90,   91,   92,  261,  351,    0,    0,    0,    0,    0,
    0,    0,    0,   96,    0,  352,    0,    0,    0,   98,
   99,  100,  101,    0,    0,    0,  102,    0,  103,  347,
    0,    0,    0,    0,  104,  105,    0,   57,   24,    0,
   25,    0,    0,   26,  259,    0,    0,    0,   27,   62,
   63,    0,   28,    0,    0,    0,    0,    0,   65,  106,
  263,   30,  109,    0,    0,    0,    0,    0,   32,    0,
    0,    0,    0,   33,    0,   72,   73,   34,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   36,
    0,   37,   75,    0,    0,   38,    0,    0,   77,    0,
   79,    0,   81,   39,   40,  260,    0,   41,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   90,   91,   92,  261,  351,    0,    0,    0,
    0,    0,    0,    0,    0,   96,    0,  352,    0,    0,
    0,   98,   99,  100,  101,    0,    0,    0,  102,    0,
  103,  356,    0,    0,    0,    0,  104,  105,    0,   57,
   24,    0,   25,    0,    0,   26,  259,    0,    0,    0,
   27,   62,   63,    0,   28,    0,    0,    0,    0,    0,
   65,  106,  263,   30,  109,    0,    0,    0,    0,    0,
   32,    0,    0,    0,    0,   33,    0,   72,   73,   34,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   36,    0,   37,   75,    0,    0,   38,    0,    0,
   77,    0,   79,    0,   81,   39,   40,  260,    0,   41,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   90,   91,   92,  261,  351,    0,
    0,    0,    0,    0,    0,    0,    0,   96,    0,    0,
    0,    0,    0,   98,   99,  100,  101,    0,    0,    0,
  102,    0,  103,  358,    0,    0,    0,    0,  104,  105,
    0,   57,   24,    0,   25,    0,    0,   26,  259,    0,
    0,    0,   27,   62,   63,    0,   28,    0,    0,    0,
    0,    0,   65,  106,  263,   30,  109,    0,    0,    0,
    0,    0,   32,    0,    0,    0,    0,   33,    0,   72,
   73,   34,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   36,    0,   37,   75,    0,    0,   38,
    0,    0,   77,    0,   79,    0,   81,   39,   40,  260,
    0,   41,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   90,   91,   92,  261,
  351,    0,    0,    0,    0,    0,    0,    0,    0,   96,
    0,    0,    0,    0,    0,   98,   99,  100,  101,    0,
    0,    0,  102,    0,  103,  360,    0,    0,    0,    0,
  104,  105,    0,   57,   24,    0,   25,    0,    0,   26,
  259,    0,    0,    0,   27,   62,   63,    0,   28,    0,
    0,    0,    0,    0,   65,  106,  263,   30,  109,    0,
    0,    0,    0,    0,   32,    0,    0,    0,    0,   33,
    0,   72,   73,   34,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   36,    0,   37,   75,    0,
    0,   38,    0,    0,   77,    0,   79,    0,   81,   39,
   40,  260,    0,   41,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   90,   91,
   92,  261,  351,    0,    0,    0,    0,    0,    0,    0,
    0,   96,    0,    0,    0,    0,    0,   98,   99,  100,
  101,    0,    0,    0,  102,    0,  103,  362,    0,    0,
    0,    0,  104,  105,    0,   57,   24,    0,   25,    0,
    0,   26,  259,    0,    0,    0,   27,   62,   63,    0,
   28,    0,    0,    0,    0,    0,   65,  106,  263,   30,
  109,    0,    0,    0,    0,    0,   32,    0,    0,    0,
    0,   33,    0,   72,   73,   34,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   36,    0,   37,
   75,    0,    0,   38,    0,    0,   77,    0,   79,    0,
   81,   39,   40,  260,    0,   41,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   90,   91,   92,  261,  351,    0,    0,    0,    0,    0,
    0,    0,    0,   96,    0,    0,    0,    0,    0,   98,
   99,  100,  101,    0,    0,    0,  102,    0,  103,  364,
    0,    0,    0,    0,  104,  105,    0,   57,   24,    0,
   25,    0,    0,   26,  259,    0,    0,    0,   27,   62,
   63,    0,   28,    0,    0,    0,    0,    0,   65,  106,
  263,   30,  109,    0,    0,    0,    0,    0,   32,    0,
    0,    0,    0,   33,    0,   72,   73,   34,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   36,
    0,   37,   75,    0,    0,   38,    0,    0,   77,    0,
   79,    0,   81,   39,   40,  260,    0,   41,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   90,   91,   92,  261,  351,    0,    0,    0,
    0,    0,    0,    0,    0,   96,    0,    0,    0,    0,
    0,   98,   99,  100,  101,    0,    0,    0,  102,    0,
  103,  366,    0,    0,    0,    0,  104,  105,    0,   57,
   24,    0,   25,    0,    0,   26,  259,    0,    0,    0,
   27,   62,   63,    0,   28,    0,    0,    0,    0,    0,
   65,  106,  263,   30,  109,    0,    0,    0,    0,    0,
   32,    0,    0,    0,    0,   33,    0,   72,   73,   34,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   36,    0,   37,   75,    0,    0,   38,    0,    0,
   77,    0,   79,    0,   81,   39,   40,  260,    0,   41,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   90,   91,   92,  261,  351,    0,
    0,    0,    0,    0,    0,    0,    0,   96,    0,    0,
    0,    0,    0,   98,   99,  100,  101,    0,    0,    0,
  102,    0,  103,  368,    0,    0,    0,    0,  104,  105,
    0,   57,   24,    0,   25,    0,    0,   26,  259,    0,
    0,    0,   27,   62,   63,    0,   28,    0,    0,    0,
    0,    0,   65,  106,  263,   30,  109,    0,    0,    0,
    0,    0,   32,    0,    0,    0,    0,   33,    0,   72,
   73,   34,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   36,    0,   37,   75,    0,    0,   38,
    0,    0,   77,    0,   79,    0,   81,   39,   40,  260,
    0,   41,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   90,   91,   92,  261,
  351,    0,    0,    0,    0,    0,    0,    0,    0,   96,
    0,    0,    0,    0,    0,   98,   99,  100,  101,    0,
    0,    0,  102,    0,  103,  370,    0,    0,    0,    0,
  104,  105,    0,   57,   24,    0,   25,    0,    0,   26,
  259,    0,    0,    0,   27,   62,   63,    0,   28,    0,
    0,    0,    0,    0,   65,  106,  263,   30,  109,    0,
    0,    0,    0,    0,   32,    0,    0,    0,    0,   33,
    0,   72,   73,   34,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   36,    0,   37,   75,    0,
    0,   38,    0,    0,   77,    0,   79,    0,   81,   39,
   40,  260,    0,   41,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   90,   91,
   92,  261,  351,    0,    0,    0,    0,    0,    0,    0,
    0,   96,    0,    0,    0,    0,    0,   98,   99,  100,
  101,    0,    0,    0,  102,    0,  103,  658,    0,    0,
    0,    0,  104,  105,    0,   57,   24,    0,   25,    0,
    0,   26,  259,    0,    0,    0,   27,   62,   63,    0,
   28,    0,    0,    0,    0,    0,   65,  106,  263,   30,
  109,    0,    0,    0,    0,    0,   32,    0,    0,    0,
    0,   33,    0,   72,   73,   34,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   36,    0,   37,
   75,    0,    0,   38,    0,    0,   77,    0,   79,    0,
   81,   39,   40,  260,    0,   41,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   90,   91,   92,  261,  351,    0,    0,    0,    0,    0,
    0,    0,    0,   96,    0,    0,    0,    0,    0,   98,
   99,  100,  101,    0,    0,    0,  102,    0,  103,  660,
    0,    0,    0,    0,  104,  105,    0,   57,   24,    0,
   25,    0,    0,   26,  259,    0,    0,    0,   27,   62,
   63,    0,   28,    0,    0,    0,    0,    0,   65,  106,
  263,   30,  109,    0,    0,    0,    0,    0,   32,    0,
    0,    0,    0,   33,    0,   72,   73,   34,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   36,
    0,   37,   75,    0,    0,   38,    0,    0,   77,    0,
   79,    0,   81,   39,   40,  260,    0,   41,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   90,   91,   92,  261,  351,    0,    0,    0,
    0,    0,    0,    0,    0,   96,    0,    0,    0,    0,
    0,   98,   99,  100,  101,    0,    0,    0,  102,    0,
  103,  662,    0,    0,    0,    0,  104,  105,    0,   57,
   24,    0,   25,    0,    0,   26,  259,    0,    0,    0,
   27,   62,   63,    0,   28,    0,    0,    0,    0,    0,
   65,  106,  263,   30,  109,    0,    0,    0,    0,    0,
   32,    0,    0,    0,    0,   33,    0,   72,   73,   34,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   36,    0,   37,   75,    0,    0,   38,    0,    0,
   77,    0,   79,    0,   81,   39,   40,  260,    0,   41,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   90,   91,   92,  261,  351,    0,
    0,    0,    0,    0,    0,    0,    0,   96,    0,    0,
    0,    0,    0,   98,   99,  100,  101,    0,    0,    0,
  102,    0,  103,  675,    0,    0,    0,    0,  104,  105,
    0,   57,   24,    0,   25,    0,    0,   26,  259,    0,
    0,    0,   27,   62,   63,    0,   28,    0,    0,    0,
    0,    0,   65,  106,  263,   30,  109,    0,    0,    0,
    0,    0,   32,    0,    0,    0,    0,   33,    0,   72,
   73,   34,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   36,    0,   37,   75,    0,    0,   38,
    0,    0,   77,    0,   79,    0,   81,   39,   40,  260,
    0,   41,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   90,   91,   92,  261,
  351,    0,    0,    0,    0,    0,    0,    0,    0,   96,
    0,    0,    0,    0,    0,   98,   99,  100,  101,    0,
    0,    0,  102,    0,  103,  677,    0,    0,    0,    0,
  104,  105,    0,   57,   24,    0,   25,    0,    0,   26,
  259,    0,    0,    0,   27,   62,   63,    0,   28,    0,
    0,    0,    0,    0,   65,  106,  263,   30,  109,    0,
    0,    0,    0,    0,   32,    0,    0,    0,    0,   33,
    0,   72,   73,   34,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   36,    0,   37,   75,    0,
    0,   38,    0,    0,   77,    0,   79,    0,   81,   39,
   40,  260,    0,   41,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   90,   91,
   92,  261,  351,    0,    0,    0,    0,    0,    0,    0,
    0,   96,    0,    0,    0,    0,    0,   98,   99,  100,
  101,    0,    0,    0,  102,    0,  103,  679,    0,    0,
    0,    0,  104,  105,    0,   57,   24,    0,   25,    0,
    0,   26,  259,    0,    0,    0,   27,   62,   63,    0,
   28,    0,    0,    0,    0,    0,   65,  106,  263,   30,
  109,    0,    0,    0,    0,    0,   32,    0,    0,    0,
    0,   33,    0,   72,   73,   34,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   36,    0,   37,
   75,    0,    0,   38,    0,    0,   77,    0,   79,    0,
   81,   39,   40,  260,    0,   41,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   90,   91,   92,  261,  680,    0,    0,    0,    0,    0,
    0,    0,    0,   96,    0,    0,    0,    0,    0,   98,
   99,  100,  101,    0,    0,    0,  102,    0,  103,  682,
    0,    0,    0,    0,  104,  105,    0,   57,   24,    0,
   25,    0,    0,   26,  259,    0,    0,    0,   27,   62,
   63,    0,   28,    0,    0,    0,    0,    0,   65,  106,
  263,   30,  109,    0,    0,    0,    0,    0,   32,    0,
    0,    0,    0,   33,    0,   72,   73,   34,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   36,
    0,   37,   75,    0,    0,   38,    0,    0,   77,    0,
   79,    0,   81,   39,   40,  260,    0,   41,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   90,   91,   92,  261,  680,    0,    0,    0,
    0,    0,    0,    0,    0,   96,    0,    0,    0,    0,
    0,   98,   99,  100,  101,    0,    0,    0,  102,    0,
  103,  684,    0,    0,    0,    0,  104,  105,    0,   57,
   24,    0,   25,    0,    0,   26,  259,    0,    0,    0,
   27,   62,   63,    0,   28,    0,    0,    0,    0,    0,
   65,  106,  263,   30,  109,    0,    0,    0,    0,    0,
   32,    0,    0,    0,    0,   33,    0,   72,   73,   34,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   36,    0,   37,   75,    0,    0,   38,    0,    0,
   77,    0,   79,    0,   81,   39,   40,  260,    0,   41,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   90,   91,   92,  261,  680,    0,
    0,    0,    0,    0,    0,    0,    0,   96,    0,    0,
    0,    0,    0,   98,   99,  100,  101,    0,    0,    0,
  102,    0,  103,  686,    0,    0,    0,    0,  104,  105,
    0,   57,   24,    0,   25,    0,    0,   26,  259,    0,
    0,    0,   27,   62,   63,    0,   28,    0,    0,    0,
    0,    0,   65,  106,  263,   30,  109,    0,    0,    0,
    0,    0,   32,    0,    0,    0,    0,   33,    0,   72,
   73,   34,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   36,    0,   37,   75,    0,    0,   38,
    0,    0,   77,    0,   79,    0,   81,   39,   40,  260,
    0,   41,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   90,   91,   92,  261,
  680,    0,    0,    0,    0,    0,    0,    0,    0,   96,
    0,    0,    0,    0,    0,   98,   99,  100,  101,    0,
    0,    0,  102,    0,  103,  688,    0,    0,    0,    0,
  104,  105,    0,   57,   24,    0,   25,    0,    0,   26,
  259,    0,    0,    0,   27,   62,   63,    0,   28,    0,
    0,    0,    0,    0,   65,  106,  263,   30,  109,    0,
    0,    0,    0,    0,   32,    0,    0,    0,    0,   33,
    0,   72,   73,   34,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   36,    0,   37,   75,    0,
    0,   38,    0,    0,   77,    0,   79,    0,   81,   39,
   40,  260,    0,   41,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   90,   91,
   92,  261,  680,    0,    0,    0,    0,    0,    0,    0,
    0,   96,    0,    0,    0,    0,    0,   98,   99,  100,
  101,    0,    0,    0,  102,    0,  103,  690,    0,    0,
    0,    0,  104,  105,    0,   57,   24,    0,   25,    0,
    0,   26,  259,    0,    0,    0,   27,   62,   63,    0,
   28,    0,    0,    0,    0,    0,   65,  106,  263,   30,
  109,    0,    0,    0,    0,    0,   32,    0,    0,    0,
    0,   33,    0,   72,   73,   34,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   36,    0,   37,
   75,    0,    0,   38,    0,    0,   77,    0,   79,    0,
   81,   39,   40,  260,    0,   41,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   90,   91,   92,  261,  680,    0,    0,    0,    0,    0,
    0,    0,    0,   96,    0,    0,    0,    0,    0,   98,
   99,  100,  101,    0,    0,    0,  102,    0,  103,  692,
    0,    0,    0,    0,  104,  105,    0,   57,   24,    0,
   25,    0,    0,   26,  259,    0,    0,    0,   27,   62,
   63,    0,   28,    0,    0,    0,    0,    0,   65,  106,
  263,   30,  109,    0,    0,    0,    0,    0,   32,    0,
    0,    0,    0,   33,    0,   72,   73,   34,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   36,
    0,   37,   75,    0,    0,   38,    0,    0,   77,    0,
   79,    0,   81,   39,   40,  260,    0,   41,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   90,   91,   92,  261,  680,    0,    0,    0,
    0,    0,    0,    0,    0,   96,    0,    0,    0,    0,
    0,   98,   99,  100,  101,    0,    0,    0,  102,    0,
  103,  694,    0,    0,    0,    0,  104,  105,    0,   57,
   24,    0,   25,    0,    0,   26,  259,    0,    0,    0,
   27,   62,   63,    0,   28,    0,    0,    0,    0,    0,
   65,  106,  263,   30,  109,    0,    0,    0,    0,    0,
   32,    0,    0,    0,    0,   33,    0,   72,   73,   34,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   36,    0,   37,   75,    0,    0,   38,    0,    0,
   77,    0,   79,    0,   81,   39,   40,  260,    0,   41,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   90,   91,   92,  261,  680,    0,
    0,    0,    0,    0,    0,    0,    0,   96,    0,    0,
    0,    0,    0,   98,   99,  100,  101,    0,    0,    0,
  102,    0,  103,  696,    0,    0,    0,    0,  104,  105,
    0,   57,   24,    0,   25,    0,    0,   26,  259,    0,
    0,    0,   27,   62,   63,    0,   28,    0,    0,    0,
    0,    0,   65,  106,  263,   30,  109,    0,    0,    0,
    0,    0,   32,    0,    0,    0,    0,   33,    0,   72,
   73,   34,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   36,    0,   37,   75,    0,    0,   38,
    0,    0,   77,    0,   79,    0,   81,   39,   40,  260,
    0,   41,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   90,   91,   92,  261,
  680,    0,    0,    0,    0,    0,    0,    0,    0,   96,
    0,    0,    0,    0,    0,   98,   99,  100,  101,    0,
    0,    0,  102,    0,  103,  698,    0,    0,    0,    0,
  104,  105,    0,   57,   24,    0,   25,    0,    0,   26,
  259,    0,    0,    0,   27,   62,   63,    0,   28,    0,
    0,    0,    0,    0,   65,  106,  263,   30,  109,    0,
    0,    0,    0,    0,   32,    0,    0,    0,    0,   33,
    0,   72,   73,   34,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   36,    0,   37,   75,    0,
    0,   38,    0,    0,   77,    0,   79,    0,   81,   39,
   40,  260,    0,   41,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   90,   91,
   92,  261,  680,    0,    0,    0,    0,    0,    0,    0,
    0,   96,    0,    0,    0,    0,    0,   98,   99,  100,
  101,    0,    0,    0,  102,    0,  103,  700,    0,    0,
    0,    0,  104,  105,    0,   57,   24,    0,   25,    0,
    0,   26,  259,    0,    0,    0,   27,   62,   63,    0,
   28,    0,    0,    0,    0,    0,   65,  106,  263,   30,
  109,    0,    0,    0,    0,    0,   32,    0,    0,    0,
    0,   33,    0,   72,   73,   34,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   36,    0,   37,
   75,    0,    0,   38,    0,    0,   77,    0,   79,    0,
   81,   39,   40,  260,    0,   41,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   90,   91,   92,  261,  680,    0,    0,    0,    0,    0,
    0,    0,    0,   96,    0,    0,    0,    0,    0,   98,
   99,  100,  101,    0,    0,    0,  102,    0,  103,  702,
    0,    0,    0,    0,  104,  105,    0,   57,   24,    0,
   25,    0,    0,   26,  259,    0,    0,    0,   27,   62,
   63,    0,   28,    0,    0,    0,    0,    0,   65,  106,
  263,   30,  109,    0,    0,    0,    0,    0,   32,    0,
    0,    0,    0,   33,    0,   72,   73,   34,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   36,
    0,   37,   75,    0,    0,   38,    0,    0,   77,    0,
   79,    0,   81,   39,   40,  260,    0,   41,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   90,   91,   92,  261,  680,    0,    0,    0,
    0,    0,    0,    0,    0,   96,    0,    0,    0,    0,
    0,   98,   99,  100,  101,    0,    0,    0,  102,    0,
  103,  704,    0,    0,    0,    0,  104,  105,    0,   57,
   24,    0,   25,    0,    0,   26,  259,    0,    0,    0,
   27,   62,   63,    0,   28,    0,    0,    0,    0,    0,
   65,  106,  263,   30,  109,    0,    0,    0,    0,    0,
   32,    0,    0,    0,    0,   33,    0,   72,   73,   34,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   36,    0,   37,   75,    0,    0,   38,    0,    0,
   77,    0,   79,    0,   81,   39,   40,  260,    0,   41,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   90,   91,   92,  261,  680,    0,
    0,    0,    0,    0,    0,    0,    0,   96,    0,    0,
    0,    0,    0,   98,   99,  100,  101,    0,    0,    0,
  102,    0,  103,  869,    0,    0,    0,    0,  104,  105,
    0,   57,   24,    0,   25,    0,    0,   26,  259,    0,
    0,    0,   27,   62,   63,    0,   28,    0,    0,    0,
    0,    0,   65,  106,  263,   30,  109,    0,    0,    0,
    0,    0,   32,    0,    0,    0,    0,   33,    0,   72,
   73,   34,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   36,    0,   37,   75,    0,    0,   38,
    0,    0,   77,    0,   79,    0,   81,   39,   40,  260,
    0,   41,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   90,   91,   92,  261,
  351,    0,    0,    0,    0,    0,    0,    0,    0,   96,
    0,    0,    0,    0,    0,   98,   99,  100,  101,    0,
    0,    0,  102,    0,  103,    0,    0,    0,    0,    0,
  104,  105,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  210,    0,    0,    0,    0,  210,    0,
    0,    0,  210,    0,  210,  106,  263,  210,  109,  210,
  210,    0,  210,    0,  210,    0,  210,    0,  210,  210,
  210,  210,    0,    0,  210,  210,    0,    0,    0,    0,
  210,    0,  210,  210,  210,    0,    0,  210,    0,  210,
    0,  210,    0,    0,  210,    0,  210,  210,  210,  210,
    0,    0,    0,  210,  210,  210,    0,    0,  210,  210,
  210,    0,    0,    0,    0,    0,    0,  210,  210,    0,
  210,  210,  666,  210,  210,  210,    0,    0,    0,  210,
   57,   24,    0,   25,    0,    0,   26,  259,    0,    0,
    0,   27,   62,   63,    0,   28,    0,    0,    0,  210,
    0,   65,    0,    0,   30,  210,  210,  210,    0,    0,
    0,   32,    0,    0,    0,  210,   33,    0,   72,   73,
   34,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   36,    0,   37,   75,    0,    0,   38,    0,
    0,   77,    0,   79,    0,   81,   39,   40,  260,    0,
   41,    0,    0,   85,    0,    0,  210,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   90,   91,   92,  261,  262,
    0,    0,    0,  525,    0,    0,    0,    0,   96,    0,
  364,   57,   24,    0,   25,  667,  668,   26,  259,    0,
    0,    0,   27,   62,   63,    0,   28,    0,    0,    0,
    0,    0,   65,    0,    0,   30,    0,    0,    0,   51,
    0,   51,   32,    0,    0,    0,  364,   33,    0,   72,
   73,   34,    0,    0,  106,  263,    0,    0,    0,    0,
    0,    0,   51,   36,    0,   37,   75,    0,    0,   38,
    0,    0,   77,    0,   79,   51,   81,   39,   40,  260,
   51,   41,    0,    0,    0,   51,    0,   51,   51,   51,
   51,    0,    0,   51,    0,   51,    0,    0,    0,   51,
    0,    0,    0,    0,    0,    0,   90,   91,   92,  261,
  526,   51,  364,    0,   51,    0,   51,    0,    0,   96,
  364,  364,  364,  364,  836,    0,    0,  364,  364,    0,
    0,  364,  364,  364,  364,  364,  364,  364,  364,  364,
   51,  364,  364,  364,  364,  364,  364,  364,  364,  364,
  364,  364,  364,  364,  364,  364,  364,  364,  364,  364,
  364,  364,  364,    0,    0,  106,  527,    0,    0,  364,
    0,   52,  364,   52,    0,   52,    0,   52,    0,    0,
   52,    0,   52,   52,    0,   52,    0,   52,    0,   52,
    0,   52,   52,   52,   52,    0,    0,   52,   52,    0,
    0,    0,    0,   52,   52,   52,   52,   52,    0,    0,
   52,    0,   52,    0,   52,    0,   52,   52,    0,   52,
   52,   52,   52,    0,    0,   52,   52,   52,   52,    0,
    0,   52,   52,   52,    0,    0,    0,    0,    0,    0,
   52,   52,    0,   52,   52,    0,   52,   52,   52,    0,
    0,    0,   52,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   52,    0,    0,   52,   52,   51,    0,    0,
    0,   51,    0,   51,    0,    0,   51,    0,   51,   51,
    0,   51,    0,   51,    0,   51,    0,   51,   51,   51,
   51,    0,    0,   51,   51,    0,    0,    0,    0,   51,
    0,   51,   51,   51,    0,    0,   51,    0,   51,    0,
   51,    0,    0,   51,    0,   51,   51,   51,   51,   52,
    0,    0,   51,   51,   51,    0,    0,   51,   51,   51,
    0,    0,    0,    0,    0,    0,   51,   51,    0,   51,
   51,    0,   51,   51,   51,    0,    0,    0,   51,    0,
    0,   51,    0,    0,    0,   51,    0,   51,    0,    0,
   51,    0,   51,   51,    0,   51,    0,   51,   51,   51,
    0,   51,   51,   51,   51,   86,    0,   51,   51,    0,
    0,    0,    0,   51,   51,   51,   51,   51,    0,    0,
   51,    0,   51,    0,   51,    0,    0,   51,    0,   51,
   51,   51,   51,    0,    0,    0,   51,   51,   51,    0,
    0,   51,   51,   51,    0,    0,    0,    0,    0,    0,
   51,   51,    0,   51,   51,   51,   51,   51,   51,    0,
    0,    0,   51,    0,    0,   52,    0,    0,    0,   52,
    0,   52,    0,    0,   52,    0,   52,   52,    0,   52,
    0,   52,   51,   52,    0,   52,   52,   52,   52,   87,
    0,   52,   52,    0,    0,    0,    0,   52,   51,   52,
   52,   52,    0,    0,   52,    0,   52,    0,   52,    0,
    0,   52,    0,   52,   52,   52,   52,    0,    0,    0,
   52,   52,   52,    0,    0,   52,   52,   52,    0,    0,
    0,    0,    0,    0,   52,   52,    0,   52,   52,   51,
   52,   52,   52,    0,    0,    0,   52,    0,    0,   51,
    0,    0,    0,   51,    0,   51,    0,    0,   51,    0,
   51,   51,    0,   51,    0,   51,   52,   51,    0,   51,
   51,   51,   51,    0,    0,   51,   51,    0,    0,    0,
    0,   51,   52,   51,   51,   51,    0,    0,   51,    0,
   51,    0,   51,    0,    0,   51,    0,   51,   51,   51,
   51,    0,    0,    0,   51,   51,   51,    0,    0,   51,
   51,   51,    0,    0,    0,    0,    0,    0,   51,   51,
    0,   51,   51,   52,   51,   51,   51,    0,    0,    0,
   51,    0,    0,   51,    0,    0,    0,   51,    0,   51,
    0,    0,   51,    0,   51,   51,    0,   51,    0,   51,
   51,   51,    0,   51,   51,   51,   51,  238,    0,   51,
   51,    0,    0,    0,    0,   51,    0,   51,   51,   51,
    0,    0,   51,    0,   51,  364,   51,    0,    0,   51,
    0,   51,   51,   51,   51,    0,    0,    0,   51,   51,
   51,    0,    0,   51,   51,   51,    0,    0,  364,    0,
    0,    0,   51,   51,    0,   51,   51,   51,   51,   51,
   51,  364,    0,    0,   51,    0,  364,    0,    0,  364,
    0,  364,    0,  364,  364,  364,  364,    0,    0,    0,
    0,  364,    0,    0,   51,  364,    0,    0,    0,  364,
    0,  239,    0,    0,    0,    0,    0,  364,    0,    0,
  364,    0,  364,    0,   57,   24,    0,   25,    0,    0,
   26,  259,    0,    0,    0,   27,   62,   63,    0,   28,
    0,  364,    0,    0,    0,   65,  364,    0,   30,    0,
    0,    0,    0,  364,  364,   32,  287,    0,  364,    0,
   33,   51,   72,   73,   34,    0,  636,    0,    0,    0,
    0,  364,    0,  637,    0,    0,   36,    0,   37,   75,
    0,    0,   38,    0,    0,   77,    0,   79,    0,   81,
   39,   40,  260,    0,   41,    0,    0,    0,    0,    0,
    0,  638,    0,  364,   88,   89,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   90,
   91,   92,   93,   94,    0,    0,    0,    0,    0,    0,
    0,    0,   96, 1011,    0,  639,    0,    0,   98,   99,
  100,  101,    0,    0,    0,  102,    0,  103,    0,    0,
    0,    0,    0,  104,  105,    0,    0,    0,    0,    0,
    0,   57,   24,    0,   25,    0,    0,   26,  259,    0,
    0,    0,   27,   62,   63,    0,   28,    0,  106,  107,
  108,  109,   65,    0,    0,   30,    0,    0,    0,    0,
    0,    0,   32,    0,    0,    0,    0,   33,    0,   72,
   73,   34,    0,  636,    0,    0,    0,    0,    0,    0,
  637,    0,    0,   36,    0,   37,   75,    0,    0,   38,
    0,    0,   77,    0,   79,    0,   81,   39,   40,  260,
    0,   41,    0,    0,    0,    0,    0,    0,  638,    0,
    0,   88,   89,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   90,   91,   92,   93,
   94,    0,    0,    0,    0,    0,    0,    0,    0,   96,
    0,    0,  639,    0,    0,   98,   99,  100,  101,    0,
    0,    0,  102,    0,  103,    0,    0,    0,    0,    0,
  104,  105,    0,    0,    0,    0,    0,    0,   57,   24,
    0,   25,    0,    0,   26,  259,    0,    0,    0,   27,
   62,   63,    0,   28,    0,  106,  107,  108,  109,   65,
    0,    0,   30,    0,    0,    0,    0,    0,    0,   32,
    0,    0,    0,    0,   33,    0,   72,   73,   34,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   36,    0,   37,   75,    0,    0,   38,    0,    0,   77,
    0,   79,    0,   81,   39,   40,  260,    0,   41,    0,
    0,   85,    0,    0,    0,   87,    0,    0,   88,   89,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   90,   91,   92,   93,  308,    0,    0,
    0,    0,    0,    0,    0,    0,   96,    0,    0,    0,
    0,    0,   98,   99,  100,  101,    0,    0,    0,  102,
    0,  103,    0,    0,    0,    0,    0,  104,  105,    0,
    0,    0,    0,    0,    0,   57,   24,    0,   25,    0,
    0,   26,  259,    0,    0,    0,   27,   62,   63,    0,
   28,    0,  106,  309,  108,  109,   65,    0,    0,   30,
    0,    0,    0,    0,    0,    0,   32,    0,    0,    0,
    0,   33,    0,   72,   73,   34,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   36,    0,   37,
   75,    0,    0,   38,    0,    0,   77,    0,   79,    0,
   81,   39,   40,  260,    0,   41,    0,    0,    0,    0,
    0,    0,   87,    0,    0,   88,   89,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   90,   91,   92,   93,  308,    0,    0,    0,    0,  546,
    0,    0,    0,   96,    0,    0,    0,    0,    0,   98,
   99,  100,  101,    0,    0,    0,  102,    0,  103,    0,
    0,    0,    0,    0,  104,  105,    0,    0,    0,    0,
    0,    0,   57,   24,    0,   25,    0,    0,   26,  259,
    0,    0,    0,   27,   62,   63,    0,   28,    0,  106,
  309,  108,  109,   65,    0,    0,   30,    0,    0,    0,
    0,    0,    0,   32,    0,    0,    0,    0,   33,    0,
   72,   73,   34,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   36,    0,   37,   75,    0,    0,
   38,    0,    0,   77,    0,   79,    0,   81,   39,   40,
  260,    0,   41,    0,    0,    0,    0,    0,    0,   87,
    0,    0,   88,   89,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   90,   91,   92,
   93,  308,    0,    0,    0,    0,  540,    0,    0,    0,
   96,    0,    0,    0,    0,    0,   98,   99,  100,  101,
    0,    0,    0,  102,    0,  103,    0,    0,    0,    0,
    0,  104,  105,    0,    0,    0,    0,    0,    0,   57,
   24,    0,   25,    0,    0,   26,  259,    0,    0,    0,
   27,   62,   63,    0,   28,    0,  106,  309,  108,  109,
   65,    0,    0,   30,    0,    0,    0,    0,    0,    0,
   32,    0,    0,    0,    0,   33,    0,   72,   73,   34,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   36,    0,   37,   75,    0,    0,   38,    0,    0,
   77,    0,   79,    0,   81,   39,   40,  260,    0,   41,
    0,    0,    0,    0,    0,    0,   87,    0,    0,   88,
   89,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   90,   91,   92,   93,  308,    0,
    0,    0,    0,    0,    0,    0,    0,   96,    0,    0,
    0,    0,    0,   98,   99,  100,  101,    0,    0,    0,
  102,    0,  103,    0,    0,    0,    0,    0,  104,  105,
    0,    0,    0,    0,    0,    0,   57,   24,    0,   25,
    0,    0,   26,  259,    0,    0,    0,   27,   62,   63,
    0,   28,    0,  106,  309,  108,  109,   65,    0,    0,
   30,    0,    0,    0,    0,    0,    0,   32,    0,    0,
    0,    0,   33,    0,   72,   73,   34,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   36,    0,
   37,   75,    0,    0,   38,    0,    0,   77,    0,   79,
    0,   81,   39,   40,  260,    0,   41,    0,    0,    0,
    0,    0,    0,   87,    0,    0,   88,   89,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   90,   91,   92,   93,   94,    0,    0,    0,    0,
    0,    0,    0,    0,   96,    0,    0,    0,    0,    0,
   98,   99,  100,  101,    0,    0,    0,  102,    0,  103,
    0,    0,    0,    0,    0,  104,  105,    0,    0,    0,
    0,    0,    0,  687,  687,    0,  687,    0,    0,  687,
  687,    0,    0,    0,  687,  687,  687,    0,  687,    0,
  106,  107,  108,  109,  687,    0,    0,  687,    0,    0,
    0,    0,    0,    0,  687,    0,    0,    0,    0,  687,
    0,  687,  687,  687,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  687,    0,  687,  687,    0,
    0,  687,    0,    0,  687,    0,  687,    0,  687,  687,
  687,  687,    0,  687,    0,    0,    0,    0,    0,    0,
  687,    0,    0,  687,  687,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  687,  687,
  687,  687,  687,    0,    0,    0,    0,    0,    0,    0,
    0,  687,    0,    0,    0,    0,    0,  687,  687,  687,
  687,    0,    0,    0,  687,    0,  687,    0,    0,    0,
    0,    0,  687,  687,    0,    0,    0,    0,    0,    0,
  146,  146,    0,  146,    0,    0,  146,  146,    0,    0,
    0,  146,  146,  146,    0,  146,    0,  687,  687,  687,
  687,  146,    0,    0,  146,    0,    0,    0,    0,    0,
    0,  146,    0,    0,    0,    0,  146,    0,  146,  146,
  146,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  146,    0,  146,  146,    0,    0,  146,    0,
    0,  146,    0,  146,    0,  146,  146,  146,  146,    0,
  146,    0,    0,    0,    0,    0,    0,  146,    0,    0,
  146,  146,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  146,  146,  146,  146,  146,
    0,    0,    0,    0,    0,    0,    0,    0,  146,    0,
    0,    0,    0,    0,  146,  146,  146,  146,    0,    0,
    0,  146,    0,  146,    0,    0,    0,    0,    0,  146,
  146,    0,    0,    0,    0,    0,    0,   57,   24,    0,
   25,    0,    0,   26,  259,    0,    0,    0,   27,   62,
   63,    0,   28,    0,  146,  146,  146,  146,   65,    0,
    0,   30,    0,    0,    0,    0,    0,    0,   32,    0,
    0,    0,    0,   33,    0,   72,   73,   34,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   36,
    0,   37,   75,    0,    0,   38,    0,    0,   77,    0,
   79,    0,   81,   39,   40,  260,    0,   41,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   90,   91,   92,  261,  680,    0,    0,    0,
    0,    0,    0,    0,    0,   96,    0,    0,    0,    0,
    0,   98,   99,  100,  101,    0,    0,    0,  102,    0,
  103,    0,   57,   24,    0,   25,  104,  105,   26,  259,
    0,    0,    0,   27,   62,   63,    0,   28,    0,    0,
    0,    0,    0,   65,    0,    0,   30,    0,    0,    0,
    0,  106,  263,   32,  109,    0,    0,    0,   33,    0,
   72,   73,   34,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   36,    0,   37,   75,    0,    0,
   38,    0,    0,   77,    0,   79,    0,   81,   39,   40,
  260,    0,   41,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   90,   91,   92,
  261,  351,    0,    0,    0,    0,    0,    0,    0,    0,
   96,    0,    0,    0,    0,    0,   98,   99,  100,  101,
    0,    0,    0,  102,    0,  103,    0,    0,    0,    0,
    0,  104,  105,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  733,    0,  733,    0,  733,  106,  263,  733,  109,
  733,  733,    0,  733,    0,  733,    0,  733,    0,  733,
  733,  733,    0,    0,    0,  733,  733,    0,    0,    0,
    0,  733,    0,  733,  733,    0,    0,    0,  733,    0,
    0,    0,  733,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  733,  733,    0,  733,    0,    0,    0,
  733,  733,    0,    0,    0,    0,    0,    0,  733,  733,
   57,   24,  733,   25,    0,  733,   26,  259,    0,    0,
  733,   27,   62,   63,    0,   28,    0,    0,    0,    0,
    0,   65,    0,    0,   30,    0,    0,    0,    0,    0,
    0,   32,    0,  733,  733,    0,   33,    0,   72,   73,
   34,    0,    0,    0,    0,    0,  733,    0,    0,    0,
    0,    0,   36,    0,   37,   75,    0,    0,   38,    0,
    0,   77,    0,   79,    0,   81,   39,   40,  260,    0,
   41,    0,    0,   85,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  733,    0,    0,
    0,    0,    0,    0,    0,   90,   91,   92,  261,  262,
    0,    0,    0,    0,    0,  732,    0,  732,   96,    0,
  732,    0,  732,  732,    0,  732,    0,  732,    0,  732,
    0,  732,  732,  732,    0,    0,    0,  732,  732,    0,
    0,    0,    0,  732,    0,  732,  732,    0,    0,    0,
  732,    0,    0,    0,  732,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  106,  263,  732,    0,  732,    0,
    0,    0,  732,  732,    0,    0,    0,    0,    0,    0,
  732,  732,    0,   24,  732,   25,    0,  732,   26,    0,
    0, 1399,  732,   27,    0,  757,    0,   28,    0,  758,
 1400, 1401,    0,    0,    0, 1402,   30,    0,    0,    0,
    0, 1403,    0,   32,    0,   51,    0,   51,   33,    0,
   51,    0,   34,    0,    0,   51,    0,    0,  732,   51,
    0,    0,    0,    0,   36,    0,   37,    0,   51,    0,
   38,    0,    0,    0,    0,   51,    0,    0,   39,   40,
   51,    0,   41,    0,   51, 1404,   51,    0,   51,    0,
 1405,    0,    0,   51,    0,    0,   51,    0,   51,  732,
    0,    0,   51,    0,    0,   51,    0,    0,    0,    0,
   51,   51,    0,   51,   51,   51,    0,   51,   51,    0,
    0,    0,    0,   51,    0,    0, 1406,   51,    0,    0,
    0,    0,    0,    0,    0,    0,   51,    0,    0,    0,
    0,    0,    0,   51,    0,   24,    0,   25,   51,    0,
   26,    0,   51,  169,   51,   27,   51,    0,    0,   28,
    0,   51,    0,    0,   51,    0,   51, 1407,   30,    0,
   51,    0,    0,   51,    0,   32,    0,    0,   51,   51,
   33,    0,   51,    0,   34,   51,  605,    0,    0,    0,
    0,    0,    0,  606,    0,    0,   36,    0,   37,   51,
    0,    0,   38,    0,    0,  607,    0,    0,    0,    0,
   39,   40,    0,    0,   41,    0,    0,  608,   52,  169,
   52,    0,    0,   52,    0,    0,    0,    0,   52,    0,
    0,    0,   52,    0,    0,    0,    0,    0,    0,    0,
    0,   52,    0,  609,    0,    0,    0,    0,   52,    0,
   51,    0,   51,   52,    0,   51,    0,   52,    0,   52,
   51,   52,    0,    0,   51,    0,   52,   51,    0,   52,
    0,   52,    0,   51,    0,   52,    0,    0,   52,    0,
   51,    0,    0,   52,   52,   51,    0,   52,    0,   51,
   52,   51,    0,   51,    0,   24,    0,   25,   51,  610,
   26,   51,    0,   51,    0,   27,    0,   51,    0,   28,
   51,    0,    0,   29,    0,   51,   51,    0,   30,   51,
    0,    0,   51,   31,    0,   32,    0,   24,    0,   25,
   33,    0,   26,    0,   34,   35,    0,   27,    0,    0,
    0,   28,    0,    0,    0,    0,   36,    0,   37,    0,
   30,    0,   38,    0,    0,    0,    0,   32,    0,    0,
   39,   40,   33,    0,   41,    0,   34,   42,    0,    0,
    0,   37,   52,    0,    0,    0,    0,    0,   36,    0,
   37,    0,   37,    0,   38,    0,    0,   37,    0,    0,
    0,   37,   39,   40,   37,    0,   41,    0,    0,   85,
    0,    0,    0,    0,   51,    0,   37,   37,    0,    0,
    0,   37,   37,    0,    0,    0,    0,   37,    0,   37,
   37,   37,   37,    0,    0,  297,    0,   37,    0,    0,
    0,   37,    0,   37,    0,    0,    0,    0,    0,    0,
    0,    0,   35,   37,    0,   37,   37,    0,   37,   43,
    0,    0,   37,   35,    0,    0,    0,    0,   35,    0,
    0,    0,   35,    0,    0,   35,    0,    0,    0,    0,
    0,    0,   37,    0,    0,    0,    0,   35,   35,   37,
   37,  330,   35,   35,   31,    0,    0,    0,   35,    0,
   35,   35,   35,   35,    0,    0,    0,    0,   35,    0,
    0,    0,   35,    0,   35,    0,    0,   31,    0,    0,
    0,    0,    0,    0,   35,    0,    0,   35,    0,   35,
   31,    0,   31,   35,   31,   31,    0,    0,    0,    0,
   31,    0,   31,   31,   31,   31,    0,    0,   31,    0,
   31,    0,    0,   35,   31,   31,    0,    0,    0,    0,
   35,   35,    0,    0,    0,    0,   31,    0,   31,   31,
    0,   31,    0,   31,    0,    0,    0,    0,   31,    0,
   31,   31,   31,   31,    0,    0,    0,    0,   31,    0,
    0,    0,   31,    0,    0,   31,    0,    0,    0,    0,
    0,    0,   31,   31,   31,    0,    0,   31,   51,   31,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   51,
    0,    0,    0,    0,   51,    0,    0,    0,   51,    0,
    0,   51,    0,   31,    0,    0,    0,    0,    0,    0,
   31,   31,    0,   51,   51,    0,    0,    0,   51,   51,
    0,   51,    0,    0,   51,    0,   51,   51,   51,   51,
    0,    0,   51,    0,   51,    0,    0,   51,   51,    0,
   51,   51,    0,    0,   51,    0,    0,    0,    0,    0,
   51,    0,    0,   51,    0,   51,   51,   51,    0,   51,
    0,   51,   51,    0,   51,    0,    0,   51,    0,   51,
   51,   51,   51,    0,    0,    0,    0,   51,    0,   51,
    0,   51,    0,   51,    0,    0,   39,   51,    0,    0,
    0,    0,    0,   51,    0,    0,   51,    0,   51,    0,
   51,    0,   51,    0,   51,   51,    0,    0,    0,    0,
   51,    0,   51,   51,   51,   51,    0,    0,    0,    0,
   51,    0,   51,    0,   51,    0,    0,   51,    0,   40,
    0,    0,    0,    0,    0,    0,   51,    0,    0,   51,
   51,   51,    0,    0,   51,   51,    0,    0,    0,    0,
   51,    0,   51,   51,   51,   51,    0,    0,    0,    0,
   51,    0,    0,    0,   51,   51,    0,   51,   51,   51,
    0,    0,  220,    0,    0,    0,   51,    0,    0,   51,
   51,   51,    0,    0,   51,   51,   51,    0,    0,    0,
   51,    0,   51,   51,   51,   51,    0,    0,   51,    0,
   51,    0,    0,    0,   51,   51,    0,   51,   51,   51,
    0,    0,  222,    0,   51,    0,   51,    0,    0,   51,
   51,   51,    0,    0,    0,   51,    0,    0,    0,    0,
   51,    0,   51,   51,   51,   51,    0,   51,    0,    0,
   51,    0,    0,    0,   51,   51,    0,    0,    0,    0,
   51,    0,  322,    0,  477,   51,   51,    0,    0,   51,
   51,   51,   51,   51,   51,   51,    0,    0,    0,    0,
   51,    0,    0,    0,   51,    0,    0,  478,    0,    0,
    0,    0,    0,    0,  477,   51,   51,    0,    0,   51,
  479,   51,  323,    0,  480,  481,    0,    0,    0,    0,
  482,    0,  483,  484,  485,  486,    0,  478,    0,    0,
  487,    0,    0,    0,  488,   51,    0,    0,   51,   51,
  479,    0,    0,    0,    0,  481,  489,    0,    0,  490,
  482,  491,  483,  484,  485,  486,    0,    0,    0,    0,
  487,    0,    0,    0,  488,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  492,  489,    0,    0,  490,
    0,  491,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  492,
  };
  protected static readonly short [] yyCheck = {            17,
  306,   18,    4,  305,  320,   17,   17,   52,    6,   17,
   52,  385,  544,  295,  193,  192,  546,  239,  494,  354,
  237,   69,  329,  304,  252,   20,  516,  341,  161,  304,
  594,  601,  119, 1019,  302,  117,   60,  119,   60,  612,
   88,   89,  379,  396, 1196,   93,   78,  975,   59,  824,
  256,  395, 1236,  256,  256,    0,   74,  621,  268,  268,
   78,  336,  256,  379,   17,  113,  268,  292,  256,   80,
  256,   82,  256, 1470,  256,  256,  335, 1230,   96,   45,
  385, 1340,   48,    0,   88,   89,  256,  294,  282,   62,
  464, 1275, 1024,   66,   67,   68,  369,   70,   71,  306,
 1359,   17,   75,   76,  256,  109, 1290,   17,   81,   82,
  256,   84,  256,   86,  256,  369, 1076, 1305,   91,   92,
  314,  269,  357,   21,  325,  499,  369,   17,  176,  792,
  256,  794,  256,  374,  377,  256,  377,  256,  286,  375,
  256, 1294, 1102,  161,   17,  118,  256,  372,  193,  161,
  161,  193,  387,  161,   20,   53, 1314,  430,  731,  464,
  369,  436,  256,  256,   17,  419,  372,  395,  256,  339,
  373,  430,  375,   17,  344,  838,  346,  268,  841,  349,
  350,  417,  352,  353,  368,  276,  368,  256,  372,   17,
  372,   17,  237,  256, 1382,  237,  421,   17,  256,  203,
  204,  382, 1599,  251,  252,  375,  392,   60,  161,   17,
   17,   64,  419,  423,  423,  421,  590,  265,  419,   17,
 1152,  423,   88,   89,  368,  419,  540,  430,  256,  415,
  372,  419, 1160,  377,  252,  233,  422,  421,  460,  421,
  258,  543,  459,  109,  331,  161,  328,  363,  585,  331,
  343,  161,  626,  363,  302, 1413,  338,  631,  632,  594,
  430,  227,   60, 1421,  268,  795,   64,  419,  292,  585,
  292,  161,  363,  419,  368, 1534,  370,  295,  372,  421,
  302,  851,  300,  301,  628,  333,  621,  260,  161,  358,
  294,  264,  340,  419,  382,  419,  612,  315,  419,  392,
  419,  325, 1561,  419,  352,  323,    0,  325,  161,  419,
  314,  329,  257,  324, 1573,  256, 1575,  161,  376,  382,
 1478,  256,  415,  256,  342,  343,  631,  421,  419,  422,
  424,  304,  256,  161, 1191,  161,  429,  203,  204,  387,
  257,  161,  354,  391,  348,  349,  354,  395,  396,  377,
 1125,  383,  726,  161,  161,  272,  425,  426,  427,  428,
  277,  256,  256,  161,  281,  383,  375,  256,  256,  256,
  374,  256,  256,  277, 1231,  369, 1528,  395,  396,  296,
  953,  399,  400,  401,  402,  403,  404,  405,  406,  407,
  408,  409,  414,  441,  442,  732,  256,  445,  256,  674,
  628,  256,  268,  392,  256,  256,  323,  256,  417,  413,
 1594,  256,  363,  431,  459,  731, 1402,  459, 1081,  256,
  256,  726,  363,  256,  469,  342,  415,  469,  294,  256,
  371,  256,  373,  368,  375,  370,  430,  441,  442,  292,
  306,  757, 1626,  256,  377,  257,  256,  256,  314,  266,
  256,  339,  376,  306,  320,  266,  344,  987,  346,  363,
  256,  349,  350,  256,  352,  353,  461,  515,  419,  517,
  262,  264,  325,  780,  256,  965,  370,  325,  419,  474,
  305,  376,  348,  349,  373,  369,  371,  375,  363,  376,
  375,  375,  516,  292,  292,  340,  544,  314,  509,  465,
  466,  354,  876,  314,  341,  471,  298,  257,  374,  372,
  370,  256,  256,  379,  372,  419,  420,  739,  358,  370,
  375,  370,  570,  375,  542,   17,  544,  325,  546,  797,
  867,  277,  325,  370,  887,  281, 1106,  765,  511,  375,
  373,  351,  430, 1206,  419, 1075,  373,  413,  559,  294,
  772,  867, 1215,  305,  429,  368,  354,  575,  421,  376,
  578,  414,  256,  611,  373,  376,  369,  373,   60,  368,
  369,  419,   64,  377,  343,  441,  442,  373,  589,  627,
  628, 1244,  594,  369,  671,  558,  594,  379,  380,  671,
  601,  373,  335,  369,  373,  461,  342,  710,  369,  343,
  363,  369,  715,  716,  375, 1175, 1463,  375,  474,  621,
  628, 1320, 1321,  621,  382,  952,  414,  374,  636,  637,
  377,  363,  373,  392,  368,  673,  430,  430,  372,  369,
  374,  375,  256,  377, 1343, 1492, 1493,  953,  382, 1496,
  419, 1304,  373,  369,  430,  339,  415, 1211,  950,  343,
  373,  377, 1509,  422,  430, 1512,  419, 1563, 1564,  430,
  429, 1370,  430,  516,  712,  893,  714,  981,  372,  161,
 1527,  263,  416,  256,  368,  723,  809,  419,  372,  430,
  374,  375,  376,  377, 1393,  373,  263,  429,  382,  374,
  430,  370,  710,  256, 1551,  374,  294,  715,  716,  430,
  718,  369,  339,  272,  430,  986,  272,  430,  277,  984,
  369,  341,  281, 1019, 1620,  339,  375,  765,  516,  585,
  344,  419,  346,  315,  339,  349,  350,  296,  352,  353,
  296,  368,  256, 1321,  782,  372,  399,  400,  315,  424,
  370,  594,  430, 1321, 1321,  424,  612,  765, 1193,  797,
  272,  419,  305,  368,  323, 1245,  339,  323,  256,  357,
  758,  344,  780,  346,  343,  363,  349,  350,  621,  352,
  353, 1078,  370,  342,  296,  797,  374,  795,  272, 1321,
  343,  305, 1370, 1321,  802, 1317,  804,  339, 1233,  387,
 1092,  306, 1370, 1370, 1425, 1321,  594,  372,  313,  374,
  292,  323,  296,  382, 1321,  368,  430,  256, 1439,  372,
  325,  374,  375,  392,  377, 1043,  368, 1321,  866,  382,
  831,  419,  833,  621,  376,  843,  830,  845, 1370,  323,
 1461,  256, 1370,  325, 1169,  948,  415,  855,  849,  887,
  851,  339,  846,  422, 1370,  893,  344,  430,  346,  339,
  429,  349,  350, 1370,  352,  353,  829,  343, 1035,  863,
  339,  369,  354,  364,  370,  731, 1370,  375,  368,  887,
  339,  372,  985,  374,  382,  893, 1211,  377,  368,  392,
  343,  369, 1164,  372,  902,  930,  904,  375,  930,  368,
  339,  757,  393,  394, 1196,  344,  382,  346,  382,  368,
  349,  350,  415,  352,  353,  368,  392,  371,  392,  422,
  377,  375,  413, 1026,  339, 1028,  429, 1199, 1031,  344,
  421,  346,  414,  424,  349,  350,  343,  352,  353,  415,
  948,  415,  950,  256,  402,  357,  422,  343,  422,  792,
  935,  794,  940,  429,  992,  256,  414,  368,  343,  967,
  954,  368,  374,  343,  972,  339,  377,  975,  269,  343,
 1242, 1189,  368, 1439,  830,  387,  377,  985,  392,  987,
 1305,  377,  990,  368, 1022,  286,  415,  368,  368,  370,
  846,  430,  377,  422,  368,  838, 1516,  377,  841,  343,
  357,  415,  306,  377,  792, 1043,  794,  863,  422,  313,
  294,  867, 1115, 1408, 1117,  430, 1119,  374, 1026,  368,
 1028, 1059,  306, 1031,  368, 1420,  339, 1065,  383,  384,
  387,  344,  256,  346,  516, 1043,  349,  350, 1383,  352,
  353,  387,  397,  398,  306, 1390,  308,  372, 1260, 1256,
  838,  313,  369,  841, 1048, 1040, 1328, 1382, 1578, 1228,
  377,  370, 1050,  325, 1052,  385, 1054, 1075, 1408,  357,
 1078,  374, 1436,  382,  377,  363,  375, 1383,  377,  935,
 1420,  386,  370,  382, 1390,  373,  374,  375,  373, 1453,
  375,  368,  369,  368,  369, 1615,  390,  953,  954,  387,
  377,  372,  377,  374,  401, 1106, 1402, 1115, 1472, 1117,
 1474, 1119,  594,  391, 1122,  339, 1219,  430, 1640, 1641,
  344,  373,  346,  375,  370,  349,  350,  369,  352,  353,
  369,  419,  419,  375,  373,  377,  375,  416,  377,  621,
  369, 1133,  256,  373,  373,  375,  375,  377,  377,  369,
 1253, 1189, 1160,  373,  371,  372, 1164,  377,  375,  395,
  396,  371,  372, 1019,  374,  375,  376, 1169,  371, 1177,
 1178, 1169,  375,  371, 1175,  373, 1019,  375,  371,  419,
  373, 1189,  375, 1190, 1040,  371,  371,  277, 1196,  375,
  375, 1199, 1048, 1228,  374, 1230, 1228,  371, 1230,  373,
  373,  368,  377, 1306,  377,  372,  430,  374,  375, 1211,
  377, 1219,  377, 1211,  371,  382,  256, 1225,  375,  369,
  370, 1256,  371, 1326, 1256,  265,  375,  267,  371,  375,
  270,  377,  375,  372, 1242,  275, 1528,  376, 1081,  279,
  419,  420,  421,  422,  382, 1253, 1254,    6,  288,  416,
  373,  368,  373,  371,  377,  295,  377,  375,   17, 1294,
  300,  371, 1294,  373,  304,  403,  404,  405,  406,  407,
  408,  409,  410,  411,  412,  256,  316,  373,  318, 1317,
  374,  377,  322,  368,  369, 1320, 1321,  256, 1320, 1321,
  330,  331,  294, 1081,  334,  354,  355,  337, 1306,  377,
  371,   60,  373, 1305,  377,   64,   20, 1305, 1343, 1317,
  792, 1343,  794,  387,  388,  389,  294,  371, 1326,  373,
 1328,  373,  373,  375,  375, 1319, 1169,  354,  355,   88,
   89,  375,  343,  377,  256, 1370, 1374,  371, 1370,  373,
  371,  373,  373,  265,  377,  267,  356,  375,  270,  377,
  109,  419,  375,  275,  377,  419,  838,  279, 1393,  841,
 1652, 1393,  375, 1206,  377,  802,  288,  804, 1211,  369,
  370,  419, 1215,  295,   88,   89, 1232,  370,  300,  419,
 1382, 1169,  304,  373, 1382, 1386,  415, 1381,  376,  415,
  416,  365,  366,  373,  316,  109,  318,  368,  369,  382,
  322, 1244,  161,  365,  366, 1399, 1400,  377,  330,  331,
  415,  416,  334,  417,  418,  337,  423,  424, 1206,  369,
  364,  375,  430, 1211,  373,  369,  373, 1215,  372,  294,
  374,  375,  294, 1427,  375,  373, 1430,  373,  382, 1447,
  375, 1297,  373, 1444,  203,  204,  256,  377,  372,  393,
  394,  256,  429,  429,  294,  294, 1244,  382,  373,  375,
  374, 1304, 1305, 1319,  376,  375,  374,  419,  373,  413,
  430, 1506,  375,  382, 1506,  375,  375,  421,  375,  424,
  424,  373,  375,  368,  375,  373,  430,  343, 1523,  203,
  204, 1523,  375,  294,  294,  375,  419,  419,    0,  371,
  419, 1536, 1537,  372, 1536, 1537,  376,  368, 1516,  268,
  256,  256,  375, 1514,  256,  256, 1304, 1305,  382,  280,
 1528,  256,  368,  373,  369, 1381,  343, 1383, 1563, 1564,
  371, 1563, 1564,  292, 1390,  294,  372, 1545,  375, 1382,
    0,  375,  377, 1399, 1400,  377, 1402,  306,  373,  382,
  371,  373, 1408,  373,  268,  314,  424,  373,  382, 1402,
  347,  320,  368,  382, 1420,  256,  325,  382,  256, 1425,
 1578, 1427,  369,  377, 1430,  373,  256,  373,  256,  347,
  294,  375,  371, 1439,  376, 1620,  372,  371, 1620,  348,
  349,  292,  306,  371, 1382,  354,  373,  348,  369, 1081,
  314,  339, 1640, 1641,  373, 1461,  320, 1615,  419,  375,
  372,  419,  348,  373,  256,  374,  369,  382,  368,  368,
  379,  377, 1623, 1624,  368,  356,  369,  375,  337, 1630,
 1631,  305, 1640, 1641,  348,  349,  373,  377,  372,  369,
  369,  373,  369,  419, 1652,  370,  372,  419,  368,  419,
  372,  372,  419,  377,  413,  414,  372,  374,  368,  339,
  374,  372,  343,  382,  344,  379,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,  372,  377,  382,
  370,  373,  441,  442,  373,  372,  256, 1169,  374,  369,
  375,  371,  374,  373,  377,  375,  376,  377,  375,  413,
  375,  419,  375,  373,  373,  371,  419,  419,  373,  377,
  377,  391,  419,  377,  373,  373,  369,  371,  373,  382,
  382,  369,  315,  263, 1206,  372,  372,  441,  442, 1211,
   94,  382,  369, 1215,   98,   99,  100,  101,  102,  103,
  104,  105,  373,  373,  377,    0,    0,  461,  368,  377,
  430,  369,  377,    0,  373,  257,  369,  516,  373,  261,
  474,  368, 1244,  373,  369,  371,  369,  419,  377,  373,
  272,  371,  368,  374,  419,  277,  419,  369,  373,  281,
  377,  369,  284,  373,  373,  369,  377,  368,  373,  369,
  377,  373,  369,  315,  296,  297,  256,  263,  377,  301,
  302,  261,  262,  377,  377,  307,  377,  309,  310,  311,
  312,  377,  377,  377,  377,  317,  377,   51,   12,  321,
    5,  323, 1304, 1305,  284, 1040,  585,  935, 1189,    0,
 1189,  333, 1393,  335,  336,  594,  338,  297,  298, 1343,
  342, 1398,  302, 1238, 1568,  305, 1531,  307, 1519,  309,
  310,  311,  312,  612, 1444, 1584, 1548,  317, 1514,  957,
  362,  321,  621,  952,  957,  325,  957,  369,  370,  771,
 1425,  585, 1358,  333, 1631, 1370,  336, 1445,  338,  339,
 1625, 1541, 1537,  343,  344, 1536,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,  357,  612, 1624,
 1382, 1294,  362,  363, 1474,  930,  320, 1297,  368,  369,
  370,  371,  372,  373,  374,  375,  376,  377,  414,  379,
  380,  981,  637,  383,  384,  385,  386,  387,  893, 1092,
  390,  391,   72,  261,  765,  395,  396,  397,  398,  399,
  400,  401,  402,  797,  308,    0,  344,  992,  425,  427,
  426,  430, 1195,  428,  414,  429,  284,  417,  585,  419,
  867,  421, 1272, 1381,  424, 1169,  161, 1154, 1077,  297,
  430, 1178,  731, 1102,  302, 1061, 1167,  341, 1245,  307,
 1169,  309,  310,  311,  312,  560, 1214,  351,  450,  317,
  996,  450, 1376,  321, 1254,  932,  925,  325,  757,   -1,
   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,  336,   -1,
  338,   -1,   -1,  721,   -1,   -1,   -1,  731,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  792,  362,  794,    0,   -1,   -1,   -1,
   -1,  369,   -1,  757,   -1,   -1,  410,  411,  412,   -1,
   -1,  415,  416,  417,  418,  419,  420,  421,  422,  423,
  424,  425,  426,  427,  428,  429,  430,   -1,   -1,   -1,
   -1,  830,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  838,
   -1,   -1,  841,   -1,   -1,   -1,  257,  846,   -1,   -1,
  261,  419,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  272,   -1,   -1,  863,   -1,  277,   -1,  867,   -1,
  281,   -1,   -1,  284,   -1,   -1,  830,  256,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  296,  297,   -1,   -1,   -1,
  301,  302,  846,   -1,   -1,   -1,  307,   -1,  309,  310,
  311,  312,   -1,   -1,   -1,   -1,  317,   -1,   -1,  863,
  321,   -1,  323,  867,   -1,   -1,   -1,    0,   -1,   -1,
   -1,   -1,  333,   -1,   -1,  336,   -1,  338,   -1,   -1,
   -1,  342,   -1,   -1,   -1,   -1,  540,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  362,   -1,   -1,  953,  954,   -1,  368,  369,  370,
  339,   -1,  257,   -1,   -1,  344,  261,  346,  347,  348,
  349,  350,  351,  352,  353,  354,  355,  272,   -1,   -1,
   -1,  935,  277,   -1,   -1,   -1,  281,   -1,   -1,  284,
  369,   -1,  371,   -1,  373,   -1,  375,  376,  377,  953,
  954,  296,  297,   -1,   -1,   -1,  301,  302,   -1,   -1,
   -1,   -1,  307,  617,  309,  310,  311,  312,   -1,   -1,
 1019,   -1,  317,   -1,   -1,   -1,  321,   -1,  323,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  333,   -1,
  335,  336,   -1,  338,   -1,   -1,   -1,  342,   -1, 1048,
   -1,  430,   -1,  257,   -1,   -1,   -1,  261,   -1,   -1,
   -1,  364,   -1,  667,  668, 1019,  369,  362,  272,  372,
   -1,  374,  375,  277,   -1,  370,  680,  281,   -1,   -1,
  284,   -1, 1081,   -1,   -1,   -1, 1040,   -1,   -1,   -1,
  393,  394,  296,  297, 1048,   -1,   -1,  301,  302,   -1,
   -1,   -1,   -1,  307,   -1,  309,  310,  311,  312,   -1,
  413,   -1,   -1,  317,   -1,   -1,   -1,  321,  421,  323,
   -1,  424,   -1,   -1,   -1,   -1,   -1,  430,  256,  333,
   -1,   -1,  336,   -1,  338,   -1,   -1,  265,  342,  267,
   -1,   -1,  270,   -1,   -1,   -1,   -1,  275,   -1,   -1,
   -1,  279,   -1,    0,   -1,   -1,   -1,   -1,  362,   -1,
  288,   -1,   -1,   -1,   -1,  369,  370,  295,   -1,   -1,
 1169,   -1,  300,  256,   -1,   -1,  304,   -1,  261,  262,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,
  318,   -1,   -1,   -1,  322,   -1,   -1,  801,   -1,   -1,
   -1,  284,  330,  331,   -1,   -1,  334, 1206,   -1,  337,
   -1,   -1, 1211,   -1,  297,  298, 1215,   -1,   -1,  302,
   -1,   -1,  305,   -1,  307,   -1,  309,  310,  311,  312,
   -1,   -1,   -1, 1232,  317,   -1,   -1,   -1,  321,   -1,
   -1,   -1,  325,   -1,   -1, 1244,   -1,   -1,   -1,   -1,
  333,   -1,   -1,  336,   -1,  338,  339,   -1,   -1,   -1,
  343,  344,   -1,  346,  347,  348,  349,  350,  351,  352,
  353,  354,  355,  356,   -1,   -1,   -1,   -1, 1232,  362,
  363,   -1,   -1,   -1,   -1,  368,  369,  370,  371,  372,
  373,  419,  375,  376,  377,   -1,  379,  380, 1297,   -1,
  383,  384,  385,  386,   -1, 1304, 1305,  390,  391,   -1,
   -1,   -1,  395,  396,  397,  398,  399,  400,  401,  402,
 1319,   -1,    0,  265,   -1,  267,   -1,   -1,  270,   -1,
  272,  414,   -1,  275,  417,   -1,  419,  279,  421,   -1,
   -1,  424,   -1, 1297,   -1,   -1,  288,  430,   -1,   -1,
   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,
  302,   -1,  304,   -1,   -1, 1319,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  316,   -1,  318,  981,   -1,   -1,
  322,  323, 1381, 1382, 1383,   -1,   -1,   -1,  330,  331,
   -1, 1390,  334,   -1,   -1,  337,   -1,   -1,   -1,   -1,
 1399, 1400,   -1, 1402,   -1,   -1,   -1,   -1,   -1,  256,
   -1,   -1,   -1,   -1,  261,  262,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1, 1381, 1427, 1383,
   -1, 1430,   -1,   -1,   -1,   -1, 1390,  284,   -1,   -1,
   -1,   -1,   -1,   -1,   -1, 1399, 1400,   -1, 1402,   -1,
  297,  298,   -1,   -1,   -1,  302,   -1,   -1,  305,   -1,
  307,   -1,  309,  310,  311,  312,   -1,   -1,   -1,   -1,
  317,   -1,   -1, 1427,  321,   -1, 1430,  419,  325,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,  336,
    0,  338,  339,   -1,   -1,   -1,  343,  344,   -1,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
   -1,   -1,   -1,   -1,   -1,  362,  363,  364,   -1,   -1,
   -1,  368,  369,   -1,  371,  372,  373,  374,  375,  376,
  377,   -1,  379,  380,   -1,  382,  383,  384,  385,  386,
  387,  388,  389,  390,  391,   -1,  393,  394,  395,  396,
  397,  398,  399,  400,  401,  402,  403,  404,  405,  406,
  407,  408,  409,  410,  411,  412,  413,  414,   -1,   -1,
  417,   -1,  419,   -1,  421,   -1,   -1,  424,  256,  257,
   -1,   -1,   -1,  430,   -1,   -1,  264,  265,  266,  267,
  268,   -1,  270,  271,   -1,  273,  274,  275,  276,  277,
  278,  279,  280,   -1,   -1,   -1,   -1,  285,   -1,  287,
  288,  289,  290,  291,  292,   -1,   -1,  295,   -1,   -1,
    0,  299,  300,   -1,  302,  303,  304,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  314,   -1,  316,   -1,
  318,  319,   -1,   -1,  322,   -1,  324,  325,  326,  327,
  328,  329,  330,  331,  332,  333,  334,  335,   -1,  337,
   -1,   -1,  340,  341,   -1,   -1,  344,  345,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,   -1,
  368,  369,   -1,   -1,  372,   -1,   -1,   -1,   -1,  377,
  378,  379,  380,  381,   -1,   -1,   -1,  385,   -1,  387,
   -1,   -1,   -1,   -1,   -1,  393,  394,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  418,  419,  420,  421,   -1,  423,  256,  257,   -1,   -1,
   -1,    0,  430,   -1,  264,  265,  266,  267,  268,   -1,
  270,  271,   -1,  273,  274,  275,  276,  277,  278,  279,
   -1,   -1,   -1,   -1,   -1,  285,   -1,  287,  288,  289,
  290,  291,  292,   -1,   -1,  295,   -1,   -1,   -1,  299,
  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  314,   -1,  316,   -1,  318,  319,
   -1,   -1,  322,   -1,  324,  325,  326,  327,  328,  329,
  330,  331,  332,  333,  334,  335,   -1,  337,   -1,   -1,
  340,  341,   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,
  360,  361,  362,  363,   -1,   -1,    0,   -1,  368,  369,
   -1,   -1,  372,   -1,   -1,   -1,   -1,  377,  378,  379,
  380,  381,   -1,   -1,   -1,  385,  256,  387,   -1,   -1,
   -1,  261,  262,  393,  394,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  284,   -1,   -1,   -1,  418,  419,
  420,  421,   -1,  423,   -1,   -1,   -1,  297,  298,   -1,
  430,   -1,  302,   -1,   -1,  305,   -1,  307,   -1,  309,
  310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1,   -1,
   -1,  321,   -1,   -1,   -1,  325,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  333,   -1,   -1,  336,   -1,  338,  339,
   -1,    0,   -1,  343,  344,   -1,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,
   -1,   -1,  362,  363,   -1,   -1,   -1,   -1,  368,  369,
  370,  371,  372,  373,   -1,  375,  376,  377,   -1,  379,
  380,   -1,   -1,  383,  384,  385,  386,  256,   -1,   -1,
  390,  391,  261,  262,   -1,  395,  396,  397,  398,  399,
  400,  401,  402,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  414,  284,   -1,  417,   -1,  419,
   -1,  421,   -1,   -1,  424,   -1,   -1,   -1,  297,  298,
  430,   -1,   -1,  302,   -1,   -1,  305,   -1,  307,   -1,
  309,  310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1,
   -1,   -1,  321,   -1,   -1,   -1,  325,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  333,   -1,   -1,  336,   -1,  338,
  339,   -1,   -1,   -1,  343,  344,   -1,  346,  347,  348,
  349,  350,  351,  352,  353,  354,  355,  356,   -1,   -1,
   -1,   -1,  256,  362,  363,   -1,   -1,   -1,  262,  368,
  369,   -1,  371,  372,  373,   -1,  375,  376,  377,   -1,
  379,  380,    0,   -1,  383,  384,  385,  386,   -1,   -1,
   -1,  390,  391,   -1,   -1,   -1,  395,  396,  397,  398,
  399,  400,  401,  402,  298,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  414,   -1,   -1,  417,   -1,
  419,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  430,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,  343,
  344,   -1,  346,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,  357,   -1,   -1,   -1,  256,   -1,  363,
   -1,   -1,   -1,  262,  368,  369,  370,  371,  372,  373,
  374,  375,  376,  377,   -1,  379,  380,   -1,   -1,  383,
  384,  385,  386,  387,   -1,   -1,  390,  391,    0,   -1,
   -1,  395,  396,  397,  398,  399,  400,  401,  402,  298,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  414,   -1,   -1,  417,   -1,  419,   -1,  421,   -1,   -1,
  424,   -1,   -1,   -1,   -1,   -1,  430,   -1,   -1,   -1,
   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  339,   -1,   -1,   -1,  343,  344,   -1,  346,  347,  348,
  349,  350,  351,  352,  353,  354,  355,  356,   -1,   -1,
   -1,   -1,   -1,   -1,  363,   -1,   -1,   -1,   -1,  368,
  369,  370,  371,  372,  373,   -1,  375,  376,  377,   -1,
  379,  380,   -1,   -1,  383,  384,  385,  386,   -1,   -1,
   -1,  390,  391,   -1,   -1,   -1,  395,  396,  397,  398,
  399,  400,  401,  402,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,    0,   -1,   -1,   -1,  414,   -1,   -1,  417,   -1,
  419,   -1,  421,   -1,   -1,  424,   -1,   -1,  256,  257,
   -1,  430,   -1,  261,   -1,   -1,   -1,  265,   -1,  267,
   -1,   -1,  270,   -1,  272,  273,   -1,  275,   -1,  277,
   -1,  279,   -1,  281,  282,  283,  284,   -1,    0,  287,
  288,   -1,   -1,   -1,   -1,  293,   -1,  295,  296,  297,
   -1,   -1,  300,  301,  302,   -1,  304,   -1,   -1,  307,
   -1,  309,  310,  311,  312,   -1,   -1,   -1,  316,  317,
  318,   -1,   -1,  321,  322,  323,   -1,   -1,   -1,   -1,
   -1,   -1,  330,  331,   -1,  333,  334,   -1,  336,  337,
  338,   -1,   -1,   -1,  342,   -1,   -1,   -1,   -1,   -1,
   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  362,   -1,   -1,   -1,   -1,   -1,
  368,  369,  370,   -1,   -1,  257,   -1,   -1,   -1,  261,
  378,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  272,   -1,   -1,   -1,    0,  277,   -1,   -1,   -1,  281,
   -1,   -1,  284,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  296,  297,   -1,   -1,  257,  301,
  302,  419,  261,   -1,   -1,  307,   -1,  309,  310,  311,
  312,   -1,   -1,  272,   -1,  317,   -1,    0,  277,  321,
   -1,  323,  281,   -1,   -1,  284,   -1,   -1,   -1,   -1,
   -1,  333,   -1,   -1,  336,   -1,  338,  296,  297,   -1,
  342,   -1,  301,  302,   -1,   -1,   -1,   -1,  307,   -1,
  309,  310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1,
  362,   -1,  321,   -1,  323,   -1,   -1,  369,  370,   -1,
   -1,   -1,   -1,   -1,  333,   -1,   -1,  336,  257,  338,
    0,   -1,  261,  342,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  272,   -1,   -1,   -1,   -1,  277,   -1,
   -1,   -1,  281,  362,   -1,  284,   -1,   -1,   -1,   -1,
   -1,  370,   -1,   -1,   -1,   -1,   -1,  296,  297,   -1,
   -1,   -1,  301,  302,   -1,  257,   -1,   -1,  307,  261,
  309,  310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1,
  272,   -1,  321,   -1,  323,  277,   -1,   -1,   -1,  281,
   -1,   -1,  284,   -1,  333,   -1,   -1,  336,   -1,  338,
   -1,   -1,   -1,  342,  296,  297,   -1,   -1,   -1,  301,
  302,   -1,   -1,   -1,   -1,  307,   -1,  309,  310,  311,
  312,   -1,   -1,  362,   -1,  317,   -1,   -1,  257,  321,
   -1,  323,  261,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  333,   -1,  272,  336,   -1,  338,   -1,  277,   -1,
  342,   -1,  281,   -1,   -1,  284,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  296,  297,   -1,
  362,  257,  301,  302,   -1,  261,   -1,   -1,  307,   -1,
  309,  310,  311,  312,   -1,   -1,  272,   -1,  317,   -1,
   -1,  277,  321,   -1,  323,  281,   -1,   -1,  284,   -1,
   -1,   -1,   -1,   -1,  333,   -1,   -1,  336,   -1,  338,
  296,  297,   -1,  342,  257,  301,  302,   -1,  261,   -1,
   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,  272,
   -1,  317,   -1,  362,  277,  321,   -1,  323,  281,   -1,
   -1,  284,   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,
  336,   -1,  338,  296,  297,   -1,  342,   -1,  301,  302,
   -1,   -1,   -1,   -1,  307,   -1,  309,  310,  311,  312,
   -1,   -1,   -1,   -1,  317,   -1,  362,  257,  321,   -1,
  323,  261,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  333,   -1,  272,  336,   -1,  338,   -1,  277,   -1,  342,
   -1,  281,   -1,   -1,  284,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  296,  297,   -1,  362,
   -1,  301,  302,   -1,   -1,   -1,   -1,  307,   -1,  309,
  310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1,   -1,
   -1,  321,   -1,  323,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  333,   -1,  256,  336,   -1,  338,   -1,
   -1,   -1,  342,  264,  265,  266,  267,   -1,   -1,  270,
  271,   -1,  273,  274,  275,  276,  277,  278,  279,   -1,
   -1,   -1,  362,   -1,  285,   -1,  287,  288,  289,  290,
  291,  292,   -1,   -1,  295,   -1,   -1,   -1,  299,  300,
   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  314,   -1,  316,   -1,  318,  319,   -1,
   -1,  322,   -1,  324,  325,  326,  327,  328,  329,  330,
  331,  332,  333,  334,  335,   -1,  337,   -1,   -1,  340,
  341,   -1,   -1,  344,  345,  256,   -1,   -1,   -1,  261,
   -1,  262,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,
  361,  362,  363,   -1,   -1,   -1,   -1,  368,   -1,   -1,
   -1,  372,  284,   -1,   -1,   -1,  377,  378,  379,  380,
  381,   -1,   -1,   -1,  385,  297,  387,  298,   -1,   -1,
  302,   -1,  393,  394,   -1,  307,   -1,  309,  310,  311,
  312,   -1,   -1,   -1,   -1,  317,   -1,   -1,   -1,  321,
   -1,   -1,   -1,  325,   -1,   -1,   -1,  418,  419,  420,
  421,  333,   -1,   -1,  336,   -1,  338,   -1,  339,  430,
   -1,   -1,   -1,  344,  256,  346,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,  357,   -1,   -1,   -1,
  362,   -1,  363,  364,   -1,   -1,   -1,   -1,  369,  370,
  371,  372,  373,  374,  375,  376,  377,   -1,  379,  380,
   -1,  382,  383,  384,  385,  386,  387,  388,  389,  390,
  391,   -1,  393,  394,  395,  396,  397,  398,  399,  400,
  401,  402,  403,  404,  405,  406,  407,  408,  409,  410,
  411,  412,  413,  414,  415,   -1,  256,  419,  419,   -1,
  421,  422,  262,  424,   -1,   -1,   -1,  339,   -1,  430,
   -1,   -1,  344,   -1,  346,  347,  348,  349,  350,  351,
  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  369,  298,  371,
   -1,  373,   -1,  375,  376,  377,   -1,   -1,   -1,   -1,
   -1,  383,  384,  385,  386,   -1,   -1,   -1,  390,  391,
   -1,   -1,   -1,  395,  396,  397,  398,  399,  400,  401,
  402,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  339,
   -1,   -1,  414,   -1,  344,   -1,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,  357,  430,   -1,
   -1,   -1,   -1,  363,  364,   -1,   -1,   -1,   -1,  369,
  370,  371,  372,  373,  374,  375,  376,  377,   -1,  379,
  380,   -1,  382,  383,  384,  385,  386,  387,  388,  389,
  390,  391,   -1,  393,  394,  395,  396,  397,  398,  399,
  400,  401,  402,  403,  404,  405,  406,  407,  408,  409,
  410,  411,  412,  413,  414,  415,  256,  256,   -1,  419,
   -1,  421,  262,   -1,  424,   -1,  265,   -1,  267,   -1,
  430,  270,   -1,   -1,   -1,   -1,  275,   -1,   -1,   -1,
  279,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  288,
   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,  298,   -1,
   -1,  300,   -1,   -1,   -1,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,
   -1,   -1,   -1,  322,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  330,  331,   -1,   -1,  334,   -1,   -1,  337,  339,
   -1,   -1,   -1,   -1,  344,   -1,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,  357,   -1,   -1,
   -1,   -1,   -1,  363,  364,   -1,   -1,   -1,   -1,  369,
  370,  371,  372,  373,  374,  375,  376,  377,   -1,  379,
  380,   -1,  382,  383,  384,  385,  386,  387,  388,  389,
  390,  391,   -1,  393,  394,  395,  396,  397,  398,  399,
  400,  401,  402,  403,  404,  405,  406,  407,  408,  409,
  410,  411,  412,  413,  414,   -1,  256,  256,   -1,  419,
  419,  421,  262,   -1,  424,   -1,  265,   -1,  267,   -1,
  430,  270,   -1,   -1,   -1,   -1,  275,   -1,   -1,   -1,
  279,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  288,
   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,  298,   -1,
   -1,  300,   -1,   -1,   -1,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,
   -1,   -1,   -1,  322,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  330,  331,   -1,   -1,  334,   -1,   -1,  337,  339,
   -1,   -1,   -1,   -1,  344,   -1,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,
   -1,   -1,   -1,  363,  364,   -1,   -1,   -1,  368,  369,
  370,  371,  372,  373,  374,  375,  376,  377,   -1,  379,
  380,   -1,  382,  383,  384,  385,  386,  387,  388,  389,
  390,  391,   -1,  393,  394,  395,  396,  397,  398,  399,
  400,  401,  402,  403,  404,  405,  406,  407,  408,  409,
  410,  411,  412,  413,  414,   -1,  256,   -1,   -1,  419,
  419,  421,  262,   -1,   -1,  261,   -1,   -1,   -1,   -1,
  430,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  284,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  298,   -1,
   -1,  297,   -1,   -1,   -1,   -1,  302,   -1,   -1,   -1,
   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,   -1,
   -1,  317,   -1,   -1,   -1,  321,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  333,   -1,  339,
  336,   -1,  338,   -1,  344,   -1,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,
   -1,   -1,   -1,  363,  364,   -1,  362,   -1,  368,  369,
   -1,  371,  372,  373,  374,  375,  376,  377,   -1,  379,
  380,   -1,  382,  383,  384,  385,  386,  387,  388,  389,
  390,  391,   -1,  393,  394,  395,  396,  397,  398,  399,
  400,  401,  402,  403,  404,  405,  406,  407,  408,  409,
  410,  411,  412,  413,  414,   -1,  256,   -1,   -1,  419,
  261,  421,  262,  419,  424,   -1,   -1,   -1,   -1,   -1,
  430,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  284,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  297,   -1,  298,   -1,
   -1,  302,   -1,   -1,  305,   -1,  307,   -1,  309,  310,
  311,  312,   -1,   -1,   -1,   -1,  317,   -1,   -1,   -1,
  321,   -1,   -1,   -1,  325,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  333,   -1,   -1,  336,   -1,  338,   -1,  339,
   -1,   -1,   -1,   -1,  344,   -1,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,
   -1,  362,   -1,  363,  364,   -1,   -1,   -1,  369,  369,
   -1,  371,  372,  373,  374,  375,  376,  377,   -1,  379,
  380,   -1,  382,  383,  384,  385,  386,  387,  388,  389,
  390,  391,   -1,  393,  394,  395,  396,  397,  398,  399,
  400,  401,  402,  403,  404,  405,  406,  407,  408,  409,
  410,  411,  412,  413,  414,   -1,  256,   -1,  419,  419,
  261,  421,  262,   -1,  424,   -1,   -1,   -1,   -1,   -1,
  430,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  284,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  297,   -1,  298,   -1,
   -1,  302,   -1,   -1,  305,   -1,  307,   -1,  309,  310,
  311,  312,   -1,   -1,   -1,   -1,  317,   -1,   -1,   -1,
  321,   -1,   -1,   -1,  325,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  333,   -1,   -1,  336,   -1,  338,   -1,  339,
   -1,   -1,   -1,   -1,  344,   -1,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,
   -1,  362,   -1,  363,  364,   -1,   -1,   -1,  369,  369,
   -1,  371,  372,  373,  374,  375,  376,  377,   -1,  379,
  380,   -1,  382,  383,  384,  385,  386,  387,  388,  389,
  390,  391,   -1,  393,  394,  395,  396,  397,  398,  399,
  400,  401,  402,  403,  404,  405,  406,  407,  408,  409,
  410,  411,  412,  413,  414,   -1,  256,   -1,  419,  419,
   -1,  421,  262,   -1,  424,   -1,  265,   -1,  267,   -1,
  430,  270,   -1,  272,  273,   -1,  275,   -1,  277,   -1,
  279,   -1,  281,  282,  283,   -1,   -1,   -1,  287,  288,
   -1,   -1,   -1,   -1,  293,   -1,  295,  296,  298,   -1,
   -1,  300,   -1,   -1,   -1,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,
   -1,   -1,   -1,  322,  323,   -1,   -1,   -1,   -1,   -1,
   -1,  330,  331,   -1,   -1,  334,   -1,   -1,  337,  339,
   -1,   -1,   -1,  342,  344,   -1,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,
   -1,   -1,   -1,  363,  364,   -1,   -1,   -1,   -1,  369,
   -1,  371,  372,  373,  374,  375,  376,  377,   -1,  379,
  380,   -1,  382,  383,  384,  385,  386,  387,  388,  389,
  390,  391,   -1,  393,  394,  395,  396,  397,  398,  399,
  400,  401,  402,  403,  404,  405,  406,  407,  408,  409,
  410,  411,  412,  413,  414,   -1,  256,   -1,   -1,  419,
  419,  421,  262,   -1,  424,   -1,  265,   -1,  267,   -1,
  430,  270,   -1,   -1,  273,   -1,  275,   -1,  277,   -1,
  279,   -1,  281,  282,  283,   -1,   -1,   -1,  287,  288,
   -1,   -1,   -1,   -1,  293,   -1,  295,   -1,  298,   -1,
   -1,  300,   -1,   -1,   -1,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,
  256,   -1,   -1,  322,   -1,   -1,  262,   -1,   -1,   -1,
  266,  330,  331,   -1,   -1,  334,   -1,   -1,  337,  339,
   -1,   -1,   -1,  342,  344,   -1,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,
   -1,   -1,  298,  363,   -1,   -1,   -1,   -1,   -1,  369,
   -1,  371,   -1,  373,   -1,  375,  376,  377,  314,  379,
  380,   -1,  382,  383,  384,  385,  386,  387,  388,  389,
  390,  391,   -1,   -1,   -1,  395,  396,  397,  398,  399,
  400,  401,  402,  403,  404,  405,  406,  407,  408,  409,
  410,  411,  412,   -1,  414,  256,   -1,   -1,   -1,  419,
  419,  357,   -1,   -1,   -1,   -1,   -1,  363,  364,   -1,
  430,   -1,   -1,  369,  370,  371,  372,  373,  374,  375,
  376,  377,   -1,  379,  380,  285,  382,  383,  384,  385,
  386,  387,  388,  389,  390,  391,   -1,  393,  394,  395,
  396,  397,  398,  399,  400,  401,  402,  403,  404,  405,
  406,  407,  408,  409,  410,  411,  412,  413,  414,   -1,
  256,   -1,   -1,  419,   -1,  421,  262,  327,  424,   -1,
   -1,   -1,   -1,   -1,  430,   -1,   -1,   -1,  339,   -1,
   -1,   -1,   -1,  344,   -1,  346,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,
   -1,   -1,  298,   -1,   -1,   -1,   -1,   -1,  369,   -1,
  371,   -1,  373,   -1,  375,  376,  377,   -1,  378,  379,
  380,  381,   -1,  383,  384,  385,  386,  387,  388,  389,
  390,   -1,   -1,  393,  394,  395,  396,  397,  398,  399,
  400,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,   -1,
  346,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,   -1,   -1,   -1,   -1,  256,   -1,  363,  364,  430,
   -1,  262,   -1,  369,  370,  371,  372,  373,  374,  375,
  376,  377,   -1,  379,  380,   -1,   -1,  383,  384,  385,
  386,   -1,   -1,   -1,  390,  391,   -1,  393,  394,  395,
  396,  397,  398,  399,  400,  401,  402,  298,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  413,  414,   -1,
   -1,   -1,   -1,  419,  256,  421,   -1,   -1,  424,   -1,
  262,   -1,   -1,   -1,  430,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  339,   -1,
   -1,   -1,   -1,  344,   -1,  346,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,  298,   -1,   -1,   -1,
   -1,   -1,  363,  364,   -1,   -1,   -1,   -1,  369,   -1,
  371,  372,  373,  374,  375,  376,  377,   -1,  379,  380,
   -1,   -1,  383,  384,  385,  386,   -1,   -1,   -1,  390,
  391,   -1,  393,  394,  395,  396,  397,  398,  399,  400,
  401,  402,   -1,  256,   -1,   -1,   -1,   -1,   -1,  262,
   -1,   -1,  413,  414,   -1,   -1,   -1,   -1,  419,   -1,
  421,  363,  364,  424,   -1,   -1,   -1,  369,  370,  430,
  372,  373,  374,  375,   -1,  377,   -1,  379,  380,   -1,
  382,  383,  384,  385,  386,  298,  388,  389,  390,  391,
   -1,  393,  394,  395,  396,  397,  398,  399,  400,  401,
  402,  403,  404,  405,  406,  407,  408,  409,  410,  411,
  412,  413,  414,   -1,   -1,   -1,   -1,  419,   -1,  421,
   -1,   -1,  424,   -1,   -1,   -1,  339,   -1,  430,   -1,
   -1,  344,   -1,  346,  347,  348,  349,  350,  351,  352,
  353,  354,  355,  356,   -1,   -1,   -1,   -1,  256,   -1,
  363,   -1,   -1,   -1,  262,   -1,  369,  370,  371,   -1,
  373,   -1,  375,  376,  377,   -1,  379,  380,   -1,   -1,
  383,  384,  385,  386,   -1,   -1,   -1,  390,  391,   -1,
   -1,   -1,  395,  396,  397,  398,  399,  400,  401,  402,
  298,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  414,   -1,   -1,   -1,   -1,  419,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  430,   -1,   -1,
  256,   -1,   -1,   -1,   -1,   -1,  262,   -1,   -1,   -1,
   -1,  339,   -1,   -1,   -1,   -1,  344,   -1,  346,  347,
  348,  349,  350,  351,  352,  353,  354,  355,  356,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  369,  298,  371,   -1,  373,   -1,  375,  376,  377,
   -1,  379,  380,   -1,   -1,  383,  384,  385,  386,  387,
  388,  389,  390,  391,   -1,   -1,   -1,  395,  396,  397,
  398,  399,  400,  401,  402,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  339,   -1,   -1,  414,   -1,  344,   -1,
  346,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,   -1,  430,   -1,   -1,  256,   -1,  363,   -1,   -1,
   -1,  262,   -1,  369,   -1,  371,   -1,  373,   -1,  375,
  376,  377,   -1,  379,  380,   -1,   -1,  383,  384,  385,
  386,   -1,   -1,   -1,  390,  391,   -1,   -1,   -1,  395,
  396,  397,  398,  399,  400,  401,  402,  298,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  414,   -1,
   -1,   -1,   -1,  419,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  430,   -1,   -1,  256,   -1,   -1,
   -1,   -1,   -1,  262,   -1,   -1,   -1,   -1,  339,   -1,
   -1,   -1,   -1,  344,   -1,  346,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  369,  298,
  371,   -1,  373,   -1,  375,  376,  377,   -1,  379,  380,
   -1,   -1,  383,  384,  385,  386,   -1,   -1,   -1,  390,
  391,   -1,   -1,   -1,  395,  396,  397,  398,  399,  400,
  401,  402,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  339,   -1,   -1,  414,   -1,  344,   -1,  346,  347,  348,
  349,  350,  351,  352,  353,  354,  355,  356,   -1,  430,
   -1,   -1,  256,   -1,   -1,   -1,   -1,   -1,  262,   -1,
  369,   -1,  371,   -1,  373,   -1,  375,  376,  377,   -1,
  379,  380,   -1,   -1,  383,  384,  385,  386,   -1,   -1,
   -1,  390,  391,   -1,   -1,   -1,  395,  396,  397,  398,
  399,  400,  401,  402,  298,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  414,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  430,   -1,   -1,  256,   -1,   -1,   -1,   -1,   -1,
  262,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,
  344,   -1,  346,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  369,  298,  371,   -1,  373,
   -1,  375,  376,  377,   -1,  379,  380,   -1,   -1,  383,
  384,  385,  386,   -1,   -1,   -1,  390,  391,   -1,   -1,
   -1,  395,  396,  397,  398,  399,  400,  401,  402,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,
  414,   -1,  344,   -1,  346,  347,  348,  349,  350,  351,
  352,  353,  354,  355,  356,   -1,  430,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  369,   -1,  371,
   -1,  373,   -1,  375,  376,  377,   -1,  379,  380,   -1,
   -1,  383,  384,  385,  386,   -1,   -1,   -1,  390,  391,
   -1,   -1,   -1,  395,  396,  397,  398,  399,  400,  401,
  402,   -1,  256,   -1,  256,   -1,   -1,   -1,   -1,   -1,
  264,  265,  414,  267,   -1,   -1,  270,  271,   -1,   -1,
   -1,  275,  276,  277,   -1,  279,   -1,   -1,  430,   -1,
   -1,  285,   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,
   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,  302,  303,
  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,
   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,
  334,   -1,   -1,   -1,   -1,   -1,   -1,  339,   -1,  256,
   -1,   -1,  344,   -1,  346,  347,  348,  349,  350,  351,
  352,  353,  354,  355,  356,  359,  360,  361,  362,  363,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  369,  372,  371,
   -1,  373,   -1,  375,  376,  377,   -1,   -1,   -1,   -1,
   -1,  383,  384,  385,  386,   -1,   -1,   -1,  390,  391,
   -1,   -1,   -1,  395,  396,  397,  398,  399,  400,  401,
  402,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,
   -1,   -1,  414,   -1,  418,  419,   -1,   -1,   -1,   -1,
   -1,   -1,  339,   -1,   -1,  429,  430,  344,  430,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  369,   -1,  371,   -1,  373,   -1,  375,  376,
  377,   -1,   -1,   -1,   -1,   -1,  383,  384,  385,  386,
   -1,   -1,   -1,  390,  391,   -1,   -1,  256,  395,  396,
  397,  398,  399,  400,  401,  402,   -1,   -1,   -1,   -1,
   -1,  339,   -1,   -1,   -1,   -1,  344,  414,  346,  347,
  348,  349,  350,  351,  352,  353,  354,  355,  356,   -1,
   -1,   -1,   -1,  430,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  369,   -1,  371,   -1,  373,   -1,  375,  376,  377,
   -1,   -1,   -1,   -1,   -1,  383,  384,  385,  386,   -1,
   -1,   -1,  390,  391,   -1,   -1,  256,   -1,   -1,  397,
  398,  399,  400,  401,  402,   -1,   -1,   -1,   -1,   -1,
  339,   -1,   -1,   -1,   -1,  344,  414,  346,  347,  348,
  349,  350,  351,  352,  353,  354,  355,  356,   -1,   -1,
   -1,   -1,  430,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  369,   -1,  371,   -1,  373,   -1,  375,  376,  377,   -1,
   -1,   -1,   -1,   -1,  383,  384,  385,  386,   -1,   -1,
   -1,  390,  391,   -1,   -1,  256,   -1,   -1,  397,  398,
  399,  400,  401,  402,   -1,   -1,   -1,   -1,   -1,  339,
   -1,   -1,   -1,   -1,  344,  414,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,
   -1,  430,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  369,
   -1,  371,   -1,  373,   -1,  375,  376,  377,   -1,   -1,
   -1,   -1,   -1,  383,  384,  385,  386,   -1,   -1,   -1,
  390,  391,   -1,   -1,  256,   -1,   -1,  397,  398,  399,
  400,  401,  402,   -1,   -1,   -1,   -1,   -1,  339,   -1,
   -1,   -1,   -1,  344,  414,  346,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,
  430,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  369,   -1,
  371,   -1,  373,   -1,  375,  376,  377,   -1,   -1,   -1,
   -1,   -1,  383,  384,  385,  386,  256,   -1,   -1,  390,
  391,   -1,  262,   -1,   -1,   -1,  397,  398,  399,  400,
  401,  402,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,
   -1,   -1,  344,  414,  346,  347,  348,  349,  350,  351,
  352,  353,  354,  355,  356,   -1,   -1,   -1,  298,  430,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  369,   -1,  371,
   -1,  373,   -1,  375,  376,  377,   -1,   -1,   -1,   -1,
   -1,  383,  384,  385,  386,   -1,   -1,   -1,  390,  391,
   -1,   -1,   -1,   -1,   -1,  397,  398,  399,  400,  401,
  402,   -1,   -1,  256,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  414,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  364,   -1,   -1,   -1,  430,  369,
   -1,   -1,  372,   -1,  374,  375,   -1,   -1,   -1,  379,
  380,   -1,   -1,  383,  384,  385,  386,  387,  388,  389,
  390,  391,   -1,  393,  394,  395,  396,  397,  398,  399,
  400,  401,  402,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  256,  413,  414,   -1,   -1,   -1,   -1,   -1,
   -1,  421,   -1,   -1,  424,   -1,  339,   -1,   -1,   -1,
  430,  344,   -1,  346,  347,  348,  349,  350,  351,  352,
  353,  354,  355,  356,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  369,   -1,  371,   -1,
  373,   -1,  375,  376,  377,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  385,  386,   -1,   -1,   -1,  390,  391,   -1,
   -1,  256,   -1,   -1,   -1,   -1,  399,  400,  401,  402,
   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,
  344,  414,  346,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,   -1,   -1,   -1,   -1,  430,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  369,   -1,  371,   -1,  373,
   -1,  375,  376,  377,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  385,  386,   -1,   -1,   -1,  390,  391,   -1,   -1,
  256,   -1,   -1,   -1,   -1,  399,  400,  401,  402,   -1,
   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,
  414,  346,  347,  348,  349,  350,  351,  352,  353,  354,
  355,  356,   -1,   -1,   -1,   -1,  430,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  369,   -1,  371,   -1,  373,   -1,
  375,  376,  377,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  385,  386,   -1,   -1,   -1,  390,  391,   -1,   -1,  256,
   -1,   -1,   -1,   -1,  399,  400,  401,  402,   -1,   -1,
   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,  414,
  346,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,   -1,   -1,   -1,   -1,  430,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  369,   -1,  371,   -1,  373,   -1,  375,
  376,  377,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  385,
  386,   -1,   -1,   -1,  390,  391,   -1,   -1,  256,   -1,
   -1,   -1,   -1,   -1,   -1,  401,  402,   -1,   -1,   -1,
   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,  414,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
   -1,   -1,   -1,   -1,  430,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  369,   -1,  371,   -1,  373,   -1,  375,  376,
  377,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  385,  386,
   -1,   -1,   -1,  390,  391,   -1,   -1,  256,   -1,   -1,
   -1,   -1,   -1,   -1,  401,  402,   -1,   -1,   -1,   -1,
   -1,  339,   -1,   -1,   -1,   -1,  344,  414,  346,  347,
  348,  349,  350,  351,  352,  353,  354,  355,  356,   -1,
   -1,   -1,   -1,  430,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  369,   -1,  371,   -1,  373,   -1,  375,  376,  377,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  386,   -1,
   -1,   -1,  390,  391,   -1,   -1,  256,   -1,   -1,   -1,
   -1,   -1,   -1,  401,  402,   -1,   -1,   -1,   -1,   -1,
  339,   -1,   -1,   -1,   -1,  344,  414,  346,  347,  348,
  349,  350,  351,  352,  353,  354,  355,  356,   -1,   -1,
   -1,   -1,  430,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  369,   -1,  371,   -1,  373,   -1,  375,  376,  377,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  386,   -1,   -1,
   -1,  390,  391,   -1,   -1,  256,   -1,   -1,   -1,   -1,
   -1,   -1,  401,  402,   -1,   -1,   -1,   -1,   -1,  339,
   -1,   -1,   -1,   -1,  344,  414,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,
   -1,  430,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  369,
   -1,  371,   -1,  373,   -1,  375,  376,  377,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  386,   -1,   -1,   -1,
   -1,  391,   -1,   -1,  256,   -1,   -1,   -1,   -1,   -1,
   -1,  401,  402,   -1,   -1,   -1,   -1,   -1,  339,   -1,
   -1,   -1,   -1,  344,  414,  346,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,
  430,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  369,   -1,
  371,   -1,  373,   -1,  375,  376,  377,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  386,   -1,   -1,   -1,   -1,
  391,   -1,   -1,  256,   -1,   -1,   -1,   -1,   -1,   -1,
  401,  402,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,
   -1,   -1,  344,  414,  346,  347,  348,  349,  350,  351,
  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,  430,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  369,   -1,  371,
   -1,  373,   -1,  375,  376,  377,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  391,
   -1,   -1,  256,   -1,   -1,   -1,   -1,   -1,   -1,  401,
  402,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,
   -1,  344,  414,  346,  347,  348,  349,  350,  351,  352,
  353,  354,  355,  356,   -1,   -1,   -1,   -1,  430,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  369,   -1,  371,   -1,
  373,   -1,  375,  376,  377,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  391,   -1,
   -1,  256,   -1,   -1,   -1,   -1,   -1,   -1,  401,  402,
   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,
  344,  414,  346,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,   -1,   -1,   -1,   -1,  430,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  369,   -1,  371,   -1,  373,
   -1,  375,  376,  377,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  391,   -1,   -1,
   -1,  262,   -1,   -1,   -1,  266,   -1,   -1,  402,   -1,
   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,
  414,  346,  347,  348,  349,  350,  351,  352,  353,  354,
  355,  356,   -1,   -1,   -1,   -1,  430,  298,   -1,   -1,
   -1,   -1,   -1,   -1,  369,   -1,  371,   -1,  373,   -1,
  375,  376,  377,  314,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  391,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  402,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  414,
   -1,   -1,   -1,   -1,   -1,   -1,  357,   -1,   -1,   -1,
   -1,   -1,  363,  364,   -1,  430,   -1,   -1,  369,  370,
   -1,  372,   -1,  374,   -1,  376,  377,   -1,  379,  380,
   -1,  382,  383,  384,  385,  386,  387,  388,  389,  390,
  391,   -1,  393,  394,  395,  396,  397,  398,  399,  400,
  401,  402,  403,  404,  405,  406,  407,  408,  409,  410,
  411,  412,  413,  414,   -1,   -1,  256,   -1,  419,   -1,
  421,   -1,   -1,  424,  264,  265,  266,  267,  268,  430,
  270,  271,   -1,  273,  274,  275,  276,  277,  278,  279,
   -1,   -1,   -1,   -1,   -1,  285,   -1,  287,  288,  289,
  290,  291,  292,   -1,   -1,  295,   -1,   -1,   -1,  299,
  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  314,   -1,  316,   -1,  318,  319,
   -1,   -1,  322,   -1,  324,  325,  326,  327,  328,  329,
  330,  331,  332,  333,  334,  335,   -1,  337,   -1,   -1,
  340,  341,   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,
  360,  361,  362,  363,   -1,   -1,   -1,   -1,  368,   -1,
   -1,   -1,  372,   -1,   -1,   -1,   -1,  377,  378,  379,
  380,  381,   -1,   -1,   -1,  385,   -1,  387,   -1,   -1,
   -1,   -1,   -1,  393,  394,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,  418,  419,
  420,  421,   -1,  423,  264,  265,  266,  267,   -1,   -1,
  270,  271,   -1,  273,  274,  275,  276,  277,  278,  279,
   -1,   -1,   -1,   -1,   -1,  285,   -1,  287,  288,  289,
  290,  291,  292,   -1,   -1,  295,   -1,   -1,   -1,  299,
  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  314,   -1,  316,   -1,  318,  319,
   -1,   -1,  322,   -1,  324,  325,  326,  327,  328,  329,
  330,  331,  332,  333,  334,  335,   -1,  337,   -1,   -1,
  340,  341,   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,
  360,  361,  362,  363,   -1,   -1,   -1,   -1,  368,   -1,
   -1,   -1,  372,   -1,   -1,   -1,   -1,  377,  378,  379,
  380,  381,   -1,   -1,   -1,  385,   -1,  387,   -1,   -1,
   -1,   -1,   -1,  393,  394,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  256,   -1,   -1,   -1,  418,  419,
  420,  421,  264,  265,  266,  267,   -1,   -1,  270,  271,
   -1,  273,  274,  275,  276,  277,  278,  279,   -1,   -1,
   -1,   -1,   -1,  285,   -1,  287,  288,  289,  290,  291,
  292,   -1,   -1,  295,   -1,   -1,   -1,  299,  300,   -1,
  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  314,   -1,  316,   -1,  318,  319,   -1,   -1,
  322,   -1,  324,  325,  326,  327,  328,  329,  330,  331,
  332,  333,  334,  335,   -1,  337,   -1,   -1,  340,  341,
   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,
  362,  363,   -1,   -1,   -1,   -1,  368,   -1,   -1,   -1,
  372,   -1,   -1,   -1,   -1,  377,  378,  379,  380,  381,
   -1,   -1,   -1,  385,   -1,  387,   -1,   -1,   -1,   -1,
   -1,  393,  394,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  256,   -1,   -1,   -1,  418,  419,  420,  421,
  264,  265,  266,  267,   -1,   -1,  270,  271,   -1,  273,
  274,  275,  276,  277,  278,  279,   -1,   -1,   -1,   -1,
   -1,  285,   -1,  287,  288,  289,  290,  291,  292,   -1,
   -1,  295,   -1,   -1,   -1,  299,  300,   -1,  302,  303,
  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  314,   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,
  324,  325,  326,  327,  328,  329,  330,  331,  332,  333,
  334,  335,   -1,  337,   -1,   -1,  340,  341,   -1,   -1,
  344,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,
   -1,   -1,   -1,   -1,  368,   -1,   -1,   -1,  372,   -1,
   -1,   -1,   -1,  377,  378,  379,  380,  381,   -1,   -1,
   -1,  385,   -1,  387,   -1,   -1,   -1,   -1,   -1,  393,
  394,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  256,   -1,   -1,   -1,  418,  419,  420,  421,  264,  265,
  266,  267,   -1,   -1,  270,  271,   -1,  273,  274,  275,
  276,  277,  278,  279,   -1,   -1,   -1,   -1,   -1,  285,
   -1,  287,  288,  289,  290,  291,  292,   -1,   -1,  295,
   -1,   -1,   -1,  299,  300,   -1,  302,  303,  304,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  314,   -1,
  316,   -1,  318,  319,   -1,   -1,  322,   -1,  324,  325,
  326,  327,  328,  329,  330,  331,  332,  333,  334,  335,
   -1,  337,   -1,   -1,  340,  341,   -1,   -1,  344,  345,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,
   -1,   -1,  368,   -1,   -1,   -1,  372,   -1,   -1,   -1,
   -1,  377,  378,  379,  380,  381,   -1,   -1,   -1,  385,
   -1,  387,   -1,   -1,   -1,   -1,   -1,  393,  394,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,
   -1,   -1,  418,  419,  420,  421,  264,  265,   -1,  267,
   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,
   -1,  279,   -1,   -1,  265,   -1,  267,  285,   -1,  270,
  288,   -1,   -1,   -1,  275,   -1,   -1,  295,  279,   -1,
   -1,   -1,  300,   -1,  302,  303,  304,  288,  306,   -1,
   -1,   -1,   -1,   -1,  295,  313,   -1,   -1,  316,  300,
  318,  319,   -1,  304,  322,   -1,   -1,  325,   -1,  327,
   -1,  329,  330,  331,  332,  316,  334,  318,   -1,   -1,
   -1,  322,   -1,  341,   -1,   -1,  344,  345,   -1,  330,
  331,   -1,   -1,  334,   -1,   -1,  337,   -1,   -1,   -1,
   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  372,   -1,   -1,  375,   -1,   -1,
  378,  379,  380,  381,   -1,   -1,   -1,  385,   -1,  387,
   -1,   -1,  373,   -1,   -1,  393,  394,   -1,   -1,   -1,
   -1,   -1,   -1,  264,  265,   -1,  267,   -1,   -1,  270,
  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,
  418,  419,  420,  421,  285,   -1,   -1,  288,   -1,   -1,
   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,  419,  300,
   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,   -1,
   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,
  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,
  341,   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,
  361,  362,  363,   -1,   -1,   -1,   -1,  368,  369,   -1,
   -1,  372,   -1,   -1,   -1,   -1,   -1,  378,  379,  380,
  381,   -1,   -1,   -1,  385,   -1,  387,   -1,   -1,   -1,
   -1,   -1,  393,  394,   -1,   -1,   -1,   -1,   -1,   -1,
  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,
   -1,  275,  276,  277,   -1,  279,   -1,  418,  419,  420,
  421,  285,   -1,  424,  288,   -1,   -1,   -1,  429,   -1,
   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,  302,  303,
  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,
   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,
  334,   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,
  344,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,
   -1,   -1,   -1,   -1,  368,   -1,   -1,   -1,  372,   -1,
   -1,   -1,   -1,   -1,  378,  379,  380,  381,   -1,   -1,
   -1,  385,   -1,  387,   -1,   -1,   -1,   -1,   -1,  393,
  394,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  256,  418,  419,  420,  421,   -1,   -1,
  424,  264,  265,   -1,  267,  429,   -1,  270,  271,   -1,
   -1,   -1,  275,  276,  277,   -1,  279,   -1,   -1,  265,
   -1,  267,  285,   -1,  270,  288,   -1,   -1,   -1,  275,
   -1,   -1,  295,  279,   -1,   -1,   -1,  300,   -1,  302,
  303,  304,  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,
   -1,   -1,   -1,  316,  300,  318,  319,   -1,  304,  322,
   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,
  316,  334,  318,   -1,   -1,   -1,  322,   -1,  341,   -1,
   -1,  344,  345,   -1,  330,  331,   -1,   -1,  334,   -1,
   -1,  337,   -1,   -1,   -1,   -1,  359,  360,  361,  362,
  363,   -1,   -1,   -1,   -1,  368,  369,   -1,   -1,  372,
   -1,   -1,   -1,   -1,   -1,  378,  379,  380,  381,   -1,
   -1,   -1,  385,   -1,  387,  371,   -1,   -1,   -1,   -1,
  393,  394,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  256,   -1,   -1,   -1,  418,  419,  420,  421,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,
  275,  276,  277,  419,  279,   -1,   -1,  265,   -1,  267,
  285,   -1,  270,  288,   -1,   -1,   -1,  275,   -1,   -1,
  295,  279,   -1,   -1,   -1,  300,   -1,  302,  303,  304,
  288,  306,   -1,   -1,   -1,   -1,   -1,  295,  313,   -1,
   -1,  316,  300,  318,  319,   -1,  304,  322,   -1,   -1,
  325,   -1,  327,   -1,  329,  330,  331,  332,  316,  334,
  318,   -1,   -1,   -1,  322,   -1,  341,   -1,   -1,  344,
  345,   -1,  330,  331,   -1,   -1,  334,   -1,   -1,  337,
   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  372,   -1,   -1,
   -1,   -1,   -1,  378,  379,  380,  381,   -1,   -1,   -1,
  385,   -1,  387,   -1,   -1,   -1,   -1,   -1,  393,  394,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,
   -1,   -1,   -1,  418,  419,  420,  421,  264,  265,   -1,
  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,
  277,  419,  279,   -1,   -1,  265,   -1,  267,  285,   -1,
  270,  288,   -1,   -1,   -1,  275,   -1,   -1,  295,  279,
   -1,   -1,   -1,  300,   -1,  302,  303,  304,  288,   -1,
   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,  316,
  300,  318,  319,  320,  304,  322,   -1,   -1,  325,   -1,
  327,   -1,  329,  330,  331,  332,  316,  334,  318,   -1,
   -1,   -1,  322,   -1,  341,   -1,   -1,  344,  345,   -1,
  330,  331,   -1,   -1,  334,   -1,   -1,  337,   -1,   -1,
   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,
   -1,  368,   -1,   -1,   -1,  372,   -1,   -1,   -1,   -1,
   -1,  378,  379,  380,  381,   -1,   -1,   -1,  385,   -1,
  387,   -1,   -1,   -1,   -1,   -1,  393,  394,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,   -1,
   -1,  418,  419,  420,  421,  264,  265,   -1,  267,   -1,
   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,  419,
  279,   -1,   -1,   -1,   -1,   -1,  285,   -1,   -1,  288,
   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,
   -1,  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,
  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,
  329,  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,
   -1,   -1,  341,   -1,   -1,  344,  345,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  359,  360,  361,  362,  363,   -1,   -1,   -1,   -1,  368,
   -1,   -1,   -1,  372,   -1,   -1,   -1,   -1,   -1,  378,
  379,  380,  381,   -1,   -1,   -1,  385,   -1,  387,   -1,
   -1,   -1,   -1,   -1,  393,  394,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,  418,
  419,  420,  421,  262,   -1,  264,  265,   -1,  267,   -1,
   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,
  279,   -1,   -1,   -1,   -1,   -1,  285,   -1,   -1,  288,
   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,  298,
   -1,  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,
  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,
  329,  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  343,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  359,  360,  361,  362,  363,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  372,   -1,  374,   -1,   -1,   -1,  378,
  379,  380,  381,  382,   -1,   -1,  385,   -1,  387,  256,
   -1,   -1,   -1,   -1,  393,  394,   -1,  264,  265,   -1,
  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,
  277,   -1,  279,   -1,   -1,   -1,   -1,   -1,  285,  418,
  419,  288,  421,   -1,   -1,   -1,   -1,   -1,  295,   -1,
   -1,   -1,   -1,  300,   -1,  302,  303,  304,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,
   -1,  318,  319,   -1,   -1,  322,   -1,   -1,  325,   -1,
  327,   -1,  329,  330,  331,  332,   -1,  334,   -1,   -1,
   -1,   -1,   -1,   -1,  341,   -1,   -1,  344,  345,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,
   -1,   -1,  369,   -1,   -1,  372,   -1,   -1,   -1,   -1,
   -1,  378,  379,  380,  381,   -1,   -1,   -1,  385,   -1,
  387,   -1,   -1,   -1,   -1,   -1,  393,  394,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,   -1,
   -1,  418,  419,  420,  421,  264,  265,   -1,  267,   -1,
   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,
  279,   -1,   -1,  265,   -1,  267,  285,   -1,  270,  288,
   -1,   -1,   -1,  275,   -1,   -1,  295,  279,   -1,   -1,
   -1,  300,   -1,  302,  303,  304,  288,   -1,   -1,   -1,
   -1,   -1,   -1,  295,   -1,   -1,   -1,  316,  300,  318,
  319,   -1,  304,  322,   -1,   -1,  325,   -1,  327,   -1,
  329,  330,  331,  332,  316,  334,  318,   -1,   -1,   -1,
  322,   -1,  341,   -1,   -1,  344,  345,   -1,  330,  331,
   -1,   -1,  334,   -1,   -1,  337,   -1,   -1,   -1,   -1,
  359,  360,  361,  362,  363,   -1,   -1,   -1,   -1,   -1,
  369,   -1,   -1,  372,   -1,   -1,   -1,   -1,   -1,  378,
  379,  380,  381,   -1,   -1,   -1,  385,   -1,  387,   -1,
   -1,   -1,   -1,   -1,  393,  394,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  256,   -1,   -1,   -1,  418,
  419,  420,  421,  264,  265,   -1,  267,   -1,   -1,  270,
  271,   -1,   -1,   -1,  275,  276,  277,  419,  279,   -1,
   -1,  265,   -1,  267,  285,   -1,  270,  288,   -1,   -1,
   -1,  275,   -1,   -1,  295,  279,   -1,   -1,   -1,  300,
   -1,  302,  303,  304,  288,   -1,   -1,   -1,   -1,   -1,
   -1,  295,   -1,   -1,   -1,  316,  300,  318,  319,   -1,
  304,  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,
  331,  332,  316,  334,  318,   -1,   -1,   -1,  322,   -1,
  341,   -1,   -1,  344,  345,   -1,  330,  331,   -1,   -1,
  334,   -1,   -1,  337,   -1,   -1,   -1,   -1,  359,  360,
  361,  362,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  372,   -1,   -1,   -1,   -1,   -1,  378,  379,  380,
  381,   -1,   -1,   -1,  385,   -1,  387,   -1,   -1,   -1,
   -1,   -1,  393,  394,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  256,   -1,   -1,   -1,  418,  419,  420,
  421,  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,
   -1,   -1,  275,  276,  277,  419,  279,   -1,   -1,   -1,
   -1,   -1,  285,   -1,   -1,  288,   -1,   -1,   -1,   -1,
   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,  302,
  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  316,   -1,  318,  319,   -1,   -1,  322,
   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,
   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,
   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,  362,
  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  372,
   -1,   -1,   -1,   -1,   -1,  378,  379,  380,  381,   -1,
   -1,   -1,  385,   -1,  387,   -1,   -1,   -1,   -1,   -1,
  393,  394,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  256,   -1,  418,  419,  420,  421,  262,
   -1,  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,
   -1,   -1,  275,  276,  277,   -1,  279,   -1,   -1,   -1,
   -1,   -1,  285,   -1,   -1,  288,   -1,   -1,   -1,   -1,
   -1,   -1,  295,   -1,   -1,  298,   -1,  300,   -1,  302,
  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  316,   -1,  318,  319,   -1,   -1,  322,
   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,
   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  343,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,  362,
  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  372,
   -1,  374,   -1,   -1,   -1,  378,  379,  380,  381,   -1,
   -1,   -1,  385,   -1,  387,  256,   -1,   -1,   -1,   -1,
  393,  394,   -1,  264,  265,   -1,  267,   -1,   -1,  270,
  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,
   -1,   -1,   -1,   -1,  285,  418,  419,  288,  421,   -1,
   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,
   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,   -1,
   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,
  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,
  341,   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,
  361,  362,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  372,   -1,   -1,   -1,   -1,   -1,  378,  379,  380,
  381,   -1,   -1,   -1,  385,   -1,  387,   -1,   -1,   -1,
   -1,   -1,  393,  394,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  256,   -1,   -1,   -1,  418,  419,  420,
  421,  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,
   -1,   -1,  275,  276,  277,   -1,  279,   -1,   -1,  265,
   -1,  267,  285,   -1,  270,  288,   -1,   -1,   -1,  275,
   -1,   -1,  295,  279,   -1,   -1,   -1,  300,   -1,  302,
  303,  304,  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,
   -1,   -1,   -1,  316,  300,  318,  319,   -1,  304,  322,
   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,
  316,  334,  318,   -1,   -1,   -1,  322,   -1,  341,   -1,
   -1,  344,  345,   -1,  330,  331,   -1,   -1,  334,   -1,
   -1,  337,   -1,   -1,   -1,   -1,  359,  360,  361,  362,
  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  372,
   -1,   -1,   -1,   -1,   -1,  378,  379,  380,  381,   -1,
   -1,   -1,  385,   -1,  387,   -1,   -1,   -1,   -1,   -1,
  393,  394,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  256,   -1,   -1,   -1,  418,  419,  420,  421,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,
  275,  276,  277,  419,  279,   -1,   -1,  265,   -1,  267,
  285,   -1,  270,  288,   -1,   -1,   -1,  275,   -1,   -1,
  295,  279,   -1,   -1,   -1,  300,   -1,  302,  303,  304,
  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,
   -1,  316,  300,  318,  319,   -1,  304,  322,   -1,   -1,
  325,   -1,  327,   -1,  329,  330,  331,  332,  316,  334,
  318,   -1,   -1,   -1,  322,   -1,  341,   -1,   -1,  344,
  345,   -1,  330,  331,   -1,   -1,  334,   -1,   -1,  337,
   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  372,   -1,   -1,
   -1,   -1,   -1,  378,  379,  380,  381,   -1,   -1,   -1,
  385,   -1,  387,   -1,   -1,   -1,   -1,   -1,  393,  394,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,
   -1,   -1,   -1,  418,  419,  420,  421,  264,  265,   -1,
  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,
  277,  419,  279,   -1,   -1,  265,   -1,  267,  285,   -1,
  270,  288,   -1,   -1,   -1,  275,   -1,   -1,  295,  279,
   -1,   -1,   -1,  300,   -1,  302,  303,  304,  288,   -1,
   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,  316,
  300,  318,  319,   -1,  304,  322,   -1,   -1,  325,   -1,
  327,   -1,  329,  330,  331,  332,  316,  334,  318,   -1,
   -1,   -1,  322,   -1,  341,   -1,   -1,  344,  345,   -1,
  330,  331,   -1,   -1,  334,   -1,   -1,  337,   -1,   -1,
   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  372,   -1,   -1,   -1,   -1,
   -1,  378,  379,  380,  381,   -1,   -1,   -1,  385,   -1,
  387,   -1,   -1,   -1,   -1,   -1,  393,  394,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,   -1,
   -1,  418,  419,  420,  421,  264,  265,   -1,  267,   -1,
   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,  419,
  279,   -1,   -1,   -1,   -1,   -1,  285,   -1,   -1,  288,
   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,
   -1,  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,
  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,
  329,  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,
   -1,   -1,  341,   -1,   -1,  344,  345,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  359,  360,  361,  362,  363,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  372,   -1,   -1,   -1,   -1,   -1,  378,
  379,  380,  381,   -1,   -1,   -1,  385,   -1,  387,   -1,
   -1,   -1,   -1,   -1,  393,  394,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,  418,
  419,  420,  421,  262,   -1,  264,  265,   -1,  267,   -1,
   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,
  279,   -1,   -1,   -1,   -1,   -1,  285,   -1,   -1,  288,
   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,  298,
   -1,  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,
  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,
  329,  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  359,  360,  361,  362,  363,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  372,   -1,  374,   -1,   -1,   -1,  378,
  379,  380,  381,   -1,   -1,   -1,  385,   -1,  387,  256,
   -1,   -1,   -1,   -1,  393,  394,   -1,  264,  265,   -1,
  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,
  277,   -1,  279,   -1,   -1,   -1,   -1,   -1,  285,  418,
  419,  288,  421,   -1,   -1,   -1,   -1,   -1,  295,   -1,
   -1,   -1,   -1,  300,   -1,  302,  303,  304,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,
   -1,  318,  319,   -1,   -1,  322,   -1,   -1,  325,   -1,
  327,   -1,  329,  330,  331,  332,   -1,  334,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  372,   -1,  374,   -1,   -1,
   -1,  378,  379,  380,  381,   -1,   -1,   -1,  385,   -1,
  387,  256,   -1,   -1,   -1,   -1,  393,  394,   -1,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,
  275,  276,  277,   -1,  279,   -1,   -1,   -1,   -1,   -1,
  285,  418,  419,  288,  421,   -1,   -1,   -1,   -1,   -1,
  295,   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,
  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  372,   -1,   -1,
   -1,   -1,   -1,  378,  379,  380,  381,   -1,   -1,   -1,
  385,   -1,  387,  256,   -1,   -1,   -1,   -1,  393,  394,
   -1,  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,
   -1,   -1,  275,  276,  277,   -1,  279,   -1,   -1,   -1,
   -1,   -1,  285,  418,  419,  288,  421,   -1,   -1,   -1,
   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,  302,
  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  316,   -1,  318,  319,   -1,   -1,  322,
   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,
   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,  362,
  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  372,
   -1,   -1,   -1,   -1,   -1,  378,  379,  380,  381,   -1,
   -1,   -1,  385,   -1,  387,  256,   -1,   -1,   -1,   -1,
  393,  394,   -1,  264,  265,   -1,  267,   -1,   -1,  270,
  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,
   -1,   -1,   -1,   -1,  285,  418,  419,  288,  421,   -1,
   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,
   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,   -1,
   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,
  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,
  361,  362,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  372,   -1,   -1,   -1,   -1,   -1,  378,  379,  380,
  381,   -1,   -1,   -1,  385,   -1,  387,  256,   -1,   -1,
   -1,   -1,  393,  394,   -1,  264,  265,   -1,  267,   -1,
   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,
  279,   -1,   -1,   -1,   -1,   -1,  285,  418,  419,  288,
  421,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,
   -1,  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,
  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,
  329,  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  359,  360,  361,  362,  363,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  372,   -1,   -1,   -1,   -1,   -1,  378,
  379,  380,  381,   -1,   -1,   -1,  385,   -1,  387,  256,
   -1,   -1,   -1,   -1,  393,  394,   -1,  264,  265,   -1,
  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,
  277,   -1,  279,   -1,   -1,   -1,   -1,   -1,  285,  418,
  419,  288,  421,   -1,   -1,   -1,   -1,   -1,  295,   -1,
   -1,   -1,   -1,  300,   -1,  302,  303,  304,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,
   -1,  318,  319,   -1,   -1,  322,   -1,   -1,  325,   -1,
  327,   -1,  329,  330,  331,  332,   -1,  334,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  372,   -1,   -1,   -1,   -1,
   -1,  378,  379,  380,  381,   -1,   -1,   -1,  385,   -1,
  387,  256,   -1,   -1,   -1,   -1,  393,  394,   -1,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,
  275,  276,  277,   -1,  279,   -1,   -1,   -1,   -1,   -1,
  285,  418,  419,  288,  421,   -1,   -1,   -1,   -1,   -1,
  295,   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,
  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  372,   -1,   -1,
   -1,   -1,   -1,  378,  379,  380,  381,   -1,   -1,   -1,
  385,   -1,  387,  256,   -1,   -1,   -1,   -1,  393,  394,
   -1,  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,
   -1,   -1,  275,  276,  277,   -1,  279,   -1,   -1,   -1,
   -1,   -1,  285,  418,  419,  288,  421,   -1,   -1,   -1,
   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,  302,
  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  316,   -1,  318,  319,   -1,   -1,  322,
   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,
   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,  362,
  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  372,
   -1,   -1,   -1,   -1,   -1,  378,  379,  380,  381,   -1,
   -1,   -1,  385,   -1,  387,  256,   -1,   -1,   -1,   -1,
  393,  394,   -1,  264,  265,   -1,  267,   -1,   -1,  270,
  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,
   -1,   -1,   -1,   -1,  285,  418,  419,  288,  421,   -1,
   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,
   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,   -1,
   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,
  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,
  361,  362,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  372,   -1,   -1,   -1,   -1,   -1,  378,  379,  380,
  381,   -1,   -1,   -1,  385,   -1,  387,  256,   -1,   -1,
   -1,   -1,  393,  394,   -1,  264,  265,   -1,  267,   -1,
   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,
  279,   -1,   -1,   -1,   -1,   -1,  285,  418,  419,  288,
  421,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,
   -1,  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,
  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,
  329,  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  359,  360,  361,  362,  363,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  372,   -1,   -1,   -1,   -1,   -1,  378,
  379,  380,  381,   -1,   -1,   -1,  385,   -1,  387,  256,
   -1,   -1,   -1,   -1,  393,  394,   -1,  264,  265,   -1,
  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,
  277,   -1,  279,   -1,   -1,   -1,   -1,   -1,  285,  418,
  419,  288,  421,   -1,   -1,   -1,   -1,   -1,  295,   -1,
   -1,   -1,   -1,  300,   -1,  302,  303,  304,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,
   -1,  318,  319,   -1,   -1,  322,   -1,   -1,  325,   -1,
  327,   -1,  329,  330,  331,  332,   -1,  334,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  372,   -1,   -1,   -1,   -1,
   -1,  378,  379,  380,  381,   -1,   -1,   -1,  385,   -1,
  387,  256,   -1,   -1,   -1,   -1,  393,  394,   -1,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,
  275,  276,  277,   -1,  279,   -1,   -1,   -1,   -1,   -1,
  285,  418,  419,  288,  421,   -1,   -1,   -1,   -1,   -1,
  295,   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,
  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  372,   -1,   -1,
   -1,   -1,   -1,  378,  379,  380,  381,   -1,   -1,   -1,
  385,   -1,  387,  256,   -1,   -1,   -1,   -1,  393,  394,
   -1,  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,
   -1,   -1,  275,  276,  277,   -1,  279,   -1,   -1,   -1,
   -1,   -1,  285,  418,  419,  288,  421,   -1,   -1,   -1,
   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,  302,
  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  316,   -1,  318,  319,   -1,   -1,  322,
   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,
   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,  362,
  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  372,
   -1,   -1,   -1,   -1,   -1,  378,  379,  380,  381,   -1,
   -1,   -1,  385,   -1,  387,  256,   -1,   -1,   -1,   -1,
  393,  394,   -1,  264,  265,   -1,  267,   -1,   -1,  270,
  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,
   -1,   -1,   -1,   -1,  285,  418,  419,  288,  421,   -1,
   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,
   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,   -1,
   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,
  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,
  361,  362,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  372,   -1,   -1,   -1,   -1,   -1,  378,  379,  380,
  381,   -1,   -1,   -1,  385,   -1,  387,  256,   -1,   -1,
   -1,   -1,  393,  394,   -1,  264,  265,   -1,  267,   -1,
   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,
  279,   -1,   -1,   -1,   -1,   -1,  285,  418,  419,  288,
  421,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,
   -1,  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,
  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,
  329,  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  359,  360,  361,  362,  363,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  372,   -1,   -1,   -1,   -1,   -1,  378,
  379,  380,  381,   -1,   -1,   -1,  385,   -1,  387,  256,
   -1,   -1,   -1,   -1,  393,  394,   -1,  264,  265,   -1,
  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,
  277,   -1,  279,   -1,   -1,   -1,   -1,   -1,  285,  418,
  419,  288,  421,   -1,   -1,   -1,   -1,   -1,  295,   -1,
   -1,   -1,   -1,  300,   -1,  302,  303,  304,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,
   -1,  318,  319,   -1,   -1,  322,   -1,   -1,  325,   -1,
  327,   -1,  329,  330,  331,  332,   -1,  334,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  372,   -1,   -1,   -1,   -1,
   -1,  378,  379,  380,  381,   -1,   -1,   -1,  385,   -1,
  387,  256,   -1,   -1,   -1,   -1,  393,  394,   -1,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,
  275,  276,  277,   -1,  279,   -1,   -1,   -1,   -1,   -1,
  285,  418,  419,  288,  421,   -1,   -1,   -1,   -1,   -1,
  295,   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,
  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  372,   -1,   -1,
   -1,   -1,   -1,  378,  379,  380,  381,   -1,   -1,   -1,
  385,   -1,  387,  256,   -1,   -1,   -1,   -1,  393,  394,
   -1,  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,
   -1,   -1,  275,  276,  277,   -1,  279,   -1,   -1,   -1,
   -1,   -1,  285,  418,  419,  288,  421,   -1,   -1,   -1,
   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,  302,
  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  316,   -1,  318,  319,   -1,   -1,  322,
   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,
   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,  362,
  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  372,
   -1,   -1,   -1,   -1,   -1,  378,  379,  380,  381,   -1,
   -1,   -1,  385,   -1,  387,  256,   -1,   -1,   -1,   -1,
  393,  394,   -1,  264,  265,   -1,  267,   -1,   -1,  270,
  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,
   -1,   -1,   -1,   -1,  285,  418,  419,  288,  421,   -1,
   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,
   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,   -1,
   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,
  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,
  361,  362,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  372,   -1,   -1,   -1,   -1,   -1,  378,  379,  380,
  381,   -1,   -1,   -1,  385,   -1,  387,  256,   -1,   -1,
   -1,   -1,  393,  394,   -1,  264,  265,   -1,  267,   -1,
   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,
  279,   -1,   -1,   -1,   -1,   -1,  285,  418,  419,  288,
  421,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,
   -1,  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,
  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,
  329,  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  359,  360,  361,  362,  363,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  372,   -1,   -1,   -1,   -1,   -1,  378,
  379,  380,  381,   -1,   -1,   -1,  385,   -1,  387,  256,
   -1,   -1,   -1,   -1,  393,  394,   -1,  264,  265,   -1,
  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,
  277,   -1,  279,   -1,   -1,   -1,   -1,   -1,  285,  418,
  419,  288,  421,   -1,   -1,   -1,   -1,   -1,  295,   -1,
   -1,   -1,   -1,  300,   -1,  302,  303,  304,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,
   -1,  318,  319,   -1,   -1,  322,   -1,   -1,  325,   -1,
  327,   -1,  329,  330,  331,  332,   -1,  334,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  372,   -1,   -1,   -1,   -1,
   -1,  378,  379,  380,  381,   -1,   -1,   -1,  385,   -1,
  387,  256,   -1,   -1,   -1,   -1,  393,  394,   -1,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,
  275,  276,  277,   -1,  279,   -1,   -1,   -1,   -1,   -1,
  285,  418,  419,  288,  421,   -1,   -1,   -1,   -1,   -1,
  295,   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,
  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  372,   -1,   -1,
   -1,   -1,   -1,  378,  379,  380,  381,   -1,   -1,   -1,
  385,   -1,  387,  256,   -1,   -1,   -1,   -1,  393,  394,
   -1,  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,
   -1,   -1,  275,  276,  277,   -1,  279,   -1,   -1,   -1,
   -1,   -1,  285,  418,  419,  288,  421,   -1,   -1,   -1,
   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,  302,
  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  316,   -1,  318,  319,   -1,   -1,  322,
   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,
   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,  362,
  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  372,
   -1,   -1,   -1,   -1,   -1,  378,  379,  380,  381,   -1,
   -1,   -1,  385,   -1,  387,  256,   -1,   -1,   -1,   -1,
  393,  394,   -1,  264,  265,   -1,  267,   -1,   -1,  270,
  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,
   -1,   -1,   -1,   -1,  285,  418,  419,  288,  421,   -1,
   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,
   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,   -1,
   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,
  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,
  361,  362,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  372,   -1,   -1,   -1,   -1,   -1,  378,  379,  380,
  381,   -1,   -1,   -1,  385,   -1,  387,  256,   -1,   -1,
   -1,   -1,  393,  394,   -1,  264,  265,   -1,  267,   -1,
   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,
  279,   -1,   -1,   -1,   -1,   -1,  285,  418,  419,  288,
  421,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,
   -1,  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,
  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,
  329,  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  359,  360,  361,  362,  363,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  372,   -1,   -1,   -1,   -1,   -1,  378,
  379,  380,  381,   -1,   -1,   -1,  385,   -1,  387,  256,
   -1,   -1,   -1,   -1,  393,  394,   -1,  264,  265,   -1,
  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,
  277,   -1,  279,   -1,   -1,   -1,   -1,   -1,  285,  418,
  419,  288,  421,   -1,   -1,   -1,   -1,   -1,  295,   -1,
   -1,   -1,   -1,  300,   -1,  302,  303,  304,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,
   -1,  318,  319,   -1,   -1,  322,   -1,   -1,  325,   -1,
  327,   -1,  329,  330,  331,  332,   -1,  334,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  372,   -1,   -1,   -1,   -1,
   -1,  378,  379,  380,  381,   -1,   -1,   -1,  385,   -1,
  387,  256,   -1,   -1,   -1,   -1,  393,  394,   -1,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,
  275,  276,  277,   -1,  279,   -1,   -1,   -1,   -1,   -1,
  285,  418,  419,  288,  421,   -1,   -1,   -1,   -1,   -1,
  295,   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,
  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  372,   -1,   -1,
   -1,   -1,   -1,  378,  379,  380,  381,   -1,   -1,   -1,
  385,   -1,  387,  256,   -1,   -1,   -1,   -1,  393,  394,
   -1,  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,
   -1,   -1,  275,  276,  277,   -1,  279,   -1,   -1,   -1,
   -1,   -1,  285,  418,  419,  288,  421,   -1,   -1,   -1,
   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,  302,
  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  316,   -1,  318,  319,   -1,   -1,  322,
   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,
   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,  362,
  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  372,
   -1,   -1,   -1,   -1,   -1,  378,  379,  380,  381,   -1,
   -1,   -1,  385,   -1,  387,   -1,   -1,   -1,   -1,   -1,
  393,  394,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  256,   -1,   -1,   -1,   -1,  261,   -1,
   -1,   -1,  265,   -1,  267,  418,  419,  270,  421,  272,
  273,   -1,  275,   -1,  277,   -1,  279,   -1,  281,  282,
  283,  284,   -1,   -1,  287,  288,   -1,   -1,   -1,   -1,
  293,   -1,  295,  296,  297,   -1,   -1,  300,   -1,  302,
   -1,  304,   -1,   -1,  307,   -1,  309,  310,  311,  312,
   -1,   -1,   -1,  316,  317,  318,   -1,   -1,  321,  322,
  323,   -1,   -1,   -1,   -1,   -1,   -1,  330,  331,   -1,
  333,  334,  256,  336,  337,  338,   -1,   -1,   -1,  342,
  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,
   -1,  275,  276,  277,   -1,  279,   -1,   -1,   -1,  362,
   -1,  285,   -1,   -1,  288,  368,  369,  370,   -1,   -1,
   -1,  295,   -1,   -1,   -1,  378,  300,   -1,  302,  303,
  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,
   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,
  334,   -1,   -1,  337,   -1,   -1,  419,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,
   -1,   -1,   -1,  256,   -1,   -1,   -1,   -1,  372,   -1,
  262,  264,  265,   -1,  267,  379,  380,  270,  271,   -1,
   -1,   -1,  275,  276,  277,   -1,  279,   -1,   -1,   -1,
   -1,   -1,  285,   -1,   -1,  288,   -1,   -1,   -1,  261,
   -1,  263,  295,   -1,   -1,   -1,  298,  300,   -1,  302,
  303,  304,   -1,   -1,  418,  419,   -1,   -1,   -1,   -1,
   -1,   -1,  284,  316,   -1,  318,  319,   -1,   -1,  322,
   -1,   -1,  325,   -1,  327,  297,  329,  330,  331,  332,
  302,  334,   -1,   -1,   -1,  307,   -1,  309,  310,  311,
  312,   -1,   -1,  315,   -1,  317,   -1,   -1,   -1,  321,
   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,  362,
  363,  333,  364,   -1,  336,   -1,  338,   -1,   -1,  372,
  372,  373,  374,  375,  376,   -1,   -1,  379,  380,   -1,
   -1,  383,  384,  385,  386,  387,  388,  389,  390,  391,
  362,  393,  394,  395,  396,  397,  398,  399,  400,  401,
  402,  403,  404,  405,  406,  407,  408,  409,  410,  411,
  412,  413,  414,   -1,   -1,  418,  419,   -1,   -1,  421,
   -1,  261,  424,  263,   -1,  265,   -1,  267,   -1,   -1,
  270,   -1,  272,  273,   -1,  275,   -1,  277,   -1,  279,
   -1,  281,  282,  283,  284,   -1,   -1,  287,  288,   -1,
   -1,   -1,   -1,  293,  294,  295,  296,  297,   -1,   -1,
  300,   -1,  302,   -1,  304,   -1,  306,  307,   -1,  309,
  310,  311,  312,   -1,   -1,  315,  316,  317,  318,   -1,
   -1,  321,  322,  323,   -1,   -1,   -1,   -1,   -1,   -1,
  330,  331,   -1,  333,  334,   -1,  336,  337,  338,   -1,
   -1,   -1,  342,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  362,   -1,   -1,  365,  366,  261,   -1,   -1,
   -1,  265,   -1,  267,   -1,   -1,  270,   -1,  272,  273,
   -1,  275,   -1,  277,   -1,  279,   -1,  281,  282,  283,
  284,   -1,   -1,  287,  288,   -1,   -1,   -1,   -1,  293,
   -1,  295,  296,  297,   -1,   -1,  300,   -1,  302,   -1,
  304,   -1,   -1,  307,   -1,  309,  310,  311,  312,  419,
   -1,   -1,  316,  317,  318,   -1,   -1,  321,  322,  323,
   -1,   -1,   -1,   -1,   -1,   -1,  330,  331,   -1,  333,
  334,   -1,  336,  337,  338,   -1,   -1,   -1,  342,   -1,
   -1,  261,   -1,   -1,   -1,  265,   -1,  267,   -1,   -1,
  270,   -1,  272,  273,   -1,  275,   -1,  277,  362,  279,
   -1,  281,  282,  283,  284,  369,   -1,  287,  288,   -1,
   -1,   -1,   -1,  293,  378,  295,  296,  297,   -1,   -1,
  300,   -1,  302,   -1,  304,   -1,   -1,  307,   -1,  309,
  310,  311,  312,   -1,   -1,   -1,  316,  317,  318,   -1,
   -1,  321,  322,  323,   -1,   -1,   -1,   -1,   -1,   -1,
  330,  331,   -1,  333,  334,  419,  336,  337,  338,   -1,
   -1,   -1,  342,   -1,   -1,  261,   -1,   -1,   -1,  265,
   -1,  267,   -1,   -1,  270,   -1,  272,  273,   -1,  275,
   -1,  277,  362,  279,   -1,  281,  282,  283,  284,  369,
   -1,  287,  288,   -1,   -1,   -1,   -1,  293,  378,  295,
  296,  297,   -1,   -1,  300,   -1,  302,   -1,  304,   -1,
   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,   -1,
  316,  317,  318,   -1,   -1,  321,  322,  323,   -1,   -1,
   -1,   -1,   -1,   -1,  330,  331,   -1,  333,  334,  419,
  336,  337,  338,   -1,   -1,   -1,  342,   -1,   -1,  261,
   -1,   -1,   -1,  265,   -1,  267,   -1,   -1,  270,   -1,
  272,  273,   -1,  275,   -1,  277,  362,  279,   -1,  281,
  282,  283,  284,   -1,   -1,  287,  288,   -1,   -1,   -1,
   -1,  293,  378,  295,  296,  297,   -1,   -1,  300,   -1,
  302,   -1,  304,   -1,   -1,  307,   -1,  309,  310,  311,
  312,   -1,   -1,   -1,  316,  317,  318,   -1,   -1,  321,
  322,  323,   -1,   -1,   -1,   -1,   -1,   -1,  330,  331,
   -1,  333,  334,  419,  336,  337,  338,   -1,   -1,   -1,
  342,   -1,   -1,  261,   -1,   -1,   -1,  265,   -1,  267,
   -1,   -1,  270,   -1,  272,  273,   -1,  275,   -1,  277,
  362,  279,   -1,  281,  282,  283,  284,  369,   -1,  287,
  288,   -1,   -1,   -1,   -1,  293,   -1,  295,  296,  297,
   -1,   -1,  300,   -1,  302,  261,  304,   -1,   -1,  307,
   -1,  309,  310,  311,  312,   -1,   -1,   -1,  316,  317,
  318,   -1,   -1,  321,  322,  323,   -1,   -1,  284,   -1,
   -1,   -1,  330,  331,   -1,  333,  334,  419,  336,  337,
  338,  297,   -1,   -1,  342,   -1,  302,   -1,   -1,  305,
   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,   -1,
   -1,  317,   -1,   -1,  362,  321,   -1,   -1,   -1,  325,
   -1,  369,   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,
  336,   -1,  338,   -1,  264,  265,   -1,  267,   -1,   -1,
  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,
   -1,  357,   -1,   -1,   -1,  285,  362,   -1,  288,   -1,
   -1,   -1,   -1,  369,  370,  295,  372,   -1,  374,   -1,
  300,  419,  302,  303,  304,   -1,  306,   -1,   -1,   -1,
   -1,  387,   -1,  313,   -1,   -1,  316,   -1,  318,  319,
   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,
  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,
   -1,  341,   -1,  419,  344,  345,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,
  360,  361,  362,  363,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  372,  373,   -1,  375,   -1,   -1,  378,  379,
  380,  381,   -1,   -1,   -1,  385,   -1,  387,   -1,   -1,
   -1,   -1,   -1,  393,  394,   -1,   -1,   -1,   -1,   -1,
   -1,  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,
   -1,   -1,  275,  276,  277,   -1,  279,   -1,  418,  419,
  420,  421,  285,   -1,   -1,  288,   -1,   -1,   -1,   -1,
   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,  302,
  303,  304,   -1,  306,   -1,   -1,   -1,   -1,   -1,   -1,
  313,   -1,   -1,  316,   -1,  318,  319,   -1,   -1,  322,
   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,
   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,
   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,  362,
  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  372,
   -1,   -1,  375,   -1,   -1,  378,  379,  380,  381,   -1,
   -1,   -1,  385,   -1,  387,   -1,   -1,   -1,   -1,   -1,
  393,  394,   -1,   -1,   -1,   -1,   -1,   -1,  264,  265,
   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,
  276,  277,   -1,  279,   -1,  418,  419,  420,  421,  285,
   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,
   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,  325,
   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,   -1,
   -1,  337,   -1,   -1,   -1,  341,   -1,   -1,  344,  345,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  372,   -1,   -1,   -1,
   -1,   -1,  378,  379,  380,  381,   -1,   -1,   -1,  385,
   -1,  387,   -1,   -1,   -1,   -1,   -1,  393,  394,   -1,
   -1,   -1,   -1,   -1,   -1,  264,  265,   -1,  267,   -1,
   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,
  279,   -1,  418,  419,  420,  421,  285,   -1,   -1,  288,
   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,
   -1,  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,
  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,
  329,  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,
   -1,   -1,  341,   -1,   -1,  344,  345,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  359,  360,  361,  362,  363,   -1,   -1,   -1,   -1,  368,
   -1,   -1,   -1,  372,   -1,   -1,   -1,   -1,   -1,  378,
  379,  380,  381,   -1,   -1,   -1,  385,   -1,  387,   -1,
   -1,   -1,   -1,   -1,  393,  394,   -1,   -1,   -1,   -1,
   -1,   -1,  264,  265,   -1,  267,   -1,   -1,  270,  271,
   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,  418,
  419,  420,  421,  285,   -1,   -1,  288,   -1,   -1,   -1,
   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,
  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  316,   -1,  318,  319,   -1,   -1,
  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,
  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,  341,
   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,
  362,  363,   -1,   -1,   -1,   -1,  368,   -1,   -1,   -1,
  372,   -1,   -1,   -1,   -1,   -1,  378,  379,  380,  381,
   -1,   -1,   -1,  385,   -1,  387,   -1,   -1,   -1,   -1,
   -1,  393,  394,   -1,   -1,   -1,   -1,   -1,   -1,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,
  275,  276,  277,   -1,  279,   -1,  418,  419,  420,  421,
  285,   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,
  295,   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,
  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,
   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,  344,
  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  372,   -1,   -1,
   -1,   -1,   -1,  378,  379,  380,  381,   -1,   -1,   -1,
  385,   -1,  387,   -1,   -1,   -1,   -1,   -1,  393,  394,
   -1,   -1,   -1,   -1,   -1,   -1,  264,  265,   -1,  267,
   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,
   -1,  279,   -1,  418,  419,  420,  421,  285,   -1,   -1,
  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,
   -1,   -1,  300,   -1,  302,  303,  304,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,
  318,  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,
   -1,  329,  330,  331,  332,   -1,  334,   -1,   -1,   -1,
   -1,   -1,   -1,  341,   -1,   -1,  344,  345,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  372,   -1,   -1,   -1,   -1,   -1,
  378,  379,  380,  381,   -1,   -1,   -1,  385,   -1,  387,
   -1,   -1,   -1,   -1,   -1,  393,  394,   -1,   -1,   -1,
   -1,   -1,   -1,  264,  265,   -1,  267,   -1,   -1,  270,
  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,
  418,  419,  420,  421,  285,   -1,   -1,  288,   -1,   -1,
   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,
   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,   -1,
   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,
  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,
  341,   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,
  361,  362,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  372,   -1,   -1,   -1,   -1,   -1,  378,  379,  380,
  381,   -1,   -1,   -1,  385,   -1,  387,   -1,   -1,   -1,
   -1,   -1,  393,  394,   -1,   -1,   -1,   -1,   -1,   -1,
  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,
   -1,  275,  276,  277,   -1,  279,   -1,  418,  419,  420,
  421,  285,   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,
   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,  302,  303,
  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,
   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,
  334,   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,
  344,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  372,   -1,
   -1,   -1,   -1,   -1,  378,  379,  380,  381,   -1,   -1,
   -1,  385,   -1,  387,   -1,   -1,   -1,   -1,   -1,  393,
  394,   -1,   -1,   -1,   -1,   -1,   -1,  264,  265,   -1,
  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,
  277,   -1,  279,   -1,  418,  419,  420,  421,  285,   -1,
   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,
   -1,   -1,   -1,  300,   -1,  302,  303,  304,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,
   -1,  318,  319,   -1,   -1,  322,   -1,   -1,  325,   -1,
  327,   -1,  329,  330,  331,  332,   -1,  334,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  372,   -1,   -1,   -1,   -1,
   -1,  378,  379,  380,  381,   -1,   -1,   -1,  385,   -1,
  387,   -1,  264,  265,   -1,  267,  393,  394,  270,  271,
   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,   -1,
   -1,   -1,   -1,  285,   -1,   -1,  288,   -1,   -1,   -1,
   -1,  418,  419,  295,  421,   -1,   -1,   -1,  300,   -1,
  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  316,   -1,  318,  319,   -1,   -1,
  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,
  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,
  362,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  372,   -1,   -1,   -1,   -1,   -1,  378,  379,  380,  381,
   -1,   -1,   -1,  385,   -1,  387,   -1,   -1,   -1,   -1,
   -1,  393,  394,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  263,   -1,  265,   -1,  267,  418,  419,  270,  421,
  272,  273,   -1,  275,   -1,  277,   -1,  279,   -1,  281,
  282,  283,   -1,   -1,   -1,  287,  288,   -1,   -1,   -1,
   -1,  293,   -1,  295,  296,   -1,   -1,   -1,  300,   -1,
   -1,   -1,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  315,  316,   -1,  318,   -1,   -1,   -1,
  322,  323,   -1,   -1,   -1,   -1,   -1,   -1,  330,  331,
  264,  265,  334,  267,   -1,  337,  270,  271,   -1,   -1,
  342,  275,  276,  277,   -1,  279,   -1,   -1,   -1,   -1,
   -1,  285,   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,
   -1,  295,   -1,  365,  366,   -1,  300,   -1,  302,  303,
  304,   -1,   -1,   -1,   -1,   -1,  378,   -1,   -1,   -1,
   -1,   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,
   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,
  334,   -1,   -1,  337,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  419,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,
   -1,   -1,   -1,   -1,   -1,  265,   -1,  267,  372,   -1,
  270,   -1,  272,  273,   -1,  275,   -1,  277,   -1,  279,
   -1,  281,  282,  283,   -1,   -1,   -1,  287,  288,   -1,
   -1,   -1,   -1,  293,   -1,  295,  296,   -1,   -1,   -1,
  300,   -1,   -1,   -1,  304,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  418,  419,  316,   -1,  318,   -1,
   -1,   -1,  322,  323,   -1,   -1,   -1,   -1,   -1,   -1,
  330,  331,   -1,  265,  334,  267,   -1,  337,  270,   -1,
   -1,  273,  342,  275,   -1,  277,   -1,  279,   -1,  281,
  282,  283,   -1,   -1,   -1,  287,  288,   -1,   -1,   -1,
   -1,  293,   -1,  295,   -1,  265,   -1,  267,  300,   -1,
  270,   -1,  304,   -1,   -1,  275,   -1,   -1,  378,  279,
   -1,   -1,   -1,   -1,  316,   -1,  318,   -1,  288,   -1,
  322,   -1,   -1,   -1,   -1,  295,   -1,   -1,  330,  331,
  300,   -1,  334,   -1,  304,  337,  306,   -1,  308,   -1,
  342,   -1,   -1,  313,   -1,   -1,  316,   -1,  318,  419,
   -1,   -1,  322,   -1,   -1,  325,   -1,   -1,   -1,   -1,
  330,  331,   -1,  265,  334,  267,   -1,  337,  270,   -1,
   -1,   -1,   -1,  275,   -1,   -1,  378,  279,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  288,   -1,   -1,   -1,
   -1,   -1,   -1,  295,   -1,  265,   -1,  267,  300,   -1,
  270,   -1,  304,  373,  306,  275,  308,   -1,   -1,  279,
   -1,  313,   -1,   -1,  316,   -1,  318,  419,  288,   -1,
  322,   -1,   -1,  325,   -1,  295,   -1,   -1,  330,  331,
  300,   -1,  334,   -1,  304,  337,  306,   -1,   -1,   -1,
   -1,   -1,   -1,  313,   -1,   -1,  316,   -1,  318,  419,
   -1,   -1,  322,   -1,   -1,  325,   -1,   -1,   -1,   -1,
  330,  331,   -1,   -1,  334,   -1,   -1,  337,  265,  371,
  267,   -1,   -1,  270,   -1,   -1,   -1,   -1,  275,   -1,
   -1,   -1,  279,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  288,   -1,  363,   -1,   -1,   -1,   -1,  295,   -1,
  265,   -1,  267,  300,   -1,  270,   -1,  304,   -1,  306,
  275,  308,   -1,   -1,  279,   -1,  313,  419,   -1,  316,
   -1,  318,   -1,  288,   -1,  322,   -1,   -1,  325,   -1,
  295,   -1,   -1,  330,  331,  300,   -1,  334,   -1,  304,
  337,  306,   -1,  308,   -1,  265,   -1,  267,  313,  419,
  270,  316,   -1,  318,   -1,  275,   -1,  322,   -1,  279,
  325,   -1,   -1,  283,   -1,  330,  331,   -1,  288,  334,
   -1,   -1,  337,  293,   -1,  295,   -1,  265,   -1,  267,
  300,   -1,  270,   -1,  304,  305,   -1,  275,   -1,   -1,
   -1,  279,   -1,   -1,   -1,   -1,  316,   -1,  318,   -1,
  288,   -1,  322,   -1,   -1,   -1,   -1,  295,   -1,   -1,
  330,  331,  300,   -1,  334,   -1,  304,  337,   -1,   -1,
   -1,  261,  419,   -1,   -1,   -1,   -1,   -1,  316,   -1,
  318,   -1,  272,   -1,  322,   -1,   -1,  277,   -1,   -1,
   -1,  281,  330,  331,  284,   -1,  334,   -1,   -1,  337,
   -1,   -1,   -1,   -1,  419,   -1,  296,  297,   -1,   -1,
   -1,  301,  302,   -1,   -1,   -1,   -1,  307,   -1,  309,
  310,  311,  312,   -1,   -1,  363,   -1,  317,   -1,   -1,
   -1,  321,   -1,  323,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  261,  333,   -1,  335,  336,   -1,  338,  419,
   -1,   -1,  342,  272,   -1,   -1,   -1,   -1,  277,   -1,
   -1,   -1,  281,   -1,   -1,  284,   -1,   -1,   -1,   -1,
   -1,   -1,  362,   -1,   -1,   -1,   -1,  296,  297,  369,
  370,  419,  301,  302,  261,   -1,   -1,   -1,  307,   -1,
  309,  310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1,
   -1,   -1,  321,   -1,  323,   -1,   -1,  284,   -1,   -1,
   -1,   -1,   -1,   -1,  333,   -1,   -1,  336,   -1,  338,
  297,   -1,  261,  342,  263,  302,   -1,   -1,   -1,   -1,
  307,   -1,  309,  310,  311,  312,   -1,   -1,  315,   -1,
  317,   -1,   -1,  362,  321,  284,   -1,   -1,   -1,   -1,
  369,  370,   -1,   -1,   -1,   -1,  333,   -1,  297,  336,
   -1,  338,   -1,  302,   -1,   -1,   -1,   -1,  307,   -1,
  309,  310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1,
   -1,   -1,  321,   -1,   -1,  362,   -1,   -1,   -1,   -1,
   -1,   -1,  369,  370,  333,   -1,   -1,  336,  261,  338,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  272,
   -1,   -1,   -1,   -1,  277,   -1,   -1,   -1,  281,   -1,
   -1,  284,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,
  369,  370,   -1,  296,  297,   -1,   -1,   -1,  301,  302,
   -1,  261,   -1,   -1,  307,   -1,  309,  310,  311,  312,
   -1,   -1,  272,   -1,  317,   -1,   -1,  277,  321,   -1,
  323,  281,   -1,   -1,  284,   -1,   -1,   -1,   -1,   -1,
  333,   -1,   -1,  336,   -1,  338,  296,  297,   -1,  342,
   -1,  301,  302,   -1,  261,   -1,   -1,  307,   -1,  309,
  310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1,  362,
   -1,  321,   -1,  323,   -1,   -1,  369,  284,   -1,   -1,
   -1,   -1,   -1,  333,   -1,   -1,  336,   -1,  338,   -1,
  297,   -1,  342,   -1,  261,  302,   -1,   -1,   -1,   -1,
  307,   -1,  309,  310,  311,  312,   -1,   -1,   -1,   -1,
  317,   -1,  362,   -1,  321,   -1,   -1,  284,   -1,  369,
   -1,   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,  336,
  297,  338,   -1,   -1,  261,  302,   -1,   -1,   -1,   -1,
  307,   -1,  309,  310,  311,  312,   -1,   -1,   -1,   -1,
  317,   -1,   -1,   -1,  321,  362,   -1,  284,  365,  366,
   -1,   -1,  369,   -1,   -1,   -1,  333,   -1,   -1,  336,
  297,  338,   -1,   -1,  261,  302,  263,   -1,   -1,   -1,
  307,   -1,  309,  310,  311,  312,   -1,   -1,  315,   -1,
  317,   -1,   -1,   -1,  321,  362,   -1,  284,  365,  366,
   -1,   -1,  369,   -1,  261,   -1,  333,   -1,   -1,  336,
  297,  338,   -1,   -1,   -1,  302,   -1,   -1,   -1,   -1,
  307,   -1,  309,  310,  311,  312,   -1,  284,   -1,   -1,
  317,   -1,   -1,   -1,  321,  362,   -1,   -1,   -1,   -1,
  297,   -1,  369,   -1,  261,  302,  333,   -1,   -1,  336,
  307,  338,  309,  310,  311,  312,   -1,   -1,   -1,   -1,
  317,   -1,   -1,   -1,  321,   -1,   -1,  284,   -1,   -1,
   -1,   -1,   -1,   -1,  261,  362,  333,   -1,   -1,  336,
  297,  338,  369,   -1,  301,  302,   -1,   -1,   -1,   -1,
  307,   -1,  309,  310,  311,  312,   -1,  284,   -1,   -1,
  317,   -1,   -1,   -1,  321,  362,   -1,   -1,  365,  366,
  297,   -1,   -1,   -1,   -1,  302,  333,   -1,   -1,  336,
  307,  338,  309,  310,  311,  312,   -1,   -1,   -1,   -1,
  317,   -1,   -1,   -1,  321,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  362,  333,   -1,   -1,  336,
   -1,  338,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  362,
  };

#line 7338 "cs-parser.jay"

// <summary>
//  A class used to hold info about an operator declarator
// </summary>
class OperatorDeclaration {
	public readonly Operator.OpType optype;
	public readonly FullNamedExpression ret_type;
	public readonly Location location;

	public OperatorDeclaration (Operator.OpType op, FullNamedExpression ret_type, Location location)
	{
		optype = op;
		this.ret_type = ret_type;
		this.location = location;
	}
}

void Error_ExpectingTypeName (Expression expr)
{
	if (expr is Invocation){
		report.Error (1002, expr.Location, "Expecting `;'");
	} else {
		expr.Error_InvalidExpressionStatement (report);
	}
}

void Error_ParameterModifierNotValid (string modifier, Location loc)
{
	report.Error (631, loc, "The parameter modifier `{0}' is not valid in this context",
			              modifier);
}

void Error_DuplicateParameterModifier (Location loc, Parameter.Modifier mod)
{
	report.Error (1107, loc, "Duplicate parameter modifier `{0}'",
  		Parameter.GetModifierSignature (mod));
}

void Error_TypeExpected (Location loc)
{
	report.Error (1031, loc, "Type expected");
}

void Error_UnsafeCodeNotAllowed (Location loc)
{
	report.Error (227, loc, "Unsafe code requires the `unsafe' command line option to be specified");
}

void Warning_EmptyStatement (Location loc)
{
	report.Warning (642, 3, loc, "Possible mistaken empty statement");
}

void Error_NamedArgumentExpected (NamedArgument a)
{
	report.Error (1738, a.Location, "Named arguments must appear after the positional arguments");
}

void Error_MissingInitializer (Location loc)
{
	report.Error (210, loc, "You must provide an initializer in a fixed or using statement declaration");
}

object Error_AwaitAsIdentifier (object token)
{
	if (async_block) {
		report.Error (4003, GetLocation (token), "`await' cannot be used as an identifier within an async method or lambda expression");
		return new LocatedToken ("await", GetLocation (token));
	}

	return token;
}

void push_current_container (TypeDefinition tc, object partial_token)
{
	if (module.Evaluator != null){
		tc.Definition.Modifiers = tc.ModFlags = (tc.ModFlags & ~Modifiers.AccessibilityMask) | Modifiers.PUBLIC;
		if (undo == null)
			undo = new Undo ();

		undo.AddTypeContainer (current_container, tc);
	}
	
	if (partial_token != null)
		current_container.AddPartial (tc);
	else
		current_container.AddTypeContainer (tc);
		
	++lexer.parsing_declaration;
	current_container = tc;
	current_type = tc;
}

TypeContainer pop_current_class ()
{
	var retval = current_container;

	current_container = current_container.Parent;
	current_type = current_type.Parent as TypeDefinition;

	return retval;
}

[System.Diagnostics.Conditional ("FULL_AST")]
void StoreModifierLocation (object token, Location loc)
{
	if (lbag == null)
		return;

	if (mod_locations == null)
  		mod_locations = new List<Tuple<Modifiers, Location>> ();

	mod_locations.Add (Tuple.Create ((Modifiers) token, loc));
}

List<Tuple<Modifiers, Location>> GetModifierLocations ()
{
	var result = mod_locations;
	mod_locations = null;
	return result;
}

[System.Diagnostics.Conditional ("FULL_AST")]
void PushLocation (Location loc)
{
	if (location_stack == null)
		location_stack = new Stack<Location> ();

	location_stack.Push (loc);
}

Location PopLocation ()
{
	if (location_stack == null)
		return Location.Null;

	return location_stack.Pop ();
}

string CheckAttributeTarget (int token, string a, Location l)
{
	switch (a) {
	case "assembly" : case "module" : case "field" : case "method" : case "param" : case "property" : case "type" :
			return a;
	}

	if (!Tokenizer.IsValidIdentifier (a)) {
		Error_SyntaxError (token);
	} else {
		report.Warning (658, 1, l,
			 "`{0}' is invalid attribute target. All attributes in this attribute section will be ignored", a);
	}

	return string.Empty;
}

static bool IsUnaryOperator (Operator.OpType op)
{
	switch (op) {
		
	case Operator.OpType.LogicalNot: 
	case Operator.OpType.OnesComplement: 
	case Operator.OpType.Increment:
	case Operator.OpType.Decrement:
	case Operator.OpType.True: 
	case Operator.OpType.False: 
	case Operator.OpType.UnaryPlus: 
	case Operator.OpType.UnaryNegation:
		return true;
	}
	return false;
}

void syntax_error (Location l, string msg)
{
	report.Error (1003, l, "Syntax error, " + msg);
}

Tokenizer lexer;

public Tokenizer Lexer {
	get {
		return lexer;
	}
}		   

public CSharpParser (SeekableStreamReader reader, CompilationSourceFile file, ParserSession session)
	: this (reader, file, file.Compiler.Report, session)
{
}

public CSharpParser (SeekableStreamReader reader, CompilationSourceFile file, Report report, ParserSession session)
{
	this.file = file;
	current_container = current_namespace = file;
	
	this.module = file.Module;
	this.compiler = file.Compiler;
	this.settings = compiler.Settings;
	this.report = report;
	
	lang_version = settings.Version;
	yacc_verbose_flag = settings.VerboseParserFlag;
	doc_support = settings.DocumentationFile != null;
	lexer = new Tokenizer (reader, file, session, report);
	oob_stack = new Stack<object> ();
	lbag = session.LocationsBag;
	use_global_stacks = session.UseJayGlobalArrays;
	parameters_bucket = session.ParametersStack;
}

public void parse ()
{
	eof_token = Token.EOF;
	
	try {
		if (yacc_verbose_flag > 1)
			yyparse (lexer, new yydebug.yyDebugSimple ());
		else
			yyparse (lexer);
			
		Tokenizer tokenizer = lexer as Tokenizer;
		tokenizer.cleanup ();		
	} catch (Exception e){
	  	if (e is yyParser.yyUnexpectedEof) {
			Error_SyntaxError (yyToken);
			UnexpectedEOF = true;
			return;
		}
			
		if (e is yyParser.yyException) {
			if (report.Errors == 0)
				report.Error (-25, lexer.Location, "Parsing error");
		} else {
			// Used by compiler-tester to test internal errors
			if (yacc_verbose_flag > 0 || e is FatalException)
				throw;
		
			report.Error (589, lexer.Location, "Internal compiler error during parsing" + e);
		}
	}
}

void CheckToken (int error, int yyToken, string msg, Location loc)
{
	if (yyToken >= Token.FIRST_KEYWORD && yyToken <= Token.LAST_KEYWORD)
		report.Error (error, loc, "{0}: `{1}' is a keyword", msg, GetTokenName (yyToken));
	else
		report.Error (error, loc, msg);
}

string ConsumeStoredComment ()
{
	string s = tmpComment;
	tmpComment = null;
	Lexer.doc_state = XmlCommentState.Allowed;
	return s;
}

void FeatureIsNotAvailable (Location loc, string feature)
{
	report.FeatureIsNotAvailable (compiler, loc, feature);
}

Location GetLocation (object obj)
{
	var lt = obj as LocatedToken;
	if (lt != null)
		return lt.Location;
		
	var mn = obj as MemberName;
	if (mn != null)
		return mn.Location;
		
	var expr = obj as Expression;
	if (expr != null)
		return expr.Location;

	return lexer.Location;
}

void start_block (Location loc)
{
	if (current_block == null) {
		current_block = new ToplevelBlock (compiler, current_local_parameters, loc);
		parsing_anonymous_method = false;
	} else if (parsing_anonymous_method) {
		current_block = new ParametersBlock (current_block, current_local_parameters, loc);
		parsing_anonymous_method = false;
	} else {
		current_block = new ExplicitBlock (current_block, loc, Location.Null);
	}
}

Block
end_block (Location loc)
{
	Block retval = current_block.Explicit;
	retval.SetEndLocation (loc);
	current_block = retval.Parent;
	return retval;
}

void start_anonymous (bool isLambda, ParametersCompiled parameters, bool isAsync, Location loc)
{
	oob_stack.Push (current_anonymous_method);
	oob_stack.Push (current_local_parameters);
	oob_stack.Push (current_variable);
	oob_stack.Push (async_block);

	current_local_parameters = parameters;
	if (isLambda) {
		if (lang_version <= LanguageVersion.ISO_2)
			FeatureIsNotAvailable (loc, "lambda expressions");

		current_anonymous_method = new LambdaExpression (loc);
	} else {
		if (lang_version == LanguageVersion.ISO_1)
			FeatureIsNotAvailable (loc, "anonymous methods");
			
		current_anonymous_method = new AnonymousMethodExpression (loc);
	}
	current_anonymous_method.IsAsync = isAsync;
	
	async_block = isAsync;
	// Force the next block to be created as a ToplevelBlock
	parsing_anonymous_method = true;
}

/*
 * Completes the anonymous method processing, if lambda_expr is null, this
 * means that we have a Statement instead of an Expression embedded 
 */
AnonymousMethodExpression end_anonymous (ParametersBlock anon_block)
{
	AnonymousMethodExpression retval;

	if (async_block)
		anon_block.IsAsync = true;

	current_anonymous_method.Block = anon_block;
	retval = current_anonymous_method;

	async_block = (bool) oob_stack.Pop ();
	current_variable = (BlockVariable) oob_stack.Pop ();
	current_local_parameters = (ParametersCompiled) oob_stack.Pop ();
	current_anonymous_method = (AnonymousMethodExpression) oob_stack.Pop ();

	return retval;
}

void Error_SyntaxError (int token)
{
	Error_SyntaxError (0, token);
}

void Error_SyntaxError (int error_code, int token)
{
	Error_SyntaxError (error_code, token, "Unexpected symbol");
}

void Error_SyntaxError (int error_code, int token, string msg)
{
	Lexer.CompleteOnEOF = false;

	// An error message has been reported by tokenizer
	if (token == Token.ERROR)
		return;
	
	// Avoid duplicit error message after unterminated string literals
	if (token == Token.LITERAL && lexer.Location.Column == 0)
		return;

	string symbol = GetSymbolName (token);
	string expecting = GetExpecting ();
	var loc = lexer.Location - symbol.Length;
	
	if (error_code == 0) {
		if (expecting == "`identifier'") {
			if (token > Token.FIRST_KEYWORD && token < Token.LAST_KEYWORD) {
				report.Error (1041, loc, "Identifier expected, `{0}' is a keyword", symbol);
				return;
			}
			
			error_code = 1001;
			expecting = "identifier";
		} else if (expecting == "`)'") {
			error_code = 1026;
		} else {
			error_code = 1525;
		}
	}
	
	if (string.IsNullOrEmpty (expecting))
		report.Error (error_code, loc, "{1} `{0}'", symbol, msg);
	else
		report.Error (error_code, loc, "{2} `{0}', expecting {1}", symbol, expecting, msg);	  
}

string GetExpecting ()
{
	int [] tokens = yyExpectingTokens (yyExpectingState);
	var names = new List<string> (tokens.Length);
	bool has_type = false;
	bool has_identifier = false;
	for (int i = 0; i < tokens.Length; i++){
		int token = tokens [i];
		has_identifier |= token == Token.IDENTIFIER;
		
		string name = GetTokenName (token);
		if (name == "<internal>")
			continue;
			
		has_type |= name == "type";
		if (names.Contains (name))
			continue;
		
		names.Add (name);
	}

	//
	// Too many tokens to enumerate
	//
	if (names.Count > 8)
		return null;

	if (has_type && has_identifier)
		names.Remove ("identifier");

	if (names.Count == 1)
		return "`" + GetTokenName (tokens [0]) + "'";
	
	StringBuilder sb = new StringBuilder ();
	names.Sort ();
	int count = names.Count;
	for (int i = 0; i < count; i++){
		bool last = i + 1 == count;
		if (last)
			sb.Append ("or ");
		sb.Append ('`');
		sb.Append (names [i]);
		sb.Append (last ? "'" : count < 3 ? "' " : "', ");
	}
	return sb.ToString ();
}


string GetSymbolName (int token)
{
	switch (token){
	case Token.LITERAL:
		return ((Constant)lexer.Value).GetValue ().ToString ();
	case Token.IDENTIFIER:
		return ((LocatedToken)lexer.Value).Value;

	case Token.BOOL:
		return "bool";
	case Token.BYTE:
		return "byte";
	case Token.CHAR:
		return "char";
	case Token.VOID:
		return "void";
	case Token.DECIMAL:
		return "decimal";
	case Token.DOUBLE:
		return "double";
	case Token.FLOAT:
		return "float";
	case Token.INT:
		return "int";
	case Token.LONG:
		return "long";
	case Token.SBYTE:
		return "sbyte";
	case Token.SHORT:
		return "short";
	case Token.STRING:
		return "string";
	case Token.UINT:
		return "uint";
	case Token.ULONG:
		return "ulong";
	case Token.USHORT:
		return "ushort";
	case Token.OBJECT:
		return "object";
		
	case Token.PLUS:
		return "+";
	case Token.UMINUS:
	case Token.MINUS:
		return "-";
	case Token.BANG:
		return "!";
	case Token.BITWISE_AND:
		return "&";
	case Token.BITWISE_OR:
		return "|";
	case Token.STAR:
		return "*";
	case Token.PERCENT:
		return "%";
	case Token.DIV:
		return "/";
	case Token.CARRET:
		return "^";
	case Token.OP_INC:
		return "++";
	case Token.OP_DEC:
		return "--";
	case Token.OP_SHIFT_LEFT:
		return "<<";
	case Token.OP_SHIFT_RIGHT:
		return ">>";
	case Token.OP_LT:
		return "<";
	case Token.OP_GT:
		return ">";
	case Token.OP_LE:
		return "<=";
	case Token.OP_GE:
		return ">=";
	case Token.OP_EQ:
		return "==";
	case Token.OP_NE:
		return "!=";
	case Token.OP_AND:
		return "&&";
	case Token.OP_OR:
		return "||";
	case Token.OP_PTR:
		return "->";
	case Token.OP_COALESCING:	
		return "??";
	case Token.OP_MULT_ASSIGN:
		return "*=";
	case Token.OP_DIV_ASSIGN:
		return "/=";
	case Token.OP_MOD_ASSIGN:
		return "%=";
	case Token.OP_ADD_ASSIGN:
		return "+=";
	case Token.OP_SUB_ASSIGN:
		return "-=";
	case Token.OP_SHIFT_LEFT_ASSIGN:
		return "<<=";
	case Token.OP_SHIFT_RIGHT_ASSIGN:
		return ">>=";
	case Token.OP_AND_ASSIGN:
		return "&=";
	case Token.OP_XOR_ASSIGN:
		return "^=";
	case Token.OP_OR_ASSIGN:
		return "|=";
	}

	return GetTokenName (token);
}

static string GetTokenName (int token)
{
	switch (token){
	case Token.ABSTRACT:
		return "abstract";
	case Token.AS:
		return "as";
	case Token.ADD:
		return "add";
	case Token.ASYNC:
		return "async";
	case Token.BASE:
		return "base";
	case Token.BREAK:
		return "break";
	case Token.CASE:
		return "case";
	case Token.CATCH:
		return "catch";
	case Token.CHECKED:
		return "checked";
	case Token.CLASS:
		return "class";
	case Token.CONST:
		return "const";
	case Token.CONTINUE:
		return "continue";
	case Token.DEFAULT:
		return "default";
	case Token.DELEGATE:
		return "delegate";
	case Token.DO:
		return "do";
	case Token.ELSE:
		return "else";
	case Token.ENUM:
		return "enum";
	case Token.EVENT:
		return "event";
	case Token.EXPLICIT:
		return "explicit";
	case Token.EXTERN:
	case Token.EXTERN_ALIAS:
		return "extern";
	case Token.FALSE:
		return "false";
	case Token.FINALLY:
		return "finally";
	case Token.FIXED:
		return "fixed";
	case Token.FOR:
		return "for";
	case Token.FOREACH:
		return "foreach";
	case Token.GOTO:
		return "goto";
	case Token.IF:
		return "if";
	case Token.IMPLICIT:
		return "implicit";
	case Token.IN:
		return "in";
	case Token.INTERFACE:
		return "interface";
	case Token.INTERNAL:
		return "internal";
	case Token.IS:
		return "is";
	case Token.LOCK:
		return "lock";
	case Token.NAMESPACE:
		return "namespace";
	case Token.NEW:
		return "new";
	case Token.NULL:
		return "null";
	case Token.OPERATOR:
		return "operator";
	case Token.OUT:
		return "out";
	case Token.OVERRIDE:
		return "override";
	case Token.PARAMS:
		return "params";
	case Token.PRIVATE:
		return "private";
	case Token.PROTECTED:
		return "protected";
	case Token.PUBLIC:
		return "public";
	case Token.READONLY:
		return "readonly";
	case Token.REF:
		return "ref";
	case Token.RETURN:
		return "return";
	case Token.REMOVE:
		return "remove";
	case Token.SEALED:
		return "sealed";
	case Token.SIZEOF:
		return "sizeof";
	case Token.STACKALLOC:
		return "stackalloc";
	case Token.STATIC:
		return "static";
	case Token.STRUCT:
		return "struct";
	case Token.SWITCH:
		return "switch";
	case Token.THIS:
		return "this";
	case Token.THROW:
		return "throw";
	case Token.TRUE:
		return "true";
	case Token.TRY:
		return "try";
	case Token.TYPEOF:
		return "typeof";
	case Token.UNCHECKED:
		return "unchecked";
	case Token.UNSAFE:
		return "unsafe";
	case Token.USING:
		return "using";
	case Token.VIRTUAL:
		return "virtual";
	case Token.VOLATILE:
		return "volatile";
	case Token.WHERE:
		return "where";
	case Token.WHILE:
		return "while";
	case Token.ARGLIST:
		return "__arglist";
	case Token.REFVALUE:
		return "__refvalue";
	case Token.REFTYPE:
		return "__reftype";
	case Token.MAKEREF:
		return "__makeref";
	case Token.PARTIAL:
		return "partial";
	case Token.ARROW:
		return "=>";
	case Token.FROM:
	case Token.FROM_FIRST:
		return "from";
	case Token.JOIN:
		return "join";
	case Token.ON:
		return "on";
	case Token.EQUALS:
		return "equals";
	case Token.SELECT:
		return "select";
	case Token.GROUP:
		return "group";
	case Token.BY:
		return "by";
	case Token.LET:
		return "let";
	case Token.ORDERBY:
		return "orderby";
	case Token.ASCENDING:
		return "ascending";
	case Token.DESCENDING:
		return "descending";
	case Token.INTO:
		return "into";
	case Token.GET:
		return "get";
	case Token.SET:
		return "set";
	case Token.OPEN_BRACE:
		return "{";
	case Token.CLOSE_BRACE:
		return "}";
	case Token.OPEN_BRACKET:
	case Token.OPEN_BRACKET_EXPR:
		return "[";
	case Token.CLOSE_BRACKET:
		return "]";
	case Token.OPEN_PARENS_CAST:
	case Token.OPEN_PARENS_LAMBDA:
	case Token.OPEN_PARENS:
		return "(";
	case Token.CLOSE_PARENS:
		return ")";
	case Token.DOT:
		return ".";
	case Token.COMMA:
		return ",";
	case Token.DEFAULT_COLON:
		return "default:";
	case Token.COLON:
		return ":";
	case Token.SEMICOLON:
		return ";";
	case Token.TILDE:
		return "~";
		
	case Token.PLUS:
	case Token.UMINUS:
	case Token.MINUS:
	case Token.BANG:
	case Token.OP_LT:
	case Token.OP_GT:
	case Token.BITWISE_AND:
	case Token.BITWISE_OR:
	case Token.STAR:
	case Token.PERCENT:
	case Token.DIV:
	case Token.CARRET:
	case Token.OP_INC:
	case Token.OP_DEC:
	case Token.OP_SHIFT_LEFT:
	case Token.OP_SHIFT_RIGHT:
	case Token.OP_LE:
	case Token.OP_GE:
	case Token.OP_EQ:
	case Token.OP_NE:
	case Token.OP_AND:
	case Token.OP_OR:
	case Token.OP_PTR:
	case Token.OP_COALESCING:	
	case Token.OP_MULT_ASSIGN:
	case Token.OP_DIV_ASSIGN:
	case Token.OP_MOD_ASSIGN:
	case Token.OP_ADD_ASSIGN:
	case Token.OP_SUB_ASSIGN:
	case Token.OP_SHIFT_LEFT_ASSIGN:
	case Token.OP_SHIFT_RIGHT_ASSIGN:
	case Token.OP_AND_ASSIGN:
	case Token.OP_XOR_ASSIGN:
	case Token.OP_OR_ASSIGN:
		return "<operator>";

	case Token.BOOL:
	case Token.BYTE:
	case Token.CHAR:
	case Token.VOID:
	case Token.DECIMAL:
	case Token.DOUBLE:
	case Token.FLOAT:
	case Token.INT:
	case Token.LONG:
	case Token.SBYTE:
	case Token.SHORT:
	case Token.STRING:
	case Token.UINT:
	case Token.ULONG:
	case Token.USHORT:
	case Token.OBJECT:
		return "type";
	
	case Token.ASSIGN:
		return "=";
	case Token.OP_GENERICS_LT:
	case Token.GENERIC_DIMENSION:
		return "<";
	case Token.OP_GENERICS_GT:
		return ">";
	case Token.INTERR:
	case Token.INTERR_NULLABLE:
		return "?";
	case Token.DOUBLE_COLON:
		return "::";
	case Token.LITERAL:
		return "value";
	case Token.IDENTIFIER:
	case Token.AWAIT:
		return "identifier";

	case Token.EOF:
		return "end-of-file";

		// All of these are internal.
	case Token.NONE:
	case Token.ERROR:
	case Token.FIRST_KEYWORD:
	case Token.EVAL_COMPILATION_UNIT_PARSER:
	case Token.EVAL_USING_DECLARATIONS_UNIT_PARSER:
	case Token.EVAL_STATEMENT_PARSER:
	case Token.LAST_KEYWORD:
	case Token.GENERATE_COMPLETION:
	case Token.COMPLETE_COMPLETION:
		return "<internal>";

		// A bit more robust.
	default:
		return yyNames [token];
        }
}

/* end end end */
}
#line default
namespace yydebug {
        using System;
	 internal interface yyDebug {
		 void push (int state, Object value);
		 void lex (int state, int token, string name, Object value);
		 void shift (int from, int to, int errorFlag);
		 void pop (int state);
		 void discard (int state, int token, string name, Object value);
		 void reduce (int from, int to, int rule, string text, int len);
		 void shift (int from, int to);
		 void accept (Object value);
		 void error (string message);
		 void reject ();
	 }
	 
	 class yyDebugSimple : yyDebug {
		 void println (string s){
			 Console.Error.WriteLine (s);
		 }
		 
		 public void push (int state, Object value) {
			 println ("push\tstate "+state+"\tvalue "+value);
		 }
		 
		 public void lex (int state, int token, string name, Object value) {
			 println("lex\tstate "+state+"\treading "+name+"\tvalue "+value);
		 }
		 
		 public void shift (int from, int to, int errorFlag) {
			 switch (errorFlag) {
			 default:				// normally
				 println("shift\tfrom state "+from+" to "+to);
				 break;
			 case 0: case 1: case 2:		// in error recovery
				 println("shift\tfrom state "+from+" to "+to
					     +"\t"+errorFlag+" left to recover");
				 break;
			 case 3:				// normally
				 println("shift\tfrom state "+from+" to "+to+"\ton error");
				 break;
			 }
		 }
		 
		 public void pop (int state) {
			 println("pop\tstate "+state+"\ton error");
		 }
		 
		 public void discard (int state, int token, string name, Object value) {
			 println("discard\tstate "+state+"\ttoken "+name+"\tvalue "+value);
		 }
		 
		 public void reduce (int from, int to, int rule, string text, int len) {
			 println("reduce\tstate "+from+"\tuncover "+to
				     +"\trule ("+rule+") "+text);
		 }
		 
		 public void shift (int from, int to) {
			 println("goto\tfrom state "+from+" to "+to);
		 }
		 
		 public void accept (Object value) {
			 println("accept\tvalue "+value);
		 }
		 
		 public void error (string message) {
			 println("error\t"+message);
		 }
		 
		 public void reject () {
			 println("reject");
		 }
		 
	 }
}
// %token constants
 class Token {
  public const int EOF = 257;
  public const int NONE = 258;
  public const int ERROR = 259;
  public const int FIRST_KEYWORD = 260;
  public const int ABSTRACT = 261;
  public const int AS = 262;
  public const int ADD = 263;
  public const int BASE = 264;
  public const int BOOL = 265;
  public const int BREAK = 266;
  public const int BYTE = 267;
  public const int CASE = 268;
  public const int CATCH = 269;
  public const int CHAR = 270;
  public const int CHECKED = 271;
  public const int CLASS = 272;
  public const int CONST = 273;
  public const int CONTINUE = 274;
  public const int DECIMAL = 275;
  public const int DEFAULT = 276;
  public const int DELEGATE = 277;
  public const int DO = 278;
  public const int DOUBLE = 279;
  public const int ELSE = 280;
  public const int ENUM = 281;
  public const int EVENT = 282;
  public const int EXPLICIT = 283;
  public const int EXTERN = 284;
  public const int FALSE = 285;
  public const int FINALLY = 286;
  public const int FIXED = 287;
  public const int FLOAT = 288;
  public const int FOR = 289;
  public const int FOREACH = 290;
  public const int GOTO = 291;
  public const int IF = 292;
  public const int IMPLICIT = 293;
  public const int IN = 294;
  public const int INT = 295;
  public const int INTERFACE = 296;
  public const int INTERNAL = 297;
  public const int IS = 298;
  public const int LOCK = 299;
  public const int LONG = 300;
  public const int NAMESPACE = 301;
  public const int NEW = 302;
  public const int NULL = 303;
  public const int OBJECT = 304;
  public const int OPERATOR = 305;
  public const int OUT = 306;
  public const int OVERRIDE = 307;
  public const int PARAMS = 308;
  public const int PRIVATE = 309;
  public const int PROTECTED = 310;
  public const int PUBLIC = 311;
  public const int READONLY = 312;
  public const int REF = 313;
  public const int RETURN = 314;
  public const int REMOVE = 315;
  public const int SBYTE = 316;
  public const int SEALED = 317;
  public const int SHORT = 318;
  public const int SIZEOF = 319;
  public const int STACKALLOC = 320;
  public const int STATIC = 321;
  public const int STRING = 322;
  public const int STRUCT = 323;
  public const int SWITCH = 324;
  public const int THIS = 325;
  public const int THROW = 326;
  public const int TRUE = 327;
  public const int TRY = 328;
  public const int TYPEOF = 329;
  public const int UINT = 330;
  public const int ULONG = 331;
  public const int UNCHECKED = 332;
  public const int UNSAFE = 333;
  public const int USHORT = 334;
  public const int USING = 335;
  public const int VIRTUAL = 336;
  public const int VOID = 337;
  public const int VOLATILE = 338;
  public const int WHERE = 339;
  public const int WHILE = 340;
  public const int ARGLIST = 341;
  public const int PARTIAL = 342;
  public const int ARROW = 343;
  public const int FROM = 344;
  public const int FROM_FIRST = 345;
  public const int JOIN = 346;
  public const int ON = 347;
  public const int EQUALS = 348;
  public const int SELECT = 349;
  public const int GROUP = 350;
  public const int BY = 351;
  public const int LET = 352;
  public const int ORDERBY = 353;
  public const int ASCENDING = 354;
  public const int DESCENDING = 355;
  public const int INTO = 356;
  public const int INTERR_NULLABLE = 357;
  public const int EXTERN_ALIAS = 358;
  public const int REFVALUE = 359;
  public const int REFTYPE = 360;
  public const int MAKEREF = 361;
  public const int ASYNC = 362;
  public const int AWAIT = 363;
  public const int INTERR_OPERATOR = 364;
  public const int GET = 365;
  public const int SET = 366;
  public const int LAST_KEYWORD = 367;
  public const int OPEN_BRACE = 368;
  public const int CLOSE_BRACE = 369;
  public const int OPEN_BRACKET = 370;
  public const int CLOSE_BRACKET = 371;
  public const int OPEN_PARENS = 372;
  public const int CLOSE_PARENS = 373;
  public const int DOT = 374;
  public const int COMMA = 375;
  public const int COLON = 376;
  public const int SEMICOLON = 377;
  public const int TILDE = 378;
  public const int PLUS = 379;
  public const int MINUS = 380;
  public const int BANG = 381;
  public const int ASSIGN = 382;
  public const int OP_LT = 383;
  public const int OP_GT = 384;
  public const int BITWISE_AND = 385;
  public const int BITWISE_OR = 386;
  public const int STAR = 387;
  public const int PERCENT = 388;
  public const int DIV = 389;
  public const int CARRET = 390;
  public const int INTERR = 391;
  public const int DOUBLE_COLON = 392;
  public const int OP_INC = 393;
  public const int OP_DEC = 394;
  public const int OP_SHIFT_LEFT = 395;
  public const int OP_SHIFT_RIGHT = 396;
  public const int OP_LE = 397;
  public const int OP_GE = 398;
  public const int OP_EQ = 399;
  public const int OP_NE = 400;
  public const int OP_AND = 401;
  public const int OP_OR = 402;
  public const int OP_MULT_ASSIGN = 403;
  public const int OP_DIV_ASSIGN = 404;
  public const int OP_MOD_ASSIGN = 405;
  public const int OP_ADD_ASSIGN = 406;
  public const int OP_SUB_ASSIGN = 407;
  public const int OP_SHIFT_LEFT_ASSIGN = 408;
  public const int OP_SHIFT_RIGHT_ASSIGN = 409;
  public const int OP_AND_ASSIGN = 410;
  public const int OP_XOR_ASSIGN = 411;
  public const int OP_OR_ASSIGN = 412;
  public const int OP_PTR = 413;
  public const int OP_COALESCING = 414;
  public const int OP_GENERICS_LT = 415;
  public const int OP_GENERICS_LT_DECL = 416;
  public const int OP_GENERICS_GT = 417;
  public const int LITERAL = 418;
  public const int IDENTIFIER = 419;
  public const int OPEN_PARENS_LAMBDA = 420;
  public const int OPEN_PARENS_CAST = 421;
  public const int GENERIC_DIMENSION = 422;
  public const int DEFAULT_COLON = 423;
  public const int OPEN_BRACKET_EXPR = 424;
  public const int EVAL_STATEMENT_PARSER = 425;
  public const int EVAL_COMPILATION_UNIT_PARSER = 426;
  public const int EVAL_USING_DECLARATIONS_UNIT_PARSER = 427;
  public const int DOC_SEE = 428;
  public const int GENERATE_COMPLETION = 429;
  public const int COMPLETE_COMPLETION = 430;
  public const int UMINUS = 431;
  public const int yyErrorCode = 256;
 }
 namespace yyParser {
  using System;
  /** thrown for irrecoverable syntax errors and stack overflow.
    */
  internal class yyException : System.Exception {
    public yyException (string message) : base (message) {
    }
  }
  internal class yyUnexpectedEof : yyException {
    public yyUnexpectedEof (string message) : base (message) {
    }
    public yyUnexpectedEof () : base ("") {
    }
  }

  /** must be implemented by a scanner object to supply input to the parser.
    */
  internal interface yyInput {
    /** move on to next token.
        @return false if positioned beyond tokens.
        @throws IOException on input error.
      */
    bool advance (); // throws java.io.IOException;
    /** classifies current token.
        Should not be called if advance() returned false.
        @return current %token or single character.
      */
    int token ();
    /** associated with current token.
        Should not be called if advance() returned false.
        @return value for token().
      */
    Object value ();
  }
 }
} // close outermost namespace, that MUST HAVE BEEN opened in the prolog
