/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.editor;

import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.domain.ICompareEditingDomain;
import org.eclipse.emf.compare.ide.ui.internal.configuration.EMFCompareConfiguration;

public abstract class AbstractEMFCompareEditorInput
extends CompareEditorInput {
    private final ICompareEditingDomain editingDomain;
    private final AdapterFactory adapterFactory;

    public AbstractEMFCompareEditorInput(EMFCompareConfiguration configuration, ICompareEditingDomain editingDomain, AdapterFactory adapterFactory) {
        super((CompareConfiguration)configuration);
        this.editingDomain = (ICompareEditingDomain)Preconditions.checkNotNull((Object)editingDomain);
        this.adapterFactory = (AdapterFactory)Preconditions.checkNotNull((Object)adapterFactory);
    }

    protected AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    protected ICompareEditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void cancelPressed() {
        while (this.editingDomain.getCommandStack().canUndo()) {
            this.editingDomain.getCommandStack().undo();
        }
        super.cancelPressed();
    }

    protected final Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.getCompareConfiguration().setEditingDomain(this.editingDomain);
        return this.doPrepareInput(monitor);
    }

    public EMFCompareConfiguration getCompareConfiguration() {
        return (EMFCompareConfiguration)super.getCompareConfiguration();
    }

    protected abstract Object doPrepareInput(IProgressMonitor var1) throws InvocationTargetException, InterruptedException;
}

