/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.contracts.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.contracts.exceptions.AssumptionWithOffsetExeption;
import org.eclipse.fordiac.ide.contracts.model.AbstractTime;
import org.eclipse.fordiac.ide.contracts.model.Assumption;
import org.eclipse.fordiac.ide.contracts.model.Instant;
import org.eclipse.fordiac.ide.contracts.model.Interval;
import org.eclipse.fordiac.ide.contracts.model.helpers.ContractUtils;

public class AssumptionWithOffset
extends Assumption {
    private static final int POS_OFFSET = 7;
    private static final int POS_WITH = 5;
    private static final int ASSUMPTION_LENGTH = 8;
    private static final int POS_OCCURS = 2;
    private static final int POS_TIME = 4;
    private static final int POS_TIME2 = 6;
    private static final int POS_EVERY = 3;
    private static final int POSITION_NO2 = 6;
    private static final int POSITION_NO1 = 4;
    private AbstractTime offSet;

    AssumptionWithOffset() {
        throw new UnsupportedOperationException("AssumptionWithOffset not Implemented");
    }

    AbstractTime getOffSet() {
        return this.offSet;
    }

    void setOffSet(AbstractTime offSet) {
        this.offSet = offSet;
    }

    static Assumption createAssumptionWithOffset(String line) throws AssumptionWithOffsetExeption {
        String[] parts = line.split(" ");
        if (!AssumptionWithOffset.isCorrectAssumtion(parts)) {
            throw new AssumptionWithOffsetExeption("Error with Assumption: " + line);
        }
        AssumptionWithOffset assumption = new AssumptionWithOffset();
        assumption.setInputEvent(parts[1]);
        if (ContractUtils.isInterval(parts, 4, ",")) {
            assumption.setRangeFromInterval(parts, 4);
        } else {
            assumption.setTime(new Instant(Integer.parseInt(parts[4].substring(0, parts[4].length() - "ms".length()))));
        }
        if (ContractUtils.isInterval(parts, 6, ",")) {
            String[] number = parts[6].split(",");
            int minOffset = Integer.parseInt(number[0].substring(1));
            number = number[1].split("]");
            int maxOffset = Integer.parseInt(number[0]);
            assumption.setOffSet(new Interval(minOffset, maxOffset));
        } else {
            assumption.setOffSet(new Instant(Integer.parseInt(parts[6].substring(0, parts[6].length() - "ms".length()))));
        }
        return assumption;
    }

    private static boolean isCorrectAssumtion(String[] parts) {
        if (parts.length != 8) {
            return false;
        }
        if (!"occurs".equals(parts[2])) {
            return false;
        }
        if (!"every".equals(parts[3])) {
            return false;
        }
        if (!"ms".equals(parts[4].substring(ContractUtils.getStartPosition(parts, 4), parts[4].length()))) {
            return false;
        }
        if (!"with".equals(parts[5])) {
            return false;
        }
        if (!"ms".equals(parts[6].substring(ContractUtils.getStartPosition(parts, 6), parts[6].length()))) {
            return false;
        }
        return "offset".equals(parts[7]);
    }

    public int getMinOffset() {
        AbstractTime abstractTime = this.getOffSet();
        if (abstractTime instanceof Instant) {
            Instant instant = (Instant)abstractTime;
            return instant.getMin();
        }
        AbstractTime abstractTime2 = this.getOffSet();
        if (abstractTime2 instanceof Interval) {
            Interval interval = (Interval)abstractTime2;
            return interval.getMin();
        }
        return Integer.MIN_VALUE;
    }

    public int getMaxOffset() {
        AbstractTime abstractTime = this.getOffSet();
        if (abstractTime instanceof Instant) {
            Instant instant = (Instant)abstractTime;
            return instant.getMin();
        }
        AbstractTime abstractTime2 = this.getOffSet();
        if (abstractTime2 instanceof Interval) {
            Interval interval = (Interval)abstractTime2;
            return interval.getMax();
        }
        return Integer.MIN_VALUE;
    }

    public static boolean isCompatibleWithOffset(Iterable<Assumption> assumptions) {
        Assumption newAssumption;
        BasicEList normal = new BasicEList();
        BasicEList withOffset = new BasicEList();
        ((Collection)assumptions).parallelStream().forEach(arg_0 -> AssumptionWithOffset.lambda$0((EList)withOffset, (EList)normal, arg_0));
        if (normal.isEmpty() && withOffset.size() == 1) {
            return true;
        }
        if (normal.size() > 1) {
            if (!Assumption.isCompatibleWith((EList<Assumption>)normal)) {
                return false;
            }
            newAssumption = ((Assumption)normal.get(0)).getContract().getAssumptionWith(((Assumption)normal.get(0)).getInputEvent());
            normal.clear();
            normal.add((Object)newAssumption);
        }
        if (withOffset.size() != 1) {
            if (!AssumptionWithOffset.isCompatibleWithOffset((EList<AssumptionWithOffset>)withOffset)) {
                return false;
            }
            newAssumption = (AssumptionWithOffset)((AssumptionWithOffset)withOffset.get(0)).getContract().getAssumptionWith(((AssumptionWithOffset)withOffset.get(0)).getInputEvent());
            withOffset.clear();
            withOffset.add((Object)newAssumption);
        }
        return AssumptionWithOffset.compatibleWithAndWithout((Assumption)normal.get(0), (AssumptionWithOffset)withOffset.get(0));
    }

    private static boolean compatibleWithAndWithout(Assumption assumption, AssumptionWithOffset assumptionWithOffset) {
        return false;
    }

    private static boolean isCompatibleWithOffset(EList<AssumptionWithOffset> withOffset) {
        int mini = ((AssumptionWithOffset)withOffset.get(0)).getMin();
        int maxi = ((AssumptionWithOffset)withOffset.get(0)).getMax();
        int miniOffest = ((AssumptionWithOffset)withOffset.get(0)).getMinOffset();
        int maxiOffset = ((AssumptionWithOffset)withOffset.get(0)).getMaxOffset();
        if (maxi == -1) {
            maxi = mini;
        }
        if (maxiOffset == -1) {
            maxiOffset = miniOffest;
        }
        int i = 1;
        while (withOffset.size() > i) {
            if (mini < ((AssumptionWithOffset)withOffset.get(i)).getMin()) {
                mini = ((AssumptionWithOffset)withOffset.get(i)).getMin();
            }
            if (maxi > ((AssumptionWithOffset)withOffset.get(i)).getMax()) {
                maxi = ((AssumptionWithOffset)withOffset.get(i)).getMax();
            }
            if (miniOffest < ((AssumptionWithOffset)withOffset.get(i)).getMinOffset()) {
                miniOffest = ((AssumptionWithOffset)withOffset.get(i)).getMinOffset();
            }
            if (maxiOffset > ((AssumptionWithOffset)withOffset.get(i)).getMaxOffset()) {
                maxiOffset = ((AssumptionWithOffset)withOffset.get(i)).getMaxOffset();
            }
            ++i;
        }
        if (mini > maxi || miniOffest > maxiOffset) {
            return false;
        }
        AssumptionWithOffset.simplifyAssumptionWithOffset((AssumptionWithOffset)withOffset.get(0), mini, maxi, miniOffest, maxiOffset);
        return true;
    }

    private static void simplifyAssumptionWithOffset(AssumptionWithOffset toRemove, int min, int max, int minOffest, int maxOffset) {
        toRemove.getContract().getAssumptions().removeIf(a -> a.getInputEvent().equals(toRemove.getInputEvent()) && a instanceof AssumptionWithOffset);
        AssumptionWithOffset toAdd = new AssumptionWithOffset();
        toAdd.setInputEvent(toRemove.getInputEvent());
        toAdd.setTime(new Interval(min, max));
        toAdd.setOffSet(new Interval(minOffest, maxOffset));
        toRemove.getContract().add(toAdd, toRemove.getContract());
    }

    @Override
    public String asString() {
        StringBuilder comment = new StringBuilder();
        if (this.getMax() == -1 || this.getMax() == this.getMin()) {
            comment.append(ContractUtils.createAssumptionString(this.getInputEvent(), String.valueOf(this.getMin())));
        } else {
            comment.append(ContractUtils.createAssumptionString(this.getInputEvent(), ContractUtils.createInterval(this)));
        }
        comment.append(" ");
        comment.append("with");
        comment.append(" ");
        if (this.getMaxOffset() == -1 || this.getMaxOffset() == this.getMinOffset()) {
            comment.append(this.getMinOffset());
        } else {
            comment.append("[");
            comment.append(this.getMinOffset());
            comment.append(",");
            comment.append(this.getMaxOffset());
            comment.append("]");
        }
        comment.append("ms");
        comment.append(" ");
        comment.append("offset");
        comment.append(System.lineSeparator());
        return comment.toString();
    }

    @Override
    List<AbstractTime> getOccurrences(int number) {
        if (number < 1) {
            return Collections.emptyList();
        }
        ArrayList<AbstractTime> timestamps = new ArrayList<AbstractTime>();
        timestamps.add(this.getFirstTime());
        int i = 0;
        while (i < number - 1) {
            timestamps.add(((AbstractTime)timestamps.get(i)).add(this.getBounds()));
            ++i;
        }
        return timestamps;
    }

    @Override
    List<AbstractTime> getOccurrences(Interval range) {
        ArrayList<AbstractTime> timestamps = new ArrayList<AbstractTime>();
        AbstractTime toAdd = this.getFirstTime();
        if (toAdd instanceof Instant) {
            Instant instant = (Instant)toAdd;
            while (instant.getMin() <= range.getMax()) {
                if (instant.getMin() >= range.getMin()) {
                    timestamps.add(instant);
                }
                instant = new Instant(instant.getMin() + this.getMin());
            }
        } else {
            Interval interval = (Interval)toAdd;
            while (interval.getMax() <= range.getMax()) {
                if (interval.getMin() >= range.getMin()) {
                    timestamps.add(interval);
                }
                interval = interval.add(this.getBounds());
            }
        }
        return timestamps;
    }

    private AbstractTime getFirstTime() {
        if (this.getMax() == -1 && this.getMaxOffset() == -1) {
            return new Instant(this.getMin() + this.getMinOffset());
        }
        int min = this.getMin() + this.getMinOffset();
        int max = 0;
        max = this.getMax() == -1 ? (max += this.getMin()) : (max += this.getMax());
        max = this.getMaxOffset() == -1 ? (max += this.getMinOffset()) : (max += this.getMaxOffset());
        return new Interval(min, max);
    }

    private static /* synthetic */ void lambda$0(EList eList, EList eList2, Assumption a) {
        if (a instanceof AssumptionWithOffset) {
            AssumptionWithOffset toAdd = (AssumptionWithOffset)a;
            eList.add((Object)toAdd);
        } else {
            eList2.add((Object)a);
        }
    }
}

