/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.contracts.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.contracts.exceptions.ContractExeption;
import org.eclipse.fordiac.ide.contracts.exceptions.GuaranteeExeption;
import org.eclipse.fordiac.ide.contracts.model.AbstractTime;
import org.eclipse.fordiac.ide.contracts.model.Contract;
import org.eclipse.fordiac.ide.contracts.model.ContractElement;
import org.eclipse.fordiac.ide.contracts.model.GuaranteeTwoEvents;
import org.eclipse.fordiac.ide.contracts.model.Interval;
import org.eclipse.fordiac.ide.contracts.model.Reaction;
import org.eclipse.fordiac.ide.contracts.model.helpers.ContractUtils;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;

public class Guarantee
extends ContractElement {
    private static final int POS_MS = 10;
    private static final int POS_WITHIN = 9;
    private static final int POS_OCCUR = 8;
    private static final int POS_EVENT_STRING = 6;
    private static final int POS_THEN = 5;
    private static final int POS_OCCURS = 4;
    private static final int POS_EVENT = 2;
    private static final int POS_WHENEVER = 1;
    private static final int GUARANTEE_LENGTH = 11;
    private static final int POS_OUTPUT_EVENT = 7;
    private static final int POS_INPUT_EVENT = 3;
    private static final int POSITION_NO = 10;
    private String outputEvent;

    Guarantee() {
    }

    public Guarantee(String inputEvent, String outputEvent, AbstractTime time) {
        super(inputEvent, time);
        this.outputEvent = outputEvent;
    }

    public String getOutputEvent() {
        return this.outputEvent;
    }

    void setOutputEvent(String outputEvent) {
        this.outputEvent = outputEvent;
    }

    public static Guarantee createGuarantee(String line) throws ContractExeption {
        if (line.contains("Reaction")) {
            return Reaction.createReaction(line);
        }
        if (line.contains("events")) {
            return GuaranteeTwoEvents.createGuaranteeTwoEvents(line);
        }
        String[] parts = line.split(" ");
        if (!Guarantee.isCorrectGuarantee(parts)) {
            throw new GuaranteeExeption("Error with Guarantee: " + line);
        }
        Guarantee guarantee = new Guarantee();
        guarantee.setInputEvent(parts[3]);
        guarantee.setOutputEvent(parts[7]);
        if (ContractUtils.isInterval(parts, 10, ",")) {
            guarantee.setRangeFromInterval(parts, 10);
            return guarantee;
        }
        guarantee.setTime(new Interval(0, Integer.parseInt(parts[10].substring(0, parts[10].length() - "ms".length()))));
        return guarantee;
    }

    private static boolean isCorrectGuarantee(String[] parts) {
        if (!Guarantee.hasCorrectBeginning(parts)) {
            return false;
        }
        if (!"event".equals(parts[6])) {
            return false;
        }
        if (!"occurs".equals(parts[8])) {
            return false;
        }
        if (!"within".equals(parts[9])) {
            return false;
        }
        return "ms".equals(parts[10].subSequence(ContractUtils.getStartPosition(parts, 10), parts[10].length()));
    }

    protected static boolean hasCorrectBeginning(String[] parts) {
        if (parts.length != 11) {
            return false;
        }
        if (!"Whenever".equals(parts[1])) {
            return false;
        }
        if (!"event".equals(parts[2])) {
            return false;
        }
        if (!"occurs,".equals(parts[4])) {
            return false;
        }
        return "then".equals(parts[5]);
    }

    @Override
    boolean isValid() {
        Guarantee guarantee = this;
        if (guarantee instanceof GuaranteeTwoEvents) {
            GuaranteeTwoEvents guaranteeTwoEvents = (GuaranteeTwoEvents)guarantee;
            return guaranteeTwoEvents.isValid();
        }
        if (!this.hasValidOwner()) {
            return false;
        }
        EList fBNetworkElements = ((SubApp)this.getContract().getOwner()).getSubAppNetwork().getNetworkElements();
        List<SubApp> containedSubapps = fBNetworkElements.stream().filter(ContractUtils::isContractSubapp).map(el -> (SubApp)el).toList();
        List<FB> containedfBs = fBNetworkElements.stream().filter(FB.class::isInstance).map(FB.class::cast).toList();
        return this.hasMatchingEvent((SubApp)this.getContract().getOwner(), containedSubapps, containedfBs);
    }

    private boolean hasMatchingEvent(SubApp subapp, List<SubApp> containedSubapps, List<FB> containedfBs) {
        List<Event> outputNames;
        List<Event> inputNames;
        if (!containedSubapps.isEmpty()) {
            EList inputEvents = subapp.getInterface().getEventInputs();
            EList outputEvents = subapp.getInterface().getEventOutputs();
            inputNames = inputEvents.stream().filter(e -> e.getName().equals(this.getInputEvent())).toList();
            outputNames = outputEvents.stream().filter(e -> e.getName().equals(this.outputEvent)).toList();
            if (inputNames.size() == 1 && outputNames.size() == 1) {
                return true;
            }
        }
        if (containedfBs.size() == 1) {
            EList inputFBEvents = containedfBs.get(0).getInterface().getEventInputs();
            EList outputFBEvents = containedfBs.get(0).getInterface().getEventOutputs();
            inputNames = inputFBEvents.stream().filter(e -> e.getName().equals(this.getInputEvent())).toList();
            outputNames = outputFBEvents.stream().filter(e -> e.getName().equals(this.outputEvent)).toList();
            if (inputNames.size() == 1 && outputNames.size() == 1) {
                return true;
            }
        }
        return false;
    }

    private static void sortHelper(Map<String, EList<Guarantee>> mapGuarantees, Map<String, EList<Reaction>> mapReactions, Map<String, EList<GuaranteeTwoEvents>> mapGuaranteeTwoEvents, Guarantee guarantee) {
        if (guarantee instanceof GuaranteeTwoEvents) {
            GuaranteeTwoEvents guaranteeTwoEvents = (GuaranteeTwoEvents)guarantee;
            if (mapGuaranteeTwoEvents.containsKey(guaranteeTwoEvents.getOutputEvent())) {
                mapGuaranteeTwoEvents.get(guaranteeTwoEvents.getOutputEvent()).add((Object)guaranteeTwoEvents);
            } else {
                BasicEList toAdd = new BasicEList();
                toAdd.add((Object)guaranteeTwoEvents);
                mapGuaranteeTwoEvents.put(guaranteeTwoEvents.getOutputEvent(), (EList<GuaranteeTwoEvents>)toAdd);
            }
        } else if (guarantee instanceof Reaction) {
            Reaction reaction = (Reaction)guarantee;
            if (mapReactions.containsKey(reaction.getOutputEvent())) {
                mapReactions.get(reaction.getOutputEvent()).add((Object)reaction);
            } else {
                BasicEList toAdd = new BasicEList();
                toAdd.add((Object)reaction);
                mapReactions.put(reaction.getOutputEvent(), (EList<Reaction>)toAdd);
            }
        } else if (mapGuarantees.containsKey(guarantee.getOutputEvent())) {
            mapGuarantees.get(guarantee.getOutputEvent()).add((Object)guarantee);
        } else {
            BasicEList toAdd = new BasicEList();
            toAdd.add((Object)guarantee);
            mapGuarantees.put(guarantee.getOutputEvent(), (EList<Guarantee>)toAdd);
        }
    }

    public static boolean isCompatibleWith(Iterable<Guarantee> guarantees) {
        HashMap<String, EList<Guarantee>> mapGuarantees = new HashMap<String, EList<Guarantee>>();
        HashMap<String, EList<Reaction>> mapReactions = new HashMap<String, EList<Reaction>>();
        HashMap<String, EList<GuaranteeTwoEvents>> mapGuaranteeTwoEvents = new HashMap<String, EList<GuaranteeTwoEvents>>();
        Consumer<Guarantee> sort = guarantee -> Guarantee.sortHelper(mapGuarantees, mapReactions, mapGuaranteeTwoEvents, guarantee);
        ((Collection)guarantees).stream().forEach(sort);
        if (mapGuaranteeTwoEvents.size() > 0) {
            return GuaranteeTwoEvents.isCompatibleWith(mapGuarantees, mapReactions, mapGuaranteeTwoEvents);
        }
        if (mapReactions.size() > 0) {
            return Reaction.isCompatibleWith(mapGuarantees, mapReactions);
        }
        for (Map.Entry entry : mapGuarantees.entrySet()) {
            if (((EList)entry.getValue()).size() == 1 || Contract.isTimeConsistent((EList<? extends ContractElement>)((EList)entry.getValue()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public String asString() {
        Guarantee guarantee = this;
        if (guarantee instanceof Reaction) {
            Reaction reaction = (Reaction)guarantee;
            return reaction.asString();
        }
        Guarantee guarantee2 = this;
        if (guarantee2 instanceof GuaranteeTwoEvents) {
            GuaranteeTwoEvents twoEvents = (GuaranteeTwoEvents)guarantee2;
            return twoEvents.asString();
        }
        StringBuilder comment = new StringBuilder();
        if (this.getMin() == 0 || this.getMin() == this.getMax()) {
            comment.append(ContractUtils.createGuaranteeString(this.getInputEvent(), this.outputEvent, String.valueOf(this.getMax())));
        } else {
            comment.append(ContractUtils.createGuaranteeString(this.getInputEvent(), this.outputEvent, ContractUtils.createInterval(this)));
        }
        comment.append(System.lineSeparator());
        return comment.toString();
    }
}

