/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.eval;

import org.eclipse.fordiac.ide.deployment.eval.fb.DeploymentFBEvaluator;
import org.eclipse.fordiac.ide.deployment.eval.fb.DeploymentFunctionFBEvaluator;
import org.eclipse.fordiac.ide.model.eval.Evaluator;
import org.eclipse.fordiac.ide.model.eval.EvaluatorFactory;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.FunctionFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceInterfaceFBType;
import org.eclipse.fordiac.ide.model.libraryElement.SimpleFBType;

public class DeploymentEvaluatorFactory
implements EvaluatorFactory {
    public static final String DEPLOYMENT_VARIANT = "deployment";

    public Evaluator createEvaluator(Object source, Variable<?> context, Iterable<Variable<?>> variables, Evaluator parent) {
        if (source instanceof FunctionFBType) {
            FunctionFBType functionFBType = (FunctionFBType)source;
            return new DeploymentFunctionFBEvaluator(functionFBType, context, variables, parent);
        }
        if (source instanceof FBType) {
            FBType fbType = (FBType)source;
            return new DeploymentFBEvaluator<FBType>(fbType, context, variables, parent);
        }
        return null;
    }

    public static void register() {
        DeploymentEvaluatorFactory factory = new DeploymentEvaluatorFactory();
        EvaluatorFactory.Registry.INSTANCE.registerFactory("default", ServiceInterfaceFBType.class, (EvaluatorFactory)factory);
        EvaluatorFactory.Registry.INSTANCE.registerFactory(DEPLOYMENT_VARIANT, SimpleFBType.class, (EvaluatorFactory)factory);
        EvaluatorFactory.Registry.INSTANCE.registerFactory(DEPLOYMENT_VARIANT, BasicFBType.class, (EvaluatorFactory)factory);
        EvaluatorFactory.Registry.INSTANCE.registerFactory(DEPLOYMENT_VARIANT, FunctionFBType.class, (EvaluatorFactory)factory);
        EvaluatorFactory.Registry.INSTANCE.registerFactory(DEPLOYMENT_VARIANT, ServiceInterfaceFBType.class, (EvaluatorFactory)factory);
    }
}

