/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.draw2d;

import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.model.data.EventType;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.ui.preferences.PreferenceGetter;
import org.eclipse.swt.graphics.Color;

public class ConnectorBorder
extends AbstractBorder {
    private static final int CONNECTOR_WIDTH = 5;
    private static final int CONNECTOR_HEIGHT = 10;
    private static final int CONNECTOR_HEIGHT_HALF = 5;
    private static final int ADAPTER_SIZE = 9;
    public static final int LR_MARGIN = 6;
    protected static final int LR_ADAPTER_MARGIN = 11;
    private static final int[] TRIANGLE_POINTS;
    private static final PointList TRIANGLE_POINT_LIST;
    private static final int[] DIAMOND_POINTS;
    private static final PointList DIAMOND_POINT_LIST;
    private final IInterfaceElement editPartModelOject;
    private Color connectorColor;

    static {
        int[] nArray = new int[6];
        nArray[2] = 5;
        nArray[3] = 5;
        nArray[5] = 10;
        TRIANGLE_POINTS = nArray;
        TRIANGLE_POINT_LIST = new PointList(TRIANGLE_POINTS);
        int[] nArray2 = new int[8];
        nArray2[2] = 5;
        nArray2[3] = -5;
        nArray2[4] = 10;
        nArray2[6] = 5;
        nArray2[7] = 5;
        DIAMOND_POINTS = nArray2;
        DIAMOND_POINT_LIST = new PointList(DIAMOND_POINTS);
    }

    public ConnectorBorder(IInterfaceElement editPartModelOject) {
        this.editPartModelOject = editPartModelOject;
        this.updateColor();
    }

    protected IInterfaceElement getEditPartModelOject() {
        return this.editPartModelOject;
    }

    public final void updateColor() {
        this.connectorColor = this.isEvent() ? PreferenceGetter.getColor((String)"EventConnectionConnectorColor") : (this.isAdapter() ? PreferenceGetter.getColor((String)"AdapterConnectionConnectorColor") : PreferenceGetter.getDataColor((String)this.editPartModelOject.getType().getName()));
    }

    protected static void createAdapterSymbolMiniFBrotated(Graphics graphics, Rectangle where, int width, boolean filled) {
        graphics.setLineWidth(1);
        graphics.setAntialias(1);
        where.x += width;
        where.y += (where.height - 9) / 2;
        PointList points = new PointList();
        points.addPoint(where.x, where.y);
        if (filled) {
            points.addPoint(where.x + 2, where.y);
            points.addPoint(where.x + 2, where.y + 2);
            points.addPoint(where.x + 4, where.y + 2);
            points.addPoint(where.x + 4, where.y);
            points.addPoint(where.x + 8, where.y);
            points.addPoint(where.x + 8, where.y + 8);
            points.addPoint(where.x + 4, where.y + 8);
            points.addPoint(where.x + 4, where.y + 6);
            points.addPoint(where.x + 2, where.y + 6);
            points.addPoint(where.x + 2, where.y + 8);
            points.addPoint(where.x, where.y + 8);
            points.addPoint(where.x, where.y);
            graphics.fillPolygon(points);
        } else {
            points.addPoint(where.x + 4, where.y);
            points.addPoint(where.x + 4, where.y + 2);
            points.addPoint(where.x + 6, where.y + 2);
            points.addPoint(where.x + 6, where.y);
            points.addPoint(where.x + 8, where.y);
            points.addPoint(where.x + 8, where.y + 8);
            points.addPoint(where.x + 6, where.y + 8);
            points.addPoint(where.x + 6, where.y + 6);
            points.addPoint(where.x + 4, where.y + 6);
            points.addPoint(where.x + 4, where.y + 8);
            points.addPoint(where.x, where.y + 8);
            points.addPoint(where.x, where.y);
            graphics.drawPolygon(points);
        }
    }

    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        graphics.setForegroundColor(this.connectorColor);
        graphics.setBackgroundColor(this.connectorColor);
        Rectangle where = ConnectorBorder.getPaintRectangle((IFigure)figure, (Insets)insets);
        if (this.isInput()) {
            if (this.isAdapter()) {
                ConnectorBorder.createAdapterSymbolMiniFBrotated(graphics, where, 0, false);
            } else if (this.isVarInOut()) {
                ConnectorBorder.drawFilledPolygonAt(graphics, where.x, where.y + where.height / 2, DIAMOND_POINT_LIST);
            } else {
                ConnectorBorder.drawFilledPolygonAt(graphics, where.x, where.y + (where.height - 10) / 2, TRIANGLE_POINT_LIST);
            }
        } else if (this.isAdapter()) {
            ConnectorBorder.createAdapterSymbolMiniFBrotated(graphics, where, where.width - 9 + 1, true);
        } else if (this.isVarInOut()) {
            ConnectorBorder.drawFilledPolygonAt(graphics, where.width + where.x - 10, where.y + where.height / 2, DIAMOND_POINT_LIST);
        } else {
            ConnectorBorder.drawFilledPolygonAt(graphics, where.x + where.width - 5, where.y + (where.height - 10) / 2, TRIANGLE_POINT_LIST);
        }
    }

    private static void drawFilledPolygonAt(Graphics graphics, int startX, int startY, PointList points) {
        graphics.translate(startX, startY);
        graphics.fillPolygon(points);
        graphics.translate(-startX, -startY);
    }

    public Insets getInsets(IFigure figure) {
        int lrMargin = this.getLRMargin();
        return this.isInput() ? new Insets(0, lrMargin, 0, 0) : new Insets(0, 0, 0, lrMargin);
    }

    protected int getLRMargin() {
        int lrMargin = 6;
        if (this.isAdapter()) {
            lrMargin = 11;
        } else if (this.isVarInOut()) {
            lrMargin *= 2;
        }
        return lrMargin;
    }

    public boolean isInput() {
        return this.editPartModelOject.isIsInput();
    }

    public final boolean isEvent() {
        return this.editPartModelOject.getType() instanceof EventType;
    }

    public final boolean isAdapter() {
        return this.editPartModelOject.getType() instanceof AdapterType;
    }

    private final boolean isVarInOut() {
        VarDeclaration varDecl;
        IInterfaceElement iInterfaceElement = this.editPartModelOject;
        return iInterfaceElement instanceof VarDeclaration && (varDecl = (VarDeclaration)iInterfaceElement).isInOutVar();
    }
}

