/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.properties;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.gef.filters.AttributeFilter;
import org.eclipse.fordiac.ide.gef.nat.AttributeColumnAccessor;
import org.eclipse.fordiac.ide.gef.nat.AttributeConfigLabelAccumulator;
import org.eclipse.fordiac.ide.gef.nat.AttributeEditableRule;
import org.eclipse.fordiac.ide.gef.nat.AttributeTableColumn;
import org.eclipse.fordiac.ide.gef.nat.DefaultImportCopyPasteLayerConfiguration;
import org.eclipse.fordiac.ide.gef.nat.InitialValueEditorConfiguration;
import org.eclipse.fordiac.ide.gef.properties.AbstractSection;
import org.eclipse.fordiac.ide.model.commands.change.ChangeAttributeOrderCommand;
import org.eclipse.fordiac.ide.model.commands.create.AddNewImportCommand;
import org.eclipse.fordiac.ide.model.commands.create.CreateAttributeCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteAttributeCommand;
import org.eclipse.fordiac.ide.model.data.InternalDataType;
import org.eclipse.fordiac.ide.model.datatype.helper.InternalAttributeDeclarations;
import org.eclipse.fordiac.ide.model.helpers.ImportHelper;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.AttributeDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableObject;
import org.eclipse.fordiac.ide.model.libraryElement.ITypedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.ui.nat.DataTypeSelectionTreeContentProvider;
import org.eclipse.fordiac.ide.model.ui.nat.TypeSelectionTreeContentProvider;
import org.eclipse.fordiac.ide.model.ui.widgets.AttributeSelectionContentProvider;
import org.eclipse.fordiac.ide.model.ui.widgets.DataTypeSelectionContentProvider;
import org.eclipse.fordiac.ide.model.ui.widgets.ITypeSelectionContentProvider;
import org.eclipse.fordiac.ide.model.ui.widgets.ImportContentProposal;
import org.eclipse.fordiac.ide.model.ui.widgets.ImportTypeSelectionProposalProvider;
import org.eclipse.fordiac.ide.model.ui.widgets.TypeSelectionButton;
import org.eclipse.fordiac.ide.ui.widget.AddDeleteReorderListWidget;
import org.eclipse.fordiac.ide.ui.widget.ChangeableListDataProvider;
import org.eclipse.fordiac.ide.ui.widget.CommandExecutor;
import org.eclipse.fordiac.ide.ui.widget.I4diacNatTableUtil;
import org.eclipse.fordiac.ide.ui.widget.IChangeableRowDataProvider;
import org.eclipse.fordiac.ide.ui.widget.NatTableColumn;
import org.eclipse.fordiac.ide.ui.widget.NatTableColumnProvider;
import org.eclipse.fordiac.ide.ui.widget.NatTableWidgetFactory;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IEditableRule;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.TextCellEditor;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class AttributeSection
extends AbstractSection
implements I4diacNatTableUtil {
    protected IChangeableRowDataProvider<Attribute> provider;
    protected NatTable table;

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.createAttributesControls(parent);
    }

    public void createAttributesControls(Composite parent) {
        Composite composite = this.getWidgetFactory().createComposite(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        AddDeleteReorderListWidget buttons = new AddDeleteReorderListWidget();
        buttons.createControls(composite, (FormToolkit)this.getWidgetFactory());
        this.provider = new ChangeableListDataProvider((IColumnAccessor)new AttributeColumnAccessor(this));
        DataLayer dataLayer = new DataLayer(this.provider);
        dataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)new AttributeConfigLabelAccumulator((IRowDataProvider<Attribute>)this.provider, this::getAnnotationModel));
        NatTableColumnProvider columnProvider = new NatTableColumnProvider(AttributeTableColumn.DEFAULT_COLUMNS);
        this.table = NatTableWidgetFactory.createRowNatTable((Composite)composite, (DataLayer)dataLayer, (IDataProvider)columnProvider, (IEditableRule)new AttributeEditableRule(IEditableRule.ALWAYS_EDITABLE, AttributeTableColumn.DEFAULT_COLUMNS, (IRowDataProvider<Attribute>)this.provider), (ICellEditor)new TypeSelectionButton(this::getTypeLibrary, (ITypeSelectionContentProvider)DataTypeSelectionContentProvider.INSTANCE, (TypeSelectionTreeContentProvider)DataTypeSelectionTreeContentProvider.INSTANCE), (I4diacNatTableUtil)this, (boolean)false);
        this.table.addConfiguration((IConfiguration)new InitialValueEditorConfiguration((IRowDataProvider<? extends ITypedElement>)this.provider));
        Predicate<TypeEntry> targetFilter = entry -> {
            LibraryElement libraryElement = entry.getType();
            if (libraryElement instanceof AttributeDeclaration) {
                AttributeDeclaration decl = (AttributeDeclaration)libraryElement;
                return decl.isValidObject(this.getType());
            }
            return true;
        };
        final AttributeNameCellEditor attributeNameCellEditor = new AttributeNameCellEditor();
        attributeNameCellEditor.enableContentProposal((IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)new ImportTypeSelectionProposalProvider(this::getType, TypeLibrary::getAttributeTypeEntry, (ITypeSelectionContentProvider)AttributeSelectionContentProvider.INSTANCE, targetFilter), KeyStroke.getInstance((int)262144, (int)32), null);
        this.table.addConfiguration((IConfiguration)new AbstractRegistryConfiguration(){

            public void configureRegistry(IConfigRegistry configRegistry) {
                configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)attributeNameCellEditor, DisplayMode.EDIT, "ATTRIBUTE_PROPOSAL_CELL");
            }
        });
        this.table.addConfiguration((IConfiguration)new DefaultImportCopyPasteLayerConfiguration((NatTableColumnProvider<? extends NatTableColumn>)columnProvider, this));
        this.table.configure();
        buttons.bindToTableViewer(this.table, (CommandExecutor)this, ref -> CreateAttributeCommand.forTemplate((ConfigurableObject)this.getType(), (Attribute)this.getLastSelectedAttribute(), (int)this.getInsertionIndex()), ref -> new DeleteAttributeCommand(this.getType(), this.getLastSelectedAttribute()), ref -> new ChangeAttributeOrderCommand(this.getType(), (Attribute)ref, this.getNeighbourListItem((Attribute)ref, true)), ref -> new ChangeAttributeOrderCommand(this.getType(), (Attribute)ref, this.getNeighbourListItem((Attribute)ref, false)));
    }

    private Attribute getNeighbourListItem(Attribute ref, boolean above) {
        List<Attribute> filtered = this.getType().getAttributes().stream().filter(att -> !(att.getType() instanceof InternalDataType)).toList();
        int idx = filtered.indexOf(ref);
        idx = above ? (idx > 0 ? idx - 1 : 0) : (idx < filtered.size() - 1 ? idx + 1 : filtered.size() - 1);
        return filtered.get(idx);
    }

    private int getInsertionIndex() {
        Attribute attribute = this.getLastSelectedAttribute();
        if (attribute == null) {
            return this.getType().getAttributes().size();
        }
        return this.getType().getAttributes().indexOf((Object)attribute) + 1;
    }

    private Attribute getLastSelectedAttribute() {
        return (Attribute)NatTableWidgetFactory.getLastSelectedVariable((NatTable)this.table);
    }

    private List<Attribute> getFilteredAttributeList() {
        ConfigurableObject confObject = this.getType();
        return confObject != null ? confObject.getAttributes().stream().filter(att -> !(att.getType() instanceof InternalDataType) && !InternalAttributeDeclarations.isInternalAttribute((AttributeDeclaration)att.getAttributeDeclaration())).toList() : Collections.emptyList();
    }

    public void addEntry(Object entry, boolean isInput, int index, CompoundCommand cmd) {
        if (entry instanceof Attribute) {
            Attribute attribute = (Attribute)entry;
            cmd.add((Command)CreateAttributeCommand.forTemplate((ConfigurableObject)this.getType(), (Attribute)attribute, (int)index));
        }
    }

    @Override
    protected void performRefresh() {
        this.provider.setInput(this.getFilteredAttributeList());
        this.table.refresh();
    }

    @Override
    protected void performRefreshAnnotations() {
        this.table.refresh(false);
    }

    @Override
    public void executeCommand(Command cmd) {
        super.executeCommand(cmd);
        this.provider.setInput(this.getFilteredAttributeList());
    }

    public void executeCompoundCommand(CompoundCommand cmd) {
        this.executeCommand((Command)cmd);
        this.table.refresh();
    }

    public boolean isEditable() {
        return true;
    }

    protected ConfigurableObject getInputType(Object input) {
        ConfigurableObject configurableObject;
        Object object = AttributeFilter.parseObject(input);
        return object instanceof ConfigurableObject ? (configurableObject = (ConfigurableObject)object) : null;
    }

    @Override
    protected void setInputCode() {
    }

    @Override
    protected void setInputInit() {
        this.provider.setInput(this.getFilteredAttributeList());
        this.table.refresh();
    }

    public void removeEntry(Object entry, CompoundCommand cmd) {
        if (entry instanceof Attribute) {
            Attribute attribute = (Attribute)entry;
            cmd.add((Command)new DeleteAttributeCommand(this.getType(), attribute));
        }
    }

    protected ConfigurableObject getType() {
        ConfigurableObject configurableObject;
        Object object = this.type;
        return object instanceof ConfigurableObject ? (configurableObject = (ConfigurableObject)object) : null;
    }

    protected class AttributeNameCellEditor
    extends TextCellEditor {
        protected AttributeNameCellEditor() {
        }

        protected void configureContentProposalAdapter(ContentProposalAdapter contentProposalAdapter) {
            contentProposalAdapter.addContentProposalListener(this::proposalAccepted);
            super.configureContentProposalAdapter(contentProposalAdapter);
        }

        protected void proposalAccepted(IContentProposal proposal) {
            if (proposal instanceof ImportContentProposal) {
                ImportContentProposal importProposal = (ImportContentProposal)proposal;
                EObject eObject = EcoreUtil.getRootContainer((EObject)AttributeSection.this.getType());
                if (eObject instanceof LibraryElement) {
                    LibraryElement libraryElement = (LibraryElement)eObject;
                    if (!ImportHelper.matchesImports((String)importProposal.getImportedNamespace(), (LibraryElement)libraryElement)) {
                        AttributeSection.this.executeCommand((Command)new AddNewImportCommand(libraryElement, importProposal.getImportedNamespace()));
                    }
                }
            }
        }
    }
}

