/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.widgets;

import java.util.List;
import java.util.function.Consumer;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.helpers.ImportHelper;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableFB;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableMoveFB;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableObject;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.StructManipulator;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.impl.InterfaceElementAnnotations;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.model.ui.editors.DataTypeDropdown;
import org.eclipse.fordiac.ide.model.ui.widgets.ITypeSelectionContentProvider;
import org.eclipse.fordiac.ide.model.ui.widgets.OpenStructMenu;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class TypeSelectionWidget {
    private static final String TYPE = "TYPE";
    private final TabbedPropertySheetWidgetFactory widgetFactory;
    private final Consumer<String> handleSelectionChanged;
    private ConfigurableObject configurableObject;
    private ITypeSelectionContentProvider contentProvider;
    private ITreeContentProvider treeContentProvider;
    private Composite composite;
    private TableViewer tableViewer;
    private Button openEditorButton;
    private boolean typeChangeEnabled;

    public TypeSelectionWidget(TabbedPropertySheetWidgetFactory widgetFactory, Consumer<String> handleSelectionChanged) {
        this.widgetFactory = widgetFactory;
        this.handleSelectionChanged = handleSelectionChanged;
    }

    public TabbedPropertySheetWidgetFactory getWidgetFactory() {
        return this.widgetFactory;
    }

    public ITypeSelectionContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public void createControls(Composite parent) {
        this.composite = this.getWidgetFactory().createComposite(parent);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.composite.setLayout((Layout)gridLayout);
        this.composite.setLayoutData((Object)new GridData(4, 0, true, false));
        this.tableViewer = TypeSelectionWidget.createTableViewer(this.composite);
        this.tableViewer.setColumnProperties(new String[]{TYPE});
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setCellModifier(new ICellModifier(){

            public void modify(Object element, String property, Object value) {
                if (TypeSelectionWidget.TYPE.equals(property) && element != null && !((TableItem)element).getData().equals(value)) {
                    TypeSelectionWidget.this.disableOpenEditorForAnyType();
                    TypeSelectionWidget.this.handleSelectionChanged.accept(value.toString());
                }
            }

            public Object getValue(Object element, String property) {
                if (TypeSelectionWidget.TYPE.equals(property)) {
                    return element;
                }
                return "Could not load";
            }

            public boolean canModify(Object element, String property) {
                return TypeSelectionWidget.this.typeChangeEnabled;
            }
        });
        this.openEditorButton = new Button(this.composite, 8);
        this.openEditorButton.setText(FordiacMessages.OPEN_TYPE_EDITOR_MESSAGE);
        this.openEditorButton.addListener(13, event -> {
            DataType dataType = null;
            if ((dataType = this.getDataTypeForOpenButton(dataType)) != null && dataType.getTypeEntry() != null) {
                OpenStructMenu.openStructEditor((IFile)dataType.getTypeEntry().getFile());
            }
        });
    }

    protected DataType getDataTypeForOpenButton(DataType dataType) {
        ConfigurableObject configurableObject = this.configurableObject;
        if (configurableObject instanceof ConfigurableFB) {
            ConfigurableFB configFb = (ConfigurableFB)configurableObject;
            dataType = configFb.getDataType();
        } else {
            ConfigurableObject configurableObject2 = this.configurableObject;
            if (configurableObject2 instanceof IInterfaceElement) {
                IInterfaceElement iel = (IInterfaceElement)configurableObject2;
                dataType = iel.getType();
            }
        }
        return dataType;
    }

    public void setEditable(boolean enabled) {
        this.typeChangeEnabled = enabled;
    }

    public void initialize(ConfigurableObject type, ITypeSelectionContentProvider contentProvider, ITreeContentProvider treeContentProvider) {
        this.configurableObject = type;
        this.contentProvider = contentProvider;
        this.treeContentProvider = treeContentProvider;
        if (type instanceof StructManipulator) {
            StructManipulator structManipulator = (StructManipulator)type;
            String newName = ImportHelper.deresolveImport((String)PackageNameHelper.getFullTypeName((LibraryElement)structManipulator.getDataType()), (String)PackageNameHelper.getContainerPackageName((EObject)type), (List)ImportHelper.getContainerImports((EObject)type));
            this.tableViewer.setInput((Object)new String[]{newName});
            this.resizeTextField();
        } else if (type instanceof VarDeclaration) {
            VarDeclaration varDecl = (VarDeclaration)type;
            this.tableViewer.setInput((Object)new String[]{InterfaceElementAnnotations.getFullTypeName((VarDeclaration)varDecl)});
        } else if (type instanceof IInterfaceElement) {
            IInterfaceElement interfaceElement = (IInterfaceElement)type;
            this.tableViewer.setInput((Object)new String[]{interfaceElement.getType().getName()});
        } else if (type instanceof ConfigurableMoveFB) {
            ConfigurableMoveFB moveFb = (ConfigurableMoveFB)type;
            if (moveFb.getDataType() == null) {
                this.tableViewer.setInput((Object)new String[]{IecTypes.GenericTypes.ANY.getName()});
            } else {
                this.tableViewer.setInput((Object)new String[]{((ConfigurableMoveFB)this.configurableObject).getDataType().getName()});
            }
            this.resizeTextField();
        }
        this.disableOpenEditorForAnyType();
        this.tableViewer.setCellEditors(this.createCellEditors());
    }

    public void refresh() {
        ConfigurableObject configurableObject = this.configurableObject;
        if (configurableObject instanceof VarDeclaration) {
            VarDeclaration varDecl = (VarDeclaration)configurableObject;
            this.tableViewer.setInput((Object)new String[]{InterfaceElementAnnotations.getFullTypeName((VarDeclaration)varDecl)});
        } else {
            ConfigurableObject configurableObject2 = this.configurableObject;
            if (configurableObject2 instanceof IInterfaceElement) {
                IInterfaceElement iel = (IInterfaceElement)configurableObject2;
                this.tableViewer.setInput((Object)new String[]{iel.getType().getName()});
            }
        }
        this.disableOpenEditorForAnyType();
    }

    private CellEditor[] createCellEditors() {
        return new CellEditor[]{new DataTypeDropdown(this::getTypeLibrary, this.contentProvider, this.treeContentProvider, this.tableViewer)};
    }

    private static TableViewer createTableViewer(Composite parent) {
        TableViewer viewer = new TableViewer(parent, 2064);
        Table table = viewer.getTable();
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        table.setLayout((Layout)tableLayout);
        table.setLayoutData((Object)new GridData(4, 0, true, false));
        table.setLinesVisible(false);
        table.setHeaderVisible(false);
        TypeSelectionWidget.addTableColumn(table);
        return viewer;
    }

    private static void addTableColumn(Table table) {
        new TableColumn(table, 0);
    }

    private void resizeTextField() {
        Table table = this.tableViewer.getTable();
        table.getColumn(0).dispose();
        table.setLayout((Layout)new TableLayout());
        table.setLayoutData((Object)new GridData(4, 0, false, false));
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setWidth(TypeSelectionWidget.getMinWidth(table));
        table.requestLayout();
    }

    private static int getMinWidth(Table table) {
        int width;
        int n = width = table.getItemCount() > 0 ? table.getItem((int)0).getBounds().width + 30 : 150;
        if (width < 150) {
            return 150;
        }
        return width;
    }

    private void disableOpenEditorForAnyType() {
        ConfigurableObject configurableObject = this.configurableObject;
        if (configurableObject instanceof ConfigurableFB) {
            ConfigurableFB configurableFb = (ConfigurableFB)configurableObject;
            this.openEditorButton.setEnabled(TypeSelectionWidget.isNonGenericStructType(configurableFb.getDataType()));
        } else if (this.configurableObject instanceof Event) {
            Composite typeComp = this.tableViewer.getTable().getParent();
            GridLayout gridLayout = new GridLayout(1, false);
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            typeComp.setLayout((Layout)gridLayout);
            typeComp.setLayoutData((Object)new GridData(4, 0, true, false));
            this.openEditorButton.dispose();
        } else {
            ConfigurableObject configurableObject2 = this.configurableObject;
            if (configurableObject2 instanceof VarDeclaration) {
                VarDeclaration varDecl = (VarDeclaration)configurableObject2;
                DataType dtp = varDecl.getType();
                this.openEditorButton.setEnabled(dtp instanceof StructuredType && !IecTypes.GenericTypes.isAnyType((DataType)dtp));
            }
        }
    }

    private static boolean isNonGenericStructType(DataType dataType) {
        return dataType instanceof StructuredType && !"ANY_STRUCT".contentEquals(dataType.getName());
    }

    protected TypeLibrary getTypeLibrary() {
        return TypeLibraryManager.INSTANCE.getTypeLibraryFromContext((EObject)this.configurableObject);
    }

    public Composite getControl() {
        return this.composite;
    }
}

