/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemmanagement.ui.wizard;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.fordiac.ide.systemmanagement.ui.Messages;
import org.eclipse.fordiac.ide.systemmanagement.ui.wizard.New4diacExampleProjectPage;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class ExampleCreationOperation
extends WorkspaceModifyOperation {
    final File exampleZipFile;
    final String projectName;
    final IPath projectPath;

    public ExampleCreationOperation(File exampleZipFile, String projectName, IPath projectPath) {
        this.exampleZipFile = exampleZipFile;
        this.projectName = projectName;
        this.projectPath = projectPath;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IProject project = workspace.getRoot().getProject(this.projectName);
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)MessageFormat.format(Messages.New4diacExampleWizard_CreatingExample, New4diacExampleProjectPage.getExampleName(this.exampleZipFile)), (int)140);
            if (!project.exists()) {
                ExampleCreationOperation.createProject(subMonitor, this.projectPath, project, this.exampleZipFile);
            }
            project.open((IProgressMonitor)subMonitor.newChild(10));
            ExampleCreationOperation.renameProject(project, this.projectName);
        }
        catch (IOException e) {
            throw new CoreException(Status.error((String)"IO issues in example project creation!", (Throwable)e));
        }
    }

    private static void createProject(SubMonitor subMonitor, IPath projectPath, IProject project, File exampleZipFile) throws IOException, InterruptedException, CoreException {
        String projectFolder = projectPath.toOSString() + File.separator + project.getName();
        File projectFolderFile = new File(projectFolder);
        projectFolderFile.mkdirs();
        subMonitor.worked(10);
        ExampleCreationOperation.extractProject(projectFolderFile, exampleZipFile, (IProgressMonitor)subMonitor.newChild(100));
        if (subMonitor.isCanceled()) {
            throw new InterruptedException();
        }
        if (projectPath.equals((Object)project.getWorkspace().getRoot().getLocation())) {
            project.create((IProgressMonitor)subMonitor.newChild(10));
        } else {
            IProjectDescription desc = project.getWorkspace().newProjectDescription(project.getName());
            desc.setLocation((IPath)new Path(projectFolder));
            project.create(desc, (IProgressMonitor)subMonitor.newChild(10));
        }
    }

    private static void extractProject(File projectFolderFile, File exampleZipFile, IProgressMonitor monitor) throws IOException, InterruptedException {
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (ZipFile zipFile = new ZipFile(exampleZipFile);){
                monitor.beginTask(Messages.New4diacExampleWizard_CopyingContentIntoNewProject, zipFile.size());
                ExampleCreationOperation.unzip(zipFile, projectFolderFile, monitor);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            monitor.done();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void unzip(ZipFile zipFile, File projectFolderFile, IProgressMonitor monitor) throws IOException, InterruptedException {
        Enumeration<? extends ZipEntry> e = zipFile.entries();
        do {
            block17: {
                if (!e.hasMoreElements()) {
                    return;
                }
                ZipEntry zipEntry = e.nextElement();
                File file = new File(projectFolderFile, zipEntry.getName());
                if (!zipEntry.isDirectory()) {
                    File parentFile = file.getParentFile();
                    if (parentFile != null && !parentFile.exists()) {
                        parentFile.mkdirs();
                    }
                    Throwable throwable = null;
                    Object var8_9 = null;
                    try {
                        InputStream is = zipFile.getInputStream(zipEntry);
                        try {
                            try (FileOutputStream os = new FileOutputStream(file);){
                                is.transferTo(os);
                            }
                            if (is == null) break block17;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (is == null) throw throwable;
                            is.close();
                            throw throwable;
                        }
                        is.close();
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        }
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                        throw throwable;
                    }
                }
            }
            monitor.worked(1);
        } while (!monitor.isCanceled());
        throw new InterruptedException();
    }

    private static void renameProject(IProject project, String projectName) throws CoreException {
        IProjectDescription description = project.getDescription();
        description.setName(projectName);
        project.move(description, 33, null);
    }
}

