/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.vertiflex;

import java.util.List;
import org.eclipse.elk.alg.common.NodeMicroLayout;
import org.eclipse.elk.alg.vertiflex.EdgeRoutingStrategy;
import org.eclipse.elk.alg.vertiflex.InternalProperties;
import org.eclipse.elk.alg.vertiflex.VertiFlexLayoutPhases;
import org.eclipse.elk.alg.vertiflex.VertiFlexUtil;
import org.eclipse.elk.alg.vertiflex.options.VertiFlexOptions;
import org.eclipse.elk.alg.vertiflex.p1yplacement.NodeYPlacerStrategy;
import org.eclipse.elk.alg.vertiflex.p2relative.RelativeXPlacerStrategy;
import org.eclipse.elk.alg.vertiflex.p3absolute.AbsoluteXPlacerStrategy;
import org.eclipse.elk.alg.vertiflex.p4edgerouting.EdgerouterStrategy;
import org.eclipse.elk.core.AbstractLayoutProvider;
import org.eclipse.elk.core.UnsupportedConfigurationException;
import org.eclipse.elk.core.alg.AlgorithmAssembler;
import org.eclipse.elk.core.alg.ILayoutPhaseFactory;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.math.ElkMargin;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.properties.IProperty;

public final class VertiFlexLayoutProvider
extends AbstractLayoutProvider {
    private final AlgorithmAssembler<VertiFlexLayoutPhases, ElkNode> algorithmAssembler = AlgorithmAssembler.create(VertiFlexLayoutPhases.class);
    private double nodeNodeSpacing;

    public void layout(ElkNode graph, IElkProgressMonitor progressMonitor) {
        List<ILayoutProcessor<ElkNode>> algorithm = this.assembleAlgorithm(graph);
        progressMonitor.begin("Tree layout", (float)algorithm.size());
        this.nodeNodeSpacing = (Double)graph.getProperty(CoreOptions.SPACING_NODE_NODE);
        if (!((Boolean)graph.getProperty(VertiFlexOptions.OMIT_NODE_MICRO_LAYOUT)).booleanValue()) {
            NodeMicroLayout.forGraph((ElkNode)graph).execute();
        }
        ElkNode root = VertiFlexUtil.findRoot(graph);
        graph.setProperty(InternalProperties.ROOT_NODE, (Object)root);
        if (root == null) {
            throw new UnsupportedConfigurationException("The given graph is not a tree!");
        }
        for (ElkNode child : graph.getChildren()) {
            int numberOfParents = child.getIncomingEdges().size();
            if (numberOfParents > 1) {
                throw new UnsupportedConfigurationException("The given graph is not an acyclic tree!");
            }
            child.setLocation(0.0, 0.0);
        }
        this.checkVerticalConstraintValidity(root, 0.0);
        int count = 0;
        for (ElkNode node : graph.getChildren()) {
            node.setProperty(InternalProperties.NODE_MODEL_ORDER, (Object)count);
            ++count;
        }
        for (ILayoutProcessor<ElkNode> processor : algorithm) {
            processor.process((Object)graph, progressMonitor.subTask(1.0f));
        }
        this.setGraphSize(graph);
        progressMonitor.done();
    }

    public List<ILayoutProcessor<ElkNode>> assembleAlgorithm(ElkNode graph) {
        this.algorithmAssembler.reset();
        this.algorithmAssembler.setPhase((Enum)VertiFlexLayoutPhases.P1_NODE_Y_PLACEMENT, (ILayoutPhaseFactory)NodeYPlacerStrategy.SIMPLE_Y_PLACING);
        this.algorithmAssembler.setPhase((Enum)VertiFlexLayoutPhases.P2_NODE_RELATIVE_PLACEMENT, (ILayoutPhaseFactory)RelativeXPlacerStrategy.SIMPLE_X_PLACING);
        this.algorithmAssembler.setPhase((Enum)VertiFlexLayoutPhases.P3_NODE_ABSOLUTE_PLACEMENT, (ILayoutPhaseFactory)AbsoluteXPlacerStrategy.ABSOLUTE_XPLACING);
        this.algorithmAssembler.setPhase((Enum)VertiFlexLayoutPhases.P4_EDGE_ROUTING, (ILayoutPhaseFactory)(switch ((EdgeRoutingStrategy)((Object)graph.getProperty(VertiFlexOptions.LAYOUT_STRATEGY))) {
            case EdgeRoutingStrategy.BEND -> EdgerouterStrategy.BEND_ROUTING;
            default -> EdgerouterStrategy.DIRECT_ROUTING;
        }));
        return this.algorithmAssembler.build((Object)graph);
    }

    private void checkVerticalConstraintValidity(ElkNode root, double currentMinConstraint) {
        ElkNode child;
        double rootHeight = root.hasProperty(VertiFlexOptions.VERTICAL_CONSTRAINT) ? (Double)root.getProperty(VertiFlexOptions.VERTICAL_CONSTRAINT) : currentMinConstraint;
        double newMinConstraint = rootHeight + root.getHeight() + Math.max(((ElkMargin)root.getProperty((IProperty)CoreOptions.MARGINS)).bottom, this.nodeNodeSpacing);
        for (ElkEdge outgoingEdge : root.getOutgoingEdges()) {
            child = (ElkNode)outgoingEdge.getTargets().get(0);
            if (!child.hasProperty(VertiFlexOptions.VERTICAL_CONSTRAINT) || !(newMinConstraint > (Double)child.getProperty(VertiFlexOptions.VERTICAL_CONSTRAINT) + ((ElkMargin)child.getProperty((IProperty)CoreOptions.MARGINS)).top)) continue;
            throw new UnsupportedConfigurationException("Invalid vertical constraints. Node " + child.getIdentifier() + " has a vertical constraint that is too low for its ancestors.");
        }
        for (ElkEdge outgoingEdge : root.getOutgoingEdges()) {
            child = (ElkNode)outgoingEdge.getTargets().get(0);
            this.checkVerticalConstraintValidity(child, newMinConstraint);
        }
    }

    private void setGraphSize(ElkNode graph) {
        ElkPadding padding = (ElkPadding)graph.getProperty(CoreOptions.PADDING);
        double maxX = 0.0;
        double maxY = 0.0;
        for (ElkNode node : graph.getChildren()) {
            ElkMargin margin = (ElkMargin)node.getProperty(CoreOptions.MARGINS);
            if (maxX < node.getX() + node.getWidth() + margin.right) {
                maxX = node.getX() + node.getWidth() + margin.right;
            }
            if (!(maxY < node.getY() + node.getHeight() + margin.bottom)) continue;
            maxY = node.getY() + node.getHeight() + margin.bottom;
        }
        graph.setWidth(maxX + padding.right);
        graph.setHeight(maxY + padding.bottom);
    }
}

