/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.fordiac.ide.model.data.SintType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.eval.value.AnyMagnitudeValue;
import org.eclipse.fordiac.ide.model.eval.value.AnySignedValue;
import org.eclipse.fordiac.ide.model.value.NumericValueConverter;

public final class SIntValue
implements AnySignedValue {
    public static final SIntValue DEFAULT = new SIntValue(0);
    private final byte value;

    private SIntValue(byte value) {
        this.value = value;
    }

    public static SIntValue toSIntValue(byte value) {
        return new SIntValue(value);
    }

    public static SIntValue toSIntValue(Number value) {
        return new SIntValue(value.byteValue());
    }

    public static SIntValue toSIntValue(String value) {
        return SIntValue.toSIntValue((Number)NumericValueConverter.INSTANCE.toValue(value));
    }

    public static SIntValue toSIntValue(AnyMagnitudeValue value) {
        return SIntValue.toSIntValue(value.byteValue());
    }

    public SintType getType() {
        return IecTypes.ElementaryTypes.SINT;
    }

    @Override
    public byte byteValue() {
        return this.value;
    }

    @Override
    public short shortValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public BigInteger bigIntegerValue() {
        return BigInteger.valueOf(this.longValue());
    }

    @Override
    public BigDecimal bigDecimalValue() {
        return BigDecimal.valueOf(this.longValue());
    }

    public int hashCode() {
        return Byte.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SIntValue other = (SIntValue)obj;
        return this.value == other.value;
    }

    public String toString() {
        return Byte.toString(this.value);
    }
}

