/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p3order;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.intermediate.preserveorder.CMGroupModelOrderCalculator;
import org.eclipse.elk.alg.layered.options.GroupOrderStrategy;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayerConstraint;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.p3order.AbstractBarycenterPortDistributor;
import org.eclipse.elk.alg.layered.p3order.BarycenterHeuristic;
import org.eclipse.elk.alg.layered.p3order.ForsterConstraintResolver;

public class ModelOrderBarycenterHeuristic
extends BarycenterHeuristic {
    private HashMap<LNode, HashSet<LNode>> biggerThan = new HashMap();
    private HashMap<LNode, HashSet<LNode>> smallerThan = new HashMap();

    public ModelOrderBarycenterHeuristic(ForsterConstraintResolver constraintResolver, Random random, AbstractBarycenterPortDistributor portDistributor, LNode[][] graph) {
        super(constraintResolver, random, portDistributor, graph);
        this.barycenterStateComparator = (n1, n2) -> {
            if (n1.hasProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT) && (n1.getProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT) == LayerConstraint.FIRST_SEPARATE || n1.getProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT) == LayerConstraint.LAST_SEPARATE) || n2.hasProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT) && (n2.getProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT) == LayerConstraint.FIRST_SEPARATE || n2.getProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT) == LayerConstraint.LAST_SEPARATE)) {
                return 0;
            }
            LGraph lgraph = n1.getGraph();
            int transitiveComparison = this.compareBasedOnTansitiveDependencies((LNode)((Object)n1), (LNode)((Object)n2));
            if (transitiveComparison != 0) {
                return transitiveComparison;
            }
            if (n1.hasProperty(InternalProperties.MODEL_ORDER) && n2.hasProperty(InternalProperties.MODEL_ORDER)) {
                int value = Integer.compare(CMGroupModelOrderCalculator.calculateModelOrderOrGroupModelOrder(n1, n2, lgraph, (Integer)lgraph.getProperty(InternalProperties.MAX_MODEL_ORDER_NODES)), CMGroupModelOrderCalculator.calculateModelOrderOrGroupModelOrder(n2, n1, lgraph, (Integer)lgraph.getProperty(InternalProperties.MAX_MODEL_ORDER_NODES)));
                if (lgraph.getProperty(LayeredOptions.CONSIDER_MODEL_ORDER_GROUP_MODEL_ORDER_CM_GROUP_ORDER_STRATEGY) == GroupOrderStrategy.ONLY_WITHIN_GROUP && n1.getProperty(LayeredOptions.CONSIDER_MODEL_ORDER_GROUP_MODEL_ORDER_CROSSING_MINIMIZATION_ID) != n2.getProperty(LayeredOptions.CONSIDER_MODEL_ORDER_GROUP_MODEL_ORDER_CROSSING_MINIMIZATION_ID)) {
                    value = 0;
                }
                if (value < 0) {
                    this.updateBiggerAndSmallerAssociations((LNode)((Object)n1), (LNode)((Object)n2));
                    return value;
                }
                if (value > 0) {
                    this.updateBiggerAndSmallerAssociations((LNode)((Object)n2), (LNode)((Object)n1));
                    return value;
                }
            }
            return this.compareBasedOnBarycenter((LNode)((Object)n1), (LNode)((Object)n2));
        };
    }

    @Override
    public void minimizeCrossings(List<LNode> layer, boolean preOrdered, boolean randomize, boolean forward) {
        if (randomize) {
            this.randomizeBarycenters(layer);
        } else {
            this.calculateBarycenters(layer, forward);
            this.fillInUnknownBarycenters(layer, preOrdered);
        }
        if (layer.size() > 1) {
            if (((Boolean)layer.get(0).getGraph().getProperty(LayeredOptions.CROSSING_MINIMIZATION_FORCE_NODE_MODEL_ORDER)).booleanValue()) {
                ModelOrderBarycenterHeuristic.insertionSort(layer, this.barycenterStateComparator, this);
            } else {
                Collections.sort(layer, this.barycenterStateComparator);
            }
            if (!((Boolean)layer.get(0).getGraph().getProperty(LayeredOptions.CROSSING_MINIMIZATION_FORCE_NODE_MODEL_ORDER)).booleanValue()) {
                this.constraintResolver.processConstraints(layer);
            }
        }
    }

    private int compareBasedOnTansitiveDependencies(LNode n1, LNode n2) {
        if (!this.biggerThan.containsKey((Object)n1)) {
            this.biggerThan.put(n1, new HashSet());
        } else if (this.biggerThan.get((Object)n1).contains((Object)n2)) {
            return 1;
        }
        if (!this.biggerThan.containsKey((Object)n2)) {
            this.biggerThan.put(n2, new HashSet());
        } else if (this.biggerThan.get((Object)n2).contains((Object)n1)) {
            return -1;
        }
        if (!this.smallerThan.containsKey((Object)n1)) {
            this.smallerThan.put(n1, new HashSet());
        } else if (this.smallerThan.get((Object)n1).contains((Object)n2)) {
            return -1;
        }
        if (!this.smallerThan.containsKey((Object)n2)) {
            this.smallerThan.put(n2, new HashSet());
        } else if (this.smallerThan.get((Object)n2).contains((Object)n1)) {
            return 1;
        }
        return 0;
    }

    private int compareBasedOnBarycenter(LNode n1, LNode n2) {
        BarycenterHeuristic.BarycenterState s1 = this.stateOf(n1);
        BarycenterHeuristic.BarycenterState s2 = this.stateOf(n2);
        if (s1.barycenter != null && s2.barycenter != null) {
            int value = s1.barycenter.compareTo(s2.barycenter);
            if (value < 0) {
                this.updateBiggerAndSmallerAssociations(n1, n2);
            } else if (value > 0) {
                this.updateBiggerAndSmallerAssociations(n2, n1);
            }
            return value;
        }
        if (s1.barycenter != null) {
            this.updateBiggerAndSmallerAssociations(n1, n2);
            return -1;
        }
        if (s2.barycenter != null) {
            this.updateBiggerAndSmallerAssociations(n2, n1);
            return 1;
        }
        return 0;
    }

    private void updateBiggerAndSmallerAssociations(LNode bigger, LNode smaller) {
        HashSet<LNode> biggerNodeBiggerThan = this.biggerThan.get((Object)bigger);
        HashSet<LNode> smallerNodeBiggerThan = this.biggerThan.get((Object)smaller);
        HashSet<LNode> biggerNodeSmallerThan = this.smallerThan.get((Object)bigger);
        HashSet<LNode> smallerNodeSmallerThan = this.smallerThan.get((Object)smaller);
        biggerNodeBiggerThan.add(smaller);
        smallerNodeSmallerThan.add(bigger);
        for (LNode verySmall : smallerNodeBiggerThan) {
            biggerNodeBiggerThan.add(verySmall);
            this.smallerThan.get((Object)verySmall).add(bigger);
            this.smallerThan.get((Object)verySmall).addAll(biggerNodeSmallerThan);
        }
        for (LNode veryBig : biggerNodeSmallerThan) {
            smallerNodeSmallerThan.add(veryBig);
            this.biggerThan.get((Object)veryBig).add(smaller);
            this.biggerThan.get((Object)veryBig).addAll(smallerNodeBiggerThan);
        }
    }

    public static void insertionSort(List<LNode> layer, Comparator<LNode> comparator, ModelOrderBarycenterHeuristic barycenterHeuristic) {
        int i = 1;
        while (i < layer.size()) {
            LNode temp = layer.get(i);
            int j = i;
            while (j > 0 && comparator.compare(layer.get(j - 1), temp) > 0) {
                layer.set(j, layer.get(j - 1));
                --j;
            }
            layer.set(j, temp);
            ++i;
        }
        barycenterHeuristic.clearTransitiveOrdering();
    }

    public void clearTransitiveOrdering() {
        this.biggerThan = new HashMap();
        this.smallerThan = new HashMap();
    }
}

