/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.policies;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.application.commands.ResizeGroupOrSubappCommand;
import org.eclipse.fordiac.ide.application.editparts.AbstractContainerContentEditPart;
import org.eclipse.fordiac.ide.application.editparts.UnfoldedSubappContentEditPart;
import org.eclipse.fordiac.ide.application.policies.FBNetworkXYLayoutEditPolicy;
import org.eclipse.fordiac.ide.gef.policies.ModifiedMoveHandle;
import org.eclipse.fordiac.ide.model.commands.change.AbstractChangeContainerBoundsCommand;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;

public class ContainerContentLayoutPolicy
extends FBNetworkXYLayoutEditPolicy {
    private Figure moveHandle;

    protected void showLayoutTargetFeedback(Request request) {
        if ("add children".equals(request.getType()) && this.moveHandle == null) {
            this.moveHandle = new ModifiedMoveHandle((GraphicalEditPart)this.getTargetEditPart(request).getParent(), new Insets(1), 3);
            this.addFeedback((IFigure)this.moveHandle);
        }
    }

    protected void eraseLayoutTargetFeedback(Request request) {
        if (this.moveHandle != null) {
            this.removeFeedback((IFigure)this.moveHandle);
            this.moveHandle = null;
        }
    }

    @Override
    protected Command createChangeConstraintCommand(ChangeBoundsRequest request, EditPart child, Object constraint) {
        Command cmd = super.createChangeConstraintCommand(request, child, constraint);
        if (cmd != null) {
            return new ResizeGroupOrSubappCommand(this.getHost(), cmd);
        }
        return cmd;
    }

    protected FBNetworkElement getParentModel() {
        FBNetworkElement fBNetworkElement;
        GraphicalEditPart graphicalEditPart = this.getHost();
        if (graphicalEditPart instanceof AbstractContainerContentEditPart) {
            AbstractContainerContentEditPart accep = (AbstractContainerContentEditPart)graphicalEditPart;
            fBNetworkElement = accep.getContainerElement();
        } else {
            fBNetworkElement = null;
        }
        return fBNetworkElement;
    }

    public static Rectangle getContainerAreaBounds(GraphicalEditPart containerContentEP) {
        int dy;
        Rectangle contentBounds = containerContentEP.getFigure().getBounds().getCopy();
        Rectangle containerBounds = ((GraphicalEditPart)containerContentEP.getParent()).getFigure().getBounds();
        int borderSize = contentBounds.x - containerBounds.x;
        if (containerBounds.width < contentBounds.width) {
            contentBounds.width = containerBounds.width - borderSize;
        }
        if (containerBounds.height - (dy = contentBounds.y - containerBounds.y) < contentBounds.height) {
            contentBounds.height = containerBounds.height - dy - borderSize;
        }
        return contentBounds;
    }

    public static AbstractChangeContainerBoundsCommand createChangeBoundsCommand(FBNetworkElement container, Rectangle contentContainerBounds, Rectangle contentBounds) {
        Point moveDelta = new Point(contentBounds.x - contentContainerBounds.x, contentBounds.y - contentContainerBounds.y);
        Dimension sizeDelta = new Dimension(contentBounds.width - contentContainerBounds.width, contentBounds.height - contentContainerBounds.height);
        return FBNetworkXYLayoutEditPolicy.createChangeBoundsCommand(container, sizeDelta, moveDelta);
    }

    protected static void translateToRelative(GraphicalEditPart graphicalEditPart, Point topLeft) {
        GraphicalEditPart parent = graphicalEditPart;
        while (parent != null) {
            if (parent instanceof UnfoldedSubappContentEditPart) {
                Rectangle subappContentBounds = ContainerContentLayoutPolicy.getContainerAreaBounds(parent);
                topLeft.translate(-subappContentBounds.x, -subappContentBounds.y);
                return;
            }
            parent = (GraphicalEditPart)parent.getParent();
        }
    }
}

