/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.value;

import java.time.LocalTime;
import java.time.temporal.ChronoField;
import org.eclipse.fordiac.ide.model.data.TimeOfDayType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.eval.value.AnyDateValue;
import org.eclipse.fordiac.ide.model.value.TypedValueConverter;

public final class TimeOfDayValue
implements AnyDateValue {
    public static final TimeOfDayValue DEFAULT = new TimeOfDayValue(0L);
    private final long value;

    private TimeOfDayValue(long value) {
        ChronoField.NANO_OF_DAY.checkValidValue(value);
        this.value = value;
    }

    public static TimeOfDayValue toTimeOfDayValue(long value) {
        return new TimeOfDayValue(value);
    }

    public static TimeOfDayValue toTimeOfDayValue(Number value) {
        return new TimeOfDayValue(value.longValue());
    }

    public static TimeOfDayValue toTimeOfDayValue(LocalTime value) {
        return TimeOfDayValue.toTimeOfDayValue(value.toNanoOfDay());
    }

    public static TimeOfDayValue toTimeOfDayValue(String value) {
        return TimeOfDayValue.toTimeOfDayValue((LocalTime)TypedValueConverter.INSTANCE_TIME_OF_DAY.toValue(value));
    }

    public static TimeOfDayValue toTimeOfDayValue(AnyDateValue value) {
        return TimeOfDayValue.toTimeOfDayValue(value.toNanos());
    }

    public TimeOfDayType getType() {
        return IecTypes.ElementaryTypes.TIME_OF_DAY;
    }

    @Override
    public long toNanos() {
        return this.value;
    }

    public LocalTime toLocalTime() {
        return LocalTime.ofNanoOfDay(this.value);
    }

    public int hashCode() {
        return Long.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeOfDayValue other = (TimeOfDayValue)obj;
        return this.value == other.value;
    }

    public String toString() {
        return TypedValueConverter.INSTANCE_TIME_OF_DAY.toString((Object)this.toLocalTime());
    }
}

