/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemmanagement.changelistener;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.fordiac.ide.model.NameRepository;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.systemmanagement.Messages;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.fordiac.ide.systemmanagement.changelistener.ExcludedElements;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;

public class FordiacResourceChangeListener
implements IResourceChangeListener {
    private static final boolean ENABLE_COPY_DIALOG = false;
    private static final Pattern TYPE_NAME_PATTERN = Pattern.compile("Name=\\\"(\\w*)\\\"");
    private final Collection<FileToRenameEntry> filesToRename;
    IResourceDeltaVisitor visitor = delta -> {
        switch (delta.getKind()) {
            case 4: {
                return FordiacResourceChangeListener.handleResourceChanged(delta);
            }
            case 2: {
                return this.handleResourceRemoved(delta);
            }
            case 1: {
                if (FordiacResourceChangeListener.testFlags(delta, 4096)) {
                    return FordiacResourceChangeListener.handleResourceMovedFrom(delta);
                }
                return this.handleResourceCopy(delta);
            }
        }
        return true;
    };
    private static final IResourceDeltaVisitor projRenameVisitor = delta -> {
        if (delta.getKind() == 1 && delta.getResource().getType() == 1 && FordiacResourceChangeListener.testFlags(delta, 4096)) {
            IFile src = ResourcesPlugin.getWorkspace().getRoot().getFile(delta.getMovedFromPath());
            IFile dst = (IFile)delta.getResource();
            FordiacResourceChangeListener.handleFileAfterProjectRename(src, dst);
        }
        return true;
    };

    public FordiacResourceChangeListener() {
        this.filesToRename = new HashSet<FileToRenameEntry>();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 1) {
            IResourceDelta rootDelta = event.getDelta();
            try {
                rootDelta.accept(this.visitor);
                if (!this.filesToRename.isEmpty()) {
                    this.handleFilesToRename();
                }
            }
            catch (CoreException e) {
                FordiacLogHelper.logError((String)"Couldn't process resource delta", (Throwable)e);
            }
        }
    }

    private void handleFilesToRename() {
        this.filesToRename.forEach(FordiacResourceChangeListener::autoRenameExistingType);
        this.filesToRename.clear();
    }

    private static boolean handleResourceChanged(IResourceDelta delta) {
        switch (delta.getResource().getType()) {
            case 1: {
                if (!FordiacResourceChangeListener.testFlags(delta, 256)) break;
                FordiacResourceChangeListener.refreshTypeEntry(delta);
                break;
            }
            case 4: {
                if (FordiacResourceChangeListener.testFlags(delta, 524288)) {
                    SystemManager.validateProjectNature(delta.getResource().getProject());
                }
                if (!FordiacResourceChangeListener.testFlags(delta, 16384)) break;
                if (delta.getResource().isAccessible()) {
                    TypeLibraryManager.INSTANCE.getTypeLibrary(delta.getResource().getProject()).refresh();
                    SystemManager.validateProjectNature(delta.getResource().getProject());
                } else {
                    FordiacResourceChangeListener.handleProjectRemove(delta);
                }
                return false;
            }
        }
        return true;
    }

    private static void refreshTypeEntry(IResourceDelta delta) {
        IFile file = (IFile)delta.getResource();
        TypeEntry typeEntryForFile = TypeLibraryManager.INSTANCE.getTypeEntryForFile(file);
        if (typeEntryForFile != null) {
            typeEntryForFile.refresh();
        }
    }

    private boolean handleResourceRemoved(IResourceDelta delta) {
        IProject project = delta.getResource().getProject();
        if (FordiacResourceChangeListener.testFlags(delta, 8192) || !TypeLibraryManager.INSTANCE.hasTypeLibrary(project)) {
            return false;
        }
        switch (delta.getResource().getType()) {
            case 1: {
                this.handleFileDelete(delta);
                break;
            }
            case 4: {
                FordiacResourceChangeListener.handleProjectRemove(delta);
                return false;
            }
        }
        return true;
    }

    private static boolean handleResourceMovedFrom(IResourceDelta delta) {
        if (delta.getResource().getType() == 4) {
            FordiacResourceChangeListener.handleProjectRename(delta);
        }
        return false;
    }

    private boolean handleResourceCopy(IResourceDelta delta) {
        IProject project = delta.getResource().getProject();
        if (delta.getResource().getType() == 4) {
            SystemManager.validateProjectNature(project);
        }
        if (!TypeLibraryManager.INSTANCE.hasTypeLibrary(project)) {
            return false;
        }
        if (delta.getResource().getType() == 1) {
            this.handleFileCopy(delta);
        }
        return true;
    }

    private void handleFileDelete(IResourceDelta delta) {
        IFile file = (IFile)delta.getResource();
        if (!TypeLibraryManager.INSTANCE.hasTypeLibrary(file.getProject())) {
            return;
        }
        TypeLibrary typeLib = TypeLibraryManager.INSTANCE.getTypeLibrary(file.getProject());
        TypeEntry entry = typeLib.getTypeEntry(file);
        if (entry != null) {
            FordiacResourceChangeListener.closeAllEditorsForFile(file);
            FileToRenameEntry rnEntry = this.getFileRenameEntry(entry);
            typeLib.removeTypeEntry(entry);
            if (rnEntry != null) {
                entry.setFile(rnEntry.getFile());
                typeLib.addTypeEntry(entry);
                this.filesToRename.remove(rnEntry);
            }
        }
    }

    private FileToRenameEntry getFileRenameEntry(TypeEntry palEntry) {
        return this.filesToRename.stream().filter(entry -> entry.getTypeEntry().equals(palEntry)).findAny().orElse(null);
    }

    private void handleFileCopy(IResourceDelta delta) {
        IFile file = (IFile)delta.getResource();
        if (!TypeLibraryManager.INSTANCE.hasTypeLibrary(file.getProject())) {
            return;
        }
        if (file.getProject().isOpen() && delta.getFlags() != 131072) {
            TypeLibrary typeLib = TypeLibraryManager.INSTANCE.getTypeLibrary(file.getProject());
            TypeEntry typeEntryForFile = TypeLibraryManager.INSTANCE.getTypeEntryForFile(file);
            if (typeEntryForFile == null) {
                TypeEntry entry = typeLib.createTypeEntry(file);
                if (entry != null && FordiacResourceChangeListener.containedTypeNameIsDifferent(file)) {
                    FordiacResourceChangeListener.updateTypeEntry(file, entry);
                    return;
                }
            } else if (!file.equals((Object)typeEntryForFile.getFile())) {
                this.filesToRename.add(new FileToRenameEntry(file, typeEntryForFile));
            }
        }
    }

    private static void openRenameDialog(IFile file, TypeEntry entry) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        InputDialog renameDialog = new InputDialog(shell, Messages.FordiacResourceChangeListener_CopyConflictTitle, Messages.FordiacResourceChangeListener_CopyConflictBody + file.getName() + "'", file.getName(), null);
        if (renameDialog.open() == 0 && !renameDialog.getValue().equals(file.getName())) {
            String newFileName = renameDialog.getValue();
            IFile newFile = file.getParent().getFile((IPath)new Path(newFileName));
            try {
                file.move(newFile.getFullPath(), true, (IProgressMonitor)new NullProgressMonitor());
                FordiacResourceChangeListener.updateTypeEntryByRename(newFile, entry);
            }
            catch (CoreException e) {
                FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
            }
        } else {
            try {
                file.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean fileExists(IFile file, IResourceDelta delta) {
        IPath filePath = file.getProjectRelativePath();
        if (!filePath.toString().endsWith(".fbt") && !filePath.toString().endsWith(".sys") && !filePath.toString().endsWith(".sub") && !filePath.toString().endsWith(".atp") && !filePath.toString().endsWith(".dtp") || ExcludedElements.contains(filePath.toOSString())) {
            return false;
        }
        return delta.getResource().getName().equals(file.getName());
    }

    private static void autoRenameExistingType(final FileToRenameEntry entry) {
        WorkspaceJob job = new WorkspaceJob(Messages.FordiacResourceChangeListener_4 + entry.getFile().getName()){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                LibraryElement type = entry.getTypeEntry().getType();
                String oldName = type.getName();
                String newName = NameRepository.createUniqueTypeName((LibraryElement)type);
                if (newName == null || newName.equals(oldName)) {
                    return Status.CANCEL_STATUS;
                }
                String oldPath = entry.getFile().getFullPath().toOSString();
                String newPath = FordiacResourceChangeListener.replaceLast(oldPath, oldName, newName);
                try {
                    entry.getFile().move((IPath)new Path(newPath), true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.setSystem(true);
        job.setPriority(20);
        job.setRule((ISchedulingRule)entry.getFile().getProject());
        job.schedule();
    }

    public static String replaceLast(String text, String regex, String replacement) {
        return text.replaceFirst("(?s)(.*)" + regex, "$1" + replacement);
    }

    private static void handleProjectRename(IResourceDelta delta) {
        IProject oldProject = ResourcesPlugin.getWorkspace().getRoot().getProject(delta.getMovedFromPath().lastSegment());
        IProject newProject = delta.getResource().getProject();
        TypeLibraryManager.INSTANCE.renameProject(oldProject, newProject);
        try {
            delta.accept(projRenameVisitor);
        }
        catch (CoreException e) {
            FordiacLogHelper.logError((String)"Couldn't handle project rename", (Throwable)e);
        }
    }

    private static void handleFileAfterProjectRename(IFile src, IFile dst) {
        TypeLibrary typeLib = TypeLibraryManager.INSTANCE.getTypeLibrary(dst.getProject());
        TypeEntry entry = typeLib.getTypeEntry(src);
        if (entry == null) {
            typeLib.createTypeEntry(dst);
        } else {
            typeLib.removeTypeEntry(entry);
            entry.setFile(dst);
            typeLib.addTypeEntry(entry);
        }
    }

    public static void updateTypeEntry(IFile newFile, TypeEntry entry) {
        LibraryElement type;
        if (entry == null) {
            return;
        }
        String newTypeName = TypeEntry.getTypeNameFromFile((IFile)newFile);
        if (!Objects.equals(newFile, entry.getFile())) {
            TypeLibrary typeLibrary = entry.getTypeLibrary();
            if (typeLibrary != null) {
                typeLibrary.removeTypeEntry(entry);
            }
            entry.setFile(newFile);
            if (typeLibrary != null) {
                typeLibrary.addTypeEntry(entry);
            }
        }
        if ((type = entry.getTypeEditable()) != null && !newTypeName.equals(type.getName())) {
            type.setName(newTypeName);
            FordiacResourceChangeListener.saveEntryWithWorkspaceJob(type, entry);
        }
    }

    public static void updateTypeEntryByRename(IFile newFile, TypeEntry entry) {
        if (entry == null) {
            return;
        }
        String newTypeName = TypeEntry.getTypeNameFromFile((IFile)newFile);
        if (!Objects.equals(newFile, entry.getFile())) {
            TypeLibrary typeLibrary = entry.getTypeLibrary();
            if (typeLibrary != null) {
                typeLibrary.removeTypeEntry(entry);
            }
            entry.setFile(newFile);
            LibraryElement type = entry.getTypeEditable();
            if (type != null) {
                type.setName(newTypeName);
            }
            if ((type = entry.getType()) != null) {
                type.setName(newTypeName);
            }
            if (typeLibrary != null) {
                typeLibrary.addTypeEntry(entry);
            }
            FordiacResourceChangeListener.saveEntryWithWorkspaceJob(type, entry);
        }
    }

    private static void saveEntryWithWorkspaceJob(final LibraryElement type, final TypeEntry entry) {
        WorkspaceJob job = new WorkspaceJob("Save type file: " + entry.getFile().getName()){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                try {
                    entry.save(type, monitor);
                }
                catch (CoreException e) {
                    FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.setSystem(true);
        job.setPriority(20);
        IContainer parent = entry.getFile().getParent();
        while (parent != null && !parent.exists()) {
            parent = parent.getParent();
        }
        IContainer rule = parent != null ? parent : ResourcesPlugin.getWorkspace().getRoot();
        job.setRule((ISchedulingRule)rule);
        job.schedule();
    }

    private static void handleProjectRemove(IResourceDelta delta) {
        IProject project = delta.getResource().getProject();
        FordiacResourceChangeListener.closeAllProjectRelatedEditors(project);
        TypeLibraryManager.INSTANCE.removeProject(project);
    }

    private static void closeAllProjectRelatedEditors(IProject project) {
        Display.getDefault().asyncExec(() -> EditorUtils.closeEditorsFiltered(editor -> {
            IFileEditorInput fileEditorInput;
            IEditorInput iEditorInput = editor.getEditorInput();
            return iEditorInput instanceof IFileEditorInput && project.equals((Object)(fileEditorInput = (IFileEditorInput)iEditorInput).getFile().getProject());
        }));
    }

    private static void closeAllEditorsForFile(IFile file) {
        Display.getDefault().asyncExec(() -> EditorUtils.closeEditorsFiltered(editor -> {
            IFileEditorInput fileEditorInput;
            IEditorInput iEditorInput = editor.getEditorInput();
            return iEditorInput instanceof IFileEditorInput && file.equals((Object)(fileEditorInput = (IFileEditorInput)iEditorInput).getFile());
        }));
    }

    private static boolean containedTypeNameIsDifferent(IFile file) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (Scanner scanner = new Scanner(file.getContents());){
                if (scanner.findWithinHorizon(TYPE_NAME_PATTERN, 0) != null) {
                    String name = scanner.match().group(1);
                    String typeName = TypeEntry.getTypeNameFromFile((IFile)file);
                    boolean bl = !typeName.equals(name);
                    return bl;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
        }
        return true;
    }

    private static boolean testFlags(IResourceDelta delta, int flags) {
        return (delta.getFlags() & flags) == flags;
    }

    private static class FileToRenameEntry {
        private final IFile filetoRename;
        private final TypeEntry existingTypeEntry;

        public FileToRenameEntry(IFile filetoRename, TypeEntry existingTypeEntry) {
            this.filetoRename = filetoRename;
            this.existingTypeEntry = existingTypeEntry;
        }

        public TypeEntry getTypeEntry() {
            return this.existingTypeEntry;
        }

        public IFile getFile() {
            return this.filetoRename;
        }
    }
}

