/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.amf.testing.ares.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.amp.amf.testing.ares.AresPackage;
import org.eclipse.amp.amf.testing.ares.ResultType;
import org.eclipse.amp.amf.testing.ares.Run;
import org.eclipse.amp.amf.testing.ares.RunSet;
import org.eclipse.amp.amf.testing.ares.provider.AresEditPlugin;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;

public class RunSetItemProvider
extends ItemProviderAdapter
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    public RunSetItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addResultPropertyDescriptor(object);
            this.addStartedPropertyDescriptor(object);
            this.addFinishedPropertyDescriptor(object);
            this.addRunsPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addResultPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_RunSet_result_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_RunSet_result_feature", "_UI_RunSet_type"), (EStructuralFeature)AresPackage.Literals.RUN_SET__RESULT, false, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addStartedPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_RunSet_started_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_RunSet_started_feature", "_UI_RunSet_type"), (EStructuralFeature)AresPackage.Literals.RUN_SET__STARTED, false, false, true, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addFinishedPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_RunSet_finished_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_RunSet_finished_feature", "_UI_RunSet_type"), (EStructuralFeature)AresPackage.Literals.RUN_SET__FINISHED, false, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addRunsPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_RunSet_runs_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_RunSet_runs_feature", "_UI_RunSet_type"), (EStructuralFeature)AresPackage.Literals.RUN_SET__RUNS, true, false, false, null, null, null));
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(AresPackage.Literals.RUN_SET__RUNS);
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public Object getImage(Object object) {
        RunSet runSet = (RunSet)object;
        for (Run run : runSet.getRuns()) {
            if (run.getResult() != ResultType.FAILURE) continue;
            return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/Failure"));
        }
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/Success"));
    }

    public String getText(Object object) {
        RunSet runSet = (RunSet)object;
        int successCount = 0;
        for (Run run : runSet.getRuns()) {
            if (run.getResult() != ResultType.SUCCESS) continue;
            ++successCount;
        }
        String label = String.valueOf(successCount) + " of " + runSet.getRuns().size();
        return label == null || label.length() == 0 ? this.getString("_UI_RunSet_type") : label;
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(RunSet.class)) {
            case 3: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    public ResourceLocator getResourceLocator() {
        return AresEditPlugin.INSTANCE;
    }
}

