/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.escape.ide;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.amp.escape.ide.LoaderCreationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class ProjectLoader
extends URLClassLoader {
    private IProject project;
    private ClassLoader mainLoader;
    private List<Bundle> bundles;

    public ProjectLoader(IProject project) throws LoaderCreationException {
        super(new URL[0]);
        this.project = project;
        try {
            project.open(null);
            IJavaProject javaProject = JavaCore.create((IProject)project);
            this.addURL(new File(project.getLocation() + "/" + javaProject.getOutputLocation().removeFirstSegments(1) + "/").toURI().toURL());
            this.bundles = ProjectLoader.readDependencies(this.openStream("META-INF/MANIFEST.MF"));
            this.mainLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this);
        }
        catch (Exception e) {
            throw new LoaderCreationException("Problem creating classloaders.", e);
        }
    }

    public static List<Bundle> readDependencies(InputStream manifestFileStream) throws BundleException, IOException, IllegalStateException {
        ManifestElement[] bundleElements;
        ArrayList<Bundle> dependencies = new ArrayList<Bundle>();
        Map manifest = ManifestElement.parseBundleManifest((InputStream)manifestFileStream, null);
        ManifestElement[] manifestElementArray = bundleElements = ManifestElement.parseHeader((String)"Require-Bundle", (String)((String)manifest.get("Require-Bundle")));
        int n = bundleElements.length;
        int n2 = 0;
        while (n2 < n) {
            String version;
            ManifestElement bundleElement = manifestElementArray[n2];
            String symbolicName = bundleElement.getValue();
            Bundle[] availableBundles = Platform.getBundles((String)symbolicName, (String)(version = bundleElement.getAttribute("bundle-version")));
            if (availableBundles != null && availableBundles.length > 0) {
                dependencies.add(availableBundles[0]);
            } else if (!ProjectLoader.isOptional(bundleElement)) {
                String missingBundle = "Bundle cannot be found: " + symbolicName;
                if (version != null) {
                    missingBundle = String.valueOf(missingBundle) + " " + version;
                }
                throw new IllegalStateException(missingBundle);
            }
            ++n2;
        }
        return dependencies;
    }

    private static boolean isOptional(ManifestElement bundleElement) {
        String optional = bundleElement.getDirective("resolution");
        return optional != null && optional.equals("optional");
    }

    private InputStream openStream(String path) {
        try {
            IFile file = this.project.getFile(path);
            if (file == null) {
                throw new RuntimeException("No resource " + path + " found in " + this.project + ".");
            }
            return file.getContents();
        }
        catch (CoreException e) {
            throw new RuntimeException("Couldn open file " + path + " in " + this.project + ".", e);
        }
    }

    public void restore() {
        Thread.currentThread().setContextClassLoader(this.mainLoader);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        try {
            Class<?> loadClass = super.loadClass(name);
            return loadClass;
        }
        catch (NoClassDefFoundError classNotFoundException) {
            Class<?> loadClassI = this.loadClassInternal(name);
            return loadClassI;
        }
        catch (NoSuchMethodError classNotFoundException) {
            Class<?> loadClassI = this.loadClassInternal(name);
            return loadClassI;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Class<?> loadClassI = this.loadClassInternal(name);
            return loadClassI;
        }
        catch (UnsupportedClassVersionError classNotFoundException) {
            throw new RuntimeException("Bad class: " + name, classNotFoundException);
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected Exception for " + name, e);
        }
    }

    private Class<?> loadClassInternal(String name) throws ClassNotFoundException {
        ClassNotFoundException lastException = null;
        for (Bundle tmp : this.bundles) {
            try {
                return tmp.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                lastException = e;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        return null;
    }
}

