/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.graphics3d.lwjgl;

import java.nio.FloatBuffer;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw3d.geometry.IMatrix3f;
import org.eclipse.draw3d.geometry.IMatrix4f;
import org.eclipse.draw3d.geometry.IPosition3D;
import org.eclipse.draw3d.geometry.IVector2f;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Math3D;
import org.eclipse.draw3d.geometry.Matrix4f;
import org.eclipse.draw3d.geometry.Vector2fImpl;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.geometry.Vector3fImpl;
import org.eclipse.draw3d.graphics.optimizer.primitive.TextPrimitive;
import org.eclipse.draw3d.graphics.optimizer.primitive.TextRenderRule;
import org.eclipse.draw3d.graphics3d.Graphics3D;
import org.eclipse.draw3d.graphics3d.ILodHelper;
import org.eclipse.draw3d.graphics3d.RenderImage;
import org.eclipse.draw3d.graphics3d.lwjgl.font.LwjglFont;
import org.eclipse.draw3d.graphics3d.lwjgl.font.LwjglVectorFont;
import org.eclipse.draw3d.util.ColorConverter;
import org.eclipse.draw3d.util.Draw3DCache;
import org.eclipse.swt.graphics.Color;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class TextRenderImage
implements RenderImage {
    private static final float LOD_VF = 1200.0f;
    private static final float LOD_TF = 10000.0f;
    private float[] m_color = new float[4];
    private String m_text;
    private IVector2f m_size;
    private LwjglVectorFont m_vectorFont;
    private LwjglFont m_textureFont;
    private FloatBuffer m_transformationBuffer;
    private Vector3f m_absPos = new Vector3fImpl();
    private Vector3f m_normal = new Vector3fImpl(IVector3f.Z_AXIS_NEG);

    public TextRenderImage(TextPrimitive i_primitive, LwjglVectorFont i_vectorFont, LwjglFont i_textureFont, IPosition3D i_position) {
        boolean hasPos;
        this.m_text = i_primitive.getText();
        this.m_vectorFont = i_vectorFont;
        this.m_textureFont = i_textureFont;
        TextRenderRule textRule = i_primitive.getRenderRule().asText();
        ColorConverter.toFloatArray((Color)textRule.getTextColor(), (int)textRule.getAlpha(), (float[])this.m_color);
        Dimension extent = i_primitive.getExtent();
        this.m_size = new Vector2fImpl((float)extent.width, (float)extent.height);
        IMatrix3f t3f = i_primitive.getTransformation();
        Point p = i_primitive.getPosition();
        boolean hasTrans = t3f != null && !IMatrix3f.IDENTITY.equals(t3f);
        boolean bl = hasPos = p.x != 0 || p.y != 0;
        if (hasTrans || hasPos) {
            Matrix4f t4f = Draw3DCache.getMatrix4f();
            try {
                if (hasTrans) {
                    Math3D.convert((IMatrix3f)t3f, (Matrix4f)t4f);
                }
                if (hasPos) {
                    Vector3f v = Draw3DCache.getVector3f();
                    try {
                        if (!hasTrans) {
                            t4f.setIdentity();
                        }
                        v.set((float)p.x, (float)p.y, 0.0f);
                        Math3D.translate((IMatrix4f)t4f, (IVector3f)v, (Matrix4f)t4f);
                    }
                    catch (Throwable throwable) {
                        Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{v});
                        throw throwable;
                    }
                    Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{v});
                }
                this.m_transformationBuffer = BufferUtils.createFloatBuffer((int)16);
                t4f.toBufferRowMajor(this.m_transformationBuffer);
                this.m_transformationBuffer.rewind();
                Math3D.mul((IMatrix4f)t4f, (IMatrix4f)i_position.getTransformationMatrix(), (Matrix4f)t4f);
                Math3D.transform((IVector3f)this.m_absPos, (IMatrix4f)t4f, (Vector3f)this.m_absPos);
            }
            catch (Throwable throwable) {
                Draw3DCache.returnMatrix4f((Matrix4f[])new Matrix4f[]{t4f});
                throw throwable;
            }
            Draw3DCache.returnMatrix4f((Matrix4f[])new Matrix4f[]{t4f});
        } else {
            Math3D.transform((IVector3f)this.m_absPos, (IMatrix4f)i_position.getTransformationMatrix(), (Vector3f)this.m_absPos);
        }
        Math3D.transform((IVector3f)this.m_normal, (IMatrix4f)i_position.getAbsoluteRotationMatrix(), (Vector3f)this.m_normal);
    }

    public void dispose() {
    }

    public void initialize(Graphics3D i_g3d) {
    }

    public void render(Graphics3D i_g3d, ILodHelper i_lodHelper) {
        float nd = i_lodHelper.getNormalizedDistance((IVector3f)this.m_absPos, this.m_size, (IVector3f)this.m_normal);
        if (nd <= 10000.0f) {
            GL11.glColor4f((float)this.m_color[0], (float)this.m_color[1], (float)this.m_color[2], (float)this.m_color[3]);
            if (this.m_transformationBuffer != null) {
                GL11.glMatrixMode((int)5888);
                GL11.glPushMatrix();
                try {
                    GL11.glMultMatrix((FloatBuffer)this.m_transformationBuffer);
                    this.renderLOD(nd);
                }
                finally {
                    GL11.glPopMatrix();
                }
            } else {
                this.renderLOD(nd);
            }
        }
    }

    private void renderLOD(float nd) {
        if (nd <= 1200.0f) {
            this.m_vectorFont.render(this.m_text);
        } else {
            this.m_textureFont.renderString(this.m_text, 0, 0, false);
        }
    }
}

