/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.chart.aggregate.IAggregateFunction;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.DataType;
import org.eclipse.birt.chart.model.attribute.GroupingUnitType;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.SeriesGrouping;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.type.StockChart;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.chart.util.LiteralHelper;
import org.eclipse.birt.chart.util.NameSet;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.core.ui.frameworks.taskwizard.WizardBase;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SeriesGroupingComposite
extends Composite
implements SelectionListener {
    private transient Group grpContent = null;
    protected transient Button btnEnabled = null;
    private transient Label lblType = null;
    private transient Combo cmbType = null;
    private transient Label lblUnit = null;
    private transient Combo cmbUnit = null;
    private transient Label lblInterval = null;
    private transient Text iscInterval = null;
    private transient Label lblAggregate = null;
    private transient Combo cmbAggregate = null;
    private final boolean fbAggEnabled;
    private Composite fCmpAggregate;
    private List<Text> fAggParamtersTextWidgets = new ArrayList<Text>();
    private Map<Button, Text> fExprBuilderWidgetsMap = new HashMap<Button, Text>();
    private Composite fAggParameterComposite;
    private ChartWizardContext fChartContext;
    private String fTitle = null;
    protected SeriesGrouping fGrouping;

    public SeriesGroupingComposite(Composite parent, int style, SeriesGrouping grouping, ChartWizardContext context) {
        this(parent, style, grouping, true, context, null);
    }

    public SeriesGroupingComposite(Composite parent, int style, SeriesGrouping grouping, boolean bAggEnabled, ChartWizardContext context, String title) {
        super(parent, style);
        this.fGrouping = grouping;
        this.fbAggEnabled = bAggEnabled;
        this.fChartContext = context;
        this.init();
        this.placeComponents();
        this.initDataNWidgetsStatus();
        this.fTitle = title == null || title.length() == 0 ? Messages.getString("AggregateEditorComposite.AggregateParameterDefinition.Title") : title;
    }

    private void init() {
        this.setSize(this.getParent().getClientArea().width, this.getParent().getClientArea().height);
    }

    private void placeComponents() {
        GridLayout glContent = new GridLayout();
        glContent.numColumns = 4;
        glContent.horizontalSpacing = 5;
        glContent.verticalSpacing = 5;
        glContent.marginWidth = 7;
        glContent.marginHeight = 7;
        this.setLayout((Layout)new FillLayout());
        this.grpContent = new Group((Composite)this, 0);
        this.grpContent.setLayout((Layout)glContent);
        this.grpContent.setText(Messages.getString("SeriesGroupingComposite.Lbl.Grouping"));
        this.btnEnabled = new Button((Composite)this.grpContent, 32);
        GridData gdBTNEnabled = new GridData(32);
        gdBTNEnabled.horizontalSpan = 4;
        this.btnEnabled.setLayoutData((Object)gdBTNEnabled);
        this.btnEnabled.setText(Messages.getString("SeriesGroupingComposite.Lbl.Enabled"));
        this.btnEnabled.addSelectionListener((SelectionListener)this);
        this.lblType = new Label((Composite)this.grpContent, 0);
        GridData gdLBLType = new GridData();
        this.lblType.setLayoutData((Object)gdLBLType);
        this.lblType.setText(Messages.getString("SeriesGroupingComposite.Lbl.Type"));
        this.cmbType = new Combo((Composite)this.grpContent, 12);
        GridData gdCMBType = new GridData(768);
        this.cmbType.setLayoutData((Object)gdCMBType);
        this.cmbType.addSelectionListener((SelectionListener)this);
        this.lblUnit = new Label((Composite)this.grpContent, 0);
        GridData gdLBLUnit = new GridData();
        this.lblUnit.setLayoutData((Object)gdLBLUnit);
        this.lblUnit.setText(Messages.getString("SeriesGroupingComposite.Lbl.Unit"));
        this.cmbUnit = new Combo((Composite)this.grpContent, 12);
        GridData gdCMBUnit = new GridData(768);
        this.cmbUnit.setLayoutData((Object)gdCMBUnit);
        this.cmbUnit.addSelectionListener((SelectionListener)this);
        this.lblInterval = new Label((Composite)this.grpContent, 0);
        GridData gdLBLInterval = new GridData();
        this.lblInterval.setLayoutData((Object)gdLBLInterval);
        this.lblInterval.setText(Messages.getString("SeriesGroupingComposite.Lbl.Interval"));
        this.iscInterval = new Text((Composite)this.grpContent, 2048);
        GridData gdISCInterval = new GridData(768);
        this.iscInterval.setLayoutData((Object)gdISCInterval);
        this.iscInterval.setToolTipText(Messages.getString("SeriesGroupingComposite.Tooltip.SelectIntervalForGrouping"));
        this.iscInterval.addSelectionListener((SelectionListener)this);
        this.iscInterval.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                String text = SeriesGroupingComposite.this.iscInterval.getText();
                if (text == null || text.trim().length() == 0) {
                    text = "0";
                }
                SeriesGroupingComposite.this.fGrouping.setGroupingInterval(Double.valueOf(text).doubleValue());
            }
        });
        this.iscInterval.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                String text = ((Text)e.getSource()).getText();
                if (e.text != null && e.text.length() > 0) {
                    StringBuffer sb = new StringBuffer();
                    sb.append(text.substring(0, e.start));
                    sb.append(e.text);
                    sb.append(text.substring(e.start));
                    text = sb.toString();
                }
                if (text != null && text.length() > 0 && !text.matches("[0-9]*[.]?[0-9]*")) {
                    e.doit = false;
                }
            }
        });
        Label lblDummy = new Label((Composite)this.grpContent, 0);
        GridData gdLBLDummy = new GridData(768);
        gdLBLDummy.horizontalSpan = 2;
        lblDummy.setLayoutData((Object)gdLBLDummy);
        GridLayout glAggregate = new GridLayout();
        glAggregate.numColumns = 2;
        glAggregate.marginHeight = 0;
        glAggregate.marginWidth = 0;
        glAggregate.horizontalSpacing = 5;
        glAggregate.verticalSpacing = 5;
        if (this.fbAggEnabled) {
            this.fCmpAggregate = new Composite((Composite)this.grpContent, 0);
            GridData gdCMPAggregate = new GridData(768);
            gdCMPAggregate.horizontalSpan = 2;
            this.fCmpAggregate.setLayoutData((Object)gdCMPAggregate);
            this.fCmpAggregate.setLayout((Layout)glAggregate);
            this.lblAggregate = new Label(this.fCmpAggregate, 0);
            GridData gdLBLAggregate = new GridData();
            this.lblAggregate.setLayoutData((Object)gdLBLAggregate);
            this.lblAggregate.setText(Messages.getString("SeriesGroupingComposite.Lbl.AggregateExpression"));
            this.cmbAggregate = new Combo(this.fCmpAggregate, 12);
            this.cmbAggregate.setLayoutData((Object)new GridData(768));
            this.cmbAggregate.addSelectionListener((SelectionListener)this);
            this.cmbAggregate.setVisibleItemCount(30);
            Series series = this.fChartContext.getChartType().getSeries();
            if (ChartUIUtil.getSeriesUIProvider((Series)series).validationIndex(series).length > 1) {
                this.lblAggregate.setVisible(false);
                this.cmbAggregate.setVisible(false);
            }
        }
        if (this.fbAggEnabled) {
            this.fAggParameterComposite = new Composite(this.fCmpAggregate, 0);
            GridData gridData = new GridData(768);
            gridData.horizontalIndent = 0;
            gridData.horizontalSpan = 2;
            gridData.exclude = true;
            this.fAggParameterComposite.setLayoutData((Object)gridData);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 3;
            this.fAggParameterComposite.setLayout((Layout)layout);
        }
    }

    private void initDataNWidgetsStatus() {
        this.setButtonsStatus();
        double iGroupInterval = 1.0;
        if (this.fGrouping != null) {
            iGroupInterval = this.fGrouping.getGroupingInterval();
        }
        if (iGroupInterval - (double)((long)iGroupInterval) == 0.0) {
            this.iscInterval.setText(String.valueOf((long)iGroupInterval));
        } else {
            this.iscInterval.setText(String.valueOf(iGroupInterval));
        }
        this.populateLists();
        if (this.fbAggEnabled) {
            String aggFuncName = ((String[])this.cmbAggregate.getData())[this.cmbAggregate.getSelectionIndex()];
            this.showAggregateParameters(aggFuncName);
        }
    }

    protected void setButtonsStatus() {
        this.setGroupingButtonSelection();
        boolean bEnableUI = this.btnEnabled.getSelection();
        this.setIntervalButtonsStatus(bEnableUI);
    }

    protected void setIntervalButtonsStatus(boolean bEnableUI) {
        this.lblType.setEnabled(bEnableUI);
        this.cmbType.setEnabled(bEnableUI);
        this.lblInterval.setEnabled(bEnableUI);
        this.iscInterval.setEnabled(bEnableUI);
        if (this.fbAggEnabled) {
            this.lblAggregate.setEnabled(bEnableUI);
            this.cmbAggregate.setEnabled(bEnableUI);
        }
    }

    protected void setGroupingButtonSelection() {
        this.btnEnabled.setSelection(this.fGrouping.isEnabled());
    }

    protected void setGroupingButtionEnabled(boolean enabled) {
        this.btnEnabled.setEnabled(enabled);
    }

    private void populateLists() {
        this.cmbUnit.removeAll();
        boolean isGroupingEnableUI = this.btnEnabled.getSelection();
        NameSet ns = LiteralHelper.dataTypeSet;
        this.cmbType.setItems(ns.getDisplayNames());
        if (isGroupingEnableUI && this.fGrouping != null) {
            this.cmbType.setText(ns.getDisplayNameByName(this.fGrouping.getGroupType().getName()));
        } else {
            this.cmbType.select(0);
        }
        this.resetGroupingUnitsCombo(isGroupingEnableUI);
        if (this.fbAggEnabled) {
            try {
                this.cmbAggregate.setItems(PluginSettings.instance().getRegisteredAggregateFunctionDisplayNames());
                this.cmbAggregate.setData((Object)PluginSettings.instance().getRegisteredAggregateFunctions());
            }
            catch (ChartException e) {
                WizardBase.displayException((Throwable)e);
            }
            if (isGroupingEnableUI && this.fGrouping.getAggregateExpression() != null) {
                int idx = this.getAggregateIndexByName(this.fGrouping.getAggregateExpression());
                if (this.cmbAggregate.getItemCount() > idx) {
                    this.cmbAggregate.select(idx);
                }
            } else if (this.cmbAggregate.getItemCount() > 0) {
                this.cmbAggregate.select(0);
            }
            this.lblAggregate.setEnabled(isGroupingEnableUI);
            this.cmbAggregate.setEnabled(isGroupingEnableUI);
        }
    }

    private void populateAggParameters() {
        EList aggPars;
        if (this.fbAggEnabled && (aggPars = this.fGrouping.getAggregateParameters()).size() > 0) {
            int size = aggPars.size() > this.fAggParamtersTextWidgets.size() ? this.fAggParamtersTextWidgets.size() : aggPars.size();
            int i = 0;
            while (i < size) {
                String value = (String)aggPars.get(i);
                if (value != null) {
                    this.fAggParamtersTextWidgets.get(i).setText(value);
                }
                ++i;
            }
        }
    }

    private void resetGroupingUnitsCombo(boolean isGroupingEnableUI) {
        NameSet ns = LiteralHelper.getGroupingUnitTypeSet((DataType)this.fGrouping.getGroupType());
        if (ns != null) {
            this.cmbUnit.setItems(ns.getDisplayNames());
            if (isGroupingEnableUI && this.fGrouping.getGroupType() != null && (this.fGrouping.getGroupType() == DataType.DATE_TIME_LITERAL || this.fGrouping.getGroupType() == DataType.TEXT_LITERAL) && this.fGrouping.getGroupingUnit() != null) {
                String name = ChartUtil.getGroupingUnitName((SeriesGrouping)this.fGrouping);
                if (name != null) {
                    String displayName = ns.getDisplayNameByName(name);
                    if (displayName == null) {
                        this.cmbUnit.select(0);
                    } else {
                        this.cmbUnit.setText(displayName);
                    }
                } else {
                    this.cmbUnit.select(0);
                }
            }
        } else {
            this.cmbUnit.removeAll();
        }
        this.lblUnit.setEnabled(isGroupingEnableUI && (this.isDateTimeGrouping(this.cmbType.getText()) || this.isTextGrouping(this.cmbType.getText())));
        this.cmbUnit.setEnabled(this.lblUnit.getEnabled());
    }

    private boolean isTextGrouping(String dataTypeName) {
        return DataType.TEXT_LITERAL.getName().equals(LiteralHelper.dataTypeSet.getNameByDisplayName(dataTypeName));
    }

    private boolean isDateTimeGrouping(String dataTypeName) {
        return DataType.DATE_TIME_LITERAL.getName().equals(LiteralHelper.dataTypeSet.getNameByDisplayName(dataTypeName));
    }

    private int getAggregateIndexByName(String name) {
        if (this.fbAggEnabled) {
            String[] names = (String[])this.cmbAggregate.getData();
            int i = 0;
            while (i < names.length) {
                if (name.equals(names[i])) {
                    return i;
                }
                ++i;
            }
        }
        return 0;
    }

    public void widgetSelected(SelectionEvent e) {
        Object oSource = e.getSource();
        if (oSource.equals(this.cmbType)) {
            this.fGrouping.setGroupType(DataType.getByName((String)LiteralHelper.dataTypeSet.getNameByDisplayName(this.cmbType.getText())));
            boolean bEnableUI = this.btnEnabled.getSelection();
            String selName = this.cmbType.getText();
            boolean bEnabled = this.isDateTimeGrouping(selName) || this.isTextGrouping(selName);
            this.resetGroupingUnitsCombo(bEnableUI);
            this.lblUnit.setEnabled(bEnableUI & bEnabled);
            this.cmbUnit.setEnabled(bEnableUI & bEnabled);
            this.lblInterval.setEnabled(bEnableUI);
            this.iscInterval.setEnabled(bEnableUI);
            if (this.fbAggEnabled) {
                this.lblAggregate.setEnabled(bEnableUI);
                this.cmbAggregate.setEnabled(bEnableUI);
                if (this.fChartContext.getChartType() instanceof StockChart && this.fGrouping.getGroupType().getValue() == 1) {
                    ChartUIUtil.updateDefaultAggregations((Chart)this.fChartContext.getModel());
                }
            }
        } else if (oSource.equals(this.cmbUnit)) {
            this.fGrouping.setGroupingUnit(GroupingUnitType.getByName((String)LiteralHelper.groupingUnitTypeSet.getNameByDisplayName(this.cmbUnit.getText())));
        } else if (oSource.equals(this.cmbAggregate)) {
            int idx = this.cmbAggregate.getSelectionIndex();
            String aggExpr = null;
            if (idx >= 0) {
                String[] names = (String[])this.cmbAggregate.getData();
                aggExpr = names[idx];
            }
            this.showAggregateParameters(aggExpr);
            this.getShell().pack();
            this.fGrouping.setAggregateExpression(aggExpr);
        } else if (oSource.equals(this.btnEnabled)) {
            this.fGrouping.setEnabled(this.btnEnabled.getSelection());
            this.setButtonsStatus();
            this.populateLists();
            this.populateAggParameters();
            String aggFuncName = null;
            try {
                aggFuncName = ((String[])this.cmbAggregate.getData())[this.cmbAggregate.getSelectionIndex()];
            }
            catch (Exception exception) {}
            this.showAggregateParameters(aggFuncName);
            this.getShell().pack();
        } else if (oSource.equals(this.iscInterval)) {
            this.fGrouping.setGroupingInterval(Double.valueOf(this.iscInterval.getText()).doubleValue());
        } else if (this.isAggParametersWidget(oSource)) {
            this.setAggParameter((Text)oSource);
        } else if (this.isBuilderBtnWidget(oSource)) {
            try {
                Text txtArg = this.fExprBuilderWidgetsMap.get(oSource);
                String sExpr = this.fChartContext.getUIServiceProvider().invoke(1, txtArg.getText(), this.fChartContext.getExtendedItem(), this.fTitle);
                txtArg.setText(sExpr);
                this.setAggParameter(txtArg);
            }
            catch (ChartException e1) {
                WizardBase.displayException((Throwable)e1);
            }
        }
    }

    private boolean isBuilderBtnWidget(Object source) {
        return this.fExprBuilderWidgetsMap.containsKey(source);
    }

    private void setAggParameter(Text oSource) {
        String text = oSource.getText();
        int index = this.fAggParamtersTextWidgets.indexOf(oSource);
        EList parameters = this.fGrouping.getAggregateParameters();
        int i = parameters.size();
        while (i < this.fAggParamtersTextWidgets.size()) {
            parameters.add(null);
            ++i;
        }
        parameters.set(index, (Object)text);
    }

    private boolean isAggParametersWidget(Object source) {
        return this.fAggParamtersTextWidgets.contains(source);
    }

    private void showAggregateParameters(String aggFuncName) {
        Control[] children = this.fAggParameterComposite.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].dispose();
            ++i;
        }
        this.fAggParamtersTextWidgets.clear();
        this.fExprBuilderWidgetsMap.clear();
        IAggregateFunction aFunc = null;
        try {
            aFunc = PluginSettings.instance().getAggregateFunction(aggFuncName);
        }
        catch (ChartException chartException) {}
        String[] args = null;
        if (aFunc != null) {
            args = aFunc.getDisplayParameters();
        }
        if (aFunc != null && args != null && args.length > 0) {
            ((GridData)this.fAggParameterComposite.getLayoutData()).exclude = false;
            ((GridData)this.fAggParameterComposite.getLayoutData()).heightHint = -1;
            int i2 = 0;
            while (i2 < args.length) {
                Label lblArg = new Label(this.fAggParameterComposite, 0);
                lblArg.setText(String.valueOf(args[i2]) + ":");
                GridData gd = new GridData();
                lblArg.setLayoutData((Object)gd);
                Text txtArg = new Text(this.fAggParameterComposite, 2048);
                GridData gridData = new GridData(768);
                gridData.horizontalIndent = 0;
                txtArg.setLayoutData((Object)gridData);
                this.fAggParamtersTextWidgets.add(txtArg);
                txtArg.addSelectionListener((SelectionListener)this);
                txtArg.addFocusListener(new FocusListener(){

                    public void focusGained(FocusEvent e) {
                    }

                    public void focusLost(FocusEvent e) {
                        SeriesGroupingComposite.this.setAggParameter((Text)e.getSource());
                    }
                });
                Button btnBuilder = new Button(this.fAggParameterComposite, 8);
                this.fExprBuilderWidgetsMap.put(btnBuilder, txtArg);
                GridData gdBTNBuilder = new GridData();
                gdBTNBuilder.heightHint = 20;
                gdBTNBuilder.widthHint = 20;
                btnBuilder.setLayoutData((Object)gdBTNBuilder);
                btnBuilder.setImage(UIHelper.getImage((String)"icons/obj16/expressionbuilder.gif"));
                btnBuilder.setToolTipText(Messages.getString("DataDefinitionComposite.Tooltip.InvokeExpressionBuilder"));
                btnBuilder.getImage().setBackground(btnBuilder.getBackground());
                btnBuilder.setEnabled(this.fChartContext.getUIServiceProvider().isInvokingSupported());
                btnBuilder.setVisible(this.fChartContext.getUIServiceProvider().isEclipseModeSupported());
                btnBuilder.addSelectionListener((SelectionListener)this);
                ++i2;
            }
        } else {
            ((GridData)this.fAggParameterComposite.getLayoutData()).heightHint = 0;
        }
        this.fAggParameterComposite.layout();
        this.fCmpAggregate.layout();
        Composite c = this.fAggParameterComposite;
        while (c != this.getShell()) {
            c.layout();
            c = c.getParent();
        }
        this.populateAggParameters();
    }

    public String[] getAggParametersName(String aggExpr) {
        return null;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

