/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.birt.core.archive.ArchiveLockManager;
import org.eclipse.birt.core.archive.ArchiveUtil;
import org.eclipse.birt.core.archive.FolderArchiveReader;
import org.eclipse.birt.core.archive.FolderArchiveWriter;
import org.eclipse.birt.core.archive.IArchiveLockManager;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.IStreamSorter;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.i18n.CoreMessages;

public class FolderArchive
implements IDocArchiveWriter,
IDocArchiveReader {
    private String folderName;
    private FolderArchiveReader reader;
    private FolderArchiveWriter writer;
    private boolean isOpen = false;

    public FolderArchive(String folderName) throws IOException {
        if (folderName == null || folderName.length() == 0) {
            throw new IOException(CoreMessages.getString("error.FolderNameIsNull"));
        }
        this.folderName = new File(folderName).getCanonicalPath();
        try {
            this.writer = new FolderArchiveWriter(folderName);
            this.reader = new FolderArchiveReader(folderName);
        }
        catch (IOException ex) {
            this.close();
            throw ex;
        }
    }

    public void initialize() throws IOException {
    }

    public String getName() {
        return this.folderName;
    }

    public RAOutputStream createRandomAccessStream(String relativePath) throws IOException {
        return this.writer.createRandomAccessStream(relativePath);
    }

    public RAOutputStream openRandomAccessStream(String relativePath) throws IOException {
        return this.writer.openRandomAccessStream(relativePath);
    }

    public RAOutputStream createOutputStream(String relativePath) throws IOException {
        return this.createRandomAccessStream(relativePath);
    }

    public RAOutputStream getOutputStream(String relativePath) throws IOException {
        return this.openRandomAccessStream(relativePath);
    }

    public RAInputStream getInputStream(String relativePath) throws IOException {
        return this.reader.getInputStream(relativePath);
    }

    public boolean dropStream(String relativePath) {
        return this.writer.dropStream(relativePath);
    }

    public boolean exists(String relativePath) {
        return this.writer.exists(relativePath);
    }

    public void setStreamSorter(IStreamSorter streamSorter) {
        this.writer.setStreamSorter(streamSorter);
    }

    public void finish() throws IOException {
        this.close();
    }

    public void open() throws IOException {
    }

    public RAInputStream getStream(String relativePath) throws IOException {
        return this.reader.getStream(relativePath);
    }

    public List listStreams(String relativeStoragePath) throws IOException {
        return this.reader.listStreams(relativeStoragePath);
    }

    public List listAllStreams() throws IOException {
        return this.reader.listAllStreams();
    }

    public void close() throws IOException {
        if (this.isOpen) {
            this.isOpen = false;
            try {
                this.writer.finish();
            }
            finally {
                this.reader.close();
            }
        }
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public Object lock(String stream) throws IOException {
        String path = ArchiveUtil.generateFullPath(this.folderName, String.valueOf(stream) + ".lck");
        IArchiveLockManager lockManager = ArchiveLockManager.getInstance();
        return lockManager.lock(path);
    }

    public void unlock(Object lock) {
        IArchiveLockManager lockManager = ArchiveLockManager.getInstance();
        lockManager.unlock(lock);
    }
}

