/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.extension;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.extension.BaseExtensionPointMainPage;

public class NewExtensionPointMainPage
extends BaseExtensionPointMainPage {
    private IPluginModelBase fModel;
    private IPluginExtensionPoint fPoint;

    public NewExtensionPointMainPage(IProject project, IPluginModelBase model) {
        this(project, model, null);
    }

    public NewExtensionPointMainPage(IProject project, IPluginModelBase model, IPluginExtensionPoint point) {
        super((IContainer)project);
        this.initialize();
        this.fModel = model;
        this.fPoint = point;
    }

    public void initialize() {
        this.setTitle(PDEUIMessages.NewExtensionPointWizard_title);
        this.setDescription(PDEUIMessages.NewExtensionPointWizard_desc);
    }

    protected boolean isPluginIdFinal() {
        return true;
    }

    public boolean finish() {
        this.setPageComplete(false);
        String id = this.fIdText.getText();
        String name = this.fNameText.getText();
        String schema = this.fSchemaText.getText();
        IPluginBase plugin = this.fModel.getPluginBase();
        IPluginExtensionPoint point = this.fModel.getFactory().createExtensionPoint();
        try {
            point.setId(id);
            if (name.length() > 0) {
                point.setName(name);
            }
            if (schema.length() > 0) {
                point.setSchema(schema);
            }
            plugin.add(point);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        if (schema.length() > 0) {
            IRunnableWithProgress operation = this.getOperation();
            try {
                this.getContainer().run(true, true, operation);
            }
            catch (InvocationTargetException e) {
                PDEPlugin.logException(e);
                return false;
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
        return true;
    }

    public String getPluginId() {
        return this.fModel.getPluginBase().getId();
    }

    protected void initializeValues() {
        if (this.fPoint == null) {
            return;
        }
        if (this.fIdText != null && this.fPoint.getId() != null) {
            this.fIdText.setText(this.fPoint.getId());
        }
        if (this.fNameText != null && this.fPoint.getName() != null) {
            this.fNameText.setText(this.fPoint.getName());
        }
        if (this.fSchemaText != null && this.fPoint.getSchema() != null) {
            this.fSchemaText.setText(this.fPoint.getSchema());
        }
    }

    protected String validateFieldContents() {
        String message = this.validateExtensionPointID();
        if (message != null) {
            return message;
        }
        message = this.validateExtensionPointName();
        if (message != null) {
            return message;
        }
        message = this.validateExtensionPointSchema();
        if (message != null) {
            return message;
        }
        return null;
    }

    protected String validateExtensionPointSchema() {
        return null;
    }
}

