/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.outline.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class OutlineFilterAndSorter {
    private List<IFilter> filters = Lists.newArrayList();
    private IComparator comparator;

    public IOutlineNode[] filterAndSort(Iterable<IOutlineNode> nodes) {
        Iterable<IFilter> enabledFilters = this.getEnabledFilters();
        Iterable filteredNodes = null;
        filteredNodes = Iterables.isEmpty(enabledFilters) ? nodes : Iterables.filter(nodes, (Predicate)new Predicate<IOutlineNode>(){

            public boolean apply(final IOutlineNode node) {
                return Iterables.all((Iterable)OutlineFilterAndSorter.this.filters, (Predicate)new Predicate<IFilter>(){

                    public boolean apply(IFilter filter) {
                        return filter.apply(node);
                    }
                });
            }
        });
        IOutlineNode[] nodesAsArray = (IOutlineNode[])Iterables.toArray(filteredNodes, IOutlineNode.class);
        if (this.comparator != null && this.comparator.isEnabled()) {
            Arrays.sort(nodesAsArray, this.comparator);
        }
        return nodesAsArray;
    }

    protected Iterable<IFilter> getEnabledFilters() {
        return Iterables.filter(this.filters, (Predicate)new Predicate<IFilter>(){

            public boolean apply(IFilter filter) {
                return filter.isEnabled();
            }
        });
    }

    public void setComparator(IComparator comparator) {
        this.comparator = comparator;
    }

    public boolean addFilter(IFilter filter) {
        return this.filters.add(filter);
    }

    public boolean removeFilter(IFilter filter) {
        return this.filters.remove(filter);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IComparator
    extends Comparator<IOutlineNode> {
        public boolean isEnabled();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IFilter
    extends Predicate<IOutlineNode> {
        public boolean isEnabled();
    }
}

