/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.impl;

import com.google.inject.Inject;
import java.io.IOException;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.ui.refactoring.IRefactoringUpdateAcceptor;
import org.eclipse.xtext.ui.refactoring.IRenameStrategy;
import org.eclipse.xtext.ui.refactoring.impl.AbstractRenameStrategy;
import org.eclipse.xtext.ui.refactoring.impl.EmfResourceChangeUtil;
import org.eclipse.xtext.ui.refactoring.impl.RefactoringStatusException;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;

public class EmfResourceRenameStrategy
extends AbstractRenameStrategy {
    private EmfResourceChangeUtil changeUtil;

    protected EmfResourceRenameStrategy(ENamedElement targetEObject, EmfResourceChangeUtil changeUtil) {
        super((EObject)targetEObject);
        this.changeUtil = changeUtil;
    }

    public void createDeclarationUpdates(String newName, ResourceSet resourceSet, IRefactoringUpdateAcceptor updateAcceptor) {
        this.applyDeclarationChange(newName, resourceSet);
        Resource targetResource = resourceSet.getResource(this.targetElementOriginalURI.trimFragment(), false);
        try {
            this.changeUtil.addSaveAsUpdate(targetResource, updateAcceptor);
        }
        catch (IOException exc) {
            throw new RefactoringStatusException(exc, true);
        }
    }

    public static class Provider
    implements IRenameStrategy.Provider {
        @Inject
        private EmfResourceChangeUtil changeUtil;

        public IRenameStrategy get(EObject targetEObject, IRenameElementContext renameElementContext) {
            if (targetEObject instanceof ENamedElement) {
                return new EmfResourceRenameStrategy((ENamedElement)targetEObject, this.changeUtil);
            }
            return null;
        }
    }
}

