/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.model.space;

import java.util.List;
import org.ascape.model.space.Coordinate;
import org.ascape.model.space.CoordinateDiscrete;
import org.ascape.model.space.Discrete;
import org.ascape.model.space.Location;
import org.ascape.model.space.Node;
import org.ascape.util.Conditional;

public abstract class Array
extends Discrete {
    private static final long serialVersionUID = 1L;
    public static final boolean CACHE_RESULTS = false;

    public Array() {
    }

    public Array(CoordinateDiscrete extent) {
        this();
        this.setExtent(extent);
    }

    public abstract Location findRandomMatchInRank(Coordinate var1, Conditional var2, int var3);

    public abstract int findNearestMatchRank(Coordinate var1, Conditional var2, boolean var3, double var4);

    @Override
    public Location findNearest(Coordinate origin, Conditional condition, boolean includeOrigin, double maximumDistance) {
        int nearestRank = this.findNearestMatchRank(origin, condition, includeOrigin, maximumDistance);
        if (nearestRank >= 0) {
            return this.findRandomMatchInRank(origin, condition, nearestRank);
        }
        return null;
    }

    @Override
    public List findWithin(Coordinate origin, Conditional condition, boolean includeOrigin, double distance) {
        List result = null;
        result = this.findWithinImpl(origin, includeOrigin, distance);
        return Array.filter(result, condition);
    }

    protected abstract List findWithinImpl(Coordinate var1, boolean var2, double var3);

    public void replace(Node currentCell, Node newCell) {
        this.set(currentCell.getCoordinate(), newCell);
    }

    public void swap(Node one, Node two) {
        Coordinate coordOne = one.getCoordinate();
        Coordinate coordTwo = two.getCoordinate();
        this.set(coordOne, two);
        this.set(coordTwo, one);
    }

    class FindKey {
        Coordinate origin;
        boolean includeSelf;
        int dist;

        public FindKey(Coordinate origin, boolean includeSelf, int dist) {
            this.dist = dist;
            this.includeSelf = includeSelf;
            this.origin = origin;
        }

        public boolean equals(Object o) {
            FindKey find = (FindKey)o;
            if (o == null) {
                return false;
            }
            if (this.dist != find.dist) {
                return false;
            }
            if (this.includeSelf != find.includeSelf) {
                return false;
            }
            return this.origin == this.origin;
        }

        public int hashCode() {
            int result = this.origin.hashCode();
            result = 29 * result + (this.includeSelf ? 1 : 0);
            result = 29 * result + this.dist;
            return result;
        }
    }
}

