/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.model.space;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ascape.model.space.Array2D;
import org.ascape.model.space.BFSWithinIterator;
import org.ascape.model.space.Coordinate;
import org.ascape.model.space.Coordinate2DDiscrete;
import org.ascape.model.space.CoordinateDiscrete;
import org.ascape.model.space.Discrete;
import org.ascape.model.space.Geometry;
import org.ascape.model.space.Location;
import org.ascape.model.space.Node;
import org.ascape.util.Conditional;

public class Array2DSmallWorld
extends Array2D {
    private static final long serialVersionUID = 1L;
    protected int radius = 1;
    protected double randomEdgeRatio;
    private Map distanceForPair;
    Set smallWorldCells;

    public Array2DSmallWorld() {
    }

    public Array2DSmallWorld(CoordinateDiscrete extent) {
        this();
        this.setGeometry(new Geometry(2, true, -1));
        this.setExtent(extent);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.smallWorldCells = new HashSet();
    }

    @Override
    public List calculateNeighbors(Node cell) {
        ArrayList<Location> neighbors = new ArrayList<Location>(this.findWithinMoore(cell.getCoordinate(), false, this.radius));
        if (this.randomEdgeRatio > 0.0) {
            int i = 0;
            while (i < neighbors.size()) {
                if (this.getRandom().nextDouble() < this.randomEdgeRatio) {
                    boolean tryAgain;
                    this.smallWorldCells.add(cell);
                    do {
                        tryAgain = false;
                        neighbors.remove(i);
                        neighbors.add(i, this.findRandom());
                        int j = 0;
                        while (j < neighbors.size()) {
                            if (j != i && neighbors.get(j) == neighbors.get(i)) {
                                tryAgain = true;
                            }
                            ++j;
                        }
                    } while (tryAgain);
                }
                ++i;
            }
        }
        return neighbors;
    }

    void calculateAllDistances() {
        System.out.println("Calculating distances..");
        CalcThread monitor = new CalcThread();
        monitor.start();
        Object[] all = this.toArray();
        while (monitor.i < all.length) {
            Node origin = (Node)all[monitor.i];
            int j = monitor.i + 1;
            while (j < all.length) {
                Node target = (Node)all[j];
                double result = this.calculateDistance(origin, target);
                this.distanceForPair.put(new CellPair(origin, target), new Double(result));
                ++j;
            }
            ++monitor.i;
        }
        monitor.running = false;
        System.out.println("Finished calcualting distances..");
    }

    @Override
    public Location findNearest(Coordinate origin, Conditional condition, boolean includeOrigin, double distance) {
        return this.findNearestBFS(origin, condition, includeOrigin, distance);
    }

    @Override
    public int findNearestMatchRank(Coordinate origin, Conditional condition, boolean includeOrigin, double maximumDistance) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Method not appropriate for this space.");
    }

    @Override
    public Location findRandomMatchInRank(Coordinate origin, Conditional condition, int rank) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Method not appropriate for this space.");
    }

    @Override
    public List findWithinImpl(Coordinate origin, boolean includeSelf, double distance) {
        return Array2DSmallWorld.iteratorToList(new BFSWithinIterator(this, this.get(origin), null, includeSelf, distance));
    }

    @Override
    protected Iterator bfsWithinIterator(Location origin, Conditional condition, boolean includeSelf, double distance) {
        return new BFSWithinIterator(this, origin, condition, includeSelf, distance);
    }

    @Override
    public Iterator withinIterator(Coordinate origin, Conditional condition, boolean includeSelf, double distance) {
        return this.bfsWithinIterator(this.get((CoordinateDiscrete)origin), condition, includeSelf, distance);
    }

    @Override
    public double calculateDistance(Coordinate origin, Coordinate target) {
        BFSWithinIterator within = (BFSWithinIterator)this.withinIterator(origin, new Discrete.FindCoordinateCondition(this, target), true, Double.MAX_VALUE);
        Location result = (Location)within.next();
        if (result != null) {
            return within.getDepth();
        }
        return Double.NaN;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public double getRandomEdgeRatio() {
        return this.randomEdgeRatio;
    }

    public void setRandomEdgeRatio(double randomEdgeRatio) {
        this.randomEdgeRatio = randomEdgeRatio;
    }

    public Set getSmallWorldCells() {
        return this.smallWorldCells;
    }

    class CalcThread
    extends Thread {
        boolean running = true;
        int i;

        CalcThread() {
        }

        @Override
        public void run() {
            while (this.running) {
                try {
                    CalcThread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                System.out.println(String.valueOf((double)this.i / (double)Array2DSmallWorld.this.getSize()) + "% complete");
            }
        }
    }

    class CellPair {
        Coordinate2DDiscrete v1;
        Coordinate2DDiscrete v2;

        public CellPair(Coordinate v1, Coordinate v2) {
            this.v1 = (Coordinate2DDiscrete)v1;
            this.v2 = (Coordinate2DDiscrete)v2;
        }

        public CellPair(Node v1, Node v2) {
            this(v1.getCoordinate(), v2.getCoordinate());
        }

        public final boolean equals(Object o) {
            CellPair other = (CellPair)o;
            return this.v1.equals(other.v1) && this.v2.equals(other.v2) || this.v1.equals(other.v2) && this.v2.equals(other.v1);
        }

        public final int hashCode() {
            int result = this.v1.hashCode() + this.v2.hashCode();
            return result;
        }
    }
}

