/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.view.nonvis;

import java.util.TooManyListenersException;
import org.ascape.model.event.DefaultScapeListener;
import org.ascape.model.event.ScapeEvent;

public class ScapeTransitionListener
extends DefaultScapeListener {
    private static final long serialVersionUID = -2745637872333511630L;
    private long lastUpdateInMillis = 0L;
    private long maxMillisBetweenUpdates = 166L;
    private boolean lastScapeAppearsRunning = false;
    protected boolean lastScapeAppearsPaused = false;

    public ScapeTransitionListener() {
        this("Scape Transition Listener");
    }

    public ScapeTransitionListener(String name) {
        super(name);
    }

    public void scapeNowRunning() {
    }

    public void scapeNowStopped() {
    }

    public void scapeNowPaused() {
    }

    public void scapeNowResumed() {
    }

    public void scapeNowSteppable() {
    }

    public void environmentNowScape() {
    }

    public void environmentNowNoScape() {
    }

    @Override
    public void scapeAdded(ScapeEvent scapeEvent) throws TooManyListenersException {
        super.scapeAdded(scapeEvent);
        this.lastScapeAppearsPaused = !this.getScape().isPaused();
        this.lastScapeAppearsRunning = !this.getScape().isRunning();
        this.lastUpdateInMillis = 0L;
        this.environmentNowScape();
    }

    @Override
    public void scapeRemoved(ScapeEvent scapeEvent) {
        super.scapeRemoved(scapeEvent);
        this.scape = null;
        this.environmentNowNoScape();
    }

    public synchronized void updateTransitions() {
        if (this.scape != null) {
            boolean scapeAppearsRunning = this.getScape().isRunning();
            boolean scapeAppearsPaused = this.getScape().isPaused();
            if (scapeAppearsRunning && !this.lastScapeAppearsRunning) {
                this.scapeNowRunning();
                if (scapeAppearsPaused) {
                    this.scapeNowPaused();
                }
            } else if (!scapeAppearsRunning && this.lastScapeAppearsRunning) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.scapeNowStopped();
            }
            if (scapeAppearsPaused && !this.lastScapeAppearsPaused) {
                this.scapeNowPaused();
            }
            if (!scapeAppearsPaused && this.lastScapeAppearsPaused && scapeAppearsRunning) {
                this.scapeNowResumed();
            }
            if (scapeAppearsPaused && !this.lastScapeAppearsPaused && scapeAppearsRunning || scapeAppearsRunning && !this.lastScapeAppearsRunning && scapeAppearsPaused) {
                this.scapeNowSteppable();
            }
            this.lastScapeAppearsRunning = scapeAppearsRunning;
            this.lastScapeAppearsPaused = scapeAppearsPaused;
            this.lastUpdateInMillis = System.currentTimeMillis();
        }
    }

    @Override
    public boolean isLifeOfScape() {
        return false;
    }

    @Override
    public void scapeNotification(ScapeEvent scapeEvent) {
        super.scapeNotification(scapeEvent);
        if (System.currentTimeMillis() - this.lastUpdateInMillis > this.maxMillisBetweenUpdates) {
            this.updateTransitions();
        }
    }
}

