/*
 * Decompiled with CFR 0.152.
 */
package org.metaabm.ide;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.EclipseUIPlugin;
import org.eclipse.emf.common.ui.MarkerHelper;
import org.eclipse.emf.common.ui.ViewerPane;
import org.eclipse.emf.common.ui.editor.ProblemEditorPart;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLParserPool;
import org.eclipse.emf.ecore.xmi.impl.XMLParserPoolImpl;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.util.EditUIMarkerHelper;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.emf.edit.ui.view.ExtendedPropertySheetPage;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.metaabm.SAgent;
import org.metaabm.act.AInput;
import org.metaabm.act.provider.MetaABMActItemProviderAdapterFactory;
import org.metaabm.function.provider.MetaABMFunctionItemProviderAdapterFactory;
import org.metaabm.ide.AgentAction;
import org.metaabm.ide.JavaAgentImporter;
import org.metaabm.ide.MetaModelerPlugin;
import org.metaabm.provider.MetaABMItemProviderAdapterFactory;

public class MetaABMEditor
extends MultiPageEditorPart
implements IEditingDomainProvider,
ISelectionProvider,
IMenuListener,
IViewerProvider,
IGotoMarker {
    protected AdapterFactoryEditingDomain editingDomain;
    protected ComposedAdapterFactory adapterFactory;
    protected IContentOutlinePage contentOutlinePage;
    protected IStatusLineManager contentOutlineStatusLineManager;
    protected TreeViewer contentOutlineViewer;
    protected PropertySheetPage propertySheetPage;
    protected TreeViewer selectionViewer;
    protected TreeViewer parentViewer;
    protected TreeViewer treeViewer;
    protected ListViewer listViewer;
    protected TableViewer tableViewer;
    protected TreeViewer treeViewerWithColumns;
    protected ViewerPane currentViewerPane;
    protected Viewer currentViewer;
    protected ISelectionChangedListener selectionChangedListener;
    protected Collection<ISelectionChangedListener> selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    protected ISelection editorSelection = StructuredSelection.EMPTY;
    protected MarkerHelper markerHelper = new EditUIMarkerHelper();
    protected Map<String, ColumnWeightData> columnWeightHints = new HashMap<String, ColumnWeightData>();
    protected ColumnWeightData defaultColumnWeight;
    protected IPartListener partListener;
    protected Collection<Resource> removedResources;
    protected Collection<Resource> changedResources;
    protected Collection<Resource> savedResources;
    protected Map<Resource, Diagnostic> resourceToDiagnosticMap;
    protected boolean updateProblemIndication;
    protected boolean displayAttributeReferences;
    protected EContentAdapter problemIndicationAdapter;
    protected IResourceChangeListener resourceChangeListener;
    private AgentAction importFromClassAction;
    private XMLParserPool parserPool;
    private Map nameToFeatureMap;
    private List lookupTable;

    protected void handleActivate() {
        if (this.editingDomain.getResourceToReadOnlyMap() != null) {
            this.editingDomain.getResourceToReadOnlyMap().clear();
            this.setSelection(this.getSelection());
        }
        if (!this.removedResources.isEmpty()) {
            if (this.handleDirtyConflict()) {
                this.getSite().getPage().closeEditor((IEditorPart)this, false);
            } else {
                this.removedResources.clear();
                this.changedResources.clear();
                this.savedResources.clear();
            }
        } else if (!this.changedResources.isEmpty()) {
            this.changedResources.removeAll(this.savedResources);
            this.handleChangedResources();
            this.changedResources.clear();
            this.savedResources.clear();
        }
    }

    protected void handleChangedResources() {
        if (!(this.changedResources.isEmpty() || this.isDirty() && !this.handleDirtyConflict())) {
            if (this.isDirty()) {
                this.changedResources.addAll((Collection<Resource>)this.editingDomain.getResourceSet().getResources());
            }
            this.editingDomain.getCommandStack().flush();
            this.updateProblemIndication = false;
            for (Resource resource : this.changedResources) {
                if (!resource.isLoaded()) continue;
                resource.unload();
                try {
                    resource.load(Collections.EMPTY_MAP);
                }
                catch (IOException exception) {
                    if (this.resourceToDiagnosticMap.containsKey(resource)) continue;
                    this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
                }
            }
            this.updateProblemIndication = true;
            this.updateProblemIndication();
        }
    }

    protected void updateProblemIndication() {
        if (this.updateProblemIndication) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(0, "org.metaabm.ide", 0, null, new Object[]{this.editingDomain.getResourceSet()});
            for (Diagnostic childDiagnostic : this.resourceToDiagnosticMap.values()) {
                if (childDiagnostic.getSeverity() == 0) continue;
                diagnostic.add(childDiagnostic);
            }
            int lastEditorPage = this.getPageCount() - 1;
            if (lastEditorPage >= 0 && this.getEditor(lastEditorPage) instanceof ProblemEditorPart) {
                ((ProblemEditorPart)this.getEditor(lastEditorPage)).setDiagnostic((Diagnostic)diagnostic);
                if (diagnostic.getSeverity() != 0) {
                    this.setActivePage(lastEditorPage);
                }
            } else if (diagnostic.getSeverity() != 0) {
                ProblemEditorPart problemEditorPart = new ProblemEditorPart();
                problemEditorPart.setDiagnostic((Diagnostic)diagnostic);
                problemEditorPart.setMarkerHelper(this.markerHelper);
                try {
                    this.addPage(++lastEditorPage, (IEditorPart)problemEditorPart, this.getEditorInput());
                    this.setPageText(lastEditorPage, problemEditorPart.getPartName());
                    this.setActivePage(lastEditorPage);
                    this.showTabs();
                }
                catch (PartInitException exception) {
                    MetaModelerPlugin.INSTANCE.log((Object)exception);
                }
            }
            if (this.markerHelper.hasMarkers((Object)this.editingDomain.getResourceSet())) {
                this.markerHelper.deleteMarkers((Object)this.editingDomain.getResourceSet());
                if (diagnostic.getSeverity() != 0) {
                    try {
                        this.markerHelper.createMarkers((Diagnostic)diagnostic);
                    }
                    catch (CoreException exception) {
                        MetaModelerPlugin.INSTANCE.log((Object)exception);
                    }
                }
            }
        }
    }

    protected boolean handleDirtyConflict() {
        return MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)MetaABMEditor.getString("_UI_FileConflict_label"), (String)MetaABMEditor.getString("_WARN_FileConflict"));
    }

    public MetaABMEditor() {
        this.columnWeightHints.put("label", new ColumnWeightData(5));
        this.columnWeightHints.put("description", new ColumnWeightData(6));
        this.columnWeightHints.put("gatherData", new ColumnWeightData(1));
        this.columnWeightHints.put("defaultValue", new ColumnWeightData(3));
        this.defaultColumnWeight = new ColumnWeightData(2);
        this.partListener = new IPartListener(){

            public void partActivated(IWorkbenchPart p) {
                if (p instanceof ContentOutline) {
                    if (((ContentOutline)p).getCurrentPage() == MetaABMEditor.this.contentOutlinePage) {
                        MetaABMEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)MetaABMEditor.this);
                        MetaABMEditor.this.setCurrentViewer((Viewer)MetaABMEditor.this.contentOutlineViewer);
                    }
                } else if (p instanceof PropertySheet) {
                    if (((PropertySheet)p).getCurrentPage() == MetaABMEditor.this.propertySheetPage) {
                        MetaABMEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)MetaABMEditor.this);
                        MetaABMEditor.this.handleActivate();
                    }
                } else if (p == MetaABMEditor.this) {
                    MetaABMEditor.this.handleActivate();
                }
            }

            public void partBroughtToTop(IWorkbenchPart p) {
            }

            public void partClosed(IWorkbenchPart p) {
            }

            public void partDeactivated(IWorkbenchPart p) {
            }

            public void partOpened(IWorkbenchPart p) {
            }
        };
        this.removedResources = new ArrayList<Resource>();
        this.changedResources = new ArrayList<Resource>();
        this.savedResources = new ArrayList<Resource>();
        this.resourceToDiagnosticMap = new LinkedHashMap<Resource, Diagnostic>();
        this.updateProblemIndication = true;
        this.displayAttributeReferences = false;
        this.problemIndicationAdapter = new EContentAdapter(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void notifyChanged(Notification notification) {
                if (notification.getNotifier() instanceof Resource) {
                    switch (notification.getFeatureID(Resource.class)) {
                        case 4: 
                        case 6: 
                        case 7: {
                            Resource resource = (Resource)notification.getNotifier();
                            Diagnostic diagnostic = MetaABMEditor.this.analyzeResourceProblems(resource, null);
                            if (diagnostic.getSeverity() != 0) {
                                MetaABMEditor.this.resourceToDiagnosticMap.put(resource, diagnostic);
                            } else {
                                MetaABMEditor.this.resourceToDiagnosticMap.remove(resource);
                            }
                            if (!MetaABMEditor.this.updateProblemIndication) return;
                            MetaABMEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    MetaABMEditor.this.updateProblemIndication();
                                }
                            });
                        }
                        default: {
                            return;
                        }
                    }
                } else {
                    super.notifyChanged(notification);
                }
            }

            protected void setTarget(Resource target) {
                this.basicSetTarget((Notifier)target);
            }

            protected void unsetTarget(Resource target) {
                this.basicUnsetTarget((Notifier)target);
            }
        };
        this.resourceChangeListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                IResourceDelta delta = event.getDelta();
                try {
                    class ResourceDeltaVisitor
                    implements IResourceDeltaVisitor {
                        protected ResourceSet resourceSet;
                        protected Collection<Resource> changedResources;
                        protected Collection<Resource> removedResources;

                        ResourceDeltaVisitor() {
                            this.resourceSet = (this).MetaABMEditor.this.editingDomain.getResourceSet();
                            this.changedResources = new ArrayList<Resource>();
                            this.removedResources = new ArrayList<Resource>();
                        }

                        public boolean visit(IResourceDelta delta) {
                            Resource resource;
                            if (delta.getResource().getType() == 1 && (delta.getKind() == 2 || delta.getKind() == 4 && delta.getFlags() != 131072) && (resource = this.resourceSet.getResource(URI.createPlatformResourceURI((String)delta.getFullPath().toString(), (boolean)true), false)) != null) {
                                if (delta.getKind() == 2) {
                                    this.removedResources.add(resource);
                                } else if (!(this).MetaABMEditor.this.savedResources.remove(resource)) {
                                    this.changedResources.add(resource);
                                }
                            }
                            return true;
                        }

                        public Collection<Resource> getChangedResources() {
                            return this.changedResources;
                        }

                        public Collection<Resource> getRemovedResources() {
                            return this.removedResources;
                        }
                    }
                    final ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
                    delta.accept((IResourceDeltaVisitor)visitor);
                    if (!visitor.getRemovedResources().isEmpty()) {
                        MetaABMEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){
                            {
                            }

                            @Override
                            public void run() {
                                (this).MetaABMEditor.this.removedResources.addAll(visitor.getRemovedResources());
                                if (!MetaABMEditor.this.isDirty()) {
                                    MetaABMEditor.this.getSite().getPage().closeEditor((IEditorPart)MetaABMEditor.this, false);
                                }
                            }
                        });
                    }
                    if (!visitor.getChangedResources().isEmpty()) {
                        MetaABMEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){
                            {
                            }

                            @Override
                            public void run() {
                                (this).MetaABMEditor.this.changedResources.addAll(visitor.getChangedResources());
                                if (MetaABMEditor.this.getSite().getPage().getActiveEditor() == MetaABMEditor.this) {
                                    MetaABMEditor.this.handleActivate();
                                }
                            }
                        });
                    }
                }
                catch (CoreException exception) {
                    MetaModelerPlugin.INSTANCE.log((Object)exception);
                }
            }
        };
        this.importFromClassAction = new AgentAction(this, MetaModelerPlugin.INSTANCE.getString("_UI_ImportAgent_menu_item"), EclipseUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.amp.amf.ide", (String)"icons/full/obj16/JavaCompilationUnit.gif")){
            final String[] javaFilter;
            {
                this.javaFilter = new String[]{"java"};
            }

            @Override
            public void run(SAgent agent) {
                FileDialog fileSelector = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
                fileSelector.setFilterExtensions(this.javaFilter);
                String path = fileSelector.open();
                if (path != null) {
                    new JavaAgentImporter(agent, path).schedule(10L);
                }
            }
        };
        this.parserPool = new XMLParserPoolImpl();
        this.nameToFeatureMap = new HashMap();
        this.lookupTable = new ArrayList();
        this.initializeEditingDomain();
    }

    protected void initializeEditingDomain() {
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new MetaABMItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new MetaABMFunctionItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new MetaABMActItemProviderAdapterFactory());
        BasicCommandStack commandStack = new BasicCommandStack();
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(final EventObject event) {
                MetaABMEditor.this.getContainer().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MetaABMEditor.this.firePropertyChange(257);
                        Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
                        if (mostRecentCommand != null && (this).MetaABMEditor.this.currentViewer != (this).MetaABMEditor.this.contentOutlineViewer) {
                            MetaABMEditor.this.setSelectionToViewer(mostRecentCommand.getAffectedObjects());
                        }
                        if ((this).MetaABMEditor.this.propertySheetPage != null && !(this).MetaABMEditor.this.propertySheetPage.getControl().isDisposed()) {
                            (this).MetaABMEditor.this.propertySheetPage.refresh();
                        }
                    }
                });
            }
        });
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)commandStack, new HashMap());
    }

    protected void firePropertyChange(int action) {
        super.firePropertyChange(action);
    }

    public void setSelectionToViewer(Collection<?> collection) {
        Collection<?> theSelection = collection;
        if (theSelection != null && !theSelection.isEmpty()) {
            final ArrayList<Object> wrapped = new ArrayList<Object>();
            for (Object object : theSelection) {
                Object wrapper = this.editingDomain.getWrapper(object);
                if (wrapper != null) {
                    wrapped.add(wrapper);
                    continue;
                }
                wrapped.add(object);
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (MetaABMEditor.this.currentViewer != null) {
                        MetaABMEditor.this.currentViewer.setSelection((ISelection)new StructuredSelection(wrapped.toArray()), true);
                    }
                }
            };
            runnable.run();
        }
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void setCurrentViewerPane(ViewerPane viewerPane) {
        if (this.currentViewerPane != viewerPane) {
            if (this.currentViewerPane != null) {
                this.currentViewerPane.showFocus(false);
            }
            this.currentViewerPane = viewerPane;
        }
        this.setCurrentViewer(this.currentViewerPane.getViewer());
    }

    public void setCurrentViewer(Viewer viewer) {
        if (this.currentViewer != viewer) {
            if (this.selectionChangedListener == null) {
                this.selectionChangedListener = new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                        MetaABMEditor.this.setSelection(selectionChangedEvent.getSelection());
                    }
                };
            }
            if (this.currentViewer != null) {
                this.currentViewer.removeSelectionChangedListener(this.selectionChangedListener);
            }
            if (viewer != null) {
                viewer.addSelectionChangedListener(this.selectionChangedListener);
            }
            this.currentViewer = viewer;
            this.setSelection((ISelection)(this.currentViewer == null ? StructuredSelection.EMPTY : this.currentViewer.getSelection()));
        }
    }

    protected void updateSelection() {
        this.setSelection((ISelection)(this.currentViewer == null ? StructuredSelection.EMPTY : this.currentViewer.getSelection()));
    }

    public Viewer getViewer() {
        return this.currentViewer;
    }

    protected void createContextMenuFor(StructuredViewer viewer) {
        this.createContextMenuAdditions(viewer);
        this.createContextMenuDragSupport(viewer);
    }

    protected void createContextMenuDragSupport(StructuredViewer viewer) {
        int dndOperations = 7;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
        viewer.addDragSupport(dndOperations, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)viewer));
        viewer.addDropSupport(dndOperations, transfers, (DropTargetListener)new EditingDomainViewerDropAdapter((EditingDomain)this.editingDomain, (Viewer)viewer));
    }

    protected void createContextMenuAdditions(StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp", "org.eclipse.amp.amf.acore.editor");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        if (viewer == this.selectionViewer) {
            viewer.addDoubleClickListener((IDoubleClickListener)new TreeExpansionListener());
        }
    }

    public void createModel() {
        Diagnostic diagnostic;
        URI resourceURI = EditUIUtil.getURI((IEditorInput)this.getEditorInput());
        Exception exception = null;
        Resource resource = null;
        try {
            resource = this.editingDomain.getResourceSet().getResource(resourceURI, true);
        }
        catch (Exception e) {
            exception = e;
            resource = this.editingDomain.getResourceSet().getResource(resourceURI, false);
        }
        if (!resource.getURI().toString().contains("core_library.metaabm")) {
            this.getResource(URI.createURI((String)"http://metaabm.org/core_library.metaabm", (boolean)true));
        }
        if ((diagnostic = this.analyzeResourceProblems(resource, exception)).getSeverity() != 0) {
            this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
        }
        this.editingDomain.getResourceSet().eAdapters().add((Object)this.problemIndicationAdapter);
    }

    private void getResource(URI resourceURI) {
        Exception exception = null;
        Resource resource = null;
        Map loadOptions = this.editingDomain.getResourceSet().getLoadOptions();
        loadOptions.put("DEFER_ATTACHMENT", Boolean.TRUE);
        loadOptions.put("DEFER_IDREF_RESOLUTION", Boolean.TRUE);
        loadOptions.put("USE_DEPRECATED_METHODS", Boolean.TRUE);
        loadOptions.put("USE_PARSER_POOL", this.parserPool);
        loadOptions.put("USE_XML_NAME_TO_FEATURE_MAP", this.nameToFeatureMap);
        try {
            resource = this.editingDomain.getResourceSet().getResource(resourceURI, true);
        }
        catch (Exception e) {
            exception = e;
            resource = this.editingDomain.getResourceSet().getResource(resourceURI, false);
        }
        Diagnostic diagnostic = this.analyzeResourceProblems(resource, exception);
        if (diagnostic.getSeverity() != 0) {
            this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
        }
        this.editingDomain.getResourceSet().eAdapters().add((Object)this.problemIndicationAdapter);
    }

    public Diagnostic analyzeResourceProblems(Resource resource, Exception exception) {
        if (!resource.getErrors().isEmpty() || !resource.getWarnings().isEmpty()) {
            BasicDiagnostic basicDiagnostic = new BasicDiagnostic(4, "org.eclipse.amp.amf.acore.editor", 0, MetaABMEditor.getString("_UI_CreateModelError_message", resource.getURI()), new Object[]{exception == null ? resource : exception});
            basicDiagnostic.merge(EcoreUtil.computeDiagnostic((Resource)resource, (boolean)true));
            return basicDiagnostic;
        }
        if (exception != null) {
            return new BasicDiagnostic(4, "org.eclipse.amp.amf.acore.editor", 0, MetaABMEditor.getString("_UI_CreateModelError_message", resource.getURI()), new Object[]{exception});
        }
        return Diagnostic.OK_INSTANCE;
    }

    public void createPages() {
        this.createModel();
        if (!this.getEditingDomain().getResourceSet().getResources().isEmpty()) {
            this.createIndividualPages();
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MetaABMEditor.this.setActivePage(0);
                }
            });
        }
        this.getContainer().addControlListener((ControlListener)new ControlAdapter(){
            boolean guard = false;

            public void controlResized(ControlEvent event) {
                if (!this.guard) {
                    this.guard = true;
                    MetaABMEditor.this.hideTabs();
                    this.guard = false;
                }
            }
        });
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MetaABMEditor.this.updateProblemIndication();
            }
        });
    }

    protected void createIndividualPages() {
        ViewerPane viewerPane = new ViewerPane(this.getSite().getPage(), (IWorkbenchPart)this){

            public Viewer createViewer(Composite composite) {
                Tree tree = new Tree(composite, 2);
                TreeViewer newTreeViewer = new TreeViewer(tree){

                    protected void internalExpandToLevel(Widget item, int level) {
                        if (level != -1) {
                            super.internalExpandToLevel(item, level);
                        } else {
                            Object data = MetaABMEditor.this.unwrap(((TreeItem)item).getData());
                            if (!(data instanceof AInput)) {
                                super.internalExpandToLevel(item, level);
                            }
                        }
                    }
                };
                return newTreeViewer;
            }

            public void requestActivation() {
                super.requestActivation();
                MetaABMEditor.this.setCurrentViewerPane(this);
            }
        };
        viewerPane.createControl(this.getContainer());
        this.selectionViewer = (TreeViewer)viewerPane.getViewer();
        this.selectionViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
        this.selectionViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider.ColorProvider((AdapterFactory)this.adapterFactory, (Viewer)this.selectionViewer));
        this.selectionViewer.setInput(this.editingDomain.getResourceSet().getResources().get(0));
        this.selectionViewer.setSelection((ISelection)new StructuredSelection(this.editingDomain.getResourceSet().getResources().get(0)), true);
        viewerPane.setTitle(this.editingDomain.getResourceSet().getResources().get(0));
        new AdapterFactoryTreeEditor(this.selectionViewer.getTree(), (AdapterFactory)this.adapterFactory);
        this.createContextMenuFor((StructuredViewer)this.selectionViewer);
        int pageIndex = this.addPage(viewerPane.getControl());
        this.setPageText(pageIndex, MetaABMEditor.getString("_UI_SelectionPage_label"));
        viewerPane = new ViewerPane(this.getSite().getPage(), (IWorkbenchPart)this){

            public Viewer createViewer(Composite composite) {
                return new TreeViewer(composite);
            }

            public void requestActivation() {
                super.requestActivation();
                MetaABMEditor.this.setCurrentViewerPane(this);
            }
        };
        viewerPane.createControl(this.getContainer());
        this.treeViewerWithColumns = (TreeViewer)viewerPane.getViewer();
        Tree tree = this.treeViewerWithColumns.getTree();
        tree.setLayoutData((Object)new FillLayout());
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        TreeColumn objectColumn = new TreeColumn(tree, 0);
        objectColumn.setText(MetaABMEditor.getString("_UI_LabelColumn_label"));
        objectColumn.setResizable(true);
        objectColumn.setWidth(250);
        TreeColumn selfColumn = new TreeColumn(tree, 0);
        selfColumn.setText(MetaABMEditor.getString("_UI_DescColumn_label"));
        selfColumn.setResizable(true);
        selfColumn.setWidth(800);
        this.treeViewerWithColumns.setColumnProperties(new String[]{"a", "b"});
        this.treeViewerWithColumns.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
        this.treeViewerWithColumns.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider.ColorProvider((AdapterFactory)this.adapterFactory, (Viewer)this.treeViewerWithColumns));
        this.createContextMenuFor((StructuredViewer)this.treeViewerWithColumns);
        int pageIndex2 = this.addPage(viewerPane.getControl());
        this.setPageText(pageIndex2, MetaABMEditor.getString("_UI_TreeWithColumnsPage_label"));
    }

    public Object unwrap(Object data) {
        if (data instanceof IWrapperItemProvider) {
            return this.unwrap(((IWrapperItemProvider)data).getValue());
        }
        return data;
    }

    protected void hideTabs() {
        if (this.getPageCount() <= 1) {
            this.setPageText(0, "");
            if (this.getContainer() instanceof CTabFolder) {
                ((CTabFolder)this.getContainer()).setTabHeight(1);
                Point point = this.getContainer().getSize();
                this.getContainer().setSize(point.x, point.y + 6);
            }
        }
    }

    protected void showTabs() {
        if (this.getPageCount() > 1) {
            this.setPageText(0, MetaABMEditor.getString("_UI_SelectionPage_label"));
            if (this.getContainer() instanceof CTabFolder) {
                ((CTabFolder)this.getContainer()).setTabHeight(-1);
                Point point = this.getContainer().getSize();
                this.getContainer().setSize(point.x, point.y - 6);
            }
        }
    }

    protected void pageChange(int pageIndex) {
        super.pageChange(pageIndex);
        if (this.contentOutlinePage != null) {
            this.handleContentOutlineSelection(this.contentOutlinePage.getSelection());
        }
    }

    public Object getAdapter(Class key) {
        if (key.equals(IContentOutlinePage.class)) {
            return this.showOutlineView() ? this.getContentOutlinePage() : null;
        }
        if (key.equals(IPropertySheetPage.class)) {
            return this.getPropertySheetPage();
        }
        if (key.equals(IGotoMarker.class)) {
            return this;
        }
        return super.getAdapter(key);
    }

    public IContentOutlinePage getContentOutlinePage() {
        if (this.contentOutlinePage == null) {
            class MyContentOutlinePage
            extends ContentOutlinePage {
                MyContentOutlinePage() {
                }

                public void createControl(Composite parent) {
                    super.createControl(parent);
                    MetaABMEditor.this.contentOutlineViewer = this.getTreeViewer();
                    MetaABMEditor.this.contentOutlineViewer.addSelectionChangedListener((ISelectionChangedListener)this);
                    MetaABMEditor.this.contentOutlineViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)MetaABMEditor.this.adapterFactory));
                    MetaABMEditor.this.contentOutlineViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider.ColorProvider((AdapterFactory)MetaABMEditor.this.adapterFactory, (Viewer)MetaABMEditor.this.contentOutlineViewer));
                    MetaABMEditor.this.contentOutlineViewer.setInput(MetaABMEditor.this.editingDomain.getResourceSet().getResources().get(0));
                    MetaABMEditor.this.createContextMenuFor((StructuredViewer)MetaABMEditor.this.contentOutlineViewer);
                    if (!MetaABMEditor.this.editingDomain.getResourceSet().getResources().isEmpty()) {
                        MetaABMEditor.this.contentOutlineViewer.setSelection((ISelection)new StructuredSelection(MetaABMEditor.this.editingDomain.getResourceSet().getResources().get(0)), true);
                    }
                }

                public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
                    super.makeContributions(menuManager, toolBarManager, statusLineManager);
                    MetaABMEditor.this.contentOutlineStatusLineManager = statusLineManager;
                }

                public void setActionBars(IActionBars actionBars) {
                    super.setActionBars(actionBars);
                    MetaABMEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
                }
            }
            this.contentOutlinePage = new MyContentOutlinePage();
            this.contentOutlinePage.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    MetaABMEditor.this.handleContentOutlineSelection(event.getSelection());
                }
            });
        }
        return this.contentOutlinePage;
    }

    public IPropertySheetPage getPropertySheetPage() {
        if (this.propertySheetPage == null) {
            this.propertySheetPage = new ExtendedPropertySheetPage(this.editingDomain){

                public void setSelectionToViewer(List<?> selection) {
                    MetaABMEditor.this.setSelectionToViewer(selection);
                    MetaABMEditor.this.setFocus();
                }

                public void setActionBars(IActionBars actionBars) {
                    super.setActionBars(actionBars);
                    MetaABMEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
                }
            };
            this.propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
        }
        return this.propertySheetPage;
    }

    public void handleContentOutlineSelection(ISelection selection) {
        Iterator selectedElements;
        if (this.currentViewerPane != null && !selection.isEmpty() && selection instanceof IStructuredSelection && (selectedElements = ((IStructuredSelection)selection).iterator()).hasNext()) {
            Object selectedElement = selectedElements.next();
            if (this.currentViewerPane.getViewer() == this.selectionViewer) {
                ArrayList selectionList = new ArrayList();
                selectionList.add(selectedElement);
                while (selectedElements.hasNext()) {
                    selectionList.add(selectedElements.next());
                }
                this.selectionViewer.setSelection((ISelection)new StructuredSelection(selectionList));
            } else if (this.currentViewerPane.getViewer().getInput() != selectedElement) {
                this.currentViewerPane.getViewer().setInput(selectedElement);
                this.currentViewerPane.setTitle(selectedElement);
            }
        }
    }

    public boolean isDirty() {
        return ((BasicCommandStack)this.editingDomain.getCommandStack()).isSaveNeeded() || this.importFromClassAction.isRun();
    }

    public void doSave(IProgressMonitor progressMonitor) {
        final HashMap<String, Object> saveOptions = new HashMap<String, Object>();
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        saveOptions.put("CONFIGURATION_CACHE", Boolean.TRUE);
        saveOptions.put("USE_CACHED_LOOKUP_TABLE", this.lookupTable);
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                boolean first = true;
                for (Resource resource : MetaABMEditor.this.editingDomain.getResourceSet().getResources()) {
                    if (!first && resource.getContents().isEmpty() && !MetaABMEditor.this.isPersisted(resource) || MetaABMEditor.this.editingDomain.isReadOnly(resource)) continue;
                    try {
                        MetaABMEditor.this.savedResources.add(resource);
                        resource.save(saveOptions);
                    }
                    catch (Exception exception) {
                        MetaABMEditor.this.resourceToDiagnosticMap.put(resource, MetaABMEditor.this.analyzeResourceProblems(resource, exception));
                    }
                    first = false;
                }
            }
        };
        this.updateProblemIndication = false;
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(true, false, (IRunnableWithProgress)operation);
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            this.firePropertyChange(257);
        }
        catch (Exception exception) {
            MetaModelerPlugin.INSTANCE.log(exception);
        }
        this.updateProblemIndication = true;
        this.updateProblemIndication();
        this.importFromClassAction.flush();
    }

    protected boolean isPersisted(Resource resource) {
        boolean result = false;
        try {
            InputStream stream = this.editingDomain.getResourceSet().getURIConverter().createInputStream(resource.getURI());
            if (stream != null) {
                result = true;
                stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSaveAs() {
        IFile file;
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.open();
        IPath path = saveAsDialog.getResult();
        if (path != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)) != null) {
            this.doSaveAs(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true), (IEditorInput)new FileEditorInput(file));
        }
    }

    protected void doSaveAs(URI uri, IEditorInput editorInput) {
        ((Resource)this.editingDomain.getResourceSet().getResources().get(0)).setURI(uri);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        NullProgressMonitor progressMonitor = this.getActionBars().getStatusLineManager() != null ? this.getActionBars().getStatusLineManager().getProgressMonitor() : new NullProgressMonitor();
        this.doSave((IProgressMonitor)progressMonitor);
    }

    public void gotoMarker(IMarker marker) {
        try {
            if (marker.getType().equals("org.eclipse.emf.ecore.diagnostic")) {
                String uriAttribute = marker.getAttribute("uri", null);
                if (uriAttribute != null) {
                    URI uri = URI.createURI((String)uriAttribute);
                    EObject eObject = this.editingDomain.getResourceSet().getEObject(uri, true);
                    if (eObject != null) {
                        this.setSelectionForMarker(eObject);
                    }
                }
            } else if (marker.getType().equals("org.eclipse.amp.amf.gen.ide.modelproblem")) {
                String elementPath = marker.getAttribute("modelElement", null);
                URI uri = URI.createURI((String)elementPath);
                EObject eObject = this.editingDomain.getResourceSet().getEObject(uri, true);
                if (eObject != null) {
                    this.setSelectionForMarker(eObject);
                } else {
                    StatusManager.getManager().handle((IStatus)new Status(2, "org.metaabm.ide", "Couldn't locate: " + uri));
                }
            }
        }
        catch (CoreException exception) {
            MetaModelerPlugin.INSTANCE.log((Object)exception);
        }
    }

    protected void setSelectionForMarker(EObject eObject) {
        this.setSelectionToViewer(Collections.singleton(this.editingDomain.getWrapper((Object)eObject)));
    }

    public void init(IEditorSite site, IEditorInput editorInput) {
        this.setSite((IWorkbenchPartSite)site);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        site.setSelectionProvider((ISelectionProvider)this);
        site.getPage().addPartListener(this.partListener);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
    }

    public void setFocus() {
        if (this.currentViewerPane != null) {
            this.currentViewerPane.setFocus();
        } else {
            this.getControl(this.getActivePage()).setFocus();
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public ISelection getSelection() {
        return this.editorSelection;
    }

    public void setSelection(ISelection selection) {
        this.editorSelection = selection;
        for (ISelectionChangedListener listener : this.selectionChangedListeners) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
        }
        this.setStatusLineManager(selection);
    }

    public void setStatusLineManager(ISelection selection) {
        IStatusLineManager statusLineManager;
        IStatusLineManager iStatusLineManager = statusLineManager = this.currentViewer != null && this.currentViewer == this.contentOutlineViewer ? this.contentOutlineStatusLineManager : this.getActionBars().getStatusLineManager();
        if (statusLineManager != null) {
            if (selection instanceof IStructuredSelection) {
                List collection = ((IStructuredSelection)selection).toList();
                switch (collection.size()) {
                    case 0: {
                        statusLineManager.setMessage(MetaABMEditor.getString("_UI_NoObjectSelected"));
                        break;
                    }
                    case 1: {
                        String text = new AdapterFactoryItemDelegator((AdapterFactory)this.adapterFactory).getText(collection.iterator().next());
                        statusLineManager.setMessage(MetaABMEditor.getString("_UI_SingleObjectSelected", text));
                        break;
                    }
                    default: {
                        statusLineManager.setMessage(MetaABMEditor.getString("_UI_MultiObjectSelected", Integer.toString(collection.size())));
                        break;
                    }
                }
            } else {
                statusLineManager.setMessage("");
            }
        }
    }

    private static String getString(String key) {
        return MetaModelerPlugin.INSTANCE.getString(key);
    }

    private static String getString(String key, Object s1) {
        return MetaModelerPlugin.INSTANCE.getString(key, new Object[]{s1});
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        ((IMenuListener)this.getEditorSite().getActionBarContributor()).menuAboutToShow(menuManager);
    }

    public EditingDomainActionBarContributor getActionBarContributor() {
        return (EditingDomainActionBarContributor)this.getEditorSite().getActionBarContributor();
    }

    public IActionBars getActionBars() {
        return this.getActionBarContributor().getActionBars();
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public void dispose() {
        this.updateProblemIndication = false;
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        this.getSite().getPage().removePartListener(this.partListener);
        this.adapterFactory.dispose();
        if (this.getActionBarContributor().getActiveEditor() == this) {
            this.getActionBarContributor().setActiveEditor(null);
        }
        if (this.propertySheetPage != null) {
            this.propertySheetPage.dispose();
        }
        if (this.contentOutlinePage != null) {
            this.contentOutlinePage.dispose();
        }
        super.dispose();
    }

    protected boolean showOutlineView() {
        return true;
    }

    public boolean isDisplayAttributeReferences() {
        return this.displayAttributeReferences;
    }

    public void setDisplayAttributeReferences(boolean displayAttributeReferences) {
        this.displayAttributeReferences = displayAttributeReferences;
    }

    public AgentAction getImportFromClassAction() {
        return this.importFromClassAction;
    }

    public MarkerHelper getMarkerHelper() {
        return this.markerHelper;
    }

    public class ReverseAdapterFactoryContentProvider
    extends AdapterFactoryContentProvider {
        public ReverseAdapterFactoryContentProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public Object[] getElements(Object object) {
            Object parent = super.getParent(object);
            return (parent == null ? Collections.EMPTY_SET : Collections.singleton(parent)).toArray();
        }

        public Object[] getChildren(Object object) {
            Object parent = super.getParent(object);
            return (parent == null ? Collections.EMPTY_SET : Collections.singleton(parent)).toArray();
        }

        public boolean hasChildren(Object object) {
            Object parent = super.getParent(object);
            return parent != null;
        }

        public Object getParent(Object object) {
            return null;
        }
    }

    private final class TreeExpansionListener
    implements IDoubleClickListener {
        private TreeExpansionListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            ISelection selection = event.getSelection();
            if (selection instanceof IStructuredSelection) {
                Object item = ((IStructuredSelection)selection).getFirstElement();
                if (((TreeViewer)event.getViewer()).getExpandedState(item)) {
                    ((TreeViewer)event.getViewer()).collapseToLevel(item, 1);
                } else {
                    ((TreeViewer)event.getViewer()).expandToLevel(item, -1);
                }
            }
        }
    }
}

