/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.property.widgets;

import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import java.util.Date;
import org.eclipse.birt.report.designer.internal.ui.views.property.widgets.DialogInfo;
import org.eclipse.birt.report.designer.internal.ui.views.property.widgets.TimeDialogInfo;
import org.eclipse.birt.report.designer.internal.ui.views.property.widgets.TimeFormat;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class TimeLabel
extends Label {
    private long time;
    private String formatType = "yyyy-MM-dd";
    private String id = TimeZone.getDefault().getID();

    public TimeLabel(Composite parent, int style) {
        this(parent, style, "yyyy-MM-dd");
    }

    public TimeLabel(Composite parent, int style, String type) {
        super(parent, style);
        if (!TimeFormat.getDefaultFormat().getSupportList().contains(type)) {
            throw new Error("Not support this Format");
        }
        this.formatType = type;
        this.setDate(new Date(System.currentTimeMillis()));
        String text = this.getShowText(type);
        this.setText(text);
    }

    public void setDate(Date date) {
        this.setTime(date.getTime());
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
        String text = this.getShowText(this.getFormatType());
        this.setText(text);
    }

    public String getFormatType() {
        return this.formatType;
    }

    public void setFormatType(String type) {
        this.formatType = type;
        String text = this.getShowText(this.formatType);
        this.setText(text);
    }

    public boolean updateTimeForTimeZone(String oldID, String newID) {
        TimeZone oldZone = TimeZone.getTimeZone((String)oldID);
        TimeZone newZone = TimeZone.getTimeZone((String)newID);
        int oldOff = oldZone.getRawOffset();
        int newOff = newZone.getRawOffset();
        this.time += (long)(newOff - oldOff);
        String text = this.getShowText(this.getFormatType());
        this.setText(text);
        return true;
    }

    private String getShowText(String type) {
        Calendar calendar = Calendar.getInstance((TimeZone)TimeZone.getTimeZone((String)this.id));
        calendar.setTimeInMillis(this.time);
        SimpleDateFormat formatter = new SimpleDateFormat(this.formatType);
        String result = formatter.format(calendar.getTime());
        return result;
    }

    public void setTimeZoneID(String newID) {
        this.updateTimeForTimeZone(this.id, newID);
        this.id = newID;
    }

    public String getTimeZone() {
        return this.id;
    }

    public boolean setInfo(DialogInfo dialogInfo) {
        TimeDialogInfo info = (TimeDialogInfo)dialogInfo;
        if (!this.getTimeZone().equals(info.getTimeZoneID()) && info.getTimeZoneID() != null) {
            this.setTimeZoneID(info.getTimeZoneID());
        }
        if (!info.getFormat().equals(this.getFormatType())) {
            this.setFormatType(info.getFormat());
        }
        if (info.getTime() != this.getTime()) {
            this.setTime(info.getTime());
        }
        return true;
    }

    public DialogInfo getInfo() {
        TimeDialogInfo info = new TimeDialogInfo();
        info.setTime(this.getTime());
        info.setTimeZoneID(this.getTimeZone());
        info.setFormat(this.formatType);
        return info;
    }

    protected void checkSubclass() {
    }
}

