/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.editors.layout;

import java.util.Hashtable;
import java.util.List;
import org.eclipse.draw2d.AbstractHintLayout;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public class FirstCellLayout
extends AbstractHintLayout {
    private Hashtable constraints = new Hashtable();

    protected Dimension calculateMinimumSize(IFigure container, int wHint, int hHint) {
        if (wHint > -1) {
            wHint = Math.max(0, wHint - container.getInsets().getWidth());
        }
        if (hHint > -1) {
            hHint = Math.max(0, hHint - container.getInsets().getHeight());
        }
        List list = container.getChildren();
        Dimension retValue = new Dimension();
        Rectangle contraint = this.getChildContraint(container);
        int i = 0;
        while (i < list.size()) {
            Figure child = (Figure)list.get(i);
            Dimension min = child.getMinimumSize(wHint - contraint.width > 0 ? wHint - contraint.width : -1, hHint);
            retValue.width += min.width;
            retValue.height = Math.max(retValue.height, min.height);
            ++i;
        }
        retValue.width += container.getInsets().getWidth();
        retValue.height += container.getInsets().getHeight();
        return retValue;
    }

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        if (wHint > -1) {
            wHint = Math.max(0, wHint - container.getInsets().getWidth());
        }
        if (hHint > -1) {
            hHint = Math.max(0, hHint - container.getInsets().getHeight());
        }
        List list = container.getChildren();
        Dimension retValue = new Dimension();
        Rectangle contraint = this.getChildContraint(container);
        int i = 0;
        while (i < list.size()) {
            Figure child = (Figure)list.get(i);
            Dimension min = child.getPreferredSize(wHint - contraint.width > 0 ? wHint - contraint.width : -1, hHint);
            retValue.width += min.width;
            retValue.height = Math.max(retValue.height, min.height);
            ++i;
        }
        retValue.width += container.getInsets().getWidth();
        retValue.height += container.getInsets().getHeight();
        return retValue;
    }

    public void layout(IFigure container) {
        List list = container.getChildren();
        Rectangle rect = container.getClientArea();
        Rectangle contraint = this.getChildContraint(container);
        int i = 0;
        while (i < list.size()) {
            Figure child = (Figure)list.get(i);
            if (this.constraints.get(child) == null) {
                child.setBounds(new Rectangle(rect.x, rect.y, rect.width - contraint.width, rect.height));
            } else {
                child.setBounds(new Rectangle(rect.x + rect.width - contraint.width, rect.y, contraint.width, rect.height));
            }
            ++i;
        }
    }

    private Rectangle getChildContraint(IFigure figure) {
        List list = figure.getChildren();
        Rectangle contraint = new Rectangle();
        int i = 0;
        while (i < list.size()) {
            Figure child = (Figure)list.get(i);
            if (this.constraints.get(child) != null) {
                contraint = (Rectangle)this.constraints.get(child);
            }
            ++i;
        }
        return contraint;
    }

    public Object getConstraint(IFigure child) {
        return this.constraints.get(child);
    }

    public void setConstraint(IFigure figure, Object newConstraint) {
        super.setConstraint(figure, newConstraint);
        if (newConstraint != null) {
            this.constraints.put(figure, newConstraint);
        }
    }
}

