/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui.drivers;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.jar.JarFile;
import java.util.zip.ZipException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.connectivity.internal.DriverUtil;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.ExceptionHandler;
import org.eclipse.datatools.connectivity.ui.Messages;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;

public class DriverClassEditDialog
extends SelectionDialog {
    private String[] mJarList = null;
    private IStructuredContentProvider fContentProvider = new ListContentProvider(new ArrayList());
    private ILabelProvider fLabelProvider = new ListLabelProvider();
    private Object fInput;
    private TableViewer fTableViewer;
    private Button typeOption;
    private Text classNameText;
    private Button browseOption;
    private boolean fAddCancelButton = true;
    private int widthInChars = 55;
    private int heightInChars = 15;

    public DriverClassEditDialog(Shell parent) {
        super(parent);
    }

    public void setInput(Object input) {
        this.fInput = input;
    }

    public void setJarList(String[] jars) {
        this.mJarList = jars;
    }

    public void setAddCancelButton(boolean addCancelButton) {
        this.fAddCancelButton = addCancelButton;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (!this.fAddCancelButton) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        } else {
            super.createButtonsForButtonBar(parent);
        }
    }

    protected Control createDialogArea(Composite container) {
        Composite parent = (Composite)super.createDialogArea(container);
        this.createMessageArea(parent);
        this.typeOption = new Button(parent, 16);
        this.typeOption.setText(Messages.DriverClassEditDialog_Type_option_button);
        this.typeOption.setLayoutData((Object)new GridData());
        this.typeOption.setSelection(true);
        this.typeOption.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                DriverClassEditDialog.this.handleOptionSelection();
            }

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }
        });
        this.classNameText = new Text(parent, 2048);
        this.classNameText.setLayoutData((Object)new GridData(768));
        this.classNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (DriverClassEditDialog.this.classNameText.getText() != null) {
                    ArrayList<String> selected = new ArrayList<String>();
                    selected.add(DriverClassEditDialog.this.classNameText.getText().trim());
                    DriverClassEditDialog.this.setResult(selected);
                }
            }
        });
        this.browseOption = new Button(parent, 16);
        this.browseOption.setText(Messages.DriverClassEditDialog_Browse_option_button);
        this.browseOption.setLayoutData((Object)new GridData());
        this.browseOption.setSelection(false);
        this.browseOption.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                DriverClassEditDialog.this.handleOptionSelection();
            }

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }
        });
        this.fTableViewer = new TableViewer(parent, this.getTableStyle());
        this.fTableViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        if (this.fInput instanceof List) {
            this.fTableViewer.setInput(this.fInput);
        } else if (this.fInput instanceof String) {
            this.classNameText.setText((String)this.fInput);
        }
        this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (DriverClassEditDialog.this.fAddCancelButton) {
                    DriverClassEditDialog.this.okPressed();
                }
            }
        });
        List initialSelection = this.getInitialElementSelections();
        if (initialSelection != null) {
            this.fTableViewer.setSelection((ISelection)new StructuredSelection(initialSelection));
        }
        GridData gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(this.heightInChars);
        gd.widthHint = this.convertWidthInCharsToPixels(this.widthInChars);
        Table table = this.fTableViewer.getTable();
        table.setLayoutData((Object)gd);
        table.setFont(container.getFont());
        this.handleOptionSelection();
        return parent;
    }

    private void handleOptionSelection() {
        if (this.typeOption.getSelection()) {
            this.classNameText.setEnabled(true);
            this.fTableViewer.getTable().setEnabled(false);
        } else {
            this.classNameText.setEnabled(false);
            this.fTableViewer.getTable().setEnabled(true);
            this.populateClassList();
        }
    }

    private int getTableStyle() {
        return 2820;
    }

    protected void okPressed() {
        if (this.fTableViewer.getTable().getEnabled()) {
            IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
            this.setResult(selection.toList());
        } else if (this.classNameText.getEnabled() && this.classNameText.getText() != null) {
            ArrayList<String> selected = new ArrayList<String>();
            selected.add(this.classNameText.getText().trim());
            this.setResult(selected);
        }
        super.okPressed();
    }

    private ArrayList getClassList() {
        final ArrayList classes = new ArrayList();
        int i = 0;
        while (i < this.mJarList.length) {
            block10: {
                String filepath = this.mJarList[i];
                final File file = new File(filepath);
                try {
                    new JarFile(file);
                }
                catch (ZipException zipException) {
                    break block10;
                }
                catch (IOException e) {
                    String msg = e.getLocalizedMessage();
                    if (e.getLocalizedMessage() == null || e.getLocalizedMessage().trim().length() == 0) {
                        msg = ConnectivityUIPlugin.getDefault().getResourceString("PropertyDescriptor.error.msg");
                    }
                    ExceptionHandler.showException(this.getShell(), ConnectivityUIPlugin.getDefault().getResourceString("PropertyDescriptor.error.title"), msg, e);
                    return null;
                }
                ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.getShell());
                try {
                    pmd.run(true, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                String[] classStr = DriverUtil.getDriverClassesFromJar((File)file, (IProgressMonitor)monitor);
                                classes.addAll(Arrays.asList(classStr));
                            }
                            catch (Exception e1) {
                                InvocationTargetException ce = new InvocationTargetException(e1);
                                throw ce;
                            }
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    String msg = e.getLocalizedMessage();
                    if (e.getLocalizedMessage() == null || e.getLocalizedMessage().trim().length() == 0) {
                        msg = ConnectivityUIPlugin.getDefault().getResourceString("PropertyDescriptor.error.msg");
                    }
                    ExceptionHandler.showException(this.getShell(), ConnectivityUIPlugin.getDefault().getResourceString("PropertyDescriptor.error.title"), msg, e);
                    return null;
                }
                catch (InterruptedException e) {
                    String msg = e.getLocalizedMessage();
                    if (e.getLocalizedMessage() == null || e.getLocalizedMessage().trim().length() == 0) {
                        msg = ConnectivityUIPlugin.getDefault().getResourceString("PropertyDescriptor.error.msg");
                    }
                    ExceptionHandler.showException(this.getShell(), ConnectivityUIPlugin.getDefault().getResourceString("PropertyDescriptor.error.title"), msg, e);
                    return null;
                }
            }
            ++i;
        }
        return classes;
    }

    private void populateClassList() {
        ArrayList list = this.getClassList();
        if (list != null) {
            this.fContentProvider = new ListContentProvider(list);
            this.fTableViewer.setContentProvider((IContentProvider)this.fContentProvider);
            this.fTableViewer.setInput((Object)list);
            this.fTableViewer.getTable().setFocus();
            ArrayList<String> initialSelection = this.getInitialElementSelections();
            if ((initialSelection == null || initialSelection.size() == 0) && this.classNameText != null && this.classNameText.getText().trim().length() > 0) {
                initialSelection = new ArrayList<String>();
                initialSelection.add(this.classNameText.getText().trim());
            }
            if (initialSelection != null && initialSelection.size() > 0) {
                this.fTableViewer.setSelection((ISelection)new StructuredSelection(initialSelection));
                this.fTableViewer.reveal(initialSelection);
            }
        } else {
            String title = ConnectivityUIPlugin.getDefault().getResourceString("DriverClassBrowsePropertyDescriptor.noclasses.title");
            String message = ConnectivityUIPlugin.getDefault().getResourceString("DriverClassBrowsePropertyDescriptor.noclasses.msg");
            MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)message);
        }
    }

    private class ListContentProvider
    implements IStructuredContentProvider {
        private ArrayList mList = null;

        public ListContentProvider(ArrayList list) {
            this.mList = list;
        }

        public void setList(ArrayList list) {
            this.mList = list;
        }

        public Object[] getElements(Object inputElement) {
            return this.mList.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ListLabelProvider
    extends LabelProvider {
        private ListLabelProvider() {
        }

        public String getText(Object obj) {
            String name = (String)obj;
            if (name != null) {
                return name;
            }
            return name != null ? name : "";
        }

        public Image getImage(Object obj) {
            return null;
        }
    }
}

