/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.ddl;

import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.datatools.connectivity.sqm.core.definition.DataModelElementFactory;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2MaterializedQueryTable;
import org.eclipse.datatools.enablement.ibm.ddl.DdlParser;
import org.eclipse.datatools.modelbase.sql.expressions.QueryExpression;
import org.eclipse.datatools.modelbase.sql.expressions.QueryExpressionDefault;
import org.eclipse.datatools.modelbase.sql.expressions.SQLExpressionsPackage;
import org.eclipse.datatools.modelbase.sql.expressions.SearchCondition;
import org.eclipse.datatools.modelbase.sql.expressions.SearchConditionDefault;
import org.eclipse.datatools.modelbase.sql.statements.SQLStatement;
import org.eclipse.datatools.modelbase.sql.statements.SQLStatementDefault;
import org.eclipse.datatools.modelbase.sql.statements.SQLStatementsPackage;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.datatools.modelbase.sql.tables.ViewTable;
import org.eclipse.emf.common.util.EList;

public abstract class DB2DdlParser
implements DdlParser {
    protected DatabaseDefinition def = null;

    public DB2DdlParser(DatabaseDefinition def) {
        this.def = def;
    }

    public void parseView(ViewTable view, String viewText) {
        int pos;
        DataModelElementFactory factory = this.def.getDataModelElementFactory();
        String[] tokens = viewText.split("[)\\s][aA][sS][\\s(]", 2);
        String body = viewText.substring(tokens[0].length()).trim();
        body = body.replaceAll("^[)]?[aA][sS]", "");
        Pattern pattern = Pattern.compile("(.*SELECT.*)[\\s]+?WITH[\\s]+?.*CHECK[\\s]+?OPTION.*", 34);
        Matcher matcher = pattern.matcher(body);
        if (matcher.matches()) {
            body = matcher.group(1).trim();
        }
        if ((body = body.trim()).startsWith("(") && (pos = this.findMatchParenths(body)) == body.length() - 1) {
            body = body.substring(1, body.length() - 1);
        }
        QueryExpression queryExpression = (QueryExpression)factory.create(SQLExpressionsPackage.eINSTANCE.getQueryExpressionDefault());
        ((QueryExpressionDefault)queryExpression).setSQL(body);
        view.setQueryExpression(queryExpression);
    }

    public void parseTrigger(Trigger trigger, String triggerText) {
        DataModelElementFactory factory = this.def.getDataModelElementFactory();
        String body = triggerText;
        String whenClause = "";
        Pattern pattern = Pattern.compile("[\\s]*CREATE[\\s]+?TRIGGER(.*)ON(.*)[\\s]+?MODE[\\s]+?DB2SQL(.*)", 34);
        Matcher matcher = pattern.matcher(triggerText);
        if (matcher.matches()) {
            this.parseUpdateColumns(matcher.group(1).trim(), trigger);
            this.parseReferencingCluase(matcher.group(2).trim(), trigger);
            body = matcher.group(3).trim();
            int whenPos = this.parseWhenClause(body);
            if (whenPos >= 0) {
                whenClause = body.substring(body.indexOf("(") + 1, whenPos);
                body = body.substring(whenPos + 1).trim();
            }
        }
        SearchCondition searchCondition = (SearchCondition)factory.create(SQLExpressionsPackage.eINSTANCE.getSearchConditionDefault());
        trigger.setWhen(searchCondition);
        ((SearchConditionDefault)searchCondition).setSQL(whenClause);
        SQLStatement sqlbody = (SQLStatement)factory.create(SQLStatementsPackage.eINSTANCE.getSQLStatementDefault());
        ((SQLStatementDefault)sqlbody).setSQL(body);
        trigger.getActionStatement().clear();
        trigger.getActionStatement().add((Object)sqlbody);
    }

    protected int parseWhenClause(String body) {
        int pos = -1;
        Pattern pattern = Pattern.compile("[\\s]*WHEN[\\s]*?\\u0028(.*)", 34);
        Matcher matcher = pattern.matcher(body);
        if (matcher.matches()) {
            matcher.group(1);
            int matches = 0;
            int i = 0;
            while (i < body.length()) {
                if (body.charAt(i) == '(') {
                    ++matches;
                } else if (body.charAt(i) == ')' && --matches == 0) {
                    pos = i;
                    break;
                }
                ++i;
            }
        }
        return pos;
    }

    protected void parseUpdateColumns(String body, Trigger trigger) {
        Pattern pattern = Pattern.compile(".*[\\s]+?UPDATE[\\s]+?OF(.*)", 34);
        Matcher matcher = pattern.matcher(body);
        if (matcher.matches()) {
            EList columns = trigger.getTriggerColumn();
            StringTokenizer tokenizer = new StringTokenizer(matcher.group(1), ",");
            String token = "";
            while (tokenizer.hasMoreTokens()) {
                token = tokenizer.nextToken().trim().replaceAll("\"", "");
                Column column = this.getColumn(trigger.getSubjectTable(), token);
                if (column == null) continue;
                columns.add((Object)column);
            }
        }
    }

    protected void parseReferencingCluase(String body, Trigger trigger) {
        StringTokenizer tokenizer = new StringTokenizer(body, " \r\n\t");
        int previousToken = 0;
        boolean expectingNameOrASToken = false;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            if (token.equalsIgnoreCase("OLD") && previousToken != 1 && !expectingNameOrASToken) {
                previousToken = 1;
                expectingNameOrASToken = true;
                continue;
            }
            if (token.equalsIgnoreCase("NEW") && previousToken != 2 && !expectingNameOrASToken) {
                previousToken = 2;
                expectingNameOrASToken = true;
                continue;
            }
            if (token.equalsIgnoreCase("OLD_TABLE") && previousToken != 3 && !expectingNameOrASToken) {
                previousToken = 3;
                expectingNameOrASToken = true;
                continue;
            }
            if (token.equalsIgnoreCase("NEW_TABLE") && previousToken != 4 && !expectingNameOrASToken) {
                previousToken = 4;
                expectingNameOrASToken = true;
                continue;
            }
            if (token.equalsIgnoreCase("AS")) {
                expectingNameOrASToken = true;
                continue;
            }
            switch (previousToken) {
                case 1: {
                    trigger.setOldRow(token);
                    previousToken = 0;
                    break;
                }
                case 2: {
                    trigger.setNewRow(token);
                    previousToken = 0;
                    break;
                }
                case 3: {
                    trigger.setOldTable(token);
                    previousToken = 0;
                    break;
                }
                case 4: {
                    trigger.setNewTable(token);
                    previousToken = 0;
                }
            }
            expectingNameOrASToken = false;
        }
    }

    private Column getColumn(Table table, String columnName) {
        for (Column c : table.getColumns()) {
            if (!c.getName().equalsIgnoreCase(columnName)) continue;
            return c;
        }
        return null;
    }

    private int findMatchParenths(String body) {
        int pos = -1;
        int matches = 1;
        int i = 1;
        while (i < body.length()) {
            if (body.charAt(i) == '(') {
                ++matches;
            } else if (body.charAt(i) == ')' && --matches == 0) {
                pos = i;
                break;
            }
            ++i;
        }
        return pos;
    }

    public abstract DB2MaterializedQueryTable parseMQT(String var1);
}

