/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.tools;

import java.util.List;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.tools.AbstractTool;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Cursor;

public abstract class SimpleDragTracker
extends AbstractTool
implements DragTracker {
    private static final int FLAG_SOURCE_FEEDBACK = 16;
    protected static final int MAX_FLAG = 16;
    private Request sourceRequest;

    protected SimpleDragTracker() {
    }

    @Override
    protected Cursor calculateCursor() {
        if (this.isInState(19)) {
            return this.getDefaultCursor();
        }
        return super.calculateCursor();
    }

    @Override
    public void commitDrag() {
        this.eraseSourceFeedback();
        this.performDrag();
        this.setState(0x40000000);
    }

    protected Request createSourceRequest() {
        return new Request();
    }

    @Override
    public void deactivate() {
        this.eraseSourceFeedback();
        this.sourceRequest = null;
        super.deactivate();
    }

    protected void eraseSourceFeedback() {
        if (!this.isShowingFeedback()) {
            return;
        }
        this.setFlag(16, false);
        List editParts = this.getOperationSet();
        int i = 0;
        while (i < editParts.size()) {
            EditPart editPart = (EditPart)editParts.get(i);
            editPart.eraseSourceFeedback(this.getSourceRequest());
            ++i;
        }
    }

    protected Request getSourceRequest() {
        if (this.sourceRequest == null) {
            this.sourceRequest = this.createSourceRequest();
        }
        return this.sourceRequest;
    }

    @Override
    protected boolean handleButtonDown(int button) {
        if (button != 1) {
            this.setState(8);
            this.handleInvalidInput();
        } else {
            this.stateTransition(1, 2);
        }
        return true;
    }

    @Override
    protected boolean handleButtonUp(int button) {
        if (this.stateTransition(4, 0x40000000)) {
            this.eraseSourceFeedback();
            this.performDrag();
        }
        return true;
    }

    @Override
    protected boolean handleDragInProgress() {
        if (this.isInDragInProgress()) {
            this.updateSourceRequest();
            this.showSourceFeedback();
            this.setCurrentCommand(this.getCommand());
        }
        return true;
    }

    @Override
    protected boolean handleDragStarted() {
        return this.stateTransition(2, 4);
    }

    @Override
    protected boolean handleInvalidInput() {
        this.eraseSourceFeedback();
        this.setCurrentCommand(UnexecutableCommand.INSTANCE);
        return true;
    }

    @Override
    protected boolean handleKeyDown(KeyEvent e) {
        if (this.acceptArrowKey(e)) {
            this.accStepIncrement();
            if (this.stateTransition(1, 32)) {
                this.setStartLocation(this.getLocation());
            }
            switch (e.keyCode) {
                case 0x1000002: {
                    this.placeMouseInViewer(this.getLocation().getTranslated(0, this.accGetStep()));
                    break;
                }
                case 0x1000001: {
                    this.placeMouseInViewer(this.getLocation().getTranslated(0, -this.accGetStep()));
                    break;
                }
                case 0x1000004: {
                    int stepping = this.accGetStep();
                    if (this.isCurrentViewerMirrored()) {
                        stepping = -stepping;
                    }
                    this.placeMouseInViewer(this.getLocation().getTranslated(stepping, 0));
                    break;
                }
                case 0x1000003: {
                    int step = -this.accGetStep();
                    if (this.isCurrentViewerMirrored()) {
                        step = -step;
                    }
                    this.placeMouseInViewer(this.getLocation().getTranslated(step, 0));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean handleKeyUp(KeyEvent e) {
        if (this.acceptArrowKey(e)) {
            this.accStepReset();
            return true;
        }
        return false;
    }

    protected boolean isShowingFeedback() {
        return this.getFlag(16);
    }

    protected void performDrag() {
        this.executeCurrentCommand();
    }

    protected void showSourceFeedback() {
        List editParts = this.getOperationSet();
        int i = 0;
        while (i < editParts.size()) {
            EditPart editPart = (EditPart)editParts.get(i);
            editPart.showSourceFeedback(this.getSourceRequest());
            ++i;
        }
        this.setFlag(16, true);
    }

    protected void updateSourceRequest() {
        this.getSourceRequest().setType(this.getCommandName());
    }
}

