/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.wst.jsdt.internal.ui.search.SearchMessages;
import org.eclipse.wst.jsdt.internal.ui.search.SearchUtil;
import org.eclipse.wst.jsdt.ui.actions.FindReferencesAction;
import org.eclipse.wst.jsdt.ui.search.ElementQuerySpecification;
import org.eclipse.wst.jsdt.ui.search.QuerySpecification;

public class FindReferencesInWorkingSetAction
extends FindReferencesAction {
    private IWorkingSet[] fWorkingSets;

    public FindReferencesInWorkingSetAction(IWorkbenchSite site) {
        this(site, null);
    }

    public FindReferencesInWorkingSetAction(IWorkbenchSite site, IWorkingSet[] workingSets) {
        super(site);
        this.fWorkingSets = workingSets;
    }

    public FindReferencesInWorkingSetAction(JavaEditor editor) {
        this(editor, null);
    }

    public FindReferencesInWorkingSetAction(JavaEditor editor, IWorkingSet[] workingSets) {
        super(editor);
        this.fWorkingSets = workingSets;
    }

    @Override
    void init() {
        this.setText(SearchMessages.Search_FindReferencesInWorkingSetAction_label);
        this.setToolTipText(SearchMessages.Search_FindReferencesInWorkingSetAction_tooltip);
        this.setImageDescriptor(JavaPluginImages.DESC_OBJS_SEARCH_REF);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.find_references_in_working_set_action");
    }

    @Override
    QuerySpecification createQuery(IJavaScriptElement element) throws JavaScriptModelException, InterruptedException {
        JavaSearchScopeFactory factory = JavaSearchScopeFactory.getInstance();
        IWorkingSet[] workingSets = this.fWorkingSets;
        if (this.fWorkingSets == null && (workingSets = factory.queryWorkingSets()) == null) {
            return super.createQuery(element);
        }
        SearchUtil.updateLRUWorkingSets(workingSets);
        IJavaScriptSearchScope scope = factory.createJavaSearchScope(workingSets, true);
        String description = factory.getWorkingSetScopeDescription(workingSets, true);
        return new ElementQuerySpecification(element, this.getLimitTo(), scope, description);
    }
}

