/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.util.gradle;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.buildship.core.internal.util.gradle.CompatEclipseProject;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildActionExecuter;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.CancellationToken;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.IntermediateResultHandler;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.ResultHandler;
import org.gradle.tooling.TestLauncher;
import org.gradle.tooling.events.OperationType;
import org.gradle.tooling.events.ProgressListener;
import org.gradle.tooling.model.eclipse.EclipseProject;

public class CompatProjectConnection
implements ProjectConnection {
    private ProjectConnection delegate;

    public CompatProjectConnection(ProjectConnection delegate) {
        this.delegate = delegate;
    }

    public <T> T getModel(Class<T> modelType) throws GradleConnectionException, IllegalStateException {
        return (T)CompatProjectConnection.injectCompatibilityModel(this.delegate.getModel(modelType));
    }

    public <T> void getModel(Class<T> modelType, ResultHandler<? super T> handler) throws IllegalStateException {
        this.delegate.getModel(modelType, new CompatResultHandler<T>(handler));
    }

    public BuildLauncher newBuild() {
        return this.delegate.newBuild();
    }

    public TestLauncher newTestLauncher() {
        return this.delegate.newTestLauncher();
    }

    public <T> ModelBuilder<T> model(Class<T> modelType) {
        return new CompatModelBuilder(this.delegate.model(modelType));
    }

    public <T> BuildActionExecuter<T> action(BuildAction<T> buildAction) {
        return new CompatBuildActionExecuter(this.delegate.action(buildAction));
    }

    public BuildActionExecuter.Builder action() {
        return new CompatBuilder(this.delegate.action());
    }

    public void close() {
        this.delegate.close();
    }

    public void notifyDaemonsAboutChangedPaths(List<Path> changedPaths) {
        this.delegate.notifyDaemonsAboutChangedPaths(changedPaths);
    }

    private static <T> T injectCompatibilityModel(T model) {
        if (model instanceof EclipseProject) {
            return (T)new CompatEclipseProject((EclipseProject)model);
        }
        if (model instanceof Map) {
            LinkedHashMap compatModel = Maps.newLinkedHashMap();
            for (Map.Entry entry : ((Map)model).entrySet()) {
                if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof EclipseProject)) {
                    return model;
                }
                String buildPath = (String)entry.getKey();
                EclipseProject eclipseProject = (EclipseProject)entry.getValue();
                compatModel.put(buildPath, CompatProjectConnection.injectCompatibilityModel(eclipseProject));
            }
            return (T)compatModel;
        }
        return model;
    }

    private static class CompatBuildActionExecuter<T>
    implements BuildActionExecuter<T> {
        private final BuildActionExecuter<T> delegate;

        CompatBuildActionExecuter(BuildActionExecuter<T> delegate) {
            this.delegate = delegate;
        }

        public BuildActionExecuter<T> withArguments(String ... arguments) {
            this.delegate.withArguments(arguments);
            return this;
        }

        public BuildActionExecuter<T> withArguments(Iterable<String> arguments) {
            this.delegate.withArguments(arguments);
            return this;
        }

        public BuildActionExecuter<T> addArguments(String ... arguments) {
            this.delegate.addArguments(arguments);
            return this;
        }

        public BuildActionExecuter<T> addArguments(Iterable<String> arguments) {
            this.delegate.addArguments(arguments);
            return this;
        }

        public BuildActionExecuter<T> setStandardOutput(OutputStream outputStream) {
            this.delegate.setStandardOutput(outputStream);
            return this;
        }

        public BuildActionExecuter<T> setStandardError(OutputStream outputStream) {
            this.delegate.setStandardError(outputStream);
            return this;
        }

        public BuildActionExecuter<T> setColorOutput(boolean colorOutput) {
            this.delegate.setColorOutput(colorOutput);
            return this;
        }

        public BuildActionExecuter<T> setStandardInput(InputStream inputStream) {
            this.delegate.setStandardInput(inputStream);
            return this;
        }

        public BuildActionExecuter<T> addProgressListener(ProgressListener listener) {
            this.delegate.addProgressListener(listener);
            return this;
        }

        public BuildActionExecuter<T> addProgressListener(org.gradle.tooling.ProgressListener listener) {
            this.delegate.addProgressListener(listener);
            return this;
        }

        public BuildActionExecuter<T> addProgressListener(ProgressListener listener, OperationType ... operationTypes) {
            this.delegate.addProgressListener(listener, operationTypes);
            return this;
        }

        public BuildActionExecuter<T> addProgressListener(ProgressListener listener, Set<OperationType> eventTypes) {
            this.delegate.addProgressListener(listener, eventTypes);
            return this;
        }

        public BuildActionExecuter<T> setJavaHome(File javaHome) {
            this.delegate.setJavaHome(javaHome);
            return this;
        }

        public BuildActionExecuter<T> setJvmArguments(String ... jvmArguments) {
            this.delegate.setJvmArguments(jvmArguments);
            return this;
        }

        public BuildActionExecuter<T> setJvmArguments(Iterable<String> jvmArguments) {
            this.delegate.setJvmArguments(jvmArguments);
            return this;
        }

        public BuildActionExecuter<T> addJvmArguments(String ... jvmArguments) {
            this.delegate.addJvmArguments(jvmArguments);
            return this;
        }

        public BuildActionExecuter<T> addJvmArguments(Iterable<String> jvmArguments) {
            this.delegate.addJvmArguments(jvmArguments);
            return this;
        }

        public BuildActionExecuter<T> setEnvironmentVariables(Map<String, String> envVariables) {
            this.delegate.setEnvironmentVariables(envVariables);
            return this;
        }

        public BuildActionExecuter<T> forTasks(String ... tasks) {
            this.delegate.forTasks(tasks);
            return this;
        }

        public BuildActionExecuter<T> withCancellationToken(CancellationToken cancellationToken) {
            this.delegate.withCancellationToken(cancellationToken);
            return this;
        }

        public BuildActionExecuter<T> forTasks(Iterable<String> tasks) {
            this.delegate.forTasks(tasks);
            return this;
        }

        public T run() throws GradleConnectionException, IllegalStateException {
            return (T)CompatProjectConnection.injectCompatibilityModel(this.delegate.run());
        }

        public void run(ResultHandler<? super T> handler) throws IllegalStateException {
            this.delegate.run(new CompatResultHandler<T>(handler));
        }
    }

    private static class CompatBuilder
    implements BuildActionExecuter.Builder {
        private final BuildActionExecuter.Builder delegate;

        CompatBuilder(BuildActionExecuter.Builder delegate) {
            this.delegate = delegate;
        }

        public <T> BuildActionExecuter.Builder projectsLoaded(BuildAction<T> buildAction, IntermediateResultHandler<? super T> handler) throws IllegalArgumentException {
            this.delegate.projectsLoaded(buildAction, new CompatIntermediateResultHander<T>(handler));
            return this;
        }

        public <T> BuildActionExecuter.Builder buildFinished(BuildAction<T> buildAction, IntermediateResultHandler<? super T> handler) throws IllegalArgumentException {
            this.delegate.buildFinished(buildAction, new CompatIntermediateResultHander<T>(handler));
            return this;
        }

        public BuildActionExecuter<Void> build() {
            return this.delegate.build();
        }
    }

    private static class CompatIntermediateResultHander<T>
    implements IntermediateResultHandler<T> {
        private final IntermediateResultHandler<T> delegate;

        CompatIntermediateResultHander(IntermediateResultHandler<T> delegate) {
            this.delegate = delegate;
        }

        public void onComplete(T result) {
            this.delegate.onComplete(CompatProjectConnection.injectCompatibilityModel(result));
        }
    }

    private static class CompatModelBuilder<T>
    implements ModelBuilder<T> {
        private final ModelBuilder<T> delegate;

        CompatModelBuilder(ModelBuilder<T> delegate) {
            this.delegate = delegate;
        }

        public ModelBuilder<T> withArguments(String ... arguments) {
            this.delegate.withArguments(arguments);
            return this;
        }

        public ModelBuilder<T> withArguments(Iterable<String> arguments) {
            this.delegate.withArguments(arguments);
            return this;
        }

        public ModelBuilder<T> addArguments(String ... arguments) {
            this.delegate.addArguments(arguments);
            return this;
        }

        public ModelBuilder<T> addArguments(Iterable<String> arguments) {
            this.delegate.addArguments(arguments);
            return this;
        }

        public ModelBuilder<T> setStandardOutput(OutputStream outputStream) {
            this.delegate.setStandardOutput(outputStream);
            return this;
        }

        public ModelBuilder<T> setStandardError(OutputStream outputStream) {
            this.delegate.setStandardError(outputStream);
            return this;
        }

        public ModelBuilder<T> setColorOutput(boolean colorOutput) {
            this.delegate.setColorOutput(colorOutput);
            return this;
        }

        public ModelBuilder<T> setStandardInput(InputStream inputStream) {
            this.delegate.setStandardInput(inputStream);
            return this;
        }

        public ModelBuilder<T> setJavaHome(File javaHome) {
            this.delegate.setJavaHome(javaHome);
            return this;
        }

        public ModelBuilder<T> setJvmArguments(String ... jvmArguments) {
            this.delegate.setJvmArguments(jvmArguments);
            return this;
        }

        public ModelBuilder<T> forTasks(String ... tasks) {
            this.delegate.forTasks(tasks);
            return this;
        }

        public ModelBuilder<T> setJvmArguments(Iterable<String> jvmArguments) {
            this.delegate.setJvmArguments(jvmArguments);
            return this;
        }

        public ModelBuilder<T> addJvmArguments(String ... jvmArguments) {
            this.delegate.addJvmArguments(jvmArguments);
            return this;
        }

        public ModelBuilder<T> addJvmArguments(Iterable<String> jvmArguments) {
            this.delegate.addJvmArguments(jvmArguments);
            return this;
        }

        public ModelBuilder<T> setEnvironmentVariables(Map<String, String> envVariables) {
            this.delegate.setEnvironmentVariables(envVariables);
            return this;
        }

        public ModelBuilder<T> forTasks(Iterable<String> tasks) {
            this.delegate.forTasks(tasks);
            return this;
        }

        public ModelBuilder<T> addProgressListener(org.gradle.tooling.ProgressListener listener) {
            this.delegate.addProgressListener(listener);
            return this;
        }

        public ModelBuilder<T> addProgressListener(ProgressListener listener, Set<OperationType> eventTypes) {
            this.delegate.addProgressListener(listener, eventTypes);
            return this;
        }

        public ModelBuilder<T> addProgressListener(ProgressListener listener) {
            this.delegate.addProgressListener(listener);
            return this;
        }

        public ModelBuilder<T> addProgressListener(ProgressListener listener, OperationType ... operationTypes) {
            this.delegate.addProgressListener(listener, operationTypes);
            return this;
        }

        public ModelBuilder<T> withCancellationToken(CancellationToken cancellationToken) {
            this.delegate.withCancellationToken(cancellationToken);
            return this;
        }

        public T get() throws GradleConnectionException, IllegalStateException {
            return (T)CompatProjectConnection.injectCompatibilityModel(this.delegate.get());
        }

        public void get(ResultHandler<? super T> handler) throws IllegalStateException {
            this.delegate.get(new CompatResultHandler<T>(handler));
        }
    }

    private static class CompatResultHandler<T>
    implements ResultHandler<T> {
        private final ResultHandler<T> delegate;

        public CompatResultHandler(ResultHandler<T> delegate) {
            this.delegate = delegate;
        }

        public void onComplete(T result) {
            this.delegate.onComplete(CompatProjectConnection.injectCompatibilityModel(result));
        }

        public void onFailure(GradleConnectionException failure) {
            this.delegate.onFailure(failure);
        }
    }
}

