/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.util.file;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.File;
import org.eclipse.buildship.core.util.string.StringUtils;
import org.eclipse.buildship.ui.i18n.UiMessages;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public final class DirectoryDialogSelectionListener
extends SelectionAdapter {
    private final Shell shell;
    private final ISWTObservableValue target;
    private final String title;

    public DirectoryDialogSelectionListener(Shell shell, Widget target, String entity) {
        this.shell = (Shell)Preconditions.checkNotNull((Object)shell);
        this.target = WidgetProperties.text().observe(target);
        this.title = NLS.bind((String)UiMessages.Title_Select_0, (Object)entity);
    }

    public void widgetSelected(SelectionEvent e) {
        File startLocation;
        DirectoryDialog directoryDialog = new DirectoryDialog(this.shell, 0x10000000);
        directoryDialog.setText(this.title);
        String text = StringUtils.valueOf((Object)this.target.getValue());
        File file = startLocation = Strings.isNullOrEmpty((String)text) ? null : new File(text.trim()).getAbsoluteFile();
        if (startLocation != null && startLocation.exists() && startLocation.isFile()) {
            directoryDialog.setFilterPath(startLocation.getParentFile().getAbsolutePath());
        } else if (startLocation != null && startLocation.exists() && startLocation.isDirectory()) {
            directoryDialog.setFilterPath(startLocation.getAbsolutePath());
        } else {
            String userHomeDir = System.getProperty("user.home");
            directoryDialog.setFilterPath(userHomeDir);
        }
        String selectedDirectory = directoryDialog.open();
        if (selectedDirectory != null) {
            this.target.setValue((Object)selectedDirectory);
        }
    }
}

