/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.view.execution;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.TreeTraverser;
import com.gradleware.tooling.toolingclient.Request;
import java.util.List;
import java.util.Map;
import org.eclipse.buildship.core.console.ProcessDescription;
import org.eclipse.buildship.ui.external.viewer.FilteredTree;
import org.eclipse.buildship.ui.external.viewer.PatternFilter;
import org.eclipse.buildship.ui.util.color.ColorUtils;
import org.eclipse.buildship.ui.util.nodeselection.ActionShowingContextMenuListener;
import org.eclipse.buildship.ui.util.nodeselection.NodeSelection;
import org.eclipse.buildship.ui.util.nodeselection.NodeSelectionProvider;
import org.eclipse.buildship.ui.util.nodeselection.SelectionHistoryManager;
import org.eclipse.buildship.ui.util.nodeselection.SelectionSpecificAction;
import org.eclipse.buildship.ui.view.BasePage;
import org.eclipse.buildship.ui.view.CollapseTreeNodesAction;
import org.eclipse.buildship.ui.view.ExpandTreeNodesAction;
import org.eclipse.buildship.ui.view.ObservableMapCellWithIconLabelProvider;
import org.eclipse.buildship.ui.view.PageSite;
import org.eclipse.buildship.ui.view.ShowFilterAction;
import org.eclipse.buildship.ui.view.execution.CancelBuildExecutionAction;
import org.eclipse.buildship.ui.view.execution.ExecutionProgressListener;
import org.eclipse.buildship.ui.view.execution.ExecutionViewMessages;
import org.eclipse.buildship.ui.view.execution.ExecutionViewState;
import org.eclipse.buildship.ui.view.execution.ExecutionsView;
import org.eclipse.buildship.ui.view.execution.OpenTestSourceFileAction;
import org.eclipse.buildship.ui.view.execution.OperationItem;
import org.eclipse.buildship.ui.view.execution.OperationItemChildrenListProperty;
import org.eclipse.buildship.ui.view.execution.RemoveAllTerminatedExecutionPagesAction;
import org.eclipse.buildship.ui.view.execution.RemoveTerminatedExecutionPageAction;
import org.eclipse.buildship.ui.view.execution.RerunBuildExecutionAction;
import org.eclipse.buildship.ui.view.execution.RerunFailedTestsAction;
import org.eclipse.buildship.ui.view.execution.RunTestAction;
import org.eclipse.buildship.ui.view.execution.ShowFailureAction;
import org.eclipse.buildship.ui.view.execution.SwitchToConsoleViewAction;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.IBeanValueProperty;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.databinding.viewers.ObservableListTreeContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapCellLabelProvider;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;
import org.gradle.tooling.events.ProgressListener;

public final class ExecutionPage
extends BasePage<FilteredTree>
implements NodeSelectionProvider {
    private final ProcessDescription processDescription;
    private final Request<Void> request;
    private final ExecutionViewState state;
    private SelectionHistoryManager selectionHistoryManager;
    private TreeViewerColumn nameColumn;
    private TreeViewerColumn durationColumn;

    public ExecutionPage(ProcessDescription processDescription, Request<Void> request, ExecutionViewState state) {
        this.processDescription = processDescription;
        this.request = request;
        this.state = state;
    }

    public ProcessDescription getProcessDescription() {
        return this.processDescription;
    }

    @Override
    public String getDisplayName() {
        return this.processDescription.getName();
    }

    @Override
    public FilteredTree createPageWithResult(Composite parent) {
        FilteredTree filteredTree = new FilteredTree(parent, 770, new PatternFilter(true));
        filteredTree.setShowFilterControls(false);
        filteredTree.getViewer().getTree().setHeaderVisible(this.state.isShowTreeHeader());
        this.nameColumn = new TreeViewerColumn(filteredTree.getViewer(), 0);
        this.nameColumn.getColumn().setText(ExecutionViewMessages.Tree_Column_Operation_Name_Text);
        this.nameColumn.getColumn().setWidth(this.state.getHeaderNameColumnWidth());
        this.durationColumn = new TreeViewerColumn(filteredTree.getViewer(), 131072);
        this.durationColumn.getColumn().setText(ExecutionViewMessages.Tree_Column_Operation_Duration_Text);
        this.durationColumn.getColumn().setWidth(this.state.getHeaderDurationColumnWidth());
        OperationItemChildrenListProperty childrenProperty = new OperationItemChildrenListProperty();
        ObservableListTreeContentProvider contentProvider = new ObservableListTreeContentProvider(childrenProperty.listFactory(), null);
        filteredTree.getViewer().setContentProvider((IContentProvider)contentProvider);
        IObservableSet knownElements = contentProvider.getKnownElements();
        this.attachLabelProvider("name", "image", knownElements, (ViewerColumn)this.nameColumn);
        this.attachLabelProvider("duration", null, knownElements, (ViewerColumn)this.durationColumn);
        this.nameColumn.getColumn().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int newWidth = ExecutionPage.this.nameColumn.getColumn().getWidth();
                ExecutionPage.this.state.setHeaderNameColumnWidth(newWidth);
                ExecutionsView view = (ExecutionsView)ExecutionPage.this.getSite().getViewSite().getPart();
                for (ExecutionPage page : FluentIterable.from(view.getPages()).filter(ExecutionPage.class)) {
                    TreeColumn column;
                    int columnWidth;
                    if (page == ExecutionPage.this || (columnWidth = (column = page.nameColumn.getColumn()).getWidth()) == newWidth) continue;
                    column.setWidth(newWidth);
                }
            }
        });
        this.durationColumn.getColumn().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int newWidth = ExecutionPage.this.durationColumn.getColumn().getWidth();
                ExecutionPage.this.state.setHeaderDurationColumnWidth(newWidth);
                ExecutionsView view = (ExecutionsView)ExecutionPage.this.getSite().getViewSite().getPart();
                for (ExecutionPage page : FluentIterable.from(view.getPages()).filter(ExecutionPage.class)) {
                    TreeColumn column;
                    int columnWidth;
                    if (page == ExecutionPage.this || (columnWidth = (column = page.durationColumn.getColumn()).getWidth()) == newWidth) continue;
                    column.setWidth(newWidth);
                }
            }
        });
        this.selectionHistoryManager = new SelectionHistoryManager(filteredTree.getViewer());
        OperationItem root = new OperationItem();
        filteredTree.getViewer().setInput((Object)root);
        this.request.addTypedProgressListeners(new ProgressListener[]{new ExecutionProgressListener(this, root)});
        return filteredTree;
    }

    private void attachLabelProvider(String textProperty, String imageProperty, IObservableSet knownElements, ViewerColumn viewerColumn) {
        IBeanValueProperty txtProperty = BeanProperties.value((String)textProperty);
        if (imageProperty != null) {
            IBeanValueProperty imgProperty = BeanProperties.value((String)imageProperty);
            ObservableMapCellWithIconLabelProvider labelProvider = new ObservableMapCellWithIconLabelProvider(this.getCustomTextColoringMapping(), txtProperty.observeDetail(knownElements), imgProperty.observeDetail(knownElements));
            viewerColumn.setLabelProvider((CellLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)labelProvider));
        } else {
            ObservableMapCellLabelProvider labelProvider = new ObservableMapCellLabelProvider(txtProperty.observeDetail(knownElements));
            viewerColumn.setLabelProvider((CellLabelProvider)labelProvider);
        }
    }

    private Map<String, ColorDescriptor> getCustomTextColoringMapping() {
        ColorDescriptor decorationsColor = ColorUtils.getDecorationsColorDescriptorFromCurrentTheme();
        return ImmutableMap.of((Object)"UP-TO-DATE", (Object)decorationsColor, (Object)"FROM-CACHE", (Object)decorationsColor);
    }

    @Override
    public void init(PageSite pageSite) {
        super.init(pageSite);
        this.populateToolBar();
        this.registerContextMenu(pageSite);
        this.registerListeners();
    }

    private void populateToolBar() {
        IActionBars actionBars = this.getSite().getActionBars();
        IToolBarManager toolbarManager = actionBars.getToolBarManager();
        toolbarManager.appendToGroup("pageGroup", (IAction)new ExpandTreeNodesAction((AbstractTreeViewer)((FilteredTree)((Object)this.getPageControl())).getViewer()));
        toolbarManager.appendToGroup("pageGroup", (IAction)new CollapseTreeNodesAction((AbstractTreeViewer)((FilteredTree)((Object)this.getPageControl())).getViewer()));
        toolbarManager.appendToGroup("pageGroup", (IAction)new ShowFilterAction((FilteredTree)((Object)this.getPageControl())));
        toolbarManager.appendToGroup("pageGroup", (IContributionItem)new Separator());
        toolbarManager.appendToGroup("pageGroup", (IAction)new SwitchToConsoleViewAction(this));
        toolbarManager.appendToGroup("pageGroup", (IContributionItem)new Separator());
        toolbarManager.appendToGroup("pageGroup", (IAction)new RerunFailedTestsAction(this));
        toolbarManager.appendToGroup("pageGroup", (IContributionItem)new Separator());
        toolbarManager.appendToGroup("pageGroup", (IAction)new CancelBuildExecutionAction(this));
        toolbarManager.appendToGroup("pageGroup", (IAction)new RerunBuildExecutionAction(this));
        toolbarManager.appendToGroup("pageGroup", (IAction)new RemoveTerminatedExecutionPageAction(this));
        toolbarManager.appendToGroup("pageGroup", (IAction)new RemoveAllTerminatedExecutionPagesAction(this));
        toolbarManager.update(true);
    }

    private void registerContextMenu(PageSite pageSite) {
        TreeViewer treeViewer = ((FilteredTree)((Object)this.getPageControl())).getViewer();
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)this.createContextMenuListener(treeViewer));
        Menu contextMenu = menuManager.createContextMenu((Control)treeViewer.getTree());
        treeViewer.getTree().setMenu(contextMenu);
        pageSite.getViewSite().registerContextMenu(menuManager, (ISelectionProvider)treeViewer);
    }

    private ActionShowingContextMenuListener createContextMenuListener(TreeViewer treeViewer) {
        RunTestAction runTestAction = new RunTestAction(this);
        ShowFailureAction showFailureAction = new ShowFailureAction(this);
        OpenTestSourceFileAction openTestSourceFileAction = new OpenTestSourceFileAction(this);
        ExpandTreeNodesAction expandNodesAction = new ExpandTreeNodesAction((AbstractTreeViewer)treeViewer);
        CollapseTreeNodesAction collapseNodesAction = new CollapseTreeNodesAction((AbstractTreeViewer)treeViewer);
        ImmutableList contextMenuActions = ImmutableList.of((Object)runTestAction, (Object)showFailureAction, (Object)openTestSourceFileAction, (Object)expandNodesAction, (Object)collapseNodesAction);
        ImmutableList contextMenuActionsPrecededBySeparator = ImmutableList.of((Object)openTestSourceFileAction, (Object)expandNodesAction);
        ImmutableList contextMenuActionsSucceededBySeparator = ImmutableList.of();
        return new ActionShowingContextMenuListener(this, (List<? extends SelectionSpecificAction>)contextMenuActions, (List<? extends SelectionSpecificAction>)contextMenuActionsPrecededBySeparator, (List<? extends SelectionSpecificAction>)contextMenuActionsSucceededBySeparator);
    }

    private void registerListeners() {
        ((FilteredTree)((Object)this.getPageControl())).getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                OpenTestSourceFileAction openTestSourceFileAction = new OpenTestSourceFileAction(ExecutionPage.this);
                openTestSourceFileAction.run();
            }
        });
    }

    public FluentIterable<OperationItem> filterTreeNodes(Predicate<OperationItem> predicate) {
        OperationItem root = (OperationItem)((FilteredTree)((Object)this.getPageControl())).getViewer().getInput();
        if (root == null) {
            return FluentIterable.from((Iterable)ImmutableList.of());
        }
        return new TreeTraverser<OperationItem>(){

            public Iterable<OperationItem> children(OperationItem operationItem) {
                return operationItem.getChildren();
            }
        }.breadthFirstTraversal((Object)root).filter(predicate);
    }

    public Object getAdapter(Class adapter) {
        if (FilteredTree.class.equals((Object)adapter)) {
            return this.getPageControl();
        }
        if (adapter.isAssignableFrom(TreeViewer.class)) {
            return ((FilteredTree)((Object)this.getPageControl())).getViewer();
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    @Override
    public boolean isCloseable() {
        return this.processDescription.getJob().getState() == 0;
    }

    @Override
    public NodeSelection getSelection() {
        return this.selectionHistoryManager.getSelectionHistory();
    }

    @Override
    public void dispose() {
        if (this.selectionHistoryManager != null) {
            this.selectionHistoryManager.dispose();
        }
        super.dispose();
    }
}

