/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.gradle.api.GradleException;
import org.gradle.api.UncheckedIOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtils {
    public static final int WINDOWS_PATH_LIMIT = 260;

    public static String toSafeFileName(String name) {
        int size = name.length();
        StringBuffer rc = new StringBuffer(size * 2);
        for (int i = 0; i < size; ++i) {
            char c = name.charAt(i);
            boolean valid = c >= 'a' && c <= 'z';
            valid = valid || c >= 'A' && c <= 'Z';
            valid = valid || c >= '0' && c <= '9';
            boolean bl = valid = valid || c == '_' || c == '-' || c == '.' || c == '$';
            if (valid) {
                rc.append(c);
                continue;
            }
            rc.append('#');
            rc.append(Integer.toHexString(c));
        }
        return rc.toString();
    }

    public static File assertInWindowsPathLengthLimitation(File file) {
        if (file.getAbsolutePath().length() > 260) {
            throw new GradleException(String.format("Cannot create file. '%s' exceeds windows path limitation of %d character.", file.getAbsolutePath(), 260));
        }
        return file;
    }

    public static Collection<? extends File> calculateRoots(Iterable<? extends File> files) {
        LinkedList<File> roots = new LinkedList<File>();
        block0: for (File file : files) {
            File absoluteFile = file.getAbsoluteFile();
            String path = absoluteFile + File.separator;
            Iterator rootsIterator = roots.iterator();
            while (rootsIterator.hasNext()) {
                File root = (File)rootsIterator.next();
                String rootPath = root.getPath() + File.separator;
                if (path.startsWith(rootPath)) continue block0;
                if (!rootPath.startsWith(path)) continue;
                rootsIterator.remove();
            }
            roots.add(absoluteFile);
        }
        return roots;
    }

    public static boolean hasExtension(File file, String extension) {
        return file.getPath().endsWith(extension);
    }

    public static File canonicalize(File src) {
        try {
            return src.getCanonicalFile();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

