/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.gradleware.tooling.toolingmodel.repository.TransientRequestAttributes;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.configuration.GradleArguments;
import org.eclipse.buildship.core.workspace.internal.CompositeModelQuery;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildActionExecuter;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.LongRunningOperation;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ProgressListener;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.ResultHandler;
import org.gradle.tooling.TestLauncher;
import org.gradle.tooling.model.build.BuildEnvironment;

final class ConnectionAwareLauncherProxy
implements InvocationHandler {
    private final LongRunningOperation launcher;
    private final ProjectConnection connection;
    private static URLClassLoader ideFriendlyCustomActionClassLoader;

    private ConnectionAwareLauncherProxy(ProjectConnection connection, LongRunningOperation target) {
        this.connection = connection;
        this.launcher = target;
    }

    static <T> ModelBuilder<T> newModelBuilder(Class<T> model, GradleArguments gradleArguments, TransientRequestAttributes transientAttributes) {
        ProjectConnection connection = ConnectionAwareLauncherProxy.openConnection(gradleArguments);
        ModelBuilder builder = connection.model(model);
        BuildEnvironment buildEnvironment = (BuildEnvironment)connection.getModel(BuildEnvironment.class);
        ConnectionAwareLauncherProxy.applyConfiguration((LongRunningOperation)builder, gradleArguments, buildEnvironment, transientAttributes);
        return (ModelBuilder)ConnectionAwareLauncherProxy.newProxyInstance(connection, (LongRunningOperation)builder);
    }

    static <T> BuildActionExecuter<Collection<T>> newCompositeModelQueryExecuter(Class<T> model, GradleArguments gradleArguments, TransientRequestAttributes transientAttributes) {
        ProjectConnection connection = ConnectionAwareLauncherProxy.openConnection(gradleArguments);
        BuildEnvironment buildEnvironment = (BuildEnvironment)connection.getModel(BuildEnvironment.class);
        BuildActionExecuter executer = connection.action(ConnectionAwareLauncherProxy.compositeModelQuery(model));
        ConnectionAwareLauncherProxy.applyConfiguration((LongRunningOperation)executer, gradleArguments, buildEnvironment, transientAttributes);
        return (BuildActionExecuter)ConnectionAwareLauncherProxy.newProxyInstance(connection, (LongRunningOperation)executer);
    }

    static BuildLauncher newBuildLauncher(GradleArguments gradleArguments, Writer configWriter, TransientRequestAttributes transientAttributes) {
        ProjectConnection connection = ConnectionAwareLauncherProxy.openConnection(gradleArguments);
        BuildEnvironment buildEnvironment = (BuildEnvironment)connection.getModel(BuildEnvironment.class);
        BuildLauncher launcher = connection.newBuild();
        ConnectionAwareLauncherProxy.applyConfiguration((LongRunningOperation)launcher, gradleArguments, buildEnvironment, configWriter, transientAttributes);
        return (BuildLauncher)ConnectionAwareLauncherProxy.newProxyInstance(connection, (LongRunningOperation)launcher);
    }

    static TestLauncher newTestLauncher(GradleArguments gradleArguments, Writer configWriter, TransientRequestAttributes transientAttributes) {
        ProjectConnection connection = ConnectionAwareLauncherProxy.openConnection(gradleArguments);
        BuildEnvironment buildEnvironment = (BuildEnvironment)connection.getModel(BuildEnvironment.class);
        TestLauncher launcher = connection.newTestLauncher();
        ConnectionAwareLauncherProxy.applyConfiguration((LongRunningOperation)launcher, gradleArguments, buildEnvironment, configWriter, transientAttributes);
        return (TestLauncher)ConnectionAwareLauncherProxy.newProxyInstance(connection, (LongRunningOperation)launcher);
    }

    private static ProjectConnection openConnection(GradleArguments gradleArguments) {
        GradleConnector connector = GradleConnector.newConnector();
        gradleArguments.applyTo(connector);
        return connector.connect();
    }

    private static void applyConfiguration(LongRunningOperation operation, GradleArguments gradleArguments, BuildEnvironment buildEnvironment, TransientRequestAttributes transientAttributes) {
        gradleArguments.applyTo(operation, buildEnvironment);
        ConnectionAwareLauncherProxy.applyTransientAttributes(operation, transientAttributes);
    }

    private static void applyConfiguration(LongRunningOperation operation, GradleArguments gradleArguments, BuildEnvironment buildEnvironment, Writer configWriter, TransientRequestAttributes transientAttributes) {
        gradleArguments.applyTo(operation, buildEnvironment);
        gradleArguments.describe(configWriter, buildEnvironment);
        ConnectionAwareLauncherProxy.applyTransientAttributes(operation, transientAttributes);
    }

    private static void applyTransientAttributes(LongRunningOperation operation, TransientRequestAttributes transientAttributes) {
        operation.setStandardOutput(transientAttributes.getStandardOutput());
        operation.setStandardError(transientAttributes.getStandardError());
        operation.setStandardInput(transientAttributes.getStandardInput());
        for (ProgressListener listener : transientAttributes.getProgressListeners()) {
            operation.addProgressListener(listener);
        }
        operation.withCancellationToken(transientAttributes.getCancellationToken());
    }

    private static <T> BuildAction<Collection<T>> compositeModelQuery(Class<T> model) {
        if (Platform.inDevelopmentMode()) {
            return ConnectionAwareLauncherProxy.ideFriendlyCompositeModelQuery(model);
        }
        return new CompositeModelQuery<T>(model);
    }

    private static <T> BuildAction<Collection<T>> ideFriendlyCompositeModelQuery(Class<T> model) {
        try {
            ClassLoader coreClassloader = ConnectionAwareLauncherProxy.class.getClassLoader();
            ClassLoader tapiClassloader = ProjectConnection.class.getClassLoader();
            URL actionRootUrl = FileLocator.resolve((URL)coreClassloader.getResource(""));
            ideFriendlyCustomActionClassLoader = new URLClassLoader(new URL[]{actionRootUrl}, tapiClassloader);
            Class<?> actionClass = ideFriendlyCustomActionClassLoader.loadClass(CompositeModelQuery.class.getName());
            return (BuildAction)actionClass.getConstructor(Class.class).newInstance(model);
        }
        catch (Exception e) {
            throw new GradlePluginsRuntimeException(e);
        }
    }

    private static Object newProxyInstance(ProjectConnection connection, LongRunningOperation launcher) {
        return Proxy.newProxyInstance(launcher.getClass().getClassLoader(), launcher.getClass().getInterfaces(), (InvocationHandler)new ConnectionAwareLauncherProxy(connection, launcher));
    }

    @Override
    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        if (m.getName().equals("run") || m.getName().equals("get")) {
            if (args == null) {
                return this.invokeRun(m);
            }
            if (args.length == 1 && args[0].getClass() == ResultHandler.class) {
                return this.invokeRun(m, args[0]);
            }
        }
        return this.invokeOther(m, args);
    }

    private Object invokeRun(Method m) throws Throwable {
        try {
            Object object = m.invoke((Object)this.launcher, new Object[0]);
            return object;
        }
        catch (InvocationTargetException e) {
            if (e.getCause() != null) {
                throw e.getCause();
            }
            throw e;
        }
        finally {
            this.closeConnection();
        }
    }

    private Object invokeRun(Method m, Object resultHandler) throws Throwable {
        final ResultHandler handler = (ResultHandler)resultHandler;
        return m.invoke((Object)this.launcher, new ResultHandler<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onComplete(Object result) {
                try {
                    handler.onComplete(result);
                }
                finally {
                    ConnectionAwareLauncherProxy.this.closeConnection();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onFailure(GradleConnectionException e) {
                try {
                    handler.onFailure(e);
                }
                finally {
                    ConnectionAwareLauncherProxy.this.closeConnection();
                }
            }
        });
    }

    private void closeConnection() {
        this.connection.close();
        if (ideFriendlyCustomActionClassLoader != null) {
            try {
                ideFriendlyCustomActionClassLoader.close();
            }
            catch (IOException e) {
                CorePlugin.logger().error("Can't close URL class loader", e);
            }
        }
    }

    private Object invokeOther(Method m, Object[] args) throws Throwable {
        return m.invoke((Object)this.launcher, args);
    }
}

