/*
 * Decompiled with CFR 0.152.
 */
package com.gradleware.tooling.toolingmodel.repository.internal;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.gradleware.tooling.toolingmodel.HierarchicalModel;
import java.util.Comparator;
import java.util.List;
import org.gradle.api.specs.Spec;

final class HierarchyHelper<T extends HierarchicalModel<T>> {
    private final T current;
    private T parent;
    private final List<T> children;
    private final Comparator<? super T> comparator;

    HierarchyHelper(T current, Comparator<? super T> comparator) {
        this.current = current;
        this.children = Lists.newArrayList();
        this.comparator = (Comparator)Preconditions.checkNotNull(comparator);
    }

    public T getRoot() {
        T root = this.current;
        while (root.getParent() != null) {
            root = root.getParent();
        }
        return root;
    }

    T getParent() {
        return this.parent;
    }

    void setParent(T parent) {
        this.parent = parent;
    }

    ImmutableList<T> getChildren() {
        return this.sort(this.children);
    }

    void addChild(T child) {
        this.children.add(child);
    }

    ImmutableList<T> getAll() {
        ImmutableList.Builder all = ImmutableList.builder();
        this.addRecursively(this.current, all);
        return this.sort((List)all.build());
    }

    private void addRecursively(T node, ImmutableList.Builder<T> nodes) {
        nodes.add(node);
        for (HierarchicalModel child : node.getChildren()) {
            this.addRecursively(child, nodes);
        }
    }

    private <E extends T> ImmutableList<E> sort(List<E> elements) {
        return Ordering.from(this.comparator).immutableSortedCopy(elements);
    }

    ImmutableList<T> filter(Spec<? super T> predicate) {
        return FluentIterable.from(this.getAll()).filter(HierarchyHelper.toPredicate(predicate)).toList();
    }

    Optional<T> tryFind(Spec<? super T> predicate) {
        return Iterables.tryFind(this.getAll(), HierarchyHelper.toPredicate(predicate));
    }

    private static <T> Predicate<? super T> toPredicate(final Spec<? super T> spec) {
        return new Predicate<T>(){

            public boolean apply(T input) {
                return spec.isSatisfiedBy(input);
            }
        };
    }
}

