/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.mass.design.service.massListener;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.SessionManagerListener;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalComponentPkg;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.vp.mass.design.service.massListener.MassChangePreCommitListener;
import org.polarsys.capella.vp.mass.design.service.massSwitch.TopDownComputeMassPaSwitch;

public class MassSessionListener
implements SessionManagerListener {
    Map<Session, MassChangePreCommitListener> sessionsMassPreCommitListener = new HashMap<Session, MassChangePreCommitListener>();

    public void notifyAddSession(Session newSession) {
        Collection viewpoints = newSession.getSelectedViewpoints(false);
        boolean viewpointSelected = false;
        for (Viewpoint viewpoint : viewpoints) {
            if (!viewpoint.getName().equals("Mass_ID")) continue;
            viewpointSelected = true;
        }
        if (!viewpointSelected) {
            return;
        }
        MassChangePreCommitListener massListener = new MassChangePreCommitListener();
        newSession.getTransactionalEditingDomain().addResourceSetListener((ResourceSetListener)massListener);
        this.registerPreCommitListener(newSession, massListener);
        this.computeMass(newSession);
    }

    public void notifyRemoveSession(Session removedSession) {
    }

    public void viewpointSelected(Viewpoint selectedSirius) {
        if (!selectedSirius.getName().equals("Mass_ID")) {
            return;
        }
        Collection sessions = SessionManager.INSTANCE.getSessions();
        for (Session session : sessions) {
            MassChangePreCommitListener massListener = new MassChangePreCommitListener();
            TransactionalEditingDomain transDomain = session.getTransactionalEditingDomain();
            if (transDomain == null) continue;
            transDomain.addResourceSetListener((ResourceSetListener)massListener);
            this.registerPreCommitListener(session, massListener);
            this.computeMass(session);
        }
    }

    public void viewpointDeselected(Viewpoint deselectedSirius) {
        if (!deselectedSirius.getName().equals("Mass_ID")) {
            return;
        }
        Set<Map.Entry<Session, MassChangePreCommitListener>> setSessionsMassPreCommitListener = this.sessionsMassPreCommitListener.entrySet();
        for (Map.Entry<Session, MassChangePreCommitListener> e : setSessionsMassPreCommitListener) {
            TransactionalEditingDomain transDomain = e.getKey().getTransactionalEditingDomain();
            if (transDomain == null) continue;
            transDomain.removeResourceSetListener((ResourceSetListener)e.getValue());
        }
    }

    public void notify(Session updated, int notification) {
    }

    public void registerPreCommitListener(Session session, MassChangePreCommitListener preCommit) {
        this.sessionsMassPreCommitListener.put(session, preCommit);
    }

    public void computeMass(final Session session) {
        TransactionalEditingDomain domain = session.getTransactionalEditingDomain();
        domain.getCommandStack().execute((Command)new RecordingCommand(domain){

            protected void doExecute() {
                TopDownComputeMassPaSwitch topDownSwitch = new TopDownComputeMassPaSwitch();
                List<PhysicalComponentPkg> physicalComponentPkgs = MassSessionListener.this.retrievesPhysicalComponentPkgFromSession(session);
                for (PhysicalComponentPkg physicalComponentPkg : physicalComponentPkgs) {
                    topDownSwitch.doSwitch((EObject)physicalComponentPkg);
                }
            }
        });
    }

    private List<PhysicalComponentPkg> retrievesPhysicalComponentPkgFromSession(Session session) {
        Collection resources = session.getSemanticResources();
        ArrayList<PhysicalComponentPkg> physicalComponentPkg = new ArrayList<PhysicalComponentPkg>();
        resources.stream().filter(CapellaResourceHelper::isCapellaResource).forEach(resource -> resource.getContents().stream().filter(Project.class::isInstance).forEach(content -> ((Project)content).getOwnedModelRoots().stream().filter(SystemEngineering.class::isInstance).forEach(modelRoot -> ((SystemEngineering)modelRoot).getOwnedArchitectures().stream().filter(PhysicalArchitecture.class::isInstance).forEach(physicalArchitecture -> physicalComponentPkg.add(((PhysicalArchitecture)physicalArchitecture).getOwnedPhysicalComponentPkg())))));
        return physicalComponentPkg;
    }
}

