/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.rules.cs;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.ctx.ActorPkg;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.information.Partition;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.la.LogicalActorPkg;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.la.LogicalComponentPkg;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.data.pa.PhysicalActorPkg;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentPkg;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.transition.common.handlers.contextscope.ContextScopeHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.contextscope.IContextScopeHandler;
import org.polarsys.capella.core.transition.common.handlers.options.OptionsHandlerHelper;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class ComponentRule
extends org.polarsys.capella.core.transition.system.rules.cs.ComponentRule {
    protected void retrieveComponentGoDeep(EObject source_p, List<EObject> result_p, IContext context_p) {
        Component element = (Component)source_p;
        super.retrieveComponentGoDeep(source_p, result_p, context_p);
        result_p.addAll((Collection<EObject>)element.getRepresentingPartitions());
        result_p.addAll((Collection<EObject>)element.getFunctionalAllocations());
        result_p.addAll((Collection<EObject>)element.getUsedInterfaceLinks());
        result_p.addAll((Collection<EObject>)element.getImplementedInterfaceLinks());
        IContextScopeHandler handler = ContextScopeHandlerHelper.getInstance((IContext)context_p);
        if (handler.contains("S_S", (EObject)element, context_p)) {
            String value = OptionsHandlerHelper.getInstance((IContext)context_p).getStringValue(context_p, "capella.core.transition.system2subsystem", "stateModesExport", "hierarchyReference");
            if ("onlyReference".equals(value)) {
                result_p.addAll((Collection<EObject>)element.getOwnedStateMachines());
                handler.addAll("S_S", (Collection)element.getOwnedStateMachines(), context_p);
            } else if ("hierarchyReference".equals(value)) {
                result_p.addAll((Collection<EObject>)element.getOwnedStateMachines());
                handler.addAll("S_S", (Collection)element.getOwnedStateMachines(), context_p);
                for (Component ancestor : this.getComponentAncestors(element)) {
                    result_p.addAll((Collection<EObject>)ancestor.getOwnedStateMachines());
                    handler.addAll("S_S", (Collection)ancestor.getOwnedStateMachines(), context_p);
                }
            }
            if (OptionsHandlerHelper.getInstance((IContext)context_p).getBooleanValue(context_p, "capella.core.transition.system2subsystem", "scenarioExport", false)) {
                result_p.addAll(EObjectExt.getReferencers((EObject)element, (EReference)InteractionPackage.Literals.INSTANCE_ROLE__REPRESENTED_INSTANCE));
            }
        }
    }

    protected EStructuralFeature getTargetContainementFeature(EObject element_p, EObject result_p, EObject container_p, IContext context_p) {
        if (container_p instanceof SystemAnalysis) {
            return CtxPackage.Literals.SYSTEM_ANALYSIS__OWNED_SYSTEM;
        }
        if (container_p instanceof LogicalArchitecture) {
            return LaPackage.Literals.LOGICAL_ARCHITECTURE__OWNED_LOGICAL_COMPONENT;
        }
        if (container_p instanceof PhysicalArchitecture) {
            return PaPackage.Literals.PHYSICAL_ARCHITECTURE__OWNED_PHYSICAL_COMPONENT;
        }
        if (container_p instanceof ActorPkg) {
            return CtxPackage.Literals.ACTOR_PKG__OWNED_ACTORS;
        }
        if (container_p instanceof LogicalActorPkg) {
            return LaPackage.Literals.LOGICAL_ACTOR_PKG__OWNED_LOGICAL_ACTORS;
        }
        if (container_p instanceof PhysicalActorPkg) {
            return PaPackage.Literals.PHYSICAL_ACTOR_PKG__OWNED_PHYSICAL_ACTORS;
        }
        if (container_p instanceof LogicalComponent) {
            return LaPackage.Literals.LOGICAL_COMPONENT__OWNED_LOGICAL_COMPONENTS;
        }
        if (container_p instanceof PhysicalComponent) {
            return PaPackage.Literals.PHYSICAL_COMPONENT__OWNED_PHYSICAL_COMPONENTS;
        }
        if (container_p instanceof LogicalComponentPkg) {
            return LaPackage.Literals.LOGICAL_COMPONENT_PKG__OWNED_LOGICAL_COMPONENTS;
        }
        if (container_p instanceof PhysicalComponentPkg) {
            return PaPackage.Literals.PHYSICAL_COMPONENT_PKG__OWNED_COMPONENTS;
        }
        return super.getTargetContainementFeature(element_p, result_p, container_p, context_p);
    }

    private Collection<Component> getComponentAncestors(Component component_p) {
        HashSet<Component> result = new HashSet<Component>();
        for (Partition partition : component_p.getRepresentingPartitions()) {
            if (!(partition instanceof Part)) continue;
            for (Part componentAncestor : ComponentExt.getPartAncestors((Part)((Part)partition))) {
                if (componentAncestor.getAbstractType() == null || !(componentAncestor.getAbstractType() instanceof Component)) continue;
                result.add((Component)componentAncestor.getAbstractType());
            }
        }
        return result;
    }
}

