/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.multiphases.activities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.InterfacePkg;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.epbs.EpbsPackage;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.InformationPackage;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentNature;
import org.polarsys.capella.core.transition.common.handlers.traceability.CompoundTraceabilityHandler;
import org.polarsys.capella.core.transition.common.handlers.traceability.config.ITraceabilityConfiguration;
import org.polarsys.capella.transition.system2subsystem.multiphases.MultiphasesContext;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class MultiphaseTraceabilityHandler
extends CompoundTraceabilityHandler {
    public MultiphaseTraceabilityHandler(ITraceabilityConfiguration configuration_p) {
        super(configuration_p);
    }

    public Collection<EObject> retrieveTracedElements(EObject source_p, IContext context_p) {
        MultiphasesContext context = (MultiphasesContext)context_p;
        if (source_p == null) {
            return Collections.emptyList();
        }
        if (context.getMapping() == MultiphasesContext.Mapping.SA && context.getSelectedPhysicalComponents().contains(source_p)) {
            return Collections.singleton(context.getTempRootComponent());
        }
        if (context.getMapping() == MultiphasesContext.Mapping.LA && source_p instanceof PhysicalComponent && ((PhysicalComponent)source_p).getNature() == PhysicalComponentNature.NODE) {
            EObject tmp = source_p;
            while (tmp instanceof PhysicalComponent) {
                if (context.getSelectedPhysicalComponents().contains(tmp)) {
                    return Collections.singleton(context.getTempRootComponent());
                }
                tmp = tmp.eContainer();
            }
        }
        if (this.isRootComponent(source_p)) {
            BlockArchitecture ba = ((MultiphasesContext)context_p).getTempBlockArchitecture();
            if (ba instanceof SystemAnalysis) {
                return Collections.singleton(((SystemAnalysis)ba).getOwnedSystem());
            }
            if (ba instanceof LogicalArchitecture) {
                return Collections.singleton(((LogicalArchitecture)ba).getOwnedLogicalComponent());
            }
            if (ba instanceof PhysicalArchitecture) {
                return Collections.singleton(((PhysicalArchitecture)ba).getOwnedPhysicalComponent());
            }
        }
        EObject dpkg = EcoreUtil2.getFirstContainer((EObject)source_p, (EClass)InformationPackage.Literals.DATA_PKG);
        EObject ipkg = EcoreUtil2.getFirstContainer((EObject)source_p, (EClass)CsPackage.Literals.INTERFACE_PKG);
        if (ipkg != null || dpkg != null || source_p instanceof DataPkg || source_p instanceof InterfacePkg) {
            return super.retrieveTracedElements(source_p, context_p);
        }
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (EObject e : super.retrieveTracedElements(source_p, context_p)) {
            if (e instanceof BlockArchitecture && e == ((MultiphasesContext)context_p).getTempBlockArchitecture()) {
                result.add(e);
                continue;
            }
            BlockArchitecture be = (BlockArchitecture)EcoreUtil2.getFirstContainer((EObject)e, (EClass)CsPackage.Literals.BLOCK_ARCHITECTURE);
            if (be != null && be.eClass() != ((MultiphasesContext)context_p).getMapping().getBlockArchitectureClass()) continue;
            result.add(e);
        }
        return result;
    }

    public void attachTraceability(EObject sourceElement_p, EObject targetElement_p, IContext context_p) {
        AbstractType type;
        if (targetElement_p instanceof BlockArchitecture) {
            return;
        }
        if (targetElement_p instanceof Part && (type = ((Part)targetElement_p).getAbstractType()) != null && this.isRootComponent((EObject)type)) {
            return;
        }
        if (this.isRootComponent(targetElement_p)) {
            return;
        }
        super.attachTraceability(sourceElement_p, targetElement_p, context_p);
    }

    private boolean isRootComponent(EObject element_p) {
        EStructuralFeature feature = element_p.eContainingFeature();
        return feature == CtxPackage.Literals.SYSTEM_ANALYSIS__OWNED_SYSTEM || feature == LaPackage.Literals.LOGICAL_ARCHITECTURE__OWNED_LOGICAL_COMPONENT || feature == PaPackage.Literals.PHYSICAL_ARCHITECTURE__OWNED_PHYSICAL_COMPONENT || feature == EpbsPackage.Literals.EPBS_ARCHITECTURE__OWNED_CONFIGURATION_ITEM;
    }
}

