/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.handlers.attachment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvement;
import org.polarsys.capella.core.model.helpers.graph.InvolvementHierarchyGraph;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class GraphHelper {
    public static <T> Collection<LinkedList<T>> getPathsTowards(T fci, Function<T, Boolean> isTheOne, IContext context_p, Function<T, Collection<T>> getNexts) {
        LinkedList<T> path = new LinkedList<T>();
        path.add(fci);
        return GraphHelper.getPathsTowards(fci, isTheOne, context_p, path, getNexts);
    }

    protected static <T> Collection<LinkedList<T>> getPathsTowards(T fci, Function<T, Boolean> isTheOne, IContext context_p, LinkedList<T> path, Function<T, Collection<T>> getNexts) {
        ArrayList<LinkedList<T>> result = new ArrayList<LinkedList<T>>();
        for (T next : getNexts.apply(fci)) {
            if (path.contains(next)) {
                path.clear();
                continue;
            }
            if (isTheOne.apply(next).booleanValue()) {
                path.add(next);
                result.add(path);
                continue;
            }
            LinkedList<T> newPath = new LinkedList<T>();
            newPath.addAll(path);
            newPath.add(next);
            result.addAll(GraphHelper.getPathsTowards(next, isTheOne, context_p, newPath, getNexts));
        }
        return result;
    }

    public static FunctionalChainInvolvement getInvolvment(InvolvementHierarchyGraph.Element e) {
        if (e instanceof InvolvementHierarchyGraph.Edge) {
            return ((InvolvementHierarchyGraph.Edge)e).getLink();
        }
        return ((InvolvementHierarchyGraph.Vertex)e).getFunction();
    }

    public static Collection<InvolvementHierarchyGraph.Element> getPrevious(InvolvementHierarchyGraph.Element e) {
        if (e instanceof InvolvementHierarchyGraph.Edge) {
            return Arrays.asList(((InvolvementHierarchyGraph.Edge)e).getSource());
        }
        return ((InvolvementHierarchyGraph.Vertex)e).getIncomingEdges();
    }

    public static Collection<InvolvementHierarchyGraph.Element> getNexts(InvolvementHierarchyGraph.Element e) {
        if (e instanceof InvolvementHierarchyGraph.Edge) {
            return Arrays.asList(((InvolvementHierarchyGraph.Edge)e).getTarget());
        }
        return ((InvolvementHierarchyGraph.Vertex)e).getOutgoingEdges();
    }

    public static Collection<InvolvementHierarchyGraph.Vertex> getVertices(InvolvementHierarchyGraph graph, FunctionalChainInvolvement fci) {
        return graph.getVertices().keySet().stream().filter(v -> v.getFunction() == fci).map(v -> (InvolvementHierarchyGraph.Vertex)graph.getVertices().get(v)).collect(Collectors.toList());
    }
}

