/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.tests.mixed;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.commands.Command;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.PopupMenuExtender;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.NavigatorActionService;
import org.polarsys.capella.core.data.capellacore.InvolvedElement;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentNature;
import org.polarsys.capella.core.data.pa.PhysicalFunction;
import org.polarsys.capella.core.data.pa.PhysicalFunctionPkg;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.core.platform.sirius.ui.navigator.view.CapellaCommonNavigator;
import org.polarsys.capella.test.framework.api.BasicTestCase;

public class TransitionMenuTest
extends BasicTestCase {
    protected final String CAPELLA_PERSPECTIVE_ID = "capella.sirius.perspective";
    protected final String TRANSITION_MENU_ID = "capella.core.transition.system2subsystem";
    protected final String VERTICAL_TRANSITION_MENU_ID = "capella.core.transition.system2subsystem.vertical";
    protected final String MULTIPHASES_TRANSITION_COMMAND_ID = "org.polarsys.capella.transition.system2subsystem.multiphases.ui";
    protected final String CROSSPHASES_TRANSITION_COMMAND_ID = "org.polarsys.capella.transition.system2subsystem.crossphases.ui";
    protected final String INTERPHASES_TRANSITION_COMMAND_ID = "org.polarsys.capella.transition.system2subsystem.interphases.ui";
    protected NavigatorActionService _actionService;

    public List<String> getRequiredTestModels() {
        return Arrays.asList("Project_test_01");
    }

    public void test() throws Exception {
        StructuredSelection navigatorSelection1 = null;
        StructuredSelection navigatorSelection2 = null;
        StructuredSelection navigatorSelection3 = null;
        try {
            CapellaModel model = this.getTestModel(this.getRequiredTestModels().get(0));
            Session session = this.getSession(this.getRequiredTestModels().get(0));
            Project project = model.getProject(session.getTransactionalEditingDomain());
            SystemEngineering eng = (SystemEngineering)project.getOwnedModelRoots().get(5);
            PhysicalArchitecture physicalArchitecturePkg = (PhysicalArchitecture)eng.getContainedPhysicalArchitectures().get(0);
            PhysicalFunctionPkg physicalFunctionsPkg = (PhysicalFunctionPkg)physicalArchitecturePkg.getOwnedFunctionPkg();
            PhysicalFunction rootFunction = (PhysicalFunction)physicalFunctionsPkg.getOwnedPhysicalFunctions().get(0);
            PhysicalComponent systemComponent = (PhysicalComponent)physicalArchitecturePkg.getSystem();
            Optional<PhysicalComponent> aNodeComponent = null;
            Optional<PhysicalComponent> aBehaviourComponent = null;
            aBehaviourComponent = systemComponent.getOwnedPhysicalComponents().stream().filter(t -> t.getNature() == PhysicalComponentNature.BEHAVIOR).findFirst();
            aNodeComponent = systemComponent.getOwnedPhysicalComponents().stream().filter(t -> t.getNature() == PhysicalComponentNature.NODE).findFirst();
            if (!aBehaviourComponent.isPresent() || !aNodeComponent.isPresent()) {
                TransitionMenuTest.fail((String)"Couldn't find model elements");
            }
            navigatorSelection1 = new StructuredSelection(Arrays.asList((InvolvedElement)aNodeComponent.get(), (InvolvedElement)aBehaviourComponent.get(), rootFunction));
            navigatorSelection2 = new StructuredSelection(Arrays.asList(rootFunction, (InvolvedElement)aNodeComponent.get(), (InvolvedElement)aBehaviourComponent.get()));
            navigatorSelection3 = new StructuredSelection(Arrays.asList((InvolvedElement)aBehaviourComponent.get(), rootFunction, (InvolvedElement)aNodeComponent.get()));
        }
        catch (Exception e) {
            TransitionMenuTest.fail((String)"Couldn't find model elements");
        }
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            TransitionMenuTest.fail((String)"No Active workbench window");
        }
        try {
            this.closeIntro();
        }
        catch (Exception E) {
            TransitionMenuTest.fail((String)"Could not close intro page");
        }
        try {
            PlatformUI.getWorkbench().showPerspective("capella.sirius.perspective", activeWorkbenchWindow);
        }
        catch (Exception e) {
            TransitionMenuTest.fail((String)"Could not open Capella perspective");
        }
        this.ensureCommandExists("org.polarsys.capella.transition.system2subsystem.multiphases.ui");
        this.ensureCommandExists("org.polarsys.capella.transition.system2subsystem.interphases.ui");
        this.ensureCommandExists("org.polarsys.capella.transition.system2subsystem.crossphases.ui");
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        this.ensureCommandIsHandled(commandService, "org.polarsys.capella.transition.system2subsystem.multiphases.ui");
        this.ensureCommandIsHandled(commandService, "org.polarsys.capella.transition.system2subsystem.interphases.ui");
        this.ensureCommandIsHandled(commandService, "org.polarsys.capella.transition.system2subsystem.crossphases.ui");
        this.testTransitionMenus((IStructuredSelection)navigatorSelection1);
        this.testTransitionMenus((IStructuredSelection)navigatorSelection2);
        this.testTransitionMenus((IStructuredSelection)navigatorSelection3);
    }

    protected CommonViewer getViewer() {
        CommonViewer[] viewer = new CommonViewer[1];
        IViewPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("capella.project.explorer");
        viewer[0] = ((CapellaCommonNavigator)part).getCommonViewer();
        return viewer[0];
    }

    protected void closeIntro() {
        IIntroPart introPart = PlatformUI.getWorkbench().getIntroManager().getIntro();
        PlatformUI.getWorkbench().getIntroManager().closeIntro(introPart);
    }

    protected void testTransitionMenus(IStructuredSelection selection) {
        CommonViewer viewer = this.getViewer();
        CapellaCommonNavigator navigator = (CapellaCommonNavigator)viewer.getCommonNavigator();
        navigator.selectReveal((ISelection)selection);
        viewer.setSelection((ISelection)selection);
        MenuManager menuMgr = new MenuManager();
        navigator.getNavigatorActionService().fillContextMenu((IMenuManager)menuMgr);
        PopupMenuExtender extender = new PopupMenuExtender("capella.project.explorer#PopupMenu", menuMgr, (ISelectionProvider)viewer, (IWorkbenchPart)navigator, ((PartSite)navigator.getSite()).getContext());
        Menu contextMenu = menuMgr.createContextMenu(viewer.getControl());
        contextMenu.notifyListeners(22, null);
        IContributionItem item = null;
        IContributionItem[] iContributionItemArray = menuMgr.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem contribution = iContributionItemArray[n2];
            if ("capella.core.transition.system2subsystem".equals(contribution.getId())) {
                item = contribution;
                break;
            }
            ++n2;
        }
        if (item == null) {
            TransitionMenuTest.fail((String)"Couldn't find transition menu in contextual menu");
        }
        MenuManager transitionMenu = (MenuManager)item;
        IContributionItem interphaseMenu = null;
        IContributionItem verticalTransitionMenu = null;
        IContributionItem[] iContributionItemArray2 = transitionMenu.getItems();
        int n3 = iContributionItemArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            IContributionItem contribution = iContributionItemArray2[n4];
            if ("org.polarsys.capella.transition.system2subsystem.interphases.ui".equals(contribution.getId())) {
                interphaseMenu = contribution;
            } else if ("capella.core.transition.system2subsystem.vertical".equals(contribution.getId())) {
                verticalTransitionMenu = contribution;
                break;
            }
            ++n4;
        }
        if (interphaseMenu == null) {
            TransitionMenuTest.fail((String)"Couldn't find interphase transition menu in contextual menu");
        }
        if (verticalTransitionMenu == null) {
            TransitionMenuTest.fail((String)"Couldn't find vertical transition menu in contextual menu");
        }
        IContributionItem crossPhaseTransition = null;
        IContributionItem multiphaseTransition = null;
        IContributionItem[] iContributionItemArray3 = ((MenuManager)verticalTransitionMenu).getItems();
        int n5 = iContributionItemArray3.length;
        int n6 = 0;
        while (n6 < n5) {
            IContributionItem contribution = iContributionItemArray3[n6];
            if ("org.polarsys.capella.transition.system2subsystem.multiphases.ui".equals(contribution.getId())) {
                multiphaseTransition = contribution;
            } else if ("org.polarsys.capella.transition.system2subsystem.crossphases.ui".equals(contribution.getId())) {
                crossPhaseTransition = contribution;
            }
            ++n6;
        }
        if (multiphaseTransition == null) {
            TransitionMenuTest.fail((String)"Couldn't find multiphase transition menu in contextual menu");
        }
        if (crossPhaseTransition == null) {
            TransitionMenuTest.fail((String)"Couldn't find crossphase transition menu in contextual menu");
        }
    }

    protected void ensureCommandExists(String commandId) {
        IConfigurationElement[] config;
        IConfigurationElement extension = null;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ui.commands");
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String id = element.getAttribute("id");
            if (id != null && id.equals(commandId)) {
                extension = element;
                break;
            }
            ++n2;
        }
        if (extension == null) {
            TransitionMenuTest.fail((String)("Couldn't find command " + commandId));
        }
    }

    protected void ensureCommandIsHandled(ICommandService commandService, String commandId) {
        Command command = commandService.getCommand(commandId);
        if (command == null) {
            TransitionMenuTest.fail((String)("Couldn't get command " + commandId + " from service"));
        }
    }
}

