/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.ui.preferences;

import java.util.Optional;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.polarsys.capella.common.flexibility.wizards.schema.IPropertyRenderer;
import org.polarsys.capella.common.flexibility.wizards.schema.IRendererContext;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.transition.common.context.TransitionContext;
import org.polarsys.capella.core.transition.system.ui.dialog.ProjectSelectionDialog;
import org.polarsys.capella.core.transition.system.ui.preferences.OutputModelRenderer;

public class FilteredOutputModelRenderer
extends OutputModelRenderer {
    protected void proceedBrowse(Shell shell, IRendererContext context) {
        String targetCapellaProject = this.getTargetProject(shell, context);
        if (targetCapellaProject != null) {
            this.changeValue(context.getProperty((IPropertyRenderer)this), context, targetCapellaProject);
            this.updatedValue(context.getProperty((IPropertyRenderer)this), context, targetCapellaProject);
        }
    }

    protected String getTargetProject(Shell shell, IRendererContext context) {
        ProjectSelectionDialog dialog = new ProjectSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
        if (context.getPropertyContext().getSource() instanceof TransitionContext) {
            TransitionContext transitionContext = (TransitionContext)context.getPropertyContext().getSource();
            Resource sourceModelResource = (Resource)transitionContext.get((Object)"_T_S_Res");
            dialog.addFilter((ViewerFilter)new NoSourceProjectViewerFilter(sourceModelResource));
        }
        dialog.open();
        Object obj = dialog.getFirstResult();
        if (obj instanceof String) {
            return (String)obj;
        }
        return null;
    }

    class NoSourceProjectViewerFilter
    extends ViewerFilter {
        private Optional<IProject> toFilterCapellaProject;

        public NoSourceProjectViewerFilter(Resource toFilterCapellaProject) {
            this.toFilterCapellaProject = Optional.ofNullable(EcoreUtil2.getFile((Resource)toFilterCapellaProject)).map(f -> f.getProject());
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return element instanceof IResource && (!this.toFilterCapellaProject.isPresent() || !this.toFilterCapellaProject.get().equals(element));
        }
    }
}

