/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.preferences;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.flexibility.properties.property.PropertyPreference;
import org.polarsys.capella.common.flexibility.properties.schema.IProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IPropertyContext;
import org.polarsys.capella.common.flexibility.properties.schema.IRestraintProperty;
import org.polarsys.capella.common.flexibility.properties.schema.PropertiesSchemaConstants;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.core.data.capellacore.AbstractPropertyValue;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.capellacore.PropertyValueGroup;
import org.polarsys.capella.core.data.capellacore.PropertyValuePkg;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.transition.common.handlers.session.SessionHandlerHelper;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class PropertyValuesPreference
extends PropertyPreference
implements IRestraintProperty {
    public static final String PROPERTIES_ELEMENTS = "PROPERTIES_ELEMENTS";

    public Object getType() {
        return Collection.class;
    }

    public Collection<EObject> getElements(IContext context) {
        HashSet elements = (HashSet)context.get((Object)"propertyValuesExport");
        if (elements == null) {
            elements = new HashSet();
            context.put((Object)"propertyValuesExport", elements);
        }
        return elements;
    }

    public Object getValue(IPropertyContext context_p) {
        Object source = context_p.getSource();
        if (source instanceof IContext) {
            String value;
            IContext context = (IContext)source;
            if (this.getElements(context).size() == 0 && (value = (String)super.getValue(context_p)) != null && value.length() > 0) {
                String[] ids;
                ArrayList<EObject> result = new ArrayList<EObject>();
                String[] stringArray = ids = value.split("\n");
                int n = ids.length;
                int n2 = 0;
                while (n2 < n) {
                    EObject relatedObject;
                    String id = stringArray[n2];
                    if (id != null && id.length() > 0 && (relatedObject = SessionHandlerHelper.getInstance((IContext)context).getEObjectFromId(id, context)) != null) {
                        result.add(relatedObject);
                    }
                    ++n2;
                }
                this.getElements(context).addAll(result);
            }
            return this.getElements(context);
        }
        return Collections.emptyList();
    }

    public Object toType(Object value_p, IPropertyContext context_p) {
        return value_p;
    }

    public IStatus validate(Object newValue_p, IPropertyContext context_p) {
        if (newValue_p == null) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    public void setValue(IPropertyContext context_p) {
        Object source = context_p.getSource();
        if (source instanceof IContext) {
            IContext context = (IContext)source;
            Object value = context_p.getCurrentValue((IProperty)this);
            if (value instanceof Collection) {
                Object result = "";
                for (Object item : (Collection)value) {
                    if (item == null || !(item instanceof EObject)) continue;
                    result = (String)result + SessionHandlerHelper.getInstance((IContext)context).getId((EObject)item, context) + "\n";
                }
                IEclipsePreferences preference = this.getScope().getNode(this.getParameter(PropertiesSchemaConstants.PropertiesSchema_PROPERTY_PREFERENCE__SCOPE));
                if (result != null) {
                    preference.put(this.getId(), (String)result);
                }
                this.getElements(context).addAll((Collection)value);
            }
        }
    }

    public Collection<Object> getChoiceValues(IPropertyContext context_p) {
        Object source = context_p.getSource();
        ArrayList<Object> values = new ArrayList<Object>();
        if (source instanceof IContext) {
            IContext context = (IContext)source;
            Collection selection = (Collection)context.get((Object)"TRANSITION_SOURCES");
            BlockArchitecture archi = null;
            if (selection.size() > 0) {
                archi = BlockArchitectureExt.getRootBlockArchitecture((EObject)((EObject)selection.iterator().next()));
            }
            if (archi != null && archi.eContainer() instanceof SystemEngineering) {
                if (archi.eContainer().eContainer() instanceof Project) {
                    this.visit(values, archi.eContainer().eContainer());
                }
                int lowestLevelArchi = selection.stream().map(BlockArchitectureExt::getRootBlockArchitecture).map(BlockArchitectureExt::getBlockArchitectureType).map(Enum::ordinal).max((elem1, elem2) -> elem1.compareTo((Integer)elem2)).orElse(0);
                for (EObject child : ((SystemEngineering)archi.eContainer()).eContents()) {
                    if (!(child instanceof AbstractPropertyValue) && !(child instanceof PropertyValueGroup) && !(child instanceof PropertyValuePkg) && (!(child instanceof BlockArchitecture) || !this.isArchitectureAtOrAboveElement(child, lowestLevelArchi))) continue;
                    this.visit(values, child);
                }
            }
        }
        return values;
    }

    private boolean isArchitectureAtOrAboveElement(EObject architecture, int elementArchitectureLevel) {
        return BlockArchitectureExt.getBlockArchitectureType((BlockArchitecture)((BlockArchitecture)architecture)).ordinal() <= elementArchitectureLevel;
    }

    private void visit(ArrayList<EObject> values_p, EObject archi_p) {
        if (archi_p instanceof AbstractPropertyValue || archi_p instanceof PropertyValueGroup || archi_p instanceof PropertyValuePkg) {
            values_p.add(archi_p);
        }
        if (archi_p instanceof PropertyValuePkg) {
            values_p.addAll(EObjectExt.getAll((EObject)archi_p, (EClass)CapellacorePackage.Literals.PROPERTY_VALUE_PKG));
            return;
        }
        if (archi_p instanceof Project) {
            archi_p.eContents().stream().forEach(elem -> {
                if (elem instanceof AbstractPropertyValue || elem instanceof PropertyValueGroup || elem instanceof PropertyValuePkg) {
                    values_p.add((EObject)elem);
                }
                if (elem instanceof PropertyValuePkg) {
                    values_p.addAll(EObjectExt.getAll((EObject)elem, (EClass)CapellacorePackage.Literals.PROPERTY_VALUE_PKG));
                }
            });
            return;
        }
        TreeIterator childs = archi_p.eAllContents();
        while (childs.hasNext()) {
            EObject child = (EObject)childs.next();
            if (child instanceof AbstractPropertyValue || child instanceof PropertyValueGroup || child instanceof PropertyValuePkg) {
                values_p.add(child);
            }
            if (!(child instanceof PropertyValuePkg)) continue;
            values_p.addAll(EObjectExt.getAll((EObject)child, (EClass)CapellacorePackage.Literals.PROPERTY_VALUE_PKG));
            childs.prune();
        }
    }

    public boolean isMany() {
        return true;
    }
}

