/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.gen.business.core.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egf.model.domain.EMFDomain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.kitalpha.doc.gen.business.core.util.LabelProviderHelper;

public class DocGenHtmlUtil {
    private static final String UNKNOWN_ELEMENT = "unknown";

    public static String getModelName(EMFDomain domain) {
        EList content = domain.getContent();
        if (!content.isEmpty() && content.get(0) instanceof EObject) {
            return DocGenHtmlUtil.getModelName((EObject)content.get(0));
        }
        return "";
    }

    public static String getModelName(EObject element) {
        if (element.eContainer() == null) {
            return LabelProviderHelper.getText(element);
        }
        return DocGenHtmlUtil.getModelName(element.eContainer());
    }

    public static String getValidFileName(String fileName) {
        if (fileName == null || fileName.trim().length() == 0) {
            return UNKNOWN_ELEMENT;
        }
        fileName = fileName.replaceAll("[^a-zA-Z 0-9 _]", "");
        return fileName;
    }

    public static IFile getFile(String fileName, String projectName, String outputFolder) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        Path path = new Path("");
        String[] stringArray = outputFolder.split("/|\\\\");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String member = stringArray[n2];
            IFolder folder = project.getFolder((IPath)(path = path.append(member)));
            if (!folder.exists()) {
                folder.create(true, true, null);
            }
            ++n2;
        }
        path = path.append(fileName);
        path = path.addFileExtension("html");
        return project.getFile((IPath)path);
    }

    public static void writeFilePatternContent(String fileName, String projectName, String outputFolder, String content) {
        ByteArrayInputStream outputContent = new ByteArrayInputStream(content.getBytes());
        try {
            IFile file = DocGenHtmlUtil.getFile(fileName, projectName, outputFolder);
            if (file.exists()) {
                file.setContents((InputStream)outputContent, true, false, null);
            } else {
                file.create((InputStream)outputContent, true, null);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static String readFileContent(String fileName, String projectName, String outputFolder) throws IOException {
        try {
            IFile file = DocGenHtmlUtil.getFile(fileName, projectName, outputFolder);
            if (file.exists()) {
                int n;
                StringWriter writer = new StringWriter();
                char[] buffer = new char[1024];
                BufferedReader reader = new BufferedReader(new InputStreamReader(file.getContents()));
                while ((n = reader.read(buffer)) != -1) {
                    ((Writer)writer).write(buffer, 0, n);
                }
                return ((Object)writer).toString();
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return new String();
    }

    public static String readSidebarFileContent(String projectName, String outputFolder) {
        try {
            return DocGenHtmlUtil.readFileContent("sidebar", projectName, outputFolder);
        }
        catch (IOException e) {
            e.printStackTrace();
            return new String();
        }
    }

    public static String displayValidString(String value) {
        if (value == null) {
            return "";
        }
        return value;
    }
}

